/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.library;

import java.net.URL;
import java.nio.file.Path;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.javatools.exports.message.Scope;

public class LibraryScope
extends Scope {
    private final URL file;
    private final String name;

    public LibraryScope(Scope scope, String description, URL file, String name) {
        super(scope, description);
        this.file = file;
        this.name = name;
    }

    public LibraryScope(Scope scope, URL file, String name) {
        super(scope, null);
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        this.file = file;
        this.name = name;
    }

    public LibraryScope(Scope scope, ExportLibrary library) {
        super(scope, null);
        if (library == null) {
            throw new NullPointerException("library == null");
        }
        this.file = library.getOrigin();
        this.name = library.getName();
    }

    @Override
    public String toString(Path basePath) {
        StringBuilder builder = new StringBuilder();
        if (this.file != null) {
            builder.append(Paths.relativize(this.file, basePath));
            if (this.name != null) {
                builder.append('[').append(this.name).append(']');
            }
        } else if (this.name != null) {
            builder.append(this.name);
        }
        return builder.toString();
    }
}

