/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class AtomicBufferedFileOutputStream
extends BufferedOutputStream {
    private final Path path;
    private final Path workPath;
    private final BufferedOutputStream writer;
    private final boolean existed;
    private boolean comparing;
    private boolean compared;
    private BufferedInputStream reader;
    private final ByteArraySequence singleByte = new ByteArraySequence(new byte[1]);
    private final ByteArraySequence multipleBytes = new ByteArraySequence(null);

    public static AtomicBufferedFileOutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return AtomicBufferedFileOutputStream.newOutputStream(path, false, options);
    }

    public static AtomicBufferedFileOutputStream newOutputStream(Path path, boolean compareContent, OpenOption ... options) throws IOException {
        Path workPath = Files.createTempFile(path.getParent(), path.getFileName().toString(), ".tmp", new FileAttribute[0]);
        BufferedOutputStream stream = new BufferedOutputStream(Files.newOutputStream(workPath, options));
        return new AtomicBufferedFileOutputStream(path, workPath, stream, compareContent);
    }

    private AtomicBufferedFileOutputStream(Path path, Path workPath, BufferedOutputStream stream, boolean comparing) throws IOException {
        super(stream);
        this.path = path;
        this.workPath = workPath;
        this.writer = stream;
        this.existed = Files.exists(path, new LinkOption[0]);
        if (comparing && this.existed) {
            this.reader = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            this.comparing = comparing;
        } else {
            this.reader = null;
            this.comparing = false;
        }
    }

    private void compare(ByteSequence sequence, int offset, int length) throws IOException {
        try {
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                if (sequence.byteAt(i) == this.reader.read()) continue;
                this.comparing = false;
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.reader = null;
                return;
            }
        }
        catch (IOException e) {
            this.comparing = false;
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
    }

    public Path getPath() {
        return this.path;
    }

    public synchronized boolean comparedEqualAtClose() {
        return this.compared;
    }

    @Override
    public synchronized void close() throws IOException {
        this.writer.close();
        if (this.comparing) {
            try {
                if (this.reader.read() == -1) {
                    Files.delete(this.workPath);
                    this.compared = true;
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (IOException e) {}
            }
            this.reader = null;
        }
        if (this.existed) {
            Path backupPath = Files.createTempFile(this.path.getParent(), this.path.getFileName().toString(), ".bak", new FileAttribute[0]);
            Files.move(this.path, backupPath, StandardCopyOption.ATOMIC_MOVE);
            try {
                Files.move(this.workPath, this.path, StandardCopyOption.ATOMIC_MOVE);
                try {
                    Files.delete(backupPath);
                }
                catch (IOException iOException) {
                }
            }
            catch (IOException e) {
                Files.move(backupPath, this.path, StandardCopyOption.ATOMIC_MOVE);
            }
        } else {
            Files.move(this.workPath, this.path, StandardCopyOption.ATOMIC_MOVE);
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public synchronized void write(int c) throws IOException {
        if (this.comparing) {
            ((ByteArraySequence)this.singleByte).array[0] = (byte)c;
            this.compare(this.singleByte, 0, 1);
        }
        this.writer.write(c);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public synchronized void write(byte[] bytes, int offset, int length) throws IOException {
        if (this.comparing) {
            ByteArraySequence.access$002(this.multipleBytes, bytes);
            this.compare(this.multipleBytes, offset, length);
        }
        this.writer.write(bytes, offset, length);
    }

    private final class ByteArraySubSequence
    implements ByteSequence {
        private final byte[] array;
        private final int offset;
        private final int length;

        public ByteArraySubSequence(byte[] array, int start, int end) {
            if (start < 0) {
                throw new IndexOutOfBoundsException("start negative");
            }
            if (end < 0) {
                throw new IndexOutOfBoundsException("end negative");
            }
            if (start > end) {
                throw new IndexOutOfBoundsException("start (" + start + ") > end (" + end + ")");
            }
            this.array = array;
            this.offset = start;
            this.length = end - start;
        }

        @Override
        public byte byteAt(int index) {
            if (index >= this.length) {
                throw new IndexOutOfBoundsException("index (" + index + ") >= length (" + this.length + ")");
            }
            return this.array[this.offset + index];
        }

        @Override
        public int length() {
            return this.length;
        }

        public ByteSequence subSequence(int start, int end) {
            if (end > this.length) {
                throw new IndexOutOfBoundsException("end (" + end + ") > length (" + this.length + ")");
            }
            return new ByteArraySubSequence(this.array, this.offset + start, this.offset + end);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (int i = this.offset; i < Math.min(this.length, this.offset + 16); ++i) {
                builder.append(Integer.toHexString(this.array[i])).append(' ');
            }
            return builder.toString();
        }
    }

    private class ByteArraySequence
    implements ByteSequence {
        private byte[] array;

        ByteArraySequence(byte[] array) {
            this.array = array;
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public byte byteAt(int index) {
            return this.array[index];
        }

        public ByteSequence subSequence(int start, int end) {
            if (end > this.array.length) {
                throw new IndexOutOfBoundsException("end (" + end + ") > length (" + this.array.length + ")");
            }
            return new ByteArraySubSequence(this.array, start, end);
        }

        static /* synthetic */ byte[] access$002(ByteArraySequence x0, byte[] x1) {
            x0.array = x1;
            return x1;
        }
    }

    private static interface ByteSequence {
        public byte byteAt(int var1);

        public int length();
    }
}

