/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.command;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Manifest;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.classpath.BaselineComparison;
import oracle.javatools.exports.classpath.BaselineReaderWriter;
import oracle.javatools.exports.classpath.ClassPathModel;
import oracle.javatools.exports.classpath.ClassPathRoot;
import oracle.javatools.exports.classpath.FileAccessPolicy;
import oracle.javatools.exports.classpath.FileTree;
import oracle.javatools.exports.classpath.Member;
import oracle.javatools.exports.classpath.NestedFileSystemPool;
import oracle.javatools.exports.classpath.Package;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.command.ClassesSource;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.command.CommandInput;
import oracle.javatools.exports.command.CommandOutput;
import oracle.javatools.exports.comment.RemediationCommentsWriter;
import oracle.javatools.exports.common.Iterables;
import oracle.javatools.exports.common.StringPool;
import oracle.javatools.exports.data.DataFiles;
import oracle.javatools.exports.extension.Extension;
import oracle.javatools.exports.file.KnownFile;
import oracle.javatools.exports.file.NullBufferedWriter;
import oracle.javatools.exports.file.PathKey;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.installation.Installation;
import oracle.javatools.exports.installation.Macros;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.javatools.exports.library.ExportLibraryReader;
import oracle.javatools.exports.library.ExportLibraryWriter;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.exports.library.LibraryScope;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.LogWriter;
import oracle.javatools.exports.message.Message;
import oracle.javatools.exports.message.Scope;
import oracle.javatools.exports.message.Severity;
import oracle.javatools.exports.message.Tag;
import oracle.javatools.exports.name.ElementName;
import oracle.javatools.exports.name.NameFormat;
import oracle.javatools.exports.name.NameSpace;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.report.CompositeIssueProperty;
import oracle.javatools.exports.report.FacadeIssueProperty;
import oracle.javatools.exports.report.IssueProperty;
import oracle.javatools.exports.report.IssuesReport;
import oracle.javatools.exports.specification.ExportDomain;
import oracle.javatools.exports.specification.ExportLinkage;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import oracle.javatools.exports.specification.ExportSpecificationWriter;
import oracle.javatools.exports.specification.Merge;
import oracle.javatools.exports.specification.SpecificationScope;
import oracle.javatools.exports.uses.DiscreteUsesHandler;
import oracle.javatools.exports.uses.DiscreteUsesWriter;
import oracle.javatools.exports.uses.PackageUses;
import oracle.javatools.exports.uses.TypeUses;
import oracle.javatools.exports.uses.UsesModel;
import oracle.javatools.exports.uses.UsesReaderWriter;
import oracle.javatools.exports.uses.UsesSupplier;
import org.xml.sax.SAXException;

public class Command {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(CommandInput commandInput, CommandOutput commandOutput) throws CommandException {
        int exitStatus;
        long commandStart = System.currentTimeMillis();
        Log log = Log.newLog(commandInput.isTraces() || commandInput.hasOutput(CommandInput.OutputType.TRACES), new Tag[0]);
        Command.writeCodeSource(commandOutput, log);
        NameSpace nameSpace = new NameSpace();
        NestedFileSystemPool nestedFileSystemPool = new NestedFileSystemPool();
        try {
            switch (commandInput.getCommandType()) {
                case GENERATE: 
                case ANALYZE: 
                case MERGE: 
                case CAPTURE: {
                    ClassPathModel model = Command.createClassPathModelFromClasses(commandInput, commandOutput, nameSpace, nestedFileSystemPool, log);
                    UsesSupplier recentUses = new UsesSupplier(commandInput.getUsesAggregate(), DataFiles.RECENTLY_USED_MESSAGES, model, log);
                    Command.writeReports(commandInput, commandOutput, model, recentUses, log);
                    if (commandInput.getCompareTo() != null && commandInput.hasOutput(CommandInput.OutputType.BASELINE)) {
                        ClassPathModel referenceModel = BaselineReaderWriter.read(commandInput.getCompareTo(), commandInput.getMiddlewareHome(), model.getBootRoots(), model.getNameSpace(), nestedFileSystemPool, model.getCommentPool(), log);
                        exitStatus = Command.compareModels(referenceModel, model, commandInput, commandOutput, recentUses, log);
                        break;
                    }
                    exitStatus = 0;
                    break;
                }
                case COMPARE: {
                    StringPool commentPool = StringPool.synchronizedPool();
                    List<ClassPathRoot> bootRoots = Command.createBootClassPathRoots(commandInput, nameSpace, nestedFileSystemPool, log);
                    ClassPathModel referenceModel = BaselineReaderWriter.read(commandInput.getBaseline0(), commandInput.getMiddlewareHome(), bootRoots, nameSpace, nestedFileSystemPool, commentPool, log);
                    ClassPathModel revisedModel = BaselineReaderWriter.read(commandInput.getBaseline1(), commandInput.getMiddlewareHome(), bootRoots, nameSpace, nestedFileSystemPool, commentPool, log);
                    UsesSupplier recentUses = new UsesSupplier(commandInput.getUsesAggregate(), DataFiles.RECENTLY_USED_MESSAGES, referenceModel, log);
                    exitStatus = Command.compareModels(referenceModel, revisedModel, commandInput, commandOutput, recentUses, log);
                    break;
                }
                case CONVERT: {
                    int filesSize;
                    Command.configureScope(commandInput, commandOutput, new HashMap<Path, FileTree>(), nameSpace, new Macros(commandInput.getMiddlewareHome(), log), log);
                    Path toSignature = commandInput.getToSignature();
                    Path toExport = commandInput.getToExport();
                    Path toCsv = commandInput.getToCsv();
                    final NameFormat nameFormat = commandInput.getApiFormat();
                    List<Path> files = commandInput.getFiles();
                    int n = filesSize = files == null ? 0 : files.size();
                    if (filesSize == 1 && !files.get(0).getFileName().toString().endsWith(".xml")) {
                        UsesModel uses = new UsesModel();
                        for (Path path : files) {
                            UsesReaderWriter.readUses(uses, path, nameSpace, false, log);
                        }
                        if (toExport != null) {
                            ExportSpecification specification = uses.createExportSpecification(new Scope(commandOutput.propertyDescription("toExport")), commandInput.getOwner(), commandInput.getConsumers(), commandInput.getAccess());
                            try {
                                new ExportSpecificationWriter().write(specification, toExport);
                            }
                            catch (IOException e) {
                                throw new CommandException(e, "Uses export specification %s not created: %s", toExport, e);
                            }
                            commandOutput.note("Uses export specification written to %s", toExport);
                        }
                        if (toSignature != null) {
                            try {
                                UsesReaderWriter.writeSignatureFile(uses, nameFormat, toSignature);
                            }
                            catch (IOException e) {
                                throw new CommandException(e, "Uses signatures list %s not created: %s", toSignature, e);
                            }
                            commandOutput.note("Uses signatures list written to %s", toSignature);
                        }
                    } else {
                        IssueProperty[] propertiesExcludeIfEmpty;
                        Set<String> rules = commandInput.getRules();
                        String pathPrefixPattern = commandInput.isRemoveAdeViewRoot() ? "^/ade/[A-Za-z0-9_-]+/" : null;
                        IssuesReport report = new IssuesReport(rules, pathPrefixPattern);
                        report.addIssueHandler(new DiscreteUsesHandler());
                        List<String> propertyNames = new ArrayList<String>(commandInput.getProperties());
                        if (propertyNames.isEmpty()) {
                            propertyNames = Arrays.asList("WORKSPACE", "PROJECT", "FILE", "LINE", "RULE", "MESSAGE");
                        }
                        IssueProperty[] properties = new IssueProperty[propertyNames.size()];
                        int count = 0;
                        for (int i = 0; i < propertyNames.size(); ++i) {
                            Object compositedNames;
                            boolean composited;
                            String name = (String)propertyNames.get(i);
                            int left = name.indexOf(91);
                            if (left == 0) {
                                throw new CommandException("%s value \"%s\" not valid, expected property name before '['", commandOutput.propertyDescription("properties"), name);
                            }
                            boolean bl = composited = left > 0;
                            if (composited) {
                                String remainder = name.substring(left + 1);
                                name = name.substring(0, left);
                                compositedNames = new ArrayList();
                                while (true) {
                                    if (remainder.charAt(remainder.length() - 1) == ']') {
                                        compositedNames.add(remainder.substring(0, remainder.length() - 1));
                                    } else {
                                        compositedNames.add(remainder);
                                        if (++i < propertyNames.size()) {
                                            remainder = propertyNames.get(i);
                                            continue;
                                        }
                                    }
                                    break;
                                }
                            } else {
                                compositedNames = Collections.singletonList(name);
                            }
                            IssueProperty[] compositedProperties = new IssueProperty[compositedNames.size()];
                            for (int c = 0; c < compositedProperties.length; ++c) {
                                String composedName = (String)compositedNames.get(c);
                                FacadeIssueProperty<ElementName> property = report.getProperty(composedName);
                                if (property == null) {
                                    throw new CommandException("%s value \"%s\" not valid, %s", commandOutput.propertyDescription("properties"), name, Command.list(report.getPropertyNames(), true, "no names supported", "use: ", "and/or"));
                                }
                                if (property == DiscreteUsesHandler.API) {
                                    property = new FacadeIssueProperty<ElementName>(DiscreteUsesHandler.API){

                                        @Override
                                        public String toString(ElementName value) {
                                            return value.getQualifiedName(nameFormat);
                                        }
                                    };
                                }
                                compositedProperties[c] = property;
                            }
                            properties[count++] = composited ? new CompositeIssueProperty(name, compositedProperties) : compositedProperties[0];
                        }
                        if (count < properties.length) {
                            IssueProperty[] issuePropertyArray = properties;
                            properties = new IssueProperty[count];
                            System.arraycopy(issuePropertyArray, 0, properties, 0, count);
                        }
                        if ((propertiesExcludeIfEmpty = new IssueProperty[commandInput.getExcludeEmpty().size()]).length > 0) {
                            int index = 0;
                            block40: for (String name : commandInput.getExcludeEmpty()) {
                                for (IssueProperty property : properties) {
                                    if (!name.equalsIgnoreCase(property.getName())) continue;
                                    propertiesExcludeIfEmpty[index++] = property;
                                    continue block40;
                                }
                                throw new CommandException("%s value \"%s\" not valid, %s", commandOutput.propertyDescription("excludeempty"), name, Command.list(propertyNames, true, "no names eligible", "eligible names: ", "and/or"));
                            }
                        }
                        Path left = commandInput.getLeft();
                        Path right = commandInput.getRight();
                        assert (left == null == (right == null));
                        if (left == null) {
                            if (filesSize == 0) {
                                throw new CommandException("%s or %s and %s required", commandOutput.propertyDescription("files"), commandOutput.propertyDescription("left"), commandOutput.propertyDescription("right"));
                            }
                            for (Path path : files) {
                                try {
                                    report.read(path);
                                }
                                catch (SAXException e) {
                                    throw new CommandException(e, "Audit report %s not read: %s", path, e);
                                }
                            }
                            if (toCsv != null) {
                                try {
                                    DiscreteUsesWriter.writeCSV(report, toCsv, commandInput.isHeader(), commandInput.getDelimiter(), properties, propertiesExcludeIfEmpty);
                                    commandOutput.note("Uses CSV list written to %s", toCsv);
                                }
                                catch (IOException e) {
                                    throw new CommandException(e, "Uses CSV list %s not created: %s", toCsv, e);
                                }
                            }
                            if (toSignature != null) {
                                try {
                                    DiscreteUsesWriter.writeSignatures(report, nameFormat, toSignature, commandInput.getSource());
                                }
                                catch (IOException e) {
                                    throw new CommandException(e, "Uses signatures %s not created: %s", toSignature, e);
                                }
                                commandOutput.note("Uses signature list written to %s", toSignature);
                            }
                        } else {
                            ArrayList<IssuesReport.Difference> differences;
                            if (toCsv == null) {
                                throw new CommandException("%s and %s requires %s", commandOutput.propertyDescription("left"), commandOutput.propertyDescription("right"), commandOutput.propertyDescription("tocsv"));
                            }
                            if (filesSize == 0) {
                                IssuesReport leftReport = new IssuesReport(report);
                                IssuesReport rightReport = new IssuesReport(report);
                                try {
                                    leftReport.read(left);
                                }
                                catch (SAXException e) {
                                    throw new CommandException(e, "Audit report %s not read: %s", left, e);
                                }
                                try {
                                    rightReport.read(right);
                                }
                                catch (SAXException e) {
                                    throw new CommandException(e, "Audit report %s not read: %s", right, e);
                                }
                                differences = IssuesReport.compare(leftReport, rightReport, properties);
                            } else {
                                Path root = files.get(0).startsWith(left) ? left : right;
                                TreeSet<Path> relativePaths = new TreeSet<Path>();
                                differences = new ArrayList();
                                for (Path path : files) {
                                    if (!path.startsWith(root)) {
                                        throw new CommandException("uses-not-relative", "Path %s not relative to root %s", path, root);
                                    }
                                    Path relativePath = root.relativize(path);
                                    relativePaths.add(relativePath);
                                }
                                for (Path path : relativePaths) {
                                    IssuesReport leftReport = new IssuesReport(report);
                                    IssuesReport rightReport = new IssuesReport(report);
                                    try {
                                        leftReport.read(left.resolve(path));
                                    }
                                    catch (SAXException e) {
                                        throw new CommandException(e, "Audit report %s not read: %s", left.resolve(path), e);
                                    }
                                    try {
                                        rightReport.read(right.resolve(path));
                                    }
                                    catch (SAXException e) {
                                        throw new CommandException(e, "Audit report %s not read: %s", right.resolve(path), e);
                                    }
                                    differences.addAll(IssuesReport.compare(leftReport, rightReport, new IssueProperty[0]));
                                }
                            }
                            try {
                                DiscreteUsesWriter.writeDifferences(differences, toCsv, commandInput.isHeader(), commandInput.getDelimiter(), properties);
                                commandOutput.note("Uses differences CSV list written to %s", toCsv);
                            }
                            catch (IOException e) {
                                commandOutput.note("Uses differences CSV list written to %s", toCsv);
                            }
                        }
                    }
                    exitStatus = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected state " + (Object)((Object)commandInput.getCommandType()));
                }
            }
            long totalProcessingTime = System.currentTimeMillis() - commandStart;
            log.note("command-time-total", "total processing time: %dms", totalProcessingTime);
            log.trace("command-time-total", "total processing time: %dms", totalProcessingTime);
        }
        finally {
            Command.writeLogs(commandInput, commandOutput, log);
        }
        long totalTime = System.currentTimeMillis() - commandStart;
        switch (commandInput.getCommandType()) {
            case GENERATE: {
                commandOutput.note("%s created in %dms", commandInput.getOutputPath(CommandInput.OutputType.EXPORTS), totalTime);
                break;
            }
            case ANALYZE: {
                commandOutput.note("Analysis completed in %dms", totalTime);
                break;
            }
            case MERGE: {
                if (commandInput.getCompareTo() != null) {
                    commandOutput.note("Merge, capture, and comparison completed in %dms: %s", totalTime, Command.comparisonSummary(exitStatus));
                    break;
                }
                commandOutput.note("Merge completed in %dms", totalTime);
                break;
            }
            case CAPTURE: {
                if (commandInput.getCompareTo() != null) {
                    commandOutput.note("Merge, capture, and comparison completed in %dms: %s", totalTime, Command.comparisonSummary(exitStatus));
                    break;
                }
                commandOutput.note("Merge and capture completed in %dms", totalTime);
                break;
            }
            case COMPARE: {
                commandOutput.note("Comparison completed in %dms: %s", totalTime, Command.comparisonSummary(exitStatus));
                break;
            }
            case CONVERT: {
                commandOutput.note("Conversion completed in %dms", totalTime);
                break;
            }
            default: {
                commandOutput.note("Processing completed in %dms", totalTime);
            }
        }
        return exitStatus;
    }

    private static String comparisonSummary(int errorCount) {
        switch (errorCount) {
            case 0: {
                return "no comparison errors";
            }
            case 1: {
                return "1 comparison error";
            }
        }
        return errorCount + " comparison errors";
    }

    protected static void writeLogs(CommandInput commandInput, CommandOutput commandOutput, Log log) throws CommandException {
        if (commandInput.hasOutput(CommandInput.OutputType.ISSUES)) {
            int n;
            Iterator<Object> i;
            List<String> excludedIds = Arrays.asList("-model-member-deprecated", "-model-misplaced-types", "-model-type-deprecated", "-model-type-misplaced", "-type-exported-not-members", "-uses-missing-*");
            EnumSet<Severity> includedSeverities = EnumSet.range(Severity.ERROR, commandInput.isClasses() ? Severity.NOTE : Severity.WARNING);
            StringBuilder description = new StringBuilder();
            EnumSet<Severity> excludedSeverities = EnumSet.complementOf(includedSeverities);
            if (!excludedSeverities.isEmpty()) {
                description.append("issues with ");
                description.append("severit");
                switch (excludedSeverities.size()) {
                    case 1: {
                        description.append("y ").append(excludedSeverities.iterator().next());
                        break;
                    }
                    case 2: {
                        i = excludedSeverities.iterator();
                        description.append("ies ").append(i.next()).append(" and ").append(i.next());
                        break;
                    }
                    default: {
                        i = excludedSeverities.iterator();
                        description.append("ies ");
                        for (n = 0; n < excludedSeverities.size() - 1; ++n) {
                            description.append(i.next()).append(", ");
                        }
                        description.append("and ").append(i.next());
                    }
                }
            }
            if (!excludedIds.isEmpty()) {
                description.append(description.length() == 0 ? "issues with " : " or ");
                switch (excludedIds.size()) {
                    case 1: {
                        description.append("with id ").append(excludedIds.iterator().next().substring(1));
                        break;
                    }
                    case 2: {
                        i = excludedIds.iterator();
                        description.append("the following ids: ").append(((String)i.next()).substring(1)).append(" and ").append(((String)i.next()).substring(1));
                        break;
                    }
                    default: {
                        i = excludedIds.iterator();
                        description.append("the following ids: ");
                        for (n = 0; n < excludedIds.size() - 1; ++n) {
                            description.append(((String)i.next()).substring(1)).append(", ");
                        }
                        description.append("and ").append(((String)i.next()).substring(1));
                    }
                }
            }
            LogWriter logWriter = new LogWriter(commandInput.getMiddlewareHome());
            logWriter.setIds(excludedIds);
            logWriter.setAttributes(EnumSet.of(LogWriter.SCOPE, LogWriter.SEVERITY, LogWriter.MESSAGE));
            logWriter.setSeverities(includedSeverities);
            Command.createDirectory(commandInput.getOutputPath(CommandInput.OutputType.ISSUES));
            if (description.length() > 0) {
                logWriter.write(log, commandInput.getOutputPath(CommandInput.OutputType.ISSUES), new Message(Severity.NOTE, "log-exclusions", "Excludes " + description, new Object[0]));
                commandOutput.note("Issues log (%s) written to %s (excluding %s)", commandOutput.propertyDescription(CommandInput.OutputType.ISSUES), commandInput.getOutputPath(CommandInput.OutputType.ISSUES), description);
            } else {
                logWriter.write(log, commandInput.getOutputPath(CommandInput.OutputType.ISSUES), new Message[0]);
                commandOutput.note("Issues log (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.ISSUES), commandInput.getOutputPath(CommandInput.OutputType.ISSUES));
            }
        }
        if (commandInput.hasOutput(CommandInput.OutputType.TRACES)) {
            log.trace("command-completed", "%s completed", new Object[]{commandInput.getCommandType()});
            LogWriter logWriter = new LogWriter(commandInput.getMiddlewareHome());
            logWriter.setIds(Collections.emptyList());
            logWriter.setAttributes(EnumSet.of(LogWriter.TIME, LogWriter.ID, LogWriter.MESSAGE));
            logWriter.setSeverities(EnumSet.of(Severity.TRACE));
            Command.createDirectory(commandInput.getOutputPath(CommandInput.OutputType.EXPORTS));
            logWriter.write(log, commandInput.getOutputPath(CommandInput.OutputType.TRACES), new Message[0]);
            commandOutput.note("Traces log (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.TRACES), commandInput.getOutputPath(CommandInput.OutputType.TRACES));
        }
    }

    private static ClassPathModel createClassPathModelFromClasses(CommandInput commandInput, CommandOutput commandOutput, NameSpace nameSpace, NestedFileSystemPool nestedFileSystemPool, Log log) throws CommandException {
        HashMap<Path, FileTree> fileTrees = new HashMap<Path, FileTree>();
        StringPool commentPool = StringPool.synchronizedPool();
        Macros macros = new Macros(commandInput.getMiddlewareHome(), log);
        ExportDomain domain = Command.configureScope(commandInput, commandOutput, fileTrees, nameSpace, macros, log);
        List<ClassPathRoot> bootRoots = Command.createBootClassPathRoots(commandInput, nameSpace, nestedFileSystemPool, log);
        boolean validating = commandInput.isValidating();
        commandOutput.note("Schema validation %s", validating ? "enabled" : "disabled");
        ExportSpecificationReader specificationReader = new ExportSpecificationReader(nameSpace, domain, validating, !validating);
        Installation installation = new Installation(commandInput.getMiddlewareHome(), specificationReader, commentPool, log);
        LinkedHashMap<PathKey, ClassPathRoot> roots = new LinkedHashMap<PathKey, ClassPathRoot>();
        LinkedHashMap<FileExportLibrary, Map<ClassPathEntry, ClassPathRoot>> libraries = new LinkedHashMap<FileExportLibrary, Map<ClassPathEntry, ClassPathRoot>>();
        switch (commandInput.getCommandType()) {
            case GENERATE: {
                for (Path path : commandInput.getClassPath()) {
                    ClassPathRoot classPathRoot = new ClassPathRoot(new Scope(commandOutput.propertyDescription("classpath")), path, fileTrees, ClassPathRoot.annotationAccessPolicy(commandInput.getOwner(), domain), nameSpace, nestedFileSystemPool, log);
                    if (!classPathRoot.exists()) {
                        if (commandInput.isFailOnClassPathError()) {
                            throw new CommandException("%s entry %s not found", commandOutput.propertyDescription("classpath"), path);
                        }
                        commandOutput.warning("%s entry %s not found", commandOutput.propertyDescription("classpath"), path);
                    }
                    roots.putIfAbsent(classPathRoot.getReferencePath(), classPathRoot);
                }
                break;
            }
            case ANALYZE: 
            case MERGE: 
            case CAPTURE: {
                Command.createRootsFromSources(new Scope(commandOutput.propertyDescription("libraries")), domain, installation, commandInput.getLibraries(), true, libraries, roots, fileTrees, nameSpace, nestedFileSystemPool, commandOutput, log);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected state " + (Object)((Object)commandInput.getCommandType()));
            }
        }
        commandOutput.note("Found %d librar%s", libraries.size(), libraries.size() != 1 ? "ies" : "y");
        for (ClassPathRoot root : bootRoots) {
            roots.putIfAbsent(root.getReferencePath(), root);
        }
        Command.createRootsFromSources(new Scope(commandOutput.propertyDescription("dependencies")), domain, installation, commandInput.getDependencies(), false, null, roots, fileTrees, nameSpace, nestedFileSystemPool, commandOutput, log);
        TreeSet<ClassPathModel.LibraryDescription> libraryDescriptions = new TreeSet<ClassPathModel.LibraryDescription>();
        for (ExportLibrary exportLibrary : libraries.keySet()) {
            libraryDescriptions.add(new ClassPathModel.LibraryDescription(exportLibrary, commandInput.getMiddlewareHome(), installation.getAliases(exportLibrary.getName())));
        }
        return new ClassPathModel(commandInput.getSource(), domain, libraryDescriptions, roots, new TraversalMonitor(commandOutput, log), nameSpace, nestedFileSystemPool, commentPool, log);
    }

    private static List<ClassPathRoot> createBootClassPathRoots(CommandInput commandInput, NameSpace nameSpace, NestedFileSystemPool nestedFileSystemPool, Log log) throws CommandException {
        Path jmods;
        Path javaHome;
        Scope commandScope = new Scope("boot class path");
        List<Path> bootClassPath = commandInput.getBootClassPath();
        if (bootClassPath.isEmpty()) {
            bootClassPath = ClassPathRoot.getDefaultBootClassPath();
        } else if (bootClassPath.size() == 1 && Files.isDirectory(javaHome = bootClassPath.get(0), new LinkOption[0]) && Files.isDirectory(jmods = javaHome.resolve("jmods"), new LinkOption[0])) {
            bootClassPath = new ArrayList<Path>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(jmods);){
                for (Path path : stream) {
                    bootClassPath.add(path);
                }
            }
            catch (IOException e) {
                throw new CommandException(e, "Boot class path unspecified and jmods directory %s not read: %s", jmods, e);
            }
            bootClassPath.sort(null);
        }
        ArrayList<ClassPathRoot> bootRoots = new ArrayList<ClassPathRoot>(bootClassPath.size());
        for (Path path : bootClassPath) {
            bootRoots.add(new ClassPathRoot(commandScope, path, null, null, nameSpace, nestedFileSystemPool, log));
        }
        return bootRoots;
    }

    private static void writeReports(CommandInput commandInput, CommandOutput commandOutput, ClassPathModel model, UsesSupplier recentUses, Log log) throws CommandException {
        Path path;
        Map<String, String> remediationComments;
        ExportDomain domain = model.getDomain();
        SortedSet<ClassPathModel.LibraryDescription> libraries = model.getLibraries();
        if (commandInput.hasOutput(CommandInput.OutputType.COMMENTS)) {
            switch (commandInput.getCommandType()) {
                case GENERATE: {
                    remediationComments = Command.collectRemediationComments(model);
                    break;
                }
                default: {
                    remediationComments = Command.collectRemediationComments(libraries, log);
                    break;
                }
            }
        } else {
            remediationComments = null;
        }
        if (commandInput.getDirectory() != null) {
            commandOutput.note("Default output directory is %s", commandInput.getDirectory());
        }
        if (commandInput.hasOutput(CommandInput.OutputType.EXPORTS)) {
            String owner = commandInput.getOwner();
            if (owner == null && commandInput.isOfficial()) {
                owner = "all";
                commandOutput.note("Setting owner to \"%s\" for FA merge", owner);
            }
            log.note("exports-domain", "domain for export specification: %s", domain).scope("");
            ExportSpecification specification = model.createExportSpecification(new SpecificationScope("created exports"), owner, commandInput.getSource(), commandInput.getConsumers(), domain, CompatibilityAccess.RESTRICTED);
            Command.createDirectory(commandInput.getOutputPath(CommandInput.OutputType.EXPORTS));
            Path path2 = commandInput.getOutputPath(CommandInput.OutputType.EXPORTS);
            try {
                new ExportSpecificationWriter().write(specification, path2);
            }
            catch (IOException e) {
                throw new CommandException(e, "Export specification %s not created: %s", path2, e);
            }
            commandOutput.note("Export specification (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.EXPORTS), path2);
        }
        if (commandInput.hasOutput(CommandInput.OutputType.COMMENTS)) {
            Command.createDirectory(commandInput.getOutputPath(CommandInput.OutputType.COMMENTS));
            path = commandInput.getOutputPath(CommandInput.OutputType.COMMENTS);
            try {
                RemediationCommentsWriter writer = new RemediationCommentsWriter();
                writer.setSorted(true);
                writer.setCommentType(RemediationCommentsWriter.Type.ATTRIBUTE);
                writer.write(remediationComments, path);
            }
            catch (IOException e) {
                throw new CommandException("Comments file %s not created: %s", path, e);
            }
            commandOutput.note("Remediation comments (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.COMMENTS), commandInput.getOutputPath(CommandInput.OutputType.COMMENTS));
        }
        if (commandInput.hasOutput(CommandInput.OutputType.LIBRARY)) {
            Command.createDirectory(commandInput.getOutputPath(CommandInput.OutputType.LIBRARY));
            Command.writeLibraryFile(model, commandInput.getLibraryName(), commandInput.getLibraryId(), commandInput.getLibraryDescription(), commandInput.getOutputPath(CommandInput.OutputType.EXPORTS), Collections.emptyList(), commandInput.getOutputPath(CommandInput.OutputType.LIBRARY));
            commandOutput.note("Library (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.LIBRARY), commandInput.getOutputPath(CommandInput.OutputType.LIBRARY));
        }
        if (commandInput.hasOutput(CommandInput.OutputType.EXPORTED)) {
            Command.createDirectory(commandInput.getOutputPath(CommandInput.OutputType.EXPORTED));
            Command.writeSignatureFile(model, CompatibilityAccess.EXPORTED, commandInput.getOutputPath(CommandInput.OutputType.EXPORTED));
            commandOutput.note("Exported signatures list (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.EXPORTED), commandInput.getOutputPath(CommandInput.OutputType.EXPORTED));
        }
        if (commandInput.hasOutput(CommandInput.OutputType.RESTRICTED)) {
            Command.createDirectory(commandInput.getOutputPath(CommandInput.OutputType.RESTRICTED));
            Command.writeSignatureFile(model, CompatibilityAccess.RESTRICTED, commandInput.getOutputPath(CommandInput.OutputType.RESTRICTED));
            commandOutput.note("Restricted signatures list (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.RESTRICTED), commandInput.getOutputPath(CommandInput.OutputType.RESTRICTED));
        }
        if (commandInput.hasOutput(CommandInput.OutputType.CONCEALED)) {
            Command.createDirectory(commandInput.getOutputPath(CommandInput.OutputType.CONCEALED));
            Command.writeSignatureFile(model, CompatibilityAccess.CONCEALED, commandInput.getOutputPath(CommandInput.OutputType.CONCEALED));
            commandOutput.note("Concealed signatures list (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.CONCEALED), commandInput.getOutputPath(CommandInput.OutputType.CONCEALED));
        }
        if (commandInput.hasOutput(CommandInput.OutputType.PROBLEMS)) {
            Command.createDirectory(commandInput.getOutputPath(CommandInput.OutputType.PROBLEMS));
            Command.writeProblemTypesFile(model, commandInput.getOutputPath(CommandInput.OutputType.PROBLEMS), commandInput.getMiddlewareHome());
            commandOutput.note("Problem types list (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.PROBLEMS), commandInput.getOutputPath(CommandInput.OutputType.PROBLEMS));
        }
        if (commandInput.hasOutput(CommandInput.OutputType.PACKAGES)) {
            path = commandInput.getOutputPath(CommandInput.OutputType.PACKAGES);
            Command.createDirectory(path);
            Command.writePackagesFile(model, recentUses.get(), path, commandInput.getMiddlewareHome());
            commandOutput.note("Packages spreadsheet (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.PACKAGES), path);
        }
        if (commandInput.hasOutput(CommandInput.OutputType.TYPES)) {
            Command.createDirectory(commandInput.getOutputPath(CommandInput.OutputType.TYPES));
            Command.writeTypesFile(model, recentUses.get(), commandInput.getOutputPath(CommandInput.OutputType.TYPES), commandInput.getMiddlewareHome());
            commandOutput.note("Types spreadsheet (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.TYPES), commandInput.getOutputPath(CommandInput.OutputType.TYPES));
        }
        if (commandInput.hasOutput(CommandInput.OutputType.RECENT_EXPORTED, CommandInput.OutputType.RECENT_COMMENTED, CommandInput.OutputType.RECENT_CONCEALED, CommandInput.OutputType.RECENT_UNCOMMENTED, CommandInput.OutputType.RECENT_MIGRATED, CommandInput.OutputType.RECENT_MISSING)) {
            Command.writeUsedFiles(commandInput, domain, model, recentUses.get(), remediationComments, log, CommandInput.OutputType.RECENT_EXPORTED, CommandInput.OutputType.RECENT_COMMENTED, CommandInput.OutputType.RECENT_CONCEALED, CommandInput.OutputType.RECENT_UNCOMMENTED, CommandInput.OutputType.RECENT_MIGRATED, CommandInput.OutputType.RECENT_MISSING);
        }
        if (commandInput.hasOutput(CommandInput.OutputType.BASELINE)) {
            Command.createDirectory(commandInput.getOutputPath(CommandInput.OutputType.BASELINE));
            new BaselineReaderWriter().write(model, domain, commandInput.getMiddlewareHome(), commandInput.getOutputPath(CommandInput.OutputType.BASELINE));
            commandOutput.note("Baseline file (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.BASELINE), commandInput.getOutputPath(CommandInput.OutputType.BASELINE));
        }
        model.logStatistics();
        if (commandInput.hasOutput(CommandInput.OutputType.LIBRARIES)) {
            Command.createDirectory(commandInput.getOutputPath(CommandInput.OutputType.LIBRARIES));
            Command.writeLibrariesFile(model.getLibraries(), commandInput.getMiddlewareHome(), commandInput.getOutputPath(CommandInput.OutputType.LIBRARIES));
            commandOutput.note("Libraries list (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.LIBRARIES), commandInput.getOutputPath(CommandInput.OutputType.LIBRARIES));
        }
    }

    private static String writeCodeSource(CommandOutput commandOutput, Log log) {
        String codeSource;
        try {
            URL root = Command.class.getProtectionDomain().getCodeSource().getLocation();
            if (URLFileSystem.isRegularFile(root)) {
                Manifest manifest = new Manifest(Command.class.getResourceAsStream("/META-INF/MANIFEST.MF"));
                String label = manifest.getMainAttributes().getValue("Oracle-Label");
                codeSource = String.format("javatools-exports code source is file %s, version %s (%s)", URLFileSystem.getFileName(root), label, URLFileSystem.getPlatformPathName(root));
                commandOutput.note(codeSource, new Object[0]);
                log.note("command-code-source", codeSource, new Object[0]);
            } else if (URLFileSystem.isDirectory(root)) {
                Manifest manifest = new Manifest(URLFileSystem.openInputStream(URLFactory.newURL(URLFileSystem.getParent(root), "MANIFEST.MF")));
                String label = manifest.getMainAttributes().getValue("Oracle-Label");
                codeSource = String.format("javatools-exports code source is directory %s, version %s (%s)", URLFileSystem.getFileName(root), label, URLFileSystem.getPlatformPathName(root));
                commandOutput.note(codeSource, new Object[0]);
                log.note("command-code-source", codeSource, new Object[0]);
            } else if (root != null) {
                codeSource = String.format("javatools-exports code source not recognized (%s)", URLFileSystem.getPlatformPathName(root));
                commandOutput.warning(codeSource, new Object[0]);
                log.warning("command-code-source", codeSource, new Object[0]);
            } else {
                codeSource = "javatools-exports code source not determined";
                commandOutput.warning(codeSource, new Object[0]);
                log.warning("command-code-source", codeSource, new Object[0]);
            }
        }
        catch (IOException e) {
            codeSource = String.format("javatools-exports code source not determined: %s", e);
            commandOutput.warning(codeSource, new Object[0]);
            log.warning("command-code-source", codeSource, new Object[0]);
        }
        return codeSource;
    }

    private static ExportDomain configureScope(CommandInput commandInput, CommandOutput commandOutput, Map<Path, FileTree> fileTrees, NameSpace nameSpace, Macros macros, Log log) throws CommandException {
        String message;
        ExportDomain domain;
        if (commandInput.getDomain() == CommandInput.FMW_DOMAIN) {
            ExportSpecificationReader reader = new ExportSpecificationReader();
            reader.setSchemaValidating(true);
            reader.setDomainValidating(true);
            try {
                KnownFile resource = DataFiles.FMW_DOMAIN;
                URL url = resource.getUrl();
                String name = URLFileSystem.getPlatformPathName(url);
                String message2 = String.format("Setting domain to official FMW domain (fmw-domain.xml from javatools-exports.jar): %s", name);
                commandOutput.note(message2, new Object[0]);
                log.note("command-domain-set", message2, new Object[0]);
                domain = reader.read(new SpecificationScope(commandOutput.propertyDescription("domain")), url, resource.getStream(), log).getDomain();
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new CommandException(e, "Domain %s not read: %s", commandInput.getDomain(), e);
            }
        } else if (commandInput.getDomain() != null) {
            message = String.format("Setting domain to %s", commandInput.getDomain());
            commandOutput.note(message, new Object[0]);
            log.note("command-domain-set", message, new Object[0]);
            ExportSpecificationReader reader = new ExportSpecificationReader();
            reader.setSchemaValidating(true);
            reader.setDomainValidating(true);
            try {
                domain = reader.read((Scope)new SpecificationScope(commandOutput.propertyDescription("domain")), commandInput.getDomain(), log).getDomain();
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new CommandException(e, "Domain %s not read: %s", commandInput.getDomain(), e);
            }
        } else {
            message = "Setting domain to the universal domain";
            commandOutput.note(message, new Object[0]);
            log.note("command-domain-set", message, new Object[0]);
            domain = new ExportDomain(new String[0]);
        }
        if (!commandInput.getScope().isEmpty() || !commandInput.getPackages().isEmpty()) {
            HashSet<PackageName> packages = new HashSet<PackageName>();
            if (!commandInput.getPackages().isEmpty()) {
                for (String name : commandInput.getPackages()) {
                    packages.add(nameSpace.packageNameSource(name));
                }
            }
            domain = Command.collectScopePackages(commandInput.getScope(), domain, fileTrees, nameSpace, macros, packages, commandOutput, log);
            if (!packages.isEmpty()) {
                String message3 = String.format("Modifying domain by intersection with %d specified package%s", packages.size(), packages.size() != 1 ? "s" : "");
                commandOutput.note(message3, new Object[0]);
                log.note("command-domain-packages", message3, new Object[0]);
                ExportDomain spanningDomain = new ExportDomain(new String[0]);
                for (PackageName name : packages) {
                    ExportDomain.Subdomain subdomain = domain.getSubdomain(name);
                    if (subdomain == null) continue;
                    spanningDomain.addSubdomain(subdomain);
                }
                domain = spanningDomain;
            }
        }
        return domain;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static ExportDomain collectScopePackages(List<Path> paths, ExportDomain domain, Map<Path, FileTree> fileTrees, NameSpace nameSpace, Macros macros, Set<PackageName> packages, CommandOutput commandOutput, Log log) throws CommandException {
        block48: for (Path path : paths) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                try {
                    tree = new FileTree(path, nameSpace);
                    packages.addAll(tree.getPackageNames());
                    fileTrees.put(path, tree);
                }
                catch (IOException e) {
                    log.warning("directory-not-read", "scope directory %s not read: %s", new Object[]{path, e}).scope(path);
                }
                continue;
            }
            var11_11 = Paths.getSuffix(path);
            var12_13 = -1;
            switch (var11_11.hashCode()) {
                case 1489193: {
                    if (!var11_11.equals(".xml")) break;
                    var12_13 = 0;
                    break;
                }
                case 1481438: {
                    if (!var11_11.equals(".pkg")) break;
                    var12_13 = 1;
                    break;
                }
                case -1268894515: {
                    if (!var11_11.equals(".library")) break;
                    var12_13 = 2;
                    break;
                }
                case 1475373: {
                    if (!var11_11.equals(".jar")) break;
                    var12_13 = 3;
                    break;
                }
                case 1490995: {
                    if (!var11_11.equals(".zip")) break;
                    var12_13 = 4;
                    break;
                }
                case 1477544: {
                    if (!var11_11.equals(".lis")) break;
                    var12_13 = 5;
                }
            }
            switch (var12_13) {
                case 0: {
                    message = String.format("Modifying domain by intersection with %s", new Object[]{Paths.toString(path)});
                    commandOutput.note(message, new Object[0]);
                    log.note("command-domain-intersection", message, new Object[0]);
                    reader = new ExportSpecificationReader();
                    reader.setSchemaValidating(true);
                    reader.setDomainValidating(true);
                    try {
                        domain = ExportDomain.intersection(domain, reader.read(new Scope(commandOutput.propertyDescription("scope")), path, log).getDomain());
                        break;
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        throw new CommandException(e, "scope domain %s not read: %s", new Object[]{path, e});
                    }
                }
                case 1: {
                    try {
                        for (Object name : Files.readAllLines(path)) {
                            if ((name = name.trim()).isEmpty()) continue;
                            packages.add(nameSpace.packageNameSource((String)name));
                        }
                        continue block48;
                    }
                    catch (IOException e) {
                        log.warning("scope-not-read", "scope package list %s not read: %s", new Object[]{path, e}).scope(path);
                        break;
                    }
                }
                case 2: {
                    try {
                        library = new ExportLibraryReader().read(path, macros.getMacros(), log);
                        name = library.getExpandedClassPathEntries().iterator();
                        while (name.hasNext()) {
                            entry = (ClassPathEntry)name.next();
                            entryPath = Paths.getAsDefaultPath(entry.getUrl());
                            if (entryPath == null) {
                                log.error("scope-not-read", "entry %s from scope library %s ignored", new Object[]{entry.getUrl(), library});
                                continue;
                            }
                            if (Files.isDirectory(entryPath, new LinkOption[0])) {
                                try {
                                    tree = new FileTree(entryPath, nameSpace);
                                    packages.addAll(tree.getPackageNames());
                                    fileTrees.put(entryPath, tree);
                                }
                                catch (IOException e) {
                                    log.warning("scope-not-read", "entry %s from scope library %s not read: %s", new Object[]{entryPath, library, e}).scope(entryPath);
                                }
                                continue;
                            }
                            try {
                                fileSystem = FileSystems.newFileSystem(entryPath, null);
                                var18_28 = null;
                                try {
                                    tree = new FileTree(fileSystem.getPath("/", new String[0]), nameSpace);
                                    packages.addAll(tree.getPackageNames());
                                    fileTrees.put(entryPath, tree);
                                }
                                catch (Throwable var19_30) {
                                    var18_28 = var19_30;
                                    throw var19_30;
                                }
                                finally {
                                    if (fileSystem == null) continue;
                                    if (var18_28 != null) {
                                        try {
                                            fileSystem.close();
                                        }
                                        catch (Throwable var19_29) {
                                            var18_28.addSuppressed(var19_29);
                                        }
                                        continue;
                                    }
                                    fileSystem.close();
                                }
                            }
                            catch (IOException | FileSystemNotFoundException e) {
                                log.warning("scope-not-read", "entry %s from scope library %s not read: %s", new Object[]{entryPath, library, e}).scope(path);
                            }
                        }
                        continue block48;
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        log.warning("scope-not-read", "scope library %s not read: %s", new Object[]{path, e}).scope(path);
                        break;
                    }
                }
                case 3: 
                case 4: {
                    try {
                        fileSystem = FileSystems.newFileSystem(path, null);
                        e = null;
                        tree = new FileTree(fileSystem.getPath("/", new String[0]), nameSpace);
                        packages.addAll(tree.getPackageNames());
                        fileTrees.put(path, tree);
                        if (fileSystem == null) continue block48;
                        if (e == null) ** GOTO lbl140
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable var15_22) {
                            e.addSuppressed(var15_22);
                        }
                        continue block48;
lbl140:
                        // 1 sources

                        fileSystem.close();
                        ** break;
                        catch (Throwable var15_23) {
                            try {
                                e = var15_23;
                                throw var15_23;
                            }
                            catch (Throwable var22_33) {
                                if (fileSystem != null) {
                                    if (e != null) {
                                        try {
                                            fileSystem.close();
                                        }
                                        catch (Throwable var23_34) {
                                            e.addSuppressed(var23_34);
                                        }
                                    } else {
                                        fileSystem.close();
                                    }
                                }
                                throw var22_33;
lbl157:
                                // 1 sources

                            }
                        }
                    }
                    catch (IOException | FileSystemNotFoundException e) {
                        log.warning("scope-not-read", "scope archive %s not read: %s", new Object[]{path, e}).scope(path);
                    }
                    break;
                }
                case 5: {
                    try {
                        lines = Files.readAllLines(path);
                        nestedPaths = new ArrayList<Path>(lines.size());
                        for (String line : lines) {
                            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                            nestedPaths.add(Paths.get(line, new String[0]));
                        }
                        domain = Command.collectScopePackages(nestedPaths, domain, fileTrees, nameSpace, macros, packages, commandOutput, log);
                    }
                    catch (IOException e) {
                        log.warning("scope-not-read", "scope list file %s not read: %s", new Object[]{path, e}).scope(path);
                    }
                    break;
                }
                default: {
                    log.warning("scope-not-recognized", "scope list file %s not a recognized type: %s", new Object[]{path}).scope(path);
                }
            }
        }
        return domain;
    }

    private static void writeUsedFiles(CommandInput commandInput, ExportDomain domain, ClassPathModel model, UsesModel uses, Map<String, String> remediationComments, Log log, CommandInput.OutputType ... outputTypes) throws CommandException {
        Path usedConcealed = null;
        Path unusedExported = null;
        Path annotated = null;
        Path unannotated = null;
        Path migrated = null;
        Path missing = null;
        block16: for (CommandInput.OutputType type : outputTypes) {
            Path path = commandInput.getOutputPath(type);
            if (path == null) continue;
            Command.createDirectory(path);
            switch (type.toString().split("_")[1]) {
                case "CONCEALED": {
                    usedConcealed = path;
                    continue block16;
                }
                case "EXPORTED": {
                    unusedExported = path;
                    continue block16;
                }
                case "COMMENTED": {
                    annotated = path;
                    continue block16;
                }
                case "UNCOMMENTED": {
                    unannotated = path;
                    continue block16;
                }
                case "MIGRATED": {
                    migrated = path;
                    continue block16;
                }
                case "MISSING": {
                    missing = path;
                }
            }
        }
        UsesReaderWriter.writeUsedFiles(uses, model, domain, remediationComments, usedConcealed, unusedExported, annotated, unannotated, migrated, missing, log);
    }

    private static String s(int n) {
        return n == 1 ? "" : "s";
    }

    /*
     * WARNING - void declaration
     */
    private static int compareModels(ClassPathModel referenceModel, ClassPathModel revisedModel, CommandInput commandInput, CommandOutput commandOutput, UsesSupplier recentUses, Log log) throws CommandException {
        Object errorSummary;
        BaselineComparison comparison = new BaselineComparison(recentUses.get(), log);
        List<Path> approvalsPaths = Iterables.sortedList(commandInput.getApprovals());
        if (!approvalsPaths.isEmpty()) {
            Throwable throwable;
            Closeable stream;
            ArrayList<Path> submittedPaths = new ArrayList<Path>();
            for (Path path : approvalsPaths) {
                try {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        stream = Files.newDirectoryStream(path, p -> Paths.hasSuffix(p, ".lis"));
                        throwable = null;
                        try {
                            for (Path child : Iterables.sortedList(stream)) {
                                comparison.readApprovals(child);
                                submittedPaths.add(child);
                            }
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            stream.close();
                            continue;
                        }
                    }
                    if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                    comparison.readApprovals(path);
                    submittedPaths.add(path);
                }
                catch (FileNotFoundException e) {
                    throw new CommandException(e, "Baseline change approvals file %s not found", path);
                }
                catch (IOException e) {
                    throw new CommandException(e, "Baseline change approvals file %s not read: %s", path, e);
                }
            }
            int count = comparison.getApprovalsCount();
            if (count == 0) {
                commandOutput.note("No baseline change approvals specified in %s", Command.list(approvalsPaths, false, "no files", "", "and"));
            } else {
                commandOutput.note("%d baseline change approval%s specified in %s", count, Command.s(count), Command.list(approvalsPaths, false, "no files", "", "and"));
            }
            Path submittedPath = commandInput.getOutputPath(CommandInput.OutputType.SUBMITTED);
            if (submittedPath != null) {
                Command.createDirectory(submittedPath);
                try {
                    stream = new BufferedOutputStream(Files.newOutputStream(submittedPath, new OpenOption[0]));
                    throwable = null;
                    try {
                        int fileCount = 0;
                        byte[] EOL = System.getProperty("line.separator").getBytes();
                        for (Path path : submittedPaths) {
                            int i;
                            if (count > 0) {
                                ((FilterOutputStream)stream).write(EOL);
                            }
                            ++fileCount;
                            for (i = 0; i < 80; ++i) {
                                ((BufferedOutputStream)stream).write(35);
                            }
                            ((FilterOutputStream)stream).write(EOL);
                            ((FilterOutputStream)stream).write(String.format("# SUBMITTED APPROVALS FILE %s: %s", fileCount, Paths.getFileName(path)).getBytes());
                            ((FilterOutputStream)stream).write(EOL);
                            for (i = 0; i < 80; ++i) {
                                ((BufferedOutputStream)stream).write(35);
                            }
                            ((FilterOutputStream)stream).write(EOL);
                            ((FilterOutputStream)stream).write(EOL);
                            Files.copy(path, (OutputStream)stream);
                            ((FilterOutputStream)stream).write(EOL);
                        }
                        commandOutput.note("Submitted approvals (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.NOTES), submittedPath);
                    }
                    catch (Throwable fileCount) {
                        throwable = fileCount;
                        throw fileCount;
                    }
                    finally {
                        if (stream != null) {
                            if (throwable != null) {
                                try {
                                    ((FilterOutputStream)stream).close();
                                }
                                catch (Throwable fileCount) {
                                    throwable.addSuppressed(fileCount);
                                }
                            } else {
                                ((FilterOutputStream)stream).close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new CommandException(e, "Submitted approvals file %s not created: %s", submittedPath, e);
                }
            }
        } else {
            commandOutput.note("No approvals submitted", new Object[0]);
        }
        comparison.compare(referenceModel, revisedModel);
        int errors = comparison.getErrorsCount();
        int warnings = comparison.getWarningsCount();
        int notes = comparison.getNotesCount();
        int unapproved = errors + warnings + notes;
        int approved = comparison.getMatchedApprovalsCount();
        Path notesPath = commandInput.getOutputPath(CommandInput.OutputType.NOTES);
        Command.createDirectory(notesPath);
        try {
            BufferedWriter writer = NullBufferedWriter.writerOrNullWriter(notesPath, Charset.defaultCharset(), new OpenOption[0]);
            Object object = null;
            try {
                for (String change : comparison.getNotes()) {
                    writer.write(change);
                    writer.newLine();
                }
                commandOutput.note("Baseline change notes list (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.NOTES), notesPath);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (object != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "Baseline change notes file %s not created: %s", notesPath, e);
        }
        Path warningsPath = commandInput.getOutputPath(CommandInput.OutputType.WARNINGS);
        Command.createDirectory(warningsPath);
        try {
            Throwable throwable = null;
            try (BufferedWriter writer = NullBufferedWriter.writerOrNullWriter(warningsPath, Charset.defaultCharset(), new OpenOption[0]);){
                for (String change : comparison.getWarnings()) {
                    writer.write(change);
                    writer.newLine();
                }
                commandOutput.note("Baseline change warnings list (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.WARNINGS), warningsPath);
            }
            catch (Throwable change) {
                Throwable throwable2 = change;
                throw change;
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "Baseline change warnings file %s not created: %s", warningsPath, e);
        }
        Path errorsPath = commandInput.getOutputPath(CommandInput.OutputType.ERRORS);
        Command.createDirectory(errorsPath);
        try {
            BufferedWriter bufferedWriter = NullBufferedWriter.writerOrNullWriter(errorsPath, Charset.defaultCharset(), new OpenOption[0]);
            Object change = null;
            try {
                int errorLimit = 128;
                errorSummary = new StringBuilder(200 * Math.min(errors, errorLimit));
                if (errors > 0) {
                    ((StringBuilder)errorSummary).append(':');
                }
                int lineCount = 0;
                for (String change2 : comparison.getErrors()) {
                    bufferedWriter.write(change2);
                    bufferedWriter.newLine();
                    if (++lineCount > errorLimit) continue;
                    ((StringBuilder)errorSummary).append("\n         ").append(change2);
                }
                if (lineCount > errorLimit) {
                    ((StringBuilder)errorSummary).append("\n         ... ").append(lineCount - errorLimit).append(" more");
                }
                commandOutput.note("Baseline change errors list (%s) written to %s%s", commandOutput.propertyDescription(CommandInput.OutputType.ERRORS), errorsPath, errorSummary);
            }
            catch (Throwable errorLimit) {
                change = errorLimit;
                throw errorLimit;
            }
            finally {
                if (bufferedWriter != null) {
                    if (change != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (Throwable errorLimit) {
                            ((Throwable)change).addSuppressed(errorLimit);
                        }
                    } else {
                        bufferedWriter.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new CommandException(iOException, "Baseline change errors file %s not created: %s", errorsPath, iOException);
        }
        Path path = commandInput.getOutputPath(CommandInput.OutputType.ERRORS_USED);
        Command.createDirectory(path);
        try (BufferedWriter writer = NullBufferedWriter.writerOrNullWriter(path, Charset.defaultCharset(), new OpenOption[0]);){
            for (String change : comparison.getErrorsWithUses()) {
                writer.write(change);
                writer.newLine();
            }
            commandOutput.note("Baseline change errors with uses list (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.ERRORS_USED), path);
        }
        catch (IOException e) {
            throw new CommandException(e, "Baseline API change errors with uses file %s not created: %s", path, e);
        }
        if (!approvalsPaths.isEmpty()) {
            Path matchedPath = commandInput.getOutputPath(CommandInput.OutputType.MATCHED);
            Command.createDirectory(matchedPath);
            try {
                BufferedWriter writer = NullBufferedWriter.writerOrNullWriter(matchedPath, Charset.defaultCharset(), new OpenOption[0]);
                errorSummary = null;
                try {
                    for (String string : comparison.getMatchedApprovals()) {
                        writer.write(string);
                        writer.newLine();
                    }
                }
                catch (Throwable change) {
                    errorSummary = change;
                    throw change;
                }
                finally {
                    if (writer != null) {
                        if (errorSummary != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable change) {
                                ((Throwable)errorSummary).addSuppressed(change);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new CommandException(e, "Matched approvals file %s not created: %s", matchedPath, e);
            }
            commandOutput.note("Matched approvals list (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.MATCHED), matchedPath);
            Path unmatchedPath = commandInput.getOutputPath(CommandInput.OutputType.UNMATCHED);
            Command.createDirectory(unmatchedPath);
            try {
                BufferedWriter writer = NullBufferedWriter.writerOrNullWriter(unmatchedPath, Charset.defaultCharset(), new OpenOption[0]);
                Object change = null;
                try {
                    for (String change2 : comparison.getUnmatchedApprovals()) {
                        writer.write(change2);
                        writer.newLine();
                    }
                }
                catch (Throwable throwable) {
                    change = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (change != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)change).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new CommandException(e, "Unmatched approvals file %s not created: %s", unmatchedPath, e);
            }
            commandOutput.note("Unmatched approvals list (%s) written to %s", commandOutput.propertyDescription(CommandInput.OutputType.UNMATCHED), unmatchedPath);
            if (comparison.getUnmatchedApprovalsCount() > 0) {
                int count = comparison.getApprovalsCount();
                commandOutput.note("%d of %d baseline change approval%s unused", comparison.getUnmatchedApprovalsCount(), count, Command.s(count));
            }
        }
        if (unapproved == 0 && approved == 0) {
            commandOutput.note("No baseline changes found", new Object[0]);
        } else if (unapproved == 0) {
            commandOutput.note("No unapproved baseline changes found", new Object[0]);
        } else {
            void var21_91;
            void var21_89;
            String[] separators;
            int items = Integer.signum(errors) + Integer.signum(warnings) + Integer.signum(notes) + Integer.signum(approved);
            switch (items) {
                case 1: {
                    separators = new String[]{""};
                    break;
                }
                case 2: {
                    separators = new String[]{"", " and "};
                    break;
                }
                case 3: {
                    separators = new String[]{"", ", ", ", and "};
                    break;
                }
                case 4: {
                    separators = new String[]{"", ", ", ", ", ", and "};
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            int count = 0;
            StringBuilder builder = new StringBuilder();
            Object var21_83 = null;
            if (errors > 0) {
                builder.append(separators[count++]).append(errors).append(" error").append(Command.s(errors));
                int errorsUses = comparison.getErrorsWithUsesCount();
                if (errorsUses > 0) {
                    builder.append(" (").append(errorsUses).append(" with uses)");
                }
                String string = "error";
            }
            if (warnings > 0) {
                void var21_85;
                builder.append(separators[count++]).append(warnings).append(" warning").append(Command.s(warnings));
                if (var21_85 == null) {
                    String string = "warning";
                }
            }
            if (notes > 0) {
                void var21_87;
                builder.append(separators[count++]).append(notes).append(" note").append(Command.s(notes));
                if (var21_87 == null) {
                    String string = "note";
                }
            }
            if (approved > 0) {
                builder.append(separators[count]).append(approved).append(" approved change").append(Command.s(approved));
            }
            builder.append(" found");
            if (var21_89 == null) {
                String string = "note";
            }
            commandOutput.log((String)var21_91, builder.toString(), new Object[0]);
        }
        return comparison.getErrorsCount();
    }

    private static String list(Collection<?> items, boolean quoteItems, String zeroText, String nonZeroPrefix, String conjunction) {
        String quote = quoteItems ? "\"" : "";
        switch (items.size()) {
            case 0: {
                return zeroText;
            }
            case 1: {
                return nonZeroPrefix + quote + items.iterator().next() + quote;
            }
            case 2: {
                Iterator<?> iterator = items.iterator();
                return nonZeroPrefix + quote + iterator.next() + quote + " " + conjunction + " " + quote + iterator.next() + quote;
            }
        }
        StringBuilder builder = new StringBuilder(nonZeroPrefix);
        Iterator<?> iterator = items.iterator();
        for (int i = 0; i < items.size() - 1; ++i) {
            builder.append(quote).append(iterator.next()).append(quote).append(", ");
        }
        builder.append(conjunction).append(" ").append(quote).append(iterator.next()).append(quote);
        return builder.toString();
    }

    private static Path createDirectory(Path path) throws CommandException {
        if (path == null) {
            return null;
        }
        try {
            return Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CommandException(e, "Directory %s not created: %s", path, e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void createRootsFromSources(Scope commandScope, ExportDomain domain, Installation installation, List<ClassesSource> sources, boolean librariesOnly, LinkedHashMap<FileExportLibrary, Map<ClassPathEntry, ClassPathRoot>> libraries, LinkedHashMap<PathKey, ClassPathRoot> roots, Map<Path, FileTree> fileTrees, NameSpace nameSpace, NestedFileSystemPool nestedFileSystemPool, CommandOutput commandOutput, Log log) throws CommandException {
        for (ClassesSource source : sources) {
            path = source.getPath();
            id = source.getId();
            type = source.getType();
            try {
                block74: {
                    block75: {
                        block73: {
                            if (path == null) break block73;
                            if (!Command.$assertionsDisabled && type == ClassesSource.SourceType.INSTALLATION) {
                                throw new AssertionError();
                            }
                            switch (2.$SwitchMap$oracle$javatools$exports$command$ClassesSource$SourceType[type.ordinal()]) {
                                case 1: {
                                    if (!Paths.hasSuffix(path, new String[]{".library"})) {
                                        throw new CommandException("Library expected to have .library file type");
                                    }
                                    resolvedObject = installation.getManifestLibrary(path);
                                    resolvedType = ClassesSource.SourceType.LIBRARY;
                                    break block74;
                                }
                                case 2: {
                                    extension = installation.findExtension(path);
                                    if (extension != null) ** GOTO lbl48
                                    try {
                                        containerFileSystem = FileSystems.newFileSystem(path, null);
                                        var21_30 = null;
                                        try {
                                            manifestPath = containerFileSystem.getPath("/", new String[0]).resolve("META-INF/extension.xml");
                                            if (!Files.exists(manifestPath, new LinkOption[0])) ** GOTO lbl27
                                            extension = installation.getExtension(commandScope, path, manifestPath);
                                            ** GOTO lbl48
lbl27:
                                            // 1 sources

                                            throw new CommandException("META-INF/extension.xml not found in expected extension %s", new Object[]{path});
                                        }
                                        catch (Throwable manifestPath) {
                                            var21_30 = manifestPath;
                                            throw manifestPath;
                                        }
                                        finally {
                                            if (containerFileSystem != null) {
                                                if (var21_30 != null) {
                                                    try {
                                                        containerFileSystem.close();
                                                    }
                                                    catch (Throwable manifestPath) {
                                                        var21_30.addSuppressed(manifestPath);
                                                    }
                                                } else {
                                                    containerFileSystem.close();
                                                }
                                            }
                                        }
                                    }
                                    catch (NoSuchFileException e) {
                                        throw new CommandException(e, "Extension %s does not exist", new Object[]{path});
                                    }
                                    catch (FileSystemNotFoundException e) {
                                        throw new CommandException(e, "Extension %s not a jar", new Object[]{path});
                                    }
                                    catch (IOException e) {
                                        throw new CommandException(e, "Extension %s not opened", new Object[]{path});
                                    }
lbl48:
                                    // 2 sources

                                    resolvedObject = extension;
                                    resolvedType = ClassesSource.SourceType.EXTENSION;
                                    break block74;
                                }
                                case 3: {
                                    if (!Files.exists(path, new LinkOption[0]) && librariesOnly) {
                                        throw new CommandException("%s not found", new Object[]{path});
                                    }
                                    resolvedObject = path;
                                    resolvedType = ClassesSource.SourceType.PATH;
                                    break block74;
                                }
                                case 4: {
                                    if (!Files.isDirectory(path, new LinkOption[0])) ** GOTO lbl64
                                    if (librariesOnly) {
                                        throw new CommandException("Directory %s not a library or extension", new Object[]{path});
                                    }
                                    resolvedObject = path;
                                    resolvedType = ClassesSource.SourceType.PATH;
                                    break block74;
lbl64:
                                    // 1 sources

                                    if (!Files.isRegularFile(path, new LinkOption[0])) ** GOTO lbl125
                                    extension = Paths.getSuffix(path);
                                    e = -1;
                                    switch (extension.hashCode()) {
                                        case -1268894515: {
                                            if (!extension.equals(".library")) break;
                                            e = 0;
                                            break;
                                        }
                                        case 1475373: {
                                            if (!extension.equals(".jar")) break;
                                            e = 1;
                                        }
                                    }
                                    switch (e) {
                                        case 0: {
                                            resolvedObject = installation.getManifestLibrary(path);
                                            resolvedType = ClassesSource.SourceType.LIBRARY;
                                            break;
                                        }
                                        case 1: {
                                            try {
                                                containerFileSystem = FileSystems.newFileSystem(path, null);
                                                var24_37 = null;
                                                try {
                                                    containerPath = containerFileSystem.getPath("/", new String[0]);
                                                    manifestPath = containerPath.resolve("META-INF/extension.xml");
                                                    if (Files.exists(manifestPath, new LinkOption[0])) {
                                                        ro = installation.getExtension(commandScope, path, manifestPath);
                                                        rt = ClassesSource.SourceType.EXTENSION;
                                                    } else {
                                                        if (librariesOnly) {
                                                            throw new CommandException("Jar %s not a library or extension", new Object[]{path});
                                                        }
                                                        ro = containerPath;
                                                        rt = ClassesSource.SourceType.PATH;
                                                    }
                                                }
                                                catch (Throwable var25_41) {
                                                    var24_37 = var25_41;
                                                    throw var25_41;
                                                }
                                                finally {
                                                    if (containerFileSystem != null) {
                                                        if (var24_37 != null) {
                                                            try {
                                                                containerFileSystem.close();
                                                            }
                                                            catch (Throwable var25_40) {
                                                                var24_37.addSuppressed(var25_40);
                                                            }
                                                        } else {
                                                            containerFileSystem.close();
                                                        }
                                                    }
                                                }
                                            }
                                            catch (IOException e) {
                                                if (librariesOnly) {
                                                    throw new CommandException("Jar %s not a library or extension", new Object[]{path});
                                                }
                                                ro = path;
                                                rt = ClassesSource.SourceType.PATH;
                                            }
                                            resolvedObject = ro;
                                            resolvedType = rt;
                                            break;
                                        }
                                        default: {
                                            if (librariesOnly) {
                                                throw new CommandException("File %s not a library or extension", new Object[]{path});
                                            }
                                            resolvedObject = path;
                                            resolvedType = ClassesSource.SourceType.PATH;
                                            break;
                                        }
                                    }
                                    break block74;
lbl125:
                                    // 1 sources

                                    if (librariesOnly) {
                                        throw new CommandException("%s not found", new Object[]{path});
                                    }
                                    resolvedObject = path;
                                    resolvedType = ClassesSource.SourceType.PATH;
                                    break block74;
                                }
                                default: {
                                    throw new IllegalStateException(type.toString());
                                }
                            }
                        }
                        if (id == null) break block75;
                        switch (2.$SwitchMap$oracle$javatools$exports$command$ClassesSource$SourceType[type.ordinal()]) {
                            case 1: {
                                resolvedObject = installation.findLibrary(id);
                                if (resolvedObject == null) {
                                    throw new CommandException("Library %s not found", new Object[]{id});
                                }
                                resolvedType = ClassesSource.SourceType.LIBRARY;
                                break block74;
                            }
                            case 2: {
                                resolvedObject = installation.findExtension(id);
                                if (resolvedObject == null) {
                                    throw new CommandException("Extension %s not found", new Object[]{id});
                                }
                                resolvedType = ClassesSource.SourceType.EXTENSION;
                                break block74;
                            }
                            case 4: {
                                extension = installation.findExtension(id);
                                library = installation.findLibrary(id);
                                if (extension != null && library != null) {
                                    mwh = installation.getMiddlewareHome();
                                    throw new CommandException("Id \"%s\" ambiguous:\n  Library %1$s (\"%s\") at %s\n  Extension %1$s at %s\n  Use %s", new Object[]{id, library.getName(), Paths.relativize(library.getOrigin(), mwh), Paths.relativize(extension.getFilePath(), mwh), commandOutput.libraryOrExtensionDescription(id)});
                                }
                                if (extension == null) ** GOTO lbl157
                                resolvedObject = extension;
                                resolvedType = ClassesSource.SourceType.EXTENSION;
                                break block74;
lbl157:
                                // 1 sources

                                if (library == null) ** GOTO lbl161
                                resolvedObject = library;
                                resolvedType = ClassesSource.SourceType.LIBRARY;
                                break block74;
lbl161:
                                // 1 sources

                                throw new CommandException("Library or extension %s not found", new Object[]{id});
                            }
                            default: {
                                throw new IllegalStateException(type.toString());
                            }
                        }
                    }
                    resolvedObject = installation;
                    resolvedType = ClassesSource.SourceType.INSTALLATION;
                }
                if (!Command.$assertionsDisabled && resolvedObject == null) {
                    throw new AssertionError((Object)("source " + source));
                }
                source.resolve(resolvedType);
                if (resolvedObject instanceof Installation) {
                    for (FileExportLibrary library : installation.getLibraries()) {
                        Command.createRootsFromLibrary(commandScope, domain, fileTrees, library, librariesOnly, libraries, roots, nameSpace, nestedFileSystemPool, log);
                    }
                    continue;
                }
                if (resolvedObject instanceof Extension) {
                    extension = (Extension)resolvedObject;
                    for (FileExportLibrary library : extension.getLibraries()) {
                        Command.createRootsFromLibrary(commandScope, domain, fileTrees, library, librariesOnly, libraries, roots, nameSpace, nestedFileSystemPool, log);
                    }
                    if (!extension.getLibraries().isEmpty()) continue;
                    commandOutput.warning("Extension %s has no libraries", new Object[]{path});
                    continue;
                }
                if (resolvedObject instanceof ExportLibrary) {
                    Command.createRootsFromLibrary(commandScope, domain, fileTrees, (FileExportLibrary)resolvedObject, librariesOnly, libraries, roots, nameSpace, nestedFileSystemPool, log);
                    continue;
                }
                if (resolvedObject instanceof Path) {
                    policy = new FileAccessPolicy(new ExportSpecification(commandScope, null, domain));
                    root = new ClassPathRoot(commandScope, path, fileTrees, policy, nameSpace, nestedFileSystemPool, log);
                    roots.putIfAbsent(root.getReferencePath(), root);
                    continue;
                }
                throw new IllegalStateException();
            }
            catch (CommandException e) {
                if (librariesOnly) {
                    throw e;
                }
                commandOutput.error(e.getMessage(), new Object[0]);
            }
        }
    }

    private static void createRootsFromLibrary(Scope commandScope, ExportDomain domain, Map<Path, FileTree> fileTrees, FileExportLibrary library, boolean proprietaryContext, LinkedHashMap<FileExportLibrary, Map<ClassPathEntry, ClassPathRoot>> libraries, LinkedHashMap<PathKey, ClassPathRoot> mergedRoots, NameSpace nameSpace, NestedFileSystemPool nestedFileSystemPool, Log log) {
        LibraryScope libraryScope = new LibraryScope(commandScope, library);
        LinkedHashMap libraryRoots = new LinkedHashMap();
        if (libraries != null) {
            libraries.put(library, libraryRoots);
        }
        for (ClassPathEntry entry : library.getExpandedClassPathEntries()) {
            Merge<?> merge;
            ClassPathRoot newRoot;
            ClassPathRoot existingRoot;
            ExportSpecification specification = proprietaryContext && entry.getResolvedExportSpecification() != null ? entry.getResolvedExportSpecification() : new ExportSpecification(new SpecificationScope((Scope)libraryScope, ExportLinkage.NULL), null, domain);
            FileAccessPolicy policy = new FileAccessPolicy(specification);
            Path path = Paths.getAsDefaultPath(entry.getUrl());
            if (path == null) {
                log.error("command-nested-root", "root with non-empty entry name %s from library %s ignored", entry.getUrl(), library);
            }
            if ((existingRoot = mergedRoots.putIfAbsent((newRoot = new ClassPathRoot(libraryScope, path, fileTrees, policy, nameSpace, nestedFileSystemPool, log)).getReferencePath(), newRoot)) == null || (merge = existingRoot.merge(commandScope, newRoot)).getSeverity() != Severity.ERROR) continue;
            log.message(merge.getSeverity(), "command-merge-roots", "%s", merge.getDescription(Severity.WARNING));
        }
    }

    static void writePackagesFile(ClassPathModel model, UsesModel uses, Path path, Path middlewareHome) throws CommandException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("NAME,PATH,LIBRARY,SPECIFICATION,ACCESS,USES");
            writer.newLine();
            TreeMap<PackageName, Map> rootsPerPackage = new TreeMap<PackageName, Map>();
            for (ClassPathRoot classPathRoot : model.getRoots()) {
                for (PackageName name : classPathRoot.getPackageNames()) {
                    Map roots = rootsPerPackage.computeIfAbsent(name, v -> new TreeMap());
                    roots.put(Paths.relativize(classPathRoot.getPath(), middlewareHome), classPathRoot);
                }
            }
            for (Map.Entry entry : rootsPerPackage.entrySet()) {
                PackageName packageName = (PackageName)entry.getKey();
                Map roots = (Map)entry.getValue();
                PackageUses packageUses = uses.getPackageUses(packageName);
                String references = packageUses != null ? String.valueOf(packageUses.getTotalReferences()) : "-";
                for (Map.Entry rootEntry : roots.entrySet()) {
                    ClassPathRoot root = (ClassPathRoot)rootEntry.getValue();
                    String rootPath = (String)rootEntry.getKey();
                    int nullCount = 0;
                    for (ExportSpecification specification : root.getAccessPolicy().getExportSpecification().getSpecifications()) {
                        Scope specificationScope = specification.getScope();
                        CompatibilityAccess access = specification.getMemberAccess(packageName);
                        if (access == null && nullCount++ > 0) continue;
                        packageName.writeSourceName(writer);
                        writer.write(44);
                        writer.write(rootPath);
                        writer.write(44);
                        Scope libraryScope = specificationScope.getScope();
                        writer.write(libraryScope != null ? libraryScope.toString(middlewareHome) : root.getScope().toString(middlewareHome));
                        writer.write(44);
                        writer.write(specificationScope.toString(middlewareHome));
                        writer.write(44);
                        writer.write(access != null ? access.toString() : "-");
                        writer.write(44);
                        writer.write(references);
                        writer.newLine();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CommandException("Packages file %s not created: %s", path, e);
        }
    }

    static void writeTypesFile(ClassPathModel model, UsesModel uses, Path path, Path middlewareHome) throws CommandException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            Map roots;
            writer.write("PACKAGE,NAME,PATH,LIBRARY,SPECIFICATION,ACCESS,USES");
            writer.newLine();
            TreeMap<TypeName, Map> rootsPerType = new TreeMap<TypeName, Map>();
            for (ClassPathRoot classPathRoot : model.getRoots()) {
                for (TypeName name : classPathRoot.getTypeNames()) {
                    roots = rootsPerType.computeIfAbsent(name, v -> new TreeMap());
                    roots.put(Paths.relativize(classPathRoot.getPath(), middlewareHome), classPathRoot);
                }
            }
            for (Map.Entry entry : rootsPerType.entrySet()) {
                TypeName typeName = (TypeName)entry.getKey();
                PackageName packageName = typeName.getPackage();
                roots = (Map)entry.getValue();
                TypeUses typeUses = uses.getTypeUses(typeName);
                String references = typeUses != null ? String.valueOf(typeUses.getTotalReferences()) : "-";
                for (Map.Entry rootEntry : roots.entrySet()) {
                    ClassPathRoot root = (ClassPathRoot)rootEntry.getValue();
                    String rootPath = (String)rootEntry.getKey();
                    for (ExportSpecification specification : root.getAccessPolicy().getExportSpecification().getSpecifications()) {
                        CompatibilityAccess access = specification.getPackage(packageName).getType(typeName).getAccess();
                        if (access == null) continue;
                        packageName.writeSourceName(writer);
                        writer.write(44);
                        typeName.writeSourceName(writer);
                        writer.write(44);
                        writer.write(rootPath);
                        writer.write(44);
                        writer.write(specification.getScope().getScope().toString(middlewareHome));
                        writer.write(44);
                        writer.write(specification.getScope().toString(middlewareHome));
                        writer.write(44);
                        writer.write(access.toString());
                        writer.write(44);
                        writer.write(references);
                        writer.newLine();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CommandException("Packages file %s not created: %s", path, e);
        }
    }

    private static Map<String, String> collectRemediationComments(ClassPathModel model) {
        HashMap<String, String> comments = new HashMap<String, String>();
        for (Package packag : model.getControlledPackages()) {
            if (packag.getAccessComment() != null) {
                comments.put(packag.getQualifiedSourceName(), packag.getAccessComment());
            }
            for (Type type : packag.getDeclaredTypes()) {
                if (type.getAccessComment() != null) {
                    comments.put(type.getQualifiedSourceName(), type.getAccessComment());
                }
                for (Member<?> member : type.getDeclaredMembers()) {
                    if (member.getAccessComment() == null) continue;
                    comments.put(member.getQualifiedSourceName(), member.getAccessComment());
                }
            }
        }
        return comments;
    }

    private static Map<String, String> collectRemediationComments(Set<ClassPathModel.LibraryDescription> libraries, Log log) {
        HashMap<String, String> comments = new HashMap<String, String>();
        for (ClassPathModel.LibraryDescription description : libraries) {
            ExportLibrary library = description.getLibrary();
            if (library == null) continue;
            for (Map.Entry<String, String> entry : library.getResolvedRemediationComments().entrySet()) {
                String value = entry.getValue();
                String predecessor = comments.putIfAbsent(entry.getKey(), value);
                if (predecessor == null || predecessor.equals(value)) continue;
                log.warning("library-duplicate-comment", "duplicate remediation comment for %s from library \"%s\": \"%s\" preceded by \"%s\"", entry.getKey(), library.getName(), value, predecessor).scope(library);
            }
        }
        return comments;
    }

    public static void writeSignatureFile(ClassPathModel model, CompatibilityAccess access, Path path) throws CommandException {
        assert (access != null);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (Package packag : model.getControlledPackages()) {
                for (Type type : packag.getControlledTypes()) {
                    if (type.getReferenceAccess() == access) {
                        writer.write(type.getTypeKind().toUpperCase());
                        writer.write(32);
                        type.getName().writeQualifiedSourceName(writer);
                        writer.newLine();
                    }
                    for (Member<?> member : type.getDeclaredMembers()) {
                        if (member.getReferenceAccess() != access || member.isSuppressed() && access == CompatibilityAccess.CONCEALED) continue;
                        writer.write(member.getKind().toUpperCase());
                        writer.write(32);
                        member.getResolvedName().writeQualifiedSourceName(writer);
                        writer.newLine();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "%s signature file %s not created: %s", new Object[]{access, path, e});
        }
    }

    public static void writeProblemTypesFile(ClassPathModel model, Path path, Path baseDirectory) throws CommandException {
        TreeMap<Type, Set> problemTypes = new TreeMap<Type, Set>();
        for (Package packag : model.getControlledPackages()) {
            if (!packag.isExportedOrRestricted()) continue;
            for (Type type : new ArrayList<Type>(packag.getDeclaredTypes())) {
                if (!type.isExportedOrRestricted()) continue;
                for (Member<?> member : type.getDeclaredMembers()) {
                    if (!member.isExportedOrRestricted()) continue;
                    for (Type problemType : member.getProblemTypes()) {
                        problemTypes.computeIfAbsent(problemType, v -> new TreeSet()).add(type);
                    }
                }
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            int count = 0;
            for (Map.Entry entry : problemTypes.entrySet()) {
                Type problemType;
                if (count++ > 0) {
                    writer.newLine();
                }
                if ((problemType = (Type)entry.getKey()).isUnresolved()) {
                    writer.write("unresolved:   ");
                } else if (!problemType.isExportable()) {
                    writer.write("unexportable: ");
                } else if (!problemType.isControlled()) {
                    writer.write("uncontrolled: ");
                } else if (problemType.getReferenceAccess() == CompatibilityAccess.CONCEALED) {
                    writer.write("concealed:    ");
                } else if (problemType.getReferenceAccess() == CompatibilityAccess.RESTRICTED) {
                    writer.write("restricted:   ");
                } else {
                    throw new IllegalStateException("unexpected problem type " + problemType);
                }
                problemType.getName().writeQualifiedSourceName(writer);
                writer.newLine();
                if (!problemType.isUnresolved()) {
                    writer.write("  at:         ");
                    ClassPathRoot root = problemType.getRoot();
                    if (root != null) {
                        String basePath = Paths.relativize(root.getPath(), baseDirectory).replace('\\', '/');
                        writer.write(basePath);
                        if (basePath.endsWith(".jar") || basePath.endsWith(".zip")) {
                            writer.write(33);
                        }
                        writer.write(47);
                        problemType.getName().writeQualifiedClassName(writer, '/');
                    } else {
                        writer.write("unspecified");
                    }
                    writer.newLine();
                    writer.write("  from:       ");
                    writer.write(problemType.getScope().toString(baseDirectory));
                    writer.newLine();
                }
                for (Type referringType : (Set)entry.getValue()) {
                    writer.write("  by:         ");
                    referringType.getName().writeQualifiedSourceName(writer);
                    writer.newLine();
                }
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "Problem types file %s not created: %s", path, e);
        }
    }

    public static void writeLibrariesFile(Set<ClassPathModel.LibraryDescription> libraries, Path middlewareHome, Path path) throws CommandException {
        int count = 0;
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
            for (ClassPathModel.LibraryDescription description : libraries) {
                if (count++ > 0) {
                    writer.println();
                }
                writer.print("Library \"");
                writer.print(description.getName());
                writer.println('\"');
                writer.print("name:       \"");
                writer.print(description.getName());
                writer.println('\"');
                writer.print("id:         ");
                writer.println(description.getId());
                writer.print("origin:     ");
                writer.println(description.getPath());
                ExportLibrary library = description.getLibrary();
                if (library == null) continue;
                writer.print("manifest:   ");
                if (library.hasManifestClassPath()) {
                    writer.printf("+%d entries", library.getExpandedClassPathEntries().size() - library.getResolvedClassPathEntries().size());
                } else {
                    writer.print("-");
                }
                writer.println();
                LibraryDependency lastDependency = null;
                int entryCount = 0;
                for (ClassPathEntry classPathEntry : library.getExpandedClassPathEntries()) {
                    if (classPathEntry.getDependency() != lastDependency) {
                        lastDependency = classPathEntry.getDependency();
                        writer.print("dependency: ");
                        writer.print(lastDependency.getId());
                        writer.print(" in ");
                        writer.println(Paths.relativize(((ExportLibrary)lastDependency.getLibrary()).getOrigin(), middlewareHome));
                    }
                    writer.print(entryCount++ == 0 ? "classpath:  " : "            ");
                    if (classPathEntry.isSupplied()) {
                        switch (classPathEntry.getExportLinkage()) {
                            case NONE: {
                                writer.print("[none] ");
                                break;
                            }
                            case EMBEDDED: {
                                writer.print("[jar-] ");
                                break;
                            }
                            case LIBRARY: {
                                writer.print("[file] ");
                                break;
                            }
                            case ALL: {
                                writer.print("[all-] ");
                                break;
                            }
                            case NULL: {
                                writer.print("[----] ");
                            }
                        }
                    } else {
                        switch (classPathEntry.getExportLinkage()) {
                            case NONE: {
                                writer.print("-none- ");
                                break;
                            }
                            case EMBEDDED: {
                                writer.print("-jar-- ");
                                break;
                            }
                            case LIBRARY: {
                                writer.print("-file- ");
                                break;
                            }
                            case ALL: {
                                writer.print("-all-- ");
                                break;
                            }
                            case NULL: {
                                writer.print("------ ");
                            }
                        }
                    }
                    writer.println(Paths.relativize(classPathEntry.getUrl(), middlewareHome));
                }
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "Libraries file %s not created: %s", path, e);
        }
    }

    private static void writeLibraryFile(ClassPathModel model, String libraryName, String libraryId, String libraryDescription, Path defaultExportSpecification, List<URL> commentsPaths, Path libraryPath) throws CommandException {
        try {
            ArrayList<ClassPathEntry> classPath = new ArrayList<ClassPathEntry>();
            HashMap<String, List<URL>> exportSpecifications = new HashMap<String, List<URL>>();
            if (defaultExportSpecification != null) {
                exportSpecifications.computeIfAbsent("", v -> new ArrayList()).add(Paths.toUrl(defaultExportSpecification));
            }
            for (ClassPathRoot root : model.getRoots()) {
                if (root.isJDK()) continue;
                URL url = root.getPath().toUri().toURL();
                ExportLinkage type = root.isControlled() ? ExportLinkage.LIBRARY : ExportLinkage.NULL;
                String key = root.isControlled() ? "" : null;
                ClassPathEntry entry = new ClassPathEntry(url, type, key, false, -1);
                classPath.add(entry);
            }
            new ExportLibraryWriter().write(libraryPath, libraryId, libraryName, libraryDescription, EnumSet.noneOf(FileExportLibrary.LibraryFlag.class), classPath, exportSpecifications, commentsPaths, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        catch (IOException e) {
            throw new CommandException(e, "Library file %s not created: %s", libraryPath, e);
        }
    }

    private static class TraversalMonitor
    implements ClassPathModel.Monitor {
        private final CommandOutput commandOutput;
        private final Log log;
        private int total;
        private String kind;
        private int count;
        private long begin;
        private long mark;

        public TraversalMonitor(CommandOutput commandOutput, Log log) {
            this.commandOutput = commandOutput;
            this.log = log;
        }

        @Override
        public void beginTraversal(List<ClassPathRoot> controlledRoots, List<ClassPathRoot> uncontrolledRoots) {
            this.total = controlledRoots.size();
            this.kind = "controlled";
            this.count = 0;
            this.mark = this.begin = System.currentTimeMillis();
            this.commandOutput.note("Found %d controlled and %d uncontrolled class path entries", controlledRoots.size(), uncontrolledRoots.size());
            this.commandOutput.note("Beginning traversal of %d %s class path entr%s", this.total, this.kind, this.ending(this.total));
        }

        @Override
        public void rootTraversed(ClassPathRoot root) {
            long now;
            ++this.count;
            if (this.count < this.total && (now = System.currentTimeMillis()) - this.mark > 15000L) {
                this.mark = now;
                this.commandOutput.note("%d of %d %s class path entr%s traversed, continuing", this.count, this.total, this.kind, this.ending(this.total));
            }
        }

        @Override
        public void endTraversal() {
            this.commandOutput.note("Completed traversal of %d %s class path entr%s", this.total, this.kind, this.ending(this.total));
            this.log.note("command-time-read-classes", "time to read %s classes: %dms", this.kind, System.currentTimeMillis() - this.begin);
        }

        private String ending(int count) {
            return count == 1 ? "y" : "ies";
        }
    }
}

