/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.javatools.exports.classpath.ClassPathRoot;

public class NestedFileSystemPool {
    public static final int DEFAULT_TRANSIENT_LIMIT = 2;
    private LinkedHashMap<Path, ClassPathRoot> permanentRoots = new LinkedHashMap();
    private LinkedHashMap<Path, ClassPathRoot> transientRoots = new LinkedHashMap<Path, ClassPathRoot>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Path, ClassPathRoot> eldest) {
            boolean evict;
            boolean bl = evict = this.size() > NestedFileSystemPool.this.transientLimit;
            if (evict) {
                eldest.getValue().closeNestedFileSystem("cache eviction");
            }
            return evict;
        }
    };
    private final int transientLimit;

    public NestedFileSystemPool() {
        this.transientLimit = 2;
    }

    public NestedFileSystemPool(int transientLimit) {
        this.transientLimit = transientLimit;
    }

    public synchronized void addPermanent(ClassPathRoot root) {
        Path path = root.getPath();
        this.transientRoots.remove(path);
        this.permanentRoots.put(path, root);
    }

    public synchronized void addTransient(ClassPathRoot root) {
        this.transientRoots.put(root.getPath(), root);
    }

    public synchronized void close(String reason) {
        for (ClassPathRoot root : this.permanentRoots.values()) {
            root.closeNestedFileSystem(reason);
        }
        this.permanentRoots.clear();
        for (ClassPathRoot root : this.transientRoots.values()) {
            root.closeNestedFileSystem(reason);
        }
        this.transientRoots.clear();
    }
}

