/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import oracle.javatools.exports.classpath.ClassPool;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.file.PathKey;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.name.NameSpace;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.Scanner;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.parser.java.v2.classfile.Name;

public class ClassReader
implements AutoCloseable {
    static final int PUBLIC_PROTECTED = 5;
    static final int PUBLIC_PROTECTED_PRIVATE = 7;
    static final int BRIDGE = 64;
    static final int SYNTHETIC = 4096;
    static final int VARARGS = 128;
    private final NameSpace nameSpace;
    private final ClassPool classPool;
    private byte[] byteBuffer;
    private final MethodSignature methodSignature = new MethodSignature(null, 0, null);
    private final MethodSignature EMPTY_VOID_SIGNATURE = new MethodSignature(TypeName.EMPTY_ARRAY, 0, TypeName.VOID);

    static boolean publicOrProtected(int modifiers) {
        return (5 & modifiers) != 0;
    }

    static boolean packagePrivate(int modifiers) {
        return (7 & modifiers) == 0;
    }

    static boolean bridge(int modifiers) {
        return (modifiers & 0x40) != 0;
    }

    static boolean synthetic(int modifiers) {
        return (modifiers & 0x1000) != 0;
    }

    static boolean varargs(int modifiers) {
        return (modifiers & 0x80) != 0;
    }

    public ClassReader(ClassPool pool, NameSpace nameSpace) {
        this.nameSpace = nameSpace;
        this.classPool = pool;
    }

    ClassFile parseClassFile(Path path, Log log) throws IOException {
        if (this.byteBuffer != null) {
            throw new IllegalStateException("class file buffer already open");
        }
        try (SeekableByteChannel channel = Files.newByteChannel(path, new OpenOption[0]);){
            long longSize = channel.size();
            if (longSize > 0x7FFFFFF7L) {
                throw new IOException("Size " + longSize + " of " + path + " too close to Integer.MAX_VALUE");
            }
            int size = (int)longSize;
            if (size > 524288) {
                log.trace("model-large-class", "class size %d at %s", size, new PathKey(path));
            }
            this.byteBuffer = this.classPool.acquireClassFileBuffer(size);
            ByteBuffer buffer = ByteBuffer.wrap(this.byteBuffer, 0, size);
            int count = channel.read(buffer);
            if (count != size) {
                throw new IOException("Expected " + size + " but got " + count + " bytes from " + path);
            }
            ClassFile classFile = new ClassFile(this.byteBuffer, size, null);
            return classFile;
        }
    }

    @Override
    public void close() {
        this.classPool.releaseMethodDescriptorBuffer(this.methodSignature.parameterTypeNames);
        MethodSignature.access$202(this.methodSignature, null);
        this.classPool.releaseClassFileBuffer(this.byteBuffer);
        this.byteBuffer = null;
    }

    MethodSignature parseMethodDescriptor(String descriptor, boolean constructor, Type type) {
        if ("()V".equals(descriptor)) {
            return this.EMPTY_VOID_SIGNATURE;
        }
        this.methodSignature.parameterCount = 0;
        if (this.methodSignature.parameterTypeNames == null) {
            MethodSignature.access$202(this.methodSignature, this.classPool.acquireMethodDescriptorBuffer());
        }
        this.methodSignature.returnTypeName = null;
        Scanner scanner = new Scanner(descriptor);
        if (scanner.next() != '(') {
            throw new IllegalStateException("malformed descriptor " + scanner.getTrimmedInitialString());
        }
        if (constructor && type.isNonStaticInnerClass()) {
            if (scanner.next() == ')') {
                throw new IllegalStateException("nothing to see here");
            }
            TypeName key = this.parseFieldDescriptor(scanner);
            if (!type.getOuterType().getName().equals(key)) {
                ((MethodSignature)this.methodSignature).parameterTypeNames[((MethodSignature)this.methodSignature).parameterCount++] = key;
            }
        }
        while (scanner.next() != ')') {
            ((MethodSignature)this.methodSignature).parameterTypeNames[((MethodSignature)this.methodSignature).parameterCount++] = this.parseFieldDescriptor(scanner);
        }
        if (scanner.next() == 'V') {
            this.methodSignature.returnTypeName = TypeName.VOID;
        } else {
            this.methodSignature.returnTypeName = this.parseFieldDescriptor(scanner);
        }
        if (scanner.next() != '\u0000') {
            throw new IllegalArgumentException("malformed descriptor " + scanner.getTrimmedInitialString());
        }
        return this.methodSignature;
    }

    TypeName parseFieldDescriptor(String descriptor) {
        Scanner scanner = new Scanner(descriptor);
        scanner.next();
        return this.parseFieldDescriptor(scanner);
    }

    TypeName parseClassName(Name name) {
        if (name == null) {
            return null;
        }
        return this.nameSpace.typeNameBinary(name.toString());
    }

    TypeName[] parseNames(Name[] names) {
        int count = names.length;
        if (count == 0) {
            return TypeName.EMPTY_ARRAY;
        }
        TypeName[] typeNames = new TypeName[count];
        for (int i = 0; i < count; ++i) {
            Name name = names[i];
            if (name == null) continue;
            typeNames[i] = this.nameSpace.typeNameBinary(name.toString());
        }
        return this.nameSpace.typeNames(typeNames);
    }

    private TypeName parseFieldDescriptor(Scanner scanner) {
        if (scanner.done()) {
            throw new IllegalStateException("malformed descriptor " + scanner.getTrimmedInitialString());
        }
        switch (scanner.current()) {
            case 'B': {
                scanner.consume();
                return TypeName.BYTE;
            }
            case 'C': {
                scanner.consume();
                return TypeName.CHAR;
            }
            case 'D': {
                scanner.consume();
                return TypeName.DOUBLE;
            }
            case 'F': {
                scanner.consume();
                return TypeName.FLOAT;
            }
            case 'I': {
                scanner.consume();
                return TypeName.INT;
            }
            case 'J': {
                scanner.consume();
                return TypeName.LONG;
            }
            case 'S': {
                scanner.consume();
                return TypeName.SHORT;
            }
            case 'Z': {
                scanner.consume();
                return TypeName.BOOLEAN;
            }
            case 'L': {
                char c;
                int offset = scanner.index() + 1;
                do {
                    if (!scanner.done()) continue;
                    throw new IllegalStateException("malformed descriptor " + scanner.getTrimmedInitialString());
                } while ((c = scanner.next()) != ';');
                scanner.consume();
                return this.nameSpace.typeNameBinary(scanner.getBackingString(), offset, scanner.index());
            }
            case '[': {
                scanner.next();
                return this.nameSpace.arrayNameGetOrCreate(this.parseFieldDescriptor(scanner));
            }
        }
        throw new IllegalStateException("malformed descriptor " + scanner.getTrimmedInitialString());
    }

    class MethodSignature {
        private TypeName[] parameterTypeNames;
        private int parameterCount;
        private TypeName returnTypeName;

        private MethodSignature(TypeName[] parameterTypeNames, int parameterCount, TypeName returnTypeName) {
            this.parameterTypeNames = parameterTypeNames;
            this.parameterCount = parameterCount;
            this.returnTypeName = returnTypeName;
        }

        TypeName[] getParameterTypeNames() {
            return ClassReader.this.nameSpace.typeNames(this.parameterTypeNames, this.parameterCount);
        }

        TypeName getReturnTypeName() {
            return this.returnTypeName;
        }

        static /* synthetic */ TypeName[] access$202(MethodSignature x0, TypeName[] x1) {
            x0.parameterTypeNames = x1;
            return x1;
        }
    }
}

