/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.application;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.command.ClassesSource;
import oracle.javatools.exports.command.Command;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.command.CommandInput;
import oracle.javatools.exports.command.CommandOutput;
import oracle.javatools.exports.name.NameFormat;
import oracle.javatools.util.CommandModel;
import oracle.javatools.util.CommandParser;

public class Exports
implements CommandOutput {
    private CommandParser parser;
    private static final String COPYRIGHT_TEXT = "Copyright (c) 2016, 2022, Oracle and/or its affiliates. All rights reserved.";

    @Override
    public void error(String message, Object ... arguments) {
        message = message.startsWith("error:") ? message : "error:   " + message;
        System.err.printf(message, arguments);
        System.err.println();
    }

    public void fatal(String message, Object ... arguments) {
        message = message.startsWith("error:") ? message : "error:   " + message;
        System.err.printf(message, arguments);
        System.err.println();
        System.exit(1);
    }

    @Override
    public void warning(String message, Object ... arguments) {
        message = message.startsWith("warning:") ? message : "warning: " + message;
        System.err.printf(message, arguments);
        System.err.println();
    }

    @Override
    public void note(String message, Object ... arguments) {
        message = message.startsWith("note:") ? message : "note:    " + message;
        System.err.printf(message, arguments);
        System.err.println();
    }

    @Override
    public void coarse(String message, Object ... arguments) {
        message = message.startsWith("note:") ? message : "note:    " + message;
        System.err.printf(message, arguments);
        System.err.println();
    }

    @Override
    public void fine(String message, Object ... arguments) {
        message = message.startsWith("note:") ? message : "note:    " + message;
        System.err.printf(message, arguments);
        System.err.println();
    }

    @Override
    public String propertyDescription(String propertyName) {
        if (this.parser.isParameter(propertyName)) {
            return propertyName + " parameter";
        }
        if (this.parser.isOption(propertyName)) {
            return "-" + propertyName + " option";
        }
        return "unknown property name \"" + propertyName + "\"";
    }

    @Override
    public String propertyDescription(CommandInput.OutputType type) {
        return "-output " + type.getTypeName() + ", or -" + type.getOptionName();
    }

    @Override
    public String libraryOrExtensionDescription(String id) {
        return "library:" + id + " or extension:" + id;
    }

    public static void main(String[] arguments) {
        new Exports().execute(arguments);
    }

    /*
     * WARNING - void declaration
     */
    private void execute(String[] arguments) {
        CommandInput.CommandType commandType;
        int argumentCount = arguments.length;
        if (argumentCount < 2) {
            Exports.printUsage();
            System.exit(1);
        }
        switch (arguments[0]) {
            case "generate": {
                commandType = CommandInput.CommandType.GENERATE;
                break;
            }
            case "analyze": {
                commandType = CommandInput.CommandType.ANALYZE;
                break;
            }
            case "merge": {
                commandType = CommandInput.CommandType.MERGE;
                break;
            }
            case "capture": {
                commandType = CommandInput.CommandType.CAPTURE;
                break;
            }
            case "compare": {
                commandType = CommandInput.CommandType.COMPARE;
                break;
            }
            case "convert": {
                commandType = CommandInput.CommandType.CONVERT;
                break;
            }
            default: {
                this.fatal("Unexpected command \"%s\", expected one of generate, analyze, merge, capture, compare, extract", arguments[0]);
                throw new IllegalStateException("error handling unexpected command " + arguments[0]);
            }
        }
        CommandInput properties = new CommandInput(commandType);
        this.parser = new CommandParser();
        this.parser.setArgumentFilesEnabled(true);
        this.parser.setCommaListsEnabled(true);
        switch (commandType) {
            case GENERATE: {
                this.parser.defineParameter("classpath", Path[].class);
                this.parser.defineRequirement("classpath");
                break;
            }
            case ANALYZE: {
                this.parser.defineParameter("libraries", String[].class);
                this.parser.defineRequirement("libraries");
                break;
            }
            case MERGE: {
                this.parser.defineParameter("libraries", String[].class);
                this.parser.defineRequirement("libraries");
                break;
            }
            case CAPTURE: {
                this.parser.defineParameter("libraries", String[].class);
                this.parser.defineRequirement("libraries");
                break;
            }
            case COMPARE: {
                this.parser.defineParameter("baselines", Path[].class);
                this.parser.defineRequirement("baselines");
                break;
            }
            case CONVERT: {
                this.parser.defineParameter("files", Path[].class);
            }
        }
        this.parser.defineOption("bootclasspath", Path[].class);
        this.parser.defineOption("help");
        this.parser.defineOption("middlewarehome", Path.class);
        this.parser.defineSynonym("middlewarehome", "mwh");
        this.parser.defineOption("source", String.class);
        this.parser.defineOption("owner", String.class);
        this.parser.defineOption("consumers", String[].class);
        this.parser.defineOption("dependencies", String[].class);
        this.parser.defineOption("domain", String.class);
        this.parser.defineOption("officialdomain");
        this.parser.defineOption("packages", String[].class);
        this.parser.defineOption("scope", Path[].class);
        this.parser.defineOption("libraryname", String.class);
        this.parser.defineOption("libraryid", String.class);
        this.parser.defineOption("librarydescription", String.class);
        this.parser.defineOption("validate");
        this.parser.defineOption("novalidate");
        this.parser.defineSuperseding("validate", "novalidate");
        this.parser.defineOption("failonclasspatherror");
        this.parser.defineOption("official");
        this.parser.defineOption("compareto", Path.class);
        this.parser.defineOption("approvals", Path[].class);
        this.parser.defineOption("exports", Path[].class);
        this.parser.defineOption("traces");
        this.parser.defineOption("uses");
        this.parser.defineSynonym("uses", "recentuses");
        this.parser.defineOption("classes");
        this.parser.defineOption("noclasses");
        this.parser.defineSuperseding("classes", "noclasses");
        this.parser.defineOption("stacktrace");
        this.parser.defineOption("tocsv", Path.class);
        this.parser.defineOption("toexport", Path.class);
        this.parser.defineOption("tosignature", Path.class);
        this.parser.defineOption("access", CompatibilityAccess.class);
        this.parser.defineRequirementPresent("access", "toexport");
        this.parser.defineOption("delimiter", String.class);
        this.parser.defineRequirementPresent("delimiter", "tocsv");
        this.parser.defineOption("header");
        this.parser.defineRequirementPresent("header", "tocsv");
        this.parser.defineOption("left", Path.class);
        this.parser.defineOption("apiformat", NameFormat.class);
        this.parser.defineRequirementPresent("apiformat", "tocsv", "tosignature");
        this.parser.defineOption("excludeempty", String[].class);
        this.parser.defineRequirementPresent("excludeempty", "tocsv");
        this.parser.defineOption("properties", String[].class);
        this.parser.defineRequirementPresent("properties", "tocsv");
        this.parser.defineRequirementPresent("header", "tocsv");
        this.parser.defineOption("noheader");
        this.parser.defineRequirementPresent("noheader", "tocsv");
        this.parser.defineSuperseding("header", "noheader");
        this.parser.defineOption("right", Path.class);
        this.parser.defineOption("rules", String[].class);
        this.parser.defineOption("removeavr");
        this.parser.defineOption("output", String[].class);
        this.parser.defineOption("directory", Path.class);
        this.parser.defineSynonym("directory", "outputdir");
        this.parser.defineSynonym("directory", "d");
        for (CommandInput.OutputType outputType : (CommandInput.OutputType[])CommandInput.OutputType.class.getEnumConstants()) {
            this.parser.defineOption(outputType.getTypeName() + "file", Path.class);
        }
        CommandModel model = null;
        try {
            Path maybePath;
            Path path;
            Object id;
            ClassesSource.SourceType type;
            String[] stringArray = arguments;
            arguments = new String[argumentCount - 1];
            System.arraycopy(stringArray, 1, arguments, 0, argumentCount - 1);
            model = this.parser.parse(arguments);
            if (model.isPresent("help")) {
                Exports.printUsage();
                System.exit(0);
            }
            properties.setCopyrightText(COPYRIGHT_TEXT);
            properties.setMiddlewareHome((Path)model.getValue("middlewarehome"));
            properties.setSource((String)model.getValue("source"));
            properties.setOwner((String)model.getValue("owner"));
            String domain = (String)model.getValue("domain");
            if ("fmw".equalsIgnoreCase(domain)) {
                properties.setDomain(CommandInput.FMW_DOMAIN);
            } else if ("all".equalsIgnoreCase(domain)) {
                properties.setDomain(CommandInput.UNIVERSAL_DOMAIN);
            } else if (domain != null) {
                CommandParser.Converter<Path> converter = this.parser.getConverter(Path.class);
                try {
                    properties.setDomain(converter.convert(domain, Path.class));
                }
                catch (Exception exception) {
                    throw new oracle.javatools.util.CommandException(exception, "option-value-conversion-failed", this.propertyDescription("domain"), converter.getTypeDescription(), domain, exception.getMessage());
                }
            } else if (model.isPresent("officialdomain")) {
                properties.setDomain(CommandInput.FMW_DOMAIN);
            }
            properties.setPackages(Arrays.asList((Object[])model.getValue("packages", new String[0])));
            properties.setScope(Arrays.asList((Object[])model.getValue("scope", new Path[0])));
            properties.setConsumers(new TreeSet<Object>(Arrays.asList((Object[])model.getValue("consumers", new String[0]))));
            properties.setLibraryName((String)model.getValue("libraryname"));
            properties.setLibraryId((String)model.getValue("libraryid"));
            properties.setLibraryDescription((String)model.getValue("librarydescription"));
            properties.setValidating(model.isAbsent("novalidate"));
            switch (commandType) {
                case GENERATE: {
                    properties.setFailOnClassPathError(model.getValue("failonclasspatherror", true));
                    break;
                }
                default: {
                    if (!model.isPresent("failonclasspatherror")) break;
                    throw new CommandException("-failonclasspatherror option prohibited for %s operation", commandType.toString().toLowerCase());
                }
            }
            properties.setOfficial(model.isPresent("official"));
            properties.setCompareTo((Path)model.getValue("compareto"));
            properties.setApprovals(Arrays.asList((Object[])model.getValue("approvals", new Path[0])));
            properties.setTraces(model.isPresent("traces"));
            properties.setUses(model.isPresent("uses"));
            properties.setClasses(model.isAbsent("noclasses"));
            switch (commandType) {
                case GENERATE: {
                    properties.setClassPath(Arrays.asList((Path[])model.getValue("classpath")));
                    break;
                }
                case ANALYZE: 
                case MERGE: 
                case CAPTURE: {
                    ArrayList<ClassesSource> libraries = new ArrayList<ClassesSource>();
                    for (String string : model.getValue("libraries", new String[0])) {
                        if (string.equals("installation") || string.equals("[installation]")) {
                            if (properties.getMiddlewareHome() == null) {
                                this.fatal("-middlewarehome required for [%s]", string);
                            }
                            type = ClassesSource.SourceType.INSTALLATION;
                            id = null;
                            path = null;
                        } else {
                            void var11_25;
                            if (string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
                                String string2;
                                if (properties.getMiddlewareHome() == null) {
                                    this.fatal("-middlewarehome required for id references like [%s]", string);
                                }
                                if ((string2 = string.substring(1, string.length() - 1)).startsWith("library:")) {
                                    type = ClassesSource.SourceType.LIBRARY;
                                    String string3 = string2.substring("library:".length());
                                } else if (string2.startsWith("extension:")) {
                                    type = ClassesSource.SourceType.EXTENSION;
                                    String string4 = string2.substring("extension:".length());
                                } else {
                                    type = ClassesSource.SourceType.UNKNOWN;
                                }
                            } else {
                                type = ClassesSource.SourceType.UNKNOWN;
                            }
                            maybePath = null;
                            try {
                                maybePath = this.parser.getConverter(Path.class).convert((String)var11_25, Path.class);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (maybePath != null && Files.exists(maybePath, new LinkOption[0])) {
                                id = null;
                                path = maybePath;
                            } else {
                                if (properties.getMiddlewareHome() == null) {
                                    this.fatal("-middlewarehome required for id references like [%s]", var11_25);
                                }
                                id = var11_25;
                                path = null;
                            }
                        }
                        libraries.add(new ClassesSource(path, id, type));
                    }
                    properties.setLibraries(libraries);
                    break;
                }
                case COMPARE: {
                    Path[] pathArray = model.getValue("baselines", new Path[0]);
                    if (pathArray.length != 2) {
                        this.fatal("compare operation requires exactly 2 baseline files to compare", new Object[0]);
                    }
                    properties.setBaseline0(pathArray[0]);
                    properties.setBaseline1(pathArray[1]);
                    break;
                }
                case CONVERT: {
                    properties.setFiles(Arrays.asList((Object[])model.getValue("files", new Path[0])));
                    properties.setAccess((CompatibilityAccess)((Object)model.getValue("access")));
                    properties.setApiFormat(model.getValue("apiformat", NameFormat.SOURCE));
                    properties.setDelimiter(model.getValue("delimiter", ","));
                    properties.setLeft((Path)model.getValue("left"));
                    properties.setRight((Path)model.getValue("right"));
                    properties.setToCsv((Path)model.getValue("tocsv"));
                    properties.setToExport((Path)model.getValue("toexport"));
                    properties.setToSignature((Path)model.getValue("tosignature"));
                    properties.setRules(Arrays.asList((Object[])model.getValue("rules", new String[0])));
                    properties.setExcludeEmpty(Arrays.asList((Object[])model.getValue("excludeempty", new String[0])));
                    properties.setProperties(Arrays.asList((Object[])model.getValue("properties", new String[0])));
                    properties.setHeader(model.isAbsent("novalidate"));
                    properties.setRemoveAdeViewRoot(model.isPresent("removeavr"));
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected commmand " + (Object)((Object)commandType));
                }
            }
            ArrayList<ClassesSource> dependencies = new ArrayList<ClassesSource>();
            for (String string : model.getValue("dependencies", new String[0])) {
                if (string.equals("installation") || string.equals("[installation]")) {
                    if (properties.getMiddlewareHome() == null) {
                        this.fatal("-middlewarehome required for [%s]", string);
                    }
                    type = ClassesSource.SourceType.INSTALLATION;
                    id = null;
                    path = null;
                } else {
                    void var11_35;
                    if (string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
                        String string5;
                        if (properties.getMiddlewareHome() == null) {
                            this.fatal("-middlewarehome required for id references like [%s]", string);
                        }
                        if ((string5 = string.substring(1, string.length() - 1)).startsWith("library:")) {
                            type = ClassesSource.SourceType.LIBRARY;
                            String string6 = string5.substring("library:".length());
                        } else if (string5.startsWith("extension:")) {
                            type = ClassesSource.SourceType.EXTENSION;
                            String string7 = string5.substring("extension:".length());
                        } else {
                            type = ClassesSource.SourceType.UNKNOWN;
                        }
                    } else {
                        type = ClassesSource.SourceType.UNKNOWN;
                    }
                    maybePath = null;
                    try {
                        maybePath = this.parser.getConverter(Path.class).convert((String)var11_35, Path.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (maybePath != null && Files.exists(maybePath, new LinkOption[0])) {
                        id = null;
                        path = maybePath;
                    } else {
                        if (properties.getMiddlewareHome() == null) {
                            this.fatal("-middlewarehome required for id references like [%s]", var11_35);
                        }
                        id = var11_35;
                        path = null;
                    }
                }
                dependencies.add(new ClassesSource(path, id, type));
            }
            properties.setDependencies(dependencies);
            properties.setDirectory((Path)model.getValue("directory"));
            properties.setOutput(Arrays.asList((Object[])model.getValue("output", new String[0])));
            for (CommandInput.OutputType outputType : (CommandInput.OutputType[])CommandInput.OutputType.class.getEnumConstants()) {
                String optionName = outputType.getOptionName();
                if (!model.isPresent(optionName)) continue;
                properties.setOutputPath(outputType, (Path)model.getValue(optionName));
            }
            properties.validate(this);
            int n = Command.execute(properties, this);
            System.exit(n);
        }
        catch (oracle.javatools.util.CommandException e) {
            this.fatal(e.getMessage(), new Object[0]);
        }
        catch (CommandException e) {
            if (model != null && model.isPresent("stacktrace")) {
                e.printStackTrace();
            }
            this.fatal(e.getMessage(), new Object[0]);
        }
    }

    private static void printUsage() {
        System.out.println(COPYRIGHT_TEXT);
        System.out.println();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Exports.class.getResourceAsStream("usage.txt")));){
            String line = reader.readLine();
            while (line != null) {
                System.out.println(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

