/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports;

public enum CompatibilityAccess {
    EXPORTED("exported"),
    RESTRICTED("restricted"),
    CONCEALED("concealed");

    private String lowerCase;

    private CompatibilityAccess(String lowerCase) {
        this.lowerCase = lowerCase;
    }

    public static CompatibilityAccess valueOfIgnoreCase(String string) throws IllegalArgumentException {
        if (string == null || "null".equalsIgnoreCase(string)) {
            return null;
        }
        for (CompatibilityAccess constant : (CompatibilityAccess[])CompatibilityAccess.class.getEnumConstants()) {
            if (!constant.lowerCase.equalsIgnoreCase(string)) continue;
            return constant;
        }
        throw new IllegalArgumentException("expected \"exported\", \"restricted\", \"concealed\", \"null\", or null (ignoring case): actual \"" + string + '\"');
    }

    public boolean isExported() {
        return this == EXPORTED;
    }

    public boolean isRestricted() {
        return this == RESTRICTED;
    }

    public boolean isConcealed() {
        return this == CONCEALED;
    }

    public boolean isExportedOrRestricted() {
        return this != CONCEALED;
    }

    public boolean isConcealedOrRestricted() {
        return this != EXPORTED;
    }

    public boolean isMoreExportedThan(CompatibilityAccess access) {
        return CompatibilityAccess.isMoreExported(this, access);
    }

    public boolean isMoreConcealedThan(CompatibilityAccess access) {
        return CompatibilityAccess.isMoreConcealed(this, access);
    }

    public CompatibilityAccess mostExported(CompatibilityAccess that) {
        return CompatibilityAccess.mostExported(this, that);
    }

    public CompatibilityAccess mostConcealed(CompatibilityAccess that) {
        return CompatibilityAccess.mostConcealed(this, that);
    }

    public String toUpperCase() {
        return this.toString();
    }

    public String toLowerCase() {
        return this.lowerCase;
    }

    public String toString() {
        return this.toLowerCase();
    }

    public static boolean isExported(CompatibilityAccess access) {
        return access != null && access.isExported();
    }

    public static boolean isRestricted(CompatibilityAccess access) {
        return access != null && access.isRestricted();
    }

    public static boolean isConcealed(CompatibilityAccess access) {
        return access != null && access.isConcealed();
    }

    public static boolean isExportedOrRestricted(CompatibilityAccess access) {
        return access != null && access.isExportedOrRestricted();
    }

    public static boolean isExportedOrNull(CompatibilityAccess access) {
        return access == null || access.isExported();
    }

    public static boolean isConcealedOrRestricted(CompatibilityAccess access) {
        return access != null && access.isConcealedOrRestricted();
    }

    public static boolean isConcealedOrNull(CompatibilityAccess access) {
        return access == null || access.isConcealed();
    }

    public static int ordinal(CompatibilityAccess access) {
        return access != null ? access.ordinal() : Integer.MAX_VALUE;
    }

    public static CompatibilityAccess enumeral(int ordinal) {
        switch (ordinal) {
            case 0: {
                return EXPORTED;
            }
            case 1: {
                return RESTRICTED;
            }
            case 2: {
                return CONCEALED;
            }
        }
        return null;
    }

    public static boolean isMoreExported(CompatibilityAccess left, CompatibilityAccess right) {
        return CompatibilityAccess.ordinal(left) < CompatibilityAccess.ordinal(right);
    }

    public static boolean isMoreConcealed(CompatibilityAccess left, CompatibilityAccess right) {
        return CompatibilityAccess.ordinal(left) > CompatibilityAccess.ordinal(right);
    }

    public static CompatibilityAccess mostExported(CompatibilityAccess left, CompatibilityAccess right) {
        return CompatibilityAccess.ordinal(left) < CompatibilityAccess.ordinal(right) ? left : right;
    }

    public static CompatibilityAccess mostConcealed(CompatibilityAccess left, CompatibilityAccess right) {
        return CompatibilityAccess.ordinal(left) < CompatibilityAccess.ordinal(right) ? right : left;
    }

    public static CompatibilityAccess mostExported(CompatibilityAccess ... values) {
        CompatibilityAccess access = values[0];
        int ordinal = CompatibilityAccess.ordinal(access);
        for (int i = 1; i < values.length; ++i) {
            CompatibilityAccess a = values[i];
            int o = CompatibilityAccess.ordinal(a);
            if (o >= ordinal) continue;
            ordinal = o;
            access = a;
        }
        return access;
    }

    public static CompatibilityAccess mostConcealed(CompatibilityAccess ... values) {
        CompatibilityAccess access = values[0];
        int ordinal = CompatibilityAccess.ordinal(access);
        for (int i = 1; i < values.length; ++i) {
            CompatibilityAccess a = values[i];
            int o = CompatibilityAccess.ordinal(a);
            if (o <= ordinal) continue;
            ordinal = o;
            access = a;
        }
        return access;
    }

    public static int compare(CompatibilityAccess left, CompatibilityAccess right) {
        return Integer.compare(CompatibilityAccess.ordinal(left), CompatibilityAccess.ordinal(right));
    }
}

