/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.tsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.tsp.MessageImprint;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public abstract class TSPMessage
implements Streamable {
    public void input(InputStream is) throws IOException {
        this.parseMessage(Utils.toBytes((Streamable)new ASN1Sequence(is)));
    }

    public void output(OutputStream os) throws IOException {
        os.write(this.getEncoded());
    }

    public int length() {
        try {
            return this.getEncoded().length;
        }
        catch (IOException ex) {
            return -1;
        }
    }

    public abstract MessageImprint getMessageImprint();

    protected abstract void parseMessage(byte[] var1) throws IOException;

    protected abstract byte[] getEncoded() throws IOException;
}

