/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicDisplay;

import java.util.HashMap;
import oracle.help.CustomProtocolHandler;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.ProtocolEvent;
import oracle.help.htmlBrowser.ProtocolListener;

public class CustomProtocolRegistry {
    private HashMap _customProtocolHandlers;
    private CustomProtocolListener _customProtocolListener;

    public CustomProtocolRegistry() {
    }

    public CustomProtocolRegistry(HTMLBrowser browser) {
        this.attachBrowser(browser);
    }

    public void attachBrowser(HTMLBrowser browser) {
        browser.addProtocolListener(new CustomProtocolListener());
    }

    public void registerCustomProtocolHandler(String customProtocol, CustomProtocolHandler handler) {
        if (this._customProtocolHandlers == null) {
            this._customProtocolHandlers = new HashMap();
        }
        if (customProtocol.indexOf(":") != -1) {
            throw new IllegalArgumentException("customProtocol string must not contain \":\"");
        }
        this._customProtocolHandlers.put(customProtocol, handler);
    }

    public CustomProtocolHandler getCustomProtocolHandler(String customProtocol) {
        if (this._customProtocolHandlers == null) {
            return null;
        }
        return (CustomProtocolHandler)this._customProtocolHandlers.get(customProtocol);
    }

    private class CustomProtocolListener
    implements ProtocolListener {
        private CustomProtocolListener() {
        }

        @Override
        public void protocolReceived(ProtocolEvent event) {
            String linkID;
            int colonIndex;
            if (2003 == event.getLinkType() && (colonIndex = (linkID = event.getLinkID()).indexOf(":")) != -1 && colonIndex != linkID.length() - 1) {
                CustomProtocolHandler protocolHandler;
                String customProtocol = linkID.substring(0, colonIndex);
                String value = linkID.substring(colonIndex + 1);
                if (CustomProtocolRegistry.this._customProtocolHandlers != null && (protocolHandler = (CustomProtocolHandler)CustomProtocolRegistry.this._customProtocolHandlers.get(customProtocol)) != null) {
                    protocolHandler.handleValue(value);
                }
            }
        }
    }
}

