/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicDisplay;

import java.awt.Point;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.JPanel;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.AssociativeLink;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.WindowType;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.ProtocolEvent;
import oracle.help.htmlBrowser.ProtocolListener;
import oracle.help.htmlBrowser.URLEvent;
import oracle.help.htmlBrowser.URLListener;
import oracle.help.library.Library;
import oracle.help.topicDisplay.TopicDisplay;
import oracle.help.topicDisplay.TopicDisplayEvent;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.help.topicDisplay.TopicDisplayListener;
import oracle.help.topicDisplay.popup.ALinkPopup;
import oracle.help.topicDisplay.popup.HTMLPopupWindow;
import oracle.help.topicDisplay.print.BrowserPrintJob;
import oracle.help.topicDisplay.print.TopicPrintJob;

public class BrowserTopicDisplay
implements TopicDisplay,
URLListener,
ProtocolListener {
    private URL _currentURL;
    private WindowType _currentWindowType;
    private Library _library;
    private HTMLBrowser _browser;
    private ListenerManager _listeners;

    public BrowserTopicDisplay(HTMLBrowser browser) {
        this(browser, null);
    }

    public BrowserTopicDisplay(HTMLBrowser browser, Library library) {
        if (browser == null) {
            throw new IllegalArgumentException("BrowserTopicDisplayPanel:  HTMLBrowser parameter to constructor cannot be null");
        }
        this._browser = browser;
        this._browser.addURLListener(this);
        this._browser.addProtocolListener(this);
        this._currentURL = null;
        this._listeners = new ListenerManager();
        this._library = library;
    }

    @Override
    public void displayTopic(Topic topic) throws TopicDisplayException {
        URL url = null;
        if (topic != null) {
            if (topic.hasTarget()) {
                try {
                    Target theTarget = topic.getTarget();
                    url = theTarget.getURL();
                }
                catch (Exception e) {
                    throw new TopicDisplayException("BrowserTopicDisplay:  Target URL is Malformed");
                }
            } else {
                throw new TopicDisplayException("BrowserTopicDisplay:  Cannot display Topic (Topic has no target)");
            }
        }
        this.setBrowserURL(url);
    }

    @Override
    public TopicPrintJob getTopicPrintJob() {
        if (this._browser.isPrintingSupported()) {
            return new BrowserPrintJob(this._browser);
        }
        return null;
    }

    @Override
    public URL getCurrentURL() {
        return this._currentURL;
    }

    @Override
    public void runFindDialog() {
        this._browser.runFindDialog();
    }

    @Override
    public JPanel getDisplayContainer() {
        return this._browser.getHTMLContainer();
    }

    @Override
    public void clear() {
        this._currentURL = null;
        this._currentWindowType = null;
        this._browser.clear();
    }

    @Override
    public void dispose() {
        this._browser.removeURLListener(this);
        this._browser.removeProtocolListener(this);
        this._browser.dispose();
        this._currentURL = null;
        this._currentWindowType = null;
        this._library = null;
        this._browser = null;
        this._listeners = null;
    }

    @Override
    public void addDisplayListener(TopicDisplayListener listener) {
        if (listener != null) {
            this._listeners.addListener((EventListener)listener);
        }
    }

    @Override
    public void removeDisplayListener(TopicDisplayListener listener) {
        if (listener != null) {
            this._listeners.removeListener((EventListener)listener);
        }
    }

    @Override
    public void urlChanged(URLEvent event) {
        this._handleURLEvent(event);
    }

    @Override
    public void anchorChanged(URLEvent event) {
        this._handleURLEvent(event);
    }

    @Override
    public void protocolReceived(ProtocolEvent e) {
        if (e.getLinkType() != 2003) {
            if (this._library != null) {
                String link = e.getLinkID();
                Point where = e.getPoint();
                if (e.getLinkType() == 2000) {
                    AssociativeLink aLink = this._library.getAssociativeLink(link);
                    ALinkPopup popup = new ALinkPopup(aLink, where, this.getDisplayContainer());
                    popup.setVisible(true);
                    Topic aTopic = popup.getSelectedTopic();
                    popup.dispose();
                    if (aTopic != null) {
                        this.displayTopic(aTopic);
                    }
                } else if (e.getLinkType() == 2001) {
                    URL topicURL = this._library.mapIDToURL(link);
                    if (topicURL != null) {
                        HTMLPopupWindow hTMLPopupWindow = new HTMLPopupWindow(this, this._browser.getClass(), topicURL, where, this.getDisplayContainer());
                    } else {
                        System.err.println("Error: topic id " + link + " does not map to an URL.");
                    }
                } else if (e.getLinkType() == 2002) {
                    URL topicURL = this._library.mapIDToURL(link);
                    if (topicURL != null) {
                        this.setBrowserURL(topicURL);
                    } else {
                        System.err.println("Error: topic id " + link + " does not map to an URL.");
                    }
                }
            } else {
                throw new TopicDisplayException("ERROR:  OHJ specific protocol encountered.  You must associate a Library with the BrowserTopicDisplay during construction to use OHJ's special protocols.");
            }
        }
    }

    public void setBrowserURL(URL url) {
        if (url == null) {
            throw new TopicDisplayException("BrowserTopicDisplay:  Error Displaying Topic");
        }
        String urlString = url.toString();
        boolean hasAnchor = false;
        if (urlString.indexOf("#") != -1) {
            hasAnchor = true;
        }
        if (!url.equals(this._currentURL) || hasAnchor) {
            this._currentURL = url;
            this.handleWindowType(url);
            this._browser.setURL(url);
        }
    }

    @Override
    public boolean canGoBack() {
        return this._browser.canGoBack();
    }

    @Override
    public void goBack() {
        this._browser.goBack();
    }

    @Override
    public boolean canGoForward() {
        return this._browser.canGoForward();
    }

    @Override
    public void goForward() {
        this._browser.goForward();
    }

    @Override
    public String getSelectedText() {
        return this._browser.getSelectedText();
    }

    @Override
    public void increaseFontSize() {
        this._browser.increaseFontSize();
    }

    @Override
    public void decreaseFontSize() {
        this._browser.decreaseFontSize();
    }

    @Override
    public void selectAll() {
        this._browser.selectAll();
    }

    @Override
    public String getCurrentPageTitle() {
        return this._browser.getCurrentPageTitle();
    }

    private void handleWindowType(URL url) {
        WindowType winType;
        if (this._library != null && url != null && this._currentWindowType != (winType = this._library.mapURLToWindowType(url))) {
            this._currentWindowType = winType;
            TopicDisplayEvent winTypeEvent = new TopicDisplayEvent(this, 2000, 1, this._currentURL, this._currentWindowType);
            this._fireTopicDisplayEvent(winTypeEvent);
        }
    }

    private void _handleURLEvent(URLEvent event) {
        if (event != null) {
            String anchor = event.getAnchor();
            if (event.getID() == 2000 || event.getID() == 2001) {
                this._currentURL = event.getURL();
                if (event.getID() == 2000) {
                    this.handleWindowType(this._currentURL);
                    if (this._currentWindowType != null) {
                        if (this._currentWindowType.getPageBG() != null) {
                            this._browser.setDefaultBackground(this._currentWindowType.getPageBG());
                        }
                        if (this._currentWindowType.getTextFG() != null) {
                            this._browser.setDefaultTextForeground(this._currentWindowType.getTextFG());
                        }
                        if (this._currentWindowType.getLinkFG() != null) {
                            this._browser.setDefaultLinkForeground(this._currentWindowType.getLinkFG());
                        }
                    }
                }
                this._fireTopicDisplayEvent(new TopicDisplayEvent(this, 2000, 0, this._currentURL, this._currentWindowType, anchor));
            }
        }
    }

    private void _fireTopicDisplayEvent(TopicDisplayEvent event) {
        Enumeration listenEnum = this._listeners.getListeners();
        if (listenEnum != null) {
            while (listenEnum.hasMoreElements()) {
                TopicDisplayListener l = (TopicDisplayListener)listenEnum.nextElement();
                l.topicDisplayChanged(event);
            }
        }
    }
}

