/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.keywordNavigator;

import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.Collections;
import java.util.List;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.StringComparator;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.navigator.keywordNavigator.KeywordIndexItem;
import oracle.help.common.navigator.keywordNavigator.TopicBaseBean;
import oracle.help.common.util.java.StaticLocaleContext;

public class KeywordIndexItemAdapter
extends SortableTwoDModel
implements HeaderItemInputHandler {
    private int lastColumnClicked = -1;
    private boolean invertSort = false;
    private KeywordIndexItem _indexItem = null;
    public static final int COLUMN_TITLE = 0;
    public static final int COLUMN_SOURCE = 1;

    public KeywordIndexItemAdapter() {
        super(2, 0);
        super.setColumnComparator(0, (Comparator)new EntryTitleComparator());
        super.setColumnComparator(1, (Comparator)new EntryViewComparator());
    }

    public void setCurrentKeywordIndexItem(KeywordIndexItem kii) {
        int initLength;
        if (kii == this._indexItem) {
            return;
        }
        if (this._indexItem != null) {
            this._indexItem.clearEntries();
        }
        if ((initLength = super.getRowCount()) > 0) {
            super.removeRows(0, initLength);
        }
        this._indexItem = kii;
        if (this._indexItem != null) {
            List entries = this._indexItem.getEntries();
            int curRow = super.getRowCount();
            super.addRows(curRow, entries.size());
            for (TopicBaseBean cur : entries) {
                super.setData(0, curRow, (Object)cur.getTopic());
                super.setData(1, curRow++, (Object)cur.getTopicTreeNode().getView());
            }
        }
    }

    public KeywordIndexItem getKeywordIndexItem() {
        return this._indexItem;
    }

    public List getEntries() {
        if (this._indexItem == null) {
            return Collections.EMPTY_LIST;
        }
        return this._indexItem.getEntries();
    }

    public Object getData(int column, int row) {
        Object data = super.getData(column, row);
        if (data != null) {
            if (column == 0) {
                Topic aTopic = (Topic)data;
                return aTopic.getLabel();
            }
            if (column == 1) {
                View source = (View)data;
                String title = source.getTitle();
                if (title == null) {
                    title = new String("");
                }
                return title;
            }
        }
        return null;
    }

    public void mouseClicked(MouseEvent e, Header header, int itemIndex) {
        this.invertSort = itemIndex == this.lastColumnClicked ? !this.invertSort : false;
        this.lastColumnClicked = itemIndex;
        this.sort(itemIndex, !this.invertSort);
    }

    public void mousePressed(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseDragged(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseExited(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseMoved(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseReleased(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseEntered(MouseEvent e, Header header, int itemIndex) {
    }

    class EntryViewComparator
    extends StringComparator {
        EntryViewComparator() {
            super(Collator.getInstance(StaticLocaleContext.getLocale()));
        }

        public int compare(Object o1, Object o2) {
            View view1 = (View)o1;
            View view2 = (View)o2;
            return super.compare((Object)view1.getTitle(), (Object)view2.getTitle());
        }
    }

    class EntryTitleComparator
    extends StringComparator {
        EntryTitleComparator() {
            super(Collator.getInstance(StaticLocaleContext.getLocale()));
        }

        public int compare(Object o1, Object o2) {
            Topic item1 = (Topic)o1;
            Topic item2 = (Topic)o2;
            String title1 = item1.getLabel();
            String title2 = item2.getLabel();
            return super.compare((Object)title1, (Object)title2);
        }
    }
}

