/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.util;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.MnemonicUtils;
import oracle.help.java.util.Version;

public class AboutBox
extends JDialog
implements ActionListener {
    private static final String _KEY_CLOSE = "CLOSE";
    public static final String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private JButton _okButton;

    public AboutBox(Frame parent) {
        super(parent);
        this.setModal(true);
        ResourceBundle bundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        this.setTitle(bundle.getString("aboutbox.title"));
        JPanel center = new JPanel();
        center.setBorder(new EmptyBorder(10, 10, 10, 10));
        center.setLayout(new GridLayout(0, 1, 4, 4));
        center.add(new JLabel(bundle.getString("aboutbox.namestring"), 0));
        center.add(new JLabel(Version.getVersion(), 0));
        String copyrightPattern = bundle.getString("aboutbox.copyright.pattern");
        center.add(new JLabel(this._getCopyright(copyrightPattern), 0));
        this.getContentPane().add((Component)center, "Center");
        DialogButtonBar south = new DialogButtonBar();
        south.setBorder((Border)new EmptyBorder(0, 10, 10, 10));
        this._okButton = MnemonicUtils.createButton(bundle.getString("aboutbox.ok"));
        this._okButton.addActionListener(this);
        south.add((Component)this._okButton);
        this.getContentPane().add((Component)south, "South");
        this.addWindowListener(new AboutBoxCloser());
        JRootPane rootPane = this.getRootPane();
        rootPane.registerKeyboardAction(this, _KEY_CLOSE, KeyStroke.getKeyStroke(27, 0), 1);
        this.validate();
        this.pack();
        WindowUtils.centerWindow((Window)this, (Component)parent);
        this.setMinimumSize(this.getPreferredSize());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._okButton || _KEY_CLOSE.equals(e.getActionCommand())) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private String _getCopyright(String copyrightPattern) {
        StringBuffer result = new StringBuffer();
        String year = String.valueOf(new GregorianCalendar().get(1));
        try {
            MessageFormat copyFormat = new MessageFormat(copyrightPattern, StaticLocaleContext.getLocale());
            Object[] objs = new Object[]{year};
            copyFormat.format(objs, result, (FieldPosition)null);
        }
        catch (RuntimeException e) {
            result = new StringBuffer();
            result.append("Copyright \u00a9 1995-");
            result.append(year);
            result.append(", Oracle.");
        }
        return result.toString();
    }

    private class AboutBoxCloser
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent event) {
            AboutBox.this.setVisible(false);
            AboutBox.this.dispose();
        }
    }
}

