/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.tree;

import java.awt.Point;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDeferringRoot;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.TopicTreeNode;
import oracle.help.java.tree.TopicTreeEvent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeModel;
import oracle.help.java.tree.TreeComponentPopupListener;

public class TopicTreeComponent
extends DTree {
    private TopicTreeNode _rootTopicTreeNode;
    private DTreeDeferringRoot _root;
    private ListenerManager _listeners;
    private TopicTreeNode _queuedSelection;

    public TopicTreeComponent(TopicTreeNode root, DTreeItemFactory factory) {
        this._rootTopicTreeNode = root;
        this._listeners = new ListenerManager();
        this._queuedSelection = null;
        this._root = new DTreeDeferringRoot(null, null, (OneDModel)new TopicTreeModel(root), factory);
        this.setRoot((DTreeRootItem)this._root);
    }

    public boolean selectTopicTreeNode(TopicTreeNode node) {
        boolean found = false;
        if (this.isVisible()) {
            if (node != null) {
                this._selectNode(node);
                found = true;
            } else {
                this._deselectAll();
            }
        } else {
            this._queuedSelection = node;
        }
        return found;
    }

    public void addPopupRequestListener(TreeComponentPopupListener listener) {
        if (listener != null) {
            this._listeners.addListener((EventListener)listener);
        }
    }

    public void removePopupRequestListener(TreeComponentPopupListener listener) {
        if (listener != null) {
            this._listeners.removeListener((EventListener)listener);
        }
    }

    public void setVisible(boolean aFlag) {
        if (aFlag) {
            super.setVisible(true);
            if (this._queuedSelection == null) {
                this._deselectAll();
            } else {
                this._selectNode(this._queuedSelection);
            }
        } else {
            this._queuedSelection = this._getCurrentSelection();
            super.setVisible(false);
        }
    }

    public void firePopupRequested(TopicTreeEvent evt, Point location) {
        Enumeration listeners = this._listeners.getListeners();
        if (listeners != null) {
            while (listeners.hasMoreElements()) {
                TreeComponentPopupListener l = (TreeComponentPopupListener)listeners.nextElement();
                l.popupRequested(evt, location);
            }
        }
    }

    private void _deselectAll() {
        try {
            this.setSelection(new DTreeSelection());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private TopicTreeNode _getCurrentSelection() {
        TopicTreeNode currentSel = null;
        if (this.isVisible()) {
            DTreeSelection selection = this.getSelection();
            if (selection.getCount() != 0) {
                TopicTreeItem anItem = (TopicTreeItem)selection.getFirstItem();
                currentSel = anItem.getTopicTreeNode();
            }
        } else {
            currentSel = this._queuedSelection;
        }
        return currentSel;
    }

    private synchronized void _selectNode(TopicTreeNode node) {
        if (node != null) {
            this._recursiveExpansion(node.getParent());
            DTreeItem visualItem = (DTreeItem)node.getClientData();
            if (visualItem != null) {
                this.makeVisible(visualItem);
                try {
                    this.getSelectionManager().selectItem(visualItem);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void _recursiveExpansion(TopicTreeNode node) {
        if (node != null) {
            this._recursiveExpansion(node.getParent());
            DTreeItem visualItem = (DTreeItem)node.getClientData();
            if (visualItem != null) {
                visualItem.setExpanded(true);
                int count = visualItem.getItemCount();
                for (int i = 0; i < count; ++i) {
                    DTreeItem dTreeItem = visualItem.getItem(i);
                }
            }
        }
    }
}

