/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.ewt.help.HelpProvider;
import oracle.help.AppletWindowManager;
import oracle.help.CustomProtocolHandler;
import oracle.help.DefaultNavigatorPanel;
import oracle.help.DefaultWindowManager;
import oracle.help.WindowManager;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.protocol.DefaultExternalProtocolHandler;
import oracle.help.java.util.ImageLoader;
import oracle.help.library.Book;
import oracle.help.library.Library;
import oracle.help.library.LibraryException;
import oracle.help.navigator.Navigator;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.NavigatorException;
import oracle.help.navigator.NavigatorListener;
import oracle.help.navigator.NavigatorTabPanel;
import oracle.help.navigator.favoritesNavigator.DefaultFavoritesModel;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.navigator.favoritesNavigator.FavoritesNavigator;
import oracle.help.topicDisplay.TopicDisplayException;

public class Help
implements oracle.bali.ewt.help.HelpProvider,
HelpProvider,
NavigatorListener {
    private ArrayList _tabPanels;
    private Library _library;
    private boolean _useLabelInfo;
    private boolean _combineBooks;
    private boolean _dockedByDefault = false;
    private boolean _addedFavNav = false;
    private DefaultNavigatorPanel _navigatorWindowPanel;
    private WindowManager _windowManager;
    private Book _defaultBook;
    private String _defaultTopicID;
    private FavoritesModel _favoritesModel;
    private static final String _defaultExternalProtocol = "external";

    public Help() {
        this(true, false);
    }

    public Help(Class htmlBrowserClass) {
        this(htmlBrowserClass, true, false);
    }

    public Help(AppletContext appletContext, String targetFrame) {
        this(appletContext, targetFrame, true, false);
    }

    public Help(boolean combineBooks, boolean useLabelInfo) {
        this(combineBooks, useLabelInfo, false);
    }

    public Help(boolean combineBooks, boolean useLabelInfo, boolean dockedByDefault) {
        Class<?> htmlBrowserClass = null;
        try {
            htmlBrowserClass = Class.forName("oracle.help.htmlBrowser.ICEBrowser");
        }
        catch (Exception e) {
            htmlBrowserClass = null;
            System.err.println("Help : Failed to load ICEBrowser");
            e.printStackTrace();
        }
        if (htmlBrowserClass != null) {
            this._initHelpSystem(htmlBrowserClass, null, null, combineBooks, useLabelInfo, false, dockedByDefault);
            this.registerCustomProtocolHandler(_defaultExternalProtocol, new DefaultExternalProtocolHandler());
        }
    }

    public Help(Class htmlBrowserClass, boolean combineBooks, boolean useLabelInfo) {
        this(htmlBrowserClass, combineBooks, useLabelInfo, false);
    }

    public Help(Class htmlBrowserClass, boolean combineBooks, boolean useLabelInfo, boolean standAloneMode) {
        this(htmlBrowserClass, combineBooks, useLabelInfo, standAloneMode, false);
    }

    public Help(Class htmlBrowserClass, boolean combineBooks, boolean useLabelInfo, boolean standAloneMode, boolean dockedByDefault) {
        if (htmlBrowserClass == null) {
            throw new IllegalArgumentException("Help: Cannot instantiate Help with null htmlBrowserClass");
        }
        this._initHelpSystem(htmlBrowserClass, null, null, combineBooks, useLabelInfo, standAloneMode, dockedByDefault);
        this.registerCustomProtocolHandler(_defaultExternalProtocol, new DefaultExternalProtocolHandler());
    }

    public Help(AppletContext appletContext, String targetFrame, boolean combineBooks, boolean useLabelInfo) {
        if (appletContext == null) {
            throw new IllegalArgumentException("Help: Cannot instantiate Help with null appletContext");
        }
        this._initHelpSystem(null, appletContext, targetFrame, combineBooks, useLabelInfo, false, false);
        this.registerCustomProtocolHandler(_defaultExternalProtocol, new DefaultExternalProtocolHandler());
    }

    public static void setHelpLocale(Locale helpLocale) {
        StaticLocaleContext.setLocale((Locale)helpLocale);
    }

    public static Locale getHelpLocale() {
        return StaticLocaleContext.getLocale();
    }

    public static void setHelpEncoding(String helpEncoding) {
        StaticLocaleContext.setEncoding((String)helpEncoding);
    }

    public static String getHelpEncoding() {
        return StaticLocaleContext.getEncoding();
    }

    public void setIconImage(Image iconImage) {
        ImageLoader.setIconImage(iconImage);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this._windowManager.showNavigatorWindow();
        } else {
            this._windowManager.hideAllWindows();
        }
    }

    public void addBook(Book book) {
        try {
            this._library.addBook(book);
        }
        catch (LibraryException e) {
            System.err.println(e.getMessage());
            return;
        }
        this._createNavigatorsForBook(book);
    }

    public void removeBook(Book book) {
        try {
            this._library.removeBook(book);
        }
        catch (LibraryException e) {
            System.err.println(e.getMessage());
        }
    }

    public void removeAllBooks() {
        int iter = 0;
        Book[] books = this._library.getBooks();
        if (books != null) {
            for (iter = 0; iter < books.length; ++iter) {
                this.removeBook(books[iter]);
            }
        }
    }

    public Book[] getBooks() {
        return this._library.getBooks();
    }

    public int getBookCount() {
        return this._library.getBookCount();
    }

    public static void registerClientWindow(Window aWindow) {
        WindowUtils.registerWindow((Window)aWindow);
    }

    public static void unregisterClientWindow(Window aWindow) {
        WindowUtils.unregisterWindow((Window)aWindow);
    }

    public void registerCustomProtocolHandler(String customProtocol, CustomProtocolHandler handler) {
        if (this._windowManager != null) {
            this._windowManager.registerCustomProtocolHandler(customProtocol, handler);
        } else {
            System.err.println("Attempting to registerCustomProtocolHandler before WindowManager creation");
        }
    }

    public void showNavigatorWindow() {
        this._windowManager.showNavigatorWindow();
    }

    public void showNavigatorWindow(Navigator activeNavigator) {
        if (activeNavigator != null) {
            this._navigatorWindowPanel.setActiveNavigator(activeNavigator);
        }
        this._windowManager.showNavigatorWindow();
    }

    public void showNavigatorWindow(Book activeBook) {
        NavigatorTabPanel tabPanelForBook = null;
        if (activeBook != null) {
            for (int iter = 0; iter < this._tabPanels.size() && tabPanelForBook == null; ++iter) {
                NavigatorTabPanelInfo anInfo = (NavigatorTabPanelInfo)this._tabPanels.get(iter);
                if (anInfo.book != activeBook) continue;
                tabPanelForBook = anInfo.tabPanel;
            }
        }
        if (tabPanelForBook != null) {
            this._navigatorWindowPanel.setActiveNavigatorTabPanel(tabPanelForBook);
        }
        this._windowManager.showNavigatorWindow();
    }

    public Navigator[] getAllNavigators() {
        return this._navigatorWindowPanel.getAllNavigators();
    }

    public void showTopic(Book book, String topicID) throws TopicDisplayException {
        this.showTopic(book, topicID, false);
    }

    public void showTopic(Book book, String topicID, boolean alwaysCreate) throws TopicDisplayException {
        this.showTopic(book, topicID, alwaysCreate, null, null);
    }

    public void showTopic(Book book, String topicID, boolean alwaysCreate, Point location, Dimension size) throws TopicDisplayException {
        URL topicURL;
        if (topicID != null) {
            topicURL = this._library.mapIDToURL(topicID);
            if (topicURL == null) {
                throw new TopicDisplayException("Cannot Display Topic: Topic ID " + topicID + " not found.");
            }
        } else {
            throw new TopicDisplayException("Cannot Display Topic:: Topic ID parameter was null");
        }
        SimpleURLTarget theTarget = new SimpleURLTarget(null, topicURL.toString());
        SimpleTopic theTopic = new SimpleTopic(null, (Target)theTarget, null);
        this._windowManager.displayTopic((Topic)theTopic, alwaysCreate, location, size);
    }

    @Override
    public void showHelp(Object book, String topicID, Component object) {
        if (book == null) {
            book = this._defaultBook;
        }
        if (topicID == null) {
            topicID = this._defaultTopicID;
        }
        if (book == null || topicID == null) {
            this.showNavigatorWindow();
        } else {
            this.showTopic((Book)book, topicID);
        }
    }

    public void showHelp(Component component) {
        String topicID = null;
        Book aBook = null;
        if (component != null) {
            topicID = HelpUtils.getHelpID((Component)component);
            aBook = (Book)HelpUtils.getHelpSet((Component)component);
        }
        if (topicID == null) {
            this.showNavigatorWindow();
        } else {
            this.showTopic(aBook, topicID);
        }
    }

    public void setHelpOnHelp(URL helpOnHelpURL) {
        if (helpOnHelpURL == null) {
            throw new IllegalArgumentException("Help::setHelpOnHelp() url parameter must be non-null");
        }
        SimpleURLTarget helpTarget = new SimpleURLTarget(null, helpOnHelpURL.toString());
        SimpleTopic helpTopic = new SimpleTopic("", (Target)helpTarget, null);
        this._navigatorWindowPanel.setHelpOnHelpTopic((Topic)helpTopic);
    }

    public void setHelpOnHelp(Book book, String topicID) {
        if (book == null || topicID == null) {
            throw new IllegalArgumentException("Help::setHelpOnHelp() both parameters must be non-null");
        }
        IndirectTarget helpTarget = new IndirectTarget(book, topicID);
        SimpleTopic helpTopic = new SimpleTopic("", (Target)helpTarget, book);
        this._navigatorWindowPanel.setHelpOnHelpTopic((Topic)helpTopic);
    }

    public void setDefaultBook(Book book) {
        this._defaultBook = book;
    }

    public void setDefaultTopicID(String topicID) {
        this._defaultTopicID = topicID;
    }

    public void dispose() {
        if (this._library != null) {
            this.removeAllBooks();
            this._library = null;
        }
        if (this._navigatorWindowPanel != null) {
            this._navigatorWindowPanel.removeNavigatorWindowListener(this);
            this._navigatorWindowPanel = null;
        }
        if (this._windowManager != null) {
            this._windowManager.dispose();
            this._windowManager = null;
        }
        this._defaultBook = null;
        this._defaultTopicID = null;
        this._tabPanels.clear();
        this._tabPanels = null;
    }

    @Override
    public void topicSelected(NavigatorEvent e) {
    }

    @Override
    public void topicActivated(NavigatorEvent e) {
        try {
            if (e.getTopic() != null) {
                Topic aTopic = e.getTopic();
                boolean newWindow = false;
                if (e.getMode() == 2) {
                    newWindow = true;
                }
                if (aTopic.hasTarget()) {
                    this._windowManager.displayTopic(aTopic, newWindow, null, null);
                }
            }
        }
        catch (Exception error) {
            System.err.println(error.getMessage());
        }
    }

    public void enableFavoritesNavigator(URL location) {
        if (this._favoritesModel == null) {
            if (location == null) {
                throw new IllegalArgumentException("Null location for favorites.xml");
            }
            this._favoritesModel = new DefaultFavoritesModel(location, this._library);
            try {
                for (int i = 0; i < this._tabPanels.size(); ++i) {
                    NavigatorTabPanelInfo info = (NavigatorTabPanelInfo)this._tabPanels.get(i);
                    FavoritesNavigator favoritesNav = (FavoritesNavigator)Navigator.createNavigator(FavoritesNavigator.class.getName(), null, null);
                    favoritesNav.setFavoritesModel(this._favoritesModel);
                    info.tabPanel.addNavigator(favoritesNav);
                }
            }
            catch (NavigatorException e) {
                e.printStackTrace();
            }
            this._windowManager.setFavoritesModel(this._favoritesModel);
            this._addedFavNav = true;
        } else {
            System.err.println("Error: enableFavoritesNavigator invoked multiple times");
        }
    }

    private void _initHelpSystem(Class htmlBrowser, AppletContext appletContext, String targetFrame, boolean combineBooks, boolean useLabelInfo, boolean standAloneMode, boolean dockedByDefault) {
        this._defaultBook = null;
        this._defaultTopicID = null;
        this._useLabelInfo = useLabelInfo;
        this._dockedByDefault = dockedByDefault;
        this._combineBooks = combineBooks;
        this._tabPanels = new ArrayList();
        this._library = new Library();
        this._navigatorWindowPanel = new DefaultNavigatorPanel();
        this._navigatorWindowPanel.addNavigatorWindowListener(this);
        if (htmlBrowser != null) {
            this._windowManager = new DefaultWindowManager(htmlBrowser, this._navigatorWindowPanel, this._library, standAloneMode, dockedByDefault);
        } else if (appletContext != null) {
            this._windowManager = new AppletWindowManager(appletContext, targetFrame, this._navigatorWindowPanel, this._library);
        } else {
            throw new IllegalArgumentException("ERROR:  Must have non-null htmlBrowserClass or appletContext to instantiate Help object.");
        }
    }

    private void _createNavigatorsForBook(Book book) {
        int iter;
        NavigatorTabPanelInfo anInfo;
        if (book == null) {
            return;
        }
        View[] bookViews = book.getAllViews();
        if (bookViews == null) {
            return;
        }
        NavigatorTabPanel tabPanelForBook = null;
        if (this._combineBooks) {
            if (this._tabPanels.size() > 0) {
                anInfo = (NavigatorTabPanelInfo)this._tabPanels.get(0);
                tabPanelForBook = anInfo.tabPanel;
            }
        } else {
            for (iter = 0; iter < this._tabPanels.size() && tabPanelForBook == null; ++iter) {
                anInfo = (NavigatorTabPanelInfo)this._tabPanels.get(iter);
                if (anInfo.book != book) continue;
                tabPanelForBook = anInfo.tabPanel;
            }
        }
        if (tabPanelForBook == null) {
            tabPanelForBook = new NavigatorTabPanel();
            this._navigatorWindowPanel.addNavigatorTabPanel(tabPanelForBook, book.getBookTitle());
            this._tabPanels.add(new NavigatorTabPanelInfo(tabPanelForBook, book));
        }
        for (iter = 0; iter < bookViews.length; ++iter) {
            View aView = bookViews[iter];
            this._createNavigatorForView(tabPanelForBook, aView);
        }
        if (!(this._favoritesModel == null || this._combineBooks && this._addedFavNav)) {
            try {
                FavoritesNavigator favoritesNav = (FavoritesNavigator)Navigator.createNavigator(FavoritesNavigator.class.getName(), null, null);
                favoritesNav.setFavoritesModel(this._favoritesModel);
                tabPanelForBook.addNavigator(favoritesNav);
                this._addedFavNav = true;
            }
            catch (NavigatorException e) {
                e.printStackTrace();
            }
        }
    }

    private void _createNavigatorForView(NavigatorTabPanel tabPanel, View aView) {
        if (aView == null) {
            return;
        }
        Navigator navForView = null;
        Navigator[] currentNavs = tabPanel.getNavigators();
        if (currentNavs != null) {
            for (int iter = 0; navForView == null && iter < currentNavs.length; ++iter) {
                Navigator iterNav = currentNavs[iter];
                if (!iterNav.getType().equals(aView.getType())) continue;
                if (this._useLabelInfo) {
                    if (iterNav.getLabel() != null) {
                        if (!iterNav.getLabel().equals(aView.getLabel())) continue;
                        navForView = iterNav;
                        continue;
                    }
                    if (aView.getLabel() != null) continue;
                    navForView = iterNav;
                    continue;
                }
                navForView = iterNav;
            }
        }
        if (navForView == null) {
            String label = null;
            Image labelImage = null;
            if (this._useLabelInfo) {
                label = aView.getLabel();
            }
            if (aView.getLabelImage() != null) {
                try {
                    URL imageURL = aView.getLabelImage().getURL();
                    if (imageURL != null) {
                        labelImage = ImageLoader.loadImage(imageURL);
                    }
                }
                catch (Exception e) {
                    labelImage = null;
                }
            }
            try {
                navForView = Navigator.createNavigator(aView.getType(), label, labelImage);
                tabPanel.addNavigator(navForView);
            }
            catch (Exception e) {
                System.err.println("Could Not Create Navigator " + e.getMessage());
                e.printStackTrace();
                return;
            }
        }
        navForView.addView(aView);
    }

    private class NavigatorTabPanelInfo {
        public NavigatorTabPanel tabPanel;
        public Book book;

        public NavigatorTabPanelInfo(NavigatorTabPanel tabPanel, Book book) {
            this.tabPanel = tabPanel;
            this.book = book;
        }
    }
}

