/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.CustomProtocolHandler;
import oracle.help.DefaultNavigatorPanel;
import oracle.help.DefaultTopicPanel;
import oracle.help.WindowManager;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.WindowType;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.java.protocol.DefaultExternalProtocolHandler;
import oracle.help.library.Book;
import oracle.help.library.Library;
import oracle.help.library.helpset.HelpSet;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.topicDisplay.BrowserTopicDisplay;
import oracle.help.topicDisplay.CustomProtocolRegistry;
import oracle.help.topicDisplay.TopicDisplayEvent;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.help.topicDisplay.TopicDisplayListener;
import oracle.help.topicDisplay.print.TopicPrintJob;

public class DefaultWindowManager
implements WindowManager,
TopicDisplayListener {
    private static final String _EWT_WINDOWUTILS = "oracle.ewt.util.WindowUtils";
    private static final String _GET_ACTIVE_WINDOW_METHOD = "getActiveWindow";
    private static Method _ewtActiveWindowMethod = null;
    private DefaultTopicPanel _activePanel;
    private DefaultTopicPanel _dockedPanel;
    private DefaultNavigatorPanel _navigatorPanel;
    private Library _library;
    private HelpWindowTracker _windowTracker;
    private Dialog _modalOwner = null;
    private boolean _standAloneMode;
    private boolean _modalMode;
    private boolean _silentMode;
    private boolean _dockedByDefault = false;
    private boolean _dockOnNextShow = false;
    private boolean _homeIDDisplayAlreadyChecked = false;
    private boolean _shouldTryLoadingEwtWindowUtils = true;
    private Vector _workingPanels;
    private Vector _cachedPanels;
    private Class _htmlBrowserClass;
    private Rectangle _bounds = null;
    private CustomProtocolRegistry _cpr;
    private FavoritesModel _favoritesModel;

    public DefaultWindowManager(Class htmlBrowserClass, DefaultNavigatorPanel navigatorPanel, Library library) {
        this(htmlBrowserClass, navigatorPanel, library, false, false);
    }

    public DefaultWindowManager(Class htmlBrowserClass, DefaultNavigatorPanel navigatorPanel, Library library, boolean standAloneMode, boolean dockedByDefault) {
        this._standAloneMode = standAloneMode;
        this._dockedByDefault = dockedByDefault;
        this._workingPanels = new Vector();
        this._cachedPanels = new Vector();
        this._activePanel = null;
        this._htmlBrowserClass = htmlBrowserClass;
        this._navigatorPanel = navigatorPanel;
        this._navigatorPanel.setWindowManager(this);
        this._library = library;
        this._windowTracker = new HelpWindowTracker();
        this._modalMode = false;
        if (this._dockedByDefault) {
            this._dockOnNextShow = true;
        }
        this._cpr = new CustomProtocolRegistry();
    }

    @Override
    public void displayTopic(Topic aTopic, boolean newWindow, Point location, Dimension size) throws TopicDisplayException {
        DefaultTopicPanel topicPanel = this._setupTopicWindow(newWindow);
        Window topicWindow = topicPanel.getCurrentTopicWindow();
        try {
            if (aTopic.hasTarget()) {
                URL targetUrl = aTopic.getTarget().getURL();
                String windowName = this._library.mapURLToWindowTypeName(targetUrl);
                WindowType windowType = this._library.getWindowType(windowName);
                if ("external".equals(windowName) && windowType == null) {
                    CustomProtocolHandler protocolHandler = this._cpr.getCustomProtocolHandler("external");
                    if (protocolHandler == null) {
                        protocolHandler = new DefaultExternalProtocolHandler();
                    }
                    protocolHandler.handleValue(targetUrl.toExternalForm());
                    return;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (this._dockedPanel == null && this._dockOnNextShow) {
            this._dockOnNextShow = false;
            this._silentMode = true;
            topicPanel.dockTopicPanel();
            this._silentMode = false;
            topicWindow = null;
        }
        topicPanel.displayTopic(aTopic);
        if (topicPanel == this._dockedPanel) {
            this.showNavigatorWindow();
        }
        if (topicWindow != null) {
            if (location != null) {
                topicWindow.setLocation(location);
            }
            if (size != null) {
                topicWindow.setSize(size);
            }
            if (!topicWindow.isVisible() && !this._silentMode) {
                topicWindow.setVisible(true);
            }
            if (topicWindow.isVisible()) {
                this._ensureNotMinimized(topicWindow);
                topicWindow.toFront();
            }
        }
    }

    public Class getHTMLBrowser() {
        return this._htmlBrowserClass;
    }

    public DefaultTopicPanel getActivePanel() {
        if (this._activePanel == null) {
            this._activePanel = this._dockedPanel != null ? this._dockedPanel : (this._workingPanels.size() != 0 ? (DefaultTopicPanel)this._workingPanels.lastElement() : this.createTopicPanel());
        }
        return this._activePanel;
    }

    public synchronized DefaultTopicPanel createTopicPanel() {
        DefaultTopicPanel topicPanel = null;
        if (this._cachedPanels.size() != 0) {
            topicPanel = (DefaultTopicPanel)this._cachedPanels.lastElement();
            this._cachedPanels.removeElement(topicPanel);
            this._workingPanels.addElement(topicPanel);
        } else {
            HTMLBrowser browser = null;
            try {
                browser = (HTMLBrowser)this._htmlBrowserClass.newInstance();
                browser.setLocale(StaticLocaleContext.getLocale());
                if (StaticLocaleContext.getEncoding() != null) {
                    browser.setCharset(StaticLocaleContext.getEncoding());
                }
                this._cpr.attachBrowser(browser);
            }
            catch (Exception e) {
                System.err.println("Failed to create instance of " + this._htmlBrowserClass);
                System.err.println("Cannot create Topic Display");
                return null;
            }
            BrowserTopicDisplay topicDisplay = new BrowserTopicDisplay(browser, this._library);
            topicPanel = new DefaultTopicPanel(topicDisplay, this);
            this._workingPanels.addElement(topicPanel);
        }
        topicPanel.addDisplayListener(this);
        return topicPanel;
    }

    @Override
    public void showNavigatorWindow() {
        Window navWindow = this._setupNavigatorWindow();
        if (this._dockedPanel == null && this._dockOnNextShow) {
            DefaultTopicPanel panelToDock = this._setupTopicWindow(false);
            this._silentMode = true;
            panelToDock.dockTopicPanel();
            this._silentMode = false;
            this._dockOnNextShow = false;
            this._checkDisplayHomeIDPage();
        }
        if (!navWindow.isVisible() && !this._silentMode) {
            navWindow.setVisible(true);
        }
        if (navWindow.isVisible() && !this._modalMode) {
            this._ensureNotMinimized(navWindow);
            navWindow.toFront();
        }
    }

    @Override
    public void hideNavigatorWindow() {
        Window navigatorWindow = this._navigatorPanel.getCurrentNavigatorWindow();
        if (navigatorWindow != null && navigatorWindow.isVisible()) {
            navigatorWindow.setVisible(false);
        }
        if (navigatorWindow instanceof Dialog && !this._javaVersionEqualOrGreater(1, 4, 1)) {
            this._windowTracker.unregisterWindow(navigatorWindow);
            this._navigatorPanel.disposeNavigatorDialog();
        }
        this._checkStandAloneExit();
    }

    @Override
    public void hideAllWindows() {
        this.hideNavigatorWindow();
        for (int iter = this._workingPanels.size() - 1; iter >= 0; --iter) {
            DefaultTopicPanel aPanel = (DefaultTopicPanel)this._workingPanels.elementAt(iter);
            aPanel.reclaimTopicPanel();
        }
    }

    public void dockTopicPanel(DefaultTopicPanel panel) {
        if (panel != null) {
            Window navWindow = this._setupNavigatorWindow();
            if (this._dockedPanel != null) {
                this._dockedPanel.undockTopicPanel();
            }
            this._workingPanels.removeElement(panel);
            Window currentWindow = panel.getCurrentTopicWindow();
            if (currentWindow != null) {
                this._windowTracker.unregisterWindow(currentWindow);
                if (currentWindow instanceof Dialog) {
                    panel.disposeTopicDialog();
                } else {
                    panel.disposeTopicFrame();
                }
            }
            this._navigatorPanel.dockTopicPanel(panel);
            this._windowTracker.registerWindow(navWindow, panel);
            this._dockedPanel = panel;
            this._activePanel = panel;
            if (!this._silentMode) {
                this.showNavigatorWindow();
            }
        }
    }

    public void undockTopicPanel() {
        if (this._dockedPanel != null) {
            Dimension dockedSize = this._dockedPanel.getSize();
            this._navigatorPanel.undockTopicPanel();
            Window navWindow = this._navigatorPanel.getCurrentNavigatorWindow();
            if (navWindow != null && navWindow.isVisible()) {
                this._workingPanels.addElement(this._dockedPanel);
                Dimension navWindowSize = navWindow.getSize();
                Dimension navPanelSize = this._navigatorPanel.getSize();
                Window topicWindow = null;
                topicWindow = navWindow instanceof Dialog ? this._dockedPanel.createTopicWindowDialog(this._getActiveModalOwnerDialog()) : this._dockedPanel.createTopicWindowFrame();
                this._windowTracker.unregisterWindow(navWindow);
                this._windowTracker.registerWindow(topicWindow, this._dockedPanel);
                int newWidth = dockedSize.width + (navWindowSize.width - navPanelSize.width);
                int newHeight = dockedSize.height + (navWindowSize.height - navPanelSize.height);
                topicWindow.setSize(newWidth, newHeight);
                topicWindow.setLocation(navWindow.getLocation().x + navWindowSize.width + 20, navWindow.getLocation().y);
                if (!this._silentMode) {
                    topicWindow.setVisible(true);
                }
            } else {
                this._dockedPanel.reclaimTopicPanel();
            }
            this._dockedPanel = null;
        }
    }

    @Override
    public void topicDisplayChanged(TopicDisplayEvent e) {
        if (e != null && e.getID() == 2000 && e.getChangeType() == 0) {
            this._synchronizeNavigators(e.getURL());
        }
    }

    @Override
    public synchronized void dispose() {
        int iter;
        if (this._dockedPanel != null) {
            this._dockedPanel.undockTopicPanel();
        }
        this._navigatorPanel.dispose();
        for (iter = 0; iter < this._workingPanels.size(); ++iter) {
            DefaultTopicPanel aPanel = (DefaultTopicPanel)this._workingPanels.elementAt(iter);
            aPanel.dispose();
        }
        for (iter = 0; iter < this._cachedPanels.size(); ++iter) {
            DefaultTopicPanel cachedPanel = (DefaultTopicPanel)this._cachedPanels.elementAt(iter);
            cachedPanel.dispose();
        }
        this._cachedPanels.removeAllElements();
        this._workingPanels.removeAllElements();
        this._activePanel = null;
        this._htmlBrowserClass = null;
        this._library = null;
        this._navigatorPanel = null;
        this._windowTracker = null;
    }

    @Override
    public boolean isNewWindowSupported() {
        return true;
    }

    @Override
    public boolean isPrintingSupported() {
        return true;
    }

    @Override
    public void printTopics(Topic[] topics) {
        if (topics != null) {
            HTMLBrowser browser = null;
            try {
                browser = (HTMLBrowser)this._htmlBrowserClass.newInstance();
                browser.setLocale(StaticLocaleContext.getLocale());
                if (StaticLocaleContext.getEncoding() != null) {
                    browser.setCharset(StaticLocaleContext.getEncoding());
                }
            }
            catch (Exception e) {
                System.err.println("Failed to create instance of " + this._htmlBrowserClass);
                System.err.println("Cannot create Topic Display");
                return;
            }
            BrowserTopicDisplay topicDisplay = new BrowserTopicDisplay(browser, this._library);
            TopicPrintJob printJob = topicDisplay.getTopicPrintJob();
            if (printJob != null) {
                printJob.printTopics(topics);
            }
        }
    }

    public synchronized void reclaimTopicPanel(DefaultTopicPanel topicPanel) {
        Window topicWindow = topicPanel.getCurrentTopicWindow();
        if (topicWindow != null) {
            this._bounds = topicWindow.getBounds();
        }
        if (this._activePanel == topicPanel) {
            this._activePanel = null;
        }
        topicPanel.clearDocumentStack();
        this._workingPanels.removeElement(topicPanel);
        this._cachedPanels.addElement(topicPanel);
        if (topicWindow instanceof Dialog && !this._javaVersionEqualOrGreater(1, 4, 1)) {
            this._windowTracker.unregisterWindow(topicWindow);
            topicPanel.disposeTopicDialog();
        }
        this._checkStandAloneExit();
    }

    @Override
    public void registerCustomProtocolHandler(String customProtocol, CustomProtocolHandler handler) {
        this._cpr.registerCustomProtocolHandler(customProtocol, handler);
    }

    @Override
    public void setFavoritesModel(FavoritesModel favoritesModel) {
        this._favoritesModel = favoritesModel;
    }

    @Override
    public FavoritesModel getFavoritesModel() {
        return this._favoritesModel;
    }

    private int _getVisibleTopicWindowCount() {
        int visibleWindowCount = 0;
        for (int i = 0; i < this._workingPanels.size(); ++i) {
            DefaultTopicPanel aPanel = (DefaultTopicPanel)this._workingPanels.elementAt(i);
            Window topicWindow = aPanel.getCurrentTopicWindow();
            if (topicWindow == null || !topicWindow.isVisible()) continue;
            ++visibleWindowCount;
        }
        return visibleWindowCount;
    }

    private void _checkDisplayHomeIDPage() {
        if (!this._homeIDDisplayAlreadyChecked) {
            Book[] books;
            String homeID = null;
            Book homeIDBook = null;
            if (this._library != null && (books = this._library.getBooks()) != null) {
                for (int i = 0; i < books.length; ++i) {
                    Book aBook = books[i];
                    if (!(aBook instanceof HelpSet) || (homeID = ((HelpSet)aBook).getHomeID()) == null) continue;
                    homeIDBook = aBook;
                    break;
                }
            }
            if (homeID != null) {
                SimpleTopic homeIDTopic = new SimpleTopic();
                homeIDTopic.setTarget((Target)new IndirectTarget(homeIDBook, homeID));
                this._dockedPanel.displayTopic((Topic)homeIDTopic);
            }
            this._homeIDDisplayAlreadyChecked = true;
        }
    }

    private void _checkModalMode() {
        Dialog newModalOwner = this._getActiveModalOwnerDialog();
        boolean aParentIsModal = false;
        if (newModalOwner != null) {
            aParentIsModal = true;
        }
        if (aParentIsModal && !this._modalMode) {
            this._disposeHelpFrames();
            this._modalMode = true;
        } else if (this._modalMode) {
            if (!aParentIsModal) {
                this._disposeHelpDialogs();
                this._modalMode = false;
            } else if (newModalOwner != this._modalOwner) {
                this._disposeHelpDialogs();
            }
        }
        this._modalOwner = newModalOwner;
    }

    private DefaultTopicPanel _setupTopicWindow(boolean newWindow) {
        Window topicWindow = null;
        DefaultTopicPanel topicPanel = null;
        this._checkModalMode();
        topicPanel = newWindow ? this.createTopicPanel() : this.getActivePanel();
        if (topicPanel == this._dockedPanel) {
            topicWindow = null;
        } else {
            topicWindow = topicPanel.getCurrentTopicWindow();
            if (topicWindow == null) {
                if (this._modalMode) {
                    JDialog topicDialog = topicPanel.createTopicWindowDialog(this._getActiveModalOwnerDialog());
                    topicWindow = topicDialog;
                } else {
                    topicWindow = topicPanel.createTopicWindowFrame();
                }
                this._setInitialPosition(topicWindow);
                this._windowTracker.registerWindow(topicWindow, topicPanel);
            }
        }
        return topicPanel;
    }

    private Window _setupNavigatorWindow() {
        this._checkModalMode();
        Window navWindow = this._navigatorPanel.getCurrentNavigatorWindow();
        if (navWindow == null) {
            if (this._modalMode) {
                JDialog navDialog = this._navigatorPanel.createNavigatorDialog(this._getActiveModalOwnerDialog());
                navWindow = navDialog;
            } else {
                navWindow = this._navigatorPanel.createNavigatorFrame();
            }
        }
        return navWindow;
    }

    private void _disposeHelpFrames() {
        this.hideAllWindows();
        this._navigatorPanel.disposeNavigatorFrame();
        for (int iter = this._cachedPanels.size() - 1; iter >= 0; --iter) {
            DefaultTopicPanel aPanel = (DefaultTopicPanel)this._cachedPanels.elementAt(iter);
            Window topicWindow = aPanel.getCurrentTopicWindow();
            if (topicWindow == null || !(topicWindow instanceof Frame)) continue;
            this._windowTracker.unregisterWindow(topicWindow);
            aPanel.disposeTopicFrame();
        }
    }

    private void _disposeHelpDialogs() {
        this.hideAllWindows();
        this._navigatorPanel.disposeNavigatorDialog();
        for (int iter = this._cachedPanels.size() - 1; iter >= 0; --iter) {
            DefaultTopicPanel aPanel = (DefaultTopicPanel)this._cachedPanels.elementAt(iter);
            Window topicWindow = aPanel.getCurrentTopicWindow();
            if (!(topicWindow instanceof Dialog)) continue;
            this._windowTracker.unregisterWindow(topicWindow);
            aPanel.disposeTopicDialog();
        }
    }

    private void _setInitialPosition(Window topicWindow) {
        Toolkit toolkit = topicWindow.getToolkit();
        Dimension screensize = toolkit.getScreenSize();
        Dimension twSize = topicWindow.getSize();
        int x = screensize.width - twSize.width - 10;
        int y = 10;
        Window navWindow = this._navigatorPanel.getCurrentNavigatorWindow();
        if (navWindow != null && navWindow.isVisible()) {
            Dimension navSize = navWindow.getSize();
            Point loc = navWindow.getLocation();
            x = loc.x + navSize.width;
            y = loc.y;
        }
        int numWorkingPanels = this._workingPanels.size();
        y += 24 * (numWorkingPanels - 1);
        if (screensize.width < (x += 24 * (numWorkingPanels - 1 + 1)) + twSize.width) {
            x = screensize.width - twSize.width;
        }
        if (x < 0) {
            x = 0;
        }
        if (screensize.height < y + twSize.height) {
            y = screensize.height - twSize.height;
        }
        if (y < 0) {
            y = 0;
        }
        topicWindow.setLocation(x, y);
    }

    private void _ensureNotMinimized(Window aWindow) {
        Frame windowFrame;
        if (aWindow instanceof Frame && (windowFrame = (Frame)aWindow).getState() == 1) {
            windowFrame.setState(0);
        }
    }

    private void _synchronizeNavigators(URL url) {
        final URL finalURL = url;
        if (SwingUtilities.isEventDispatchThread()) {
            this._navigatorPanel.synchronizeNavigators(finalURL);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultWindowManager.this._navigatorPanel.synchronizeNavigators(finalURL);
                }
            });
        }
    }

    private void _checkStandAloneExit() {
        if (this._standAloneMode && !this._navigatorPanel.isShowing() && this._workingPanels.size() == 0) {
            System.exit(0);
        }
    }

    private Dialog _getActiveModalOwnerDialog() {
        Window aWindow = WindowUtils.getActiveWindow();
        if (aWindow == null) {
            try {
                if (this._shouldTryLoadingEwtWindowUtils) {
                    this._shouldTryLoadingEwtWindowUtils = false;
                    Class<?> ewtWindowUtils = Thread.currentThread().getContextClassLoader().loadClass(_EWT_WINDOWUTILS);
                    if (ewtWindowUtils != null) {
                        _ewtActiveWindowMethod = ewtWindowUtils.getMethod(_GET_ACTIVE_WINDOW_METHOD, null);
                    }
                }
                if (_ewtActiveWindowMethod != null) {
                    aWindow = (Window)_ewtActiveWindowMethod.invoke(null, null);
                }
            }
            catch (Exception ewtWindowUtils) {
                // empty catch block
            }
        }
        Dialog modalOwner = null;
        while (aWindow != null) {
            Dialog theDialog;
            if (aWindow instanceof Dialog && (theDialog = (Dialog)aWindow).isModal()) {
                modalOwner = theDialog;
                break;
            }
            aWindow = (Window)aWindow.getParent();
        }
        return modalOwner;
    }

    private boolean _javaVersionEqualOrGreater(int major, int minor, int patch) {
        boolean greater = false;
        String versionName = null;
        int first = 1;
        int second = 0;
        int third = 0;
        try {
            versionName = System.getProperty("java.version");
        }
        catch (Throwable t) {
            return false;
        }
        try {
            int index = versionName.indexOf(".");
            first = Integer.parseInt(versionName.substring(0, index));
            versionName = versionName.substring(index + 1);
            index = versionName.indexOf(".");
            second = Integer.parseInt(versionName.substring(0, index));
            versionName = versionName.substring(index + 1);
            index = versionName.indexOf(".");
            if (index != -1) {
                versionName = versionName.substring(0, index);
            }
            third = Integer.parseInt(versionName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (first > major) {
            greater = true;
        } else if (first == major) {
            if (second > minor) {
                greater = true;
            } else if (second == minor && third >= patch) {
                greater = true;
            }
        }
        return greater;
    }

    private class HelpWindowTracker
    extends WindowAdapter {
        private Hashtable _windowTable = new Hashtable();

        @Override
        public void windowActivated(WindowEvent e) {
            Window activeWin = e.getWindow();
            DefaultTopicPanel activePanel = (DefaultTopicPanel)this._windowTable.get(activeWin);
            if (activePanel != null) {
                DefaultWindowManager.this._synchronizeNavigators(activePanel.getCurrentURL());
            }
        }

        public void registerWindow(Window window, DefaultTopicPanel panel) {
            if (window != null && panel != null) {
                this._windowTable.put(window, panel);
                window.addWindowListener(this);
            }
        }

        public void unregisterWindow(Window window) {
            if (window != null) {
                window.removeWindowListener(this);
                this._windowTable.remove(window);
            }
        }
    }
}

