/*
 * Decompiled with CFR 0.152.
 */
package odmr;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.aurora.server.tools.loadjava.DropJavaMain;
import oracle.aurora.server.tools.loadjava.LoadJavaMain;
import oracle.jdbc.OracleDriver;

public class InstallJSONSchemaGen {
    static final Logger log = Logger.getLogger("InstallJSONSchemaGen");
    String sysUserName = "sys as sysdba";
    String sysPassword = "knl_test7";
    String ConnectionName = "jdbc:oracle:thin:@adc00par:1522:er12102";
    String userName = "dmuser";

    public static String[] getJarFiles() {
        String[] fileList;
        String installHome = InstallJSONSchemaGen.getInstallHome();
        String[] files = null;
        files = fileList = new String[]{installHome + "JSON/deploy/javax.json.jar", installHome + "JSON/deploy/JSONSchemaGenerator.jar"};
        files = InstallJSONSchemaGen.replaceSeperator(files);
        return files;
    }

    private static String[] replaceSeperator(String[] files) {
        for (int i = 0; i < files.length; ++i) {
            files[i] = files[i].replace("/", File.separator);
            files[i] = files[i].replace("\\", File.separator);
        }
        return files;
    }

    protected static String getInstallHome() {
        String path = InstallJSONSchemaGen.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = null;
        try {
            decodedPath = URLDecoder.decode(path, "UTF-8");
            File extensionFile = new File(decodedPath);
            File sqlDevDir = extensionFile.getParentFile().getParentFile();
            String installHome = sqlDevDir.getAbsolutePath() + File.separator;
            return installHome;
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, "Unsupported Encoding: {0}", e.getLocalizedMessage());
            return null;
        }
    }

    protected String getFileName(String fileName) {
        int pos2;
        int pos;
        int pos1 = fileName.lastIndexOf("/");
        int n = pos = pos1 > (pos2 = fileName.lastIndexOf("\\")) ? pos1 : pos2;
        if (pos > -1) {
            fileName = fileName.substring(pos + 1);
        }
        return fileName;
    }

    protected static String createMissingFileName(String fileName) {
        return "gm_" + fileName;
    }

    private InstallJSONSchemaGen() {
        Connection conn = null;
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            conn = DriverManager.getConnection(this.ConnectionName, this.sysUserName, this.sysPassword);
            this.dropJava(conn, this.sysUserName);
            this.loadJava(conn, this.sysUserName);
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Oracle Driver registration fails: {0}", e.getLocalizedMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadJava(Connection connection, String sysUserName) {
        try {
            String[] args = this.getLoadJavaArguments(connection, sysUserName);
            String[] files = InstallJSONSchemaGen.getJarFiles();
            int i = 1;
            for (String filePath : files) {
                File file = new File(filePath);
                args[7] = file.getAbsolutePath();
                ++i;
                LoadJavaMain.main((String[])args);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected Failure: {0}", e.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        return true;
    }

    protected String[] getLoadJavaArguments(Connection connection, String sysUserName) {
        try {
            String url = connection.getMetaData().getURL();
            if (this.sysPassword != null) {
                String connectionDetails = sysUserName + "/" + this.sysPassword + "@" + url.substring(18);
                String[] args = new String[]{"-user", connectionDetails, "-schema", "ODMRSYS", "-thin", "-force", "-verbose", "filename", "-grant", this.userName};
                return args;
            }
            return null;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unexpected Failure: {0}", e.getLocalizedMessage());
            return null;
        }
    }

    private boolean dropJava(Connection connection, String sysUserName) {
        try {
            String url = connection.getMetaData().getURL();
            if (this.sysPassword != null) {
                String[] files;
                String connectionDetails = sysUserName + "/" + this.sysPassword + "@" + url.substring(18);
                String[] args = new String[]{"-user", connectionDetails, "-schema", "ODMRSYS", "-thin", "filename"};
                for (String filePath : files = InstallJSONSchemaGen.getJarFiles()) {
                    File file = new File(filePath);
                    if (!file.exists()) continue;
                    args[5] = file.getAbsolutePath();
                    DropJavaMain.main((String[])args);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected Failure: {0}", e.getLocalizedMessage());
        }
        return true;
    }

    public static void main(String[] args) {
        InstallJSONSchemaGen install = new InstallJSONSchemaGen();
    }
}

