/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.net.URLFileSystem;
import oracle.mof.xmi.ContractUtils;

public final class XMLWriter {
    private static final String INITIAL_STATE = "initial state";
    private static final String START_DOCUMENT_STATE = "start document state";
    private static final String END_DOCUMENT_STATE = "end document state";
    private static final String DOCUMENT_CLOSED_STATE = "document closed state";
    private static final String START_ELEMENT_STATE = "start element state";
    private static final String OPEN_ELEMENT_STATE = "open element state";
    private static final String OPEN_ATTRIBUTE_STATE = "open attribute state";
    private String m_state = "initial state";
    private OutputStream m_outputStream;
    private Writer m_writer;
    private char[] m_buffer = new char[8192];
    private int m_next;
    private URL m_url;
    private ArrayList m_elementNames = new ArrayList(10);
    private boolean m_lastWasContent;
    private NewLines m_newLines = NewLines.NONE;
    private int m_indent = 2;
    private int m_maxAttributes = 1;
    private int m_attributeCount;

    public void setOutputStream(OutputStream os) {
        this.checkState(INITIAL_STATE);
        ContractUtils.checkNull(os, "Output stream was null");
        this.m_outputStream = os;
        this.m_state = START_DOCUMENT_STATE;
    }

    public void setOutputURL(URL url) {
        this.checkState(INITIAL_STATE);
        ContractUtils.checkNull(url, "URL was null");
        this.m_url = url;
        this.m_state = START_DOCUMENT_STATE;
    }

    public void setNewLines(NewLines newLines) {
        ContractUtils.checkNull((Object)newLines, "New lines was null");
        this.m_newLines = newLines;
    }

    public void setIndent(int indent) {
        if (indent < 0) {
            throw new IllegalArgumentException("Negative indent");
        }
        this.m_indent = indent;
    }

    public void setMaxAttributes(int maxAttributes) {
        if (maxAttributes < 0) {
            throw new IllegalArgumentException("Negative max attributes");
        }
        this.m_maxAttributes = maxAttributes;
    }

    public boolean isOpenElementState() {
        return this.m_state == OPEN_ELEMENT_STATE;
    }

    public void abort() {
        this.m_state = DOCUMENT_CLOSED_STATE;
        if (this.m_outputStream != null) {
            try {
                this.m_outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final void checkState(String state) {
        ContractUtils.checkState(state, this.m_state);
    }

    private void write(char c) {
        this.m_buffer[this.m_next++] = c;
        if (this.m_next == this.m_buffer.length) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() {
        if (this.m_next > 0) {
            try {
                this.m_writer.write(this.m_buffer, 0, this.m_next);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_next = 0;
        }
    }

    private void writeExact(String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            this.write(s.charAt(i));
        }
    }

    private void writeTranslated(String s, boolean noNL) {
        int length = s.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    this.writeExact("&lt;");
                    continue block7;
                }
                case '&': {
                    this.writeExact("&amp;");
                    continue block7;
                }
                case '\"': {
                    this.writeExact("&quot;");
                    continue block7;
                }
                case '\'': {
                    this.writeExact("&apos;");
                    continue block7;
                }
                case '\n': {
                    if (noNL) {
                        this.writeExact("&#xa;");
                        continue block7;
                    }
                }
                default: {
                    this.write(c);
                }
            }
        }
    }

    private void writeln() {
        this.write('\n');
    }

    public void startDocument() throws IOException {
        this.checkState(START_DOCUMENT_STATE);
        if (this.m_outputStream == null) {
            this.m_outputStream = URLFileSystem.openOutputStream((URL)this.m_url);
        }
        this.m_writer = new OutputStreamWriter(this.m_outputStream, "UTF-8");
        this.writeExact("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        this.m_state = START_ELEMENT_STATE;
    }

    public void endDocument() throws IOException {
        this.checkState(END_DOCUMENT_STATE);
        this.flushBuffer();
        this.m_state = DOCUMENT_CLOSED_STATE;
        this.m_writer.close();
    }

    private boolean tidyElement(String endTag) {
        if (this.m_state == OPEN_ELEMENT_STATE) {
            this.writeExact(endTag);
            this.m_state = START_ELEMENT_STATE;
            return true;
        }
        this.checkState(START_ELEMENT_STATE);
        return false;
    }

    public void startElement(String name) {
        ContractUtils.checkNull(name, "Name cannot be null");
        this.tidyElement(">");
        this.outputElementIndent();
        this.writeExact("<");
        this.writeTranslated(name, false);
        this.pushElement(name);
        this.m_state = OPEN_ELEMENT_STATE;
        this.m_attributeCount = 0;
    }

    public void startAttribute(String name) {
        ContractUtils.checkNull(name, "Name cannot be null");
        this.checkState(OPEN_ELEMENT_STATE);
        ++this.m_attributeCount;
        if (this.m_newLines.forAttributes() && this.m_attributeCount > this.m_maxAttributes) {
            this.m_attributeCount = 0;
            this.outputIndent(this.getElementDepth() + 1);
        } else {
            this.writeExact(" ");
        }
        this.writeTranslated(name, false);
        this.writeExact("='");
        this.m_state = OPEN_ATTRIBUTE_STATE;
    }

    public void endAttribute() {
        this.checkState(OPEN_ATTRIBUTE_STATE);
        this.writeExact("'");
        this.m_state = OPEN_ELEMENT_STATE;
    }

    public void outputAttribute(String name, String value) {
        this.startAttribute(name);
        this.outputContent(value);
        this.endAttribute();
    }

    public void outputContent(String content) {
        ContractUtils.checkNull(content, "XML content must not be null");
        if (this.m_state == OPEN_ATTRIBUTE_STATE) {
            this.writeTranslated(content, true);
        } else {
            if (this.getElementDepth() == 0) {
                throw new IllegalStateException("No element to own content");
            }
            this.tidyElement(">");
            this.writeTranslated(content, false);
            this.m_lastWasContent = true;
        }
    }

    public void endElement() {
        if (this.tidyElement("/>")) {
            this.popElement();
        } else {
            String name = this.popElement();
            this.outputElementIndent();
            this.writeExact("</");
            this.writeTranslated(name, false);
            this.writeExact(">");
        }
        if (this.getElementDepth() == 0) {
            this.m_state = END_DOCUMENT_STATE;
        }
    }

    private void outputElementIndent() {
        if (this.m_newLines.forElements() && !this.m_lastWasContent) {
            this.outputIndent(this.getElementDepth());
        }
        this.m_lastWasContent = false;
    }

    private void outputIndent(int depth) {
        this.writeln();
        for (int i = depth * this.m_indent; i > 0; --i) {
            this.write(' ');
        }
    }

    private int getElementDepth() {
        return this.m_elementNames.size();
    }

    private void pushElement(String name) {
        this.m_elementNames.add(name);
    }

    private String popElement() {
        if (this.getElementDepth() == 0) {
            throw new IllegalStateException("No elements to pop");
        }
        return (String)this.m_elementNames.remove(this.getElementDepth() - 1);
    }

    public static enum NewLines {
        NONE(false, false),
        ELEMENTS(true, false),
        ALL(true, true);

        private boolean m_elements;
        private boolean m_attributes;

        private NewLines(boolean elements, boolean attributes) {
            this.m_elements = elements;
            this.m_attributes = attributes;
        }

        public boolean forElements() {
            return this.m_elements;
        }

        public boolean forAttributes() {
            return this.m_attributes;
        }
    }
}

