/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.mof.xmi.ContractUtils;
import oracle.mof.xmi.ObjectResolver;
import oracle.mof.xmi.ResolutionResult;
import oracle.mof.xmi.XMIDocument;

public class XMIDocumentSet {
    private final ArrayList<ObjectResolver> m_resolvers = new ArrayList();
    private final HashMap<String, ObjectResolver> m_resolversByURI = new HashMap();
    private final ArrayList<XMIDocument> m_documents = new ArrayList();

    public void resolveReferences() {
        for (int i = 0; i < this.getDocumentCount(); ++i) {
            this.getDocument(i).resolveReferences();
        }
    }

    public int getDocumentCount() {
        return this.m_documents.size();
    }

    public XMIDocument getDocument(int index) {
        return this.m_documents.get(index);
    }

    public void addDocument(XMIDocument document) {
        ContractUtils.checkNull(document, "Document must not be null");
        this.m_documents.add(document);
        document.setDocumentSet(this);
    }

    public void addResolver(ObjectResolver resolver) {
        ContractUtils.checkNull(resolver, "Resolver must not be null");
        this.m_resolvers.add(resolver);
    }

    public void addMapping(String uri, ObjectResolver resolver) {
        ContractUtils.checkNull(uri, "URI must not be null");
        ContractUtils.checkNull(resolver, "Resolver must not be null");
        ObjectResolver oldMapping = this.m_resolversByURI.put(uri, resolver);
        if (oldMapping != null && oldMapping != resolver) {
            throw new IllegalStateException(uri + " already mapped");
        }
    }

    public ObjectResolver getResolver(String uri) {
        return this.m_resolversByURI.get(uri);
    }

    public Object getInstance(String uri) {
        int index = uri.indexOf(35);
        if (index > 0 && index < uri.length()) {
            String documentURI = uri.substring(0, index);
            return this.getInstanceByFragment(documentURI, uri.substring(index + 1));
        }
        return this.getInstanceByUUID(uri);
    }

    protected Object getInstanceByFragment(String documentURI, String fragment) {
        ObjectResolver resolver = this.getResolver(documentURI);
        if (resolver != null) {
            return resolver.resolve(documentURI, fragment);
        }
        return this.getInstanceByUUID(documentURI + "#" + fragment);
    }

    protected Object getInstanceByUUID(String uri) {
        for (int i = this.m_resolvers.size() - 1; i >= 0; --i) {
            Object o = this.m_resolvers.get(i).resolve(uri);
            if (o == ResolutionResult.NOT_FOUND) continue;
            return o;
        }
        return ResolutionResult.NOT_FOUND;
    }
}

