/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.io.IOException;
import oracle.mof.xmi.XMIMetaModel;
import oracle.mof.xmi.XMIProperty;
import oracle.mof.xmi.XMIType;
import oracle.mof.xmi.XMIWriter;
import oracle.mof.xmi.XMLWriter;

public class XMI21Writer
extends XMIWriter {
    @Override
    public void startXMI() throws IOException {
        XMLWriter writer = this.getXMLWriter();
        writer.startDocument();
        writer.startElement("xmi:XMI");
        String xmiVersion = this.getXMIVersion();
        if (xmiVersion != null) {
            writer.outputAttribute("xmi:version", xmiVersion);
        }
        writer.outputAttribute("xmlns:xmi", this.getXMINamespace());
        for (XMIMetaModel xMIMetaModel : this.getMetaModels()) {
            writer.outputAttribute("xmlns:" + xMIMetaModel.getNSPrefix(), xMIMetaModel.getNSURI());
        }
        writer.startElement("documentation");
        writer.outputAttribute("exporter", this.getExporter());
        writer.outputAttribute("exporterVersion", this.getExporterVersion());
        writer.endElement();
    }

    protected String getXMIVersion() {
        return "2.1";
    }

    protected String getXMINamespace() {
        return "http://schema.omg.org/spec/XMI/" + this.getXMIVersion();
    }

    @Override
    public void startInstanceImpl(XMIType type) {
        XMLWriter writer = this.getXMLWriter();
        String name = type.getMetaModel().getNSPrefix() + ":" + type.getName();
        XMIProperty composite = this.peekProperty();
        if (composite == null) {
            writer.startElement(name);
            if (this.requiresType()) {
                writer.outputAttribute("xmi:type", name);
            }
        } else {
            this.outputPropertyElement(composite);
            if (this.requiresType() || type != composite.getType()) {
                writer.outputAttribute("xmi:type", name);
            }
        }
    }

    protected boolean requiresType() {
        return false;
    }

    @Override
    protected String getIdAttribute() {
        return "xmi:id";
    }

    @Override
    protected String getUUIDAttribute() {
        return "xmi:uuid";
    }

    @Override
    protected String getLabelAttribute() {
        return "xmi:label";
    }

    @Override
    protected void startPropertyAsElement(XMIProperty property) {
    }

    @Override
    protected void outputValueAsElement(XMIProperty property, String value) {
        XMLWriter writer = this.getXMLWriter();
        this.outputPropertyElement(property);
        if (property.getPropertyType().isDatatype()) {
            writer.outputContent(value);
        } else {
            this.outputRef(value);
        }
        writer.endElement();
    }

    @Override
    protected String getIdRefAttribute() {
        return "xmi:idref";
    }

    private void outputPropertyElement(XMIProperty property) {
        this.getXMLWriter().startElement(property.getName());
    }

    @Override
    protected void endPropertyAsElement(XMIProperty property) {
    }

    @Override
    public void endXMI() throws IOException {
        XMLWriter writer = this.getXMLWriter();
        writer.endElement();
        writer.endDocument();
    }
}

