/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.HttpConnection;
import oracle.sdovis.util.HttpGetThread;
import oracle.sdovis.util.HttpPostThread;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.WfsFeatureType;
import oracle.sdovis.util.XMLDOMParser;
import oracle.sdovis.util.wfs110.Capabilities;
import oracle.sdovis.util.wfs110.FeatureType;
import oracle.sdovis.util.wfs110.OutputFormats;
import oracle.sdovis.util.wfs110.WGS84BoundingBox;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WfsCapabilities {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String version = "1.0.0";
    private int updateSequence = 0;
    private Hashtable xmlnsValues = new Hashtable();
    private String serviceName = null;
    private String serviceTitle = null;
    private String serviceAbstract = null;
    private String serviceKeywords = null;
    private String serviceOnlineResource = null;
    private String serviceFees = null;
    private String serviceAccessConstraints = null;
    private String getCapabilities_getURL = null;
    private String getCapabilities_postURL = null;
    private String describeFeatureType_getURL = null;
    private String describeFeatureType_postURL = null;
    private String getFeature_getURL = null;
    private String getFeature_postURL = null;
    private String getFeatureWithLock_getURL = null;
    private String getFeatureWithLock_postURL = null;
    private String transaction_getURL = null;
    private String transaction_postURL = null;
    private String lockFeature_getURL = null;
    private String lockFeature_postURL = null;
    private ArrayList featureFormats = new ArrayList();
    private ArrayList featurewithlockFormats = new ArrayList();
    private ArrayList serviceOperations = new ArrayList();
    private Vector featureTypes = new Vector();
    private ArrayList spatialOperators = new ArrayList();
    private ArrayList logicalOperators = new ArrayList();
    private ArrayList comparisonOperators = new ArrayList();
    private ArrayList arithmeticOperators = new ArrayList();

    public WfsCapabilities() {
        this.xmlnsValues.put("xmlns", "http://www.opengis.net/wfs");
        this.xmlnsValues.put("xmlns:wfs", "http://www.opengis.net/wfs");
        this.xmlnsValues.put("xmlns:ogc", "http://www.opengis.net/ogc");
    }

    public void reset() {
        this.version = "1.0.0";
        this.updateSequence = 0;
        this.xmlnsValues = new Hashtable();
        this.xmlnsValues.put("xmlns", "http://www.opengis.net/wfs");
        this.xmlnsValues.put("xmlns:wfs", "http://www.opengis.net/wfs");
        this.xmlnsValues.put("xmlns:ogc", "http://www.opengis.net/ogc");
        this.serviceName = null;
        this.serviceTitle = null;
        this.serviceAbstract = null;
        this.serviceKeywords = null;
        this.serviceOnlineResource = null;
        this.serviceFees = null;
        this.serviceAccessConstraints = null;
        this.getCapabilities_getURL = null;
        this.getCapabilities_postURL = null;
        this.describeFeatureType_getURL = null;
        this.describeFeatureType_postURL = null;
        this.getFeature_getURL = null;
        this.getFeature_postURL = null;
        this.getFeatureWithLock_getURL = null;
        this.getFeatureWithLock_postURL = null;
        this.transaction_getURL = null;
        this.transaction_postURL = null;
        this.lockFeature_getURL = null;
        this.lockFeature_postURL = null;
        this.featureFormats.clear();
        this.featurewithlockFormats.clear();
        this.serviceOperations.clear();
        this.featureTypes.clear();
        this.spatialOperators.clear();
        this.logicalOperators.clear();
        this.comparisonOperators.clear();
        this.arithmeticOperators.clear();
    }

    public boolean readUsingHttpGet(String url, long timeout, String wfsVersion) {
        String result;
        block12: {
            this.reset();
            if (wfsVersion != null) {
                this.version = wfsVersion;
            }
            if (url == null || url.trim().length() == 0) {
                return false;
            }
            String getreq = url.trim();
            if (getreq.lastIndexOf(63) > -1) {
                if (!getreq.endsWith("?") && !getreq.endsWith("&")) {
                    getreq = getreq + "&";
                }
            } else if (!getreq.endsWith("&")) {
                getreq = getreq + "?";
            }
            getreq = getreq + "VERSION=" + this.version + "&SERVICE=WFS&REQUEST=GetCapabilities";
            log.info("GetCapabilities request: " + getreq);
            result = "";
            try {
                if (timeout <= 0L) {
                    result = Util.issueHttpGetRequest(getreq);
                    break block12;
                }
                HttpGetThread getThread = new HttpGetThread(getreq);
                getThread.start();
                getThread.checkTimeout(timeout);
                if (getThread.isCompleted()) {
                    result = getThread.getResponse();
                    break block12;
                }
                Exception ex = getThread.getException();
                if (ex == null) {
                    log.warning("Request timeout.");
                } else {
                    log.warning(ex.getMessage());
                }
                getThread = null;
                return false;
            }
            catch (IOException e) {
                log.severe("GetCapabilities using Http Get failed: " + e.getMessage());
                return false;
            }
        }
        return this.decodeCapabilities(result);
    }

    public boolean readUsingHttpPost(String url, long timeout, String wfsVersion) {
        String result;
        block8: {
            this.reset();
            if (wfsVersion != null) {
                this.version = wfsVersion;
            }
            if (url == null || url.trim().length() == 0) {
                return false;
            }
            String postreq = url.trim();
            String xml = "<?xml version=\"1.0\" ?>\n<GetCapabilities\n   service=\"WFS\"\n   version=\"" + this.version + "\"\n" + "   xmlns=\"http://www.opengis.net/wfs\" />";
            log.info("Request: " + xml);
            result = "";
            try {
                if (timeout <= 0L) {
                    HttpConnection hurl = new HttpConnection();
                    hurl.connect(postreq);
                    hurl.sendXMLRequest("", xml);
                    result = hurl.getXMLResponse();
                    break block8;
                }
                HttpPostThread postThread = new HttpPostThread(postreq, xml, null);
                postThread.start();
                postThread.checkTimeout(timeout);
                if (postThread.isCompleted()) {
                    result = postThread.getResponse();
                    break block8;
                }
                Exception ex = postThread.getException();
                if (ex == null) {
                    log.warning("Request timeout.");
                } else {
                    log.warning(ex.getMessage());
                }
                postThread = null;
                return false;
            }
            catch (Exception e) {
                log.severe("GetCapabilities using Http Post failed: " + e.getMessage());
                return false;
            }
        }
        return this.decodeCapabilities(result);
    }

    private boolean decodeCapabilities(String result) {
        log.finest("Capabilities XML: \n" + result);
        if (this.version.equals("1.0.0")) {
            return this.decodeCapabilities100(result);
        }
        if (this.version.equals("1.1.0")) {
            return this.decodeCapabilities110(result);
        }
        return false;
    }

    private boolean decodeCapabilities100(String result) {
        if (result == null) {
            return false;
        }
        try {
            NodeList capNodes;
            String value;
            XMLDOMParser parser = new XMLDOMParser();
            if (!parser.parse(result)) {
                log.severe("Unable to parse capabilities request");
                return false;
            }
            Document doc = parser.getDocument();
            Node root = doc.getFirstChild();
            if (root == null) {
                log.severe("Invalid XML response for GetCapabilities. Root node not found.");
                return false;
            }
            if (!root.getNodeName().equalsIgnoreCase("WFS_Capabilities")) {
                NodeList nl = doc.getElementsByTagName("WFS_Capabilities");
                if (nl != null && nl.getLength() > 0) {
                    root = nl.item(0);
                } else {
                    log.info("WFS_Capabilities node not found.");
                    return false;
                }
            }
            if ((value = XMLDOMParser.getAttribute(root, "version")) != null && value.trim().length() > 0) {
                if (!value.trim().equalsIgnoreCase("1.0.0")) {
                    log.info("Unsupported capabilities version: " + value.trim());
                }
                this.version = value.trim();
            }
            if ((value = XMLDOMParser.getAttribute(root, "updateSequence")) != null && value.trim().length() > 0) {
                try {
                    int seq;
                    this.updateSequence = seq = Integer.parseInt(value.trim());
                }
                catch (Exception e) {
                    this.updateSequence = 0;
                }
            }
            if ((value = XMLDOMParser.getAttribute(root, "xmlns")) != null && value.trim().length() > 0) {
                this.xmlnsValues.put("xmlns", value.trim());
            }
            if ((value = XMLDOMParser.getAttribute(root, "xmlns:wfs")) != null && value.trim().length() > 0) {
                this.xmlnsValues.put("xmlns:wfs", value.trim());
            }
            if ((value = XMLDOMParser.getAttribute(root, "xmlns:ogc")) != null && value.trim().length() > 0) {
                this.xmlnsValues.put("xmlns:ogc", value.trim());
            }
            if ((capNodes = root.getChildNodes()) != null) {
                for (int j = 0; j < capNodes.getLength(); ++j) {
                    Node node = capNodes.item(j);
                    if (node.getNodeName().equalsIgnoreCase("Service")) {
                        this.updateServiceParameters(node);
                        continue;
                    }
                    if (node.getNodeName().equalsIgnoreCase("Capability")) {
                        this.updateCapabilityParameters(parser, node);
                        continue;
                    }
                    if (!node.getNodeName().equalsIgnoreCase("FeatureTypeList")) continue;
                    this.updateFeatureTypeParameters(parser, node);
                    for (int i = 0; i < this.featureTypes.size(); ++i) {
                        WfsFeatureType wft = (WfsFeatureType)this.featureTypes.get(i);
                        if (wft.getNameSpaceAlias() == null) continue;
                        String alias = wft.getNameSpaceAlias();
                        if (wft.getNameSpaceAliasURL() == null) {
                            value = XMLDOMParser.getAttribute(root, "xmlns:" + alias);
                            if (value == null || value.trim().length() <= 0) continue;
                            wft.setNameSpaceAliasURL(value.trim());
                            this.xmlnsValues.put("xmlns:" + alias, value.trim());
                            continue;
                        }
                        this.xmlnsValues.put("xmlns:" + alias, wft.getNameSpaceAliasURL());
                    }
                }
            }
        }
        catch (Exception e) {
            log.severe("Decode GetCapabilities  1.0.0 failed: " + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean decodeCapabilities110(String result) {
        if (result == null) {
            log.severe("Capabilities XML is null.");
            return false;
        }
        Capabilities cap = new Capabilities();
        try {
            cap.parseCapabilities(result);
            String[] xmlnskeys = cap.getXmlNameSpaceKeys();
            if (xmlnskeys != null && xmlnskeys.length > 0) {
                for (int i = 0; i < xmlnskeys.length; ++i) {
                    this.xmlnsValues.put(xmlnskeys[i], cap.getXmlNameSpace(xmlnskeys[i]));
                }
            }
            this.getCapabilities_getURL = cap.getGETURLforGetCapabilities();
            this.getCapabilities_postURL = cap.getPOSTURLforGetCapabilities();
            this.describeFeatureType_getURL = cap.getGETURLforDescribeFeatureType();
            this.describeFeatureType_postURL = cap.getPOSTURLforDescribeFeatureType();
            this.getFeature_getURL = cap.getGETURLforGetFeature();
            this.getFeature_postURL = cap.getPOSTURLforGetFeature();
            FeatureType[] ftypes = cap.getFeatures();
            if (ftypes != null && ftypes.length > 0) {
                for (int i = 0; i < ftypes.length; ++i) {
                    OutputFormats outf;
                    WfsFeatureType ft = new WfsFeatureType();
                    ft.setName(ftypes[i].getName());
                    ft.setTitle(ftypes[i].getTitle());
                    ft.setNameSpaceAlias(ftypes[i].getNamespaceAliasName());
                    ft.setNameSpaceAliasURL(ftypes[i].getNamespaceURL());
                    ft.setSRS(ftypes[i].getDefaultSRS());
                    WGS84BoundingBox llbox = ftypes[i].getWGS84BoundingBox();
                    if (llbox != null) {
                        double[] mbr = new double[]{llbox.getLowerCorner().getX(), llbox.getLowerCorner().getY(), llbox.getUpperCorner().getX(), llbox.getUpperCorner().getY()};
                        ft.setLatLongBoundingBox(mbr);
                    }
                    if ((outf = ftypes[i].getOutputFormats()) != null && outf.getFormats() != null) {
                        String[] formats = outf.getFormats();
                        for (int j = 0; j < formats.length; ++j) {
                            ft.addOutputFormat(formats[j]);
                        }
                    }
                    this.featureTypes.add(ft);
                }
            }
        }
        catch (Exception e) {
            log.severe("Decode GetCapabilities  1.1.0 failed: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getVersion() {
        return this.version;
    }

    public int getUpdateSequence() {
        return this.updateSequence;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceTitle() {
        return this.serviceTitle;
    }

    public String getServiceAbstract() {
        return this.serviceAbstract;
    }

    public String getServiceKeywords() {
        return this.serviceKeywords;
    }

    public String getServiceOnlineResource() {
        return this.serviceOnlineResource;
    }

    public String getServiceFees() {
        return this.serviceFees;
    }

    public String getServiceAccessConstraints() {
        return this.serviceAccessConstraints;
    }

    public String getCapabilitiesGetURL() {
        return this.getCapabilities_getURL;
    }

    public String getCapabilitiesPostURL() {
        return this.getCapabilities_postURL;
    }

    public String describeFeatureTypeGetURL() {
        return this.describeFeatureType_getURL;
    }

    public String describeFeatureTypePostURL() {
        return this.describeFeatureType_postURL;
    }

    public String getFeatureGetURL() {
        return this.getFeature_getURL;
    }

    public String getFeaturePostURL() {
        return this.getFeature_postURL;
    }

    public String getFeatureWithLockGetURL() {
        return this.getFeatureWithLock_getURL;
    }

    public String getFeatureWithLockPostURL() {
        return this.getFeatureWithLock_postURL;
    }

    public String getTransactionGetURL() {
        return this.transaction_getURL;
    }

    public String getTransactionPostURL() {
        return this.transaction_postURL;
    }

    public String getLockFeatureGetURL() {
        return this.lockFeature_getURL;
    }

    public String getLocFeaturePostURL() {
        return this.lockFeature_postURL;
    }

    public ArrayList getFeatureFormat() {
        return this.featureFormats;
    }

    public ArrayList getFeatureWithLockFormat() {
        return this.featurewithlockFormats;
    }

    public ArrayList getServiceOperations() {
        return this.serviceOperations;
    }

    public WfsFeatureType[] getFeatureTypesAsArray() {
        if (this.featureTypes.size() <= 0) {
            return null;
        }
        return this.featureTypes.toArray(new WfsFeatureType[this.featureTypes.size()]);
    }

    public Vector getFeatureTypes() {
        return this.featureTypes;
    }

    public ArrayList getSpatialOperators() {
        return this.spatialOperators;
    }

    public ArrayList getLogicalOperators() {
        return this.logicalOperators;
    }

    public ArrayList getComparisonOperators() {
        return this.comparisonOperators;
    }

    public ArrayList getArithmeticOperators() {
        return this.arithmeticOperators;
    }

    private void updateServiceParameters(Node serviceNode) {
        if (serviceNode == null) {
            return;
        }
        NodeList serviceNodes = serviceNode.getChildNodes();
        if (serviceNodes != null) {
            for (int j = 0; j < serviceNodes.getLength(); ++j) {
                Node child = serviceNodes.item(j);
                Node value = child.getFirstChild();
                String valueString = "";
                if (value != null) {
                    valueString = value.getNodeValue().trim();
                }
                if (child.getNodeName().equalsIgnoreCase("Name")) {
                    this.serviceName = valueString;
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("Title")) {
                    this.serviceTitle = valueString;
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("Abstract")) {
                    this.serviceAbstract = valueString;
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("Keywords")) {
                    this.serviceKeywords = valueString;
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("OnlineResource")) {
                    this.serviceOnlineResource = valueString;
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("Fees")) {
                    this.serviceFees = valueString;
                    continue;
                }
                if (!child.getNodeName().equalsIgnoreCase("AccessConstraints")) continue;
                this.serviceAccessConstraints = valueString;
            }
        }
    }

    private void updateCapabilityParameters(XMLDOMParser parser, Node capabilityNode) {
        if (parser == null || capabilityNode == null) {
            return;
        }
        NodeList capabilityNodes = capabilityNode.getChildNodes();
        if (capabilityNodes != null) {
            for (int k = 0; k < capabilityNodes.getLength(); ++k) {
                Node child = capabilityNodes.item(k);
                if (!child.getNodeName().equalsIgnoreCase("Request")) continue;
                NodeList reqtypes = child.getChildNodes();
                for (int i = 0; i < reqtypes.getLength(); ++i) {
                    int j;
                    String[] formats;
                    String[] res;
                    Node reqtype = reqtypes.item(i);
                    if (reqtype.getNodeName().equalsIgnoreCase("GetCapabilities")) {
                        res = this.getHttpAddresses(parser, reqtype);
                        if (res == null) continue;
                        this.getCapabilities_getURL = res[0];
                        this.getCapabilities_postURL = res[1];
                        continue;
                    }
                    if (reqtype.getNodeName().equalsIgnoreCase("DescribeFeatureType")) {
                        res = this.getHttpAddresses(parser, reqtype);
                        if (res == null) continue;
                        this.describeFeatureType_getURL = res[0];
                        this.describeFeatureType_postURL = res[1];
                        continue;
                    }
                    if (reqtype.getNodeName().equalsIgnoreCase("GetFeature")) {
                        res = this.getHttpAddresses(parser, reqtype);
                        if (res != null) {
                            this.getFeature_getURL = res[0];
                            this.getFeature_postURL = res[1];
                        }
                        formats = this.getResultFormats(reqtype);
                        this.featureFormats.clear();
                        if (formats == null) continue;
                        for (j = 0; j < formats.length; ++j) {
                            this.featureFormats.add(formats[j]);
                        }
                        continue;
                    }
                    if (reqtype.getNodeName().equalsIgnoreCase("GetFeatureWithLock")) {
                        res = this.getHttpAddresses(parser, reqtype);
                        if (res != null) {
                            this.getFeatureWithLock_getURL = res[0];
                            this.getFeatureWithLock_postURL = res[1];
                        }
                        formats = this.getResultFormats(reqtype);
                        this.featurewithlockFormats.clear();
                        if (formats == null) continue;
                        for (j = 0; j < formats.length; ++j) {
                            this.featurewithlockFormats.add(formats[j]);
                        }
                        continue;
                    }
                    if (reqtype.getNodeName().equalsIgnoreCase("Transaction")) {
                        res = this.getHttpAddresses(parser, reqtype);
                        if (res == null) continue;
                        this.transaction_getURL = res[0];
                        this.transaction_postURL = res[1];
                        continue;
                    }
                    if (!reqtype.getNodeName().equalsIgnoreCase("LockFeature") || (res = this.getHttpAddresses(parser, reqtype)) == null) continue;
                    this.lockFeature_getURL = res[0];
                    this.lockFeature_postURL = res[1];
                }
                break;
            }
        }
    }

    private String[] getHttpAddresses(XMLDOMParser parser, Node parent) {
        if (parent == null || parser == null) {
            return null;
        }
        NodeList dcpnodes = parent.getChildNodes();
        if (dcpnodes == null) {
            return null;
        }
        String[] result = new String[]{null, null};
        for (int k = 0; k < dcpnodes.getLength(); ++k) {
            NodeList httpnodes;
            Node child = dcpnodes.item(k);
            if (!child.getNodeName().equalsIgnoreCase("DCPType") || (httpnodes = child.getChildNodes()) == null) continue;
            for (int i = 0; i < httpnodes.getLength(); ++i) {
                NodeList httpchildren;
                Node hchild = httpnodes.item(i);
                if (!hchild.getNodeName().equalsIgnoreCase("HTTP") || (httpchildren = hchild.getChildNodes()) == null) continue;
                for (int j = 0; j < httpchildren.getLength(); ++j) {
                    Node op = httpchildren.item(j);
                    if (op.getNodeName().equalsIgnoreCase("Get")) {
                        String get = XMLDOMParser.getAttribute(op, "onlineResource");
                        if (get == null) continue;
                        result[0] = get;
                        continue;
                    }
                    if (!op.getNodeName().equalsIgnoreCase("Post")) continue;
                    String post = XMLDOMParser.getAttribute(op, "onlineResource");
                    if (post == null) continue;
                    result[1] = post;
                }
            }
        }
        return result;
    }

    private String[] getResultFormats(Node featureNode) {
        if (featureNode == null) {
            return null;
        }
        ArrayList<String> formats = new ArrayList<String>();
        NodeList fNodes = featureNode.getChildNodes();
        if (fNodes != null) {
            for (int j = 0; j < fNodes.getLength(); ++j) {
                NodeList frNodes;
                Node fn = fNodes.item(j);
                if (!fn.getNodeName().equalsIgnoreCase("ResultFormat") || (frNodes = fn.getChildNodes()) == null) continue;
                for (int i = 0; i < frNodes.getLength(); ++i) {
                    Node frNode = frNodes.item(i);
                    String format = frNode.getNodeName();
                    if (format == null || format.trim().length() <= 0 || format.trim().equalsIgnoreCase("#text")) continue;
                    formats.add(format.trim());
                }
                break;
            }
        }
        if (formats.size() == 0) {
            formats = null;
            return null;
        }
        return formats.toArray(new String[formats.size()]);
    }

    private void updateFeatureTypeParameters(XMLDOMParser parser, Node featuretypelistNode) {
        if (parser == null || featuretypelistNode == null) {
            return;
        }
        Object srs = null;
        if (!featuretypelistNode.getNodeName().equalsIgnoreCase("FeatureTypeList")) {
            return;
        }
        this.featureTypes.clear();
        NodeList featureNodes = featuretypelistNode.getChildNodes();
        if (featureNodes != null) {
            for (int k = 0; k < featureNodes.getLength(); ++k) {
                Node child = featureNodes.item(k);
                if (this.normalize(child.getNodeName()).equalsIgnoreCase("Operations")) {
                    this.serviceOperations.clear();
                    NodeList opNodes = child.getChildNodes();
                    if (opNodes == null) continue;
                    for (int j = 0; j < opNodes.getLength(); ++j) {
                        Node op = opNodes.item(j);
                        String opName = op.getNodeName();
                        if (opName == null || opName.trim().length() <= 0 || opName.trim().equalsIgnoreCase("#text")) continue;
                        this.serviceOperations.add(opName.trim());
                    }
                    continue;
                }
                if (!this.normalize(child.getNodeName()).equalsIgnoreCase("FeatureType")) continue;
                WfsFeatureType featType = new WfsFeatureType();
                NodeList ftypes = child.getChildNodes();
                for (int i = 0; i < ftypes.getLength(); ++i) {
                    Node urlvalue;
                    String format;
                    Node ftype = ftypes.item(i);
                    Node value = ftype.getFirstChild();
                    if (this.normalize(ftype.getNodeName()).equalsIgnoreCase("Name")) {
                        if (value == null) continue;
                        String ndvalue = value.getNodeValue().trim();
                        int index = ndvalue.indexOf(":");
                        if (index > -1) {
                            featType.setNameSpaceAlias(ndvalue.substring(0, index));
                            featType.setName(ndvalue.substring(index + 1, ndvalue.length()));
                            String nspUrl = XMLDOMParser.getAttribute(ftype, "xmlns:" + ndvalue.substring(0, index));
                            if (nspUrl == null || nspUrl.trim().length() <= 0) continue;
                            featType.setNameSpaceAliasURL(nspUrl.trim());
                            continue;
                        }
                        featType.setName(ndvalue);
                        continue;
                    }
                    if (this.normalize(ftype.getNodeName()).equalsIgnoreCase("Title")) {
                        if (value == null) continue;
                        featType.setTitle(value.getNodeValue().trim());
                        continue;
                    }
                    if (this.normalize(ftype.getNodeName()).equalsIgnoreCase("Abstract")) {
                        if (value == null) continue;
                        featType.setAbstract(value.getNodeValue().trim());
                        continue;
                    }
                    if (this.normalize(ftype.getNodeName()).equalsIgnoreCase("Keywords")) {
                        if (value == null) continue;
                        featType.setKeywords(value.getNodeValue().trim());
                        continue;
                    }
                    if (this.normalize(ftype.getNodeName()).equalsIgnoreCase("SRS")) {
                        if (value == null) continue;
                        featType.setSRS(value.getNodeValue().trim());
                        continue;
                    }
                    if (this.normalize(ftype.getNodeName()).equalsIgnoreCase("LatLongBoundingBox")) {
                        String minx = XMLDOMParser.getAttribute(ftype, "minx");
                        String miny = XMLDOMParser.getAttribute(ftype, "miny");
                        String maxx = XMLDOMParser.getAttribute(ftype, "maxx");
                        String maxy = XMLDOMParser.getAttribute(ftype, "maxy");
                        if (minx == null || miny == null || maxx == null || maxy == null) continue;
                        double[] latlong = new double[4];
                        try {
                            latlong[0] = Double.parseDouble(minx);
                            latlong[1] = Double.parseDouble(miny);
                            latlong[2] = Double.parseDouble(maxx);
                            latlong[3] = Double.parseDouble(maxy);
                            featType.setLatLongBoundingBox(latlong);
                        }
                        catch (Exception e) {
                            latlong = null;
                        }
                        continue;
                    }
                    if (!this.normalize(ftype.getNodeName()).equalsIgnoreCase("MetadataURL")) continue;
                    String mdtype = XMLDOMParser.getAttribute(ftype, "type");
                    if (mdtype != null && mdtype.trim().length() > 0) {
                        featType.setMetadataType(mdtype.trim());
                    }
                    if ((format = XMLDOMParser.getAttribute(ftype, "format")) != null && format.trim().length() > 0) {
                        featType.setMetadataFormat(format.trim());
                    }
                    if ((urlvalue = ftype.getFirstChild()) == null) continue;
                    featType.setMetadataURL(urlvalue.getNodeValue().trim());
                }
                if (featType.getNameSpaceAlias() != null) {
                    String nsurl;
                    String xmlns = XMLDOMParser.getAttribute(child, "xmlns");
                    if (xmlns != null && xmlns.trim().length() > 0) {
                        featType.setXMLNameSpace(xmlns.trim());
                    }
                    if ((nsurl = XMLDOMParser.getAttribute(child, "xmlns:" + featType.getNameSpaceAlias())) != null && nsurl.trim().length() > 0) {
                        featType.setNameSpaceAliasURL(nsurl.trim());
                    }
                }
                this.featureTypes.add(featType);
            }
        }
    }

    public String normalize(String nodeName) {
        if (nodeName == null) {
            return null;
        }
        if (nodeName.indexOf(":") >= 0) {
            return nodeName.substring(nodeName.indexOf(":") + 1);
        }
        return nodeName;
    }

    public WfsFeatureType getFeatureType(String feature) {
        if (feature == null || this.featureTypes.size() < 1) {
            return null;
        }
        for (int i = 0; i < this.featureTypes.size(); ++i) {
            WfsFeatureType wft = (WfsFeatureType)this.featureTypes.get(i);
            if (wft.getName() == null || !wft.getName().equalsIgnoreCase(feature)) continue;
            return wft;
        }
        return null;
    }

    public String getXmlNameSpace(String xmlns) {
        if (xmlns == null) {
            return null;
        }
        return (String)this.xmlnsValues.get(xmlns);
    }
}

