/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.spatial.geometry.JGeometry;

public class PolygonUtil {
    public static JGeometry[] getSimplifiedComponents(JGeometry geom, int simplyFactor, int filteringFactor) {
        if (geom == null) {
            return null;
        }
        JGeometry[] elements = geom.getElements();
        double maxSize = 0.0;
        for (int i = 0; i < elements.length; ++i) {
            double[] mbr;
            double s;
            if (elements[i] == null || elements[i].getType() != 3 && elements[i].getType() != 2 || !((s = Math.max((mbr = elements[i].getMBR())[2] - mbr[0], mbr[3] - mbr[1])) > maxSize)) continue;
            maxSize = s;
        }
        int count = 0;
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] != null && (elements[i].getType() == 3 || elements[i].getType() == 2)) {
                double[] mbr = elements[i].getMBR();
                double s = Math.max(mbr[2] - mbr[0], mbr[3] - mbr[1]);
                if (s * (double)filteringFactor >= maxSize) {
                    double threshold = Math.max(mbr[2] - mbr[0], mbr[3] - mbr[1]) / (double)simplyFactor;
                    elements[i] = elements[i].simplify(threshold);
                    ++count;
                    continue;
                }
                elements[i] = null;
                continue;
            }
            elements[i] = null;
        }
        if (count == elements.length) {
            return elements;
        }
        JGeometry[] results = new JGeometry[count];
        int j = 0;
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null) continue;
            results[j] = elements[i];
            ++j;
        }
        return results;
    }

    public static double[] findLabelBox(JGeometry geom) {
        return PolygonUtil.findLabelBox(geom, 0.6, 4.0);
    }

    public static double[] findLabelBox(JGeometry geom, double hwRatio, double centerWeight) {
        if (geom.isCircle()) {
            double[] mbr = geom.getMBR();
            double w = mbr[2] - mbr[0];
            double h = mbr[3] - mbr[1];
            mbr[0] = mbr[0] + w / 6.0;
            mbr[2] = mbr[2] - w / 6.0;
            mbr[1] = mbr[1] + h / 4.0;
            mbr[3] = mbr[3] - h / 4.0;
            return mbr;
        }
        if (geom.isRectangle()) {
            double[] mbr = geom.getMBR();
            return mbr;
        }
        JGeometry[] elements = PolygonUtil.getSimplifiedComponents(geom, 50, 5);
        if (elements == null) {
            return null;
        }
        double[] box = null;
        Object center = null;
        for (int i = 0; i < elements.length; ++i) {
            double minY;
            geom = elements[i];
            if (geom == null || !PolygonUtil.shouldFindLabelBox(elements[i])) continue;
            double[] mbr = geom.getMBR();
            int hLineNum = 31;
            Double[][] hInters = PolygonUtil.findHorizontalIntersectionsForSimplePolygon(geom, mbr[1], mbr[3], hLineNum);
            double gridHeight = (mbr[3] - mbr[1]) / (double)(hLineNum + 1);
            int centerYIdx = hLineNum / 2;
            int centerXIdx = PolygonUtil.findLongestSegment(hInters[centerYIdx]);
            double centerLen = hInters[centerYIdx][centerXIdx + 1] - hInters[centerYIdx][centerXIdx];
            int startYIdx = centerYIdx;
            double width = centerLen;
            double minX = hInters[centerYIdx][centerXIdx];
            double maxX = hInters[centerYIdx][centerXIdx + 1];
            double maxY = minY = mbr[1] + (double)(centerYIdx + 1) * gridHeight;
            double[] box1 = PolygonUtil.getOptimalBox(hInters, mbr, gridHeight, hLineNum, minX, maxX, minY, startYIdx, hwRatio);
            for (int j = 0; j < hLineNum; ++j) {
                int xIdx = PolygonUtil.findLongestSegment(hInters[j]);
                minX = hInters[j][xIdx];
                maxX = hInters[j][xIdx + 1];
                minY = mbr[1] + (double)(j + 1) * gridHeight;
                double[] box2 = PolygonUtil.getOptimalBox(hInters, mbr, gridHeight, hLineNum, minX, maxX, minY, j, hwRatio);
                if (!(PolygonUtil.getRectangleArea(box1) * centerWeight < PolygonUtil.getRectangleArea(box2))) continue;
                box1 = box2;
            }
            if (box != null && !(PolygonUtil.getRectangleArea(box1) > PolygonUtil.getRectangleArea(box))) continue;
            box = box1;
        }
        return box;
    }

    private static double[] getOptimalBox(Double[][] hInters, double[] mbr, double lineSpacing, int hLineNum, double minX, double maxX, double hy, int startYIdx, double hwRatio) {
        double[] box = new double[]{minX, hy, maxX, hy};
        double width = maxX - minX;
        boolean goingUp = true;
        boolean goingDown = true;
        int up = startYIdx + 1;
        int down = startYIdx - 1;
        while (goingUp || goingDown) {
            double y;
            if (up >= hLineNum) {
                goingUp = false;
            }
            if (down < 0) {
                goingDown = false;
            }
            double[] box1 = null;
            double[] box2 = null;
            if (goingUp) {
                y = mbr[1] + (double)(up + 1) * lineSpacing;
                box1 = PolygonUtil.expandBox(box, hInters[up], y);
            }
            if (goingDown) {
                y = mbr[1] + (double)(down + 1) * lineSpacing;
                box2 = PolygonUtil.expandBox(box, hInters[down], y);
            }
            double[] newBox = box1;
            if (PolygonUtil.getRectangleArea(box1) < PolygonUtil.getRectangleArea(box2)) {
                newBox = box2;
                if (goingUp) {
                    --up;
                }
            } else if (goingDown) {
                ++down;
            }
            if (newBox == null || PolygonUtil.getRectangleArea(newBox) < PolygonUtil.getRectangleArea(box) || (newBox[2] - newBox[0]) * hwRatio < newBox[3] - newBox[1]) break;
            box = newBox;
            ++up;
            --down;
        }
        return box;
    }

    private static double[] expandBox(double[] box, Double[] segments, double y) {
        double minX = box[0];
        double maxX = box[2];
        double tx1 = minX;
        double tx2 = maxX;
        double maxLen = 0.0;
        if (segments == null) {
            return null;
        }
        if (segments.length < 2) {
            return null;
        }
        for (int i = 1; i < segments.length; i += 2) {
            double len;
            double x1 = segments[i - 1];
            double x2 = segments[i];
            if (x1 >= maxX) break;
            if (x2 <= minX) continue;
            x1 = Math.max(x1, minX);
            if (!((x2 = Math.min(x2, maxX)) > x1) || !((len = x2 - x1) > maxLen)) continue;
            maxLen = len;
            tx1 = x1;
            tx2 = x2;
        }
        if (maxLen <= 0.0) {
            return null;
        }
        double[] newBox = new double[]{tx1, Math.min(box[1], y), tx2, Math.max(box[3], y)};
        return newBox;
    }

    private static int[] findLongestSegment(Double[][] segments) {
        int x = -1;
        int y = -1;
        double maxLen = 0.0;
        if (segments == null) {
            return null;
        }
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i].length < 2) continue;
            for (int j = 1; j < segments[i].length; j += 2) {
                double l = segments[i][j] - segments[i][j - 1];
                if (!(l > maxLen)) continue;
                x = j - 1;
                y = i;
                maxLen = l;
            }
        }
        if (x < 0) {
            return null;
        }
        int[] result = new int[]{x, y};
        return result;
    }

    private static int findLongestSegment(Double[] segments) {
        int x = -1;
        double maxLen = 0.0;
        if (segments == null) {
            return -1;
        }
        if (segments.length < 2) {
            return -1;
        }
        for (int j = 1; j < segments.length; j += 2) {
            double l = segments[j] - segments[j - 1];
            if (!(l > maxLen)) continue;
            x = j - 1;
            maxLen = l;
        }
        return x;
    }

    private static Double[][] findHorizontalIntersectionsForSimplePolygon(JGeometry geom, double minY, double maxY, int hLineNum) {
        int[] elemInfoArray = geom.getElemInfo();
        int numElements = elemInfoArray.length / 3;
        int dim = geom.getDimensions();
        double[] coords = geom.getOrdinatesArray();
        ArrayList[] intersections = new ArrayList[hLineNum];
        for (int j = 0; j < intersections.length; ++j) {
            intersections[j] = new ArrayList(10);
        }
        for (int i = 0; i < numElements; ++i) {
            int startIdx = elemInfoArray[i * 3] - 1;
            int endIdx = coords.length;
            if (elemInfoArray.length > i * 3 + 3) {
                endIdx = elemInfoArray[i * 3 + 3] - 1;
            }
            if (elemInfoArray[i * 3 + 1] % 10 != 3) continue;
            if (elemInfoArray[i * 3 + 2] == 3) {
                PolygonUtil.addHorizontalIntersectionsForRectangle(intersections, minY, maxY, hLineNum, coords, dim, startIdx, endIdx);
                continue;
            }
            PolygonUtil.addHorizontalIntersectionsForRing(intersections, minY, maxY, hLineNum, coords, dim, startIdx, endIdx);
        }
        Double[][] result = new Double[intersections.length][];
        for (int j = 0; j < intersections.length; ++j) {
            ArrayList array = intersections[j];
            if (array == null || array.size() <= 0) continue;
            result[j] = new Double[array.size()];
            result[j] = array.toArray(result[j]);
            Arrays.sort(result[j]);
        }
        return result;
    }

    private static void addHorizontalIntersectionsForRectangle(ArrayList[] intersections, double minY, double maxY, int yNum, double[] coords, int dim, int startIdx, int endIdx) {
        double tmp;
        double rectX1 = coords[startIdx];
        double rectY1 = coords[startIdx + 1];
        double rectX2 = coords[startIdx + dim];
        double rectY2 = coords[startIdx + 1 + dim];
        if (rectX1 > rectX2) {
            tmp = rectX1;
            rectX1 = rectX2;
            rectX2 = tmp;
        }
        if (rectY1 > rectY2) {
            tmp = rectY1;
            rectY1 = rectY2;
            rectY2 = tmp;
        }
        double step = (maxY - minY) / (double)yNum;
        double y = minY;
        int i = 0;
        while (i < yNum) {
            if (!(y < rectY1) && !(y > rectY2)) {
                intersections[i].add(new Double(rectX1));
                intersections[i].add(new Double(rectX2));
            }
            ++i;
            y += step;
        }
    }

    private static void addHorizontalIntersectionsForRing(ArrayList[] intersections, double minY, double maxY, int yNum, double[] coords, int dim, int startIdx, int endIdx) {
        double step = (maxY - minY) / (double)(yNum + 1);
        for (int i = startIdx + dim; i < endIdx; i += dim) {
            int idx2;
            double startX = coords[i - dim];
            double startY = coords[i - dim + 1];
            double endX = coords[i];
            double endY = coords[i + 1];
            int idx1 = PolygonUtil.findLowerYIdx(minY, maxY, yNum, step, startY);
            if (idx1 == (idx2 = PolygonUtil.findLowerYIdx(minY, maxY, yNum, step, endY)) || idx1 <= 0 && idx2 <= 0 || idx1 >= yNum && idx2 >= yNum) continue;
            int syIdx = idx1;
            int eyIdx = idx2;
            if (syIdx > eyIdx) {
                int tmp = syIdx;
                syIdx = eyIdx;
                eyIdx = tmp;
            }
            if (syIdx < 0) {
                syIdx = 0;
            }
            if (eyIdx > yNum) {
                eyIdx = yNum;
            }
            for (int j = syIdx; j < eyIdx; ++j) {
                double hy = minY + (double)(j + 1) * step;
                double intsectX = PolygonUtil.getHorizontalIntersection(startX, startY, endX, endY, hy);
                if (intsectX == Double.NEGATIVE_INFINITY) continue;
                intersections[j].add(new Double(intsectX));
                if (startY == endY) {
                    intersections[j].add(new Double(endX));
                }
                if (endY != hy || !PolygonUtil.shouldDuplicateEndPoint(coords, dim, i + 1)) continue;
                intersections[j].add(new Double(intsectX));
            }
        }
    }

    private static boolean shouldDuplicateEndPoint(double[] coords, int dim, int idx) {
        double lastY = coords[idx - dim];
        double nextY = Double.NaN;
        double currentY = coords[idx];
        if (coords.length > idx + dim) {
            nextY = coords[idx + dim];
        } else if (coords[0] != coords[idx - 1] && coords[1] != currentY) {
            nextY = coords[1];
        } else {
            return false;
        }
        return lastY <= currentY && nextY <= currentY || lastY >= currentY && nextY >= currentY;
    }

    private static double[] createPoint(double x, double y) {
        double[] point = new double[]{x, y};
        return point;
    }

    private static int findLowerYIdx(double minY, double maxY, int stepNumber, double step, double y) {
        if (y < minY) {
            return -1;
        }
        if (y > maxY) {
            return stepNumber + 1;
        }
        if (y == minY) {
            return 0;
        }
        if (y == maxY) {
            return stepNumber;
        }
        return (int)((y - minY) / step);
    }

    private static double getHorizontalIntersection(double startX, double startY, double endX, double endY, double hy) {
        if (startY > hy && endY > hy || startY < hy && endY < hy) {
            return Double.NEGATIVE_INFINITY;
        }
        if (startY == hy) {
            return startX;
        }
        if (endY == hy) {
            return endX;
        }
        double hx = startX + (hy - startY) * (endX - startX) / (endY - startY);
        return hx;
    }

    private static double getRectangleArea(double[] rect) {
        if (rect == null) {
            return 0.0;
        }
        return (rect[2] - rect[0]) * (rect[3] - rect[1]);
    }

    private static double[] getCenter(JGeometry geom) {
        double[] coords = geom.getOrdinatesArray();
        int dim = geom.getDimensions();
        double xSum = 0.0;
        double ySum = 0.0;
        for (int i = 0; i < coords.length; i += dim) {
            xSum += coords[i];
            ySum += coords[i + 1];
        }
        double[] center = new double[2];
        int cnum = coords.length / dim;
        center[0] = xSum / (double)cnum;
        center[1] = ySum / (double)cnum;
        return center;
    }

    private static boolean shouldFindLabelBox(JGeometry geom) {
        return geom.getType() != 1 && geom.getType() != 5 && geom.getType() != 2 && geom.getType() != 6;
    }
}

