/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.mapviewer.share.AnnotationTextMetadata;
import oracle.mapviewer.share.ArrayParameter;
import oracle.mapviewer.share.AttributeGroup;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.FieldArray;
import oracle.mapviewer.share.NetworkMetadata;
import oracle.mapviewer.share.Sequence;
import oracle.mapviewer.share.SpatialColumnExtent;
import oracle.mapviewer.share.SpatialTableMetadata;
import oracle.mapviewer.share.TopoChildFeatureDescriptor;
import oracle.mapviewer.share.TopoFeatureDescriptor;
import oracle.mapviewer.share.TopoPrimitiveDescriptor;
import oracle.mapviewer.share.TopologyEdge;
import oracle.mapviewer.share.TopologyFace;
import oracle.mapviewer.share.TopologyMetadata;
import oracle.mapviewer.share.TopologyNode;
import oracle.mapviewer.share.TopologyPrimitives;
import oracle.mapviewer.share.TopologyRelation;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.util.ORAWorkspaceJDBCUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.type.SdoTglObject;
import oracle.spatial.type.SdoTglObjectArray;
import oracle.spatial.type.SdoTopoGeometry;
import oracle.spatial.type.SdoTopoObject;
import oracle.spatial.type.SdoTopoObjectArray;
import oracle.spatial.util.WKB;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.NUMBER;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class JDBCUtil {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static Method struct_unwrap = null;
    private static Method clob_unwrap = null;
    private static Method blob_unwrap = null;
    private static Method array_unwrap = null;

    public static JSDOGeometry loadGeometry(ResultSet rs, int columnIndex, boolean useCustomPickler) throws Exception {
        JGeometry[] elems;
        JSDOGeometry geom = null;
        STRUCT struct = null;
        if (useCustomPickler) {
            byte[] bytes = ((OracleResultSet)rs).getBytes(columnIndex);
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            geom = JSDOGeometry.loadFromDB(bytes);
        } else {
            Object o = rs.getObject(columnIndex);
            if (o == null) {
                return null;
            }
            try {
                struct = (STRUCT)o;
            }
            catch (ClassCastException ex) {
                if (struct_unwrap == null && (struct_unwrap = o.getClass().getMethod("unwrap", Class.class)) != null) {
                    log.fine("Got WLS unwrap method for STRUCT through introspect.");
                }
                if (struct_unwrap != null) {
                    struct = (STRUCT)struct_unwrap.invoke(o, STRUCT.class);
                }
                throw ex;
            }
            geom = JSDOGeometry.loadFromDB(struct);
        }
        boolean hasNURBSElem = false;
        if (geom != null && geom.getType() % 1000 != 1 && (elems = geom.getElements()) != null && elems.length > 0) {
            for (int k = 0; k < elems.length; ++k) {
                int[] elemInfo = elems[k].getElemInfo();
                if (elemInfo == null || elemInfo.length < 3 || elemInfo[1] != 2 || elemInfo[2] != 3) continue;
                hasNURBSElem = true;
                break;
            }
        }
        if (!hasNURBSElem) {
            return geom;
        }
        return JSDOGeometry.recast(JGeometry.getNurbsApprox((JGeometry)geom));
    }

    public static STRUCT getOracleSTRUCT(ResultSet rs, int columnIndex) throws Exception {
        Object o = rs.getObject(columnIndex);
        if (o == null) {
            return null;
        }
        STRUCT struct = null;
        try {
            struct = (STRUCT)o;
            return struct;
        }
        catch (ClassCastException ex) {
            if (struct_unwrap == null && (struct_unwrap = o.getClass().getMethod("unwrap", Class.class)) != null) {
                log.fine("Got WLS unwrap method for STRUCT through introspect.");
            }
            if (struct_unwrap != null) {
                struct = (STRUCT)struct_unwrap.invoke(o, STRUCT.class);
                return struct;
            }
            throw ex;
        }
    }

    public static CLOB safeCastCLOB(Clob clob) throws Exception {
        CLOB res = null;
        try {
            res = (CLOB)clob;
            return res;
        }
        catch (ClassCastException ex) {
            if (clob_unwrap == null && (clob_unwrap = clob.getClass().getMethod("unwrap", Class.class)) != null) {
                log.fine("Got WLS unwrap method for CLOB through introspect.");
            }
            if (clob_unwrap != null) {
                res = (CLOB)clob_unwrap.invoke((Object)clob, CLOB.class);
                return res;
            }
            return null;
        }
    }

    public static BLOB safeCastBLOB(Blob blob) throws Exception {
        BLOB res = null;
        try {
            res = (BLOB)blob;
            return res;
        }
        catch (ClassCastException ex) {
            if (blob_unwrap == null && (blob_unwrap = blob.getClass().getMethod("unwrap", Class.class)) != null) {
                log.fine("Got WLS unwrap method for BLOB through introspect.");
            }
            if (blob_unwrap != null) {
                res = (BLOB)blob_unwrap.invoke((Object)blob, BLOB.class);
                return res;
            }
            return null;
        }
    }

    public static AnnotationText loadAnnotationText(ResultSet rs, String column) throws Exception {
        AnnotationText geom = null;
        STRUCT struct = null;
        Object o = rs.getObject(column);
        if (o == null) {
            return null;
        }
        try {
            struct = (STRUCT)o;
        }
        catch (ClassCastException ex) {
            if (struct_unwrap == null && (struct_unwrap = o.getClass().getMethod("unwrap", Class.class)) != null) {
                log.fine("Got WLS unwrap method for STRUCT through introspect.");
            }
            if (struct_unwrap != null) {
                struct = (STRUCT)struct_unwrap.invoke(o, STRUCT.class);
            }
            throw ex;
        }
        geom = AnnotationText.load(struct);
        return geom;
    }

    public static ARRAY safeCastARRAY(Object array) throws Exception {
        ARRAY res = null;
        try {
            res = (ARRAY)array;
            return res;
        }
        catch (ClassCastException ex) {
            if (array_unwrap == null && (array_unwrap = array.getClass().getMethod("unwrap", Class.class)) != null) {
                log.fine("Got WLS unwrap method for ARRAY through introspect.");
            }
            if (array_unwrap != null) {
                res = (ARRAY)array_unwrap.invoke(array, ARRAY.class);
                return res;
            }
            return null;
        }
    }

    public static ARRAY createSQLArray(ArrayParameter ap, Connection conn) throws SQLException {
        String dataSource = ap.getDataSource();
        Hashtable descTable = ArrayParameter.getDescriptorTable();
        String typeName = ap.getTypeName();
        Object value = ap.getValue();
        ArrayDescriptor desc = null;
        if (dataSource != null) {
            desc = (ArrayDescriptor)descTable.get(dataSource + ":" + typeName);
            if (desc == null) {
                desc = ArrayDescriptor.createDescriptor((String)typeName, (Connection)conn);
                descTable.put(dataSource + ":" + typeName, desc);
            }
        } else {
            desc = ArrayDescriptor.createDescriptor((String)typeName, (Connection)conn);
        }
        return new ARRAY(desc, conn, value);
    }

    public static JSDOGeometry loadGeometryFromJavaDB(ResultSet rs, int columnIndex) throws Exception {
        JGeometry geo = null;
        Blob blobGeom = rs.getBlob(columnIndex);
        if (blobGeom != null) {
            WKB wkb = new WKB();
            try {
                byte[] geomDef = blobGeom.getBytes(1L, (int)blobGeom.length());
                if (geomDef != null && (geo = wkb.toJGeometry(geomDef)) != null) {
                    return JSDOGeometry.recast(geo);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public static String[] getNonNullAttributes(Connection conn, String tableName) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (tableName == null) {
            throw new Exception("Table name name is null.");
        }
        Vector<String> columns = new Vector<String>();
        Statement st = null;
        ResultSet rs = null;
        String querystr = null;
        try {
            querystr = "select * from " + tableName + " where rownum < 1";
            st = conn.prepareStatement(querystr);
            rs = st.executeQuery();
            ResultSetMetaData rsmeta = rs.getMetaData();
            int colCnt = rsmeta.getColumnCount();
            for (int i = 1; i <= colCnt; ++i) {
                String typename = rsmeta.getColumnTypeName(i);
                String colname = rsmeta.getColumnName(i);
                int isnull = rsmeta.isNullable(i);
                if (isnull != 0) continue;
                columns.add(colname);
            }
        }
        catch (Exception ex) {
            log.severe(querystr + "\n" + ex);
            columns.clear();
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        if (columns.size() == 0) {
            return null;
        }
        return columns.toArray(new String[columns.size()]);
    }

    public static String[] getPrimaryKeyColumns(Connection conn, String table) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name name is null.");
        }
        ResultSet rs = null;
        ArrayList<String> pkNames = new ArrayList<String>();
        try {
            DatabaseMetaData meta = conn.getMetaData();
            rs = meta.getPrimaryKeys(null, null, table.toUpperCase());
            while (rs.next()) {
                pkNames.add(rs.getString(4));
            }
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
            pkNames.clear();
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
        }
        if (pkNames.size() == 0) {
            return null;
        }
        if (pkNames.size() > 0) {
            Collections.sort(pkNames);
        }
        return pkNames.toArray(new String[pkNames.size()]);
    }

    public static boolean createTable(Connection conn, String newTable, String templateTable) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (newTable == null) {
            throw new Exception("Table name name is null.");
        }
        if (templateTable == null) {
            throw new Exception("Template table name is null.");
        }
        Statement st = null;
        ResultSet rs = null;
        String createStmt = null;
        try {
            createStmt = "create table " + newTable + " as select * from " + templateTable + " where rownum < 1";
            st = conn.prepareStatement(createStmt);
            st.execute();
        }
        catch (Exception ex) {
            log.severe(createStmt + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return true;
    }

    public static boolean createTable(Connection conn, String table, String[] columns, String[] types, boolean[] notNull, String primaryKey) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("New Table name is null.");
        }
        if (columns == null || columns.length == 0 || types == null || types.length == 0 || notNull == null || notNull.length == 0) {
            throw new Exception("Column names, types, and non null parameters must be defined.");
        }
        if (columns.length != types.length || columns.length != notNull.length) {
            throw new Exception("Column names, types, and non null parameters must have same size.");
        }
        Statement st = null;
        ResultSet rs = null;
        String createTable = null;
        try {
            createTable = "create table " + table + "(\n";
            for (int i = 0; i < columns.length; ++i) {
                if (i > 0) {
                    createTable = createTable + ",\n";
                }
                createTable = createTable + columns[i] + " " + types[i];
                if (!notNull[i]) continue;
                createTable = createTable + " NOT NULL";
            }
            createTable = primaryKey != null ? createTable + ",\n PRIMARY KEY (" + primaryKey + ")\n)" : createTable + "\n)";
            st = conn.prepareStatement(createTable);
            st.execute();
        }
        catch (Exception ex) {
            log.severe(createTable + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return true;
    }

    public static boolean createTopology(Connection conn, String topology, double tolerance, int srid) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (topology == null) {
            throw new Exception("Topology name is null.");
        }
        Statement callstmt = null;
        Statement stmt = null;
        String callStr = null;
        boolean autoCommit = conn.getAutoCommit();
        try {
            conn.setAutoCommit(false);
            callStr = "declare\nbegin\nsdo_topo.create_topology('" + topology + "'," + tolerance + "," + srid + ");\n" + "end;\n";
            callstmt = conn.prepareCall(callStr);
            callstmt.execute();
            callstmt.close();
            callStr = "declare\nbegin\nsdo_topo.initialize_metadata('" + topology + "'" + ");\n" + "end;\n";
            callstmt = conn.prepareCall(callStr);
            callstmt.execute();
            String query = "insert into " + topology + "_face$ (face_id) values (-1)";
            stmt = conn.prepareStatement(query);
            stmt.executeUpdate();
            if (autoCommit) {
                conn.commit();
            }
        }
        catch (Exception ex) {
            if (autoCommit) {
                try {
                    conn.rollback();
                }
                catch (Exception rb) {
                    // empty catch block
                }
            }
            log.severe(callStr + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (callstmt != null) {
                try {
                    callstmt.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
            conn.setAutoCommit(autoCommit);
        }
        return true;
    }

    public static boolean relateFeatureTableWithTopology(Connection conn, String topology, String featureTable, String topoColumn, String topoFeatureType, int childLayerId) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (topology == null) {
            throw new Exception("Topology name is null.");
        }
        if (featureTable == null) {
            throw new Exception("Feature table name is null.");
        }
        if (topoColumn == null) {
            throw new Exception("Topology column name is null");
        }
        if (topoFeatureType == null) {
            throw new Exception("Topology feature type is null");
        }
        Statement callstmt = null;
        String callStr = null;
        boolean autoCommit = conn.getAutoCommit();
        try {
            conn.setAutoCommit(false);
            callStr = "declare\nbegin\nsdo_topo.add_topo_geometry_layer('" + topology.toUpperCase() + "'," + "'" + featureTable.toUpperCase() + "'," + "'" + topoColumn.toUpperCase() + "'," + "'" + topoFeatureType.toUpperCase() + "'";
            if (childLayerId > 0) {
                callStr = callStr + ",null," + childLayerId;
            }
            callStr = callStr + ");\nend;\n";
            callstmt = conn.prepareCall(callStr);
            callstmt.execute();
            conn.commit();
        }
        catch (Exception ex) {
            log.severe(callStr + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (callstmt != null) {
                try {
                    callstmt.close();
                }
                catch (Exception re) {}
            }
            conn.setAutoCommit(autoCommit);
        }
        return true;
    }

    public static boolean createGeometryMetadata(Connection conn, String newTable, String templateTable, String templateGeomColumn) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (newTable == null) {
            throw new Exception("New table name is null.");
        }
        if (templateTable == null || templateGeomColumn == null) {
            log.warning("Template table, and template geometry column must be defined.");
            throw new Exception("Template table, and template geometry column must be defined.");
        }
        Statement st = null;
        ResultSet rs = null;
        String createMeta = null;
        try {
            createMeta = "insert into user_sdo_geom_metadata select '" + newTable.toUpperCase() + "', column_name, diminfo,srid from " + " user_sdo_geom_metadata where table_name = :1 and " + " column_name = :2";
            st = conn.prepareStatement(createMeta);
            st.setString(1, templateTable.toUpperCase());
            st.setString(2, templateGeomColumn.toUpperCase());
            st.execute();
        }
        catch (Exception ex) {
            log.info("SQL: " + createMeta + "\nTemplate Table: " + templateTable.toUpperCase() + "\nTemplate Column: " + templateGeomColumn.toUpperCase());
            log.severe("Exception: " + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return true;
    }

    public static boolean createGeometryMetadata(Connection conn, String table, String geomColumn, String[] dimName, double[] min, double[] max, double[] tol, long srid) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name is null.");
        }
        if (geomColumn == null) {
            throw new Exception("Geometry column name is null.");
        }
        if (dimName == null || dimName.length == 0 || min == null || min.length == 0 || max == null || max.length == 0 || tol == null || tol.length == 0) {
            throw new Exception("Dimension array elements must be defined.");
        }
        if (min.length != dimName.length || min.length != max.length || min.length != tol.length) {
            throw new Exception("Dimension array elements must be of same size.");
        }
        int dim = min.length;
        Statement st = null;
        ResultSet rs = null;
        String createMeta = null;
        try {
            createMeta = "insert into user_sdo_geom_metadata values (\n";
            createMeta = createMeta + "'" + table.toUpperCase() + "',\n" + "'" + geomColumn.toUpperCase() + "',\n" + "MDSYS.SDO_DIM_ARRAY(\n";
            for (int i = 0; i < dim; ++i) {
                if (i > 0) {
                    createMeta = createMeta + ",\n";
                }
                createMeta = createMeta + "MDSYS.SDO_DIM_ELEMENT('" + dimName[i] + "'," + min[i] + ", " + max[i] + ", " + tol[i] + ")";
            }
            createMeta = createMeta + "\n),\n" + (srid == 0L ? "null" : Long.valueOf(srid)) + "\n)";
            st = conn.prepareStatement(createMeta);
            st.execute();
        }
        catch (Exception ex) {
            log.severe(createMeta + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return true;
    }

    public static boolean createAnnotationTextMetadata(Connection conn, String table, String atextColumn, Double baseScale, String textExpression, String graphicAttrs) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name is null.");
        }
        if (atextColumn == null || graphicAttrs == null) {
            throw new Exception("Annotation text column, and graphic attributes must be defined.");
        }
        Statement st = null;
        String createMeta = null;
        try {
            createMeta = "insert into user_annotation_text_metadata values(\n";
            createMeta = createMeta + "'" + table.toUpperCase() + "',\n" + "'" + atextColumn.toUpperCase() + "',\n";
            createMeta = Double.isNaN(baseScale) || Double.isInfinite(baseScale) || baseScale <= 0.0 ? createMeta + "null," : createMeta + "" + baseScale + ",";
            createMeta = textExpression == null ? createMeta + "null,\n" : createMeta + "'" + textExpression + "',\n";
            createMeta = graphicAttrs == null ? createMeta + "null)" : createMeta + "'" + graphicAttrs + "')";
            st = conn.prepareStatement(createMeta);
            st.execute();
        }
        catch (Exception ex) {
            log.severe(createMeta + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return true;
    }

    public static boolean deleteGeometryMetadata(Connection conn, String tableName, String sptColumnName) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (tableName == null) {
            throw new Exception("Table name is null.");
        }
        if (sptColumnName == null) {
            throw new Exception("Spatial column name is null.");
        }
        Statement dropStmt = null;
        String delStmt = null;
        boolean autoCommit = conn.getAutoCommit();
        try {
            conn.setAutoCommit(false);
            delStmt = "delete from user_sdo_geom_metadata where table_name = :1 and column_name = :2";
            dropStmt = conn.prepareStatement(delStmt);
            dropStmt.setString(1, tableName.toUpperCase());
            dropStmt.setString(2, sptColumnName.toUpperCase());
            dropStmt.executeUpdate();
            conn.commit();
        }
        catch (Exception ex) {
            log.severe(delStmt + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (dropStmt != null) {
                try {
                    dropStmt.close();
                }
                catch (Exception re) {}
            }
            conn.setAutoCommit(autoCommit);
        }
        return true;
    }

    public static boolean deleteAnnotationTextMetadata(Connection conn, String tableName, String sptColumnName) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (tableName == null) {
            throw new Exception("Table name is null.");
        }
        if (sptColumnName == null) {
            throw new Exception("Spatial column name is null.");
        }
        Statement dropStmt = null;
        String delStmt = null;
        boolean autoCommit = conn.getAutoCommit();
        try {
            conn.setAutoCommit(false);
            delStmt = "delete from user_annotation_text_metadata where table_name = :1 and column_name = :2";
            dropStmt = conn.prepareStatement(delStmt);
            dropStmt.setString(1, tableName.toUpperCase());
            dropStmt.setString(2, sptColumnName.toUpperCase());
            dropStmt.executeUpdate();
            conn.commit();
        }
        catch (Exception ex) {
            log.severe(delStmt + "\n" + ex);
            throw ex;
        }
        finally {
            if (dropStmt != null) {
                try {
                    dropStmt.close();
                }
                catch (Exception re) {}
            }
            conn.setAutoCommit(autoCommit);
        }
        return true;
    }

    public static boolean createSpatialIndex(Connection conn, String indexName, String tableName, String spatialColumn) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (indexName == null) {
            throw new Exception("Index name is null.");
        }
        if (tableName == null) {
            throw new Exception("Table name is null.");
        }
        if (spatialColumn == null) {
            throw new Exception("Spatial column name is null.");
        }
        Statement pstmt = null;
        String createIndex = null;
        boolean autoCommit = conn.getAutoCommit();
        try {
            conn.setAutoCommit(false);
            createIndex = "create index " + indexName.toUpperCase() + " on " + tableName + "(" + spatialColumn + ") indextype is mdsys.spatial_index";
            pstmt = conn.prepareStatement(createIndex);
            pstmt.execute();
            conn.commit();
        }
        catch (Exception ex) {
            log.severe(createIndex + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {}
            }
            conn.setAutoCommit(autoCommit);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dropTable(Connection conn, String tableName) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (tableName == null) {
            throw new Exception("Table name is null.");
        }
        Statement dropStmt = null;
        String dropstmt = null;
        boolean autoCommit = false;
        try {
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            dropstmt = "Drop table " + tableName.toUpperCase();
            dropStmt = conn.prepareStatement(dropstmt);
            dropStmt.executeUpdate();
            conn.commit();
        }
        catch (Exception ex) {
            log.severe(dropstmt + "\n" + ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (dropStmt != null) {
                try {
                    dropStmt.close();
                }
                catch (Exception re) {}
            }
            conn.setAutoCommit(autoCommit);
        }
        return true;
    }

    public static boolean dropIndex(Connection conn, String indexName) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (indexName == null) {
            throw new Exception("Index name is null.");
        }
        Statement dropStmt = null;
        String dropstmt = null;
        boolean autoCommit = conn.getAutoCommit();
        try {
            conn.setAutoCommit(false);
            dropstmt = "Drop index " + indexName.toUpperCase();
            dropStmt = conn.prepareStatement(dropstmt);
            dropStmt.executeUpdate();
            conn.commit();
        }
        catch (Exception ex) {
            log.severe(dropstmt + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (dropStmt != null) {
                try {
                    dropStmt.close();
                }
                catch (Exception re) {}
            }
            conn.setAutoCommit(autoCommit);
        }
        return true;
    }

    public static SpatialColumnExtent getSpatialColumnExtent(Connection conn, String owner, String table, String spatialColumn, String spatialType) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name is null.");
        }
        if (spatialColumn == null) {
            throw new Exception("Spatial column name is null.");
        }
        String user = owner;
        if (user == null) {
            user = conn.getMetaData().getUserName();
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        String query = null;
        SpatialColumnExtent sce = null;
        try {
            query = "select s.sdo_root_mbr, s.sdo_index_geodetic, g.srid from user_indexes i, user_sdo_index_metadata s, user_sdo_geom_metadata g where s.sdo_index_name = i.index_name and g.table_name = i.table_name and i.table_owner = :1 and i.table_name = :2 and g.column_name = :3 and s.sdo_column_name = :4";
            st = conn.prepareStatement(query);
            st.setString(1, user.toUpperCase());
            st.setString(2, table.toUpperCase());
            if (spatialType != null && spatialType.equalsIgnoreCase(SpatialTableMetadata.ANNOTATION_TYPE)) {
                st.setString(3, spatialColumn.toUpperCase() + ".PRIVATEENVELOPE");
                st.setString(4, "\"" + spatialColumn.toUpperCase() + "\".\"PRIVATEENVELOPE\"");
            } else if (spatialType != null && spatialType.equalsIgnoreCase(SpatialTableMetadata.GEORASTER_TYPE)) {
                st.setString(3, spatialColumn.toUpperCase() + ".SPATIALEXTENT");
                st.setString(4, "\"" + spatialColumn.toUpperCase() + "\".\"SPATIALEXTENT\"");
            } else {
                st.setString(3, spatialColumn.toUpperCase());
                st.setString(4, "\"" + spatialColumn.toUpperCase() + "\"");
            }
            rs = st.executeQuery();
            if (rs.next()) {
                JSDOGeometry geom = JDBCUtil.loadGeometry(rs, 1, false);
                if (geom == null) {
                    SpatialColumnExtent spatialColumnExtent = null;
                    return spatialColumnExtent;
                }
                boolean geodetic = rs.getString("sdo_index_geodetic").equalsIgnoreCase("TRUE");
                Rectangle2D mbrR = Util.geom2MBR(geom, geodetic);
                sce = new SpatialColumnExtent();
                sce.setTableName(table);
                sce.setColumnName(spatialColumn);
                sce.setExtent(new double[]{mbrR.getMinX(), mbrR.getMinY(), mbrR.getMaxX(), mbrR.getMaxY()});
                sce.setSRID(rs.getInt("srid"));
            }
        }
        catch (Exception ex) {
            log.severe(query + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return sce;
    }

    public static boolean tableValueExists(Connection conn, String table, String column, String value) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name is null.");
        }
        if (column == null) {
            throw new Exception("Column name is null.");
        }
        if (value == null) {
            throw new Exception("Value is null.");
        }
        Statement st = null;
        ResultSet rs = null;
        String query = null;
        try {
            query = "select rowid from " + table.toUpperCase() + " where " + column.toUpperCase() + " = :1";
            st = conn.prepareStatement(query);
            st.setString(1, value);
            rs = st.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        catch (Exception ex) {
            log.severe(query + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
    }

    public static String getSpatialIndex(Connection conn, String tableName, String spatialColumn) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (tableName == null) {
            throw new Exception("Table name is null.");
        }
        if (spatialColumn == null) {
            throw new Exception("Spatial column name is null.");
        }
        String indexName = null;
        Statement st = null;
        ResultSet rs = null;
        String querystr = null;
        String owner = null;
        String tbName = tableName;
        try {
            String user;
            owner = user = conn.getMetaData().getUserName();
            int index = tableName.indexOf(".");
            if (index > -1) {
                owner = tableName.substring(0, index);
                tbName = tableName.substring(index + 1, tableName.length());
            }
            querystr = "select index_name from all_sdo_index_info where table_name = :1 and column_name = :2 and table_owner = :3";
            st = conn.prepareStatement(querystr);
            st.setString(1, tableName.toUpperCase());
            st.setString(2, spatialColumn.toUpperCase());
            st.setString(3, owner.toUpperCase());
            rs = st.executeQuery();
            if (rs.next()) {
                indexName = rs.getString(1);
            }
        }
        catch (Exception ex) {
            log.severe(querystr + "\n" + ex.getMessage());
            indexName = null;
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return indexName;
    }

    public static PreparedStatement prepareEditInsertStatement(Connection conn, String spatialType, Field[] attributes, Object spatialObject, String baseTable, String spatialColumn, String keyColumn) throws Exception {
        int k;
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (spatialType == null) {
            throw new Exception("Spatial type name is null.");
        }
        if (baseTable == null) {
            throw new Exception("Base table name is null.");
        }
        if (spatialColumn == null) {
            throw new Exception("Spatial column is null.");
        }
        if (keyColumn == null) {
            throw new Exception("Data Set key column is null.");
        }
        if (!(spatialType.equalsIgnoreCase(SpatialTableMetadata.GEOMETRY_TYPE) || spatialType.equalsIgnoreCase(SpatialTableMetadata.ANNOTATION_TYPE) || spatialType.equalsIgnoreCase(SpatialTableMetadata.TOPOFEATURE_TYPE))) {
            throw new Exception("Invalid spatial type.");
        }
        String sptCol = spatialColumn;
        String sptBinding = "?";
        String keyValue = "?";
        Object var = spatialObject;
        if (var == null) {
            sptCol = null;
            sptBinding = null;
        }
        Field[] attrs = attributes;
        String sql = "insert into " + baseTable + "\n(";
        if (sptCol != null) {
            sql = sql + sptCol;
        }
        if (attrs != null && attrs.length > 0) {
            for (k = 0; k < attrs.length; ++k) {
                sql = k == 0 && sptCol == null ? sql + attrs[k].getName() : sql + "," + attrs[k].getName();
                if (!keyColumn.equalsIgnoreCase(attrs[k].getName()) || attrs[k].getValue() == null) continue;
                keyValue = attrs[k].getValue().toString();
            }
        }
        sql = sql + ") \nvalues\n(";
        if (sptBinding != null) {
            sql = sql + sptBinding;
        }
        if (attrs != null && attrs.length > 0) {
            for (k = 0; k < attrs.length; ++k) {
                sql = k == 0 && sptBinding == null ? sql + "?" : sql + ",?";
            }
        }
        sql = sql + ")";
        log.finest("Insert sql for feature: " + keyValue + "\n" + sql);
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
            if (stmt == null) {
                return null;
            }
            int attrStartIndex = 2;
            if (var != null) {
                JDBCUtil.setBindingVariable(conn, stmt, var, 1);
            } else {
                attrStartIndex = 1;
            }
            if (attrs != null && attrs.length > 0) {
                for (int k2 = 0; k2 < attrs.length; ++k2) {
                    JDBCUtil.setBindingVariable(conn, stmt, attrs[k2], k2 + attrStartIndex);
                }
            }
        }
        catch (Exception e) {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            throw e;
        }
        return stmt;
    }

    public static PreparedStatement prepareEditUpdateStatement(Connection conn, String spatialType, Field[] attributes, Object spatialObject, String baseTable, String spatialColumn, String keyColumn) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (spatialType == null) {
            throw new Exception("Spatial type name is null.");
        }
        if (baseTable == null) {
            throw new Exception("Base table name is null.");
        }
        if (spatialColumn == null) {
            throw new Exception("Spatial column is null.");
        }
        if (keyColumn == null) {
            throw new Exception("Key column attribute is null.");
        }
        if (!(spatialType.equalsIgnoreCase(SpatialTableMetadata.GEOMETRY_TYPE) || spatialType.equalsIgnoreCase(SpatialTableMetadata.ANNOTATION_TYPE) || spatialType.equalsIgnoreCase(SpatialTableMetadata.TOPOFEATURE_TYPE))) {
            throw new Exception("Invalid spatial type.");
        }
        if (attributes == null || attributes.length == 0) {
            throw new Exception("At least key column must be part of the attribute list.");
        }
        Field keyField = null;
        String keyValue = null;
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equalsIgnoreCase(keyColumn)) continue;
            keyField = attributes[i];
            keyValue = keyField.getValue().toString();
            break;
        }
        if (keyField == null || keyValue == null) {
            throw new Exception("Key column is not defined or key value is null.");
        }
        String sql = "update " + baseTable + " set ";
        boolean columnAdded = false;
        if (spatialObject != null) {
            sql = sql + spatialColumn + " = ?";
            columnAdded = true;
        }
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i].getName().equalsIgnoreCase(keyColumn)) continue;
            sql = !columnAdded ? sql + attributes[i].getName().toUpperCase() + " = ?" : sql + ", " + attributes[i].getName().toUpperCase() + " = ?";
            columnAdded = true;
        }
        sql = sql + " where " + keyColumn + " = ?";
        log.finest("Update sql for feature: " + keyValue + "\n" + sql);
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
            if (stmt == null) {
                return null;
            }
            int attrStartIndex = 1;
            if (spatialObject != null) {
                JDBCUtil.setBindingVariable(conn, stmt, spatialObject, attrStartIndex++);
            }
            for (int i = 0; i < attributes.length; ++i) {
                if (attributes[i].getName().equalsIgnoreCase(keyColumn)) continue;
                JDBCUtil.setBindingVariable(conn, stmt, attributes[i], attrStartIndex++);
            }
            JDBCUtil.setBindingVariable(conn, stmt, keyField, attrStartIndex++);
        }
        catch (Exception e) {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            throw e;
        }
        return stmt;
    }

    public static void deleteEditFeatures(Connection conn, String baseTable, String keyColumn, String[] keys) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (baseTable == null) {
            throw new Exception("Base table name is null.");
        }
        if (keyColumn == null) {
            throw new Exception("Key column name is null.");
        }
        if (keys == null || keys.length == 0) {
            log.info("There no features to be deleted.");
            return;
        }
        Statement dStmt = null;
        try {
            log.finest("Deleting features...");
            String deleteSQL = "delete from " + baseTable + " where " + keyColumn + " = ?";
            log.finest(deleteSQL);
            dStmt = conn.prepareStatement(deleteSQL);
            for (int i = 0; i < keys.length; ++i) {
                log.finest("Deleting feature: " + keys[i]);
                JDBCUtil.setBindingVariable(conn, (PreparedStatement)dStmt, keys[i], 1);
                dStmt.addBatch();
            }
            if (dStmt != null) {
                ((OraclePreparedStatement)dStmt).executeBatch();
            }
            log.finest("Done with deleting features.");
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (dStmt != null) {
                try {
                    dStmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void saveEditedData(Connection conn, String spatialType, AttributeGroup[] toInsert, AttributeGroup[] toUpdate, String[] toDelete, String baseTable, String spatialColumn, String keyColumn) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (baseTable == null) {
            throw new Exception("Base table name is null.");
        }
        if (spatialColumn == null) {
            throw new Exception("Spatial column name is null.");
        }
        if (keyColumn == null) {
            throw new Exception("Base table name is null.");
        }
        Statement iStmt = null;
        Statement uStmt = null;
        Statement dStmt = null;
        boolean autoCommit = conn.getAutoCommit();
        try {
            int i;
            conn.setAutoCommit(false);
            if (toInsert != null && toInsert.length > 0) {
                for (i = 0; i < toInsert.length; ++i) {
                    iStmt = JDBCUtil.prepareEditInsertStatement(conn, spatialType, toInsert[i].getNonComplexAttributes(), toInsert[i].getSpatialAttribute(), baseTable, spatialColumn, keyColumn);
                    if (iStmt == null) continue;
                    iStmt.executeUpdate();
                    iStmt.close();
                }
            }
            if (toUpdate != null && toUpdate.length > 0) {
                for (i = 0; i < toUpdate.length; ++i) {
                    uStmt = JDBCUtil.prepareEditUpdateStatement(conn, spatialType, toUpdate[i].getNonComplexAttributes(), toUpdate[i].getSpatialAttribute(), baseTable, spatialColumn, keyColumn);
                    if (uStmt == null) continue;
                    uStmt.executeUpdate();
                    uStmt.close();
                }
            }
            if (toDelete != null && toDelete.length > 0) {
                JDBCUtil.deleteEditFeatures(conn, baseTable, keyColumn, toDelete);
            }
            if (autoCommit) {
                conn.commit();
            }
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
            if (autoCommit) {
                try {
                    log.warning("Rolling back any previous changes.");
                    conn.rollback();
                }
                catch (Exception re) {
                    // empty catch block
                }
            }
            throw ex;
        }
        finally {
            conn.setAutoCommit(autoCommit);
            if (iStmt != null) {
                try {
                    iStmt.close();
                }
                catch (Exception e) {}
            }
            if (uStmt != null) {
                try {
                    uStmt.close();
                }
                catch (Exception e) {}
            }
            if (dStmt != null) {
                try {
                    dStmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void setBindingVariable(Connection conn, PreparedStatement stmt, Object var, int idx) throws SQLException, IllegalArgumentException {
        if (conn == null) {
            throw new IllegalArgumentException("Connection object is null.");
        }
        if (var instanceof String) {
            stmt.setString(idx, (String)var);
        } else if (var instanceof Integer) {
            stmt.setInt(idx, (Integer)var);
        } else if (var instanceof Double) {
            stmt.setDouble(idx, (Double)var);
        } else if (var instanceof Float) {
            stmt.setFloat(idx, ((Float)var).floatValue());
        } else if (var instanceof Long) {
            stmt.setLong(idx, (Long)var);
        } else if (var instanceof Short) {
            stmt.setShort(idx, (Short)var);
        } else if (var instanceof Byte) {
            stmt.setByte(idx, (Byte)var);
        } else if (var instanceof BigDecimal) {
            stmt.setBigDecimal(idx, (BigDecimal)var);
        } else if (var instanceof byte[]) {
            stmt.setBytes(idx, (byte[])var);
        } else if (var instanceof Date) {
            stmt.setDate(idx, (Date)var);
        } else if (var instanceof Time) {
            stmt.setTime(idx, (Time)var);
        } else if (var instanceof Timestamp) {
            stmt.setTimestamp(idx, (Timestamp)var);
        } else if (var instanceof ArrayParameter) {
            stmt.setArray(idx, (Array)JDBCUtil.createSQLArray((ArrayParameter)var, conn));
        } else if (var instanceof Field) {
            if (((Field)var).isArray()) {
                String[] values = ((FieldArray)var).toStringArray();
                ArrayParameter arp = new ArrayParameter(((FieldArray)var).getSQLfieldType(), values);
                stmt.setObject(idx, JDBCUtil.createSQLArray(arp, conn));
            } else {
                Object fieldVar = ((Field)var).getValue();
                stmt.setString(idx, (String)fieldVar);
            }
        } else if (var instanceof JGeometry) {
            JGeometry g = (JGeometry)var;
            STRUCT geom = null;
            Object[] descs = Util.createDBGeomDescriptors(conn);
            geom = JGeometry.store((JGeometry)g, (Connection)conn, (Object[])descs);
            stmt.setObject(idx, geom);
        } else if (var instanceof AnnotationText) {
            AnnotationText atext = (AnnotationText)var;
            STRUCT geom = null;
            Object[] descs = AnnotationText.getDBDescriptors(conn);
            geom = atext.store(conn, descs);
            stmt.setObject(idx, geom);
        } else if (var instanceof TopoFeatureDescriptor) {
            SdoTopoGeometry topoGeom = JDBCUtil.createSdoTopoGeometryObject(conn, (TopoFeatureDescriptor)var);
            STRUCT tpg = (STRUCT)topoGeom.toDatum(conn);
            stmt.setObject(idx, tpg);
        } else {
            throw new IllegalArgumentException("Binding data type not supported: " + var.getClass().toString());
        }
    }

    private static SdoTopoGeometry createSdoTopoGeometryObject(Connection conn, TopoFeatureDescriptor tfd) throws SQLException {
        if (conn == null || tfd == null) {
            return null;
        }
        int tgType = tfd.getTopoFeatureType();
        TopoPrimitiveDescriptor[] tpdef = tfd.getPrimitives();
        TopoChildFeatureDescriptor[] tcfd = tfd.getChildFeatures();
        if (tpdef != null && tpdef.length > 0) {
            int i;
            SdoTopoObject[] stoa;
            SdoTopoObjectArray topoObjArray = null;
            if (tgType != 4) {
                stoa = new SdoTopoObject[tpdef.length];
                for (i = 0; i < tpdef.length; ++i) {
                    stoa[i] = new SdoTopoObject(new NUMBER(tpdef[i].getTopoId()), new NUMBER(tpdef[i].getTopoType()));
                }
                topoObjArray = new SdoTopoObjectArray(stoa);
            } else {
                stoa = new SdoTopoObject[tpdef.length];
                i = 0;
                int index = 0;
                for (int t = 1; t <= 3; ++t) {
                    for (i = 0; i < tpdef.length; ++i) {
                        if (tpdef[i].getTopoType() != t) continue;
                        stoa[index++] = new SdoTopoObject(new NUMBER(tpdef[i].getTopoId()), new NUMBER(t));
                    }
                }
                topoObjArray = new SdoTopoObjectArray(stoa);
            }
            SdoTopoGeometry stg = new SdoTopoGeometry(conn);
            SdoTopoGeometry[] stgOut = new SdoTopoGeometry[]{new SdoTopoGeometry(conn)};
            SdoTopoGeometry stgResult = stg.sdoTopoGeometry(new CHAR(tfd.getTopology().toUpperCase(), CHAR.DEFAULT_CHARSET), new CHAR(tfd.getFeatureTable().toUpperCase(), CHAR.DEFAULT_CHARSET), new CHAR(tfd.getTopoColumn().toUpperCase(), CHAR.DEFAULT_CHARSET), new NUMBER(tgType), topoObjArray, stgOut);
            return stgResult;
        }
        if (tcfd != null && tcfd.length > 0) {
            SdoTglObjectArray topoTglObjArray = null;
            SdoTglObject[] stoa = new SdoTglObject[tcfd.length];
            for (int i = 0; i < tcfd.length; ++i) {
                stoa[i] = new SdoTglObject(new NUMBER(tcfd[i].getLayerId()), new NUMBER(tcfd[i].getFeatureId()));
            }
            topoTglObjArray = new SdoTglObjectArray(stoa);
            SdoTopoGeometry stg = new SdoTopoGeometry(conn);
            SdoTopoGeometry[] stgOut = new SdoTopoGeometry[]{new SdoTopoGeometry(conn)};
            SdoTopoGeometry stgResult = stg.sdoTopoGeometry(new CHAR(tfd.getTopology().toUpperCase(), CHAR.DEFAULT_CHARSET), new CHAR(tfd.getFeatureTable().toUpperCase(), CHAR.DEFAULT_CHARSET), new CHAR(tfd.getTopoColumn().toUpperCase(), CHAR.DEFAULT_CHARSET), new NUMBER(tgType), topoTglObjArray, stgOut);
            return stgResult;
        }
        return null;
    }

    public static String[] getEditorSessionNames(Connection conn, String editorName) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (editorName == null) {
            throw new Exception("Editor name is null.");
        }
        ArrayList<String> sessionNames = new ArrayList<String>();
        PreparedStatement st = null;
        ResultSet rs = null;
        String querystr = null;
        try {
            querystr = "select name from user_sdo_edit_sessions where editor = ? order by name";
            st = conn.prepareStatement(querystr);
            st.setString(1, editorName.toUpperCase());
            rs = st.executeQuery();
            while (rs.next()) {
                sessionNames.add(rs.getString(1));
            }
        }
        catch (Exception ex) {
            log.severe(querystr + "\n" + ex);
            sessionNames = null;
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        if (sessionNames == null || sessionNames.size() == 0) {
            return null;
        }
        return sessionNames.toArray(new String[sessionNames.size()]);
    }

    public static String[] getGeometryAttributes(Connection conn, String tableName) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (tableName == null) {
            throw new Exception("Table name is null.");
        }
        ArrayList<String> columns = new ArrayList<String>();
        Statement st = null;
        ResultSet rs = null;
        String querystr = null;
        try {
            if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") > -1) {
                querystr = "select * from " + tableName + " where rownum < 1";
                st = conn.prepareStatement(querystr);
                rs = st.executeQuery();
                ResultSetMetaData rsmeta = rs.getMetaData();
                int colCnt = rsmeta.getColumnCount();
                for (int i = 1; i <= colCnt; ++i) {
                    String[] cols;
                    int type = rsmeta.getColumnType(i);
                    String typename = rsmeta.getColumnTypeName(i);
                    String colname = rsmeta.getColumnName(i);
                    if (typename.equalsIgnoreCase("MDSYS.SDO_GEOMETRY")) {
                        columns.add(colname);
                        continue;
                    }
                    if (typename.equalsIgnoreCase("MDSYS.SDO_GEORASTER")) {
                        columns.add(colname + ".SPATIALEXTENT");
                        continue;
                    }
                    if (typename.equalsIgnoreCase("MDSYS.SDO_CART_TEXT")) {
                        columns.add(colname + ".LOCATION");
                        columns.add(colname + ".LEADER_LINE");
                        columns.add(colname + ".ENVELOPE");
                        continue;
                    }
                    if (Util.isSTGeometryType(typename)) {
                        columns.add(colname);
                        continue;
                    }
                    if (type != 2002 || (cols = JDBCUtil.getSpatialAttributes(conn, typename, colname, "SDO_GEOMETRY")) == null) continue;
                    for (int k = 0; k < cols.length; ++k) {
                        columns.add(cols[k]);
                    }
                }
            } else {
                querystr = "select column_name from user_sdo_geom_metadata where table_name = ?";
                st = conn.prepareStatement(querystr);
                st.setString(1, tableName);
                rs = st.executeQuery();
                while (rs.next()) {
                    String colname = rs.getString(1);
                    columns.add(colname);
                }
            }
        }
        catch (Exception ex) {
            log.severe(querystr + "\n" + ex.getMessage());
            columns.clear();
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception re) {}
            }
        }
        if (columns.size() == 0) {
            return null;
        }
        Collections.sort(columns);
        return columns.toArray(new String[columns.size()]);
    }

    public static String[] getSpatialAttributes(Connection conn, String type_name, String column_name, String spatial_type) throws SQLException {
        if (spatial_type == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        StructDescriptor desc = StructDescriptor.createDescriptor((String)type_name, (Connection)conn);
        ResultSetMetaData md = desc.getMetaData();
        int numAttrs = desc.getLength();
        for (int i = 0; i < numAttrs; ++i) {
            String attr_name = md.getColumnName(i + 1);
            int attr_type = md.getColumnType(i + 1);
            String attr_typeName = md.getColumnTypeName(i + 1);
            if (attr_typeName.equalsIgnoreCase(spatial_type) || attr_typeName.indexOf(spatial_type) > -1) {
                String colname = column_name + "." + attr_name;
                names.add(colname.toUpperCase());
                continue;
            }
            if (attr_type != 2002 || spatial_type.indexOf("SDO_GEOMETRY") <= -1) continue;
            if (attr_typeName.equalsIgnoreCase("MDSYS.SDO_GEORASTER") || attr_typeName.indexOf("SDO_GEORASTER") > -1) {
                names.add(column_name + "." + attr_name + ".SPATIALEXTENT");
                continue;
            }
            if (!attr_typeName.equalsIgnoreCase("MDSYS.ST_ANNOTATION_TEXT") && attr_typeName.indexOf("ST_ANNOTATION_TEXT") <= -1) continue;
            names.add(column_name + "." + attr_name + ".PRIVATEENVELOPE");
        }
        if (names.size() == 0) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }

    public static String[] getNonComplexAttributes(Connection conn, String tableName, boolean checkObject) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (tableName == null) {
            throw new Exception("Table name is null.");
        }
        ArrayList<String> columns = new ArrayList<String>();
        Statement st = null;
        ResultSet rs = null;
        String querystr = null;
        try {
            DatabaseMetaData dbmeta = conn.getMetaData();
            if (dbmeta.getDatabaseProductName().toUpperCase().indexOf("ORACLE") > -1) {
                querystr = "select * from " + tableName + " where rownum < 1";
                st = conn.prepareStatement(querystr);
                rs = st.executeQuery();
                ResultSetMetaData rsmeta = rs.getMetaData();
                int colCnt = rsmeta.getColumnCount();
                String dbName = Util.getDBName(conn);
                for (int i = 1; i <= colCnt; ++i) {
                    String[] cols;
                    int type = rsmeta.getColumnType(i);
                    String typename = rsmeta.getColumnTypeName(i);
                    String colname = rsmeta.getColumnName(i);
                    if (!JDBCUtil.isComplexAttribute(type, dbName) && type != 2002) {
                        columns.add(colname);
                        continue;
                    }
                    if (type != 2002 || !checkObject || (cols = JDBCUtil.getNonComplexAttributes(conn, typename, colname)) == null) continue;
                    for (int k = 0; k < cols.length; ++k) {
                        columns.add(cols[k]);
                    }
                }
            } else {
                rs = dbmeta.getColumns(null, null, tableName, null);
                while (rs.next()) {
                    String colname;
                    int type = rs.getInt("DATA_TYPE");
                    if (JDBCUtil.isComplexAttribute(type, dbmeta.getDatabaseProductName()) || columns.contains(colname = rs.getString("COLUMN_NAME"))) continue;
                    columns.add(colname);
                }
            }
        }
        catch (Exception ex) {
            log.severe(querystr + "\n" + ex.getMessage());
            columns.clear();
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        if (columns.size() == 0) {
            return null;
        }
        Collections.sort(columns);
        return columns.toArray(new String[columns.size()]);
    }

    public static String[] getNonComplexAttributes(Connection conn, String type_name, String column_name) throws SQLException {
        ArrayList<String> names = new ArrayList<String>();
        StructDescriptor desc = StructDescriptor.createDescriptor((String)type_name, (Connection)conn);
        ResultSetMetaData md = desc.getMetaData();
        int numAttrs = desc.getLength();
        String dbName = Util.getDBName(conn);
        for (int i = 0; i < numAttrs; ++i) {
            String attr_name = md.getColumnName(i + 1);
            int attr_type = md.getColumnType(i + 1);
            String attr_typeName = md.getColumnTypeName(i + 1);
            if (!JDBCUtil.isComplexAttribute(attr_type, dbName) && attr_type != 2002) {
                String colname = column_name + "." + attr_name;
                names.add(colname.toUpperCase());
                continue;
            }
            if (attr_type != 2002) continue;
        }
        if (names.size() == 0) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }

    public static boolean isComplexAttribute(int type, String dbName) {
        return !(dbName == null || dbName.toUpperCase().indexOf("ORACLE") > -1 ? type == -6 || type == 5 || type == 4 || type == -5 || type == 6 || type == 7 || type == 8 || type == 2 || type == 3 || type == 1 || type == 12 || type == -1 || type == 2 || type == 999 || type == 91 || type == 92 || type == 93 : type == -6 || type == 5 || type == 4 || type == -5 || type == 6 || type == 7 || type == 8 || type == 2 || type == 3 || type == 1 || type == 12 || type == -1 || type == 91 || type == 92 || type == 93);
    }

    public static SpatialTableMetadata[] getGeometryTablesMetadata(Connection conn) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        Statement st = null;
        ResultSet rs = null;
        ArrayList<SpatialTableMetadata> tableMetadata = new ArrayList<SpatialTableMetadata>();
        try {
            String user = conn.getMetaData().getUserName();
            String query = null;
            if (Util.is10gOrAfter(conn)) {
                query = "select table_name, column_name, owner, srid from (  select table_name, column_name, owner, srid from all_sdo_geom_metadata where owner = ?    minus   select table_name, column_name, table_owner, srid from all_sdo_topo_metadata where table_owner = ?    minus   select table_name, column_name||'.PRIVATEENVELOPE', owner,  (    select srid from all_sdo_geom_metadata gmd where       gmd.table_name = atmd.table_name and       gmd.column_name = atmd.column_name||'.PRIVATEENVELOPE' and       gmd.owner = atmd.owner  ) from all_annotation_text_metadata atmd where owner = ?) order by table_name";
                log.finest("Query to load geometry metadata for user [" + user.toUpperCase() + "]:\n" + query);
                st = conn.prepareStatement(query);
                st.setString(1, user.toUpperCase());
                st.setString(2, user.toUpperCase());
                st.setString(3, user.toUpperCase());
            } else {
                query = "select table_name, column_name, owner, srid from all_sdo_geom_metadata  where owner = ?  order by table_name";
                log.finest("Query to load geometry metadata for user [" + user.toUpperCase() + "]:\n" + query);
                st = conn.prepareStatement(query);
                st.setString(1, user.toUpperCase());
            }
            rs = st.executeQuery();
            while (rs.next()) {
                String tb_name = rs.getString(1);
                String tb_column = rs.getString(2);
                String tb_owner = rs.getString(3);
                int tb_srid = rs.getInt(4);
                SpatialTableMetadata tb_meta = new SpatialTableMetadata();
                tb_meta.setType(SpatialTableMetadata.GEOMETRY_TYPE);
                tb_meta.setName(tb_name);
                tb_meta.setSpatialColumn(tb_column);
                tb_meta.setOwner(tb_owner);
                tb_meta.setSRID(tb_srid);
                tableMetadata.add(tb_meta);
            }
        }
        catch (Exception e) {
            tableMetadata.clear();
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        if (tableMetadata.size() == 0) {
            return null;
        }
        return tableMetadata.toArray(new SpatialTableMetadata[tableMetadata.size()]);
    }

    public static AnnotationTextMetadata[] getAnnotationTextMetadata(Connection conn) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        Statement st = null;
        ResultSet rs = null;
        ArrayList<AnnotationTextMetadata> tableMetadata = new ArrayList<AnnotationTextMetadata>();
        try {
            String user = conn.getMetaData().getUserName();
            String query = null;
            query = "select table_name, column_name, owner,(  select srid from all_sdo_geom_metadata gmd where     gmd.table_name = atmd.table_name and     gmd.column_name = atmd.column_name||'.PRIVATEENVELOPE' and     gmd.owner = atmd.owner) from all_annotation_text_metadata atmd where owner = ?order by table_name";
            log.finest("Query to load annotext metadata for user [" + user.toUpperCase() + "]:\n" + query);
            st = conn.prepareStatement(query);
            st.setString(1, user.toUpperCase());
            rs = st.executeQuery();
            while (rs.next()) {
                String tb_name = rs.getString(1);
                String tb_column = rs.getString(2);
                String tb_owner = rs.getString(3);
                int tb_srid = rs.getInt(4);
                AnnotationTextMetadata tb_meta = new AnnotationTextMetadata();
                tb_meta.setName(tb_name);
                tb_meta.setSpatialColumn(tb_column);
                tb_meta.setOwner(tb_owner);
                tb_meta.setSRID(tb_srid);
                tableMetadata.add(tb_meta);
            }
        }
        catch (Exception e) {
            tableMetadata.clear();
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        if (tableMetadata.size() == 0) {
            return null;
        }
        return tableMetadata.toArray(new AnnotationTextMetadata[tableMetadata.size()]);
    }

    public static SpatialTableMetadata[] getTopologyTablesMetadata(Connection conn) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        Statement st = null;
        ResultSet rs = null;
        ArrayList<SpatialTableMetadata> tableMetadata = new ArrayList<SpatialTableMetadata>();
        try {
            String user = conn.getMetaData().getUserName();
            String query = null;
            if (Util.is10gOrAfter(conn)) {
                query = "select a.table_name, a.column_name, a.owner, a.srid   from all_sdo_geom_metadata a, all_sdo_topo_metadata b   where a.table_name = b.table_name and        a.column_name = b.column_name and        a.owner = ? and        b.table_owner = ?";
                log.finest("Query to load topology metadata for user [" + user.toUpperCase() + "]:\n" + query);
                st = conn.prepareStatement(query);
                st.setString(1, user.toUpperCase());
                st.setString(2, user.toUpperCase());
                rs = st.executeQuery();
                while (rs.next()) {
                    String tb_name = rs.getString(1);
                    String tb_column = rs.getString(2);
                    String tb_owner = rs.getString(3);
                    int tb_srid = rs.getInt(4);
                    SpatialTableMetadata tb_meta = new SpatialTableMetadata();
                    tb_meta.setType(SpatialTableMetadata.TOPOFEATURE_TYPE);
                    if (tb_name.toUpperCase().endsWith("_LT")) {
                        SpatialTableMetadata dup_tb_meta = new SpatialTableMetadata();
                        dup_tb_meta.setType(SpatialTableMetadata.TOPOFEATURE_TYPE);
                        int idx = tb_name.toUpperCase().indexOf("_LT");
                        dup_tb_meta.setName(tb_name.substring(0, idx));
                        dup_tb_meta.setSpatialColumn(tb_column);
                        dup_tb_meta.setOwner(tb_owner);
                        dup_tb_meta.setSRID(tb_srid);
                        tableMetadata.add(dup_tb_meta);
                    }
                    tb_meta.setName(tb_name);
                    tb_meta.setSpatialColumn(tb_column);
                    tb_meta.setOwner(tb_owner);
                    tb_meta.setSRID(tb_srid);
                    tableMetadata.add(tb_meta);
                }
            }
        }
        catch (Exception e) {
            tableMetadata.clear();
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        if (tableMetadata.size() == 0) {
            return null;
        }
        return tableMetadata.toArray(new SpatialTableMetadata[tableMetadata.size()]);
    }

    public static SpatialTableMetadata[] getSpatialTablesMetadata(Connection conn) throws Exception {
        SpatialTableMetadata[] topoMeta;
        AnnotationTextMetadata[] atMeta;
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        ArrayList<SpatialTableMetadata> tableMetadata = new ArrayList<SpatialTableMetadata>();
        SpatialTableMetadata[] geomMeta = JDBCUtil.getGeometryTablesMetadata(conn);
        if (geomMeta != null && geomMeta.length > 0) {
            for (int i = 0; i < geomMeta.length; ++i) {
                tableMetadata.add(geomMeta[i]);
            }
        }
        if ((atMeta = JDBCUtil.getAnnotationTextMetadata(conn)) != null && atMeta.length > 0) {
            for (int i = 0; i < atMeta.length; ++i) {
                tableMetadata.add(atMeta[i]);
            }
        }
        if ((topoMeta = JDBCUtil.getTopologyTablesMetadata(conn)) != null && topoMeta.length > 0) {
            for (int i = 0; i < topoMeta.length; ++i) {
                tableMetadata.add(topoMeta[i]);
            }
        }
        if (tableMetadata.size() == 0) {
            return null;
        }
        return tableMetadata.toArray(new SpatialTableMetadata[tableMetadata.size()]);
    }

    public static String[] getTopologyNames(Connection conn) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        Statement st = null;
        ResultSet rs = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            String user = conn.getMetaData().getUserName();
            String query = null;
            if (Util.is10gOrAfter(conn)) {
                query = "select distinct topology from all_sdo_topo_metadata   where owner = ? order by topology";
                st = conn.prepareStatement(query);
                st.setString(1, user.toUpperCase());
                rs = st.executeQuery();
                while (rs.next()) {
                    String topology = rs.getString(1);
                    if (topology == null) continue;
                    names.add(topology);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        if (names.size() == 0) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }

    public static long getSRID(Connection conn, String baseTable, String spatialColumn, String spatialType) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (baseTable == null) {
            throw new Exception("Base table name is null.");
        }
        if (spatialColumn == null) {
            throw new Exception("Spatial column is null.");
        }
        if (spatialType == null) {
            throw new Exception("Spatial type name is null.");
        }
        String query = "";
        String columnName = spatialColumn;
        try {
            String owner = conn.getMetaData().getUserName();
            String table = baseTable;
            int index = baseTable.indexOf(".");
            if (index > -1) {
                owner = baseTable.substring(0, index);
                table = baseTable.substring(index + 1, baseTable.length());
            }
            query = "select srid from all_sdo_geom_metadata where table_name = ? and column_name = ? and owner = ?";
            if (spatialType != null && spatialType.equalsIgnoreCase(SpatialTableMetadata.ANNOTATION_TYPE)) {
                columnName = columnName + ".PRIVATEENVELOPE";
            } else if (spatialType != null && spatialType.equalsIgnoreCase(SpatialTableMetadata.GEORASTER_TYPE)) {
                columnName = columnName + ".SPATIALEXTENT";
            }
            stmt = conn.prepareStatement(query);
            stmt.setString(1, table.toUpperCase());
            stmt.setString(2, columnName.toUpperCase());
            stmt.setString(3, owner.toUpperCase());
            rs = stmt.executeQuery();
            if (rs.next()) {
                long srid;
                long l = srid = rs.getLong(1);
                return l;
            }
        }
        catch (Exception e) {
            log.severe(query + "\n" + e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        return 0L;
    }

    public static String getWKT(Connection conn, long srid) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String query = "select wktext from cs_srs where srid = :1";
        String wkt = null;
        try {
            stmt = conn.prepareStatement(query);
            stmt.setLong(1, srid);
            rs = stmt.executeQuery();
            if (rs.next()) {
                String string = wkt = rs.getString("wktext");
                return string;
            }
        }
        catch (Exception e) {
            log.severe(query + "\n" + e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        return null;
    }

    public static boolean isGeodeticSRID(Connection conn, long srid) throws Exception {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        String query = "SELECT srid FROM MDSYS.cs_srs where srid = ? and WKTEXT like 'GEOGCS%'";
        try {
            stmt = conn.prepareStatement(query);
            stmt.setLong(1, srid);
            rs = stmt.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log.severe(query + "\n" + e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        return false;
    }

    public static Hashtable<String, String> getAttributesAndJavaTypes(Connection conn, String baseTable, String spatialColumn) throws Exception {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (baseTable == null) {
            throw new Exception("Data set base table is null.");
        }
        if (spatialColumn == null) {
            throw new Exception("Data set spatial column is null.");
        }
        Hashtable<String, String> attrTypes = new Hashtable<String, String>();
        String query = "select * from " + baseTable + " where rownum < 1";
        try {
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            ResultSetMetaData rsmeta = rs.getMetaData();
            int colCnt = rsmeta.getColumnCount();
            for (int i = 1; i <= colCnt; ++i) {
                int type = rsmeta.getColumnType(i);
                String typename = rsmeta.getColumnTypeName(i);
                String colname = rsmeta.getColumnName(i);
                if (colname.equalsIgnoreCase(spatialColumn)) {
                    if (typename.equalsIgnoreCase("MDSYS.SDO_GEOMETRY")) {
                        attrTypes.put(colname, "JGeometry");
                        continue;
                    }
                    if (typename.equalsIgnoreCase("MDSYS.ST_ANNOTATION_TEXT")) {
                        attrTypes.put(colname, "AnnotationText");
                        continue;
                    }
                    if (!typename.equalsIgnoreCase("MDSYS.SDO_TOPO_GEOMETRY")) continue;
                    attrTypes.put(colname, "SdoTopoGeometry");
                    continue;
                }
                if (!JDBCUtil.isComplexAttribute(type, null) && type != 2002) {
                    String var = JDBCUtil.getJavaTypeFromOracleType(type);
                    if (var == null) continue;
                    attrTypes.put(colname, var);
                    continue;
                }
                if (!typename.equalsIgnoreCase("MDSYS.SDO_LIST_TYPE")) continue;
                attrTypes.put(colname, "FieldArray");
            }
            Hashtable<String, String> hashtable = attrTypes;
            return hashtable;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
    }

    private static String getJavaTypeFromOracleType(int oracleType) {
        if (oracleType == -6 || oracleType == 5) {
            return "Short";
        }
        if (oracleType == 4) {
            return "Integer";
        }
        if (oracleType == -5) {
            return "Long";
        }
        if (oracleType == 6 || oracleType == 7) {
            return "Float";
        }
        if (oracleType == 8 || oracleType == 2 || oracleType == 3 || oracleType == 2) {
            return "Double";
        }
        if (oracleType == 1 || oracleType == 12 || oracleType == -1 || oracleType == 999) {
            return "String";
        }
        if (oracleType == 91) {
            return "Date";
        }
        if (oracleType == 92) {
            return "Time";
        }
        if (oracleType == 93) {
            return "Timestamp";
        }
        return null;
    }

    private static Field getFieldFromOracleType(int oracleType) {
        if (oracleType == -6 || oracleType == 5) {
            return new Field().setShort(0);
        }
        if (oracleType == 4) {
            return new Field().setInt(0);
        }
        if (oracleType == -5) {
            return new Field().setLong(0L);
        }
        if (oracleType == 6 || oracleType == 7) {
            return new Field().setFloat(0.0f);
        }
        if (oracleType == 8 || oracleType == 2 || oracleType == 3 || oracleType == 2) {
            return new Field().setDouble(0.0);
        }
        if (oracleType == 1 || oracleType == 12 || oracleType == -1 || oracleType == 999) {
            return new Field("");
        }
        if (oracleType == 91) {
            return new Field().setDate(0L);
        }
        if (oracleType == 92) {
            return new Field().setDate(0L);
        }
        if (oracleType == 93) {
            return new Field().setDate(0L);
        }
        return null;
    }

    private static Field getFieldFromResultSet(ResultSet rs, int column) throws Exception {
        Field field = null;
        Object var = rs.getObject(column);
        if (var == null) {
            return null;
        }
        if (var instanceof String) {
            field = new Field((String)var);
        } else if (var instanceof Integer) {
            field = new Field((Integer)var);
        } else if (var instanceof Double) {
            field = new Field((Double)var);
        } else if (var instanceof Float) {
            field = new Field().setFloat(((Float)var).floatValue());
        } else if (var instanceof Long) {
            field = new Field().setLong((Long)var);
        } else if (var instanceof Short) {
            field = new Field().setShort(((Short)var).shortValue());
        }
        if (var instanceof BigDecimal) {
            field = new Field(((BigDecimal)var).doubleValue());
        } else if (var instanceof Date) {
            field = new Field().setDate(((Date)var).getTime());
        } else if (var instanceof Time) {
            field = new Field().setDate(((Time)var).getTime());
        } else if (var instanceof Timestamp) {
            field = new Field().setDate(((Timestamp)var).getTime());
        } else if (var instanceof ROWID) {
            field = new Field(var.toString());
        }
        return field;
    }

    public static AnnotationTextMetadata getAnnotationTextMetadata(Connection conn, String table, String column) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name is null.");
        }
        if (column == null) {
            throw new Exception("Column name is null.");
        }
        String connectionUser = conn.getMetaData().getUserName();
        String atName = table;
        String atOwner = connectionUser;
        int idx = atName.indexOf(".");
        if (idx > -1) {
            atOwner = atName.substring(0, idx);
            atName = atName.substring(idx + 1, atName.length());
        }
        String atquery = "select * from all_annotation_text_metadata where table_name = ?  and column_name = ?  and owner = ?";
        AnnotationTextMetadata metadata = new AnnotationTextMetadata();
        PreparedStatement atStmt = null;
        ResultSet rs = null;
        try {
            atStmt = conn.prepareStatement(atquery);
            atStmt.setString(1, atName.toUpperCase());
            atStmt.setString(2, column.toUpperCase());
            atStmt.setString(3, atOwner.toUpperCase());
            rs = atStmt.executeQuery();
            if (!rs.next()) {
                log.warning("Unable to load Annotation metadata for Table Name " + atName + ", Column Name " + column + ", Annotation Owner " + atOwner);
                throw new Exception("Unable to load Annotation metadata for Table Name " + atName + ", Column Name " + column + ", Annotation Owner " + atOwner);
            }
            metadata.setOwner(atOwner);
            metadata.setName(atName.toUpperCase());
            metadata.setSpatialColumn(column.toUpperCase());
            metadata.setTextExpression(rs.getString("text_expression"));
            metadata.setTextAttributes(rs.getString("text_attributes"));
            if (rs.getObject("map_base_scale") != null) {
                metadata.setMapBaseScale(rs.getDouble("map_base_scale"));
            }
        }
        catch (Exception ex) {
            log.severe("Annotation load metadata Exception: " + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (atStmt != null) {
                try {
                    atStmt.close();
                }
                catch (Exception re) {}
            }
        }
        return metadata;
    }

    public static boolean updateAnnotationTextMetadata(Connection conn, String tableName, String columnName, double mapBaseScale, String expression, String attributes) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (tableName == null) {
            throw new Exception("Table name is null.");
        }
        if (columnName == null) {
            throw new Exception("Column name is null.");
        }
        if (tableName.indexOf(".") > -1) {
            throw new Exception("Update of annotation text metadata for cross schema user is not allowed.");
        }
        PreparedStatement updateStmt = null;
        String update = "update user_annotation_text_metadata set\nmap_base_scale = :1,\ntext_expression = :2,\ntext_attributes = :3\nwhere \ntable_name = :4 and\ncolumn_name = :5";
        try {
            updateStmt = conn.prepareStatement(update);
            if (Double.isNaN(mapBaseScale) || mapBaseScale <= 0.0) {
                updateStmt.setObject(1, null);
            } else {
                updateStmt.setDouble(1, mapBaseScale);
            }
            updateStmt.setString(2, expression);
            updateStmt.setString(3, attributes);
            updateStmt.setString(4, tableName.toUpperCase());
            updateStmt.setString(5, columnName.toUpperCase());
            updateStmt.executeUpdate();
        }
        catch (Exception ex) {
            log.severe(update + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (updateStmt != null) {
                try {
                    updateStmt.close();
                }
                catch (Exception re) {}
            }
        }
        return true;
    }

    public static NetworkMetadata getNetworkMetadata(Connection conn, String network) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (network == null) {
            System.out.println("Network name is null.");
            throw new Exception("Network name is null.");
        }
        String netquery = "select * from user_sdo_network_metadata where network = '" + network.toUpperCase() + "'";
        NetworkMetadata metadata = new NetworkMetadata();
        Statement netStmt = null;
        ResultSet rs = null;
        try {
            String connectionUser;
            String networkOwner = connectionUser = conn.getMetaData().getUserName();
            int index = network.indexOf(".");
            if (index > -1) {
                String tbSchema = network.substring(0, index);
                String ntName = network.substring(index + 1, network.length());
                netquery = "select * from all_sdo_network_metadata where network = '" + ntName.toUpperCase() + "'" + " and owner = '" + tbSchema.toUpperCase() + "'";
            }
            if (!(rs = (netStmt = conn.prepareStatement(netquery)).executeQuery()).next()) {
                throw new Exception("Unable to load Network " + network);
            }
            if (index > -1) {
                networkOwner = rs.getString("owner");
            }
            metadata.setNetworkOwner(networkOwner);
            metadata.setNetworkName(rs.getString("network"));
            metadata.setNetworkId(rs.getInt("network_id"));
            metadata.setNetworkCategory(rs.getString("network_category"));
            metadata.setGeometryType(rs.getString("geometry_type"));
            metadata.setNetworkType(rs.getString("network_type"));
            metadata.setNumberOfHierarchyLevels(rs.getInt("no_of_hierarchy_levels"));
            metadata.setLRSTable(rs.getString("lrs_table_name"));
            metadata.setLRSGeometryColumn(rs.getString("lrs_geom_column"));
            metadata.setNodeTable(rs.getString("node_table_name"));
            metadata.setNodeGeometryColumn(rs.getString("node_geom_column"));
            metadata.setNodeCostColumn(rs.getString("node_cost_column"));
            metadata.setLinkTable(rs.getString("link_table_name"));
            metadata.setLinkGeometryColumn(rs.getString("link_geom_column"));
            metadata.setLinkDirection(rs.getString("link_direction"));
            metadata.setLinkCostColumn(rs.getString("link_cost_column"));
            metadata.setPathTable(rs.getString("path_table_name"));
            metadata.setPathGeometryColumn(rs.getString("path_geom_column"));
            metadata.setPathLinkTable(rs.getString("path_link_table_name"));
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (netStmt != null) {
                try {
                    netStmt.close();
                }
                catch (Exception re) {}
            }
        }
        return metadata;
    }

    public static String[] getNetworkNames(Connection conn) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        Statement st = null;
        ResultSet rs = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            String user = conn.getMetaData().getUserName();
            String query = null;
            if (Util.is10gOrAfter(conn)) {
                query = "select distinct network from all_sdo_network_metadata   where owner = ? order by network";
                st = conn.prepareStatement(query);
                st.setString(1, user.toUpperCase());
                rs = st.executeQuery();
                while (rs.next()) {
                    String network = rs.getString(1);
                    if (network == null) continue;
                    names.add(network);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        if (names.size() == 0) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }

    public static TopologyMetadata getTopologyMetadata(Connection conn, String topology, String featureTable, String topoColumn) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (topology == null) {
            throw new Exception("Feature Table name is null.");
        }
        PreparedStatement topoStmt = null;
        ResultSet rs = null;
        String connectionUser = conn.getMetaData().getUserName();
        String topName = topology;
        String topOwner = connectionUser;
        int index = topName.indexOf(".");
        if (index > -1) {
            topOwner = topName.substring(0, index);
            topName = topName.substring(index + 1, topName.length());
        }
        String tbName = null;
        String tbOwner = connectionUser;
        String topoquery = null;
        if (featureTable != null && topoColumn != null) {
            tbName = featureTable;
            tbOwner = connectionUser;
            index = tbName.indexOf(".");
            if (index > -1) {
                tbOwner = tbName.substring(0, index);
                tbName = tbName.substring(index + 1, tbName.length());
            }
            topoquery = "select * from all_sdo_topo_metadata where topology = ?  and table_name = ?  and column_name = ?  and table_owner = ?  and owner = ?";
        } else {
            topoquery = "select * from all_sdo_topo_metadata where topology = ?  and owner = ?";
        }
        TopologyMetadata metadata = new TopologyMetadata();
        try {
            if (tbName != null && !tbName.endsWith("_LT") && ORAWorkspaceJDBCUtil.isVersionedTable(conn, null, tbName)) {
                tbName = tbName + "_LT";
            }
            topoStmt = conn.prepareStatement(topoquery);
            if (tbName != null) {
                topoStmt.setString(1, topName.toUpperCase());
                topoStmt.setString(2, tbName.toUpperCase());
                topoStmt.setString(3, topoColumn.toUpperCase());
                topoStmt.setString(4, tbOwner.toUpperCase());
                topoStmt.setString(5, topOwner.toUpperCase());
            } else {
                topoStmt.setString(1, topName.toUpperCase());
                topoStmt.setString(2, topOwner.toUpperCase());
            }
            rs = topoStmt.executeQuery();
            if (!rs.next()) {
                throw new Exception("Unable to load Topology " + topName + ", Table Name " + featureTable + ", Column Name " + topoColumn);
            }
            metadata.setTopologyOwner(rs.getString("owner"));
            metadata.setTopology(rs.getString("topology"));
            metadata.setTopologyId(rs.getInt("topology_id"));
            metadata.setTolerance(rs.getDouble("tolerance"));
            metadata.setSrid(rs.getLong("srid"));
            metadata.setNodeSequence(rs.getString("node_sequence"));
            metadata.setEdgeSequence(rs.getString("edge_sequence"));
            metadata.setFaceSequence(rs.getString("face_sequence"));
            metadata.setTopoGeometrySequence(rs.getString("tg_sequence"));
            metadata.setDigitsRightOfDecimal(rs.getInt("digits_right_of_decimal"));
            if (tbName != null) {
                metadata.setFeatureTable(rs.getString("table_name"));
                metadata.setTopoColumn(rs.getString("column_name"));
                metadata.setTopoLayerId(rs.getInt("tg_layer_id"));
                metadata.setTopoLayerType(rs.getString("tg_layer_type"));
                metadata.setTopoLayerLevel(rs.getInt("tg_layer_level"));
                metadata.setChildLayerId(rs.getInt("child_layer_id"));
                metadata.setFeatureTableOwner(rs.getString("table_owner"));
            }
        }
        catch (Exception ex) {
            log.severe("Topology load metadata Exception: " + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (topoStmt != null) {
                try {
                    topoStmt.close();
                }
                catch (Exception re) {}
            }
        }
        return metadata;
    }

    public static TopologyMetadata[] getTopologyLayersMetadata(Connection conn, String topology) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (topology == null) {
            throw new Exception("Feature Table name is null.");
        }
        PreparedStatement topoStmt = null;
        ResultSet rs = null;
        String connectionUser = conn.getMetaData().getUserName();
        String topName = topology;
        String topOwner = connectionUser;
        int index = topName.indexOf(".");
        if (index > -1) {
            topOwner = topName.substring(0, index);
            topName = topName.substring(index + 1, topName.length());
        }
        ArrayList<TopologyMetadata> metadatas = new ArrayList<TopologyMetadata>();
        String topoquery = null;
        topoquery = "select * from all_sdo_topo_metadata where topology = ? and owner = ? order by tg_layer_level";
        try {
            topoStmt = conn.prepareStatement(topoquery);
            topoStmt.setString(1, topName.toUpperCase());
            topoStmt.setString(2, topOwner.toUpperCase());
            rs = topoStmt.executeQuery();
            while (rs.next()) {
                TopologyMetadata metadata = new TopologyMetadata();
                metadata.setTopologyOwner(rs.getString("owner"));
                metadata.setTopology(rs.getString("topology"));
                metadata.setTopologyId(rs.getInt("topology_id"));
                metadata.setTolerance(rs.getDouble("tolerance"));
                metadata.setSrid(rs.getLong("srid"));
                metadata.setNodeSequence(rs.getString("node_sequence"));
                metadata.setEdgeSequence(rs.getString("edge_sequence"));
                metadata.setFaceSequence(rs.getString("face_sequence"));
                metadata.setTopoGeometrySequence(rs.getString("tg_sequence"));
                metadata.setDigitsRightOfDecimal(rs.getInt("digits_right_of_decimal"));
                metadata.setFeatureTable(rs.getString("table_name"));
                metadata.setTopoColumn(rs.getString("column_name"));
                metadata.setTopoLayerId(rs.getInt("tg_layer_id"));
                metadata.setTopoLayerType(rs.getString("tg_layer_type"));
                metadata.setTopoLayerLevel(rs.getInt("tg_layer_level"));
                metadata.setChildLayerId(rs.getInt("child_layer_id"));
                metadata.setFeatureTableOwner(rs.getString("table_owner"));
                metadatas.add(metadata);
            }
        }
        catch (Exception ex) {
            log.severe("Topology load metadata Exception: " + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (topoStmt != null) {
                try {
                    topoStmt.close();
                }
                catch (Exception re) {}
            }
        }
        if (metadatas.size() == 0) {
            return null;
        }
        return metadatas.toArray(new TopologyMetadata[metadatas.size()]);
    }

    public static String[] getFeatureTableTopologyNames(Connection conn, String featureTable, String topoColumn) throws Exception {
        String connectionUser;
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (featureTable == null) {
            throw new Exception("Feature Table name is null.");
        }
        if (topoColumn == null) {
            throw new Exception("Topology column name is null.");
        }
        PreparedStatement topoStmt = null;
        ResultSet rs = null;
        String tableOwner = connectionUser = conn.getMetaData().getUserName();
        String tbName = featureTable;
        int index = featureTable.indexOf(".");
        if (index > -1) {
            tableOwner = featureTable.substring(0, index);
            tbName = featureTable.substring(index + 1, featureTable.length());
        }
        String topoquery = null;
        ArrayList<String> names = new ArrayList<String>();
        topoquery = "select owner, topology from all_sdo_topo_metadata where table_name = ?  and column_name = ?  and table_owner = ?";
        try {
            topoStmt = conn.prepareStatement(topoquery);
            topoStmt.setString(1, tbName.toUpperCase());
            topoStmt.setString(2, topoColumn.toUpperCase());
            topoStmt.setString(3, tableOwner.toUpperCase());
            rs = topoStmt.executeQuery();
            while (rs.next()) {
                String owner = rs.getString("owner");
                String topology = rs.getString("topology");
                names.add(owner + "." + topology);
            }
        }
        catch (Exception ex) {
            log.severe("Topology names load Exception: " + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (topoStmt != null) {
                try {
                    topoStmt.close();
                }
                catch (Exception re) {}
            }
        }
        if (names.size() == 0) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }

    public static long getSequenceNextValue(Connection conn, String sequence) throws Exception {
        long id;
        block14: {
            if (conn == null) {
                throw new Exception("Connection is null.");
            }
            if (sequence == null) {
                throw new Exception("Sequence name is null.");
            }
            id = -1L;
            String sqlSeqString = "select " + sequence + ".nextval from dual";
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.prepareStatement(sqlSeqString);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    id = rs.getLong(1);
                    break block14;
                }
                throw new Exception("unable to query sequence [" + sequence + "].");
            }
            catch (Exception ex) {
                log.severe(ex.getMessage());
                throw ex;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        return id;
    }

    public static long getSequenceCurrentValue(Connection conn, String sequence) throws Exception {
        long id;
        block14: {
            if (conn == null) {
                throw new Exception("Connection is null.");
            }
            if (sequence == null) {
                throw new Exception("Sequence name is null.");
            }
            id = -1L;
            String sqlSeqString = "select " + sequence + ".currval from dual";
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.prepareStatement(sqlSeqString);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    id = rs.getLong(1);
                    break block14;
                }
                throw new Exception("unable to query sequence [" + sequence + "].");
            }
            catch (Exception ex) {
                log.severe(ex.getMessage());
                throw ex;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        return id;
    }

    public static long getNetworkEntityMaxIdValue(Connection conn, String network, String netEntity) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (network == null) {
            throw new Exception("Newtork name is null.");
        }
        if (netEntity == null) {
            throw new Exception("Network entity (must be NODE or LINK) is null.");
        }
        if (!netEntity.equalsIgnoreCase("node") && !netEntity.equalsIgnoreCase("link")) {
            throw new Exception("Invalid network entity name (must be NODE or LINK).");
        }
        String column = null;
        String table = null;
        if (netEntity.equalsIgnoreCase("node")) {
            column = "max(node_id)";
            table = network + "_node$";
        } else {
            column = "max(link_id)";
            table = network + "_link$";
        }
        String sqlString = " select " + column + " from " + table;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sqlString);
            rs = stmt.executeQuery();
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
        }
        catch (Exception ex) {
            log.severe(sqlString + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        return 0L;
    }

    public static boolean createSequence(Connection conn, String sequence, long startWith, int cache) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (sequence == null) {
            throw new Exception("Sequence name is null.");
        }
        String sqlSeqString = null;
        sqlSeqString = cache < 2 ? "create sequence " + sequence + " start with " + startWith : "create sequence " + sequence + " start with " + startWith + " cache " + cache;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sqlSeqString);
            stmt.execute();
        }
        catch (Exception ex) {
            log.severe(sqlSeqString + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        return true;
    }

    public static boolean sequenceExists(Connection conn, String sequenceName) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (sequenceName == null) {
            throw new Exception("Sequence name is null.");
        }
        String sqlSeqString = "select sequence_name from user_sequences where sequence_name = ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sqlSeqString);
            stmt.setString(1, sequenceName.toUpperCase());
            rs = stmt.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            log.severe(sqlSeqString + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        return false;
    }

    public static Sequence[] getSequences(Connection conn) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        String sqlSeqString = "select * from user_sequences order by sequence_name";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        try {
            stmt = conn.prepareStatement(sqlSeqString);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Sequence seq = new Sequence();
                seq.setName(rs.getString("sequence_name"));
                seq.setMinValue(rs.getDouble("min_value"));
                seq.setMaxValue(rs.getDouble("max_value"));
                seq.setIncrementBy(rs.getInt("increment_by"));
                sequences.add(seq);
            }
        }
        catch (Exception ex) {
            log.severe(sqlSeqString + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        if (sequences.size() == 0) {
            return null;
        }
        return sequences.toArray(new Sequence[sequences.size()]);
    }

    public static Hashtable getTopoUniverseFaceInfo(Connection conn, String topology) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (topology == null) {
            throw new Exception("Feature Table name is null.");
        }
        PreparedStatement topoStmt = null;
        ResultSet rs = null;
        String connectionUser = conn.getMetaData().getUserName();
        String topName = topology;
        String topOwner = connectionUser;
        int index = topName.indexOf(".");
        if (index > -1) {
            topOwner = topName.substring(0, index);
            topName = topName.substring(index + 1, topName.length());
        }
        String topoquery = "select * from " + topName + "_FACE$ where face_id = ?";
        try {
            topoStmt = conn.prepareStatement(topoquery);
            topoStmt.setInt(1, -1);
            rs = topoStmt.executeQuery();
            if (rs.next()) {
                long[] array;
                ARRAY inodelist;
                long[] array2;
                ARRAY iedgelist;
                Hashtable<String, Serializable> output = new Hashtable<String, Serializable>();
                int id = rs.getInt("FACE_ID");
                output.put("FACE_ID", new Integer(id));
                if (rs.getObject("BOUNDARY_EDGE_ID") != null) {
                    long bedge = rs.getLong("BOUNDARY_EDGE_ID");
                    output.put("BOUNDARY_EDGE_ID", new Long(bedge));
                }
                if ((iedgelist = (ARRAY)rs.getObject("ISLAND_EDGE_ID_LIST")) != null && (array2 = iedgelist.getLongArray()) != null && array2.length > 0) {
                    Vector<Long> values = new Vector<Long>();
                    for (int i = 0; i < array2.length; ++i) {
                        values.add(array2[i]);
                    }
                    output.put("ISLAND_EDGE_ID_LIST", values);
                }
                if ((inodelist = (ARRAY)rs.getObject("ISLAND_NODE_ID_LIST")) != null && (array = inodelist.getLongArray()) != null && array.length > 0) {
                    Vector<Long> values = new Vector<Long>();
                    for (int i = 0; i < array.length; ++i) {
                        values.add(array[i]);
                    }
                    output.put("ISLAND_NODE_ID_LIST", values);
                }
                Hashtable<String, Serializable> hashtable = output;
                return hashtable;
            }
        }
        catch (Exception ex) {
            log.severe("Topology universe face information Exception: " + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (topoStmt != null) {
                try {
                    topoStmt.close();
                }
                catch (Exception re) {}
            }
        }
        return null;
    }

    public static TopologyMetadata getTopoFeatureDescriptors(Connection conn, String topology, String featureTable, String topoColumn, Rectangle2D window, Vector<TopoFeatureDescriptor> features, Vector<Field> attributes) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (topology == null) {
            throw new Exception("Feature Table name is null.");
        }
        if (featureTable == null) {
            throw new Exception("Feature Table name is null.");
        }
        if (topoColumn == null) {
            throw new Exception("Topology column name is null.");
        }
        if (features == null) {
            throw new Exception("Features vector is null.");
        }
        TopologyMetadata metadata = JDBCUtil.getTopologyMetadata(conn, topology, featureTable, topoColumn);
        if (metadata == null) {
            throw new Exception("Unable to load metadata for topology [" + topology + "]" + ", feature table [" + featureTable + "]" + ", topo column [" + topoColumn + "].");
        }
        int layerLevel = metadata.getTopoLayerLevel();
        int layerId = metadata.getTopoLayerId();
        PreparedStatement topoStmt = null;
        ResultSet rs = null;
        String topoquery = null;
        String filter = "";
        if (window != null) {
            filter = "SDO_FILTER(a." + topoColumn + ", " + "MDSYS.SDO_GEOMETRY(2003, ";
            filter = metadata.getSrid() == 0L ? filter + "NULL" : filter + "" + metadata.getSrid();
            double xl = window.getMinX();
            double xh = window.getMaxX();
            double yl = window.getMinY();
            double yh = window.getMaxY();
            filter = filter + ", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + xl + "," + yl + "," + xh + "," + yh + ")) " + ") = 'TRUE'";
        }
        topoquery = "select a." + topoColumn + ".tg_id, b.topo_id,b.topo_type, a.* " + " from " + featureTable + " a, " + topology + "_RELATION$ b" + " where a." + topoColumn + ".tg_layer_id=b.tg_layer_id and" + " a." + topoColumn + ".tg_id=b.tg_id";
        if (window != null) {
            topoquery = topoquery + " and " + filter;
        }
        topoquery = topoquery + " order by a." + topoColumn + ".tg_id";
        log.finest("Topology query: " + topoquery);
        try {
            topoStmt = conn.prepareStatement(topoquery);
            rs = topoStmt.executeQuery();
            ResultSetMetaData rsmeta = rs.getMetaData();
            int colCnt = rsmeta.getColumnCount();
            for (int i = 4; i <= colCnt; ++i) {
                Field field;
                String colname = rsmeta.getColumnName(i);
                int coltype = rsmeta.getColumnType(i);
                if (JDBCUtil.isComplexAttribute(coltype, null) || (field = JDBCUtil.getFieldFromOracleType(coltype)) == null) continue;
                field.setName(colname);
                attributes.add(field);
            }
            long currentId = -1L;
            TopoFeatureDescriptor featDescriptor = null;
            while (rs.next()) {
                int featId = rs.getInt(1);
                if (currentId != (long)featId) {
                    featDescriptor = new TopoFeatureDescriptor();
                    featDescriptor.setFeatureId(featId);
                    featDescriptor.setLayerId(layerId);
                    features.add(featDescriptor);
                    currentId = featId;
                    for (int i = 4; i <= colCnt; ++i) {
                        Field f;
                        int coltype = rsmeta.getColumnType(i);
                        if (JDBCUtil.isComplexAttribute(coltype, null) || (f = JDBCUtil.getFieldFromResultSet(rs, i)) == null) continue;
                        f.setName(rsmeta.getColumnName(i));
                        featDescriptor.addAttribute(f);
                    }
                }
                int topoId = rs.getInt(2);
                int topoType = rs.getInt(3);
                if (layerLevel > 0) {
                    TopoChildFeatureDescriptor childFeature = new TopoChildFeatureDescriptor(topoId, topoType);
                    featDescriptor.addChildFeature(childFeature);
                    continue;
                }
                TopoPrimitiveDescriptor primitive = new TopoPrimitiveDescriptor(topoId, topoType);
                featDescriptor.addPrimitive(primitive);
            }
            TopologyMetadata topologyMetadata = metadata;
            return topologyMetadata;
        }
        catch (Exception ex) {
            log.finest("Query: " + topoquery);
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (topoStmt != null) {
                try {
                    topoStmt.close();
                }
                catch (Exception re) {}
            }
        }
    }

    public static String[] getTopologyFeatureTables(Connection conn, String topology) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (topology == null) {
            throw new Exception("Feature Table name is null.");
        }
        String topoquery = null;
        PreparedStatement topoStmt = null;
        ResultSet rs = null;
        ArrayList<String> featureTables = new ArrayList<String>();
        topoquery = "select table_schema, table_name from user_sdo_topo_metadata where topology = ?";
        try {
            topoStmt = conn.prepareStatement(topoquery);
            topoStmt.setString(1, topology.toUpperCase());
            rs = topoStmt.executeQuery();
            while (rs.next()) {
                String tableSchema = rs.getString(1);
                String tableName = rs.getString(2);
                featureTables.add(tableSchema + "." + tableName);
            }
        }
        catch (Exception ex) {
            log.finest("Query: " + topoquery);
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (topoStmt != null) {
                try {
                    topoStmt.close();
                }
                catch (Exception re) {}
            }
        }
        if (featureTables.size() == 0) {
            return null;
        }
        return featureTables.toArray(new String[featureTables.size()]);
    }

    public static TopologyPrimitives getTopologyPrimitives(Connection conn, String topology, Rectangle2D mbr) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (topology == null) {
            throw new Exception("Topology name is null.");
        }
        TopologyPrimitives primitives = new TopologyPrimitives();
        Rectangle2D totalMBR = null;
        String query = null;
        TopologyMetadata metadata = JDBCUtil.getTopologyMetadata(conn, topology, null, null);
        if (metadata == null) {
            throw new Exception("Unable to load metadata for topology [" + topology + "]");
        }
        int topoSRID = (int)metadata.getSrid();
        try {
            query = "select * from " + topology + "_FACE$" + JDBCUtil.getFilterExpression(mbr, topoSRID, "mbr_geometry");
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                TopologyFace face = JDBCUtil.loadTopoFaceFromRS(rs);
                if (face == null) continue;
                primitives.addFace(face);
                Rectangle2D faceMBR = face.getMBR();
                if (faceMBR == null) continue;
                if (totalMBR == null) {
                    totalMBR = new Rectangle2D.Double();
                }
                totalMBR.add(faceMBR);
            }
            rs.close();
            stmt.close();
            query = totalMBR != null ? "select * from " + topology + "_EDGE$" + JDBCUtil.getFilterExpression(totalMBR, topoSRID, "geometry") : "select * from " + topology + "_EDGE$" + JDBCUtil.getFilterExpression(mbr, topoSRID, "geometry");
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                TopologyEdge edge = JDBCUtil.loadTopoEdgeFromRS(rs);
                if (edge == null) continue;
                primitives.addEdge(edge);
                Rectangle2D edgeMBR = edge.getMBR();
                if (edgeMBR == null) continue;
                if (totalMBR == null) {
                    totalMBR = new Rectangle2D.Double();
                }
                totalMBR.add(edgeMBR);
            }
            rs.close();
            stmt.close();
            query = totalMBR != null ? "select * from " + topology + "_NODE$" + JDBCUtil.getFilterExpression(totalMBR, topoSRID, "geometry") : "select * from " + topology + "_NODE$" + JDBCUtil.getFilterExpression(mbr, topoSRID, "geometry");
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                TopologyNode node = JDBCUtil.loadTopoNodeFromRS(rs);
                if (node == null) continue;
                primitives.addNode(node);
            }
        }
        catch (Exception e) {
            log.severe(query + "\n" + e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        if (primitives.getNumberOfPrimitives() > 0) {
            return primitives;
        }
        return null;
    }

    public static TopologyPrimitives getTopologyPrimitives(Connection conn, String topology, int[] faceIds, int[] edgeIds, int[] nodeIds) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (topology == null) {
            throw new Exception("Topology name is null.");
        }
        if (!(faceIds != null && faceIds.length != 0 || edgeIds != null && edgeIds.length != 0 || nodeIds != null && nodeIds.length != 0)) {
            throw new Exception("At least one primitive must be defined.");
        }
        String query = null;
        TopologyPrimitives primitives = new TopologyPrimitives();
        try {
            int i;
            String inclause;
            if (faceIds != null && faceIds.length > 0) {
                inclause = " where face_id in (";
                for (i = 0; i < faceIds.length; ++i) {
                    if (i > 0) {
                        inclause = inclause + ",";
                    }
                    inclause = inclause + "'" + faceIds[i] + "'";
                }
                inclause = inclause + ")";
                query = "select * from " + topology + "_FACE$" + inclause;
                stmt = conn.prepareStatement(query);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    TopologyFace face = JDBCUtil.loadTopoFaceFromRS(rs);
                    if (face == null) continue;
                    primitives.addFace(face);
                }
                rs.close();
                stmt.close();
            }
            if (edgeIds != null && edgeIds.length > 0) {
                inclause = " where edge_id in (";
                for (i = 0; i < edgeIds.length; ++i) {
                    if (i > 0) {
                        inclause = inclause + ",";
                    }
                    inclause = inclause + "'" + edgeIds[i] + "'";
                }
                inclause = inclause + ")";
                query = "select * from " + topology + "_EDGE$" + inclause;
                stmt = conn.prepareStatement(query);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    TopologyEdge edge = JDBCUtil.loadTopoEdgeFromRS(rs);
                    if (edge == null) continue;
                    primitives.addEdge(edge);
                }
                rs.close();
                stmt.close();
            }
            if (nodeIds != null && nodeIds.length > 0) {
                inclause = " where node_id in (";
                for (i = 0; i < nodeIds.length; ++i) {
                    if (i > 0) {
                        inclause = inclause + ",";
                    }
                    inclause = inclause + "'" + nodeIds[i] + "'";
                }
                inclause = inclause + ")";
                query = "select * from " + topology + "_NODE$" + inclause;
                stmt = conn.prepareStatement(query);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    TopologyNode node = JDBCUtil.loadTopoNodeFromRS(rs);
                    if (node == null) continue;
                    primitives.addNode(node);
                }
            }
        }
        catch (Exception e) {
            log.severe(query + "\n" + e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        if (primitives.getNumberOfPrimitives() > 0) {
            return primitives;
        }
        return null;
    }

    public static TopologyRelation[] getRelationsForTopoPrimitive(Connection conn, String topology, int primitiveId, int primitiveType) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (topology == null) {
            throw new Exception("Topology name is null.");
        }
        if (primitiveType < 1 || primitiveType > 3) {
            throw new Exception("Invalid topology primitive type (must be 1,2, or 3)");
        }
        String sqlSelectLayer = " select * from " + topology;
        String query = null;
        ArrayList<TopologyRelation> relations = new ArrayList<TopologyRelation>();
        try {
            if (primitiveType == 1) {
                query = sqlSelectLayer + "_relationL where topo_type=1 and topo_id=?";
                stmt = conn.prepareStatement(query);
                stmt.setInt(1, primitiveId);
            } else if (primitiveType == 2) {
                query = sqlSelectLayer + "_relationL where topo_type=2 and (topo_id=? or topo_id=?)" + " order by tg_layer_id, tg_id";
                stmt = conn.prepareStatement(query);
                stmt.setInt(1, primitiveId);
                stmt.setInt(2, -primitiveId);
            } else {
                query = sqlSelectLayer + "_relationL where topo_type=3 and topo_id=? order by tg_layer_id, tg_id";
                stmt = conn.prepareStatement(query);
                stmt.setInt(1, primitiveId);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                TopologyRelation relation = new TopologyRelation(rs.getInt("tg_layer_id"), rs.getInt("tg_id"), rs.getInt("topo_id"), rs.getInt("topo_type"));
                relations.add(relation);
            }
        }
        catch (Exception e) {
            log.severe(query + "\n" + e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        if (relations.size() == 0) {
            return null;
        }
        return relations.toArray(new TopologyRelation[relations.size()]);
    }

    public static TopologyRelation[] getRelationsForTopoChildFeature(Connection conn, String topology, int childLayerId, int featureId) throws Exception {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (topology == null) {
            throw new Exception("Topology name is null.");
        }
        String ischildlayerQuery = "select tg_layer_id from user_sdo_topo_metadata where  topology = ? and child_layer_id = ?";
        String sqlSelectLayer = " select * from " + topology + "_relation$ " + "where tg_layer_id = ? and topo_id = ? and topo_type = ?";
        ArrayList<TopologyRelation> relations = new ArrayList<TopologyRelation>();
        String query = null;
        try {
            query = ischildlayerQuery;
            int parentLayerId = 0;
            stmt = conn.prepareStatement(query);
            stmt.setString(1, topology.toUpperCase());
            stmt.setInt(2, childLayerId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                TopologyRelation[] topologyRelationArray = null;
                return topologyRelationArray;
            }
            parentLayerId = rs.getInt(1);
            rs.close();
            stmt.close();
            query = sqlSelectLayer;
            stmt = conn.prepareStatement(query);
            stmt.setInt(1, parentLayerId);
            stmt.setInt(2, childLayerId);
            stmt.setInt(3, featureId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                TopologyRelation relation = new TopologyRelation(rs.getInt("tg_layer_id"), rs.getInt("tg_id"), rs.getInt("topo_id"), rs.getInt("topo_type"));
                relations.add(relation);
            }
        }
        catch (Exception e) {
            log.severe(query + "\n" + e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        if (relations.size() == 0) {
            return null;
        }
        return relations.toArray(new TopologyRelation[relations.size()]);
    }

    private static String getFilterExpression(Rectangle2D mbr, int srid, String spatialColumn) {
        if (mbr != null && spatialColumn != null) {
            double xl = mbr.getMinX();
            double yl = mbr.getMinY();
            double xh = mbr.getMaxX();
            double yh = mbr.getMaxY();
            String filter = " where  MDSYS.SDO_FILTER(" + spatialColumn + ",\n" + "  MDSYS.SDO_GEOMETRY(2003,";
            String params = ", 'querytype=WINDOW'";
            filter = srid == 0 ? filter + "NULL" : filter + "" + srid;
            filter = filter + ", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + xl + "," + yl + "," + xh + "," + yh + "))" + params + ") = 'TRUE'";
            return filter;
        }
        return "";
    }

    private static TopologyEdge loadTopoEdgeFromRS(ResultSet rs) throws SQLException {
        TopologyEdge e = new TopologyEdge(rs.getInt("edge_id"));
        e.setOriginNode(rs.getInt("start_node_id"));
        e.setEndNode(rs.getInt("end_node_id"));
        e.setBoundedFaceL(rs.getInt("left_face_id"));
        e.setBoundedFaceR(rs.getInt("right_face_id"));
        e.setNextEdgeL(rs.getInt("next_left_edge_id"));
        e.setPrevEdgeL(rs.getInt("prev_left_edge_id"));
        e.setNextEdgeR(rs.getInt("next_right_edge_id"));
        e.setPrevEdgeR(rs.getInt("prev_right_edge_id"));
        STRUCT st = (STRUCT)rs.getObject("geometry");
        if (st != null) {
            JGeometry geom = JGeometry.load((STRUCT)st);
            e.setGeometry(geom);
        }
        return e;
    }

    private static TopologyFace loadTopoFaceFromRS(ResultSet rs) throws SQLException {
        STRUCT st;
        TopologyFace f = new TopologyFace(rs.getInt("face_id"));
        f.setBoundaryEdge(rs.getInt("boundary_edge_id"));
        ARRAY a = (ARRAY)rs.getArray("island_edge_id_list");
        if (a != null) {
            f.setIslandEdges(a.getIntArray());
        }
        if ((a = (ARRAY)rs.getArray("island_node_id_list")) != null) {
            f.setIslandNodes(a.getIntArray());
        }
        if ((st = (STRUCT)rs.getObject("mbr_geometry")) != null) {
            JGeometry geom = JGeometry.load((STRUCT)st);
            f.setMBRGeometry(geom);
        }
        return f;
    }

    private static TopologyNode loadTopoNodeFromRS(ResultSet rs) throws SQLException {
        TopologyNode n = new TopologyNode(rs.getInt("node_id"));
        n.setStartEdge(rs.getInt("edge_id"));
        n.setContainFace(rs.getInt("face_id"));
        STRUCT st = (STRUCT)rs.getObject("geometry");
        if (st != null) {
            JGeometry geom = JGeometry.load((STRUCT)st);
            n.setGeometry(geom);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIndexTableName(Connection conn, String featureTable, String tableOwner, String spatialColumn) {
        block31: {
            String string;
            if (conn == null || featureTable == null || tableOwner == null || spatialColumn == null) {
                return null;
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            String query = null;
            String tableName = featureTable;
            int index = tableName.indexOf(".");
            if (index > -1) {
                tableName = featureTable.substring(index + 1, featureTable.length());
            }
            try {
                query = "    select sdo_index_table\n    from all_sdo_index_info\n    where table_owner = ?\n    and table_name = ?\n    and column_name = ?";
                pstmt = conn.prepareStatement(query);
                pstmt.setString(1, tableOwner.toUpperCase());
                pstmt.setString(2, tableName.toUpperCase());
                pstmt.setString(3, spatialColumn.toUpperCase());
                rs = pstmt.executeQuery();
                if (!rs.next()) break block31;
                if (index > -1) {
                    String string2 = tableOwner.toUpperCase() + "." + rs.getString(1);
                    return string2;
                }
                string = rs.getString(1);
            }
            catch (Exception ex) {
                log.severe(query + "\n" + ex.getMessage());
                break block31;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception e) {}
                }
            }
            return string;
        }
        return null;
    }
}

