/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.util.DBTable;
import oracle.sdovis.util.JDBCUtil;
import oracle.sql.ARRAY;
import oracle.sql.Datum;
import oracle.sql.STRUCT;

public class GeomMetaTable
extends DBTable {
    String mSpatialTableName;
    String mSpatialColumnName;
    int mSRID;
    int mDimensions;
    double mXMin;
    double mYMin;
    double mXMax;
    double mYMax;
    double mXTolerance;
    double mYTolerance;
    public static final String DEFAULT_TABLE_NAME = "ALL_SDO_GEOM_METADATA";

    public GeomMetaTable(String dataSrc) {
        super(dataSrc, DEFAULT_TABLE_NAME);
    }

    public double getXMin() {
        return this.mXMin;
    }

    public double getYMin() {
        return this.mYMin;
    }

    public double getXMax() {
        return this.mXMax;
    }

    public double getYMax() {
        return this.mYMax;
    }

    public double getXTolerance() {
        return this.mXTolerance;
    }

    public double getYTolerance() {
        return this.mYTolerance;
    }

    public int getSRID() {
        return this.mSRID;
    }

    public int getDimensions() {
        return this.mDimensions;
    }

    public String getSpatialTableName() {
        return this.mSpatialTableName;
    }

    public String getSpatialColumnName() {
        return this.mSpatialColumnName;
    }

    public String getUserName() {
        return this.mUser;
    }

    @Override
    public int getId() throws SQLException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTablesAndColumns() {
        Statement pstmt = null;
        Hashtable<String, String> ht = new Hashtable<String, String>(512);
        try {
            AbstractDBDataSource ds = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            this.mConnection = ds.getConnection();
            pstmt = this.mConnection.prepareStatement("select table_name, column_name from " + this.mTableName);
            this.query((PreparedStatement)pstmt);
            while (this.mResultSet.next()) {
                String table = this.mResultSet.getString(1);
                String column = this.mResultSet.getString(2);
                ht.put(table, column);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Hashtable hashtable = null;
            return hashtable;
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                this.closeQuery();
            }
            catch (SQLException e) {}
        }
        return ht;
    }

    public int getSRID(String table, String column) {
        if (this.query(table, column)) {
            return this.mSRID;
        }
        return 0;
    }

    @Override
    public int update() throws SQLException {
        return 0;
    }

    @Override
    public int insert() throws SQLException {
        return 0;
    }

    @Override
    public int delete() throws SQLException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean query(String table, String column) {
        Statement pstmt = null;
        this.mSRID = 0;
        this.mDimensions = 2;
        this.mYMax = 0.0;
        this.mXMax = 0.0;
        this.mYMin = 0.0;
        this.mXMin = 0.0;
        if (table != null) {
            table = table.toUpperCase();
        }
        if (column != null) {
            column = column.toUpperCase();
        }
        AbstractDBDataSource ds = null;
        try {
            ds = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            this.mConnection = ds.getConnection();
            String qq = "SELECT table_name, column_name, diminfo, srid FROM " + this.mTableName + " WHERE TABLE_NAME=?" + " and COLUMN_NAME=?" + " and OWNER=?";
            pstmt = this.mConnection.prepareStatement(qq);
            pstmt.setString(1, table);
            pstmt.setString(2, column);
            pstmt.setString(3, this.mUser);
            this.query((PreparedStatement)pstmt);
            this.next();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            try {
                this.closeQuery();
            }
            catch (Exception e1) {
                System.err.println("cannot query metadata from " + this.mTableName + " for " + table + ":" + column);
            }
            try {
                if (this.mConnection == null) {
                    this.mConnection = ds.getConnection();
                }
                String qq = "SELECT table_name, column_name, diminfo, srid FROM user_sdo_geom_metadata WHERE TABLE_NAME=? and COLUMN_NAME=?";
                pstmt = this.mConnection.prepareStatement(qq);
                pstmt.setString(1, table);
                pstmt.setString(2, column);
                this.query((PreparedStatement)pstmt);
                this.next();
                boolean bl = true;
                return bl;
            }
            catch (SQLException e2) {
                e2.printStackTrace(System.err);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                this.closeQuery();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryForTheme(String themeName) {
        Statement pstmt = null;
        this.mSRID = 0;
        this.mDimensions = 2;
        this.mYMax = 0.0;
        this.mXMax = 0.0;
        this.mYMin = 0.0;
        this.mXMin = 0.0;
        AbstractDBDataSource ds = null;
        try {
            ds = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            this.mConnection = ds.getConnection();
            String qq = "SELECT table_name, column_name, diminfo, srid FROM " + this.mTableName + ", USER_SDO_THEMES b " + " WHERE upper(b.NAME) =?" + " and TABLE_NAME=BASE_TABLE and (COLUMN_NAME=GEOMETRY_COLUMN " + " OR COLUMN_NAME = (GEOMETRY_COLUMN || '.SPATIALEXTENT')" + " OR COLUMN_NAME = (GEOMETRY_COLUMN || '.PRIVATEENVELOPE')) " + " and OWNER=:2";
            pstmt = this.mConnection.prepareStatement(qq);
            pstmt.setString(1, themeName.toUpperCase());
            pstmt.setString(2, this.mUser);
            this.query((PreparedStatement)pstmt);
            this.next();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                this.closeQuery();
            }
            catch (SQLException e1) {
                System.err.println("cannot query metadata from " + this.mTableName + " for " + themeName);
            }
            try {
                if (this.mConnection == null) {
                    this.mConnection = ds.getConnection();
                }
                System.err.println("looking at USER_SDO_GEOM_METADATA for theme " + themeName);
                String qq = "SELECT table_name, column_name, diminfo, srid FROM USER_SDO_GEOM_METADATA , USER_SDO_THEMES b  WHERE upper(b.NAME) =? and TABLE_NAME=BASE_TABLE and (COLUMN_NAME=GEOMETRY_COLUMN  OR COLUMN_NAME = (GEOMETRY_COLUMN || '.SPATIALEXTENT') OR COLUMN_NAME = (GEOMETRY_COLUMN || '.PRIVATEENVELOPE'))";
                pstmt = this.mConnection.prepareStatement(qq);
                pstmt.setString(1, themeName.toUpperCase());
                this.query((PreparedStatement)pstmt);
                this.next();
                boolean bl = true;
                return bl;
            }
            catch (SQLException e2) {
                e2.printStackTrace(System.err);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                this.closeQuery();
            }
            catch (SQLException e) {}
        }
    }

    @Override
    protected void initDeleteStatement() throws SQLException {
    }

    @Override
    protected void initInsertStatement() throws SQLException {
    }

    @Override
    protected void initUpdateStatement() throws SQLException {
    }

    @Override
    protected void updateLocalData() throws SQLException {
        this.mSpatialTableName = this.mResultSet.getString(1);
        this.mSpatialColumnName = this.mResultSet.getString(2);
        ARRAY sdoDimArray = null;
        try {
            sdoDimArray = JDBCUtil.safeCastARRAY(this.mResultSet.getObject(3));
        }
        catch (Exception ex) {
            throw new SQLException("Cannot get dim array.");
        }
        this.mSRID = this.mResultSet.getInt(4);
        Datum[] sdoDimInfoArray = sdoDimArray.getOracleArray();
        this.mDimensions = sdoDimInfoArray.length;
        STRUCT struct = (STRUCT)sdoDimInfoArray[0];
        Datum[] dim1Attrs = struct.getOracleAttributes();
        struct = (STRUCT)sdoDimInfoArray[1];
        Datum[] dim2Attrs = struct.getOracleAttributes();
        this.mXMin = dim1Attrs[1].doubleValue();
        this.mYMin = dim2Attrs[1].doubleValue();
        this.mXMax = dim1Attrs[2].doubleValue();
        this.mYMax = dim2Attrs[2].doubleValue();
        this.mXTolerance = dim1Attrs[3].doubleValue();
        this.mYTolerance = dim2Attrs[3].doubleValue();
    }
}

