/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

public class EarthCGUtil {
    static final double HalfPI = 1.5707963267948966;
    static final double RAD = 57.29577951308232;

    public static final double dist(double[] p1, double[] p2, double smax, double t, double flat) {
        double phi1 = 1.5707963267948966 - Math.abs(p1[1]) < 1.0E-10 ? p1[1] : Math.atan(t * Math.tan(p1[1]));
        double phi2 = 1.5707963267948966 - Math.abs(p2[1]) < 1.0E-10 ? p2[1] : Math.atan(t * Math.tan(p2[1]));
        double phim = (phi1 + phi2) / 2.0;
        double dphim = (phi1 - phi2) / 2.0;
        double lamm = Math.abs(p1[0] - p2[0]);
        if (lamm > Math.PI) {
            lamm = Math.PI * 2 - lamm;
        }
        if ((lamm /= 2.0) < 5.0E-8 && Math.abs(dphim) < 5.0E-8) {
            return 0.0;
        }
        if (1.5707963267948966 - lamm < 5.0E-8 && Math.abs(phim) < 5.0E-8 || 1.5707963267948966 - Math.abs(dphim) < 5.0E-8) {
            return -1.0;
        }
        double sphim = Math.sin(phim);
        double cphim = Math.cos(phim);
        double sdphim = Math.sin(dphim);
        double cdphim = Math.cos(dphim);
        double slamm = Math.sin(lamm);
        double cl = sdphim * sdphim + slamm * slamm * (cdphim * cdphim - sphim * sphim);
        double d = Math.acos(1.0 - 2.0 * cl);
        double sd = Math.sin(d);
        double ce = 2.0 * (1.0 - 2.0 * cl);
        double cyp = 2.0 * sphim * sphim * cdphim * cdphim / (1.0 - cl);
        double ctp = 2.0 * sdphim * sdphim * cphim * cphim / cl;
        double cx = cyp + ctp;
        double cy = cyp - ctp;
        double ct = d / sd;
        double cd = 4.0 * ct * ct;
        double ca = cd * ce;
        return smax * sd * (ct - flat * (ct * cx - cy) / 4.0 + flat * flat * (cx * (ca + (ct - (ca - ce) / 2.0) * cx) - cy * (2.0 * cd + ce * cy) + cd * cx * cy) / 64.0);
    }

    public static final void gcu(double[] p) {
        double ct = Math.cos(p[1]);
        double st = Math.sin(p[1]);
        double cp = Math.cos(p[0]);
        double sp = Math.sin(p[0]);
        p[0] = ct * cp;
        p[1] = ct * sp;
        p[2] = st;
    }

    public static final void bd(double[] a1, double dist, double bear, double[] a2) {
        double[] b = new double[3];
        double[] c = new double[3];
        b[2] = 0.0;
        if (Math.abs(a1[0]) < 1.0E-15 && Math.abs(a1[1]) < 1.0E-15) {
            b[0] = 0.0;
            b[1] = a1[2] > 0.0 ? 1.0 : -1.0;
        } else {
            b[0] = a1[1];
            b[1] = -a1[0];
        }
        EarthCGUtil.mdsphvr(b, a1, -bear, c);
        double mag = EarthCGUtil.MAGNITUDE(c);
        c[0] = c[0] / mag;
        c[1] = c[1] / mag;
        c[2] = c[2] / mag;
        EarthCGUtil.mdsphvr(a1, c, dist, a2);
    }

    public static final void gdu(double[] p) {
        double magxy = Math.sqrt(p[0] * p[0] + p[1] * p[1]);
        p[0] = Math.atan2(p[1], p[0]);
        p[1] = Math.atan(p[2] / magxy);
    }

    public static final void mdsphvr(double[] v, double[] axis, double psi, double[] result) {
        double[] axisV = new double[3];
        double[] vP = new double[3];
        EarthCGUtil.cp(axis, v, axisV);
        EarthCGUtil.cp(axisV, axis, vP);
        double s = Math.sin(psi);
        double c = Math.cos(psi) - 1.0;
        result[0] = v[0] + c * vP[0] + s * axisV[0];
        result[1] = v[1] + c * vP[1] + s * axisV[1];
        result[2] = v[2] + c * vP[2] + s * axisV[2];
    }

    public static final void cp(double[] a, double[] b, double[] r) {
        r[0] = a[1] * b[2] - a[2] * b[1];
        r[1] = a[2] * b[0] - a[0] * b[2];
        r[2] = a[0] * b[1] - a[1] * b[0];
    }

    public static final double convertRadius(double lon, double lat, double r) {
        double[] a = new double[3];
        double[] res = new double[3];
        a[0] = lon * (Math.PI / 180);
        a[1] = lat * (Math.PI / 180);
        a[2] = 0.0;
        EarthCGUtil.gcu(a);
        EarthCGUtil.bd(a, r / 6378206.0, 0.0, res);
        EarthCGUtil.gdu(res);
        res[0] = res[0] * 57.29577951308232;
        res[1] = res[1] * 57.29577951308232;
        return Math.sqrt((lon - res[0]) * (lon - res[0]) + (lat - res[1]) * (lat - res[1]));
    }

    public static final double[] convertRadius(double lon, double lat, double[] rs) {
        double[] out = new double[rs.length];
        for (int i = 0; i < rs.length; ++i) {
            out[i] = EarthCGUtil.convertRadius(lon, lat, rs[i]);
        }
        return out;
    }

    protected static final double MAGNITUDE(double[] a) {
        return Math.sqrt(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]);
    }

    public static final void unisphere2LongLat(double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, double[] longRange, double[] latRange) {
        double rad = 57.29577951308232;
        latRange[0] = Math.asin(zMin);
        latRange[1] = Math.asin(zMax);
        if (xMin == 0.0 && yMin * yMax < 0.0) {
            longRange[0] = -1.5707963267948966;
            longRange[1] = 1.5707963267948966;
        } else if (xMax == 0.0 && yMin * yMax < 0.0) {
            longRange[0] = 1.5707963267948966;
            longRange[1] = -1.5707963267948966;
        } else if (yMin == 0.0 && xMin * xMax < 0.0) {
            longRange[0] = 0.0;
            longRange[1] = Math.PI;
        } else if (yMax == 0.0 && xMin * xMax < 0.0) {
            longRange[0] = -Math.PI;
            longRange[1] = 0.0;
        } else if (xMin * xMax < 0.0 && yMin * yMax < 0.0) {
            longRange[0] = -Math.PI;
            longRange[1] = Math.PI;
        } else {
            double y = xMin >= 0.0 || xMax * xMin < 0.0 && yMin > 0.0 ? yMin : yMax;
            double x = yMin >= 0.0 || yMax * yMin < 0.0 && xMax < 0.0 ? xMax : xMin;
            longRange[0] = Math.atan2(y, x);
            y = xMax <= 0.0 || xMax * xMin < 0.0 && yMin > 0.0 ? yMin : yMax;
            x = yMax <= 0.0 || yMax * yMin < 0.0 && xMax < 0.0 ? xMax : xMin;
            longRange[1] = Math.atan2(y, x);
        }
        longRange[0] = longRange[0] * rad;
        longRange[1] = longRange[1] * rad;
        latRange[0] = latRange[0] * rad;
        latRange[1] = latRange[1] * rad;
    }
}

