/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class CanvasCache {
    public static final int DEFAULT_LIMIT = 120;
    private static int canvasLimit = 120;
    private static LinkedHashMap cache;
    private static HashMap countMap;
    private static long hitCount;
    private static long missCount;

    private CanvasCache() {
        CanvasCache.init();
    }

    public static synchronized void init() {
        CanvasCache.destroy();
        cache = new LinkedHashMap(canvasLimit + 1, 0.75f, true){

            public boolean removeEldestEntry(Map.Entry eldest) {
                boolean flag;
                boolean bl = flag = this.size() > canvasLimit;
                if (flag) {
                    ImageEntry ent = (ImageEntry)eldest.getValue();
                    if (ent.busy) {
                        flag = false;
                    } else {
                        String keyBase = CanvasCache.getKeyBase(ent.image);
                        int cnt = (Integer)countMap.get(keyBase);
                        cnt = cnt == 0 ? 0 : cnt - 1;
                        countMap.put(keyBase, new Integer(cnt));
                    }
                }
                return flag;
            }
        };
        countMap = new HashMap();
    }

    public static synchronized void destroy() {
        if (cache == null) {
            return;
        }
        for (ImageEntry imageEntry : cache.entrySet()) {
            imageEntry.image.flush();
            imageEntry.image = null;
        }
        cache.clear();
        cache = null;
        if (countMap != null) {
            countMap.clear();
            countMap = null;
        }
    }

    public static synchronized void setCanvasLimit(int newLimit) {
        canvasLimit = newLimit;
    }

    public static synchronized int getCanvasLimit() {
        return canvasLimit;
    }

    public static synchronized BufferedImage getImage(int width, int height, int type) {
        String keyBase;
        Integer cnt;
        if (cache == null) {
            CanvasCache.init();
        }
        if ((cnt = (Integer)countMap.get(keyBase = CanvasCache.getKeyBase(width, height, type))) == null) {
            return CanvasCache.createImage(width, height, type, 0);
        }
        keyBase = keyBase + "_c";
        int count = cnt;
        for (int i = 1; i <= count; ++i) {
            String key = keyBase + i;
            try {
                ImageEntry ent = (ImageEntry)cache.get(key);
                if (ent.busy) continue;
                ent.busy = true;
                ent.lastAccessedTime = System.currentTimeMillis();
                ++ent.accessCount;
                ++hitCount;
                return ent.image;
            }
            catch (NullPointerException npe) {
                System.out.println("NPE caught on key: " + key);
            }
        }
        return CanvasCache.createImage(width, height, type, count);
    }

    private static final String getKeyBase(int width, int height, int type) {
        return "img_w" + width + "_h" + height + "_t" + type;
    }

    private static final String getKeyBase(BufferedImage image) {
        return CanvasCache.getKeyBase(image.getWidth(), image.getHeight(), image.getType());
    }

    protected static synchronized BufferedImage createImage(int width, int height, int type, int imageCount) {
        try {
            ++missCount;
            String keyBase = CanvasCache.getKeyBase(width, height, type);
            BufferedImage img = new BufferedImage(width, height, type);
            ImageEntry entry = new ImageEntry();
            entry.image = img;
            entry.busy = true;
            entry.lastAccessedTime = System.currentTimeMillis();
            entry.accessCount = 1L;
            cache.put(keyBase + "_c" + ++imageCount, entry);
            countMap.put(keyBase, new Integer(imageCount));
            return img;
        }
        catch (OutOfMemoryError ex) {
            System.out.println("OOM error!  Current stats: " + CanvasCache.printStats());
            System.out.println("width: " + width + ", height: " + height);
            return null;
        }
    }

    public static synchronized void freeImage(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int type = image.getType();
        String keyBase = CanvasCache.getKeyBase(width, height, type);
        Integer cnt = (Integer)countMap.get(keyBase);
        int count = cnt;
        keyBase = keyBase + "_c";
        for (int i = 1; i <= count; ++i) {
            String key = keyBase + i;
            ImageEntry ent = (ImageEntry)cache.get(key);
            if (image != ent.image) continue;
            image.flush();
            ent.busy = false;
            return;
        }
    }

    public static long getImageCount() {
        return cache != null ? (long)cache.size() : 0L;
    }

    public static long getHitCount() {
        return hitCount;
    }

    public static long getMissCount() {
        return missCount;
    }

    public static String printStats() {
        String stats = new String("\ntotal # of cached images: " + CanvasCache.getImageCount() + "\n");
        stats = stats + "total hit count: " + CanvasCache.getHitCount() + "\n";
        stats = stats + "total miss count: " + CanvasCache.getMissCount() + "\n";
        return stats;
    }

    static {
        hitCount = 0L;
        missCount = 0L;
    }

    public static class ImageEntry {
        BufferedImage image;
        boolean busy = false;
        long lastAccessedTime;
        long accessCount;
    }
}

