/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.EPSG2SDO;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.VectorThemeDefinition;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.WSAuthenticator;
import oracle.sdovis.util.WfsCapabilities;
import oracle.sdovis.util.WfsFeatureType;

public class WFSThemeDefinition
extends VectorThemeDefinition {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String url = null;
    private String version = "1.0.0";
    private String srsName = null;
    private String featureName = null;
    private String spatialColumn = null;
    private String renderStyle = null;
    private String labelColumn = null;
    private String labelStyle = null;
    private String[] attributeList = null;
    private String[] renderStyleAttributes = null;
    private String queryCondition = null;
    private String[] featureIds = null;
    private boolean isPredefined = false;
    private String outputFormat = "GML2";
    private String keyColumn = "fid";
    private WfsCapabilities capabilities = new WfsCapabilities();
    private WfsFeatureType featureType = null;
    String userName = null;
    String password = null;
    private boolean reverseAxisOrder = false;
    private boolean ignoreAxisOrderCheck = false;
    private int epsgCode = 0;

    public WFSThemeDefinition(String name) {
        this.setName(name);
    }

    public WFSThemeDefinition(String name, String datasource, String url, String srs, String featureName, String spatialColumn, String renderStyle, String labelColumn, String labelStyle, String[] attributeList, String[] renderStyleAttributes, String queryCondition) {
        this.createCacheGroup();
        this.setName(name);
        this.dataSource = datasource;
        this.url = url;
        this.setSRS(srs);
        this.featureName = featureName;
        this.spatialColumn = spatialColumn;
        this.renderStyle = renderStyle;
        this.labelColumn = labelColumn;
        this.labelStyle = labelStyle;
        this.attributeList = attributeList;
        this.renderStyleAttributes = renderStyleAttributes;
        this.queryCondition = queryCondition;
    }

    public WFSThemeDefinition(String name, String datasource, String url, String srs, String featureName, String spatialColumn, String renderStyle, String labelColumn, String labelStyle, String[] attributeList, String[] renderStyleAttributes, String[] featIds) {
        this.createCacheGroup();
        this.setName(name);
        this.dataSource = datasource;
        this.url = url;
        this.setSRS(srs);
        this.featureName = featureName;
        this.spatialColumn = spatialColumn;
        this.renderStyle = renderStyle;
        this.labelColumn = labelColumn;
        this.labelStyle = labelStyle;
        this.attributeList = attributeList;
        this.renderStyleAttributes = renderStyleAttributes;
        this.featureIds = featIds;
    }

    public WFSThemeDefinition(String name, String datasource, String url, String srs, String featureName, String spatialColumn, StylingRule[] rules, String[] featIds, String key) {
        this.createCacheGroup();
        this.isPredefined = true;
        this.setName(name);
        this.dataSource = datasource;
        this.url = url;
        this.setSRS(srs);
        this.featureName = featureName;
        this.spatialColumn = spatialColumn;
        this.featureIds = featIds;
        if (key != null) {
            this.keyColumn = key;
        }
        if (rules == null) {
            return;
        }
        StylingRule rule = rules[0];
        this.renderStyle = rule.getFeatureStyleName();
        this.labelColumn = rule.getLabelColumn();
        this.labelStyle = rule.getLabelStyleName();
        this.queryCondition = rule.getFeatureCond();
        this.attributeList = rule.getAttributeColumnsAsArray();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String wfsVersion) {
        this.version = wfsVersion;
    }

    @Override
    public String getKeyColumn() {
        return this.keyColumn;
    }

    public void setKeyColumn(String key) {
        this.keyColumn = key == null ? "fid" : key;
    }

    public String getURL() {
        return this.url;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String feature) {
        this.featureName = feature;
    }

    public String getSpatialColumn() {
        return this.spatialColumn;
    }

    public void setSpatialColumn(String column) {
        this.spatialColumn = column;
    }

    public String getLabelColumn() {
        return this.labelColumn;
    }

    public void setLabelColumn(String column) {
        this.labelColumn = column;
    }

    public String[] getFeatureAttributes() {
        return this.attributeList;
    }

    public void setFeatureAttributes(String[] attrs) {
        this.attributeList = attrs;
    }

    public void setFeatureAttributesAsString(String attrs) {
        if (attrs == null) {
            this.attributeList = null;
        } else {
            ArrayList ats = Util.splitBy(attrs, ",");
            if (ats == null || ats.size() == 0) {
                this.attributeList = null;
            } else {
                this.attributeList = new String[ats.size()];
                for (int i = 0; i < ats.size(); ++i) {
                    this.attributeList[i] = ats.get(i).toString();
                }
            }
        }
    }

    public String getRenderStyle() {
        return this.renderStyle;
    }

    public void setRenderStyle(String style) {
        this.renderStyle = style;
    }

    public String getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(String style) {
        this.labelStyle = style;
    }

    public String[] getFeatureIds() {
        return this.featureIds;
    }

    public void setFeatureIds(String[] ids) {
        this.featureIds = ids;
    }

    @Override
    public String getXMLDefinition() {
        return "";
    }

    @Override
    public String getThemeType() {
        return "WFS";
    }

    public String getSRS() {
        return this.srsName;
    }

    public void setSRS(String srsname) {
        int index;
        if (this.srsName != null && srsname != null && this.srsName.equalsIgnoreCase(srsname)) {
            return;
        }
        this.srsName = srsname;
        if (srsname != null && (srsname.indexOf("epsg.xml") > -1 || srsname.indexOf("#") > -1)) {
            index = srsname.indexOf("#");
            if (index > -1) {
                this.srsName = "EPSG:" + srsname.substring(index + 1, srsname.length());
            }
        } else if (srsname != null && srsname.indexOf("urn:") > -1 && (index = srsname.indexOf("EPSG")) > -1) {
            int idx = srsname.lastIndexOf(":");
            this.srsName = idx > -1 ? "EPSG:" + srsname.substring(idx + 1, srsname.length()) : srsname.substring(index, srsname.length());
        }
        String sridS = "";
        if (this.srsName != null) {
            sridS = this.srsName;
            int index2 = this.srsName.indexOf(":");
            if (index2 > -1) {
                sridS = this.srsName.substring(index2 + 1, this.srsName.length());
            }
            int srsid = 0;
            try {
                srsid = Integer.parseInt(sridS);
            }
            catch (Exception ex) {
                return;
            }
            if (this.srsName.toUpperCase().indexOf("EPSG:") == -1) {
                this.srid = srsid;
            } else {
                if (this.dataSource == null) {
                    return;
                }
                this.epsgCode = srsid;
                int sdosrid = 0;
                String sridmap = EPSG2SDO.EPSGtoSDO(String.valueOf(srsid));
                sdosrid = sridmap != null ? Integer.parseInt(sridmap) : Util.EPSGsrid_To_Oraclesrid(this.dataSource, srsid);
                if (sdosrid > 0) {
                    this.srid = sdosrid;
                    log.info("Theme SRID set to " + this.srid + " for EPSG " + srsid);
                } else if (Util.existsOracleSRID(this.dataSource, srsid)) {
                    this.srid = srsid;
                    log.info("Theme SRID set to " + this.srid);
                } else {
                    log.warning("Unable to find an equivalent SDO SRID for EPSG " + srsid);
                    this.srid = 0;
                }
            }
        }
    }

    public String getQueryCondition() {
        return this.queryCondition;
    }

    public void setQueryCondition(String cond) {
        this.queryCondition = cond;
    }

    public String[] getRenderStyleAttributes() {
        return this.renderStyleAttributes;
    }

    public boolean isPredefined() {
        return this.isPredefined;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String format) {
        this.outputFormat = format;
    }

    public boolean readCapabilities(long timeout) {
        if (this.url == null) {
            return false;
        }
        WfsCapabilities cap = null;
        CacheGroup cg = CacheMgr2.getGroup("WFS_URL", "WFS_CAPABILITIES");
        if (cg != null) {
            cap = (WfsCapabilities)cg.get(this.url + this.version);
        }
        if (cap != null) {
            this.capabilities = cap;
        } else {
            if (this.hasAuthentication() && this.url != null) {
                WSAuthenticator authenticator = WSAuthenticator.getInstance();
                this.addProtectedURL(authenticator, this.url);
            }
            this.capabilities = new WfsCapabilities();
            if (!this.capabilities.readUsingHttpGet(this.url, timeout, this.version)) {
                log.warning("Unable to get Capabilities for url: " + this.url);
                return false;
            }
            if (cg != null) {
                cg.put(this.url + this.version, this.capabilities, 0L);
            }
        }
        this.doCompleteAuthentication();
        this.featureType = this.capabilities.getFeatureType(this.featureName);
        if (this.featureType != null) {
            this.setSRS(this.featureType.getSRS());
            if (this.featureType.getAttributeTypes() == null) {
                String describeUrl_get = this.capabilities.describeFeatureTypeGetURL();
                String describeUrl_post = this.capabilities.describeFeatureTypePostURL();
                if (describeUrl_get != null) {
                    this.featureType.readAttributesWithTypesUsingHttpGet(describeUrl_get, timeout, this.version);
                } else if (describeUrl_post == null) {
                    log.warning("Null describeFeatureType URLs.");
                } else {
                    this.featureType.readAttributesWithTypesUsingHttpPost(describeUrl_post, timeout, this.version);
                }
                if (this.featureType.getAttributeTypes() == null) {
                    log.warning("Feature attribute types are null.");
                }
            }
            this.adjustAttributeNames();
        } else {
            log.warning("Unable to get information for feature: " + this.featureName);
        }
        return true;
    }

    public WfsCapabilities getCapabilities() {
        return this.capabilities;
    }

    public WfsFeatureType getFeatureType() {
        return this.featureType;
    }

    private void adjustAttributeNames() {
        String value = null;
        value = this.getRealAttributeName(this.spatialColumn);
        if (value != null) {
            this.spatialColumn = value;
        }
        if ((value = this.getRealAttributeName(this.labelColumn)) != null) {
            this.labelColumn = value;
        }
        if (this.attributeList != null) {
            for (int i = 0; i < this.attributeList.length; ++i) {
                value = this.getRealAttributeName(this.attributeList[i]);
                if (value == null) continue;
                this.attributeList[i] = value;
            }
        }
        if (!this.keyColumn.equalsIgnoreCase("fid")) {
            value = this.getRealAttributeName(this.keyColumn);
            if (value != null) {
                this.keyColumn = value;
            } else {
                log.warning("Specified key column " + this.keyColumn + " is not a feature attribute. Using default \"fid\".");
                this.keyColumn = "fid";
            }
        }
    }

    public String getRealAttributeName(String column) {
        if (column == null) {
            return null;
        }
        if (this.featureType == null) {
            return null;
        }
        Hashtable fattrs = this.featureType.getAttributeTypes();
        if (fattrs == null || fattrs.size() == 0) {
            return null;
        }
        Enumeration e = fattrs.keys();
        while (e.hasMoreElements()) {
            String attr = (String)e.nextElement();
            if (!attr.equalsIgnoreCase(column)) continue;
            return attr;
        }
        return null;
    }

    private void createCacheGroup() {
        CacheMgr2.createSubRegion("WFS_URL");
        CacheMgr2.createGroup("WFS_URL", "WFS_CAPABILITIES");
    }

    public void clearCapabilitiesFromCache() {
        if (this.url == null) {
            return;
        }
        CacheGroup cg = CacheMgr2.getGroup("WFS_URL", "WFS_CAPABILITIES");
        if (cg == null) {
            return;
        }
        cg.remove(this.url + this.version);
    }

    public String getCacheSubRegion() {
        return "WFS_URL";
    }

    public String getCacheGroup() {
        return "WFS_CAPABILITIES";
    }

    @Override
    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo ti = new BasicThemeInfo();
        ti.setName(this.getName());
        ti.setBaseTable(this.url);
        ti.setType("WFS");
        ti.setKeyColumn(this.getKeyColumn());
        ti.setSrid(this.getSrid());
        ti.setSpatialColumn(this.spatialColumn);
        return ti;
    }

    @Override
    public String[] getRenderingStyles() {
        if (this.renderStyle == null) {
            return null;
        }
        String[] styleNames = new String[]{this.renderStyle.toUpperCase()};
        return styleNames;
    }

    @Override
    public String[] getLabelingStyles() {
        if (this.labelStyle == null) {
            return null;
        }
        String[] styleNames = new String[]{this.labelStyle.toUpperCase()};
        return styleNames;
    }

    @Override
    public String[] getLabelColumns() {
        String[] columns = null;
        if (this.labelColumn != null) {
            columns = new String[]{this.labelColumn};
        }
        return columns;
    }

    public void setAuthentication(String user, String pwd) {
        this.userName = user;
        this.password = pwd;
    }

    public boolean hasAuthentication() {
        return this.userName != null && this.password != null;
    }

    public String getAuthenticationUser() {
        return this.userName;
    }

    public void setAuthenticationUser(String user) {
        this.userName = user;
    }

    public String getAuthenticationPwd() {
        return this.password;
    }

    public void setAuthenticationPwd(String pwd) {
        this.password = pwd;
    }

    private void doCompleteAuthentication() {
        if (this.hasAuthentication() && this.url != null) {
            WSAuthenticator authenticator = WSAuthenticator.getInstance();
            this.addProtectedURL(authenticator, this.url);
            if (this.capabilities != null) {
                String describeUrl_get = this.capabilities.describeFeatureTypeGetURL();
                this.addProtectedURL(authenticator, describeUrl_get);
                String describeUrl_post = this.capabilities.describeFeatureTypePostURL();
                this.addProtectedURL(authenticator, describeUrl_post);
                String getfeatureGetUrl = this.capabilities.getFeatureGetURL();
                this.addProtectedURL(authenticator, getfeatureGetUrl);
                String getfeaturePostUrl = this.capabilities.getFeaturePostURL();
                this.addProtectedURL(authenticator, getfeaturePostUrl);
            }
        }
    }

    private void addProtectedURL(WSAuthenticator authenticator, String urlString) {
        if (authenticator != null && urlString != null) {
            if (urlString.endsWith("?")) {
                authenticator.addProtectedURL(urlString.substring(0, urlString.length() - 1), this.userName, this.password);
            } else {
                authenticator.addProtectedURL(urlString, this.userName, this.password);
            }
        }
    }

    public boolean getReverseAxisOrder() {
        return this.reverseAxisOrder;
    }

    public void setReverserAxisOrder(boolean reverse) {
        this.reverseAxisOrder = reverse;
    }

    public void updateAxisOrder() {
        this.reverseAxisOrder = false;
        if (this.version.equals("1.1.0") && this.epsgCode > 0) {
            this.reverseAxisOrder = Util.reverseAxisOrder(this.dataSource, this.epsgCode);
        } else if (this.version.equals("1.1.0") && this.srid > 0) {
            this.reverseAxisOrder = Util.reverseAxisOrder(this.dataSource, this.srid);
        }
    }

    public boolean getIgnoreAxisOrderCheck() {
        return this.ignoreAxisOrderCheck;
    }

    public void setIgnoreAxisOrderCheck(boolean ignore) {
        this.ignoreAxisOrderCheck = ignore;
    }

    public void setVersion(String wfsVersion, boolean checkAxisOrder) {
        if (wfsVersion != null) {
            this.version = wfsVersion;
        }
        if (checkAxisOrder) {
            this.updateAxisOrder();
        }
    }

    public String getServiceURL() {
        return this.url;
    }

    public void setServiceURL(String url) {
        this.url = url;
    }
}

