/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.TopologyTheme;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.theme.TopologyThemeDefinition;
import oracle.sdovis.util.Util;

public class NetworkThemeDefinition
extends ThemeDefinition {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    boolean passThrough = true;
    String networkOwner = null;
    String networkName = null;
    int networkId = 0;
    int hierachyLevels = 1;
    String networkCategory = null;
    String geometryType = null;
    String networkType = null;
    String lrsTableName = null;
    String lrsGeomColumn = null;
    String nodeTableName = null;
    String nodeGeomColumn = null;
    String nodeCostColumn = null;
    String linkTableName = null;
    String linkGeomColumn = null;
    String linkDirection = null;
    String linkCostColumn = null;
    String pathTableName = null;
    String pathGeomColumn = null;
    String pathLinkTableName = null;
    String linkStyle = null;
    String nodeStyle = null;
    String directionStyle = null;
    String bidirectionStyle = null;
    SizeDefinition dirStyleSize = new SizeDefinition(8.0, null);
    boolean multipleMarker = false;
    SizeDefinition nodeStyleSize = new SizeDefinition(5.0, null);
    String[] pathStyles = null;
    int[] idPaths = null;
    String linkLabelStyle = null;
    String linkLabelColumn = null;
    String nodeLabelStyle = null;
    String nodeLabelColumn = null;
    String pathLabelStyle = null;
    String pathLabelColumn = null;
    String linkQuery = null;
    String nodeQuery = null;
    String[] pathQuery = null;
    double linkDirectionPosition = 0.85;
    int networkLevel = 1;
    public static final String DIJKSTRA_ALGORITHM = "DIJKSTRA";
    public static final String ASEARCH_ALGORITHM = "ASEARCH";
    public static final String WITHINCOST_ALGORITHM = "WITHINCOST";
    String spAlgorithm = null;
    String spStyle = null;
    int spStartNode = 0;
    int spEndNode = 0;
    String spStartStyle = null;
    String spEndStyle = null;
    int[] spIDS = null;
    double spCost = 0.0;
    boolean predefined = false;
    String mBaseTable = null;
    String mKeyColumn = "ROWID";
    StylingRule mSRule = null;
    PreparedStatement pstmt = null;
    String currentKey = null;
    int cachingMode = 1;
    String cacheSubRegionName = null;
    String linkCacheGroup = null;
    String nodeCacheGroup = null;
    Hashtable sridLinkCache = new Hashtable(5);
    Hashtable sridNodeCache = new Hashtable(5);
    boolean bidirectionAttr = false;
    String connectionUser = null;
    String nodeKeyColumn = null;
    String linkKeyColumn = null;
    String topologyName = null;
    TopologyTheme nodeFeaturesTheme = null;
    TopologyTheme linkFeaturesTheme = null;

    public NetworkThemeDefinition(String name, String dataSource, String netName, String linkStyleName, String dirStyle, double dirPos, int dirMarkerSize, String nodeStyleName, int nodeMarkerSize, String pathIds, String pathStyleNames, int netLevel, boolean passThrough) {
        this.name = name;
        this.dataSource = dataSource;
        DBDataSource ds = (DBDataSource)DSManager.get(dataSource);
        if (ds == null) {
            log.severe("Unable to get data source " + dataSource);
            return;
        }
        this.is9i = ds.is9i();
        if (!this.readMetadata(dataSource, netName)) {
            return;
        }
        this.bidirectionAttr = this.bidirectionAttrExists(dataSource);
        this.linkStyle = linkStyleName;
        this.directionStyle = dirStyle;
        this.linkDirectionPosition = dirPos;
        this.dirStyleSize.setValue(dirMarkerSize);
        this.rewriteLinkQuery();
        this.nodeStyle = nodeStyleName;
        this.nodeStyleSize.setValue(nodeMarkerSize);
        this.rewriteNodeQuery();
        this.generatePathQueries(pathIds, pathStyleNames);
        this.networkLevel = netLevel;
        this.passThrough = passThrough;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkThemeDefinition(String name, String dataSource, String netname, int netLevel, StylingRule[] styleRules, int srid, int cacheMode) {
        this.dataSource = dataSource;
        DBDataSource ds = (DBDataSource)DSManager.get(dataSource);
        if (ds == null) {
            log.severe("Unable to get data source " + dataSource);
            return;
        }
        Connection conn = null;
        this.is9i = ds.is9i();
        this.predefined = true;
        this.name = name;
        this.srid = srid;
        this.networkLevel = netLevel;
        this.passThrough = false;
        if (netLevel < 1) {
            this.networkLevel = 1;
            log.warning("Invalid network level (level 1 is assumed).");
        }
        if (!this.readMetadata(dataSource, netname)) {
            return;
        }
        this.bidirectionAttr = this.bidirectionAttrExists(dataSource);
        if (styleRules == null || styleRules.length < 1) {
            log.warning("There are no styling rules defined for this theme");
            return;
        }
        this.cachingMode = cacheMode;
        if (cacheMode != 1 && cacheMode != 1 && cacheMode != 3) {
            this.cachingMode = 1;
        }
        this.linkCacheGroup = netname + "_LINK_PDT_NET";
        this.nodeCacheGroup = netname + "_NODE_PDT_NET";
        boolean pinned = this.cachingMode == 2;
        try {
            conn = ds.getConnection();
            this.cacheSubRegionName = CacheMgr2.getSubRegionName(conn);
            if (CacheMgr2.getSubRegion(this.cacheSubRegionName) == null) {
                CacheMgr2.createSubRegion(conn);
            }
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, this.linkCacheGroup, 0, pinned);
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, this.nodeCacheGroup, 0, pinned);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        if (styleRules == null) {
            log.warning("Styling rules has not been defined.");
            return;
        }
        this.mSRule = styleRules[0];
        for (int i = 0; i < styleRules.length; ++i) {
            if (styleRules[i].getLinkStyle() != null) {
                if (this.linkQuery != null) {
                    log.warning("Link query already defined on a previous rule.");
                } else {
                    this.linkStyle = styleRules[i].getLinkStyle();
                    this.directionStyle = styleRules[i].getDirectionStyle();
                    this.bidirectionStyle = styleRules[i].getBiDirectionStyle();
                    this.linkDirectionPosition = styleRules[i].getDirectionPosition();
                    this.dirStyleSize = styleRules[i].getDirectionStyleSize();
                    this.multipleMarker = styleRules[i].hasMultipleDirectionMarkers();
                    this.linkLabelStyle = styleRules[i].getLinkLabelStyle();
                    this.linkLabelColumn = styleRules[i].getLinkLabelColumn();
                    this.rewriteLinkQuery();
                }
            }
            if (styleRules[i].getNodeStyle() != null) {
                if (this.nodeQuery != null) {
                    log.warning("Node query already defined on a previous rule.");
                } else {
                    this.nodeStyle = styleRules[i].getNodeStyle();
                    this.nodeStyleSize = styleRules[i].getNodeStyleSize();
                    this.nodeLabelStyle = styleRules[i].getNodeLabelStyle();
                    this.nodeLabelColumn = styleRules[i].getNodeLabelColumn();
                    this.rewriteNodeQuery();
                }
            }
            if (this.pathQuery != null) {
                log.warning("Path query already defined on a previous rule.");
                continue;
            }
            this.generatePathQueries(styleRules[i].getPathIds(), styleRules[i].getPathStyles());
            this.pathLabelStyle = styleRules[i].getPathLabelStyle();
            this.pathLabelColumn = styleRules[i].getPathLabelColumn();
            this.rewritePathQueries();
        }
    }

    public NetworkThemeDefinition(String name, String dataSource, String netName, String algorithm, int startNode, int endNode, String linkStyleName, String startStyle, String endStyle, int netLevel, boolean passThrough) {
        this.name = name;
        this.dataSource = dataSource;
        if (!this.readMetadata(dataSource, netName)) {
            return;
        }
        this.spAlgorithm = algorithm;
        this.spStyle = linkStyleName;
        this.spStartNode = startNode;
        this.spEndNode = endNode;
        this.spStartStyle = startStyle;
        this.spEndStyle = endStyle;
        this.networkLevel = netLevel;
        this.passThrough = passThrough;
    }

    public NetworkThemeDefinition(String name, String dataSource, String netName, int startNode, String startStyle, String linkStyleName, double cost, int netLevel, boolean passThrough) {
        this.name = name;
        this.dataSource = dataSource;
        if (!this.readMetadata(dataSource, netName)) {
            return;
        }
        this.spAlgorithm = WITHINCOST_ALGORITHM;
        this.spStyle = linkStyleName;
        this.spStartNode = startNode;
        this.spStartStyle = startStyle;
        this.spCost = cost;
        this.networkLevel = netLevel;
        this.passThrough = passThrough;
    }

    public void rewriteLinkQuery() {
        String tbSchema = "";
        if (this.connectionUser != null && this.networkOwner != null && !this.connectionUser.equalsIgnoreCase(this.networkOwner)) {
            tbSchema = this.networkOwner + ".";
        }
        String geokey = "";
        if (this.predefined) {
            geokey = this.getLinkKeyColumn() + ", ";
        }
        String bidirAttr = "";
        if (this.bidirectionAttr) {
            bidirAttr = ", bidirected";
        }
        this.linkQuery = null;
        if (this.linkStyle != null) {
            if (this.geometryType.equals("SDO_GEOMETRY")) {
                this.linkQuery = this.linkLabelStyle == null || this.linkLabelColumn == null ? "select " + geokey + this.linkGeomColumn + bidirAttr + " from " + tbSchema + this.linkTableName : "select " + geokey + this.linkGeomColumn + ", " + this.linkLabelColumn + bidirAttr + " from " + tbSchema + this.linkTableName;
            } else if (this.geometryType.equals("LRS_GEOMETRY")) {
                this.linkQuery = this.linkLabelStyle == null || this.linkLabelColumn == null ? "select " + geokey + this.lrsGeomColumn + " from " + tbSchema + this.lrsTableName : "select " + geokey + this.lrsGeomColumn + ", " + this.linkLabelColumn + " from " + tbSchema + this.lrsTableName;
            } else if (this.geometryType.equals("TOPO_GEOMETRY")) {
                this.linkQuery = "select " + geokey + this.linkGeomColumn + ", " + this.linkLabelColumn + bidirAttr + " from " + tbSchema + this.linkTableName;
                StylingRule[] rules = new StylingRule[]{new StylingRule()};
                if (this.bidirectionAttr) {
                    rules[0].setAttributeColumns(new String[]{"bidirected"});
                }
                rules[0].setFeatureStyleName(this.linkStyle);
                if (this.linkLabelStyle != null && this.linkLabelColumn != null) {
                    rules[0].setLabelColumn(this.linkLabelColumn);
                    rules[0].setLabelStyleName(this.linkLabelStyle);
                    rules[0].setLabeFunction("1");
                    rules[0].setLabeled(true);
                }
                TopologyThemeDefinition def = new TopologyThemeDefinition(this.getName() + "_links", this.dataSource, this.topologyName, this.linkTableName, this.linkGeomColumn, "ROWID", rules, this.getSrid(), 1);
                this.linkFeaturesTheme = new TopologyTheme(def);
            } else {
                this.linkQuery = null;
            }
        }
    }

    public void rewriteNodeQuery() {
        String tbSchema = "";
        if (this.connectionUser != null && this.networkOwner != null && !this.connectionUser.equalsIgnoreCase(this.networkOwner)) {
            tbSchema = this.networkOwner + ".";
        }
        String geokey = "";
        String lrskey = "";
        if (this.predefined) {
            geokey = this.getNodeKeyColumn() + ",";
            lrskey = tbSchema + this.lrsTableName + "." + this.getNodeKeyColumn() + ",";
        }
        this.nodeQuery = null;
        if (this.nodeStyle != null) {
            if (this.geometryType.equals("SDO_GEOMETRY")) {
                this.nodeQuery = this.nodeLabelStyle == null || this.nodeLabelColumn == null ? "select " + geokey + this.nodeGeomColumn + " from " + tbSchema + this.nodeTableName : "select " + geokey + this.nodeGeomColumn + ", " + this.nodeLabelColumn + " from " + tbSchema + this.nodeTableName;
            } else if (this.geometryType.equals("LRS_GEOMETRY")) {
                this.nodeQuery = this.nodeLabelStyle == null || this.nodeLabelColumn == null ? "select " + lrskey + this.lrsGeomColumn + ", measure, " + tbSchema + this.lrsTableName + ".geom_id from " + tbSchema + this.lrsTableName + " inner join " + tbSchema + this.nodeTableName + " on " + tbSchema + this.lrsTableName + ".geom_id = " + tbSchema + this.nodeTableName + ".geom_id" : "select " + lrskey + this.lrsGeomColumn + ", measure, " + tbSchema + this.lrsTableName + ".geom_id," + tbSchema + this.nodeTableName + "." + this.nodeLabelColumn + " from " + tbSchema + this.lrsTableName + " inner join " + tbSchema + this.nodeTableName + " on " + tbSchema + this.lrsTableName + ".geom_id = " + tbSchema + this.nodeTableName + ".geom_id";
            } else if (this.geometryType.equals("TOPO_GEOMETRY")) {
                this.nodeQuery = "select " + geokey + this.nodeGeomColumn + ", " + this.nodeLabelColumn + " from " + tbSchema + this.nodeTableName;
                StylingRule[] rules = new StylingRule[]{new StylingRule()};
                rules[0].setFeatureStyleName(this.nodeStyle);
                if (this.nodeLabelStyle != null && this.nodeLabelColumn != null) {
                    rules[0].setLabelColumn(this.nodeLabelColumn);
                    rules[0].setLabelStyleName(this.nodeLabelStyle);
                    rules[0].setLabeFunction("1");
                    rules[0].setLabeled(true);
                }
                TopologyThemeDefinition def = new TopologyThemeDefinition(this.getName() + "_nodes", this.dataSource, this.topologyName, this.nodeTableName, this.nodeGeomColumn, "ROWID", rules, this.getSrid(), 1);
                this.nodeFeaturesTheme = new TopologyTheme(def);
            } else {
                this.nodeQuery = null;
            }
        }
    }

    public void rewritePathQueries() {
        if (this.idPaths == null) {
            return;
        }
        String tbSchema = "";
        if (this.connectionUser != null && this.networkOwner != null && !this.connectionUser.equalsIgnoreCase(this.networkOwner)) {
            tbSchema = this.networkOwner + ".";
        }
        for (int i = 0; i < this.idPaths.length; ++i) {
            if (this.pathQuery[i] == null || this.idPaths[i] == 0) continue;
            if (this.pathLabelStyle == null || this.pathLabelColumn == null) {
                if (this.geometryType.equals("SDO_GEOMETRY")) {
                    this.pathQuery[i] = "select " + this.linkGeomColumn + " from " + tbSchema + this.linkTableName + " inner join " + tbSchema + this.pathLinkTableName + " on " + tbSchema + this.linkTableName + ".link_id = " + tbSchema + this.pathLinkTableName + ".link_id where path_id = " + this.idPaths[i] + " order by seq_no";
                    continue;
                }
                if (this.geometryType.equals("LRS_GEOMETRY")) {
                    this.pathQuery[i] = "select mv_lrs_geom.* from (select " + this.lrsGeomColumn + ", link_id, start_measure, " + "end_measure from " + tbSchema + this.lrsTableName + " inner join " + tbSchema + this.linkTableName + " on " + tbSchema + this.lrsTableName + ".geom_id = " + tbSchema + this.linkTableName + ".geom_id) mv_lrs_geom inner join " + tbSchema + this.pathLinkTableName + " on mv_lrs_geom.link_id = " + tbSchema + this.pathLinkTableName + ".link_id where path_id = " + this.idPaths[i] + " order by seq_no";
                    continue;
                }
                if (this.geometryType.equals("TOPO_GEOMETRY")) {
                    this.pathQuery[i] = "select " + tbSchema + this.pathTableName + "." + this.pathGeomColumn + " from " + tbSchema + this.pathTableName + " where path_id = " + this.idPaths[i];
                    continue;
                }
                this.pathQuery[i] = null;
                continue;
            }
            this.pathQuery[i] = this.geometryType.equals("SDO_GEOMETRY") ? "select " + tbSchema + this.linkTableName + "." + this.linkGeomColumn + "," + tbSchema + this.pathTableName + "." + this.pathLabelColumn + " from " + tbSchema + this.pathTableName + " inner join " + tbSchema + this.pathLinkTableName + " on " + tbSchema + this.pathTableName + ".path_id = " + tbSchema + this.pathLinkTableName + ".path_id inner join " + tbSchema + this.linkTableName + " on " + tbSchema + this.pathLinkTableName + ".link_id = " + tbSchema + this.linkTableName + ".link_id where " + tbSchema + this.pathLinkTableName + ".path_id = " + this.idPaths[i] + " order by seq_no" : (this.geometryType.equals("LRS_GEOMETRY") ? "select mv_lrs_geom.*, " + tbSchema + this.pathTableName + "." + this.pathLabelColumn + " from " + tbSchema + this.pathTableName + " inner join " + tbSchema + this.pathLinkTableName + " on " + tbSchema + this.pathTableName + ".path_id = " + tbSchema + this.pathLinkTableName + ".path_id inner join " + "(select " + this.lrsGeomColumn + ", link_id, start_measure, " + "end_measure from " + tbSchema + this.lrsTableName + " inner join " + tbSchema + this.linkTableName + " on " + tbSchema + this.lrsTableName + ".geom_id = " + tbSchema + this.linkTableName + ".geom_id) mv_lrs_geom on " + tbSchema + this.pathLinkTableName + ".link_id = mv_lrs_geom.link_id " + "where " + tbSchema + this.pathLinkTableName + ".path_id = " + this.idPaths[i] + " order by seq_no" : (this.geometryType.equals("TOPO_GEOMETRY") ? "select " + tbSchema + this.pathTableName + "." + this.pathGeomColumn + "," + tbSchema + this.pathTableName + "." + this.pathLabelColumn + " from " + tbSchema + this.pathTableName + " where path_id = " + this.idPaths[i] : null));
        }
    }

    private void generatePathQueries(String pathIds, String pathStyleNames) {
        String tbSchema = "";
        if (this.connectionUser != null && this.networkOwner != null && !this.connectionUser.equalsIgnoreCase(this.networkOwner)) {
            tbSchema = this.networkOwner + ".";
        }
        if (pathIds != null) {
            ArrayList ids = Util.splitBy(pathIds, ",");
            this.idPaths = new int[ids.size()];
            for (int k = 0; k < ids.size(); ++k) {
                try {
                    this.idPaths[k] = Integer.parseInt((String)ids.get(k));
                    continue;
                }
                catch (Exception ex) {
                    log.warning("Network Theme with invalid path Id.");
                    this.idPaths[k] = 0;
                }
            }
            ArrayList styles = Util.splitBy(pathStyleNames, ",");
            this.pathStyles = new String[ids.size()];
            for (int k = 0; k < styles.size(); ++k) {
                this.pathStyles[k] = (String)styles.get(k);
            }
            if (ids.size() != styles.size()) {
                log.warning("Each Path ID must have a Path Style.");
            }
            this.pathQuery = new String[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                this.pathQuery[i] = null;
                if (this.idPaths[i] == 0) continue;
                if (this.geometryType.equals("SDO_GEOMETRY")) {
                    if (this.pathStyles[i] == null) continue;
                    this.pathQuery[i] = "select " + this.linkGeomColumn + " from " + tbSchema + this.linkTableName + " inner join " + tbSchema + this.pathLinkTableName + " on " + tbSchema + this.linkTableName + ".link_id = " + tbSchema + this.pathLinkTableName + ".link_id where path_id = " + this.idPaths[i] + " order by seq_no";
                    continue;
                }
                if (this.geometryType.equals("LRS_GEOMETRY")) {
                    this.pathQuery[i] = "select mv_lrs_geom.* from (select " + this.lrsGeomColumn + ", link_id, start_measure, " + "end_measure from " + tbSchema + this.lrsTableName + " inner join " + tbSchema + this.linkTableName + " on " + tbSchema + this.lrsTableName + ".geom_id = " + tbSchema + this.linkTableName + ".geom_id) mv_lrs_geom inner join " + tbSchema + this.pathLinkTableName + " on mv_lrs_geom.link_id = " + tbSchema + this.pathLinkTableName + ".link_id where path_id = " + this.idPaths[i] + " order by seq_no";
                    continue;
                }
                if (this.geometryType.equals("TOPO_GEOMETRY")) {
                    if (this.pathStyles[i] == null) continue;
                    this.pathQuery[i] = "select " + this.pathGeomColumn + " from " + tbSchema + this.pathTableName + " where path_id = " + this.idPaths[i];
                    continue;
                }
                this.pathQuery[i] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readMetadata(String dataSrc, String netName) {
        String netquery = "select * from user_sdo_network_metadata where network = '" + netName.toUpperCase() + "'";
        AbstractDBDataSource ds = (AbstractDBDataSource)DSManager.get(this.dataSource);
        if (ds == null) {
            log.severe("Unable to get data source: " + dataSrc);
            return false;
        }
        this.networkOwner = this.connectionUser = ds.getUser();
        int index = netName.indexOf(".");
        if (index > -1) {
            String tbSchema = netName.substring(0, index);
            String ntName = netName.substring(index + 1, netName.length());
            netquery = "select * from all_sdo_network_metadata where network = '" + ntName.toUpperCase() + "'" + " and owner = '" + tbSchema.toUpperCase() + "'";
        }
        Connection conn = null;
        log.info("[Network Metadata Query] " + netquery);
        PreparedStatement netStmt = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            netStmt = conn.prepareStatement(netquery);
            rs = netStmt.executeQuery();
            if (!rs.next()) {
                log.severe("Unable to load Network " + netName);
                boolean bl = false;
                return bl;
            }
            if (index > -1) {
                this.networkOwner = rs.getString("owner");
            }
            this.networkName = rs.getString("network");
            this.networkId = rs.getInt("network_id");
            this.networkCategory = rs.getString("network_category");
            this.geometryType = rs.getString("geometry_type");
            this.networkType = rs.getString("network_type");
            this.hierachyLevels = rs.getInt("no_of_hierarchy_levels");
            this.lrsTableName = rs.getString("lrs_table_name");
            this.lrsGeomColumn = rs.getString("lrs_geom_column");
            this.nodeTableName = rs.getString("node_table_name");
            this.nodeGeomColumn = rs.getString("node_geom_column");
            this.nodeCostColumn = rs.getString("node_cost_column");
            this.linkTableName = rs.getString("link_table_name");
            this.linkGeomColumn = rs.getString("link_geom_column");
            this.linkDirection = rs.getString("link_direction");
            this.linkCostColumn = rs.getString("link_cost_column");
            this.pathTableName = rs.getString("path_table_name");
            this.pathGeomColumn = rs.getString("path_geom_column");
            this.pathLinkTableName = rs.getString("path_link_table_name");
            this.topologyName = rs.getString("topology");
        }
        catch (Exception ex) {
            log.severe("Network load metadata Exception: " + ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (netStmt != null) {
                try {
                    netStmt.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception re) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bidirectionAttrExists(String dataSrc) {
        if (this.linkTableName == null) {
            return false;
        }
        String tbSchema = "";
        if (this.connectionUser != null && this.networkOwner != null && !this.connectionUser.equalsIgnoreCase(this.networkOwner)) {
            tbSchema = this.networkOwner + ".";
        }
        String netquery = "select * from " + tbSchema + this.linkTableName + " where rownum < 1";
        DBDataSource ds = (DBDataSource)DSManager.get(dataSrc);
        if (ds == null) {
            log.severe("Unable to get data source: " + dataSrc);
            return false;
        }
        Connection conn = null;
        PreparedStatement netStmt = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            netStmt = conn.prepareStatement(netquery);
            rs = netStmt.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int totalColCount = meta.getColumnCount();
            for (int i = 0; i < totalColCount; ++i) {
                if (!meta.getColumnName(i + 1).equalsIgnoreCase("BIDIRECTED")) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            log.severe("Network bidirection check Exception: " + ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (netStmt != null) {
                try {
                    netStmt.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception re) {}
            }
        }
        return false;
    }

    public void setNetworkThemeLabels(String linkLabelStyle, String linkLabelColumn, String nodeLabelStyle, String nodeLabelColumn, String pathLabelStyle, String pathLabelColumn) {
        if (this.predefined) {
            return;
        }
        if (linkLabelStyle != null && linkLabelColumn != null) {
            this.linkLabelStyle = linkLabelStyle;
            this.linkLabelColumn = linkLabelColumn;
        } else {
            this.linkLabelStyle = null;
            this.linkLabelColumn = null;
        }
        if (nodeLabelStyle != null && nodeLabelColumn != null) {
            this.nodeLabelStyle = nodeLabelStyle;
            this.nodeLabelColumn = nodeLabelColumn;
        } else {
            this.nodeLabelStyle = null;
            this.nodeLabelColumn = null;
        }
        if (pathLabelStyle != null && pathLabelColumn != null) {
            this.pathLabelStyle = pathLabelStyle;
            this.pathLabelColumn = pathLabelColumn;
        } else {
            this.pathLabelStyle = null;
            this.pathLabelColumn = null;
        }
        this.rewriteLinkQuery();
        this.rewriteNodeQuery();
        this.rewritePathQueries();
    }

    public void setASIS(boolean v) {
        this.passThrough = v;
    }

    public boolean getASIS() {
        return this.passThrough;
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    public String getKeyColumn() {
        return this.mKeyColumn;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public String getNetworkOwner() {
        return this.networkOwner;
    }

    public String getNetworkCategory() {
        return this.networkCategory;
    }

    public String getLinkCacheGroup() {
        return this.linkCacheGroup;
    }

    public String getNodeCacheGroup() {
        return this.nodeCacheGroup;
    }

    public String getCacheSubRegion() {
        return this.cacheSubRegionName;
    }

    public String getLinkQuery() {
        return this.linkQuery;
    }

    public String getNodeQuery() {
        return this.nodeQuery;
    }

    public String[] getPathQueries() {
        return this.pathQuery;
    }

    public String[] getPathStyles() {
        return this.pathStyles;
    }

    public int[] getPathIds() {
        return this.idPaths;
    }

    public String getLinkCacheGroup(int SRid) {
        Integer id = new Integer(SRid);
        Object obj = this.sridLinkCache.get(id);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public String getNodeCacheGroup(int SRid) {
        Integer id = new Integer(SRid);
        Object obj = this.sridNodeCache.get(id);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public Hashtable getLinkSRidCache() {
        return this.sridLinkCache;
    }

    public Hashtable getNodeSRidCache() {
        return this.sridNodeCache;
    }

    public void createLinkCacheGroup(int SRid) {
        Integer id = new Integer(SRid);
        if (this.sridLinkCache.get(id) != null) {
            log.info("Link cache group for SRid " + SRid + " already exists.");
            return;
        }
        log.finer("Creating a link cache group for SRID: " + SRid);
        String CacheGroup2 = this.networkName + "_" + SRid + "_LINK_PDT_NET";
        log.finer("Cache group: " + CacheGroup2);
        boolean pinned = this.cachingMode == 2;
        try {
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, CacheGroup2, 0, pinned);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        this.sridLinkCache.put(id, CacheGroup2);
    }

    public void createNodeCacheGroup(int SRid) {
        Integer id = new Integer(SRid);
        if (this.sridNodeCache.get(id) != null) {
            log.info("Node cache group for SRid " + SRid + " already exists.");
            return;
        }
        log.finer("Creating a node cache group for SRID: " + SRid);
        String CacheGroup2 = this.networkName + "_" + SRid + "_NODE_PDT_NET";
        log.finer("Cache group: " + CacheGroup2);
        boolean pinned = this.cachingMode == 2;
        try {
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, CacheGroup2, 0, pinned);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        this.sridNodeCache.put(id, CacheGroup2);
    }

    public int getCachingMode() {
        return this.cachingMode;
    }

    public String getLinkStyle() {
        return this.linkStyle;
    }

    public void setLinkStyle(String style) {
        this.linkStyle = style;
        if (this.mSRule != null) {
            this.mSRule.setLinkStyle(style);
        }
    }

    public String getNodeStyle() {
        return this.nodeStyle;
    }

    public void setNodeStyle(String style) {
        this.nodeStyle = style;
        if (this.mSRule != null) {
            this.mSRule.setNodeStyle(style);
        }
    }

    public SizeDefinition getNodeStyleSize() {
        return this.nodeStyleSize;
    }

    public void setNodeStyleSize(SizeDefinition size) {
        this.nodeStyleSize = size == null ? new SizeDefinition(8.0, null) : size;
        if (this.mSRule != null) {
            this.mSRule.setNodeStyleSize(this.nodeStyleSize);
        }
    }

    public String getDirectionStyle() {
        return this.directionStyle;
    }

    public void setDirectionStyle(String style) {
        this.directionStyle = style;
        if (this.mSRule != null) {
            this.mSRule.setDirectionStyle(style);
        }
    }

    public String getBiDirectionStyle() {
        return this.bidirectionStyle;
    }

    public SizeDefinition getDirectionStyleSize() {
        return this.dirStyleSize;
    }

    public void setDirectionStyleSize(SizeDefinition size) {
        this.dirStyleSize = size == null ? new SizeDefinition(8.0, null) : size;
        if (this.mSRule != null) {
            this.mSRule.setDirectionStyleSize(this.dirStyleSize);
        }
    }

    public String getLinkDirection() {
        return this.linkDirection;
    }

    public double getLinkDirectionPosition() {
        return this.linkDirectionPosition;
    }

    public void setLinkdDirectionPosition(double pos) {
        this.linkDirectionPosition = pos;
        if (this.mSRule != null) {
            this.mSRule.setDirectionPosition(pos);
        }
    }

    public String getShortestPathAlgorithm() {
        return this.spAlgorithm;
    }

    public String getShortestPathStyle() {
        return this.spStyle;
    }

    public String getShortestPathStartStyle() {
        return this.spStartStyle;
    }

    public String getShortestPathEndStyle() {
        return this.spEndStyle;
    }

    public int getShortestPathStartNode() {
        return this.spStartNode;
    }

    public int getShortestPathEndNode() {
        return this.spEndNode;
    }

    public String getLRSGeometryColumn() {
        return this.lrsGeomColumn;
    }

    public String getLRSTableName() {
        return this.lrsTableName;
    }

    public String getLinkGeometryColumn() {
        return this.linkGeomColumn;
    }

    public String getNodeGeometryColumn() {
        return this.nodeGeomColumn;
    }

    public String getPathGeometryColumn() {
        return this.pathGeomColumn;
    }

    public String getLinkTableName() {
        return this.linkTableName;
    }

    public String getNodeTableName() {
        return this.nodeTableName;
    }

    public void setShortestPathIds(int[] ids) {
        this.spIDS = ids;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public int getNetworkLevel() {
        return this.networkLevel;
    }

    public double getShortestPathCost() {
        return this.spCost;
    }

    public String getGeometryType() {
        return this.geometryType;
    }

    public void setNodeQuery(String nq) {
        this.nodeQuery = nq;
    }

    public String getLinkLabelStyle() {
        return this.linkLabelStyle;
    }

    public void setLinkLabelStyle(String style) {
        this.linkLabelStyle = style;
        if (this.mSRule != null) {
            this.mSRule.setLinkLabelStyle(style);
        }
    }

    public String getLinkLabelColumn() {
        return this.linkLabelColumn;
    }

    public void setLinkLabelColumn(String column) {
        this.linkLabelColumn = column;
        if (this.mSRule != null) {
            this.mSRule.setLinkLabelColumn(column);
        }
    }

    public String getNodeLabelStyle() {
        return this.nodeLabelStyle;
    }

    public void setNodeLabelStyle(String style) {
        this.nodeLabelStyle = style;
        if (this.mSRule != null) {
            this.mSRule.setNodeLabelStyle(style);
        }
    }

    public String getNodeLabelColumn() {
        return this.nodeLabelColumn;
    }

    public void setNodeLabelColumn(String column) {
        this.nodeLabelColumn = column;
        if (this.mSRule != null) {
            this.mSRule.setNodeLabelColumn(column);
        }
    }

    public String getPathLabelStyle() {
        return this.pathLabelStyle;
    }

    public void setPathLabelStyle(String style) {
        this.pathLabelStyle = style;
        if (this.mSRule != null) {
            this.mSRule.setPathLabelStyle(style);
        }
    }

    public String getPathLabelColumn() {
        return this.pathLabelColumn;
    }

    public void setPathLabelColumn(String column) {
        this.pathLabelColumn = column;
        if (this.mSRule != null) {
            this.mSRule.setPathLabelColumn(column);
        }
    }

    @Override
    public String getThemeType() {
        return "NETWORK";
    }

    @Override
    public String getXMLDefinition() {
        StringBuffer xmlDef = new StringBuffer(2048);
        xmlDef.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n<styling_rules");
        this.getCommonAttributes(xmlDef);
        xmlDef.append(">\n");
        xmlDef.append(this.getAttributes());
        if (this.mSRule != null) {
            xmlDef.append("  <rule>\n");
            xmlDef.append(this.getRuleFeatures(this.mSRule));
            xmlDef.append(this.getRuleLabel(this.mSRule));
            xmlDef.append("  </rule>\n");
        }
        xmlDef.append("</styling_rules>");
        return xmlDef.toString();
    }

    void getCommonAttributes(StringBuffer xmlAttr) {
        String key;
        String themeType = this.getThemeType();
        if (themeType != null && themeType.trim().length() > 0) {
            xmlAttr.append(" theme_type=\"" + themeType + "\"");
        }
        if ((key = this.getKeyColumn()) != null && key.trim().length() > 0) {
            xmlAttr.append(" key_column=\"" + key + "\"");
        }
        int cm = this.getCachingMode();
        String caching = "normal";
        if (cm == 2) {
            caching = "all";
        } else if (cm == 3) {
            caching = "none";
        }
        if (caching != null && caching.trim().length() > 0) {
            xmlAttr.append(" caching=\"" + caching + "\"");
        }
    }

    public String getAttributes() {
        String netAttr = "";
        if (this.networkName != null) {
            netAttr = netAttr + " network_name=\"" + this.networkName + "\"";
        }
        if (this.networkLevel != 1) {
            netAttr = netAttr + " network_level=\"" + this.networkLevel + "\"";
        }
        return netAttr;
    }

    public String getRuleFeatures(StylingRule sr) {
        String nodeStyle;
        String ruleFeat = "    <features>\n";
        String linkStyle = sr.getLinkStyle();
        if (linkStyle != null) {
            ruleFeat = ruleFeat + "      <link style=\"" + linkStyle + "\"";
            String directionStyle = sr.getDirectionStyle();
            if (directionStyle != null) {
                ruleFeat = ruleFeat + " direction_style=\"" + directionStyle + "\"" + " direction_position=\"" + sr.getDirectionPosition() + "\"" + " direction_markersize=\"" + sr.getDirectionStyleSize() + "\"";
            }
            ruleFeat = ruleFeat + "></link>\n";
        }
        if ((nodeStyle = sr.getNodeStyle()) != null) {
            ruleFeat = ruleFeat + "      <node style=\"" + nodeStyle + "\"" + " markersize=\"" + sr.getNodeStyleSize() + "\"></node>\n";
        }
        String pathStyles = sr.getPathStyles();
        String pathIds = sr.getPathIds();
        if (pathStyles != null) {
            ruleFeat = ruleFeat + "      <path ";
            if (pathIds != null) {
                ruleFeat = ruleFeat + " ids=\"" + pathIds + "\"";
            }
            ruleFeat = ruleFeat + " styles=\"" + pathStyles + "\"></path>\n";
        }
        ruleFeat = ruleFeat + "    </features>\n";
        return ruleFeat;
    }

    public String getRuleLabel(StylingRule sr) {
        if (!sr.getLabeled()) {
            return "";
        }
        String ruleLabel = "    <label>\n";
        String linkLabelStyle = sr.getLinkLabelStyle();
        String linkLabelCol = sr.getLinkLabelColumn();
        if (linkLabelStyle != null) {
            ruleLabel = ruleLabel + "      <link";
            if (linkLabelCol != null) {
                ruleLabel = ruleLabel + " column=\"" + linkLabelCol + "\"";
            }
            ruleLabel = ruleLabel + " style=\"" + linkLabelStyle + "\"> 1 </link>\n";
        }
        String nodeLabelStyle = sr.getNodeLabelStyle();
        String nodeLabelCol = sr.getNodeLabelColumn();
        if (nodeLabelStyle != null) {
            ruleLabel = ruleLabel + "      <node";
            if (nodeLabelCol != null) {
                ruleLabel = ruleLabel + " column=\"" + nodeLabelCol + "\"";
            }
            ruleLabel = ruleLabel + " style=\"" + nodeLabelStyle + "\"> 1 </node>\n";
        }
        String pathLabelStyle = sr.getPathLabelStyle();
        String pathLabelCol = sr.getPathLabelColumn();
        if (pathLabelStyle != null) {
            ruleLabel = ruleLabel + "      <path";
            if (pathLabelCol != null) {
                ruleLabel = ruleLabel + " column=\"" + pathLabelCol + "\"";
            }
            ruleLabel = ruleLabel + " style=\"" + pathLabelStyle + "\"> 1 </path>\n";
        }
        ruleLabel = ruleLabel + "    </label>\n";
        return ruleLabel;
    }

    public void setMultipleDirectionMarkers(boolean value) {
        this.multipleMarker = value;
        if (this.mSRule != null) {
            this.mSRule.setMultipleDirectionMarkers(value);
        }
    }

    public boolean hasMultipleDirectionMarkers() {
        return this.multipleMarker;
    }

    public void setBiDirectionStyle(String name) {
        this.bidirectionStyle = name;
        if (this.mSRule != null) {
            this.mSRule.setBiDirectionStyle(name);
        }
    }

    public boolean hasBidirectionAttribute() {
        return this.bidirectionAttr;
    }

    public String getConnectionUser() {
        return this.connectionUser;
    }

    @Override
    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo ti = new BasicThemeInfo();
        ti.setName(this.getName());
        ti.setBaseTable(this.getLinkTableName());
        ti.setType("NETWORK");
        ti.setKeyColumn(this.getKeyColumn());
        ti.setSrid(this.getSrid());
        ti.setSpatialColumn(this.getLinkGeometryColumn());
        return ti;
    }

    @Override
    public String[] getRenderingStyles() {
        if (this.linkStyle == null && this.nodeStyle == null && this.pathStyles == null) {
            return null;
        }
        ArrayList<String> styleNames = new ArrayList<String>();
        if (this.linkStyle != null) {
            styleNames.add(this.linkStyle.toUpperCase());
        }
        if (this.nodeStyle != null && !styleNames.contains(this.nodeStyle.toUpperCase())) {
            styleNames.add(this.nodeStyle.toUpperCase());
        }
        if (this.pathStyles != null) {
            for (int i = 0; i < this.pathStyles.length; ++i) {
                if (styleNames.contains(this.pathStyles[i].toUpperCase())) continue;
                styleNames.add(this.pathStyles[i].toUpperCase());
            }
        }
        if (styleNames.size() < 1) {
            return null;
        }
        return styleNames.toArray(new String[styleNames.size()]);
    }

    @Override
    public String[] getLabelingStyles() {
        if (this.linkLabelStyle == null && this.nodeLabelStyle == null && this.pathLabelStyle == null) {
            return null;
        }
        ArrayList<String> styleNames = new ArrayList<String>();
        if (this.linkLabelStyle != null) {
            styleNames.add(this.linkLabelStyle.toUpperCase());
        }
        if (this.nodeLabelStyle != null && !styleNames.contains(this.nodeLabelStyle.toUpperCase())) {
            styleNames.add(this.nodeLabelStyle.toUpperCase());
        }
        if (this.pathLabelStyle != null && !styleNames.contains(this.pathLabelStyle.toUpperCase())) {
            styleNames.add(this.pathLabelStyle.toUpperCase());
        }
        if (styleNames.size() < 1) {
            return null;
        }
        return styleNames.toArray(new String[styleNames.size()]);
    }

    public String getNodeKeyColumn() {
        if (this.nodeKeyColumn == null) {
            return this.getKeyColumn();
        }
        return this.nodeKeyColumn;
    }

    public void setNodeKeyColumn(String key) {
        this.nodeKeyColumn = key;
        this.rewriteNodeQuery();
    }

    public String getLinkKeyColumn() {
        if (this.linkKeyColumn == null) {
            return this.getKeyColumn();
        }
        return this.linkKeyColumn;
    }

    public void setLinkKeyColumn(String key) {
        this.linkKeyColumn = key;
        this.rewriteLinkQuery();
    }

    @Override
    public String[] getHighlightStyles() {
        return null;
    }

    @Override
    public String[] getLabelColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        if (this.linkLabelStyle != null && this.linkLabelColumn != null) {
            columns.add(this.linkLabelColumn);
        }
        if (this.nodeLabelStyle != null && this.nodeLabelColumn != null) {
            columns.add(this.nodeLabelColumn);
        }
        if (this.pathLabelStyle != null && this.pathLabelColumn != null) {
            columns.add(this.pathLabelColumn);
        }
        if (columns.size() == 0) {
            return null;
        }
        return columns.toArray(new String[columns.size()]);
    }

    @Override
    public Field[] getDistinctAttrColumns() {
        return null;
    }

    public TopologyTheme getLinkTopologyTheme() {
        return this.linkFeaturesTheme;
    }

    public TopologyTheme getNodeTopologyTheme() {
        return this.nodeFeaturesTheme;
    }

    public StylingRule getStylingRule() {
        return this.mSRule;
    }
}

