/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.SRS;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;
import org.owasp.esapi.ESAPI;

public class ImageThemeDefinition
extends ThemeDefinition {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    String format = "GIF";
    String query = null;
    int width;
    int height;
    boolean preserveScale = true;
    boolean passThrough = true;
    String imageColumn = null;
    String mbrColumn = null;
    boolean predefined = false;
    String mBaseTable = null;
    String mKeyColumn = null;
    StylingRule mSRule = null;
    protected String cacheGroupName = null;
    String cacheSubRegionName = null;
    String unit = null;
    double resolution = -1.0;
    float alpha = 1.0f;

    public ImageThemeDefinition() {
        this.predefined = false;
    }

    public ImageThemeDefinition(String name, String dataSource, String mBaseTable, String mSpatialColumn, String keyColumn, String imageColumn, String imageFormat, StylingRule[] styleRules, int srid) {
        try {
            this.predefined = true;
            this.name = name;
            this.dataSource = dataSource;
            DBDataSource ds = (DBDataSource)DSManager.get(dataSource);
            this.is9i = ds.is9i();
            this.mBaseTable = mBaseTable;
            this.mKeyColumn = keyColumn;
            this.mbrColumn = mSpatialColumn;
            this.imageColumn = imageColumn;
            this.format = imageFormat;
            this.srid = srid;
            this.mSRule = styleRules[0];
            this.cacheGroupName = mBaseTable + "_" + imageColumn.toUpperCase() + "_PDT_IMG";
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public void setImageQuery(String _query) {
        String userQuery = _query;
        log.finest("Before esapi canonicalizing: " + userQuery);
        this.query = ESAPI.encoder().canonicalize(userQuery, true);
        log.finest("After esapi canonicalizing: " + this.query);
    }

    public String getImageQuery() {
        return this.query;
    }

    public void setImageFormat(String fmt) {
        this.format = fmt;
    }

    public String getImageFormat() {
        return this.format;
    }

    public void setAlpha(float a) {
        this.alpha = a;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public String getBaseTableName() {
        return this.mBaseTable;
    }

    public void setBaseTableName(String table) {
        this.mBaseTable = table;
    }

    public String getImageColumnName() {
        return this.imageColumn;
    }

    public void setImageColumn(String imgCol) {
        this.imageColumn = imgCol;
    }

    public String getMBRColumn() {
        return this.mbrColumn;
    }

    public void setMBRColumn(String mbrCol) {
        this.mbrColumn = mbrCol;
    }

    public boolean getASIS() {
        return this.passThrough;
    }

    public void setASIS(boolean v) {
        this.passThrough = v;
    }

    public void setImageResolution(String unit, double res) {
        if (unit == null || SRS.distUnitList.get(unit.toUpperCase()) == null) {
            throw new IllegalArgumentException("Invalid image resolution unit given.");
        }
        this.unit = unit.toUpperCase();
        this.resolution = res;
    }

    public double getImageResolution() {
        return this.resolution;
    }

    public void setImageResolution(double res) {
        this.resolution = res;
    }

    public String getImageResolutionUnit() {
        return this.unit;
    }

    public void setImageResolutionUnit(String resUnit) {
        this.unit = resUnit;
    }

    public String getKeyColumn() {
        return this.mKeyColumn;
    }

    public void setKeyColumn(String key) {
        this.mKeyColumn = key;
    }

    public void setPredefined(boolean v) {
        this.predefined = v;
    }

    public boolean getPredefined() {
        return this.predefined;
    }

    @Override
    public String getThemeType() {
        return "IMAGE";
    }

    @Override
    public String getXMLDefinition() {
        StringBuffer xmlDef = new StringBuffer(2048);
        xmlDef.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n<styling_rules");
        this.getCommonAttributes(xmlDef);
        xmlDef.append(this.getAttributes());
        xmlDef.append(">\n");
        if (this.mSRule != null) {
            xmlDef.append("  <rule" + PredGeomThemeDefinition.getRuleAttributes(this.mSRule) + ">\n");
            xmlDef.append(PredGeomThemeDefinition.getRuleFeatures(this.mSRule));
            xmlDef.append(PredGeomThemeDefinition.getRuleLabel(this.mSRule));
            xmlDef.append("  </rule>\n");
        }
        xmlDef.append("</styling_rules>");
        return xmlDef.toString();
    }

    void getCommonAttributes(StringBuffer xmlAttr) {
        String caching;
        String key;
        String themeType = this.getThemeType();
        if (themeType != null && themeType.trim().length() > 0) {
            xmlAttr.append(" theme_type=\"" + themeType + "\"");
        }
        if ((key = this.mKeyColumn) != null && key.trim().length() > 0) {
            xmlAttr.append(" key_column=\"" + key + "\"");
        }
        if ((caching = "normal") != null && caching.trim().length() > 0) {
            xmlAttr.append(" caching=\"" + caching + "\"");
        }
    }

    public String getAttributes() {
        String imgAttr = "";
        if (this.imageColumn != null) {
            imgAttr = imgAttr + " image_column=\"" + this.imageColumn + "\"";
        }
        if (this.format != null) {
            imgAttr = imgAttr + " image_format=\"" + this.format + "\"";
        }
        if (this.unit != null) {
            imgAttr = imgAttr + " image_unit=\"" + this.unit + "\"";
        }
        if (this.resolution != -1.0) {
            imgAttr = imgAttr + " image_resolution=\"" + this.resolution + "\"";
        }
        if ((double)this.alpha != 1.0) {
            imgAttr = imgAttr + " image_alpha=\"" + this.alpha + "\"";
        }
        return imgAttr;
    }

    @Override
    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo ti = new BasicThemeInfo();
        ti.setName(this.getName());
        ti.setBaseTable(this.getBaseTableName());
        ti.setType("IMAGE");
        ti.setKeyColumn(this.getKeyColumn());
        ti.setSrid(this.getSrid());
        ti.setSpatialColumn(this.getImageColumnName());
        return ti;
    }

    @Override
    public String[] getRenderingStyles() {
        return null;
    }

    @Override
    public String[] getLabelingStyles() {
        return null;
    }

    @Override
    public String[] getHighlightStyles() {
        return null;
    }

    @Override
    public String[] getLabelColumns() {
        return null;
    }

    @Override
    public Field[] getDistinctAttrColumns() {
        return null;
    }

    public StylingRule getStylingRule() {
        return this.mSRule;
    }
}

