/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.GeoRasterBitmapMask;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.SRS;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.util.JDBCUtil;
import org.owasp.esapi.ESAPI;

public class GeoRasterThemeDefinition
extends ThemeDefinition {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    String query = null;
    boolean preserveScale = true;
    boolean passThrough = true;
    String mGeoRasterColumn = null;
    String mRasterTable = null;
    String mRasterId = null;
    String mBands = null;
    String mRasterPyramid = null;
    int pyramidLevel = 0;
    boolean predefined = false;
    String mBaseTable = null;
    String mKeyColumn = null;
    StylingRule mSRule = null;
    protected String cacheGroupName = null;
    String cacheSubRegionName = null;
    String unit = null;
    double resolution = -1.0;
    float alpha = 1.0f;
    double[] sptResolution = null;
    double lastRasterId = -1.0;
    String lastRdtTable = null;
    JSDOGeometry polygonMask = null;
    String pmaskTable = null;
    String pmaskGeomColumn = null;
    String pmaskQCondition = null;
    String pmaskJoinColumn = null;
    String pmaskJoinGeorColumn = null;
    public static final String LINEARSTRETCH_OPERATION = "LINEARSTRETCH";
    public static final String NORMALIZE_OPERATION = "NORMALIZE";
    public static final String EQUALIZE_OPERATION = "EQUALIZE";
    public static final String PIECEWISE_OPERATION = "PIECEWISELINEARSTRETCH";
    public static final String BRIGHTNESS_OPERATION = "BRIGHTNESS";
    public static final String CONTRAST_OPERATION = "CONTRAST";
    public static final String THRESHOLD_OPERATION = "CHANGETHRESHOLD";
    String[] imageProcessNames = null;
    Hashtable imageProcess = null;
    Hashtable bitmapMasks = null;
    private boolean transpNoData = false;
    private int alphaBand = -1;
    private String reprojMode = "BILINEAR";
    private boolean filterReprojResult = false;
    public static String RENDER_INTERPOLATE_NEAREST_NEIGHBOR = "NEAREST_NEIGHBOR";
    public static String RENDER_INTERPOLATE_BILINEAR = "BILINEAR";
    public static String RENDER_INTERPOLATE_BICUBIC = "BICUBIC";
    public static String RENDER_INTERPOLATE_BICUBIC2 = "BICUBIC2";
    private String renderInterpolationHint = RENDER_INTERPOLATE_NEAREST_NEIGHBOR;

    public GeoRasterThemeDefinition() {
    }

    public GeoRasterThemeDefinition(String name, String dataSource, String geoRasterTable, String geoRasterColumn, String rasterID, String rasterTable, String rasterPyramid, String query) {
        this.name = name;
        this.dataSource = dataSource;
        this.mBaseTable = geoRasterTable;
        this.mGeoRasterColumn = geoRasterColumn;
        this.mRasterPyramid = rasterPyramid;
        this.mRasterId = rasterID;
        this.mRasterTable = rasterTable;
        this.setImageQuery(query);
        DBDataSource ds = (DBDataSource)DSManager.get(dataSource);
        this.is9i = ds.is9i();
        this.predefined = false;
        if (rasterPyramid != null) {
            try {
                this.pyramidLevel = Integer.parseInt(rasterPyramid);
            }
            catch (Exception ex) {
                log.warning("Invalid pyramid value: 0 will be assumed");
                this.pyramidLevel = 0;
            }
        } else {
            this.pyramidLevel = 0;
        }
    }

    public GeoRasterThemeDefinition(String name, String dataSource, String geoRasterTable, String geoRasterColumn, String keyColumn, String rasterTable, String rasterId, String rasterPyramid, String rasterBands, StylingRule[] styleRules, int srid) {
        String pdquery = null;
        try {
            DBDataSource ds = (DBDataSource)DSManager.get(dataSource);
            this.is9i = ds.is9i();
            this.predefined = true;
            this.name = name;
            this.dataSource = dataSource;
            this.mBaseTable = geoRasterTable;
            this.mKeyColumn = keyColumn;
            this.mGeoRasterColumn = geoRasterColumn;
            this.passThrough = false;
            this.srid = srid;
            if (styleRules != null) {
                this.mSRule = styleRules[0];
                this.passThrough = styleRules[0].isQueryPassThrough();
            }
            this.mBands = rasterBands;
            this.mRasterTable = rasterTable;
            this.mRasterId = rasterId;
            this.mRasterPyramid = rasterPyramid;
            this.setImageQuery(pdquery);
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
            throw new IllegalArgumentException(ex.getMessage());
        }
        if (rasterPyramid != null) {
            try {
                this.pyramidLevel = Integer.parseInt(rasterPyramid);
            }
            catch (Exception ex) {
                log.warning("Invalid pyramid value: 0 will be assumed");
                this.pyramidLevel = 0;
            }
        } else {
            this.pyramidLevel = 0;
        }
    }

    public String getBaseTable() {
        return this.mBaseTable;
    }

    public void setBaseTable(String table) {
        this.mBaseTable = table;
    }

    public void setGeoRasterColumn(String georCol) {
        this.mGeoRasterColumn = georCol;
    }

    public void setRasterTable(String rastertable) {
        this.mRasterTable = rastertable;
    }

    public void setRasterId(String rasterid) {
        this.mRasterId = rasterid;
    }

    public void setPyramidLevel(String level) {
        try {
            this.pyramidLevel = Integer.parseInt(level);
        }
        catch (Exception ex) {
            this.pyramidLevel = 0;
        }
    }

    public int getPyramidLevel() {
        return this.pyramidLevel;
    }

    public void setBands(String bands) {
        this.mBands = bands;
    }

    public String getBands() {
        return this.mBands;
    }

    public void setASIS(boolean v) {
        this.passThrough = v;
    }

    public void setImageResolution(String unit, double res) {
        if (unit == null || SRS.distUnitList.get(unit.toUpperCase()) == null) {
            throw new IllegalArgumentException("Invalid image resolution unit given.");
        }
        this.unit = unit.toUpperCase();
        this.resolution = res;
        log.finest("image resolution: " + res + ", unit: " + unit);
    }

    public String getImageResolutionUnit() {
        return this.unit;
    }

    public double getImageResolution() {
        return this.resolution;
    }

    public void setImageQuery(String _query) {
        if (_query == null) {
            this.query = "select grt." + this.mGeoRasterColumn + " from " + this.mBaseTable + " grt where grt." + this.mGeoRasterColumn + ".rasterid = ?";
            if (this.mRasterTable != null) {
                this.query = this.query + " and grt." + this.mGeoRasterColumn + ".rasterdatatable = ?";
            }
        } else {
            String userQuery = _query;
            log.finest("Before esapi canonicalizing: " + userQuery);
            this.query = ESAPI.encoder().canonicalize(userQuery, true);
            log.finest("After esapi canonicalizing: " + this.query);
            this.mRasterId = null;
        }
    }

    public String getImageQuery() {
        return this.query;
    }

    public void setAlpha(float a) {
        this.alpha = a;
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public String getThemeType() {
        return "GEORASTER";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getSpatialResolution(int pyramid, double rasterId, String rasterTable, Connection conn) {
        double[] res = null;
        if (this.sptResolution != null && this.lastRasterId != -1.0 && this.lastRdtTable != null && rasterId == this.lastRasterId && this.lastRdtTable.equalsIgnoreCase(rasterTable)) {
            res = new double[]{this.sptResolution[0] * Math.pow(2.0, pyramid), this.sptResolution[1] * Math.pow(2.0, pyramid)};
            log.finest("Res X: " + res[0] + "   Res Y: " + res[1] + "  Pyramidlevel: " + pyramid);
            return res;
        }
        String rdtcompl = "";
        if (rasterTable != null) {
            rdtcompl = " and a." + this.mGeoRasterColumn + ".rasterdatatable = ?";
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String ptstmt = "SELECT sdo_geor.getmodelcoordinate(a." + this.mGeoRasterColumn + ",0,sdo_number_array(?,?)) pt_geom " + "FROM " + this.mBaseTable + " a WHERE a." + this.mGeoRasterColumn + ".rasterid = ?" + rdtcompl;
        try {
            JSDOGeometry geom;
            stmt = conn.prepareStatement(ptstmt);
            stmt.setInt(1, 0);
            stmt.setInt(2, 0);
            stmt.setDouble(3, rasterId);
            if (rasterTable != null) {
                stmt.setString(4, rasterTable.toUpperCase());
            }
            rs = stmt.executeQuery();
            double[] pt00_coord = null;
            if (rs != null && rs.next()) {
                JSDOGeometry geom2 = JDBCUtil.loadGeometry(rs, 1, false);
                pt00_coord = geom2.getPoint();
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {
                    log.warning(re.getMessage());
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {
                    log.warning(re.getMessage());
                }
            }
            stmt = conn.prepareStatement(ptstmt);
            stmt.setInt(1, 0);
            stmt.setInt(2, 1);
            stmt.setDouble(3, rasterId);
            if (rasterTable != null) {
                stmt.setString(4, rasterTable.toUpperCase());
            }
            rs = stmt.executeQuery();
            double[] pt01_coord = null;
            if (rs != null && rs.next()) {
                JSDOGeometry geom3 = JDBCUtil.loadGeometry(rs, 1, false);
                pt01_coord = geom3.getPoint();
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {
                    // empty catch block
                }
            }
            stmt = conn.prepareStatement(ptstmt);
            stmt.setInt(1, 1);
            stmt.setInt(2, 0);
            stmt.setDouble(3, rasterId);
            if (rasterTable != null) {
                stmt.setString(4, rasterTable.toUpperCase());
            }
            rs = stmt.executeQuery();
            double[] pt10_coord = null;
            if (rs != null && rs.next()) {
                geom = JDBCUtil.loadGeometry(rs, 1, false);
                pt10_coord = geom.getPoint();
            }
            if (pt00_coord == null || pt01_coord == null || pt10_coord == null) {
                log.severe("Unable to calculate spatial resolution.");
                geom = null;
                return geom;
            }
            res = new double[2];
            this.sptResolution = new double[2];
            this.lastRasterId = rasterId;
            this.lastRdtTable = rasterTable;
            double d1 = pt01_coord[0] - pt00_coord[0];
            double d2 = pt01_coord[1] - pt00_coord[1];
            res[0] = Math.sqrt(d1 * d1 + d2 * d2);
            this.sptResolution[0] = res[0];
            res[0] = res[0] * Math.pow(2.0, pyramid);
            d1 = pt10_coord[0] - pt00_coord[0];
            d2 = pt10_coord[1] - pt00_coord[1];
            res[1] = Math.sqrt(d1 * d1 + d2 * d2);
            this.sptResolution[1] = res[1];
            res[1] = res[1] * Math.pow(2.0, pyramid);
            log.finest("Res X: " + res[0] + "   Res Y: " + res[1] + "  Pyramidlevel: " + pyramid);
            double[] dArray = res;
            return dArray;
        }
        catch (Exception ex) {
            log.severe("Unable to calculate spatial resolution: " + ex.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {
                    log.warning(re.getMessage());
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {
                    log.warning(re.getMessage());
                }
            }
        }
        this.sptResolution = null;
        this.lastRasterId = -1.0;
        this.lastRdtTable = null;
        return null;
    }

    public String getOriginalPyramidLevel() {
        return this.mRasterPyramid;
    }

    public void setOriginalPyramidLevel(String level) {
        this.mRasterPyramid = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getCellCoordinate(double x, double y, double rasterId, String rasterTable, int ptSRID, int pyrLevel, Connection conn) {
        int[] cellvalue = null;
        String SRid = "null";
        if (ptSRID > 0) {
            SRid = String.valueOf(ptSRID);
        }
        String cellquery = "SELECT sdo_geor.getCellCoordinate(grt." + this.mGeoRasterColumn + ",?,sdo_geometry(2001," + SRid + "," + "sdo_point_type(?,?,null), null,null)) coord " + "FROM " + this.mBaseTable + " grt WHERE grt." + this.mGeoRasterColumn + ".rasterid = ?";
        if (rasterTable != null) {
            cellquery = cellquery + " and grt." + this.mGeoRasterColumn + ".rasterdatatable = ?";
        }
        log.finest("getCellCoordinate query: " + cellquery);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(cellquery);
            stmt.setInt(1, pyrLevel);
            stmt.setDouble(2, x);
            stmt.setDouble(3, y);
            stmt.setDouble(4, rasterId);
            if (rasterTable != null) {
                stmt.setString(5, rasterTable.toUpperCase());
            }
            if ((rs = stmt.executeQuery()) != null && rs.next()) {
                Array ar = rs.getArray(1);
                cellvalue = new int[2];
                BigDecimal[] values = (BigDecimal[])ar.getArray();
                cellvalue[0] = values[0].intValue();
                cellvalue[1] = values[1].intValue();
                log.finest("Row:" + cellvalue[0] + " Column: " + cellvalue[1]);
                int[] nArray = cellvalue;
                return nArray;
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception in getCellCoordinate.", ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {
                    log.warning(re.getMessage());
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {
                    log.warning(re.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getModelCoordinate(int row, int column, double rasterId, String rasterTable, int pyrLevel, Connection conn) {
        double[] modelvalue = null;
        String modelquery = "SELECT sdo_geor.getModelCoordinate(grt." + this.mGeoRasterColumn + ",?,sdo_number_array(?,?)) coord " + "FROM " + this.mBaseTable + " grt WHERE grt." + this.mGeoRasterColumn + ".rasterid = ?";
        if (rasterTable != null) {
            modelquery = modelquery + " and grt." + this.mGeoRasterColumn + ".rasterdatatable = ?";
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(modelquery);
            stmt.setInt(1, pyrLevel);
            stmt.setInt(2, row);
            stmt.setInt(3, column);
            stmt.setDouble(4, rasterId);
            if (rasterTable != null) {
                stmt.setString(5, rasterTable.toUpperCase());
            }
            if ((rs = stmt.executeQuery()) != null && rs.next()) {
                JSDOGeometry geom = JDBCUtil.loadGeometry(rs, 1, false);
                modelvalue = new double[2];
                double[] dArray = modelvalue = geom.getPoint();
                return dArray;
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Exception in getModelCoordinate.", ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {
                    log.warning(re.getMessage());
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {
                    log.warning(re.getMessage());
                }
            }
        }
        return null;
    }

    public String getRasterId() {
        return this.mRasterId;
    }

    public String getRasterTable() {
        return this.mRasterTable;
    }

    public String getGeoRasterColumn() {
        return this.mGeoRasterColumn;
    }

    public JSDOGeometry getPolygonMask() {
        return this.polygonMask;
    }

    public void setPolygonMask(double[] coords, int maskSrid) {
        this.polygonMask = null;
        this.pmaskTable = null;
        this.pmaskGeomColumn = null;
        this.pmaskQCondition = null;
        this.pmaskJoinColumn = null;
        this.pmaskJoinGeorColumn = null;
        this.polygonMaskChanged();
        if (coords == null) {
            return;
        }
        this.polygonMask = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])coords, (int)2, (int)maskSrid));
    }

    public void setPolygonMask(JSDOGeometry geom) {
        this.polygonMask = geom;
        this.pmaskTable = null;
        this.pmaskGeomColumn = null;
        this.pmaskQCondition = null;
        this.pmaskJoinColumn = null;
        this.pmaskJoinGeorColumn = null;
        this.polygonMaskChanged();
    }

    @Override
    public String getXMLDefinition() {
        StringBuffer xmlDef = new StringBuffer(2048);
        xmlDef.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n<styling_rules");
        this.getCommonAttributes(xmlDef);
        xmlDef.append(this.getAttributes());
        xmlDef.append(">\n");
        if (this.mSRule != null && this.mSRule.getFeatureCond() != null) {
            xmlDef.append("  <rule" + PredGeomThemeDefinition.getRuleAttributes(this.mSRule) + ">\n");
            xmlDef.append(PredGeomThemeDefinition.getRuleFeatures(this.mSRule));
            xmlDef.append(PredGeomThemeDefinition.getRuleLabel(this.mSRule));
            xmlDef.append("  </rule>\n");
        }
        xmlDef.append("</styling_rules>");
        return xmlDef.toString();
    }

    public String getAttributes() {
        String imgAttr = "";
        if (this.mSRule == null || this.mSRule != null && this.mSRule.getFeatureCond() == null) {
            if (this.mRasterId != null) {
                imgAttr = imgAttr + " raster_id=\"" + this.mRasterId + "\"";
            }
            if (this.mRasterTable != null) {
                imgAttr = imgAttr + " raster_table=\"" + this.mRasterTable + "\"";
            }
        }
        if (this.mRasterPyramid != null) {
            imgAttr = imgAttr + " raster_pyramid=\"" + this.mRasterPyramid + "\"";
        }
        if (this.mBands != null) {
            imgAttr = imgAttr + " raster_bands=\"" + this.mBands + "\"";
        }
        if (this.polygonMask != null) {
            imgAttr = imgAttr + " polygon_mask=\"" + this.polygonMask + "\"";
        }
        return imgAttr;
    }

    void getCommonAttributes(StringBuffer xmlAttr) {
        String caching;
        String key;
        String themeType = this.getThemeType();
        if (themeType != null && themeType.trim().length() > 0) {
            xmlAttr.append(" theme_type=\"" + themeType + "\"");
        }
        if ((key = this.mKeyColumn) != null && key.trim().length() > 0) {
            xmlAttr.append(" key_column=\"" + key + "\"");
        }
        if ((caching = "normal") != null && caching.trim().length() > 0) {
            xmlAttr.append(" caching=\"" + caching + "\"");
        }
    }

    public void setImageProcess(String[] names, Hashtable parameters) {
        this.imageProcessNames = names;
        this.imageProcess = parameters;
    }

    public void setImageProcessNames(String[] names) {
        this.imageProcessNames = names;
    }

    public String[] getImageProcessNames() {
        return this.imageProcessNames;
    }

    public void setImageProcessParameters(Hashtable parameters) {
        this.imageProcess = parameters;
    }

    public Hashtable getImageProcessParameters() {
        return this.imageProcess;
    }

    public boolean addImageProcessOperation(String opName) {
        if (opName == null) {
            return false;
        }
        if (this.imageProcessNames == null) {
            this.imageProcessNames = new String[1];
            this.imageProcessNames[0] = opName;
        } else {
            int size = this.imageProcessNames.length;
            Vector<String> names = new Vector<String>();
            for (int i = 0; i < size; ++i) {
                names.add(this.imageProcessNames[i]);
            }
            if (names.contains(opName)) {
                return true;
            }
            names.add(opName);
            this.imageProcessNames = names.toArray(new String[names.size()]);
        }
        return true;
    }

    public boolean addImageProcessParameter(String opName, String param, String value) {
        Hashtable<String, String> params;
        if (opName == null || param == null || value == null) {
            return false;
        }
        if (this.imageProcess == null) {
            this.imageProcess = new Hashtable();
        }
        if ((params = (Hashtable<String, String>)this.imageProcess.get(opName)) == null) {
            params = new Hashtable<String, String>();
            this.imageProcess.put(opName, param);
        }
        params.put(param, value);
        this.addImageProcessOperation(opName);
        return true;
    }

    public Hashtable getImageProcessParameters(String opName) {
        if (opName == null) {
            return null;
        }
        if (this.imageProcess != null) {
            return (Hashtable)this.imageProcess.get(opName);
        }
        return null;
    }

    public void deleteAllImageProcessOperations() {
        this.imageProcessNames = null;
        this.imageProcess = null;
    }

    public boolean removeImageProcessOperation(String opName) {
        if (opName == null) {
            return false;
        }
        if (this.imageProcess != null) {
            this.imageProcess.remove(opName);
            if (this.imageProcess.size() == 0) {
                this.imageProcess = null;
            }
        }
        if (this.imageProcessNames != null) {
            int size = this.imageProcessNames.length;
            Vector<String> names = new Vector<String>();
            for (int i = 0; i < size; ++i) {
                names.add(this.imageProcessNames[i]);
            }
            if (!names.contains(opName)) {
                return true;
            }
            names.remove(opName);
            this.imageProcessNames = names.size() > 0 ? names.toArray(new String[names.size()]) : null;
        }
        return true;
    }

    public StylingRule getStylingRule() {
        return this.mSRule;
    }

    public void setStylingRule(StylingRule rule) {
        this.mSRule = rule;
    }

    public Hashtable getBitmapMasks() {
        return this.bitmapMasks;
    }

    public void setBitmapMasks(GeoRasterBitmapMask[] masks) {
        if (masks == null || masks.length == 0) {
            this.bitmapMasks = null;
            return;
        }
        this.bitmapMasks = new Hashtable();
        for (int i = 0; i < masks.length; ++i) {
            int rid = masks[i].getRasterId();
            String rdtname = masks[i].getRasterDataTableName();
            this.bitmapMasks.put("" + rid + ":" + rdtname.toUpperCase(), masks[i]);
        }
    }

    public GeoRasterBitmapMask getBitmapMask(String key) {
        if (this.bitmapMasks == null || key == null) {
            return null;
        }
        return (GeoRasterBitmapMask)this.bitmapMasks.get(key.toUpperCase());
    }

    @Override
    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo ti = new BasicThemeInfo();
        ti.setName(this.getName());
        ti.setBaseTable(this.getBaseTable());
        ti.setType("GEORASTER");
        ti.setKeyColumn(this.mKeyColumn);
        ti.setSrid(this.getSrid());
        ti.setSpatialColumn(this.getGeoRasterColumn());
        return ti;
    }

    @Override
    public String[] getRenderingStyles() {
        return null;
    }

    @Override
    public String[] getLabelingStyles() {
        return null;
    }

    public boolean isNODATATransparent() {
        return this.transpNoData;
    }

    public void setNODATATransparent(boolean transp) {
        this.transpNoData = transp;
    }

    public int getAlphaBand() {
        return this.alphaBand;
    }

    public void setAlphaBand(int band) {
        this.alphaBand = band < 0 ? -1 : band;
    }

    public void setPolygonMaskFromTable(String maskTable, String maskGeomColumn, String maskQCondition, String maskJoinColumn, String maskJoinGeorColumn) {
        if (maskTable == null || maskGeomColumn == null) {
            return;
        }
        this.pmaskTable = maskTable;
        this.pmaskGeomColumn = maskGeomColumn;
        this.pmaskQCondition = maskQCondition;
        if (maskQCondition != null && maskQCondition.trim().length() == 0) {
            this.pmaskQCondition = null;
        }
        this.pmaskJoinColumn = maskJoinColumn;
        this.pmaskJoinGeorColumn = maskJoinGeorColumn;
        if (maskJoinColumn == null || maskJoinGeorColumn == null) {
            this.pmaskJoinColumn = null;
            this.pmaskJoinGeorColumn = null;
        }
        this.polygonMask = null;
        this.polygonMaskChanged();
    }

    private void polygonMaskChanged() {
        if (this.mRasterId != null) {
            this.query = "select grt." + this.mGeoRasterColumn;
            if (this.pmaskJoinGeorColumn != null) {
                this.query = this.query + ", grt." + this.pmaskJoinGeorColumn;
            }
            this.query = this.query + " from " + this.mBaseTable + " grt where grt." + this.mGeoRasterColumn + ".rasterid = ?";
            if (this.mRasterTable != null) {
                this.query = this.query + " and grt." + this.mGeoRasterColumn + ".rasterdatatable = ?";
            }
        }
    }

    public String getPolygonMaskTable() {
        return this.pmaskTable;
    }

    public void setPolygonMaskTable(String table) {
        this.pmaskTable = table;
    }

    public String getPolygonMaskGeometryColumn() {
        return this.pmaskGeomColumn;
    }

    public void setPolygonMaskGeometryColumn(String column) {
        this.pmaskGeomColumn = column;
    }

    public String getPolygonMaskQueryCondition() {
        return this.pmaskQCondition;
    }

    public void setPolygonMaskQueryCondition(String cond) {
        this.pmaskQCondition = cond;
    }

    public String getPolygonMaskGeometryJoinColumn() {
        return this.pmaskJoinColumn;
    }

    public void setPolygonMaskGeometryJoinColumn(String column) {
        this.pmaskJoinColumn = column;
    }

    public String getPolygonMaskGeoRasterJoinColumn() {
        return this.pmaskJoinGeorColumn;
    }

    public void setPolygonMaskGeoRasterJoinColumn(String column) {
        this.pmaskJoinGeorColumn = column;
    }

    public boolean hasPolygonMaskJoinColumns() {
        return this.pmaskJoinColumn != null && this.pmaskJoinGeorColumn != null;
    }

    @Override
    public String[] getHighlightStyles() {
        return null;
    }

    @Override
    public String[] getLabelColumns() {
        return null;
    }

    @Override
    public Field[] getDistinctAttrColumns() {
        return null;
    }

    public String getReprojectionMode() {
        return this.reprojMode;
    }

    public void setReprojectionMode(String mode) {
        this.reprojMode = mode == null || mode.equalsIgnoreCase("BILINEAR") ? "BILINEAR" : (mode.equalsIgnoreCase("NN") ? "NN" : (mode.equalsIgnoreCase("CUBIC") ? "CUBIC" : (mode.equalsIgnoreCase("AVERAGE4") ? "AVERAGE4" : (mode.equalsIgnoreCase("AVERAGE16") ? "AVERAGE16" : "BILINEAR"))));
    }

    public boolean getFilterReprojectionResult() {
        return this.filterReprojResult;
    }

    public void setFilterReprojectionResult(boolean filter) {
        this.filterReprojResult = filter;
    }

    public String getRenderInterpolationHint() {
        return this.renderInterpolationHint;
    }

    public void setRenderInterpolationHint(String hint) {
        this.renderInterpolationHint = hint == null || hint.toUpperCase().equals(RENDER_INTERPOLATE_NEAREST_NEIGHBOR) ? RENDER_INTERPOLATE_NEAREST_NEIGHBOR : (hint.toUpperCase().equals(RENDER_INTERPOLATE_BILINEAR) ? RENDER_INTERPOLATE_BILINEAR : (hint.toUpperCase().equals(RENDER_INTERPOLATE_BICUBIC) ? RENDER_INTERPOLATE_BICUBIC : (hint.toUpperCase().equals(RENDER_INTERPOLATE_BICUBIC2) ? RENDER_INTERPOLATE_BICUBIC2 : RENDER_INTERPOLATE_NEAREST_NEIGHBOR)));
    }
}

