/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.util.Map;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SharedUtils;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.VectorThemeDefinition;
import oracle.sdovis.util.Util;
import org.owasp.esapi.ESAPI;

public class DynGeomThemeDefinition
extends VectorThemeDefinition {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected String mQuery = null;
    protected String mBaseTable = null;
    protected String mSpatialColumn = null;
    protected String mLabelColumn = null;
    protected String mFeatureStyleName = null;
    protected String mLabelStyleName = null;
    protected String mKeyColumn = null;
    private int mBindingVaraiblesNum = 0;
    protected boolean mPassThrough = false;
    protected String mXcolumn = null;
    protected String mYcolumn = null;
    boolean isHeatMapTheme = false;
    protected String labelAtextTable = null;
    protected String labelLeaderlineStyleName = null;

    public DynGeomThemeDefinition(String name, String dataSrc, String completeQuery, String spatialCol, int srid) {
        Map m;
        this.name = name;
        this.dataSource = dataSrc;
        if (completeQuery == null || completeQuery.length() == 0 || !Util.isQueryAllowed(completeQuery)) {
            throw new IllegalArgumentException("Illegal or null query string specified.");
        }
        String userQuery = completeQuery;
        log.finest("Before esapi canonicalizing: " + userQuery);
        this.mQuery = ESAPI.encoder().canonicalize(userQuery, true);
        log.finest("After esapi canonicalizing: " + this.mQuery);
        this.mSpatialColumn = spatialCol;
        this.srid = srid;
        if ((spatialCol == null || srid <= 0) && (m = Util.peekDynamicQuery(completeQuery, dataSrc, spatialCol)) != null) {
            String hasRecord;
            if (m.get("gc") != null) {
                this.mSpatialColumn = (String)m.get("gc");
            }
            if (m.get("srid") != null) {
                this.srid = Integer.parseInt((String)m.get("srid"));
            }
            if (srid == 0 && this.srid == 0 && (hasRecord = (String)m.get("hasrecord")) != null && hasRecord.equalsIgnoreCase("false")) {
                this.mPassThrough = true;
            }
        }
        this.is9i = ((AbstractDBDataSource)DSManager.get(dataSrc)).is9i();
        this.mBindingVaraiblesNum = SharedUtils.countBindingVariables(this.mQuery);
    }

    public DynGeomThemeDefinition() {
    }

    public String getQuery() {
        return this.mQuery;
    }

    public String getBaseTable() {
        return this.mBaseTable;
    }

    public String getSpatialColumn() {
        return this.mSpatialColumn;
    }

    public String getLabelColumn() {
        return this.mLabelColumn;
    }

    public String getFeatureStyleName() {
        return this.mFeatureStyleName;
    }

    public String getLabelStyleName() {
        return this.mLabelStyleName;
    }

    public boolean isPassthrough() {
        return this.mPassThrough;
    }

    public void setQuery(String v) {
        if (v == null || v.length() == 0 || !Util.isQueryAllowed(v)) {
            throw new IllegalArgumentException("Illegal or null query string specified.");
        }
        this.mQuery = v;
    }

    public void setBaseTable(String v) {
        this.mBaseTable = v;
    }

    public void setSpatialColumn(String v) {
        this.mSpatialColumn = v;
    }

    public void setLabelColumn(String v) {
        this.mLabelColumn = v;
    }

    public void setFeatureStyleName(String v) {
        this.mFeatureStyleName = v;
    }

    public void setLabelStyleName(String v) {
        this.mLabelStyleName = v;
    }

    public void setPassthrough(boolean v) {
        this.mPassThrough = v;
    }

    @Override
    public String getThemeType() {
        return "GEOM_DYNAMIC";
    }

    public void setKeyColumn(String keyCol) {
        this.mKeyColumn = keyCol;
    }

    @Override
    public String getKeyColumn() {
        return this.mKeyColumn;
    }

    @Override
    public String getXMLDefinition() {
        return "";
    }

    public int getBindingVariablesNumber() {
        return this.mBindingVaraiblesNum;
    }

    @Override
    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo ti = new BasicThemeInfo();
        ti.setName(this.getName());
        ti.setBaseTable(this.getBaseTable());
        ti.setType("GEOM_DYNAMIC");
        ti.setKeyColumn(this.getKeyColumn());
        ti.setSrid(this.getSrid());
        ti.setSpatialColumn(this.getSpatialColumn());
        return ti;
    }

    @Override
    public String[] getRenderingStyles() {
        if (this.mFeatureStyleName == null || this.mFeatureStyleName.trim().length() == 0) {
            return null;
        }
        String[] styleNames = new String[]{this.mFeatureStyleName.toUpperCase()};
        return styleNames;
    }

    @Override
    public String[] getLabelingStyles() {
        if (this.mLabelStyleName == null || this.mLabelStyleName.trim().length() == 0) {
            return null;
        }
        String[] styleNames = new String[]{this.mLabelStyleName.toUpperCase()};
        return styleNames;
    }

    public void setPointColumns(String xcolumn, String ycolumn) {
        this.mXcolumn = xcolumn;
        this.mYcolumn = ycolumn;
    }

    public String getPointXColumn() {
        return this.mXcolumn;
    }

    public String getPointYColumn() {
        return this.mYcolumn;
    }

    @Override
    public String[] getHighlightStyles() {
        return null;
    }

    @Override
    public String[] getLabelColumns() {
        String[] columns = null;
        if (this.mLabelColumn != null) {
            columns = new String[]{this.mLabelColumn};
        }
        return columns;
    }

    public String getLabelAnnoTextTable() {
        return this.labelAtextTable;
    }

    public void setLabelAnnoTextTable(String table) {
        this.labelAtextTable = table;
    }

    public String getLabelLeaderLineStyleName() {
        return this.labelLeaderlineStyleName;
    }

    public void setLabelLeaderLineStyleName(String style) {
        this.labelLeaderlineStyleName = style;
    }
}

