/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

class Grid
implements Comparable {
    private Rectangle2D.Double grid;
    private long index;
    private Area intersection;
    private double intersectionSize;
    private boolean contained;

    public Grid(long i, long numofdots, Area shape, Rectangle2D.Double square) {
        this.index = i;
        long root = (long)Math.sqrt(numofdots);
        double width = square.getWidth() / (double)root;
        double xPos = square.getX() + (double)(i % root) * width;
        double yPos = square.getY() + (double)(i / root) * width;
        this.grid = new Rectangle2D.Double(xPos, yPos, width, width);
        this.contained = shape.contains(this.grid);
        this.intersection = (Area)shape.clone();
        this.setIntersection(this.intersection);
        this.intersectionSize = this.getAreaSize(this.intersection, null);
    }

    private void setIntersection(Area shape) {
        shape.intersect(new Area(this.grid));
    }

    public Area getIntersection() {
        return this.intersection;
    }

    public Rectangle2D.Double getGrid() {
        return this.grid;
    }

    public boolean isContained() {
        return this.contained;
    }

    private double getAreaSize(Area area, AffineTransform at) {
        double size = 0.0;
        double[] coords = new double[6];
        double[] oldcoords = new double[2];
        PathIterator itor = area.getPathIterator(at);
        while (!itor.isDone()) {
            int type = itor.currentSegment(coords);
            switch (type) {
                case 0: {
                    oldcoords[0] = coords[0];
                    oldcoords[1] = coords[1];
                    break;
                }
                case 4: {
                    break;
                }
                case 1: {
                    size += (oldcoords[0] + coords[0]) * (coords[1] - oldcoords[1]);
                    oldcoords[0] = coords[0];
                    oldcoords[1] = coords[1];
                    break;
                }
                default: {
                    System.out.println("Error: cannot calculate area of polygon with curve/cubic edge");
                    System.exit(1);
                }
            }
            itor.next();
        }
        return (size /= 2.0) > 0.0 ? size : -1.0 * size;
    }

    public double getSize() {
        return this.getAreaSize(new Area(this.grid), null);
    }

    public double getWidth() {
        return this.grid.getWidth();
    }

    public double getX() {
        return this.grid.getX();
    }

    public double getY() {
        return this.grid.getY();
    }

    public double getIntersectionSize() {
        return this.intersectionSize;
    }

    public int compareTo(Object anothergrid) {
        double result = ((Grid)anothergrid).getIntersectionSize() - this.intersectionSize;
        if (result > 0.0) {
            return 1;
        }
        if (result == 0.0) {
            return 0;
        }
        return -1;
    }
}

