/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.style.TextStyleModifiers;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.ShapeUtil;

public class TextPath {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static final FontRenderContext frc = new FontRenderContext(null, true, false);
    static int MIN_GLYPH_WIDTH = 4;
    static int GROW_SIZE = 32;
    private double angleReject = 1.6;
    private double angleGlyphReject = 0.575;
    private double angleTolerance = 0.64;
    private float screenPercentPadding = 0.15f;
    private TextStyleModel bean;
    private TextStyleModifiers textmods = null;
    private Font font;
    private GlyphVector glyphVector;
    private int nGlyphs;
    private AffineTransform at = new AffineTransform();
    private AffineTransform glyphTransform = new AffineTransform();
    private double ascent;

    public TextPath(TextStyleModel m, TextStyleModifiers tmods) {
        this.bean = m;
        this.textmods = tmods;
        this.font = this.bean.getFont();
        Font f = this.bean.getFont();
        if (tmods != null) {
            f = this.font.deriveFont((float)tmods.getFontSize());
        }
        LineMetrics metrics = f.getLineMetrics("ljqLJQ", frc);
        this.ascent = metrics.getAscent();
    }

    public TextStyleModifiers getTextStyleModifiers() {
        return this.textmods;
    }

    public double getAscent() {
        return this.ascent;
    }

    public TextStyleModel getBean() {
        return this.bean;
    }

    public void setBean(TextStyleModel bn) {
        this.bean = bn;
    }

    public FontRenderContext getFrc() {
        return frc;
    }

    public Shape putTextOnPath(Graphics2D g2, Shape shp, String text, double textLen, RectArray crRects, Rectangle2D deviceWindow, boolean forcedLabeling, boolean labelOnlyOnce, boolean upsideDownLabels) {
        boolean foundPlace = false;
        GeneralPath gp = null;
        RectArray ncMBR = new RectArray(1);
        CandidateRuns[] crs = this.getCandidates(g2, shp, textLen, upsideDownLabels || forcedLabeling);
        block0: for (int i = 0; !(i >= crs.length || foundPlace && labelOnlyOnce); ++i) {
            Vector allRuns;
            CandidateRuns cr;
            block20: {
                cr = crs[i];
                if (cr.getSize() <= 1 || !forcedLabeling && cr.getLen() < textLen) continue;
                Vector runs = cr.getRuns();
                allRuns = new Vector();
                if (runs.size() != 0) {
                    Object lhint = this.bean.getLabelingHint(LabelingHints.KEY_LINE_HALIGN);
                    Collections.sort(runs);
                    if (lhint == null || lhint == LabelingHints.VALUE_LINE_HALIGN_CENTER) {
                        int run;
                        double midLen = cr.getLen() / 2.0;
                        double prevDif = Math.abs(midLen - ((StartingPoint)runs.elementAt(0)).getDistFromStart());
                        double thisDif = 0.0;
                        for (run = 1; runs.size() > run; ++run) {
                            double d;
                            thisDif = Math.abs(midLen - ((StartingPoint)runs.elementAt(run)).getDistFromStart());
                            if (!(d <= prevDif)) break;
                            prevDif = thisDif;
                        }
                        int leftIdx = --run;
                        int rightIdx = run;
                        while (true) {
                            double rightDist;
                            if (leftIdx < 0) {
                                while (rightIdx < runs.size()) {
                                    allRuns.add(runs.elementAt(rightIdx));
                                    ++rightIdx;
                                }
                                break block20;
                            }
                            if (rightIdx >= runs.size()) {
                                while (leftIdx >= 0) {
                                    allRuns.add(runs.elementAt(leftIdx));
                                    --leftIdx;
                                }
                                break block20;
                            }
                            if (leftIdx == rightIdx) {
                                allRuns.add(runs.elementAt(leftIdx));
                                --leftIdx;
                                ++rightIdx;
                                continue;
                            }
                            double leftDist = Math.abs(midLen - ((StartingPoint)runs.elementAt(leftIdx)).getDistFromStart());
                            if (leftDist <= (rightDist = Math.abs(midLen - ((StartingPoint)runs.elementAt(rightIdx)).getDistFromStart()))) {
                                allRuns.add(runs.elementAt(leftIdx));
                                --leftIdx;
                                continue;
                            }
                            allRuns.add(runs.elementAt(rightIdx));
                            ++rightIdx;
                        }
                    }
                    if (lhint == LabelingHints.VALUE_LINE_HALIGN_END) {
                        allRuns = runs;
                        Collections.reverse(allRuns);
                    } else {
                        allRuns = runs;
                    }
                }
            }
            double prevRunDist = -1.0;
            for (int j = 0; j < allRuns.size(); ++j) {
                StartingPoint sp = (StartingPoint)allRuns.elementAt(j);
                if (sp.getDistFromStart() == prevRunDist) continue;
                prevRunDist = sp.getDistFromStart();
                sp.setDirection(sp.calculateDirection(cr.getX(), cr.getY(), textLen, cr.getSize()));
                Shape s = this.processStartPoint(cr, sp, text, crRects, j == allRuns.size() - 1 && forcedLabeling, upsideDownLabels, ncMBR, deviceWindow, g2);
                if (s == null) continue;
                if (gp == null) {
                    gp = new GeneralPath();
                }
                gp.append(s, false);
                foundPlace = true;
                Rectangle2D tr = s.getBounds2D();
                double ncArea = deviceWindow.getHeight() * deviceWindow.getWidth() * (double)this.screenPercentPadding;
                double hwRatio = tr.getHeight() / tr.getWidth();
                double ncHeight = Math.sqrt(ncArea * hwRatio);
                double tH = Math.max(ncHeight, tr.getHeight());
                double tW = tH / hwRatio;
                Rectangle2D.Double nr = new Rectangle2D.Double(tr.getCenterX() - tW / 2.0, tr.getY() - tH / 2.0, tW, tH);
                ncMBR.insert(nr);
                if (labelOnlyOnce) break block0;
            }
        }
        if (foundPlace || !forcedLabeling) {
            return gp;
        }
        Rectangle2D mbr = shp.getBounds2D();
        int cx = (int)mbr.getCenterX();
        int cy = (int)mbr.getCenterY();
        double[] endPts = ShapeUtil.getEndPoints(shp);
        double angle = 0.0;
        if (endPts != null) {
            if (!upsideDownLabels && endPts[2] < endPts[0]) {
                double x = endPts[0];
                double y = endPts[1];
                endPts[0] = endPts[2];
                endPts[1] = endPts[3];
                endPts[2] = x;
                endPts[3] = y;
            }
            angle = Math.atan2(endPts[3] - endPts[1], endPts[2] - endPts[0]);
        }
        Font f = this.font;
        if (this.font != null && this.textmods != null) {
            f = this.font.deriveFont((float)this.textmods.getFontSize());
        }
        GlyphVectorInfo gvinfo = new GlyphVectorInfo();
        gvinfo.txt = text;
        this.glyphVector = f.createGlyphVector(frc, text);
        this.glyphVector.performDefaultLayout();
        gvinfo.visualBounds = this.glyphVector.getVisualBounds();
        gvinfo.avgGW = gvinfo.visualBounds.getWidth() / (double)this.glyphVector.getNumGlyphs();
        gvinfo.visualCenterY = gvinfo.visualBounds.getCenterY();
        Point2D np = this.glyphVector.getGlyphPosition(0);
        gvinfo.ngx = np.getX();
        gvinfo.ngy = np.getY();
        Object hint = this.bean.getLabelingHint(LabelingHints.KEY_LINE_VALIGN);
        if (hint == null) {
            hint = LabelingHints.VALUE_LINE_VALIGN_BASELINE;
        }
        double[] offset = this.getGlyphOffset(gvinfo, 0.0, hint, false);
        return StyleText.getLayout(g2, text, cx, cy, LabelingHints.VALUE_OPOINT_HALIGN_CENTER, angle, (int)offset[1], this.bean, this.textmods);
    }

    private CandidateRuns[] getCandidates(Graphics2D g2, Shape shp, double textLen, boolean upsideDownLabels) {
        Vector<CandidateRuns> v = null;
        PathIterator pi = shp.getPathIterator(null);
        double[] coord = new double[6];
        double mx = 0.0;
        double my = 0.0;
        double x = -1.0;
        double y = -1.0;
        boolean direction = true;
        float[] linePercents = new float[]{0.0f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.0f};
        g2.setColor(g2.getColor().darker());
        CandidateRuns cr = new CandidateRuns();
        while (!pi.isDone()) {
            switch (pi.currentSegment(coord)) {
                case 0: {
                    mx = coord[0];
                    my = coord[1];
                    if (cr.getSize() == 0) {
                        cr.append(mx, my, textLen);
                        break;
                    }
                    if (mx == x && my == y) break;
                    cr.findPercentRuns(textLen, linePercents);
                    if (v == null) {
                        v = new Vector<CandidateRuns>(1);
                    }
                    v.add(cr);
                    cr = new CandidateRuns();
                    cr.append(mx, my, textLen);
                    break;
                }
                case 1: {
                    x = coord[0];
                    y = coord[1];
                    if (cr.getSize() > 1) {
                        double by;
                        double bx;
                        double ay;
                        double prevX = cr.getX()[cr.getSize() - 1];
                        double prevY = cr.getY()[cr.getSize() - 1];
                        double ax = prevX - cr.getX()[cr.getSize() - 2];
                        double angle = this.angleDifference(ax, ay = prevY - cr.getY()[cr.getSize() - 2], bx = x - prevX, by = y - prevY);
                        if (angle > this.angleReject || !upsideDownLabels && direction != x >= prevX && angle > this.angleTolerance) {
                            cr.findPercentRuns(textLen, linePercents);
                            if (v == null) {
                                v = new Vector(1);
                            }
                            v.add(cr);
                            cr = new CandidateRuns();
                            direction = x >= prevX;
                            cr.append(prevX, prevY, textLen);
                        }
                        cr.append(x, y, textLen);
                        break;
                    }
                    if (cr.getSize() == 1) {
                        direction = x >= cr.getX()[0];
                        cr.append(x, y, textLen);
                        break;
                    }
                    cr.append(x, y, textLen);
                }
            }
            pi.next();
        }
        cr.findPercentRuns(textLen, linePercents);
        if (v == null) {
            return new CandidateRuns[]{cr};
        }
        v.add(cr);
        return v.toArray(new CandidateRuns[v.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape processStartPoint(CandidateRuns cr, StartingPoint sp, String text, RectArray crRects, boolean forcedLabeling, boolean upsideDownLabels, RectArray ncMBR, Rectangle2D deviceWindow, Graphics2D g) {
        Shape[] bgGaps = new Shape[text.length() - 1];
        GlyphCorners prevBGCorners = null;
        int index = sp.getIndex();
        boolean crDirection = sp.getDirection();
        double[] x = cr.getX();
        double[] y = cr.getY();
        boolean upsideDown = !crDirection;
        Object vhint = null;
        if (upsideDown && this.bean.isSmartPathFollowing() && (vhint = this.bean.getLabelingHint(LabelingHints.KEY_LINE_VALIGN)) != null) {
            if (vhint == LabelingHints.VALUE_LINE_VALIGN_BOTTOM) {
                this.bean.setLabelingHint(LabelingHints.KEY_LINE_VALIGN, LabelingHints.VALUE_LINE_VALIGN_TOP);
            } else if (vhint == LabelingHints.VALUE_LINE_VALIGN_TOP) {
                this.bean.setLabelingHint(LabelingHints.KEY_LINE_VALIGN, LabelingHints.VALUE_LINE_VALIGN_BOTTOM);
            }
        }
        try {
            Color backColor;
            Font f = this.font;
            if (this.font != null && this.textmods != null) {
                f = this.font.deriveFont(this.textmods.getFontSize());
            }
            this.glyphVector = f.createGlyphVector(frc, text);
            this.glyphVector.performDefaultLayout();
            this.nGlyphs = this.glyphVector.getNumGlyphs();
            GlyphVectorInfo gvinfo = new GlyphVectorInfo();
            gvinfo.ngi = upsideDown ? this.nGlyphs - 1 : 0;
            gvinfo.txt = text;
            gvinfo.visualBounds = this.glyphVector.getVisualBounds();
            gvinfo.visualCenterY = gvinfo.visualBounds.getCenterY();
            SegmentCtl ctl = new SegmentCtl();
            ctl.sx = sp.getX();
            ctl.sy = sp.getY();
            double prevVecX = 0.0;
            double prevVecY = 0.0;
            block10: for (int i = index; i < cr.size; ++i) {
                block48: {
                    double targetY;
                    double targetX;
                    block45: {
                        block46: {
                            Point2D pt;
                            double segLength;
                            block47: {
                                ctl.ex = x[i];
                                ctl.ey = y[i];
                                segLength = Point2D.distance(ctl.sx, ctl.sy, ctl.ex, ctl.ey);
                                targetX = ctl.sx;
                                targetY = ctl.sy;
                                if ((upsideDown || gvinfo.ngi == 0) && (!upsideDown || gvinfo.ngi == this.nGlyphs - 1)) break block45;
                                pt = this.getRealStartPoint(ctl, gvinfo);
                                if (pt == null) break block46;
                                if (!(pt.distance(ctl.ex, ctl.ey) <= segLength) || !(pt.distance(ctl.sx, ctl.sy) <= segLength)) break block47;
                                targetX = pt.getX();
                                targetY = pt.getY();
                                break block45;
                            }
                            if (!(pt.distance(ctl.ex, ctl.ey) > segLength)) break block48;
                            targetX = ctl.sx;
                            targetY = ctl.sy;
                            break block45;
                        }
                        Shape shape = null;
                        return shape;
                    }
                    double rotationAngle = 0.0;
                    double targetCX = 0.0;
                    double targetCY = 0.0;
                    double dx = 0.0;
                    double dy = 0.0;
                    boolean forcedFit = false;
                    int nidx = -1;
                    do {
                        Rectangle2D r2d = this.glyphVector.getGlyphLogicalBounds(gvinfo.ngi).getBounds2D();
                        double ngw = r2d.getWidth();
                        if (!forcedFit) {
                            nidx = -1;
                            for (int j = i; j < cr.size; ++j) {
                                if (!(Point2D.distance(targetX, targetY, x[j], y[j]) >= ngw)) continue;
                                nidx = j;
                                break;
                            }
                            if (nidx != -1) {
                                double angleDif;
                                double nsx = x[nidx - 1];
                                double nsy = y[nidx - 1];
                                double nex = x[nidx];
                                double ney = y[nidx];
                                double nlen = Point2D.distance(nsx, nsy, nex, ney);
                                double ndx = (nex - nsx) / nlen;
                                double ndy = (ney - nsy) / nlen;
                                double t = ndx * (targetX - nex) + ndy * (targetY - ney);
                                double lec = Point2D.distance(t * ndx + nex, t * ndy + ney, targetX, targetY);
                                double dt = Math.sqrt(ngw * ngw - lec * lec);
                                double rx = (t + dt) * ndx + nex;
                                double ry = (t + dt) * ndy + ney;
                                dx = (rx - targetX) / ngw;
                                dy = (ry - targetY) / ngw;
                                targetCX = targetX + ngw * 0.5 * dx;
                                targetCY = targetY + ngw * 0.5 * dy;
                                rotationAngle = Math.atan2(ry - targetY, rx - targetX);
                                if (!forcedLabeling && (upsideDown && gvinfo.ngi != this.nGlyphs - 1 || !upsideDown && gvinfo.ngi != 0) && (angleDif = this.angleDifference(prevVecX, prevVecY, ngw * dx, ngw * dy)) > this.angleGlyphReject) {
                                    Shape shape = null;
                                    return shape;
                                }
                            } else if (forcedLabeling || upsideDown && gvinfo.ngi == 0 || !upsideDown && gvinfo.ngi == this.nGlyphs - 1 || upsideDown && (double)(gvinfo.ngi + 1) / (double)this.nGlyphs <= 0.14 || !upsideDown && (double)(this.nGlyphs - gvinfo.ngi) / (double)this.nGlyphs <= 0.14) {
                                double nlen = Point2D.distance(targetX, targetY, x[cr.size - 1], y[cr.size - 1]);
                                dx = (x[cr.size - 1] - targetX) / nlen;
                                dy = (y[cr.size - 1] - targetY) / nlen;
                                targetCX = targetX + ngw * 0.5 * dx;
                                targetCY = targetY + ngw * 0.5 * dy;
                                rotationAngle = Math.atan2(y[cr.size - 1] - targetY, x[cr.size - 1] - targetX);
                                forcedFit = true;
                            } else {
                                Shape nlen = null;
                                return nlen;
                            }
                        }
                        prevVecX = ngw * dx;
                        prevVecY = ngw * dy;
                        Object hint = this.bean.getLabelingHint(LabelingHints.KEY_LINE_VALIGN);
                        if (hint == null) {
                            hint = LabelingHints.VALUE_LINE_VALIGN_BASELINE;
                        }
                        double[] offset = this.getGlyphOffset(gvinfo, rotationAngle, hint, upsideDown);
                        double gXOffset = offset[0];
                        double gYOffset = offset[1];
                        ctl.previousAngle = rotationAngle;
                        Shape glyph = this.glyphVector.getGlyphOutline(gvinfo.ngi);
                        Point2D np = this.glyphVector.getGlyphPosition(gvinfo.ngi);
                        gvinfo.ngx = np.getX();
                        gvinfo.ngy = np.getY();
                        double gcx = gvinfo.ngx + ngw / 2.0;
                        double gcy = gvinfo.visualCenterY;
                        this.glyphTransform.setToIdentity();
                        this.glyphTransform.rotate(upsideDown ? rotationAngle + Math.PI : rotationAngle, targetCX + gXOffset, targetCY + gYOffset);
                        this.glyphTransform.translate(targetCX + gXOffset - gcx, targetCY + gYOffset - gcy);
                        Point2D[] originalCorners = new Point2D[]{new Point2D.Double(r2d.getX(), r2d.getY()), new Point2D.Double(r2d.getX() + r2d.getWidth(), r2d.getY()), new Point2D.Double(r2d.getX() + r2d.getWidth(), r2d.getY() + r2d.getHeight()), new Point2D.Double(r2d.getX(), r2d.getY() + r2d.getHeight())};
                        Point2D[] transformedCorners = new Point2D[4];
                        for (int p = 0; p < 4; ++p) {
                            transformedCorners[p] = new Point2D.Double(0.0, 0.0);
                            this.glyphTransform.transform(originalCorners[p], transformedCorners[p]);
                        }
                        ctl.setCornersPoints(transformedCorners);
                        if (this.bean.getBackground() != null) {
                            GlyphCorners[] gc = new GlyphCorners[2];
                            if (this.bean.haloEnabled()) {
                                float hwidth = this.bean.getHaloWidth();
                                if (this.textmods != null) {
                                    hwidth = this.textmods.getHaloWidth();
                                }
                                double shpx = r2d.getX() - (double)hwidth / 2.0;
                                double shpy = r2d.getY() - (double)hwidth / 2.0;
                                double shpw = r2d.getWidth() + (double)hwidth;
                                double shph = r2d.getHeight() + (double)hwidth;
                                Point2D[] bgHaloCorners = new Point2D[]{new Point2D.Double(shpx, shpy), new Point2D.Double(shpx + shpw, shpy), new Point2D.Double(shpx + shpw, shpy + shph), new Point2D.Double(shpx, shpy + shph)};
                                Point2D[] tCorners = new Point2D[4];
                                for (int p = 0; p < 4; ++p) {
                                    tCorners[p] = new Point2D.Double(0.0, 0.0);
                                    this.glyphTransform.transform(bgHaloCorners[p], tCorners[p]);
                                }
                                GlyphCorners gcrn = new GlyphCorners();
                                gcrn.setCornersPoints(tCorners);
                                if (prevBGCorners != null) {
                                    if (upsideDown) {
                                        gc[0] = gcrn;
                                        gc[1] = prevBGCorners;
                                    } else {
                                        gc[0] = prevBGCorners;
                                        gc[1] = gcrn;
                                    }
                                }
                                prevBGCorners = gcrn;
                            } else if (ctl.previousCorners2 != null) {
                                if (upsideDown) {
                                    gc[0] = ctl.previousCorners;
                                    gc[1] = ctl.previousCorners2;
                                } else {
                                    gc[0] = ctl.previousCorners2;
                                    gc[1] = ctl.previousCorners;
                                }
                            }
                            if (gc[0] != null && gc[1] != null) {
                                GeneralPath bgGap = new GeneralPath();
                                bgGap.moveTo(gc[0].getCorners()[0].getX(), gc[0].getCorners()[0].getY());
                                bgGap.lineTo(gc[0].getCorners()[1].getX(), gc[0].getCorners()[1].getY());
                                bgGap.lineTo(gc[1].getCorners()[0].getX(), gc[1].getCorners()[0].getY());
                                bgGap.lineTo(gc[1].getCorners()[1].getX(), gc[1].getCorners()[1].getY());
                                bgGap.lineTo(gc[1].getCorners()[2].getX(), gc[1].getCorners()[2].getY());
                                bgGap.lineTo(gc[1].getCorners()[3].getX(), gc[1].getCorners()[3].getY());
                                bgGap.lineTo(gc[0].getCorners()[2].getX(), gc[0].getCorners()[2].getY());
                                bgGap.lineTo(gc[0].getCorners()[3].getX(), gc[0].getCorners()[3].getY());
                                bgGap.closePath();
                                bgGaps[gvinfo.ngi + (upsideDown ? 0 : -1)] = bgGap;
                            }
                        }
                        glyph = this.glyphTransform.createTransformedShape(glyph);
                        r2d = glyph.getBounds2D();
                        if (crRects != null && !forcedLabeling && crRects.conflicts(r2d) || ncMBR.conflicts(r2d)) {
                            Shape gc = null;
                            return gc;
                        }
                        ctl.mbrs.addElement(r2d);
                        ctl.s.append(glyph, false);
                        gvinfo.ngi = gvinfo.ngi + (upsideDown ? -1 : 1);
                        if (upsideDown && gvinfo.ngi < 0 || !upsideDown && gvinfo.ngi >= this.nGlyphs) break block10;
                        double advance = upsideDown ? (double)this.glyphVector.getGlyphMetrics(gvinfo.ngi).getAdvance() + ngw - this.glyphVector.getGlyphLogicalBounds(gvinfo.ngi).getBounds2D().getWidth() : (double)this.glyphVector.getGlyphMetrics(gvinfo.ngi - 1).getAdvance();
                        targetX += advance * dx;
                        targetY += advance * dy;
                    } while (forcedFit || nidx == i);
                    if (nidx > i + 1) {
                        ctl.ex = x[nidx - 1];
                        ctl.ey = y[nidx - 1];
                        i = nidx - 1;
                    }
                }
                ctl.sx = ctl.ex;
                ctl.sy = ctl.ey;
            }
            if (upsideDown && gvinfo.ngi >= 0 || !upsideDown && gvinfo.ngi < this.nGlyphs || ctl.abort || !deviceWindow.contains(ctl.s.getBounds2D())) {
                Shape i = null;
                return i;
            }
            if (crRects != null) {
                crRects.addAll(ctl.mbrs);
            }
            if ((backColor = this.bean.getBackground()) != null) {
                for (int i = 0; i < bgGaps.length; ++i) {
                    g.setPaint(backColor);
                    g.fill(bgGaps[i]);
                }
            }
            GeneralPath generalPath = ctl.s;
            return generalPath;
        }
        catch (Exception e) {
            log.log(Level.INFO, e.getMessage(), e);
            Shape shape = null;
            return shape;
        }
        finally {
            if (upsideDown && vhint != null && this.bean.isSmartPathFollowing()) {
                this.bean.setLabelingHint(LabelingHints.KEY_LINE_VALIGN, vhint);
            }
        }
    }

    private Point2D getRealStartPoint(SegmentCtl ctl, GlyphVectorInfo gvinfo) {
        int i;
        int nps = ctl.previousCorners2 == null ? 4 : 8;
        Point2D[] prjpts = new Point2D[nps];
        for (int i2 = 0; i2 < nps; ++i2) {
            prjpts[i2] = new Point2D.Double(0.0, 0.0);
        }
        Point2D[] corners = new Point2D[nps];
        for (i = 0; i < 4; ++i) {
            corners[i] = ctl.previousCorners.getCorners()[i];
        }
        if (nps > 4) {
            for (i = 4; i < 8; ++i) {
                corners[i] = ctl.previousCorners2.getCorners()[i - 4];
            }
        }
        for (i = 0; i < nps; ++i) {
            Point2D pt = corners[i];
            ShapeUtil.projection(pt.getX(), pt.getY(), ctl.sx, ctl.sy, ctl.ex, ctl.ey, prjpts[i]);
        }
        double maxDist = Double.NEGATIVE_INFINITY;
        double segLen = Point2D.distance(ctl.sx, ctl.sy, ctl.ex, ctl.ey);
        int idx = -1;
        for (int i3 = 0; i3 < nps; ++i3) {
            double dE;
            double dS = Point2D.distance(prjpts[i3].getX(), prjpts[i3].getY(), ctl.sx, ctl.sy);
            if (dS < (dE = Point2D.distance(prjpts[i3].getX(), prjpts[i3].getY(), ctl.ex, ctl.ey)) && dE >= segLen) {
                dS *= -1.0;
            }
            if (!(dS > maxDist)) continue;
            maxDist = dS;
            idx = i3;
        }
        return prjpts[idx];
    }

    private double[] getGlyphOffset(GlyphVectorInfo gvinfo, double rotationAngle, Object hint, boolean upsideDown) {
        double gXOffset = 0.0;
        double gYOffset = 0.0;
        if (hint == LabelingHints.VALUE_LINE_VALIGN_MIDDLE) {
            gXOffset = 0.0;
            gYOffset = 0.0;
        } else if (hint == LabelingHints.VALUE_LINE_VALIGN_BASELINE) {
            double offset = gvinfo.visualCenterY - gvinfo.ngy;
            if (upsideDown) {
                offset *= -1.0;
            }
            gXOffset = -offset * Math.sin(rotationAngle);
            gYOffset = offset * Math.cos(rotationAngle);
        } else if (hint == LabelingHints.VALUE_LINE_VALIGN_BOTTOM) {
            double offset = gvinfo.visualBounds.getHeight() / 2.0 + 1.0;
            if (upsideDown) {
                offset *= -1.0;
            }
            gXOffset = offset * Math.sin(rotationAngle);
            gYOffset = -offset * Math.cos(rotationAngle);
        } else if (hint == LabelingHints.VALUE_LINE_VALIGN_TOP) {
            double offset = gvinfo.visualBounds.getHeight() / 2.0 + 1.0;
            if (upsideDown) {
                offset *= -1.0;
            }
            gXOffset = -offset * Math.sin(rotationAngle);
            gYOffset = offset * Math.cos(rotationAngle);
        }
        return new double[]{gXOffset, gYOffset};
    }

    private double angleDifference(double ax, double ay, double bx, double by) {
        return Math.acos((ax * bx + ay * by) / (Point2D.distance(0.0, 0.0, ax, ay) * Point2D.distance(0.0, 0.0, bx, by)));
    }

    public int getGROW_SIZE() {
        return GROW_SIZE;
    }

    class CandidateRuns {
        private double[] x;
        private double[] y;
        private Vector runs = new Vector();
        private int size = 0;
        private double len = 0.0;

        public CandidateRuns() {
        }

        public CandidateRuns(int numPoints) {
            this();
            this.x = new double[numPoints];
            this.y = new double[numPoints];
        }

        public void append(double _x, double _y, double textLen) {
            if (this.size >= 1) {
                double dist = Point2D.distance(this.x[this.size - 1], this.y[this.size - 1], _x, _y);
                if (dist > textLen) {
                    this.len += dist;
                    int n = (int)(dist / textLen);
                    double offset = (dist - textLen * (double)n) / (double)(n + 1);
                    double x1 = this.x[this.size - 1];
                    double y1 = this.y[this.size - 1];
                    double dx = (_x - this.x[this.size - 1]) / dist;
                    double dy = (_y - this.y[this.size - 1]) / dist;
                    this.ensureCapacity(this.size + n);
                    for (int i = 0; i < n; ++i) {
                        double mx = x1 + dx * ((double)(i + 1) * offset + (double)i * textLen);
                        double my = y1 + dy * ((double)(i + 1) * offset + (double)i * textLen);
                        this.runs.add(new StartingPoint(mx, my, this.size, this.len - dist + ((double)(i + 1) * offset + (double)i * textLen) + textLen / 2.0));
                    }
                } else {
                    this.len += dist;
                }
            } else {
                this.len = 0.0;
            }
            this.ensureCapacity(this.size + 1);
            this.x[this.size] = _x;
            this.y[this.size++] = _y;
        }

        public double calculateLength() {
            if (this.size == 0) {
                return 0.0;
            }
            this.len = 0.0;
            double x1 = this.x[0];
            double y1 = this.y[0];
            double x2 = 0.0;
            double y2 = 0.0;
            for (int i = 1; i < this.size; ++i) {
                x2 = this.x[i];
                y2 = this.y[i];
                this.len += Point2D.distance(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
            }
            return this.len;
        }

        public void ensureCapacity(int n) {
            if (this.x != null && this.x.length > n) {
                return;
            }
            double[] t = new double[n + GROW_SIZE];
            if (this.x != null) {
                System.arraycopy(this.x, 0, t, 0, this.size);
            }
            this.x = t;
            t = new double[n + GROW_SIZE];
            if (this.y != null) {
                System.arraycopy(this.y, 0, t, 0, this.size);
            }
            this.y = t;
        }

        public void findPercentRuns(double textLen, float[] linePercents) {
            if (this.x == null || this.y == null) {
                return;
            }
            if (this.len <= 0.0) {
                this.calculateLength();
            }
            if (this.len < textLen) {
                return;
            }
            double[] offsets = new double[linePercents.length];
            for (int i = 0; i < linePercents.length; ++i) {
                offsets[i] = Math.min(this.len - textLen, Math.max(0.0, this.len * (double)linePercents[i] - textLen / 2.0));
            }
            double alen = 0.0;
            double dist = 0.0;
            double x1 = this.x[0];
            double y1 = this.y[0];
            double x2 = 0.0;
            double y2 = 0.0;
            int percIdx = 0;
            for (int i = 1; i < this.size; ++i) {
                x2 = this.x[i];
                y2 = this.y[i];
                dist = Point2D.distance(x1, y1, x2, y2);
                alen += dist;
                for (int j = percIdx; j < linePercents.length; ++j) {
                    double off = offsets[j];
                    if (alen > off) {
                        double dx = (x2 - x1) / dist;
                        double dy = (y2 - y1) / dist;
                        double mx = x1 + dx * (off - (alen - dist));
                        double my = y1 + dy * (off - (alen - dist));
                        this.runs.add(new StartingPoint(mx, my, i, off + textLen / 2.0));
                        ++percIdx;
                        continue;
                    }
                    if (alen != off) break;
                    this.runs.add(new StartingPoint(x2, y2, i + 1, off + textLen / 2.0));
                    ++percIdx;
                }
                if (percIdx >= linePercents.length) break;
                x1 = x2;
                y1 = y2;
            }
        }

        public void setX(double[] x) {
            this.x = x;
        }

        public double[] getX() {
            return this.x;
        }

        public void setY(double[] y) {
            this.y = y;
        }

        public double[] getY() {
            return this.y;
        }

        public void setRuns(Vector runs) {
            this.runs = runs;
        }

        public Vector getRuns() {
            return this.runs;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public void setLen(double len) {
            this.len = len;
        }

        public double getLen() {
            return this.len;
        }
    }

    class StartingPoint
    implements Comparable {
        private double x;
        private double y;
        private int index = -1;
        private double distFromStart = 0.0;
        private boolean direction = true;

        public StartingPoint(double x, double y, int index, double distFromStart) {
            this.x = x;
            this.y = y;
            this.index = index;
            this.distFromStart = distFromStart;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void setDistFromStart(double distFromStart) {
            this.distFromStart = distFromStart;
        }

        public double getDistFromStart() {
            return this.distFromStart;
        }

        public void setX(double x) {
            this.x = x;
        }

        public double getX() {
            return this.x;
        }

        public void setY(double y) {
            this.y = y;
        }

        public double getY() {
            return this.y;
        }

        public void setDirection(boolean direction) {
            this.direction = direction;
        }

        public boolean getDirection() {
            return this.direction;
        }

        public boolean calculateDirection(double[] x, double[] y, double textLen, int size) {
            double directionRatio = 0.0;
            double alen = 0.0;
            double x1 = this.getX();
            double y1 = this.getY();
            for (int i = this.getIndex(); i < size; ++i) {
                double x2 = x[i];
                double y2 = y[i];
                double dist = Point2D.distance(x1, y1, x2, y2);
                if ((alen += dist) > textLen) {
                    double dx = (x2 - x1) / dist;
                    double dy = (y2 - y1) / dist;
                    double mx = x1 + dx * (textLen - (alen - dist));
                    double my = y1 + dy * (textLen - (alen - dist));
                    directionRatio += (double)(mx < x1 ? -1 : 1) * Point2D.distance(x1, y1, mx, my);
                    break;
                }
                if (alen == textLen) {
                    directionRatio += (double)(x2 < x1 ? -1 : 1) * Point2D.distance(x1, y1, x2, y2);
                    break;
                }
                directionRatio += (double)(x2 < x1 ? -1 : 1) * Point2D.distance(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
            }
            return directionRatio > 0.0;
        }

        public int compareTo(Object o) {
            if (((StartingPoint)o).getDistFromStart() < this.getDistFromStart()) {
                return 1;
            }
            if (((StartingPoint)o).getDistFromStart() > this.getDistFromStart()) {
                return -1;
            }
            return 0;
        }
    }

    class SegmentCtl {
        boolean abort = false;
        boolean fits = true;
        GeneralPath s = new GeneralPath();
        Vector mbrs = new Vector(24);
        int numSharpTurns;
        double sx;
        double sy;
        double ex;
        double ey;
        GlyphCorners previousCorners = null;
        GlyphCorners previousCorners2 = null;
        double previousAngle;

        SegmentCtl() {
        }

        public void setCorners(Shape glyph, AffineTransform glyphTransform) {
            if (this.previousCorners != null) {
                this.previousCorners2 = (GlyphCorners)this.previousCorners.clone();
            }
            if (this.previousCorners == null) {
                this.previousCorners = new GlyphCorners();
            }
            this.previousCorners.setCorners(glyph, glyphTransform);
        }

        public void setCornersPoints(Point2D[] pts) {
            if (this.previousCorners != null) {
                this.previousCorners2 = (GlyphCorners)this.previousCorners.clone();
            }
            if (this.previousCorners == null) {
                this.previousCorners = new GlyphCorners();
            }
            this.previousCorners.setCornersPoints(pts);
        }
    }

    class GlyphCorners {
        Point2D[] pts = new Point2D[4];

        public GlyphCorners() {
            for (int i = 0; i < 4; ++i) {
                this.pts[i] = new Point2D.Double(0.0, 0.0);
            }
        }

        public Object clone() {
            GlyphCorners obj = new GlyphCorners();
            for (int i = 0; i < 4; ++i) {
                obj.pts[i].setLocation(this.pts[i]);
            }
            return obj;
        }

        public void setCorners(Shape glyph, AffineTransform xfm) {
            Rectangle2D r2d = xfm.createTransformedShape(glyph).getBounds2D();
            this.pts[0].setLocation(r2d.getMinX(), r2d.getMaxY());
            this.pts[1].setLocation(r2d.getMinX(), r2d.getMinY());
            this.pts[2].setLocation(r2d.getMaxX(), r2d.getMinY());
            this.pts[3].setLocation(r2d.getMaxX(), r2d.getMaxY());
        }

        public void setCornersPoints(Point2D[] pts) {
            this.pts = pts;
        }

        public Point2D[] getCorners() {
            return this.pts;
        }
    }

    class GlyphVectorInfo {
        String txt = null;
        Rectangle2D visualBounds;
        double visualCenterY = 0.0;
        int ngi;
        double ngx;
        double ngy;
        double avgGW;

        GlyphVectorInfo() {
        }
    }
}

