/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleResultSet;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TruetypeFont;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.style.Style;
import oracle.sdovis.util.DBTable;
import oracle.sdovis.util.Util;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class StyleTable
extends DBTable {
    String mName = null;
    int mType = 0;
    String mDescription = null;
    StringBuffer mSVGData = null;
    byte[] mImageData = null;
    JSDOGeometry mGeometry = null;
    private CLOB mCLOBSVG;
    private BLOB mBLOBImage;

    public int getType() {
        return this.mType;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getName() {
        return this.mName;
    }

    public StringBuffer getDefinition() {
        return this.mSVGData;
    }

    public byte[] getImageData() {
        return this.mImageData;
    }

    public JSDOGeometry getGeometry() {
        return this.mGeometry;
    }

    public StyleTable(String dataSrc, String tableName) {
        super(dataSrc, tableName);
    }

    @Override
    public int update() throws SQLException {
        String name = this.mName;
        int type = this.mType;
        String desc = this.mDescription;
        StringBuffer svgData = this.mSVGData;
        byte[] img = this.mImageData;
        JSDOGeometry geom = this.mGeometry;
        this.delete();
        this.mName = name;
        this.mType = type;
        this.mDescription = desc;
        this.mSVGData = svgData;
        this.mImageData = img;
        this.mGeometry = geom;
        int res = this.insert();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert() throws SQLException {
        Object str = null;
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        boolean autoCommit = this.mConnection.getAutoCommit();
        this.mConnection.setAutoCommit(false);
        this.initInsertStatement();
        this.mInsertStatement.setString(1, this.mName.toUpperCase());
        this.mInsertStatement.setString(2, StyleUtils.getTypeNameFromCode(this.mType));
        this.mInsertStatement.setString(3, this.mDescription);
        int res = this.mInsertStatement.executeUpdate();
        this.mConnection.commit();
        this.mConnection.setAutoCommit(false);
        Statement stmt = ((OracleConnection)this.mConnection).createStatement();
        String s = "SELECT definition, image FROM " + this.mTableName + " WHERE name='" + this.mName.toUpperCase() + "' FOR UPDATE";
        this.mResultSet = stmt.executeQuery(s);
        if (!this.mResultSet.next()) {
            System.err.println("Query: " + s);
            System.err.println("Cannot query " + this.mTableName + "! The inserted row is deleted.");
            res = this.delete();
            this.mConnection.setAutoCommit(autoCommit);
            return res;
        }
        this.mCLOBSVG = ((OracleResultSet)this.mResultSet).getCLOB("DEFINITION");
        this.mBLOBImage = ((OracleResultSet)this.mResultSet).getBLOB("IMAGE");
        try {
            Util.putClobContents((Clob)this.mCLOBSVG, this.mSVGData.toString());
            if (this.mImageData != null) {
                Util.putBlobContents((Blob)this.mBLOBImage, this.mImageData);
            }
            this.mConnection.commit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            if (this.mConnection != null) {
                this.mConnection.setAutoCommit(autoCommit);
            }
            this.close();
        }
        return res;
    }

    @Override
    public int delete() throws SQLException {
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        boolean autoCommit = this.mConnection.getAutoCommit();
        this.mConnection.setAutoCommit(false);
        this.initDeleteStatement();
        this.mDeleteStatement.setString(1, this.mName.toUpperCase());
        int res = this.mDeleteStatement.executeUpdate();
        this.mConnection.commit();
        this.mConnection.setAutoCommit(autoCommit);
        this.close();
        this.mSVGData = null;
        this.mImageData = null;
        this.mName = null;
        this.mType = 0;
        this.mDescription = null;
        this.mCLOBSVG = null;
        this.mBLOBImage = null;
        this.mGeometry = null;
        if (this.mConnection != null) {
            this.mConnection.close();
        }
        return res;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setType(int type) {
        this.mType = type;
    }

    public void setType(String s) {
        this.mType = StyleUtils.getTypeCodeFromName(s);
    }

    public void setDescription(String desc) {
        this.mDescription = desc;
    }

    public void setDefinition(StringBuffer data) {
        this.mSVGData = data;
    }

    public void setImage(String imgFile) {
        if (imgFile == null || imgFile.length() < 2) {
            return;
        }
        try {
            this.mImageData = Util.readFile(imgFile);
        }
        catch (IOException e) {
            this.mImageData = null;
        }
    }

    public void setImage(byte[] data) {
        this.mImageData = data;
    }

    public void setGeometry(JSDOGeometry data) {
        this.mGeometry = data;
    }

    public Style getStyleObject(String name) throws DataException {
        if (name == null) {
            return null;
        }
        if (name.indexOf(58) > 0 || name.indexOf(47) > 0) {
            int idx = name.indexOf(58);
            if (idx < 0) {
                idx = name.indexOf(47);
            }
            String owner = name.substring(0, idx);
            String sname = name.substring(idx + 1, name.length());
            return this.getStyleObject(sname, owner);
        }
        try {
            this.query("select *from " + this.mTableName + " where name='" + name.toUpperCase() + "'");
            if (!this.next()) {
                Style idx = null;
                return idx;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataException(e);
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (SQLException e2) {}
        }
        String description = this.mDescription;
        Style style = StyleFactory.createStyleObject(this.mType, this.getDefinition().toString(), this.mImageData);
        if (style != null) {
            style.getModel().setDescription(description);
        }
        return style;
    }

    public TruetypeFont getTTFont(String name) throws DataException {
        if (name == null) {
            return null;
        }
        Font font = null;
        if (name.indexOf(58) > 0) {
            int idx = name.indexOf(58);
            String owner = name.substring(0, idx);
            String sname = name.substring(idx + 1, name.length());
            return this.getTTFont(sname, owner);
        }
        try {
            this.query("select * from " + this.mTableName + " where name='" + name.toUpperCase() + "' and type='TTF' and owner='" + this.mUser + "'");
            if (!this.next()) {
                TruetypeFont idx = null;
                return idx;
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            throw new DataException(e);
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (SQLException e2) {}
        }
        TruetypeFont ttf = new TruetypeFont();
        ttf.setName(this.mName);
        ttf.setDescription(this.mDescription);
        ttf.setFontData(this.mImageData);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.mImageData);
            font = Font.createFont(0, bais);
            ttf.setFont(font);
            return ttf;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DataException(e.getCause());
        }
    }

    public Style getStyleObject(String name, String owner) throws DataException {
        if (name == null) {
            return null;
        }
        try {
            this.query("select * from " + this.mTableName + " where name='" + name.toUpperCase() + "' and owner='" + owner.toUpperCase() + "'");
            if (!this.next()) {
                Style style = null;
                return style;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataException(e);
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (SQLException e2) {
                e2.printStackTrace(System.err);
            }
        }
        String description = this.mDescription;
        Style style = StyleFactory.createStyleObject(this.mType, this.getDefinition().toString(), this.mImageData);
        if (style != null) {
            style.getModel().setDescription(description);
        }
        return style;
    }

    public TruetypeFont getTTFont(String name, String owner) throws DataException {
        if (name == null) {
            return null;
        }
        try {
            this.query("select * from " + this.mTableName + " where name='" + name.toUpperCase() + "' and owner='" + owner.toUpperCase() + "' and type='TTF'");
            if (!this.next()) {
                TruetypeFont truetypeFont = null;
                return truetypeFont;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataException(e);
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (SQLException e2) {}
        }
        TruetypeFont ttf = new TruetypeFont();
        ttf.setName(this.mName);
        ttf.setDescription(this.mDescription);
        ttf.setFontData(this.mImageData);
        Font font = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.mImageData);
            font = Font.createFont(0, bais);
            ttf.setFont(font);
            return ttf;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DataException(e.getCause());
        }
    }

    protected void finalize() {
        try {
            super.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected void initDeleteStatement() throws SQLException {
        if (this.mDeleteStatement == null) {
            this.mDeleteStatement = this.mConnection.prepareStatement("DELETE FROM " + this.mTableName + " WHERE name = ?");
        }
    }

    @Override
    protected void initInsertStatement() throws SQLException {
        if (this.mInsertStatement == null) {
            this.mInsertStatement = this.mConnection.prepareStatement("INSERT INTO " + this.mTableName + "(name,type,description,definition,image)" + " VALUES(?, ?, ?, empty_clob(), empty_blob())");
        }
    }

    @Override
    protected void initUpdateStatement() throws SQLException {
    }

    @Override
    protected void updateLocalData() throws SQLException {
        String typeName = null;
        Object str = null;
        String owner = null;
        this.mName = this.mResultSet.getString("NAME");
        if (this.mTableName.equals("ALL_SDO_STYLES")) {
            owner = this.mResultSet.getString("OWNER");
            this.mName = new String(owner + ":" + this.mName);
        }
        typeName = this.mResultSet.getString("TYPE");
        this.mType = StyleUtils.getTypeCodeFromName(typeName);
        this.mDescription = this.mResultSet.getString("DESCRIPTION");
        this.mCLOBSVG = (CLOB)this.mResultSet.getObject("DEFINITION");
        this.mBLOBImage = (BLOB)this.mResultSet.getObject("IMAGE");
        try {
            this.mSVGData = new StringBuffer(this.mCLOBSVG.getSubString(1L, (int)this.mCLOBSVG.length()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.mSVGData = null;
        }
        if (this.mBLOBImage == null) {
            this.mImageData = null;
            return;
        }
        try {
            if (this.mBLOBImage.length() < 5L) {
                this.mImageData = null;
                return;
            }
            this.mImageData = this.mBLOBImage.getBytes(1L, (int)this.mBLOBImage.length());
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.mImageData = null;
        }
    }
}

