/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.LineStyleModel;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.SRS;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.LineStyleModifiers;
import oracle.sdovis.style.MarkerStroke;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.RenderingUtils;
import oracle.sdovis.util.ShapeUtil;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StyleLine
implements Style {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static final long serialVersionUID = -9142054770024138861L;
    LineStyleModel bean;
    transient Stroke parallelStroke = null;
    transient Stroke overallFillStroke = null;
    transient Stroke centerLineStroke = null;
    transient Stroke hashMarkStroke = null;
    transient MarkerStroke mpStroke = null;
    transient StyleMarker[] mpMarkerStyles = null;
    transient StyleMarker markerStyle = null;

    public StyleLine() {
        this.bean = new LineStyleModel();
    }

    public StyleLine(StyleModel model) {
        this.setModel(model);
    }

    public StyleLine(String svg) throws StyleException {
        this.bean = new LineStyleModel();
        if (!this.parseLineStyles(svg)) {
            throw new StyleException("Invalid line style definition.");
        }
    }

    @Override
    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public Object clone() {
        try {
            StyleLine sty = (StyleLine)super.clone();
            sty.setModel((StyleModel)this.bean.clone());
            return sty;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    private boolean parseLineStyles(String svg) {
        String unit;
        String joinS;
        String rootStyle;
        SizeDefinition lwd;
        XMLDOMParser parser = new XMLDOMParser();
        if (!parser.parse(svg)) {
            return false;
        }
        String cased = parser.getAttribute("g", "cased");
        if (cased != null && cased.length() > 0) {
            this.bean.setCased("true".equalsIgnoreCase(cased));
        }
        if ((lwd = StyleUtils.getStrokeWidthSize(rootStyle = parser.getAttribute("g", "style"))) != null) {
            this.bean.setLineWidth((float)lwd.getValue());
            this.bean.setLineWidthUnit(lwd.getUnit());
        } else {
            this.bean.setLineWidth(0.0f);
            this.bean.setLineWidthUnit(null);
        }
        String measMarker = StyleUtils.getNamedString(rootStyle, "marker-name");
        if (measMarker != null) {
            String sizeMarker;
            this.bean.setMarkerStyleName(measMarker.toUpperCase());
            String posMarker = StyleUtils.getNamedString(rootStyle, "marker-position");
            if (posMarker != null) {
                if (posMarker.equalsIgnoreCase(LineStyleModel.MULTIMARKER_END_POINTS) || posMarker.equalsIgnoreCase(LineStyleModel.MULTIMARKER_ALL_POINTS)) {
                    this.bean.setMultipleMarkerPosition(posMarker);
                } else {
                    try {
                        this.bean.setMarkerPosition(Double.parseDouble(posMarker));
                    }
                    catch (Exception e) {
                        this.bean.setMarkerPosition(0.75);
                    }
                    this.bean.setMultipleMarkerPosition(LineStyleModel.MULTIMARKER_ALONG_PATH);
                    String multiMarker = StyleUtils.getNamedString(rootStyle, "multiple-marker");
                    if (multiMarker != null && multiMarker.trim().equalsIgnoreCase("true")) {
                        this.bean.setMultipleMarker(true);
                    } else {
                        this.bean.setMultipleMarker(false);
                    }
                }
            }
            if ((sizeMarker = StyleUtils.getNamedString(rootStyle, "marker-size")) != null) {
                SizeDefinition mksize = SizeDefinition.parse(sizeMarker);
                if (mksize != null) {
                    this.bean.setMarkerWidth(mksize.getValue());
                    this.bean.setMarkerHeight(mksize.getValue());
                    this.bean.setMarkerSizeUnit(mksize.getUnit());
                } else {
                    this.bean.setMarkerWidth(-1.0);
                    this.bean.setMarkerHeight(-1.0);
                    this.bean.setMarkerSizeUnit(null);
                }
            } else {
                SizeDefinition mkhsize;
                SizeDefinition mkwsize;
                double w = -1.0;
                String un = null;
                String wsizeMarker = StyleUtils.getNamedString(rootStyle, "marker-width");
                if (wsizeMarker != null && (mkwsize = SizeDefinition.parse(wsizeMarker)) != null) {
                    w = mkwsize.getValue();
                    un = mkwsize.getUnit();
                }
                double h = -1.0;
                String hsizeMarker = StyleUtils.getNamedString(rootStyle, "marker-height");
                if (hsizeMarker != null && (mkhsize = SizeDefinition.parse(hsizeMarker)) != null) {
                    h = mkhsize.getValue();
                    if (un == null) {
                        un = mkhsize.getUnit();
                    }
                }
                this.bean.setMarkerWidth(w);
                this.bean.setMarkerHeight(h);
                this.bean.setMarkerSizeUnit(un);
            }
        } else {
            this.bean.setMarkerStyleName(null);
        }
        String s = null;
        NodeList nl = parser.getElementNodes("line");
        if (nl == null) {
            return false;
        }
        Node base = null;
        Node parallel = null;
        Node hashmark = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node nd = nl.item(i);
            s = XMLDOMParser.getAttribute(nd, "class");
            if (s.toUpperCase().equals("BASE")) {
                base = nd;
                continue;
            }
            if (s.toUpperCase().equals("PARALLEL")) {
                parallel = nd;
                continue;
            }
            if (!s.toUpperCase().equals("HASHMARK")) continue;
            hashmark = nd;
        }
        if (base == null && parallel == null && hashmark == null) {
            return false;
        }
        Object dash = null;
        String capS = StyleUtils.getNamedString(rootStyle, "stroke-linecap");
        if (capS != null) {
            if ((capS = capS.toUpperCase()).equals("BUTT")) {
                this.bean.setCap(0);
            } else if (capS.equals("ROUND")) {
                this.bean.setCap(1);
            } else if (capS.equals("SQUARE")) {
                this.bean.setCap(2);
            }
        }
        if ((joinS = StyleUtils.getNamedString(rootStyle, "stroke-linejoin")) != null) {
            if ((joinS = joinS.toUpperCase()).equals("BEVEL")) {
                this.bean.setJoin(2);
            } else if (joinS.equals("MITER")) {
                this.bean.setJoin(0);
            } else if (joinS.equals("ROUND")) {
                this.bean.setJoin(1);
            }
        }
        if (base != null) {
            boolean hasBase = false;
            s = XMLDOMParser.getAttribute(base, "dash");
            if (s != null) {
                hasBase = true;
                ArrayList dashs = Util.splitBy(s, ",");
                String unit2 = null;
                if (dashs != null && dashs.size() > 0) {
                    float[] centerLineDash = new float[dashs.size()];
                    for (int i = 0; i < dashs.size(); ++i) {
                        SizeDefinition sizedef = SizeDefinition.parse((String)dashs.get(i));
                        centerLineDash[i] = sizedef != null ? (float)sizedef.getValue() : 0.0f;
                        if (sizedef.getUnit() == null) continue;
                        unit2 = sizedef.getUnit();
                    }
                    this.bean.setCenterLineDashPattern(centerLineDash);
                    this.bean.setCenterLineDashPatternUnit(unit2);
                    dash = null;
                }
            }
            if ((s = XMLDOMParser.getAttribute(base, "phase")) != null) {
                hasBase = true;
                this.bean.setCenterLinePhase(Float.valueOf(s).floatValue());
            } else {
                this.bean.setCenterLinePhase(0.0f);
            }
            s = XMLDOMParser.getAttribute(base, "style");
            if (s != null) {
                hasBase = true;
                SizeDefinition lw = StyleUtils.getStrokeWidthSize(s);
                if (lw == null) {
                    this.bean.setCenterLineWidth(0.0f);
                    this.bean.setCenterLineWidthUnit(null);
                } else {
                    this.bean.setCenterLineWidth((float)lw.getValue());
                    this.bean.setCenterLineWidthUnit(lw.getUnit());
                }
                this.bean.setCenterLineColor(StyleUtils.getColor("fill", s));
            }
            if (this.bean.getCenterLineColor() == null) {
                this.bean.setCenterLineColor(StyleUtils.getColor("fill", rootStyle));
            }
            if ((double)this.bean.getCenterLineWidth() == 0.0) {
                SizeDefinition cld = StyleUtils.getStrokeWidthSize(rootStyle);
                if (cld != null) {
                    this.bean.setCenterLineWidth((float)cld.getValue());
                    this.bean.setCenterLineWidthUnit(cld.getUnit());
                } else {
                    this.bean.setCenterLineWidth(0.0f);
                    this.bean.setCenterLineWidthUnit(null);
                }
            }
            if (hasBase) {
                this.centerLineStroke = new BasicStroke(this.bean.getCenterLineWidth(), this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getCenterLineDashPattern(), this.bean.getCenterLinePhase());
            }
        } else {
            this.centerLineStroke = null;
        }
        if (parallel != null) {
            s = XMLDOMParser.getAttribute(parallel, "dash");
            if (s != null) {
                ArrayList dashs = Util.splitBy(s, ",");
                unit = null;
                if (dashs != null && dashs.size() > 0) {
                    float[] parallelDash = new float[dashs.size()];
                    for (int i = 0; i < dashs.size(); ++i) {
                        SizeDefinition sizedef = SizeDefinition.parse((String)dashs.get(i));
                        parallelDash[i] = sizedef != null ? (float)sizedef.getValue() : 0.0f;
                        if (sizedef.getUnit() == null) continue;
                        unit = sizedef.getUnit();
                    }
                    this.bean.setWingDashPattern(parallelDash);
                    this.bean.setWingDashPatternUnit(unit);
                    dash = null;
                }
            }
            if ((s = XMLDOMParser.getAttribute(parallel, "phase")) != null) {
                this.bean.setWingPhase(Float.valueOf(s).floatValue());
            } else {
                this.bean.setWingPhase(0.0f);
            }
            s = XMLDOMParser.getAttribute(parallel, "style");
            if (s != null) {
                SizeDefinition ww = StyleUtils.getStrokeWidthSize(s);
                if (ww == null) {
                    this.bean.setWingWidth(0.0f);
                    this.bean.setWingWidthUnit(null);
                } else {
                    this.bean.setWingWidth((float)ww.getValue());
                    this.bean.setWingWidthUnit(ww.getUnit());
                }
                this.bean.setWingColor(StyleUtils.getColor("fill", s));
            }
            if (this.bean.getWingColor() == null) {
                this.bean.setWingColor(StyleUtils.getColor("stroke", rootStyle));
            }
            this.parallelStroke = new BasicStroke(this.bean.getLineWidth(), this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getWingDashPattern(), this.bean.getWingPhase());
        } else if (cased != null && cased.length() > 0 && "true".equalsIgnoreCase(cased)) {
            this.setParallelLineStyle(null, 0.0f, null, 0.0f);
        }
        if (hashmark != null) {
            this.bean.setHashMarkEnabled(true);
            Object hashDash = null;
            unit = null;
            s = XMLDOMParser.getAttribute(hashmark, "dash");
            if (s != null) {
                ArrayList dashs = Util.splitBy(s, ",");
                if (dashs != null && dashs.size() > 0) {
                    SizeDefinition d1;
                    SizeDefinition d0 = SizeDefinition.parse((String)dashs.get(0));
                    if (d0 != null) {
                        this.bean.setHashMarkGap((float)d0.getValue());
                        if (d0.getUnit() != null) {
                            unit = d0.getUnit();
                        }
                    } else {
                        this.bean.setHashMarkGap(8.5f);
                    }
                    if ((d1 = SizeDefinition.parse((String)dashs.get(1))) != null) {
                        this.bean.setHashMarkLength((float)d1.getValue());
                        if (d1.getUnit() != null) {
                            unit = d1.getUnit();
                        }
                    } else {
                        this.bean.setHashMarkLength(3.0f);
                    }
                    if (dashs.size() > 2) {
                        SizeDefinition d2 = SizeDefinition.parse((String)dashs.get(2));
                        if (d2 != null) {
                            this.bean.setHashMarkWidth((float)d2.getValue());
                            if (d2.getUnit() != null) {
                                unit = d2.getUnit();
                            }
                        } else {
                            this.bean.setHashMarkWidth(1.0f);
                        }
                    }
                    dash = null;
                }
                this.bean.setHashMarkUnit(unit);
                if (this.isPixelUnit(this.bean.getHashMarkUnit())) {
                    this.hashMarkStroke = new BasicStroke(this.bean.getHashMarkWidth());
                }
            }
            if ((s = XMLDOMParser.getAttribute(hashmark, "style")) != null) {
                this.bean.setHashMarkColor(StyleUtils.getColor("fill", s));
            }
            if (this.bean.getHashMarkColor() == null) {
                this.bean.setHashMarkColor(StyleUtils.getColor("stroke", rootStyle));
            }
        }
        if (rootStyle != null) {
            float w;
            this.bean.setFillColor(StyleUtils.getColor("fill", rootStyle));
            this.overallFillStroke = (double)this.bean.getLineWidth() >= 1.0 && this.bean.getLineWidthSize().isPixelUnit() && this.isPixelUnit(this.bean.getWingDashPatternUnit()) ? ((w = this.bean.getLineWidth() - this.bean.getWingWidth() * 2.0f) > 0.0f ? new BasicStroke(w, this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getWingDashPattern(), this.bean.getWingPhase()) : null) : null;
        } else {
            this.bean.setFillColor(Color.red);
        }
        Node mpattern = parser.getElementNode("marker-pattern");
        if (mpattern != null) {
            SizeDefinition oi;
            SizeDefinition oi2;
            String val = XMLDOMParser.getAttribute(mpattern, "offset");
            if (val != null) {
                SizeDefinition od = SizeDefinition.parse(val);
                if (od != null) {
                    this.bean.setMpStartingOffset((float)od.getValue());
                    this.bean.setMpStartingOffsetUnit(od.getUnit());
                } else {
                    this.bean.setMpStartingOffset(0.0f);
                    this.bean.setMpStartingOffsetUnit(null);
                }
            }
            if ((val = XMLDOMParser.getAttribute(mpattern, "interval")) != null) {
                SizeDefinition oi3 = SizeDefinition.parse(val);
                if (oi3 != null) {
                    this.bean.setMpInterval((float)oi3.getValue());
                    this.bean.setMpIntervalUnit(oi3.getUnit());
                } else {
                    this.bean.setMpInterval(5.0f);
                    this.bean.setMpIntervalUnit(null);
                }
            }
            String szunit = null;
            double mpwidth = -1.0;
            val = XMLDOMParser.getAttribute(mpattern, "width");
            if (val != null && (oi2 = SizeDefinition.parse(val)) != null) {
                mpwidth = oi2.getValue();
                szunit = oi2.getUnit();
            }
            double mpheight = -1.0;
            val = XMLDOMParser.getAttribute(mpattern, "height");
            if (val != null && (oi = SizeDefinition.parse(val)) != null) {
                mpheight = oi.getValue();
                szunit = oi.getUnit();
            }
            this.bean.setMpMarkerSize(new SizeDefinition2D(mpwidth, mpheight, szunit));
            ArrayList mps = XMLDOMParser.getSubElements(mpattern, "marker");
            if (mps == null || mps.size() == 0) {
                throw new IllegalArgumentException("Marker pattern is missing <marker> element.");
            }
            String[] mpstyles = new String[mps.size()];
            for (int i = 0; i < mps.size(); ++i) {
                Node mpv = (Node)mps.get(i);
                mpstyles[i] = XMLDOMParser.getElementValue(mpv);
            }
            this.bean.setMpMarkerStyles(mpstyles);
        }
        return true;
    }

    private void createStrokes() {
        float w;
        if (this.bean.getLineWidth() > 0.0f && this.bean.getLineWidthSize().isPixelUnit() && this.bean.getWingWidthSize().isPixelUnit() && this.isPixelUnit(this.bean.getWingDashPatternUnit())) {
            this.parallelStroke = new BasicStroke(this.bean.getLineWidth(), this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getWingDashPattern(), this.bean.getWingPhase());
        }
        if (this.bean.getCenterLineWidth() > 0.0f && this.bean.getCenterLineWidthSize().isPixelUnit() && this.isPixelUnit(this.bean.getCenterLineDashPatternUnit())) {
            this.centerLineStroke = new BasicStroke(this.bean.getCenterLineWidth(), this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getCenterLineDashPattern(), this.bean.getCenterLinePhase());
        }
        if (this.bean.getLineWidthSize().isPixelUnit() && this.isPixelUnit(this.bean.getWingWidthUnit()) && this.isPixelUnit(this.bean.getWingDashPatternUnit()) && (w = this.bean.getLineWidth() - this.bean.getWingWidth() * 2.0f) > 0.0f) {
            this.overallFillStroke = new BasicStroke(w, this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getWingDashPattern(), this.bean.getWingPhase());
        }
        if (this.bean.getHashMarkWidth() > 0.0f && this.isPixelUnit(this.bean.getHashMarkUnit())) {
            this.hashMarkStroke = new BasicStroke(this.bean.getHashMarkWidth());
        }
    }

    public void setOverallStyle(Color c, float width, int endCapType, int joinType) {
        this.overallFillStroke = null;
        this.bean.setOverallStyle(c, width, endCapType, joinType);
    }

    public void setCenterLineStyle(Color c, float width, float[] dash, float phase) {
        this.centerLineStroke = null;
        this.bean.setCenterLineStyle(c, width, dash, phase);
        if (width > 0.0f) {
            this.centerLineStroke = new BasicStroke(this.bean.getCenterLineWidth(), this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getCenterLineDashPattern(), this.bean.getCenterLinePhase());
        }
    }

    public void setParallelLineStyle(Color c, float width, float[] dash, float phase) {
        this.parallelStroke = null;
        this.overallFillStroke = null;
        this.bean.setWingLineStyle(c, width, dash, phase);
        if (this.bean.getLineWidth() > 0.0f) {
            this.parallelStroke = new BasicStroke(this.bean.getLineWidth(), this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getWingDashPattern(), this.bean.getWingPhase());
        }
    }

    private Stroke prepareFillStroke(StyleModifiers stymods) {
        if (stymods != null && stymods instanceof LineStyleModifiers) {
            LineStyleModifiers lmods = (LineStyleModifiers)stymods;
            float w = lmods.getLineWidth() - lmods.getWingWidth() * 2.0f;
            if (w > 0.0f) {
                return new BasicStroke(w, this.bean.getCap(), this.bean.getJoin(), 1.0f, lmods.getWingDashPattern(), lmods.getWingPhase());
            }
            return null;
        }
        if (this.overallFillStroke == null) {
            float w = this.bean.getLineWidth() - this.bean.getWingWidth() * 2.0f;
            if (w > 0.0f) {
                this.overallFillStroke = new BasicStroke(w, this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getWingDashPattern(), this.bean.getWingPhase());
                return this.overallFillStroke;
            }
            return null;
        }
        return this.overallFillStroke;
    }

    public void resetMarkerPatternStroke() {
        this.mpStroke = null;
    }

    private MarkerStroke prepareMPStroke(StyleModifiers stymods) {
        if (stymods != null && stymods instanceof LineStyleModifiers) {
            LineStyleModifiers lmods = (LineStyleModifiers)stymods;
            StyleMarker[] mkclones = this.cloneMPStyles();
            if (lmods.getMpWidth() > 0 || lmods.getMpHeight() > 0) {
                for (int i = 0; i < mkclones.length; ++i) {
                    if (lmods.getMpWidth() > 0) {
                        mkclones[i].setDesiredWidth(lmods.getMpWidth());
                    }
                    if (lmods.getMpHeight() <= 0) continue;
                    mkclones[i].setDesiredHeight(lmods.getMpHeight());
                }
            }
            return new MarkerStroke(mkclones, lmods.getMpInterval(), lmods.getMpStartingOffset());
        }
        if (this.mpStroke == null) {
            StyleMarker[] mkclones = this.cloneMPStyles();
            if (this.bean.getMpMarkerWidth() > 0.0 || this.bean.getMpMarkerHeight() > 0.0) {
                for (int i = 0; i < mkclones.length; ++i) {
                    mkclones[i].setDesiredWidth((int)this.bean.getMpMarkerWidth());
                    mkclones[i].setDesiredHeight((int)this.bean.getMpMarkerHeight());
                }
            }
            this.mpStroke = new MarkerStroke(mkclones, this.bean.getMpInterval(), this.bean.getMpStartingOffset());
            return this.mpStroke;
        }
        return this.mpStroke;
    }

    private StyleMarker[] cloneMPStyles() {
        if (this.mpMarkerStyles == null) {
            return null;
        }
        StyleMarker[] markers = new StyleMarker[this.mpMarkerStyles.length];
        for (int i = 0; i < this.mpMarkerStyles.length; ++i) {
            markers[i] = (StyleMarker)this.mpMarkerStyles[i].clone();
        }
        return markers;
    }

    public void setHashMarkStyle(Color c, float width, float height, float gap) {
        this.bean.setHashMarkStyle(c, width, height, gap);
        this.hashMarkStroke = new BasicStroke(width);
    }

    public StyleMarker getMarkerStyle() {
        return this.markerStyle;
    }

    public void setMarkerStyle(StyleMarker sty) {
        this.markerStyle = sty;
    }

    public StyleMarker[] getMarkerPatternStyles() {
        return this.mpMarkerStyles;
    }

    public void setMarkerPatternStyles(StyleMarker[] mks) {
        this.mpMarkerStyles = mks;
    }

    public boolean hasParallelLine() {
        return this.parallelStroke != null;
    }

    public boolean hasCenterLine() {
        return this.centerLineStroke != null;
    }

    public boolean hasFill() {
        return this.bean.getFillColor() != null && this.bean.getLineWidth() > this.bean.getWingWidth() * 2.0f;
    }

    public boolean supportCasedLine() {
        return this.bean.isCased() && this.hasParallelLine() && this.hasFill();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.createStrokes();
    }

    @Override
    public StyleModel getModel() {
        return this.bean;
    }

    @Override
    public void setModel(StyleModel model) {
        if (!(model instanceof LineStyleModel)) {
            throw new IllegalArgumentException("Not a LineStyleModel instance .");
        }
        this.bean = (LineStyleModel)model;
        this.createStrokes();
    }

    @Override
    public boolean resolveStyles(StyleCache sc, Hashtable dynaStyles) {
        String[] names;
        boolean res = true;
        String name = this.bean.getMarkerStyleName();
        if (name != null && this.markerStyle == null) {
            this.markerStyle = (StyleMarker)Util.getStyle(name, sc, dynaStyles);
            if (this.markerStyle == null) {
                res = false;
            }
        }
        if ((names = this.bean.getMpMarkerStyles()) != null && this.mpMarkerStyles == null) {
            this.mpMarkerStyles = new StyleMarker[names.length];
            for (int i = 0; i < names.length; ++i) {
                this.mpMarkerStyles[i] = (StyleMarker)Util.getStyle(names[i], sc, dynaStyles);
                if (this.mpMarkerStyles[i] != null) continue;
                res = false;
            }
        }
        return res;
    }

    @Override
    public boolean refreshResolvedStyles(StyleCache sc, Hashtable dynaStyles) {
        this.markerStyle = null;
        this.mpMarkerStyles = null;
        this.mpStroke = null;
        return this.resolveStyles(sc, dynaStyles);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, float x, float y, StyleModifiers stymods) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("cannot apply LINE style to a point");
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Rectangle2D rect, StyleModifiers stymods) throws StyleNotApplicableException {
        GeneralPath gp = new GeneralPath();
        float sx = (float)(rect.getMinX() + 5.0);
        float sy = (float)rect.getCenterY();
        gp.moveTo(sx, sy);
        float ex = (float)(rect.getMaxX() - 5.0);
        float ey = sy;
        gp.lineTo(ex, ey);
        this.apply(vc, g, gp, 2, null, null, null, null, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(vc, g, shp, gtype, null, null, null, null, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g2, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        this.casedFill1(vc, g2, shp, gtype, label, labelPoint, cr, values, stymods);
        this.casedFill2(vc, g2, shp, gtype, label, labelPoint, cr, values, stymods);
        this.casedFill3(vc, g2, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(vc, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(vc, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    public void casedFill1(VisContext vc, Graphics2D g2, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        LineStyleModifiers lmods;
        float w;
        this.prepareFillStroke(stymods);
        Stroke parstrk = this.parallelStroke;
        if (stymods != null && stymods instanceof LineStyleModifiers && (w = (lmods = (LineStyleModifiers)stymods).getLineWidth()) > 0.0f) {
            parstrk = new BasicStroke(w, this.bean.getCap(), this.bean.getJoin(), 1.0f, lmods.getWingDashPattern(), lmods.getWingPhase());
        }
        if (this.bean.getWingColor() != null) {
            g2.setColor(this.bean.getWingColor());
        }
        if (parstrk != null && this.bean.getWingColor() != null) {
            g2.setStroke(parstrk);
            RenderingUtils.smartDraw(shp, g2, vc);
        }
    }

    public void casedFill2(VisContext vc, Graphics2D g2, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        Stroke fillstrk = this.prepareFillStroke(stymods);
        if (this.bean.getFillColor() != null && fillstrk != null) {
            g2.setColor(this.bean.getFillColor());
            g2.setStroke(fillstrk);
            RenderingUtils.smartDraw(shp, g2, vc);
        }
    }

    public void casedFill3(VisContext vc, Graphics2D g2, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        MarkerStroke mstk;
        block22: {
            int realh;
            int realw;
            block23: {
                LineStyleModifiers lmods;
                float w;
                Stroke ctstrk = this.centerLineStroke;
                if (stymods != null && stymods instanceof LineStyleModifiers && (w = (lmods = (LineStyleModifiers)stymods).getCenterLineWidth()) > 0.0f) {
                    ctstrk = new BasicStroke(w, this.bean.getCap(), this.bean.getJoin(), 10.0f, lmods.getCenterLineDashPattern(), lmods.getCenterLinePhase());
                }
                if (ctstrk != null) {
                    g2.setColor(this.bean.getCenterLineColor());
                    g2.setStroke(ctstrk);
                    RenderingUtils.smartDraw(shp, g2, vc);
                }
                Stroke hmstrk = this.hashMarkStroke;
                if (stymods != null && stymods instanceof LineStyleModifiers) {
                    LineStyleModifiers lmods2 = (LineStyleModifiers)stymods;
                    hmstrk = new BasicStroke(lmods2.getHashMarkWidth());
                }
                if (this.bean.isHashMarkEnabled() && hmstrk != null) {
                    float hmgap = this.bean.getHashMarkGap();
                    float hmlength = this.bean.getHashMarkLength();
                    if (stymods != null && stymods instanceof LineStyleModifiers) {
                        hmgap = ((LineStyleModifiers)stymods).getHashMarkGap();
                        hmlength = ((LineStyleModifiers)stymods).getHashMarkLength();
                    }
                    g2.setColor(this.bean.getHashMarkColor());
                    g2.setStroke(hmstrk);
                    ShapeUtil.drawHashmarksOnShape(g2, this.bean.getHashMarkColor(), shp, hmgap, hmlength);
                }
                if (this.bean.getMarkerStyleName() == null || this.markerStyle == null) break block22;
                realw = (int)this.bean.getMarkerWidth();
                realh = (int)this.bean.getMarkerHeight();
                if (stymods != null && stymods instanceof LineStyleModifiers) {
                    realw = ((LineStyleModifiers)stymods).getMarkerWidth();
                    realh = ((LineStyleModifiers)stymods).getMarkerHeight();
                }
                if (!this.bean.isMultipleMarker() || !this.bean.getMultipleMarkerPosition().equalsIgnoreCase(LineStyleModel.MULTIMARKER_ALL_POINTS) && !this.bean.getMultipleMarkerPosition().equalsIgnoreCase(LineStyleModel.MULTIMARKER_END_POINTS)) break block23;
                double[] segpoints = ShapeUtil.lrSegmentPoints(shp);
                boolean all_points = true;
                if (this.bean.getMultipleMarkerPosition().equalsIgnoreCase(LineStyleModel.MULTIMARKER_END_POINTS)) {
                    all_points = false;
                }
                if (segpoints == null || segpoints.length <= 0) break block22;
                StyleMarker cloneMarker = (StyleMarker)this.markerStyle.clone();
                if (realw > 0) {
                    cloneMarker.setDesiredWidth(realw);
                }
                if (realh > 0) {
                    cloneMarker.setDesiredHeight(realh);
                }
                double firstx = 0.0;
                double firsty = 0.0;
                double lastx = 0.0;
                double lasty = 0.0;
                double dx = 0.0;
                double dy = 0.0;
                for (int i = 0; i < segpoints.length / 4; ++i) {
                    Rectangle2D.Double sr;
                    if (i > 0) {
                        if (segpoints[4 * i] != lastx || segpoints[4 * i + 1] != lasty) {
                            sr = new Rectangle2D.Double(lastx + 0.5 - (double)(realw / 2), lasty + 0.5 - (double)(realh / 2), realw, realh);
                            cloneMarker.apply(vc, g2, sr, null);
                        }
                    } else {
                        firstx = segpoints[4 * i];
                        firsty = segpoints[4 * i + 1];
                    }
                    dx = segpoints[4 * i + 2] - segpoints[4 * i];
                    dy = segpoints[4 * i + 3] - segpoints[4 * i + 1];
                    cloneMarker.setOrientation(dx, -dy, 0.0);
                    if (all_points || !all_points && (lastx != segpoints[4 * i] || lasty != segpoints[4 * i + 1])) {
                        sr = new Rectangle2D.Double(segpoints[4 * i] + 0.5 - (double)(realw / 2), segpoints[4 * i + 1] + 0.5 - (double)(realh / 2), realw, realh);
                        cloneMarker.apply(vc, g2, sr, null);
                    }
                    lastx = segpoints[4 * i + 2];
                    lasty = segpoints[4 * i + 3];
                }
                if (firstx == lastx && firsty == lasty) break block22;
                Rectangle2D.Double sr = new Rectangle2D.Double(lastx + 0.5 - (double)(realw / 2), lasty + 0.5 - (double)(realh / 2), realw, realh);
                cloneMarker.apply(vc, g2, sr, null);
                break block22;
            }
            if ((double)realw < 0.75 * ShapeUtil.lengthOf(shp)) {
                StyleMarker cloneMarker = (StyleMarker)this.markerStyle.clone();
                if (realw > 0) {
                    cloneMarker.setDesiredWidth(realw);
                }
                if (realh > 0) {
                    cloneMarker.setDesiredHeight(realh);
                }
                float[] pt = new float[2];
                for (double dirpos = this.bean.getMarkerPosition(); dirpos >= 0.0 && dirpos <= 1.0; dirpos += this.bean.getMarkerPosition()) {
                    if (ShapeUtil.lrPoint(shp, dirpos, pt)) {
                        double[] segpoints = new double[4];
                        ShapeUtil.lrSegmentPoints(shp, dirpos, segpoints);
                        double dx = segpoints[2] - segpoints[0];
                        double dy = segpoints[3] - segpoints[1];
                        cloneMarker.setOrientation(dx, -dy, 0.0);
                        Rectangle2D.Double sr = new Rectangle2D.Double((double)pt[0] + 0.5 - (double)(realw / 2), (double)pt[1] + 0.5 - (double)(realh / 2), realw, realh);
                        cloneMarker.apply(vc, g2, sr, null);
                    }
                    if (!this.bean.isMultipleMarker() || dirpos == 0.0 || dirpos == 1.0) break;
                }
            }
        }
        if (this.bean.getMpMarkerStyles() != null && (mstk = this.prepareMPStroke(stymods)) != null) {
            try {
                MarkerStroke.MarkerPosition[] mps = mstk.placeMarkers(shp, vc);
                mstk.drawMarkers(g2, mps);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    @Override
    public Object getPropertyValue(String propertyType) {
        return null;
    }

    @Override
    public StyleModifiers convertToPixelSize(VisContext vc) {
        if (this.bean.getLineWidthSize().isPixelUnit() && this.bean.getCenterLineWidthSize().isPixelUnit() && this.isPixelUnit(this.bean.getCenterLineDashPatternUnit()) && this.isPixelUnit(this.bean.getWingDashPatternUnit()) && this.bean.getWingWidthSize().isPixelUnit() && this.isPixelUnit(this.bean.getHashMarkUnit()) && this.bean.getMarkerSize2DDef().isPixelUnit() && this.bean.getMpStartingOffsetSize().isPixelUnit() && this.bean.getMpIntervalSize().isPixelUnit() && this.bean.getMpMarkerSize().isPixelUnit()) {
            return null;
        }
        LineStyleModifiers lnmods = new LineStyleModifiers();
        if (vc == null || Util.isFullExtent(vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMaxX(), vc.getQueryWindow().getMaxY()) || vc.getQueryWindow().getWidth() == 0.0 && vc.getQueryWindow().getHeight() == 0.0) {
            SizeDefinition2D mpsize;
            SizeDefinition mpintv;
            SizeDefinition mpoff;
            SizeDefinition2D msize;
            String hmunit;
            SizeDefinition wlwidth;
            String wldunit;
            int i;
            float[] dashmod;
            String cldunit;
            float[] dash;
            SizeDefinition clwidth;
            SizeDefinition blwidth = this.bean.getLineWidthSize();
            if (blwidth.isPixelUnit()) {
                lnmods.setLineWidth((float)blwidth.getValue());
            }
            if ((clwidth = this.bean.getCenterLineWidthSize()).isPixelUnit()) {
                lnmods.setCenterLineWidth((float)clwidth.getValue());
            }
            if (!blwidth.isPixelUnit() && lnmods.getLineWidth() < lnmods.getCenterLineWidth()) {
                lnmods.setLineWidth(lnmods.getCenterLineWidth() + 4.0f);
            }
            if ((dash = this.bean.getCenterLineDashPattern()) != null && dash.length > 0 && this.isPixelUnit(cldunit = this.bean.getCenterLineDashPatternUnit())) {
                dashmod = new float[dash.length];
                for (i = 0; i < dash.length; ++i) {
                    dashmod[i] = dash[i];
                }
                lnmods.setCenterLineDashPattern(dashmod);
            }
            if ((dash = this.bean.getWingDashPattern()) != null && dash.length > 0 && this.isPixelUnit(wldunit = this.bean.getWingDashPatternUnit())) {
                dashmod = new float[dash.length];
                for (i = 0; i < dash.length; ++i) {
                    dashmod[i] = dash[i];
                }
                lnmods.setWingDashPattern(dashmod);
            }
            if ((wlwidth = this.bean.getWingWidthSize()).isPixelUnit()) {
                lnmods.setWingWidth((float)wlwidth.getValue());
            } else if (wlwidth.getValue() != 0.0) {
                lnmods.setWingWidth(1.0f);
            }
            lnmods.setWingPhase(this.bean.getWingPhase());
            if (!blwidth.isPixelUnit() && lnmods.getLineWidth() <= lnmods.getWingWidth()) {
                lnmods.setLineWidth(lnmods.getWingWidth() + 4.0f);
            }
            if (this.isPixelUnit(hmunit = this.bean.getHashMarkUnit())) {
                lnmods.setHashMarkGap(this.bean.getHashMarkGap());
                lnmods.setHashMarkLength(this.bean.getHashMarkLength());
                lnmods.setHashMarkWidth(this.bean.getHashMarkWidth());
            }
            if ((msize = this.bean.getMarkerSize2DDef()).isPixelUnit()) {
                lnmods.setMarkerWidth((int)this.bean.getMarkerWidth());
                lnmods.setMarkerHeight((int)this.bean.getMarkerHeight());
            }
            if ((mpoff = this.bean.getMpStartingOffsetSize()).isPixelUnit()) {
                lnmods.setMpStartingOffset((float)mpoff.getValue());
            }
            if ((mpintv = this.bean.getMpIntervalSize()).isPixelUnit()) {
                lnmods.setMpInterval((float)mpintv.getValue());
            }
            if ((mpsize = this.bean.getMpMarkerSize()).isPixelUnit()) {
                lnmods.setMpWidth((int)this.bean.getMpMarkerWidth());
                lnmods.setMpHeight((int)this.bean.getMpMarkerHeight());
            }
        } else {
            int i;
            float[] dashmod;
            float[] dash;
            double pixelY;
            Rectangle2D devW = vc.getDeviceWindow();
            Rectangle2D queW = vc.getQueryWindow();
            double pixelX = queW.getWidth() / devW.getWidth();
            pixelX = pixelY = queW.getHeight() / devW.getHeight();
            double v = this.getPixelValue(this.bean.getLineWidthSize(), pixelY, vc);
            if (v > 0.0) {
                lnmods.setLineWidth((float)v);
            }
            if ((v = this.getPixelValue(this.bean.getCenterLineWidthSize(), pixelY, vc)) > 0.0) {
                lnmods.setCenterLineWidth((float)v);
            }
            if ((dash = this.bean.getCenterLineDashPattern()) != null && dash.length > 0) {
                dashmod = new float[dash.length];
                String cldunit = this.bean.getCenterLineDashPatternUnit();
                if (this.isPixelUnit(cldunit)) {
                    for (i = 0; i < dash.length; ++i) {
                        dashmod[i] = dash[i];
                    }
                    lnmods.setCenterLineDashPattern(dashmod);
                } else {
                    for (i = 0; i < dash.length; ++i) {
                        v = this.getPixelValue(new SizeDefinition(dash[i], cldunit), pixelX, vc);
                        if (!(v > 0.0)) continue;
                        dashmod[i] = (float)v;
                    }
                    lnmods.setCenterLineDashPattern(dashmod);
                }
            }
            if ((dash = this.bean.getWingDashPattern()) != null && dash.length > 0) {
                dashmod = new float[dash.length];
                String wldunit = this.bean.getWingDashPatternUnit();
                if (this.isPixelUnit(wldunit)) {
                    for (i = 0; i < dash.length; ++i) {
                        dashmod[i] = dash[i];
                    }
                    lnmods.setWingDashPattern(dashmod);
                } else {
                    for (i = 0; i < dash.length; ++i) {
                        v = this.getPixelValue(new SizeDefinition(dash[i], wldunit), pixelX, vc);
                        if (!(v > 0.0)) continue;
                        dashmod[i] = (float)v;
                    }
                    lnmods.setWingDashPattern(dashmod);
                }
            }
            if ((v = this.getPixelValue(this.bean.getWingWidthSize(), pixelY, vc)) > 0.0) {
                lnmods.setWingWidth((float)v);
            }
            lnmods.setWingPhase(this.bean.getWingPhase());
            String hmunit = this.bean.getHashMarkUnit();
            if (this.isPixelUnit(hmunit)) {
                lnmods.setHashMarkGap(this.bean.getHashMarkGap());
                lnmods.setHashMarkLength(this.bean.getHashMarkLength());
                lnmods.setHashMarkWidth(this.bean.getHashMarkWidth());
            } else {
                v = this.getPixelValue(new SizeDefinition(this.bean.getHashMarkGap(), hmunit), pixelX, vc);
                if (v > 0.0) {
                    lnmods.setHashMarkGap((float)v);
                }
                if ((v = this.getPixelValue(new SizeDefinition(this.bean.getHashMarkLength(), hmunit), pixelY, vc)) > 0.0) {
                    lnmods.setHashMarkLength((float)v);
                }
                if ((v = this.getPixelValue(new SizeDefinition(this.bean.getHashMarkWidth(), hmunit), pixelX, vc)) > 0.0) {
                    lnmods.setHashMarkWidth((float)v);
                }
            }
            v = this.getPixelValue(new SizeDefinition(this.bean.getMarkerWidth(), this.bean.getMarkerSizeUnit()), pixelX, vc);
            if (v > 0.0) {
                lnmods.setMarkerWidth((int)v);
            }
            if ((v = this.getPixelValue(new SizeDefinition(this.bean.getMarkerHeight(), this.bean.getMarkerSizeUnit()), pixelY, vc)) > 0.0) {
                lnmods.setMarkerHeight((int)v);
            }
            if ((v = this.getPixelValue(this.bean.getMpStartingOffsetSize(), pixelX, vc)) > 0.0) {
                lnmods.setMpStartingOffset((float)v);
            }
            if ((v = this.getPixelValue(this.bean.getMpIntervalSize(), pixelX, vc)) > 0.0) {
                lnmods.setMpInterval((float)v);
            }
            if ((v = this.getPixelValue(new SizeDefinition(this.bean.getMpMarkerWidth(), this.bean.getMpMarkerUnit()), pixelX, vc)) > 0.0) {
                lnmods.setMpWidth((int)v);
            }
            if ((v = this.getPixelValue(new SizeDefinition(this.bean.getMpMarkerHeight(), this.bean.getMpMarkerUnit()), pixelY, vc)) > 0.0) {
                lnmods.setMpHeight((int)v);
            }
        }
        return lnmods;
    }

    private double getPixelValue(SizeDefinition value, double pixelSize, VisContext vc) {
        Double convFactor = null;
        if (value.getUnit() != null) {
            convFactor = SRS.getDistanceConversionFactor(value.getUnit());
        }
        if (value.isPixelUnit()) {
            return value.getValue();
        }
        if (convFactor != null) {
            double cv = value.getValue() * convFactor;
            if (vc.getSrs() != null && vc.getSrs().isGeodetic()) {
                double dgw = SphereCG.convertRadius(0.0, 0.0, cv);
                return dgw / pixelSize + 0.5;
            }
            return cv / pixelSize + 0.5;
        }
        return 0.0;
    }

    private boolean isPixelUnit(String unit) {
        return unit == null || unit.equalsIgnoreCase("px") || unit.equalsIgnoreCase("pt");
    }
}

