/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.style.ColorStyleModel;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.ShapeUtil;
import oracle.sdovis.util.XMLDOMParser;

public class StyleColor
implements Style {
    static final long serialVersionUID = -7634361956221034855L;
    ColorStyleModel bean;
    transient Stroke basicStroke = new BasicStroke(1.0f, 0, 2);

    public StyleColor() {
        this.bean = new ColorStyleModel();
    }

    public StyleColor(StyleModel model) {
        this.setModel(model);
    }

    public StyleColor(Color c) {
        this.bean = new ColorStyleModel();
        this.bean.setFillColor(c);
    }

    public StyleColor(Color fillC, Color strokeC) {
        this.bean = new ColorStyleModel();
        this.bean.setFillColor(fillC);
        this.bean.setStrokeColor(strokeC);
    }

    public StyleColor(String svg) throws StyleException {
        this.bean = new ColorStyleModel();
        this.parseStyleColor(svg);
    }

    @Override
    public StyleModel getModel() {
        return this.bean;
    }

    @Override
    public void setModel(StyleModel model) {
        if (!(model instanceof ColorStyleModel)) {
            throw new IllegalArgumentException("Not a ColorStyleModel instance.");
        }
        this.bean = (ColorStyleModel)model;
    }

    @Override
    public String getDefinition() {
        return this.bean.toXMLString();
    }

    private void parseStyleColor(String svg) throws StyleException {
        XMLDOMParser parser;
        if (this.basicStroke == null) {
            this.basicStroke = new BasicStroke(1.0f, 0, 2);
        }
        if (!(parser = new XMLDOMParser()).parse(svg)) {
            throw new StyleException("Invalid color style definition.");
        }
        String type = parser.getAttribute("g", "class");
        if (type == null) {
            throw new StyleException("Invalid color style definition (expecting COLOR).");
        }
        String color = parser.getAttribute("g", "style");
        if (color == null) {
            throw new StyleException("Invalid color style definition (no color attribute).");
        }
        this.bean.setFillColor(StyleUtils.getColor("fill", color));
        this.bean.setStrokeColor(StyleUtils.getColor("stroke", color));
        float strokeW = StyleUtils.getStrokeWidth(color);
        if (strokeW >= 0.0f) {
            float strokeWidth = strokeW;
            this.basicStroke = new BasicStroke(strokeWidth, 0, 2);
            this.bean.setStrokeWidth(strokeWidth);
        }
    }

    private static StyleColor getDefault() {
        return new StyleColor(null, Color.black);
    }

    public void setStrokeWidth(float w) {
        if (w < 0.0f) {
            return;
        }
        this.bean.setStrokeWidth(w);
        this.basicStroke = new BasicStroke(w, 0, 2);
    }

    public float getStrokeWidth() {
        return this.bean.getStrokeWidth();
    }

    public Object clone() {
        try {
            StyleColor sa = (StyleColor)super.clone();
            sa.setModel((StyleModel)this.bean.clone());
            return sa;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public Color getFillColor() {
        return this.bean.getFillColor();
    }

    public void setFillColor(Color c) {
        this.bean.setFillColor(c);
    }

    public Color getStrokeColor() {
        return this.bean.getStrokeColor();
    }

    public void setStrokeColor(Color c) {
        this.bean.setStrokeColor(c);
    }

    @Override
    public boolean resolveStyles(StyleCache sc, Hashtable dynaStyles) {
        return true;
    }

    @Override
    public boolean refreshResolvedStyles(StyleCache sc, Hashtable dynaStyles) {
        return this.resolveStyles(sc, dynaStyles);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, float x, float y, StyleModifiers stymods) throws StyleNotApplicableException {
        Color fillC = this.bean.getFillColor();
        Color strokeC = this.bean.getStrokeColor();
        if (fillC != null) {
            g.setColor(fillC);
        }
        if (strokeC != null) {
            g.setColor(strokeC);
        }
        g.drawLine((int)(x - 3.0f), (int)(y - 3.0f), (int)(x + 3.0f), (int)(y + 3.0f));
        g.drawLine((int)(x - 3.0f), (int)(y + 3.0f), (int)(x + 3.0f), (int)(y - 3.0f));
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Rectangle2D rect, StyleModifiers stymods) throws StyleNotApplicableException {
        Color fillC = this.bean.getFillColor();
        Color strokeC = this.bean.getStrokeColor();
        if (fillC != null) {
            g.setPaint(fillC);
            g.fill(rect);
        }
        if (strokeC != null) {
            g.setStroke(this.basicStroke);
            g.setPaint(strokeC);
            g.draw(rect);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, StyleModifiers stymods) throws StyleNotApplicableException {
        Color fillC = this.bean.getFillColor();
        if (gtype == 2 || gtype == 6 || gtype == 4 && ShapeUtil.numCloseSegments(shp) == 0) {
            Color strokeC = this.bean.getStrokeColor();
            if (fillC != null) {
                g.setPaint(fillC);
            }
            if (strokeC != null) {
                g.setPaint(strokeC);
            }
            g.setStroke(this.basicStroke);
            g.draw(shp);
        } else if (gtype == 4) {
            this.applyToCollectionWithRing(g, shp);
        } else {
            this.apply(g, shp);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(null, g, shp, gtype, stymods);
    }

    protected void apply(Graphics2D g, Shape p) {
        Color fillC = this.bean.getFillColor();
        Color strokeC = this.bean.getStrokeColor();
        if (fillC != null) {
            g.setPaint(fillC);
            g.fill(p);
        }
        if (strokeC != null) {
            g.setStroke(this.basicStroke);
            g.setPaint(strokeC);
            g.draw(p);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    protected void applyToCollectionWithRing(Graphics2D g, Shape shp) {
        int nClose;
        PathIterator pi = shp.getPathIterator(null);
        Path2D gp = null;
        GeneralPath gpLines = null;
        GeneralPath gpRings = null;
        float[] seg = new float[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: {
                    if (gp != null) {
                        nClose = ShapeUtil.numCloseSegments(gp);
                        if (nClose == 0) {
                            if (gpLines == null) {
                                gpLines = new GeneralPath();
                            }
                            gpLines.append(gp, false);
                        } else {
                            if (gpRings == null) {
                                gpRings = new GeneralPath();
                            }
                            gpRings.append(gp, false);
                        }
                    }
                    gp = new GeneralPath();
                    ((Path2D.Float)gp).moveTo(seg[0], seg[1]);
                    break;
                }
                case 1: {
                    ((Path2D.Float)gp).lineTo(seg[0], seg[1]);
                    break;
                }
                case 4: {
                    gp.closePath();
                    break;
                }
                case 3: {
                    ((Path2D.Float)gp).curveTo(seg[0], seg[1], seg[2], seg[3], seg[4], seg[5]);
                    break;
                }
                case 2: {
                    ((Path2D.Float)gp).quadTo(seg[0], seg[1], seg[2], seg[3]);
                }
            }
            pi.next();
        }
        if (gp != null) {
            nClose = ShapeUtil.numCloseSegments(gp);
            if (nClose == 0) {
                if (gpLines == null) {
                    gpLines = new GeneralPath();
                }
                gpLines.append(gp, false);
            } else {
                if (gpRings == null) {
                    gpRings = new GeneralPath();
                }
                gpRings.append(gp, false);
            }
        }
        if (gpLines != null) {
            this.applyToCollectionElement(g, gpLines, false);
        }
        if (gpRings != null) {
            this.applyToCollectionElement(g, gpRings, true);
        }
    }

    private void applyToCollectionElement(Graphics2D g, GeneralPath gp, boolean isClosed) {
        Color fillC = this.bean.getFillColor();
        Color strokeC = this.bean.getStrokeColor();
        if (isClosed) {
            this.apply(g, gp);
        } else {
            if (fillC != null) {
                g.setPaint(fillC);
            }
            if (strokeC != null) {
                g.setPaint(strokeC);
            }
            g.setStroke(this.basicStroke);
            g.draw(gp);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.basicStroke == null) {
            this.basicStroke = new BasicStroke(this.bean.getStrokeWidth(), 0, 2);
        }
    }

    @Override
    public Object getPropertyValue(String propertyType) {
        if (propertyType == null) {
            return null;
        }
        if (propertyType.equalsIgnoreCase("FILL_COLOR")) {
            return this.bean.getFillColor();
        }
        return null;
    }

    @Override
    public StyleModifiers convertToPixelSize(VisContext vc) {
        return null;
    }
}

