/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.style.AreaStyleModel;
import oracle.mapviewer.share.style.StyleModel;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.ImageUtils;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Node;

public class StyleArea
implements Style {
    static final long serialVersionUID = 252711490847139593L;
    AreaStyleModel bean = null;
    transient Rectangle2D.Double mbr = null;
    transient BasicStroke stroke = null;
    transient TexturePaint tp = null;
    transient BufferedImage bufferedImage = null;
    transient StyleLine borderLineStyle = null;

    public StyleArea() {
        this.bean = new AreaStyleModel();
        this.createGraphicsObjects();
    }

    public StyleArea(StyleModel model) {
        this.setModel(model);
    }

    public StyleArea(String svg, byte[] imgData) throws StyleException {
        this.bean = new AreaStyleModel();
        this.bean.setFillPatternImage(imgData);
        this.parseAreaStyle(svg);
        this.createGraphicsObjects();
    }

    public Object clone() {
        try {
            StyleArea sa = (StyleArea)super.clone();
            sa.setModel((StyleModel)this.bean.clone());
            return sa;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public String getDefinition() {
        return this.bean.toXMLString();
    }

    private void parseAreaStyle(String svg) throws StyleException {
        XMLDOMParser parser = new XMLDOMParser();
        if (!parser.parse(svg)) {
            return;
        }
        String type = parser.getAttribute("g", "class");
        if (!type.equalsIgnoreCase(this.bean.getTypeName())) {
            System.err.println("[StyleArea] svg error: wrong type of style (expecting AREA)");
            return;
        }
        try {
            this.bean.setBorderStyleName(this.parseLineStyleName(parser.getAttribute("g", "style")));
        }
        catch (Exception e) {
            this.bean.setBorderStyleName(null);
        }
        boolean repeatFillPattern = true;
        try {
            Node f = parser.getElementNode("fill-pattern");
            if (f != null) {
                String r = XMLDOMParser.getAttribute(f, "repeat");
                repeatFillPattern = Boolean.getBoolean(r);
                this.bean.setRepeatFillPattern(repeatFillPattern);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            StyleColor styColor = new StyleColor(svg);
            this.bean.setBorderColor(styColor.getStrokeColor());
            this.bean.setFillColor(styColor.getFillColor());
            if (styColor.getStrokeWidth() >= 0.0f) {
                this.bean.setBorderWidth(styColor.getStrokeWidth());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void createGraphicsObjects() {
        this.refreshFillPattern();
        this.refreshBorderStroke();
    }

    public void refreshFillPattern() {
        if (this.bean.getFillPatternImage() != null) {
            BufferedImage img = null;
            try {
                img = ImageIO.read(new ByteArrayInputStream(this.bean.getFillPatternImage()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bufferedImage = ImageUtils.makeBufferedImage(img, 2);
            this.tp = new TexturePaint(this.bufferedImage, new Rectangle2D.Double(0.0, 0.0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight()));
            this.mbr = new Rectangle2D.Double(0.0, 0.0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
            img.flush();
            Object var1_1 = null;
        }
    }

    public void refreshBorderStroke() {
        float sw = this.bean.getBorderWidth();
        this.stroke = sw < 1.0f ? null : new BasicStroke(sw, 0, 2);
    }

    private String parseLineStyleName(String style) {
        if (style == null || style.length() == 0) {
            return null;
        }
        int idx = style.indexOf("line-style:");
        if (idx < 0) {
            return null;
        }
        int idx2 = style.indexOf(";", idx);
        if (idx2 < 0) {
            idx2 = style.length();
        }
        if (idx2 <= 0) {
            return null;
        }
        return style.substring(idx + 11, idx2);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.createGraphicsObjects();
    }

    @Override
    public StyleModel getModel() {
        return this.bean;
    }

    @Override
    public void setModel(StyleModel model) {
        if (!(model instanceof AreaStyleModel)) {
            throw new IllegalArgumentException("Not a valid Area style model");
        }
        this.bean = (AreaStyleModel)model;
        this.createGraphicsObjects();
    }

    @Override
    public boolean resolveStyles(StyleCache sc, Hashtable dynaStyles) {
        if (this.borderLineStyle != null || this.bean.getBorderStyleName() == null) {
            return true;
        }
        this.borderLineStyle = (StyleLine)Util.getStyle(this.bean.getBorderStyleName(), sc, dynaStyles);
        if (this.borderLineStyle == null) {
            return false;
        }
        return this.borderLineStyle.resolveStyles(sc, dynaStyles);
    }

    @Override
    public boolean refreshResolvedStyles(StyleCache sc, Hashtable dynaStyles) {
        this.borderLineStyle = null;
        return this.resolveStyles(sc, dynaStyles);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, float x, float y, StyleModifiers stymods) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("AREA style cannot be applied to a point.");
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Rectangle2D rect, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(vc, g, rect, 3, null, null, null, null, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(vc, g, shp, gtype, null, null, null, null, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        Color strokeC = this.bean.getBorderColor();
        Color fill = this.bean.getFillColor();
        if (this.bean.getAreaStyleType() == 2 && this.tp != null) {
            g.setPaint(this.tp);
        } else if (this.bean.getAreaStyleType() == 1) {
            g.setPaint(fill);
        }
        if (this.bean.isRepeatFillPattern() || this.bean.getAreaStyleType() == 1) {
            g.fill(shp);
        } else {
            BufferedImage image = this.tp.getImage();
            Rectangle2D mbr = shp.getBounds2D();
            g.drawImage(image, (int)mbr.getMinX(), (int)mbr.getMinY(), (int)mbr.getWidth(), (int)mbr.getHeight(), Color.white, null);
        }
        if (this.bean.getBorderStyleName() != null && this.borderLineStyle == null) {
            System.err.println("Warning: border style not resolved.");
        }
        if (this.borderLineStyle != null) {
            this.borderLineStyle.apply(vc, g, shp, gtype, label, labelPoint, cr, values, stymods);
        } else if (strokeC != null && this.stroke != null) {
            g.setColor(strokeC);
            g.setStroke(this.stroke);
            g.draw(shp);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(vc, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(vc, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    public void setBorderLineStyle(StyleLine borderLineStyle) {
        this.borderLineStyle = borderLineStyle;
    }

    public StyleLine getBroderLineStyle() {
        return this.borderLineStyle;
    }

    @Override
    public Object getPropertyValue(String propertyType) {
        return null;
    }

    @Override
    public StyleModifiers convertToPixelSize(VisContext vc) {
        return null;
    }
}

