/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.StyleMarker;

public class MarkerStroke {
    private StyleMarker[] markers;
    private float internalGap;
    private float startingOffset;
    private float offset;
    private static float DEFAULT_WIDTH = 9.0f;

    public MarkerStroke(StyleMarker marker) {
        this(new StyleMarker[]{marker}, 0.0f, 0.0f);
    }

    public MarkerStroke(StyleMarker[] markers, float internalGap, float startingOffset) {
        if (markers == null) {
            throw new IllegalArgumentException("Marker styles cannot be null.");
        }
        this.internalGap = internalGap;
        this.startingOffset = startingOffset;
        this.markers = new StyleMarker[markers.length];
        this.offset = 0.0f;
        for (int i = 0; i < markers.length; ++i) {
            this.markers[i] = markers[i];
            float w = markers[i].getDesiredWidth();
            if (w <= 0.0f) {
                w = DEFAULT_WIDTH;
            }
            this.offset += w;
            this.offset += internalGap;
        }
    }

    public MarkerPosition[] placeMarkers(Shape shape, VisContext vc) {
        double devWinMaxY;
        ArrayList<MarkerPosition> result = new ArrayList<MarkerPosition>();
        float moveX = 0.0f;
        float moveY = 0.0f;
        float lastX = 0.0f;
        float lastY = 0.0f;
        float thisX = 0.0f;
        float thisY = 0.0f;
        float[] coords = new float[6];
        int type = 0;
        float next = 0.0f;
        int currentMarker = 0;
        int numMarkers = this.markers.length;
        FlatteningPathIterator pit = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float angleToAdd = 0.0f;
        if (shape instanceof Ellipse2D || shape instanceof Rectangle2D) {
            angleToAdd = (float)Math.PI;
        }
        Rectangle2D devWin = vc == null ? null : vc.getDeviceWindow();
        double devWinMinX = devWin == null ? Double.NEGATIVE_INFINITY : devWin.getMinX();
        double devWinMinY = devWin == null ? Double.NEGATIVE_INFINITY : devWin.getMinY();
        double devWinMaxX = devWin == null ? Double.POSITIVE_INFINITY : devWin.getMaxX();
        double d = devWinMaxY = devWin == null ? Double.POSITIVE_INFINITY : devWin.getMaxY();
        while (currentMarker < numMarkers && !pit.isDone()) {
            type = pit.currentSegment(coords);
            switch (type) {
                case 0: {
                    moveX = lastX = coords[0];
                    moveY = lastY = coords[1];
                    next = this.startingOffset;
                    break;
                }
                case 4: {
                    coords[0] = moveX;
                    coords[1] = moveY;
                }
                case 1: {
                    thisX = coords[0];
                    thisY = coords[1];
                    float dx = thisX - lastX;
                    float dy = thisY - lastY;
                    float segmentLen = (float)Math.sqrt(dx * dx + dy * dy);
                    if (segmentLen >= next) {
                        float r = 1.0f / segmentLen;
                        float angle = (float)Math.atan2(dy, dx) + angleToAdd;
                        while (currentMarker < numMarkers && segmentLen >= next) {
                            boolean visible;
                            float x = lastX + next * dx * r;
                            float y = lastY + next * dy * r;
                            StyleMarker marker = this.markers[currentMarker];
                            boolean bl = visible = (double)x <= devWinMaxX && (double)x >= devWinMinX && (double)y <= devWinMaxY && (double)y >= devWinMinY;
                            if (visible) {
                                MarkerPosition mp = new MarkerPosition();
                                mp.marker = marker;
                                mp.x = x;
                                mp.y = y;
                                mp.angle = angle;
                                mp.drawPercentage = 100.0f;
                                result.add(mp);
                            }
                            next += (float)(marker.getDesiredWidth() / 2);
                            next += this.internalGap;
                            ++currentMarker;
                            next += (float)(this.markers[currentMarker %= numMarkers].getDesiredWidth() / 2);
                        }
                    }
                    next -= segmentLen;
                    lastX = thisX;
                    lastY = thisY;
                }
            }
            pit.next();
        }
        return result.toArray(new MarkerPosition[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMarkers(Graphics2D g2, MarkerPosition[] mps) {
        try {
            for (int i = 0; i < mps.length; ++i) {
                MarkerPosition mp = mps[i];
                StyleMarker m = mp.marker;
                m.setOrientation(mp.angle);
                m.apply(null, g2, mp.x, mp.y, null);
            }
        }
        catch (Exception e) {
            for (int k = 0; k < this.markers.length; ++k) {
                StyleMarker mk = this.markers[k];
                mk.resetOrientation();
            }
        }
        finally {
            for (int k = 0; k < this.markers.length; ++k) {
                StyleMarker mk = this.markers[k];
                mk.resetOrientation();
            }
        }
    }

    public static class MarkerPosition {
        StyleMarker marker;
        float x;
        float y;
        float angle;
        float drawPercentage;
    }
}

