/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stream;

import java.awt.Color;
import java.awt.Font;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.SimpleGeometry;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AreaStyleModel;
import oracle.mapviewer.share.style.ColorStyleModel;
import oracle.mapviewer.share.style.LineStyleModel;
import oracle.mapviewer.share.style.MarkerStyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.stylex.BucketSeries;
import oracle.mapviewer.share.stylex.VariableMarkerStyleModel;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyleCache;
import oracle.sdovis.stream.GeoJsonUtils2;
import oracle.sdovis.stream.GeometryFeaturePump;
import oracle.sdovis.style.StyleArea;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.spatial.geometry.JGeometry;

public class StyleJsonUtil {
    public static String styleAreaToJSON(StyleArea style, String name, StyleCache sc) {
        StringBuilder res = new StringBuilder(100);
        AreaStyleModel bean = (AreaStyleModel)style.getModel();
        res.append("{name:\"" + name + "\",type:\"area\"");
        String borderStyleName = bean.getBorderStyleName();
        Color borderColor = bean.getBorderColor();
        Color fillColor = bean.getFillColor();
        float borderWidth = bean.getBorderWidth();
        if (borderStyleName != null || borderColor != null) {
            if (borderStyleName != null) {
                res.append(",stroke:\"" + XMLUtil.replaceXMLEntities(borderStyleName) + "\"");
            } else if (borderColor != null) {
                res.append("," + StyleJsonUtil.getJSONStrokeDef(borderColor, borderWidth, null));
            }
        }
        if (fillColor != null) {
            res.append("," + StyleJsonUtil.getJSONFillDef(fillColor));
        }
        res.append("}");
        if (borderStyleName != null) {
            StyleLine lsty = (StyleLine)sc.get(borderStyleName);
            res.append(", " + StyleJsonUtil.styleLineToJSON(lsty, borderStyleName));
        }
        return res.toString();
    }

    public static String styleColorToJSON(StyleColor style, String name) {
        ColorStyleModel bean = (ColorStyleModel)style.getModel();
        StringBuilder res = new StringBuilder(100);
        res.append("{name:\"" + name + "\",type:\"color\"");
        Color strokeColor = bean.getStrokeColor();
        float strokeWidth = bean.getStrokeWidth();
        Color fillColor = bean.getFillColor();
        if (strokeColor != null) {
            res.append("," + StyleJsonUtil.getJSONStrokeDef(strokeColor, strokeWidth, null));
        }
        if (fillColor != null) {
            res.append("," + StyleJsonUtil.getJSONFillDef(fillColor));
        }
        res.append("}");
        return res.toString();
    }

    public static String styleLineToJSON(StyleLine style, String name) {
        Color centerLineColor;
        int cap;
        LineStyleModel bean = (LineStyleModel)style.getModel();
        StringBuilder res = new StringBuilder(100);
        res.append("{name:\"" + name + "\",type:\"line\"");
        String isCased = bean.isCased() ? ",cased:\"true\"" : "";
        Color strokeColor = bean.getFillColor();
        SizeDefinition lineWidth = bean.getLineWidthSize();
        if (lineWidth.getValue() > 0.0) {
            String unit = "";
            if (lineWidth.getUnit() != null && !lineWidth.getUnit().equalsIgnoreCase("px")) {
                unit = lineWidth.getUnit();
            }
            res.append("," + StyleJsonUtil.getJSONStrokeDef(strokeColor, lineWidth.getValue(), unit));
        }
        if ((cap = bean.getCap()) == 2) {
            res.append(",strokeLineCap:\"SQUARE\"");
        } else if (cap == 0) {
            res.append(",strokeLineCap:\"BUTT\"");
        } else {
            res.append(",strokeLineCap:\"ROUND\"");
        }
        int join = bean.getJoin();
        if (join == 2) {
            res.append(",strokeLineJoin:\"BEVEL\"");
        } else if (join == 0) {
            res.append(",strokeLineJoin:\"MITER\"");
        } else {
            res.append(",strokeLineJoin:\"ROUND\"");
        }
        int sublines = 0;
        Color wingColor = bean.getWingColor();
        if (wingColor != null) {
            ++sublines;
            res.append(",wingLine:{");
            SizeDefinition wingWidth = bean.getWingWidthSize();
            res.append(StyleJsonUtil.getJSONStrokeDef(wingColor, wingWidth.getValue(), wingWidth.getUnit()));
            res.append(StyleJsonUtil.getJSONDashPattern(bean.getWingDashPattern(), bean.getWingDashPatternUnit()));
            res.append("}");
        }
        if ((centerLineColor = bean.getCenterLineColor()) != null) {
            ++sublines;
            res.append(",centerLine:{");
            SizeDefinition centerLineWidth = bean.getCenterLineWidthSize();
            res.append(StyleJsonUtil.getJSONStrokeDef(centerLineColor, centerLineWidth.getValue(), centerLineWidth.getUnit()));
            res.append(StyleJsonUtil.getJSONDashPattern(bean.getCenterLineDashPattern(), bean.getCenterLineDashPatternUnit()));
            res.append("}");
        }
        res.append("}");
        return res.toString();
    }

    public static String styleMarkerToJSON(StyleMarker style, String name) {
        StringBuilder sb = new StringBuilder(100);
        MarkerStyleModel bean = (MarkerStyleModel)style.getModel();
        sb.append("{name:\"" + name + "\",type:\"marker\"");
        int markerType = bean.getMarkerType();
        sb.append(",markerType:\"" + StyleJsonUtil.getMarkerTypeString(markerType) + "\"");
        String fonts = "";
        Font labelFont = bean.getLabelFont();
        if (labelFont != null) {
            SizeDefinition labelFontSize = bean.getLabelFontSize();
            sb.append(",label:{");
            sb.append(StyleJsonUtil.getJSONFontDef(labelFont, new SizeDefinition2D(labelFontSize.getValue(), -1.0, labelFontSize.getUnit())));
            Color labelFontColor = bean.getLabelFontColor();
            if (labelFontColor != null) {
                sb.append("," + StyleJsonUtil.getJSONFillDef(labelFontColor));
            }
            SizeDefinition2D labelOffset = bean.getLabelOffsetSize();
            double labelOffsetX = labelOffset.getWidth();
            double labelOffsetY = labelOffset.getHeight();
            if (labelOffset.isPixelUnit()) {
                if (labelOffsetX != 0.0) {
                    sb.append(",offsetX:" + String.valueOf((int)labelOffsetX));
                }
                if (labelOffsetY != 0.0) {
                    sb.append(",offsetY:" + String.valueOf((int)labelOffsetY));
                }
            } else {
                if (labelOffsetX != 0.0) {
                    String loffx = StyleUtils.getUSLocaleFormat(labelOffsetX);
                    loffx = StyleUtils.cleanDecimalZeros(loffx, 1);
                    fonts = fonts + ",offsetX:" + loffx;
                }
                if (labelOffsetY != 0.0) {
                    String loffy = StyleUtils.getUSLocaleFormat(labelOffsetY);
                    loffy = StyleUtils.cleanDecimalZeros(loffy, 1);
                    fonts = fonts + ",offsetY:" + loffy;
                }
            }
            if (labelOffset.getUnit() != null && !labelOffset.getUnit().equalsIgnoreCase("px")) {
                sb.append(",offsetUnit:\"" + labelOffset.getUnit() + "\"");
            }
            sb.append("}");
        }
        String forcedUnit = "";
        SizeDefinition2D markerSize = bean.getMarkerSize();
        if (markerSize.getUnit() != null && !markerSize.getUnit().equalsIgnoreCase("px")) {
            sb.append(",sizeUnit:\"" + markerSize.getUnit() + "\"");
        }
        String mkwdStr = String.valueOf(markerSize.getWidth());
        String mkhtStr = String.valueOf(markerSize.getHeight());
        if (markerSize.isPixelUnit()) {
            mkwdStr = String.valueOf((int)markerSize.getWidth());
            mkhtStr = String.valueOf((int)markerSize.getHeight());
        }
        sb.append(",width:" + mkwdStr + ",height:" + mkhtStr);
        String anchorElem = "";
        double[] anchorPoint = bean.getAnchorPoint();
        if (anchorPoint[0] != 0.5 || anchorPoint[1] != 0.5) {
            sb.append(",anchorX:" + anchorPoint[0] + ",anchorY:" + anchorPoint[1]);
        }
        if (markerType == 1 || markerType == 2 || markerType == 4 || markerType == 3) {
            sb.append("," + StyleJsonUtil.getJSONFillDef(bean.getVectorFillColor()));
            sb.append("," + StyleJsonUtil.getJSONStrokeDef(bean.getVectorStrokeColor(), bean.getVectorStrokeWidth(), null));
            sb.append(",shape:");
            JGeometry geom = null;
            double[] vector = bean.getVector();
            switch (markerType) {
                case 3: {
                    geom = JGeometry.createCircle((double)0.0, (double)0.0, (double)1.0, (int)-1);
                    break;
                }
                case 1: {
                    if (vector == null || vector.length % 2 != 0) break;
                    geom = JGeometry.createLinearPolygon((double[])vector, (int)2, (int)-1);
                    break;
                }
                case 2: {
                    if (vector == null || vector.length % 2 != 0) break;
                    geom = JGeometry.createLinearLineString((double[])vector, (int)2, (int)-1);
                    break;
                }
                case 4: {
                    if (vector == null || vector.length != 4) break;
                    geom = new JGeometry(vector[0], vector[1], vector[2], vector[3], -1);
                }
            }
            if (geom != null) {
                sb.append(StyleJsonUtil.geometryToJSON(geom));
            }
        } else {
            if (markerType == 5 || markerType == 6) {
                return sb.append("}").toString();
            }
            if (markerType == 7) {
                String rawSVGString = bean.getRawSVGString();
                return sb.append("}").toString();
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public static String styleTextToJSON(StyleText stext, String name) {
        String v;
        Object mta;
        StringBuilder sb = new StringBuilder(100);
        TextStyleModel bean = (TextStyleModel)stext.getModel();
        sb.append("{name:\"" + name + "\",type:\"text\"");
        Font font = bean.getFont();
        Font textFont = null;
        textFont = font == null ? bean.getDefaultFont() : font;
        SizeDefinition2D fontSizes = bean.getFontSizes();
        sb.append("," + StyleJsonUtil.getJSONFontDef(textFont, fontSizes));
        sb.append("," + StyleJsonUtil.getJSONFillDef(bean.getColor()));
        Color background = bean.getBackground();
        if (background != null) {
            sb.append(",background:{" + StyleJsonUtil.getJSONFillDef(background) + "}");
        }
        String floatwidth = "";
        String floatwidthunit = "";
        SizeDefinition haloWidth = bean.getHaloSize();
        if (haloWidth.getUnit() != null && !haloWidth.getUnit().equalsIgnoreCase("px")) {
            floatwidthunit = ",floatWidthUnit:\"" + haloWidth.getUnit() + "\"";
        }
        String hwdStr = StyleUtils.getUSLocaleFormat(haloWidth.getValue());
        String hwStr = StyleUtils.cleanDecimalZeros(hwdStr, 1);
        if (haloWidth.isPixelUnit()) {
            hwStr = StyleUtils.cleanDecimalZeros(hwdStr, 0);
        }
        if (haloWidth.getValue() > 0.0 && !haloWidth.isPixelUnit() || haloWidth.getValue() >= 1.0 && haloWidth.isPixelUnit()) {
            Color haloColor;
            sb.append(",floatWidth:" + hwStr);
            if (!haloWidth.isPixelUnit()) {
                sb.append(floatwidthunit);
            }
            if ((haloColor = bean.getHaloColor()) != Color.white) {
                sb.append(",floatColor:{" + StyleJsonUtil.getJSONFillDef(haloColor) + "}");
            }
        }
        if ((mta = bean.getLabelingHints().get(LabelingHints.KEY_MULTILINE_TEXT_ALIGN)) != null) {
            sb.append(",multiLineAlign:\"");
            String a = LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_CENTER == mta ? "center" : (LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_RIGHT == mta ? "right" : "left");
            sb.append(a + "\"");
        }
        String tdecoration = "";
        String textDecoration = bean.getTextDecoration();
        if (!textDecoration.equalsIgnoreCase(TextStyleModel.TEXT_DECORATION_NONE)) {
            sb.append(",textDecoration:\"" + textDecoration.toLowerCase() + "\"");
        }
        LabelingHints labelingHints = bean.getLabelingHints();
        Object halign = labelingHints.get(LabelingHints.KEY_OPOINT_HALIGN);
        Object valign = labelingHints.get(LabelingHints.KEY_OPOINT_VALIGN);
        if (halign != null || valign != null) {
            if (halign == null) {
                halign = LabelingHints.VALUE_OPOINT_HALIGN_CENTER;
            }
            if (valign == null) {
                valign = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE;
            }
            sb.append(",oPointOptions:{");
            if (halign != null) {
                String h = halign == LabelingHints.VALUE_OPOINT_HALIGN_CENTER ? "center" : (halign == LabelingHints.VALUE_OPOINT_HALIGN_START ? "start" : "end");
                sb.append("halign:\"" + h + "\"");
            }
            if (valign != null) {
                String string = valign == LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE ? "middle" : (valign == LabelingHints.VALUE_OPOINT_VALIGN_TOP ? "top" : (v = valign == LabelingHints.VALUE_OPOINT_VALIGN_BOTTOM ? "bottom" : "baseline"));
                if (halign != null) {
                    sb.append(",");
                }
                sb.append("valign:\"" + v + "\"");
            }
            sb.append("}");
        }
        valign = null;
        valign = labelingHints.get(LabelingHints.KEY_LINE_VALIGN);
        if (valign != null) {
            sb.append(",pathOptions:{");
            v = valign == LabelingHints.VALUE_LINE_VALIGN_MIDDLE ? "middle" : (valign == LabelingHints.VALUE_LINE_VALIGN_TOP ? "top" : (valign == LabelingHints.VALUE_LINE_VALIGN_BOTTOM ? "bottom" : "baseline"));
            sb.append("valign:\"" + v + "\"");
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String varirableMarkerStyleToJSON(VariableMarkerStyle style, String name, StyleCache sc) {
        VariableMarkerStyleModel bean = (VariableMarkerStyleModel)style.getModel();
        StringBuilder sb = new StringBuilder(200);
        sb.append("{name:\"" + name + "\",type:\"variable_marker\"");
        String unit = bean.getSizesUnit();
        if (unit != null && !unit.equalsIgnoreCase("px")) {
            sb.append(",sizeUnit:\"" + unit + "\"");
        }
        sb.append(",startSize:" + bean.getStartSize());
        sb.append(",increment:" + bean.getIncrement());
        String baseMarkerName = bean.getBaseMarkerName();
        sb.append(",baseMarker:\"" + baseMarkerName + "\"");
        BucketSeries bs = bean.getBucketSeries();
        sb.append(",buckets:");
        sb.append("}");
        StyleMarker lsty = (StyleMarker)sc.get(baseMarkerName);
        sb.append(", " + StyleJsonUtil.styleMarkerToJSON(lsty, baseMarkerName));
        return sb.toString();
    }

    private static String getJSONFontDef(Font font, SizeDefinition2D fontSizes) {
        StringBuilder sb = new StringBuilder(50);
        int style = font.getStyle();
        sb.append("fontFamily:\"" + font.getFamily() + "\"");
        if (font.isItalic()) {
            sb.append(",fontStyle:\"italic\"");
        }
        float size = (float)fontSizes.getWidth();
        String sizeStr = String.valueOf(size);
        if (fontSizes.isPixelUnit()) {
            sizeStr = String.valueOf((int)size);
        }
        sb.append(",fontSize:" + sizeStr);
        float minsize = (float)fontSizes.getHeight();
        if ((double)minsize > 0.0) {
            String minsizeStr = String.valueOf(minsize);
            if (fontSizes.isPixelUnit()) {
                minsizeStr = String.valueOf((int)minsize);
            }
            sb.append(",minfontSize:" + minsizeStr);
        }
        String sizeUnit = "";
        if (fontSizes.getUnit() != null && !fontSizes.getUnit().equalsIgnoreCase("px")) {
            sizeUnit = fontSizes.getUnit();
            sb.append(",fontSizeUnit:\"" + sizeUnit + "\"");
        }
        String weight = "";
        if (font.isBold()) {
            sb.append(",fontWeight:\"bold\"");
        }
        return sb.toString();
    }

    private static String getJSONStrokeDef(Color color, double width, String widthUnit) {
        String sw = ",strokeThickness:" + (width > 0.0 ? width : 1.0);
        String opa = color.getAlpha() < 255 ? ",strokeOpacity:" + color.getAlpha() : "";
        String wu = widthUnit != null && widthUnit.length() > 0 ? ",strokeThicknessUnit:\"" + widthUnit + "\"" : "";
        return "stroke:\"" + StyleUtils.getHexidecimalString(color) + "\"" + sw + opa + wu;
    }

    private static String getJSONFillDef(Color color) {
        String res = "fill:\"" + StyleUtils.getHexidecimalString(color) + "\"";
        int alpha = color.getAlpha();
        if (alpha < 255) {
            res = res + ",fillOpacity:" + alpha;
        }
        return res;
    }

    private static String arrayToJSONString(float[] array) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("[");
        if (array != null && array.length > 0) {
            sb.append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                sb.append("," + array[i]);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private static String getJSONDashPattern(float[] dashPattern, String unit) {
        String res = "";
        if (dashPattern != null && dashPattern.length > 0) {
            res = ",dash:" + StyleJsonUtil.arrayToJSONString(dashPattern);
            if (unit != null && !unit.equalsIgnoreCase("px")) {
                res = res + ",dashUnit:\"" + unit + "\"";
            }
        }
        return res;
    }

    private static String getMarkerTypeString(int type) {
        if (type == 1) {
            return "polygon";
        }
        if (type == 2) {
            return "polyline";
        }
        if (type == 3) {
            return "circle";
        }
        if (type == 4) {
            return "rectangle";
        }
        if (type == 5) {
            return "image";
        }
        if (type == 7) {
            return "SVG";
        }
        return "TTF";
    }

    private static String geometryToJSON(JGeometry geom) {
        SimpleGeometry g = GeometryFeaturePump.toSimpleGeometry(JSDOGeometry.recast(geom));
        StringBuilder sb = new StringBuilder(100);
        GeoJsonUtils2.simpleGeometry2GeoJson(g, sb, GeoJsonUtils2.getNumberFormat(0), false);
        return sb.toString();
    }
}

