/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import javax.vecmath.Vector3d;
import oracle.sdovis.raytracing.Hit;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.PhongMaterial;
import oracle.sdovis.raytracing.Plane;
import oracle.sdovis.raytracing.Ray;

public class TextureMap
extends Material {
    Material basemat;
    double[][] demdata;
    Vector3d[][] normalmap;
    Vector3d[][] xvmap;
    Vector3d[][] yvmap;
    int width;
    int height;
    int imWidth;
    int imHeight;
    int numBands;
    Vector3d u;
    Vector3d v;
    Vector3d w;
    boolean image_only = false;
    int g = 1;

    public TextureMap(Vector3d diff, Vector3d spec, double exponent, Vector3d trans, Vector3d refl, double refr, double[][] demdata_, int numbands, int imw, int imh) {
        super(diff, trans, refl, refr);
        this.demdata = demdata_;
        this.width = imw;
        this.height = imh;
        this.numBands = numbands;
        this.xvmap = new Vector3d[this.height][this.width];
        this.yvmap = new Vector3d[this.height][this.width];
        this.normalmap = new Vector3d[this.height][this.width];
        this.basemat = new PhongMaterial(diff, spec, exponent, trans, refl, refr);
        this.calcNormalMap();
    }

    @Override
    public Vector3d shade(Ray r, Hit h, Vector3d dirToLight, Vector3d lightColor) {
        Hit newh = new Hit(h.getT(), h.getMaterial());
        Vector3d ro = r.getOrigin();
        Vector3d rd = r.getDirection();
        double xc = ro.x + rd.x * h.getT();
        double yc = ro.y + rd.y * h.getT();
        int rdx_pix = (int)(xc * (double)this.width);
        int rdy_pix = (int)(yc * (double)this.height);
        ((Plane)h.getObject()).setWindow(this.width, this.height);
        Vector3d txcoords = h.getObject().getTextureCoordinates(h, r);
        if (txcoords != null) {
            double u = txcoords.x;
            double v = txcoords.y;
            Vector3d origin = h.getObject().getOrigin();
            Vector3d testcolor = new Vector3d();
            int outy = (int)(v * (double)(this.height - 1));
            int outx = (int)(u * (double)(this.width - 1));
            int outx1 = outx * this.numBands;
            if (this.numBands >= 3) {
                if (this.image_only) {
                    h.getMaterial().setDiffuseColor(new Vector3d(this.demdata[outy][outx1] / 255.0, this.demdata[outy][outx1 + 1] / 255.0, this.demdata[outy][outx1 + 2] / 255.0));
                    testcolor = new Vector3d(this.demdata[outy][outx1] / 255.0, this.demdata[outy][outx1 + 1] / 255.0, this.demdata[outy][outx1 + 2] / 255.0);
                }
            } else if (this.image_only) {
                h.getMaterial().setDiffuseColor(new Vector3d(this.demdata[outy][outx1] / 255.0, this.demdata[outy][outx1] / 255.0, this.demdata[outy][outx1] / 255.0));
                testcolor = new Vector3d(this.demdata[outy][outx1] / 255.0, this.demdata[outy][outx1] / 255.0, this.demdata[outy][outx1] / 255.0);
            } else {
                Vector3d newnorm = this.normalmap[outy][outx1];
                Vector3d on = h.getNormal();
                h.setNormal(this.normalmap[outy][outx1]);
            }
        }
        return this.basemat.shade(r, h, dirToLight, lightColor);
    }

    public void calcNormalMap() {
        for (int y = 0; y < this.demdata.length; ++y) {
            for (int x = 0; x < this.demdata[y].length; ++x) {
                Vector3d t2;
                Vector3d t1;
                double x_gradient = 0.0;
                double y_gradient = 0.0;
                x_gradient = x == 0 || x - this.g < 0 ? this.demdata[y][x + this.g] : (x == this.demdata[y].length - 1 || x + this.g > this.demdata[y].length - 1 ? -this.demdata[y][x - this.g] : this.demdata[y][x + this.g] - this.demdata[y][x - this.g]);
                y_gradient = y == 0 || y - this.g < 0 ? this.demdata[y + this.g][x] : (y == this.demdata.length - 1 || y + this.g > this.demdata.length - 1 ? -this.demdata[y - this.g][x] : this.demdata[y + this.g][x] - this.demdata[y - this.g][x]);
                this.xvmap[y][x] = t1 = new Vector3d(1.0, 0.0, x_gradient);
                this.yvmap[y][x] = t2 = new Vector3d(0.0, 1.0, y_gradient);
                Vector3d normal = new Vector3d();
                normal.cross(t1, t2);
                this.normalmap[y][x] = normal;
            }
        }
    }
}

