/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import java.util.Vector;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import oracle.sdovis.raytracing.LightSource;

public class PointLight
extends LightSource {
    Vector3d position;
    Vector3d color;
    double attenuation1;
    double attenuation2;
    double attenuation3;

    public PointLight() {
        this.position = new Vector3d();
        this.color = new Vector3d(1.0, 1.0, 1.0);
    }

    public PointLight(Vector3d p, Vector3d c, double att1, double att2, double att3) {
        this.position = p;
        this.color = c;
        this.attenuation1 = att1;
        this.attenuation2 = att2;
        this.attenuation3 = att3;
    }

    @Override
    public Vector getIllumination(Vector3d p) {
        Vector<Object> v = new Vector<Object>();
        Vector3d dir = new Vector3d();
        dir.sub((Tuple3d)this.position, (Tuple3d)p);
        double distanceToLight = dir.length();
        dir.normalize();
        double att = 1.0 / (this.attenuation1 + this.attenuation2 * distanceToLight + this.attenuation3 * distanceToLight * distanceToLight);
        if (att < 0.0) {
            att = 0.0;
        }
        Vector3d col = new Vector3d();
        col.scale(att, (Tuple3d)this.color);
        v.addElement(dir);
        v.addElement(col);
        v.addElement(new Double(distanceToLight));
        return v;
    }
}

