/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.georss;

import java.util.ArrayList;
import java.util.List;
import oracle.mapviewer.share.Field;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.georss.GeoFeedParser;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AtomParser
extends GeoFeedParser {
    private Document doc;
    private String dataSrc;

    public AtomParser(String dsrc) {
        this.dataSrc = dsrc;
    }

    @Override
    public StyledFeatureI[] parse(Document content) throws Exception {
        this.doc = content;
        ArrayList<StyledFeatureI> features = new ArrayList<StyledFeatureI>();
        this.parseRoot(features);
        NodeList nl = this.doc.getElementsByTagName("entry");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node ent = nl.item(i);
            StyledFeatureI f = this.extractFeature(ent);
            if (f == null) continue;
            features.add(f);
        }
        return features.toArray(new StyledFeatureI[features.size()]);
    }

    protected void parseRoot(List features) {
        NodeList ndList = this.doc.getElementsByTagName("feed");
        if (ndList == null) {
            return;
        }
        Node nd = ndList.item(0);
        StyledFeatureI f = this.extractFeature(nd);
        if (f != null) {
            features.add(f);
        }
    }

    protected StyledFeatureI extractFeature(Node node) {
        Field f;
        JSDOGeometry geom;
        StyledFeature sf = null;
        String title = null;
        Node _title = XMLDOMParser.getSubElement(node, "title");
        if (_title != null) {
            title = XMLDOMParser.getElementValue(_title);
        }
        String id = null;
        Node _id = XMLDOMParser.getSubElement(node, "id");
        if (_id != null) {
            id = XMLDOMParser.getElementValue(_id);
        }
        String updated = null;
        Node _updated = XMLDOMParser.getSubElement(node, "updated");
        if (_updated != null) {
            updated = XMLDOMParser.getElementValue(_updated);
        }
        String summary = null;
        Node _summary = XMLDOMParser.getSubElement(node, "summary");
        if (_summary != null) {
            summary = XMLDOMParser.getElementValue(_summary);
        }
        String content = null;
        Node _content = XMLDOMParser.getSubElement(node, "content");
        if (_content != null) {
            content = XMLDOMParser.getElementValue(_content);
        }
        String link = null;
        Node _link = XMLDOMParser.getSubElement(node, "link");
        if (_link != null) {
            link = XMLDOMParser.getElementValue(_link);
        }
        if ((geom = AtomParser.extractLocation(node)) == null) {
            return null;
        }
        sf = new StyledFeature();
        sf.setLabel(id);
        ArrayList<Field> fields = new ArrayList<Field>(5);
        if (id != null) {
            f = new Field(id);
            f.setNameAndKey("Id", true, "Id");
            fields.add(f);
        }
        if (title != null) {
            f = new Field(title);
            f.setNameAndKey("Title", false, "Title");
            fields.add(f);
        }
        if (updated != null) {
            f = new Field(updated);
            f.setNameAndKey("Updated", false, "Updated");
            fields.add(f);
        }
        if (summary != null) {
            f = new Field(summary);
            f.setNameAndKey("Summary", false, "Summary");
            fields.add(f);
        } else if (content != null) {
            f = new Field(content);
            f.setNameAndKey("Content", false, "Content");
            fields.add(f);
        } else if (link != null) {
            f = new Field(link);
            f.setNameAndKey("Link", false, "Link");
            fields.add(f);
        }
        sf.setDataSource(this.dataSrc);
        sf.setGeometry(geom);
        sf.setIdentifiableAttributes(fields.toArray(new Field[fields.size()]));
        return sf;
    }
}

