/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.edit.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import oracle.sdovis.edit.util.GeometryUtil;
import oracle.sdovis.edit.util.JGeometryElementInfo;
import oracle.sdovis.edit.util.JGeometrySegment;
import oracle.sdovis.edit.util.JGeometrySegmentPoint;
import oracle.spatial.geometry.JGeometry;

public class JGeometryUtil {
    private static final int STYPE_POINT = 0;
    private static final int STYPE_ORIENTED_POINT = 1;
    private static final int STYPE_CURVE = 2;
    private static final int STYPE_POLYGON = 3;

    private static int getGeomSimpleType(JGeometry geom) {
        int gt = geom.getType();
        switch (gt) {
            case 1: 
            case 5: {
                if (geom.isOrientedPoint() || geom.isOrientedMultiPoint()) {
                    return 1;
                }
                return 0;
            }
            case 2: 
            case 6: {
                return 2;
            }
            case 3: 
            case 7: {
                return 3;
            }
        }
        return -1;
    }

    public static JGeometry append(JGeometry[] geoms) throws Exception {
        return JGeometryUtil.append(geoms, false);
    }

    public static JGeometry append(JGeometry[] geoms, boolean forceCollection) throws Exception {
        if (geoms == null || geoms.length == 0) {
            return null;
        }
        if (geoms.length == 1) {
            return geoms[0];
        }
        boolean makeCollection = forceCollection;
        int dim = -1;
        int srid = -1;
        int numElemInfo = 0;
        int numOrds = 0;
        for (JGeometry geom : geoms) {
            if (dim == -1) {
                dim = geom.getDimensions();
            } else if (geom.getDimensions() != dim) {
                throw new Exception("Geometries have different dimensions");
            }
            if (numOrds == 0) {
                srid = geom.getSRID();
            } else if (geom.getSRID() != srid) {
                throw new Exception("Geometries have different SRIDs");
            }
            int[] elemEInfo = geom.getElemInfo();
            if (elemEInfo == null) {
                numElemInfo += 3;
                numOrds += geom.getDimensions();
                continue;
            }
            numElemInfo += elemEInfo.length;
            numOrds += geom.getOrdinatesArray().length;
            if (makeCollection || geom.getType() != 4) continue;
            makeCollection = true;
        }
        int[] elemInfo = new int[numElemInfo];
        double[] ords = new double[numOrds];
        int lastSType = -1;
        int lastOrd = 0;
        int lastElemInfo = 0;
        for (JGeometry geom : geoms) {
            for (JGeometry elem : JGeometryUtil.getElements(geom)) {
                if (!makeCollection) {
                    if (lastSType == -1) {
                        lastSType = JGeometryUtil.getGeomSimpleType(elem);
                    } else if (JGeometryUtil.getGeomSimpleType(elem) != lastSType) {
                        makeCollection = true;
                    }
                }
                int[] elemEInfo = elem.getElemInfo();
                double[] elemOrds = null;
                if (elemEInfo == null) {
                    elemInfo[lastElemInfo++] = 1 + lastOrd;
                    elemInfo[lastElemInfo++] = 1;
                    elemInfo[lastElemInfo++] = 1;
                    elemOrds = elem.getPoint();
                } else {
                    for (int i = 0; i < elemEInfo.length / 3; ++i) {
                        elemInfo[lastElemInfo++] = elemEInfo[i * 3 + 0] + lastOrd;
                        elemInfo[lastElemInfo++] = elemEInfo[i * 3 + 1];
                        elemInfo[lastElemInfo++] = elemEInfo[i * 3 + 2];
                    }
                    elemOrds = elem.getOrdinatesArray();
                }
                System.arraycopy(elemOrds, 0, ords, lastOrd, elemOrds.length);
                lastOrd += elemOrds.length;
            }
        }
        int outType = -1;
        if (makeCollection) {
            outType = 4;
        } else {
            switch (lastSType) {
                case 0: 
                case 1: {
                    outType = 5;
                    break;
                }
                case 2: {
                    outType = 6;
                    break;
                }
                case 3: {
                    outType = 7;
                }
            }
        }
        return new JGeometry(dim * 1000 + outType, srid, elemInfo, ords);
    }

    public static Point2D[] getJavaPoints(JGeometry geom) {
        if (geom == null) {
            return null;
        }
        JGeometry[] geoelem = JGeometryUtil.getElements(geom);
        if (geoelem == null || geoelem.length == 0) {
            return null;
        }
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (int k = 0; k < geoelem.length; ++k) {
            int dim = geoelem[k].getDimensions();
            double[] oords = geoelem[k].getOrdinatesArray();
            if (geoelem[k].isPoint()) {
                Point2D pt = geoelem[k].getJavaPoint();
                if (pt == null) continue;
                points.add(pt);
                continue;
            }
            if (oords == null) continue;
            for (int l = 0; l < oords.length / dim; ++l) {
                points.add(new Point2D.Double(oords[dim * l], oords[dim * l + 1]));
            }
        }
        if (points.size() == 0) {
            return null;
        }
        return points.toArray(new Point2D[points.size()]);
    }

    public static Point2D[][] getBoundaryOfElement(JGeometry geom, int element) {
        Point2D[][] boundary = null;
        if (geom == null) {
            return null;
        }
        JGeometry[] elems = JGeometryUtil.getElements(geom);
        if (elems == null || elems.length == 0) {
            return null;
        }
        if (element < 0 || element >= elems.length) {
            return null;
        }
        JGeometry geoelem = elems[element];
        boundary = JGeometryUtil.getBoundary(geoelem);
        return boundary;
    }

    public static Point2D[][] getBoundary(JGeometry geoelem) {
        Point2D[][] boundary = null;
        if (geoelem == null) {
            return null;
        }
        int gtype = geoelem.getType();
        if (gtype != 1 && gtype != 2 && gtype != 3) {
            return null;
        }
        int dim = geoelem.getDimensions();
        int[] elemInfo = geoelem.getElemInfo();
        double[] oords = geoelem.getOrdinatesArray();
        if (geoelem.isPoint()) {
            boundary = new Point2D[][]{new Point2D[1]};
            boundary[0][0] = geoelem.getJavaPoint();
        } else if (geoelem.isRectangle()) {
            boundary = new Point2D[][]{new Point2D[5]};
            boundary[0][0] = new Point2D.Double(oords[0], oords[1]);
            boundary[0][1] = new Point2D.Double(oords[0], oords[dim + 1]);
            boundary[0][2] = new Point2D.Double(oords[dim], oords[dim + 1]);
            boundary[0][3] = new Point2D.Double(oords[dim], oords[1]);
            boundary[0][4] = new Point2D.Double(oords[0], oords[1]);
        } else if (geoelem.isCircle()) {
            boundary = new Point2D[][]{JGeometryUtil.getBoundaryFromCircleOordinates(oords, dim, 200)};
        } else if (geoelem.getType() == 3) {
            int etype = elemInfo[1];
            if (etype == 1005 || etype == 2005) {
                boundary = new Point2D[][]{JGeometryUtil.getBoundaryFromCompoundOordinates(oords, elemInfo, dim, 100)};
            } else {
                int einterp = elemInfo[2];
                if (einterp == 2) {
                    boundary = new Point2D[][]{JGeometryUtil.getBoundaryFromArcOordinates(oords, dim, 100)};
                } else {
                    int nelems = elemInfo.length / 3;
                    boundary = new Point2D[nelems][];
                    for (int i = 0; i < nelems; ++i) {
                        int interp = elemInfo[3 * i + 2];
                        int startIndex = elemInfo[3 * i] - 1;
                        int endIndex = oords.length - 1;
                        if (i < nelems - 1) {
                            endIndex = elemInfo[3 * (i + 1)] - 2;
                        }
                        boundary[i] = interp == 3 ? JGeometryUtil.getBoundaryFromRectangleOordinates(oords, dim, startIndex) : JGeometryUtil.getBoundaryFromOordinatesRange(oords, dim, startIndex, endIndex);
                    }
                }
            }
        } else if (geoelem.getType() == 2) {
            int type;
            int etype = elemInfo[1];
            boundary = etype == 4 ? new Point2D[][]{JGeometryUtil.getBoundaryFromCompoundOordinates(oords, elemInfo, dim, 100)} : ((type = elemInfo[2]) == 2 ? new Point2D[][]{JGeometryUtil.getBoundaryFromArcOordinates(oords, dim, 100)} : new Point2D[][]{JGeometryUtil.getBoundaryFromOordinates(oords, dim)});
        } else {
            return null;
        }
        return boundary;
    }

    public static Point2D[] getBoundaryFromOordinates(double[] oords, int dim) {
        if (oords == null) {
            return null;
        }
        ArrayList<Point2D.Double> linepoints = new ArrayList<Point2D.Double>();
        int npts = oords.length / dim;
        for (int i = 0; i < npts; ++i) {
            linepoints.add(new Point2D.Double(oords[dim * i], oords[dim * i + 1]));
        }
        if (linepoints.size() == 0) {
            return null;
        }
        return linepoints.toArray(new Point2D[linepoints.size()]);
    }

    public static Point2D[] getBoundaryFromArcOordinates(double[] oords, int dim, int arcPoints) {
        if (oords == null) {
            return null;
        }
        ArrayList<Point2D.Double> linepoints = new ArrayList<Point2D.Double>();
        for (int l = 0; l < oords.length - dim; l += dim * 2) {
            Point2D.Double pt1 = new Point2D.Double(oords[l], oords[l + 1]);
            Point2D.Double pt2 = new Point2D.Double(oords[l + dim], oords[l + dim + 1]);
            Point2D.Double pt3 = new Point2D.Double(oords[l + 2 * dim], oords[l + 2 * dim + 1]);
            double[] arcpts = JGeometry.linearizeArc((double)((Point2D)pt1).getX(), (double)((Point2D)pt1).getY(), (double)((Point2D)pt2).getX(), (double)((Point2D)pt2).getY(), (double)((Point2D)pt3).getX(), (double)((Point2D)pt3).getY(), (int)arcPoints);
            if (arcpts == null) {
                return null;
            }
            int nvertexes = arcpts.length / 2;
            int start = 0;
            if (l > 0) {
                start = 1;
            }
            for (int m = start; m < nvertexes; ++m) {
                linepoints.add(new Point2D.Double(arcpts[2 * m], arcpts[2 * m + 1]));
            }
        }
        if (linepoints.size() == 0) {
            return null;
        }
        return linepoints.toArray(new Point2D[linepoints.size()]);
    }

    public static Point2D[] getBoundaryFromCircleOordinates(double[] oords, int dim, int numPoints) {
        if (oords == null) {
            return null;
        }
        ArrayList<Point2D.Double> linepoints = new ArrayList<Point2D.Double>();
        Point2D.Double pt1 = new Point2D.Double(oords[0], oords[1]);
        Point2D.Double pt2 = new Point2D.Double(oords[dim], oords[dim + 1]);
        Point2D.Double pt3 = new Point2D.Double(oords[2 * dim], oords[2 * dim + 1]);
        double[] res = JGeometry.linearizeArc((double)((Point2D)pt1).getX(), (double)((Point2D)pt1).getY(), (double)((Point2D)pt2).getX(), (double)((Point2D)pt2).getY(), (double)((Point2D)pt3).getX(), (double)((Point2D)pt3).getY(), (int)200);
        if (res == null) {
            return null;
        }
        int nvertexes = res.length / 2;
        for (int m = 0; m < nvertexes; ++m) {
            linepoints.add(new Point2D.Double(res[2 * m], res[2 * m + 1]));
        }
        if (linepoints.size() == 0) {
            return null;
        }
        return linepoints.toArray(new Point2D[linepoints.size()]);
    }

    public static Point2D[] getBoundaryFromOordinatesRange(double[] oords, int dim, int startIndex, int endIndex) {
        if (oords == null) {
            return null;
        }
        if (startIndex < 0 || endIndex < 0 || startIndex >= oords.length || endIndex >= oords.length || endIndex <= startIndex) {
            return null;
        }
        ArrayList<Point2D.Double> linepoints = new ArrayList<Point2D.Double>();
        for (int i = startIndex; i <= endIndex; i += dim) {
            linepoints.add(new Point2D.Double(oords[i], oords[i + 1]));
        }
        if (linepoints.size() == 0) {
            return null;
        }
        return linepoints.toArray(new Point2D[linepoints.size()]);
    }

    public static Point2D[] getBoundaryFromRectangleOordinates(double[] oords, int dim, int startIndex) {
        if (oords == null) {
            return null;
        }
        if (startIndex < 0 || startIndex >= oords.length) {
            return null;
        }
        ArrayList<Point2D.Double> linepoints = new ArrayList<Point2D.Double>();
        linepoints.add(new Point2D.Double(oords[startIndex], oords[startIndex + 1]));
        linepoints.add(new Point2D.Double(oords[startIndex], oords[startIndex + dim + 1]));
        linepoints.add(new Point2D.Double(oords[startIndex + dim], oords[startIndex + dim + 1]));
        linepoints.add(new Point2D.Double(oords[startIndex + dim], oords[startIndex + 1]));
        linepoints.add(new Point2D.Double(oords[startIndex], oords[startIndex + 1]));
        if (linepoints.size() == 0) {
            return null;
        }
        return linepoints.toArray(new Point2D[linepoints.size()]);
    }

    public static double[] getOordinatesSubset(double[] oords, int startIndex, int endIndex) {
        if (oords == null) {
            return null;
        }
        if (startIndex < 0 || endIndex < 0 || startIndex >= oords.length || endIndex >= oords.length || endIndex < startIndex) {
            return null;
        }
        int pos = 0;
        double[] subset = new double[endIndex - startIndex + 1];
        for (int i = startIndex; i <= endIndex; ++i) {
            subset[pos++] = oords[i];
        }
        return subset;
    }

    public static Point2D[] getBoundaryFromCompoundOordinates(double[] oords, int[] elemInfo, int dim, int arcPoints) {
        if (oords == null || elemInfo == null) {
            return null;
        }
        int nelems = elemInfo[2];
        ArrayList<Point2D.Double> linepoints = new ArrayList<Point2D.Double>();
        for (int i = 0; i < nelems; ++i) {
            int k;
            int endIndex;
            int startIndex;
            int interp = elemInfo[3 * (i + 1) + 2];
            if (interp == 1) {
                startIndex = elemInfo[3 * (i + 1)] - 1;
                endIndex = oords.length - 1;
                if (i < nelems - 1) {
                    endIndex = elemInfo[3 * (i + 2)] - 1;
                }
                for (k = startIndex; k <= endIndex; k += dim) {
                    if (k == startIndex && linepoints.size() > 0) continue;
                    linepoints.add(new Point2D.Double(oords[k], oords[k + 1]));
                }
                continue;
            }
            startIndex = elemInfo[3 * (i + 1)] - 1;
            endIndex = oords.length;
            if (i < nelems - 1) {
                endIndex = elemInfo[3 * (i + 2)];
            }
            for (k = startIndex; k < endIndex - dim; k += dim * 2) {
                Point2D.Double pt1 = new Point2D.Double(oords[startIndex], oords[startIndex + 1]);
                Point2D.Double pt2 = new Point2D.Double(oords[startIndex + dim], oords[startIndex + dim + 1]);
                Point2D.Double pt3 = new Point2D.Double(oords[startIndex + 2 * dim], oords[startIndex + 2 * dim + 1]);
                double[] arcpts = JGeometry.linearizeArc((double)((Point2D)pt1).getX(), (double)((Point2D)pt1).getY(), (double)((Point2D)pt2).getX(), (double)((Point2D)pt2).getY(), (double)((Point2D)pt3).getX(), (double)((Point2D)pt3).getY(), (int)arcPoints);
                if (arcpts == null) {
                    return null;
                }
                int nvertexes = arcpts.length / 2;
                for (int m = 0; m < nvertexes; ++m) {
                    if (m == 0 && linepoints.size() > 0) continue;
                    linepoints.add(new Point2D.Double(arcpts[2 * m], arcpts[2 * m + 1]));
                }
            }
        }
        if (linepoints.size() == 0) {
            return null;
        }
        return linepoints.toArray(new Point2D[linepoints.size()]);
    }

    public static JGeometry addVertex(JGeometry geom, JGeometrySegmentPoint interPT) {
        int i;
        if (geom == null || interPT == null) {
            return null;
        }
        int gtype = geom.getType();
        if (gtype == 1 || gtype == 5) {
            return null;
        }
        double[] oords = geom.getOrdinatesArray();
        if (oords == null) {
            return null;
        }
        int[] eInfo = geom.getElemInfo();
        if (eInfo == null) {
            return null;
        }
        JGeometrySegment segment = interPT.getSegment();
        Point2D point = interPT.getPoint();
        int ptLoc = interPT.getPointLocation();
        if (segment == null || point == null) {
            return null;
        }
        if (segment.getSegmentType() != JGeometrySegment.LINE_TYPE || ptLoc != 2) {
            return null;
        }
        int elemIndex = segment.getElementIndex();
        int segIndex = segment.getSegmentIndex();
        int subelemIndex = segment.getSubElementIndex();
        int dim = geom.getDimensions();
        JGeometryElementInfo[] elemsInfo = JGeometryUtil.getElementsInfo(geom, elemIndex + 1);
        if (elemsInfo == null || elemsInfo.length == 0) {
            return null;
        }
        int eiStart = elemsInfo[0].getElementInfoStart();
        int oordStart = elemsInfo[0].getElementOordStart();
        if (subelemIndex > 0) {
            oordStart = eInfo[eiStart + 3 * subelemIndex] - 1;
            eiStart += 3 * subelemIndex;
        }
        int offset = segIndex * dim;
        int[] elemInfo = new int[eInfo.length];
        System.arraycopy(eInfo, 0, elemInfo, 0, eInfo.length);
        double[] ordinates = new double[oords.length + dim];
        for (i = 0; i < oordStart + offset + dim; ++i) {
            ordinates[i] = oords[i];
        }
        ordinates[oordStart + offset + dim] = point.getX();
        ordinates[oordStart + offset + dim + 1] = point.getY();
        for (i = oordStart + offset + 2 * dim; i < ordinates.length; ++i) {
            ordinates[i] = oords[i - dim];
        }
        for (i = eiStart + 3; i < elemInfo.length; i += 3) {
            int n = i;
            elemInfo[n] = elemInfo[n] + dim;
        }
        return new JGeometry(geom.getType() + geom.getDimensions() * 1000, geom.getSRID(), elemInfo, ordinates);
    }

    public static JGeometry moveVertex(JGeometry geom, JGeometrySegmentPoint interPT, Point2D newPT) {
        int ptLoc;
        JGeometrySegment segment;
        int[] eInfo;
        double[] oords;
        block19: {
            block18: {
                block17: {
                    if (geom == null || interPT == null || newPT == null) {
                        return null;
                    }
                    int gtype = geom.getType();
                    if (gtype == 1 || gtype == 5) {
                        return null;
                    }
                    oords = geom.getOrdinatesArray();
                    if (oords == null) {
                        return null;
                    }
                    eInfo = geom.getElemInfo();
                    if (eInfo == null) {
                        return null;
                    }
                    segment = interPT.getSegment();
                    Point2D point = interPT.getPoint();
                    ptLoc = interPT.getPointLocation();
                    if (segment == null || point == null) {
                        return null;
                    }
                    if (segment.getSegmentType() == JGeometrySegment.LINE_TYPE) break block17;
                    if (segment.getSegmentType() != JGeometrySegment.RECTANGLE_TYPE) break block18;
                }
                if (ptLoc != 2 && ptLoc >= 0) break block19;
            }
            return null;
        }
        int elemIndex = segment.getElementIndex();
        int segIndex = segment.getSegmentIndex();
        int subelemIndex = segment.getSubElementIndex();
        int dim = geom.getDimensions();
        JGeometry gelem = geom.getElementAt(elemIndex + 1);
        JGeometryElementInfo[] elemsInfo = JGeometryUtil.getElementsInfo(geom, elemIndex + 1);
        if (gelem == null || elemsInfo == null || elemsInfo.length == 0) {
            return null;
        }
        int eiStart = elemsInfo[0].getElementInfoStart();
        int eiEnd = elemsInfo[0].getElementInfoEnd();
        int oordStart = elemsInfo[0].getElementOordStart();
        int oordEnd = elemsInfo[0].getElementOordEnd();
        if (subelemIndex > 0) {
            oordStart = eInfo[eiStart + 3 * subelemIndex] - 1;
        }
        int offset = segIndex * dim + ptLoc * dim;
        int[] elemInfo = new int[eInfo.length];
        System.arraycopy(eInfo, 0, elemInfo, 0, eInfo.length);
        double[] ordinates = new double[oords.length];
        System.arraycopy(oords, 0, ordinates, 0, oords.length);
        ordinates[oordStart + offset] = newPT.getX();
        ordinates[oordStart + offset + 1] = newPT.getY();
        if (gelem.isRectangle()) {
            double x1 = ordinates[oordStart + segIndex * dim];
            double y1 = ordinates[oordStart + segIndex * dim + 1];
            double x2 = ordinates[oordStart + segIndex * dim + dim];
            double y2 = ordinates[oordStart + segIndex * dim + dim + 1];
            ordinates[oordStart + segIndex * dim] = Math.min(x1, x2);
            ordinates[oordStart + segIndex * dim + 1] = Math.min(y1, y2);
            ordinates[oordStart + segIndex * dim + dim] = Math.max(x1, x2);
            ordinates[oordStart + segIndex * dim + dim + 1] = Math.max(y1, y2);
        } else if (gelem.getType() == 3) {
            int nelems = (eiEnd - eiStart + 1) / 3;
            if (nelems > 1 && subelemIndex < nelems - 1) {
                oordEnd = eInfo[eiStart + 3 * (subelemIndex + 1)] - 2;
            }
            int gdim = gelem.getDimensions();
            int nvertexes = (oordEnd - oordStart + 1) / gdim;
            if (segIndex == 0 && ptLoc == 0) {
                ordinates[oordEnd - 1] = newPT.getX();
                ordinates[oordEnd] = newPT.getY();
            } else if (segIndex == nvertexes - 2 && ptLoc == 1) {
                ordinates[oordStart] = newPT.getX();
                ordinates[oordStart + 1] = newPT.getY();
            }
        }
        return new JGeometry(geom.getType() + geom.getDimensions() * 1000, geom.getSRID(), elemInfo, ordinates);
    }

    public static JGeometry moveGeometry(JGeometry geom, double offsetX, double offsetY) {
        if (geom == null) {
            return null;
        }
        int dim = geom.getDimensions();
        JGeometry move = null;
        int[] eInfo = geom.getElemInfo();
        double[] oords = geom.getOrdinatesArray();
        if (oords != null) {
            int[] elemInfo = new int[eInfo.length];
            System.arraycopy(eInfo, 0, elemInfo, 0, eInfo.length);
            double[] ordinates = new double[oords.length];
            System.arraycopy(oords, 0, ordinates, 0, oords.length);
            if (!geom.isOrientedPoint() && !geom.isOrientedMultiPoint()) {
                for (int i = 0; i < ordinates.length / dim; ++i) {
                    int n = i * dim;
                    ordinates[n] = ordinates[n] + offsetX;
                    int n2 = i * dim + 1;
                    ordinates[n2] = ordinates[n2] + offsetY;
                }
            } else {
                for (int i = 0; i < ordinates.length / (2 * dim); ++i) {
                    int n = i * 2 * dim;
                    ordinates[n] = ordinates[n] + offsetX;
                    int n3 = i * 2 * dim + 1;
                    ordinates[n3] = ordinates[n3] + offsetY;
                }
            }
            move = new JGeometry(geom.getType() + geom.getDimensions() * 1000, geom.getSRID(), elemInfo, ordinates);
        } else {
            double[] points = geom.getPoint();
            if (points != null) {
                points[0] = points[0] + offsetX;
                points[1] = points[1] + offsetY;
                move = dim > 2 ? new JGeometry(points[0], points[1], points[2], geom.getSRID()) : new JGeometry(points[0], points[1], geom.getSRID());
            }
        }
        return move;
    }

    private static void transformOrdinates(double[] src, int srcOffset, ArrayList<Double> dst, int pnts, int dim, AffineTransform at) {
        for (int i = 0; i < pnts; ++i) {
            double[] tp = new double[2];
            at.transform(src, srcOffset + i * dim, tp, 0, 1);
            dst.add(tp[0]);
            dst.add(tp[1]);
            for (int j = 2; j < dim; ++j) {
                dst.add(src[srcOffset + (i * dim + j)]);
            }
        }
    }

    public static JGeometry transformGeometry(JGeometry geom, AffineTransform at) throws Exception {
        return JGeometryUtil.transformGeometry(geom, at, true, false);
    }

    public static JGeometry transformGeometry(JGeometry geom, AffineTransform at, boolean rotateOrientedPoints, boolean makePointsOriented) throws Exception {
        if (geom == null) {
            return null;
        }
        if (geom.getDimensions() != 2) {
            return null;
        }
        boolean performsRotation = false;
        if ((at.getType() & 0x38) > 0) {
            performsRotation = true;
        }
        boolean uniformScale = false;
        if ((at.getType() & 2) > 0) {
            uniformScale = true;
        }
        int dim = geom.getDimensions();
        JGeometry[] elements = JGeometryUtil.getElements(geom);
        for (int i = 0; i < elements.length; ++i) {
            JGeometry element = elements[i];
            int[] origElemInfo = element.getElemInfo();
            double[] origOrdinates = element.getOrdinatesArray();
            double[] newOrdinates = null;
            int[] newElemInfo = null;
            if (element.getType() == 1) {
                if (element.isOrientedPoint()) {
                    newOrdinates = new double[origOrdinates.length];
                    newOrdinates[dim] = origOrdinates[dim];
                    newOrdinates[dim + 1] = origOrdinates[dim + 1];
                    newElemInfo = new int[]{1, 1, 1, 3, 1, 0};
                } else {
                    origOrdinates = element.getPoint();
                    if (makePointsOriented && performsRotation) {
                        newOrdinates = new double[dim + 2];
                        newOrdinates[dim] = 1.0;
                        newOrdinates[dim + 1] = 0.0;
                        newElemInfo = new int[]{1, 1, 1, 3, 1, 0};
                    } else {
                        newOrdinates = new double[dim];
                        newElemInfo = new int[]{1, 1, 1};
                    }
                }
                at.transform(origOrdinates, 0, newOrdinates, 0, 1);
                if (rotateOrientedPoints && performsRotation && (makePointsOriented || element.isOrientedPoint())) {
                    double[] to = new double[]{origOrdinates[0] + newOrdinates[dim], origOrdinates[1] + newOrdinates[dim + 1]};
                    at.transform(to, 0, to, 0, 1);
                    double rot = Math.atan2(to[1] - newOrdinates[1], to[0] - newOrdinates[0]);
                    newOrdinates[dim] = Math.cos(rot);
                    newOrdinates[dim + 1] = Math.sin(rot);
                }
            } else if (element.getType() == 3) {
                int j;
                newElemInfo = new int[origElemInfo.length];
                System.arraycopy(origElemInfo, 0, newElemInfo, 0, origElemInfo.length);
                ArrayList<Double> newOrdinatesList = new ArrayList<Double>(origOrdinates.length);
                for (j = 0; j < newElemInfo.length / 3; ++j) {
                    boolean isCompound;
                    int start = newElemInfo[j * 3 + 0];
                    int eType = newElemInfo[j * 3 + 1];
                    int inter = newElemInfo[j * 3 + 2];
                    boolean bl = isCompound = eType % 10 == 5;
                    if (isCompound) {
                        int numComponents = inter;
                        int end = (j + numComponents + 1) * 3 + 0 < origElemInfo.length ? origElemInfo[(j + numComponents + 1) * 3 + 0] : origOrdinates.length + 1;
                        int indexDif = newOrdinatesList.size() + 1 - newElemInfo[j * 3 + 0];
                        int n = j * 3 + 0;
                        newElemInfo[n] = newElemInfo[n] + indexDif;
                        for (int k = 1; k <= numComponents; ++k) {
                            int n2 = (j + k) * 3 + 0;
                            newElemInfo[n2] = newElemInfo[n2] + indexDif;
                        }
                        JGeometryUtil.transformOrdinates(origOrdinates, start - 1, newOrdinatesList, (end - start) / dim, dim, at);
                        j += numComponents;
                        continue;
                    }
                    boolean outerPoly = eType / 1000 == 1;
                    boolean isRectangle = inter == 3;
                    boolean isCircle = inter == 4;
                    int end = (j + 1) * 3 + 0 < origElemInfo.length ? origElemInfo[(j + 1) * 3 + 0] : origOrdinates.length + 1;
                    if (isRectangle && performsRotation) {
                        newElemInfo[j * 3 + 0] = newOrdinatesList.size() + 1;
                        newElemInfo[j * 3 + 2] = 1;
                        newOrdinatesList.ensureCapacity(newOrdinatesList.size() + 5 * dim);
                        double minx = origOrdinates[start - 1 + (dim * 0 + 0)];
                        double miny = origOrdinates[start - 1 + (dim * 0 + 1)];
                        double maxx = origOrdinates[start - 1 + (dim * 1 + 0)];
                        double maxy = origOrdinates[start - 1 + (dim * 1 + 1)];
                        newOrdinates = outerPoly ? new double[]{minx, miny, maxx, miny, maxx, maxy, minx, maxy, minx, miny} : new double[]{minx, miny, minx, maxy, maxx, maxy, maxx, miny, minx, miny};
                        at.transform(newOrdinates, 0, newOrdinates, 0, 5);
                        for (int k = 0; k < 5; ++k) {
                            newOrdinatesList.add(newOrdinates[k * 2 + 0]);
                            newOrdinatesList.add(newOrdinates[k * 2 + 1]);
                            for (int l = 2; l < dim; ++l) {
                                newOrdinatesList.add(Double.NaN);
                            }
                        }
                        continue;
                    }
                    if (isCircle) {
                        int l;
                        newElemInfo[j * 3 + 0] = newOrdinatesList.size() + 1;
                        newElemInfo[j * 3 + 2] = 1;
                        int sf = 128;
                        newOrdinatesList.ensureCapacity(newOrdinatesList.size() + (sf + 1) * dim);
                        double x1 = origOrdinates[start - 1 + (dim * 0 + 0)];
                        double y1 = origOrdinates[start - 1 + (dim * 0 + 1)];
                        double x2 = origOrdinates[start - 1 + (dim * 1 + 0)];
                        double y2 = origOrdinates[start - 1 + (dim * 1 + 1)];
                        double x3 = origOrdinates[start - 1 + (dim * 2 + 0)];
                        double y3 = origOrdinates[start - 1 + (dim * 2 + 1)];
                        double[] res = JGeometry.computeArc((double)x1, (double)y1, (double)x2, (double)y2, (double)x3, (double)y3);
                        if (res == null) {
                            throw new Exception("Overlapping or co-linear points for arc");
                        }
                        double direction = outerPoly ? -1.0 : 1.0;
                        double centerx = res[0];
                        double centery = res[1];
                        double r = res[2];
                        double[] tp = new double[]{centerx + r, centery};
                        at.transform(tp, 0, tp, 0, 1);
                        newOrdinatesList.add(tp[0]);
                        newOrdinatesList.add(tp[1]);
                        for (l = 2; l < dim; ++l) {
                            newOrdinatesList.add(Double.NaN);
                        }
                        for (int k = 1; k < sf; ++k) {
                            double kf = Math.PI * ((double)(sf - (direction > 0.0 ? k : sf - k)) / ((double)sf / 2.0));
                            tp = new double[]{centerx + r * Math.cos(kf), centery + r * Math.sin(kf)};
                            at.transform(tp, 0, tp, 0, 1);
                            newOrdinatesList.add(tp[0]);
                            newOrdinatesList.add(tp[1]);
                            for (int l2 = 2; l2 < dim; ++l2) {
                                newOrdinatesList.add(Double.NaN);
                            }
                        }
                        tp = new double[]{centerx + r, centery};
                        at.transform(tp, 0, tp, 0, 1);
                        newOrdinatesList.add(tp[0]);
                        newOrdinatesList.add(tp[1]);
                        for (l = 2; l < dim; ++l) {
                            newOrdinatesList.add(Double.NaN);
                        }
                        continue;
                    }
                    newElemInfo[j * 3 + 0] = newOrdinatesList.size() + 1;
                    JGeometryUtil.transformOrdinates(origOrdinates, start - 1, newOrdinatesList, (end - start) / dim, dim, at);
                }
                newOrdinates = new double[newOrdinatesList.size()];
                for (j = 0; j < newOrdinatesList.size(); ++j) {
                    newOrdinates[j] = (Double)newOrdinatesList.get(j);
                }
            } else {
                newElemInfo = new int[origElemInfo.length];
                System.arraycopy(origElemInfo, 0, newElemInfo, 0, origElemInfo.length);
                newOrdinates = new double[origOrdinates.length];
                at.transform(origOrdinates, 0, newOrdinates, 0, origOrdinates.length / 2);
            }
            elements[i] = new JGeometry(dim * 1000 + element.getType(), element.getSRID(), newElemInfo, newOrdinates);
        }
        return JGeometryUtil.append(elements, geom.getType() == 4);
    }

    public static JGeometry removeVertex(JGeometry geom, JGeometrySegmentPoint interPT) {
        int i;
        if (geom == null || interPT == null) {
            return null;
        }
        int gtype = geom.getType();
        if (gtype == 1 || gtype == 5) {
            return null;
        }
        double[] oords = geom.getOrdinatesArray();
        if (oords == null) {
            return null;
        }
        int[] eInfo = geom.getElemInfo();
        if (eInfo == null) {
            return null;
        }
        JGeometrySegment segment = interPT.getSegment();
        Point2D point = interPT.getPoint();
        int ptLoc = interPT.getPointLocation();
        if (segment == null || point == null) {
            return null;
        }
        if (segment.getSegmentType() != JGeometrySegment.LINE_TYPE || ptLoc == 2) {
            return null;
        }
        int elemIndex = segment.getElementIndex();
        int segIndex = segment.getSegmentIndex();
        int subelemIndex = segment.getSubElementIndex();
        int dim = geom.getDimensions();
        JGeometry gelem = geom.getElementAt(elemIndex + 1);
        JGeometryElementInfo[] elemsInfo = JGeometryUtil.getElementsInfo(geom, elemIndex + 1);
        if (gelem == null || elemsInfo == null || elemsInfo.length == 0) {
            return null;
        }
        int eiStart = elemsInfo[0].getElementInfoStart();
        int eiEnd = elemsInfo[0].getElementInfoEnd();
        int oordStart = elemsInfo[0].getElementOordStart();
        int oordEnd = elemsInfo[0].getElementOordEnd();
        if (subelemIndex > 0) {
            oordStart = eInfo[eiStart + 3 * subelemIndex] - 1;
            eiStart += 3 * subelemIndex;
        }
        int offset = segIndex * dim + ptLoc * dim;
        int[] elemInfo = new int[eInfo.length];
        System.arraycopy(eInfo, 0, elemInfo, 0, eInfo.length);
        double[] ordinates = new double[oords.length - dim];
        if (gelem.getType() == 3) {
            int i2;
            int nelems = (eiEnd - eiStart + 1) / 3;
            if (nelems > 1 && subelemIndex < nelems - 1) {
                oordEnd = eInfo[eiStart + 3 * (subelemIndex + 1)] - 2;
            }
            int gdim = gelem.getDimensions();
            int nvertexes = (oordEnd - oordStart + 1) / gdim;
            if (segIndex == 0 && ptLoc == 0 || segIndex == nvertexes - 2 && ptLoc == 1) {
                for (i2 = 0; i2 < oordStart; ++i2) {
                    ordinates[i2] = oords[i2];
                }
                for (i2 = oordStart; i2 < ordinates.length; ++i2) {
                    ordinates[i2] = oords[i2 + gdim];
                }
                ordinates[oordEnd - 1 - gdim] = oords[oordStart + gdim];
                ordinates[oordEnd - gdim] = oords[oordStart + gdim + 1];
            } else {
                for (i2 = 0; i2 < oordStart + offset; ++i2) {
                    ordinates[i2] = oords[i2];
                }
                for (i2 = oordStart + offset; i2 < ordinates.length; ++i2) {
                    ordinates[i2] = oords[i2 + dim];
                }
            }
        } else {
            for (i = 0; i < oordStart + offset; ++i) {
                ordinates[i] = oords[i];
            }
            for (i = oordStart + offset; i < ordinates.length; ++i) {
                ordinates[i] = oords[i + dim];
            }
        }
        for (i = eiStart + 3; i < elemInfo.length; i += 3) {
            int n = i;
            elemInfo[n] = elemInfo[n] - dim;
        }
        return new JGeometry(geom.getType() + geom.getDimensions() * 1000, geom.getSRID(), elemInfo, ordinates);
    }

    public static JGeometry removeVertexes(JGeometry geom, JGeometrySegmentPoint[] interPTs) {
        if (geom == null || interPTs == null || interPTs.length == 0) {
            return null;
        }
        int dim = geom.getDimensions();
        int gtype = geom.getType();
        if (gtype == 1 || gtype == 5) {
            return null;
        }
        double[] oords = geom.getOrdinatesArray();
        if (oords == null) {
            return null;
        }
        int[] eInfo = geom.getElemInfo();
        if (eInfo == null) {
            return null;
        }
        JGeometry[] elems = geom.getElements();
        if (elems == null || elems.length == 0) {
            return null;
        }
        ArrayList<JGeometry> outelems = new ArrayList<JGeometry>();
        boolean hasPoint = false;
        boolean hasLine = false;
        boolean hasPolygon = false;
        for (int i = 0; i < elems.length; ++i) {
            int j;
            JGeometry elem = elems[i];
            if (elem.getType() == 1) {
                outelems.add(elems[i]);
                hasPoint = true;
                continue;
            }
            double[] eloords = new double[elem.getOrdinatesArray().length];
            System.arraycopy(elem.getOrdinatesArray(), 0, eloords, 0, elem.getOrdinatesArray().length);
            int[] elinfo = new int[elem.getElemInfo().length];
            System.arraycopy(elem.getElemInfo(), 0, elinfo, 0, elem.getElemInfo().length);
            int nelems = elinfo.length / 3;
            for (int k = 0; k < interPTs.length; ++k) {
                int elemIndex = interPTs[k].getSegment().getElementIndex();
                if (elemIndex != i) continue;
                int segIndex = interPTs[k].getSegment().getSegmentIndex();
                int subelemIndex = interPTs[k].getSegment().getSubElementIndex();
                int offset = 0;
                if (subelemIndex > 0) {
                    offset = elinfo[3 * subelemIndex] - 1;
                }
                if (interPTs[k].getPointLocation() == 0) {
                    eloords[dim * segIndex + offset] = Double.NaN;
                    eloords[dim * segIndex + 1 + offset] = Double.NaN;
                    continue;
                }
                eloords[dim * segIndex + offset + dim] = Double.NaN;
                eloords[dim * segIndex + 1 + offset + dim] = Double.NaN;
            }
            boolean discard = true;
            int extRingEnd = eloords.length;
            if (nelems > 1) {
                extRingEnd = elinfo[3] - 1;
            }
            for (int j2 = 0; j2 < eloords.length && j2 != extRingEnd; ++j2) {
                if (Double.isNaN(eloords[j2])) continue;
                discard = false;
                break;
            }
            if (discard) continue;
            ArrayList<Double> coords = new ArrayList<Double>();
            ArrayList<Integer> info = new ArrayList<Integer>();
            if (elem.getType() == 2) {
                for (int j3 = 0; j3 < eloords.length / dim; ++j3) {
                    if (Double.isNaN(eloords[j3 * dim])) continue;
                    for (int k = 0; k < dim; ++k) {
                        coords.add(new Double(eloords[j3 * dim + k]));
                    }
                }
                if (coords.size() == 0 || coords.size() / dim < 2) continue;
                double[] loords = new double[coords.size()];
                for (int j4 = 0; j4 < coords.size(); ++j4) {
                    loords[j4] = (Double)coords.get(j4);
                }
                outelems.add(new JGeometry(2 + geom.getDimensions() * 1000, geom.getSRID(), new int[]{1, 2, 1}, loords));
                hasLine = true;
                continue;
            }
            int extPts = 0;
            for (j = 0; j < extRingEnd; j += dim) {
                if (Double.isNaN(eloords[j])) continue;
                ++extPts;
            }
            if (extPts < 4) continue;
            info.add(new Integer(1));
            info.add(new Integer(1003));
            info.add(new Integer(1));
            for (j = 0; j < extRingEnd; ++j) {
                if (Double.isNaN(eloords[j])) continue;
                coords.add(new Double(eloords[j]));
            }
            double xi = (Double)coords.get(0);
            double yi = (Double)coords.get(1);
            double xf = (Double)coords.get(coords.size() - dim);
            double yf = (Double)coords.get(coords.size() - dim + 1);
            if (xi != xf || yi != yf) {
                coords.add(new Double(xi));
                coords.add(new Double(yi));
                for (int k = 2; k < dim; ++k) {
                    coords.add(new Double(0.0));
                }
            }
            int nextOordStart = coords.size() + 1;
            int pvringEnd = extRingEnd;
            for (int k = 1; k < nelems; ++k) {
                int j5;
                int intPts = 0;
                int intRingEnd = eloords.length;
                if (k < nelems - 1) {
                    intRingEnd = elinfo[3 * (k + 1)] - 1;
                }
                for (j5 = pvringEnd; j5 < intRingEnd; j5 += dim) {
                    if (Double.isNaN(eloords[j5])) continue;
                    ++intPts;
                }
                if (intPts < 4) {
                    pvringEnd = intRingEnd;
                    continue;
                }
                info.add(new Integer(nextOordStart));
                info.add(new Integer(2003));
                info.add(new Integer(1));
                xi = Double.NaN;
                yi = Double.NaN;
                for (j5 = pvringEnd; j5 < intRingEnd; ++j5) {
                    if (Double.isNaN(eloords[j5])) continue;
                    coords.add(new Double(eloords[j5]));
                    if (Double.isNaN(xi)) {
                        xi = eloords[j5];
                        continue;
                    }
                    if (!Double.isNaN(yi)) continue;
                    yi = eloords[j5];
                }
                xf = (Double)coords.get(coords.size() - dim);
                yf = (Double)coords.get(coords.size() - dim + 1);
                if (xi != xf || yi != yf) {
                    coords.add(new Double(xi));
                    coords.add(new Double(yi));
                    for (int m = 2; m < dim; ++m) {
                        coords.add(new Double(0.0));
                    }
                }
                nextOordStart = coords.size() + 1;
                pvringEnd = intRingEnd;
            }
            double[] loords = new double[coords.size()];
            for (int j6 = 0; j6 < coords.size(); ++j6) {
                loords[j6] = (Double)coords.get(j6);
            }
            int[] linfos = new int[info.size()];
            for (int j7 = 0; j7 < info.size(); ++j7) {
                linfos[j7] = (Integer)info.get(j7);
            }
            outelems.add(new JGeometry(3 + geom.getDimensions() * 1000, geom.getSRID(), linfos, loords));
            hasPolygon = true;
        }
        if (outelems.size() == 0) {
            return null;
        }
        int outputType = JGeometryUtil.getGeometryType(outelems);
        int numOords = 0;
        for (int i = 0; i < outelems.size(); ++i) {
            JGeometry g = outelems.get(i);
            double[] goords = g.getOrdinatesArray();
            if (g.getType() == 1) {
                if (goords == null) {
                    numOords += dim;
                    continue;
                }
                numOords += goords.length;
                continue;
            }
            numOords += goords.length;
        }
        double[] outOords = new double[numOords];
        int count = 0;
        for (int i = 0; i < outelems.size(); ++i) {
            JGeometry g = outelems.get(i);
            double[] goords = g.getOrdinatesArray();
            if (g.getType() == 1) {
                if (goords == null) {
                    double[] pts = g.getPoint();
                    for (int k = 0; k < pts.length; ++k) {
                        outOords[count++] = pts[k];
                    }
                    continue;
                }
                for (int k = 0; k < goords.length; ++k) {
                    outOords[count++] = goords[k];
                }
                continue;
            }
            for (int k = 0; k < goords.length; ++k) {
                outOords[count++] = goords[k];
            }
        }
        int numEinfo = 0;
        for (int i = 0; i < outelems.size(); ++i) {
            JGeometry g = outelems.get(i);
            int[] ginfo = g.getElemInfo();
            if (g.getType() == 1) {
                if (ginfo == null) {
                    numEinfo += dim;
                    continue;
                }
                numEinfo += ginfo.length;
                continue;
            }
            numEinfo += ginfo.length;
        }
        int[] outEinfo = new int[numEinfo];
        int offsetOord = 1;
        int offsetEinfo = 0;
        for (int i = 0; i < outelems.size(); ++i) {
            JGeometry g = outelems.get(i);
            int[] ginfo = g.getElemInfo();
            double[] goords = g.getOrdinatesArray();
            outEinfo[offsetEinfo] = offsetOord;
            if (g.getType() == 1) {
                outEinfo[offsetEinfo + 1] = 1;
                outEinfo[offsetEinfo + 2] = 1;
                offsetOord += dim;
                offsetEinfo += 3;
                continue;
            }
            if (g.getType() == 2) {
                outEinfo[offsetEinfo + 1] = 2;
                outEinfo[offsetEinfo + 2] = 1;
                offsetOord += goords.length;
                offsetEinfo += 3;
                continue;
            }
            int nelems = ginfo.length / 3;
            for (int k = 0; k < nelems; ++k) {
                outEinfo[offsetEinfo] = offsetOord;
                outEinfo[offsetEinfo + 2] = 1;
                outEinfo[offsetEinfo + 1] = k == 0 ? 1003 : 2003;
                offsetOord = k == nelems - 1 ? (offsetOord += goords.length - ginfo[3 * k] + 1) : (offsetOord += ginfo[3 * (k + 1)] - ginfo[3 * k]);
                offsetEinfo += 3;
            }
        }
        return new JGeometry(outputType + geom.getDimensions() * 1000, geom.getSRID(), outEinfo, outOords);
    }

    public static JGeometry movePoint(JGeometry geom, JGeometrySegmentPoint interPT, Point2D newPT) {
        if (geom == null || interPT == null || newPT == null) {
            return null;
        }
        int gtype = geom.getType();
        if (gtype != 1 && gtype != 5 && gtype != 4) {
            return null;
        }
        JGeometrySegment segment = interPT.getSegment();
        Point2D point = interPT.getPoint();
        if (segment == null || point == null || segment.getSegmentType() != JGeometrySegment.POINT_TYPE) {
            return null;
        }
        int dim = geom.getDimensions();
        double[] oords = geom.getOrdinatesArray();
        int[] eInfo = geom.getElemInfo();
        int[] elemInfo = null;
        double[] ordinates = null;
        if (eInfo != null && oords != null) {
            elemInfo = new int[eInfo.length];
            System.arraycopy(eInfo, 0, elemInfo, 0, eInfo.length);
            ordinates = new double[oords.length];
            System.arraycopy(oords, 0, ordinates, 0, oords.length);
        }
        if (gtype == 1) {
            if (!geom.isOrientedPoint()) {
                if (oords == null) {
                    double[] ptoords = geom.getFirstPoint();
                    ptoords[0] = newPT.getX();
                    ptoords[1] = newPT.getY();
                    if (ptoords.length == 2) {
                        return new JGeometry(ptoords[0], ptoords[1], geom.getSRID());
                    }
                    return new JGeometry(ptoords[0], ptoords[1], ptoords[2], geom.getSRID());
                }
                if (eInfo == null) {
                    return null;
                }
                ordinates[0] = newPT.getX();
                ordinates[1] = newPT.getY();
                return new JGeometry(geom.getType() + geom.getDimensions() * 1000, geom.getSRID(), elemInfo, ordinates);
            }
            if (oords == null || eInfo == null) {
                return null;
            }
            ordinates[0] = newPT.getX();
            ordinates[1] = newPT.getY();
            return new JGeometry(geom.getType() + geom.getDimensions() * 1000, geom.getSRID(), elemInfo, ordinates);
        }
        if (gtype == 5) {
            if (eInfo == null || oords == null) {
                return null;
            }
            int elemIndex = segment.getElementIndex();
            ordinates[elemIndex * dim] = newPT.getX();
            ordinates[elemIndex * dim + 1] = newPT.getY();
            return new JGeometry(geom.getType() + geom.getDimensions() * 1000, geom.getSRID(), elemInfo, ordinates);
        }
        if (gtype == 4) {
            if (eInfo == null || oords == null) {
                return null;
            }
            int elemIndex = segment.getElementIndex();
            JGeometryElementInfo[] elemsInfo = JGeometryUtil.getElementsInfo(geom, elemIndex + 1);
            if (elemsInfo == null || elemsInfo.length == 0) {
                return null;
            }
            int oordStart = elemsInfo[0].getElementOordStart();
            ordinates[oordStart] = newPT.getX();
            ordinates[oordStart + 1] = newPT.getY();
            return new JGeometry(geom.getType() + geom.getDimensions() * 1000, geom.getSRID(), elemInfo, ordinates);
        }
        return null;
    }

    public static JGeometryElementInfo[] getElementsInfo(JGeometry geometry, int position) {
        if (geometry == null) {
            return null;
        }
        int[] elemInfo = geometry.getElemInfo();
        double[] ordinates = geometry.getOrdinatesArray();
        int dim = geometry.getDimensions();
        ArrayList<JGeometryElementInfo> al = new ArrayList<JGeometryElementInfo>();
        JGeometryElementInfo elinfo = null;
        int ecount = 0;
        int gtype = geometry.getType();
        if (gtype == 1 || gtype == 2 || gtype == 3) {
            if (gtype == 1) {
                elinfo = new JGeometryElementInfo();
                if (elemInfo == null || ordinates == null) {
                    elinfo.setInfo(gtype, al.size(), -1, -1, -1, -1);
                } else {
                    elinfo.setInfo(gtype, al.size(), 0, elemInfo.length - 1, 0, ordinates.length - 1);
                }
            } else {
                if (elemInfo == null || ordinates == null) {
                    return null;
                }
                elinfo = new JGeometryElementInfo();
                elinfo.setInfo(gtype, al.size(), 0, elemInfo.length - 1, 0, ordinates.length - 1);
            }
            al.add(elinfo);
            ++ecount;
        } else if (gtype == 6 || gtype == 7 || gtype == 4 || gtype == 5) {
            if (elemInfo == null || ordinates == null) {
                return null;
            }
            int eistart = 0;
            int start = 0;
            int eiend = 0;
            int end = 0;
            for (int i = 0; i < elemInfo.length; i += 3) {
                int egtype;
                int egtype2;
                if (elemInfo[i + 1] == 2) {
                    if (++ecount == position || position == -1) {
                        egtype2 = 2;
                        start = elemInfo[i] - 1;
                        end = i + 3 < elemInfo.length ? elemInfo[i + 3] - 2 : ordinates.length - 1;
                        elinfo = new JGeometryElementInfo();
                        elinfo.setInfo(egtype2, al.size(), i, i + 2, start, end);
                        al.add(elinfo);
                    }
                    if (ecount != position) continue;
                    i = elemInfo.length;
                    continue;
                }
                if (elemInfo[i + 1] == 4) {
                    int subElems = elemInfo[i + 2];
                    if (++ecount == position || position == -1) {
                        egtype = 2;
                        eistart = i;
                        start = elemInfo[i] - 1;
                        if (i + 3 + 3 * subElems < elemInfo.length) {
                            end = elemInfo[i + 3 + 3 * subElems] - 2;
                            eiend = i + 3 + 3 * subElems - 1;
                        } else {
                            end = ordinates.length - 1;
                            eiend = elemInfo.length - 1;
                        }
                        elinfo = new JGeometryElementInfo();
                        elinfo.setInfo(egtype, al.size(), eistart, eiend, start, end);
                        al.add(elinfo);
                    }
                    if (ecount == position) {
                        i = elemInfo.length;
                        continue;
                    }
                    i += 3 * subElems;
                    continue;
                }
                if (elemInfo[i + 1] == 1003 || elemInfo[i + 1] == 1005 || elemInfo[i + 1] == 3 || elemInfo[i + 1] == 5) {
                    ++ecount;
                    egtype2 = 3;
                    int top_e = elemInfo[i + 1];
                    eistart = i;
                    start = elemInfo[i] - 1;
                    boolean hasMore = false;
                    if ((top_e == 1003 || top_e == 3) && i + 3 < elemInfo.length) {
                        end = elemInfo[i + 3] - 2;
                        eiend = i + 3 - 1;
                        hasMore = true;
                    } else if ((top_e == 1005 || top_e == 5) && i + 3 + 3 * elemInfo[i + 2] < elemInfo.length) {
                        int subElems = elemInfo[i + 2];
                        end = elemInfo[i + 3 + 3 * subElems] - 2;
                        eiend = i + 3 + 3 * subElems - 1;
                        i += 3 * subElems;
                        hasMore = true;
                    } else {
                        end = ordinates.length - 1;
                        eiend = elemInfo.length - 1;
                    }
                    boolean inner = true;
                    while (hasMore && inner) {
                        if (i + 3 + 1 < elemInfo.length) {
                            int nexte = elemInfo[i + 3 + 1];
                            if (nexte == 2003) {
                                if ((i += 3) + 3 < elemInfo.length) {
                                    end = elemInfo[i + 3] - 2;
                                    eiend = i + 3 - 1;
                                } else {
                                    end = ordinates.length - 1;
                                    eiend = elemInfo.length - 1;
                                }
                                inner = true;
                                continue;
                            }
                            if (nexte == 2005) {
                                int isubElems;
                                if ((i += 3) + 3 + 3 * (isubElems = elemInfo[i + 2]) < elemInfo.length) {
                                    end = elemInfo[i + 3 + 3 * isubElems] - 2;
                                    eiend = i + 3 + 3 * isubElems - 1;
                                    inner = true;
                                } else {
                                    end = ordinates.length - 1;
                                    eiend = elemInfo.length - 1;
                                    inner = false;
                                }
                                i += 3 * isubElems;
                                continue;
                            }
                            inner = false;
                            continue;
                        }
                        hasMore = false;
                    }
                    if (ecount == position || position == -1) {
                        elinfo = new JGeometryElementInfo();
                        elinfo.setInfo(egtype2, al.size(), eistart, eiend, start, end);
                        al.add(elinfo);
                    }
                    if (ecount != position) continue;
                    i = elemInfo.length;
                    continue;
                }
                if (elemInfo[i + 1] == 1) {
                    int eitpr = elemInfo[i + 2];
                    egtype = 1;
                    start = elemInfo[i] - 1;
                    boolean isOriPoint = false;
                    if (eitpr >= 1) {
                        if (i + 3 < elemInfo.length) {
                            if (eitpr == 1 && elemInfo[i + 4] == 1 && elemInfo[i + 5] == 0) {
                                isOriPoint = true;
                            }
                            if (isOriPoint && i + 6 < elemInfo.length) {
                                end = elemInfo[i + 6] - 2;
                            } else if (isOriPoint) {
                                end = ordinates.length - 1;
                            }
                        }
                        for (int j = 0; j < eitpr; ++j) {
                            ++ecount;
                            if (dim == 2 && !isOriPoint) {
                                if (ecount == position || position == -1) {
                                    elinfo = new JGeometryElementInfo();
                                    elinfo.setInfo(1, al.size(), i, i + 2, start, start + 1);
                                    al.add(elinfo);
                                }
                                if (ecount == position) {
                                    j = eitpr;
                                    i = elemInfo.length;
                                    continue;
                                }
                                start += 2;
                                continue;
                            }
                            if (dim == 3 && !isOriPoint) {
                                if (ecount == position || position == -1) {
                                    elinfo = new JGeometryElementInfo();
                                    elinfo.setInfo(1, al.size(), i, i + 2, start, start + 2);
                                    al.add(elinfo);
                                }
                                if (ecount == position) {
                                    j = eitpr;
                                    i = elemInfo.length;
                                    continue;
                                }
                                start += 3;
                                continue;
                            }
                            if (!isOriPoint) {
                                if (ecount == position || position == -1) {
                                    int[] eia = new int[]{1, 1, 1};
                                    elinfo = new JGeometryElementInfo();
                                    elinfo.setInfo(1, al.size(), i, i + 2, start, start + dim);
                                    al.add(elinfo);
                                }
                                if (ecount == position) {
                                    j = eitpr;
                                    i = elemInfo.length;
                                    continue;
                                }
                                start += dim;
                                continue;
                            }
                            if (!isOriPoint) continue;
                            if (ecount == position || position == -1) {
                                elinfo = new JGeometryElementInfo();
                                elinfo.setInfo(egtype, al.size(), i, i + 5, start, end);
                                al.add(elinfo);
                            }
                            if (ecount == position) {
                                j = eitpr;
                                i = elemInfo.length;
                                continue;
                            }
                            i += 3;
                        }
                        continue;
                    }
                    return null;
                }
                i += 3;
            }
        }
        if (position > ecount || ecount == 0) {
            return null;
        }
        JGeometryElementInfo[] jga = new JGeometryElementInfo[al.size()];
        return al.toArray(jga);
    }

    public static JGeometry addPoint(JGeometry geom, JGeometry point) {
        if (geom == null || point == null) {
            return null;
        }
        if (point.getType() != 1) {
            return null;
        }
        if (geom.getSRID() != point.getSRID()) {
            return null;
        }
        int geomdim = geom.getDimensions();
        if (point.getDimensions() != geomdim) {
            return null;
        }
        int ptdim = point.getDimensions();
        double[] pts = point.getPoint();
        if (pts == null) {
            return null;
        }
        int type = geom.getType();
        if (type == 1 || type == 5) {
            if (geom.isOrientedPoint() || geom.isOrientedMultiPoint()) {
                int[] eInfo = geom.getElemInfo();
                double[] oords = geom.getOrdinatesArray();
                if (eInfo == null || oords == null) {
                    return null;
                }
                int[] elemInfo = new int[eInfo.length + 6];
                System.arraycopy(eInfo, 0, elemInfo, 0, eInfo.length);
                elemInfo[eInfo.length] = oords.length + 1;
                elemInfo[eInfo.length + 1] = 1;
                elemInfo[eInfo.length + 2] = 1;
                elemInfo[eInfo.length + 3] = oords.length + 1 + geomdim;
                elemInfo[eInfo.length + 4] = 1;
                elemInfo[eInfo.length + 5] = 0;
                double[] orientVector = new double[geomdim];
                orientVector[0] = 1.0;
                for (int i = 1; i < geomdim; ++i) {
                    orientVector[i] = 0.0;
                }
                JGeometry[] elements = JGeometryUtil.getElements(geom);
                if (elements != null) {
                    for (int i = 0; i < geomdim; ++i) {
                        orientVector[i] = oords[geomdim + i];
                    }
                    if (elements.length > 1) {
                        int i;
                        boolean useDefaultVector = false;
                        boolean stop = false;
                        for (i = 1; i < elements.length; ++i) {
                            for (int j = 0; j < geomdim; ++j) {
                                if (orientVector[j] == oords[i * geomdim + geomdim + j]) continue;
                                useDefaultVector = true;
                                stop = true;
                                break;
                            }
                            if (stop) break;
                        }
                        if (useDefaultVector) {
                            orientVector[0] = 1.0;
                            for (i = 1; i < geomdim; ++i) {
                                orientVector[i] = 0.0;
                            }
                        }
                    }
                }
                double[] ordinates = new double[oords.length + 2 * geomdim];
                System.arraycopy(oords, 0, ordinates, 0, oords.length);
                for (int i = 0; i < geomdim; ++i) {
                    ordinates[oords.length + i] = pts[i];
                    ordinates[oords.length + i + geomdim] = orientVector[i];
                }
                int outtype = 5 + geom.getDimensions() * 1000;
                return new JGeometry(outtype, geom.getSRID(), elemInfo, ordinates);
            }
            if (type == 1) {
                int i;
                int[] elemInfo = new int[]{1, 1, 2};
                double[] ordinates = new double[2 * geomdim];
                double[] geompts = geom.getPoint();
                for (i = 0; i < geomdim; ++i) {
                    ordinates[i] = geompts[i];
                }
                for (i = 0; i < ptdim && geomdim + i != ordinates.length; ++i) {
                    ordinates[geomdim + i] = pts[i];
                }
                int outtype = 5 + geom.getDimensions() * 1000;
                return new JGeometry(outtype, geom.getSRID(), elemInfo, ordinates);
            }
            int[] eInfo = geom.getElemInfo();
            double[] oords = geom.getOrdinatesArray();
            if (eInfo == null || oords == null) {
                return null;
            }
            int[] elemInfo = null;
            double[] ordinates = new double[oords.length + geomdim];
            System.arraycopy(oords, 0, ordinates, 0, oords.length);
            if (eInfo.length == 3) {
                elemInfo = new int[3];
                System.arraycopy(eInfo, 0, elemInfo, 0, eInfo.length);
                elemInfo[2] = elemInfo[2] + 1;
            } else {
                elemInfo = new int[eInfo.length + 3];
                System.arraycopy(eInfo, 0, elemInfo, 0, eInfo.length);
                elemInfo[eInfo.length] = oords.length + 1;
                elemInfo[eInfo.length + 1] = 1;
                elemInfo[eInfo.length + 2] = 1;
            }
            for (int i = 0; i < ptdim && oords.length + i != ordinates.length; ++i) {
                ordinates[oords.length + i] = pts[i];
            }
            int outtype = 5 + geom.getDimensions() * 1000;
            return new JGeometry(outtype, geom.getSRID(), elemInfo, ordinates);
        }
        int[] eInfo = geom.getElemInfo();
        double[] oords = geom.getOrdinatesArray();
        if (eInfo == null || oords == null) {
            return null;
        }
        int[] elemInfo = new int[eInfo.length + 3];
        double[] ordinates = new double[oords.length + geomdim];
        System.arraycopy(oords, 0, ordinates, 0, oords.length);
        System.arraycopy(eInfo, 0, elemInfo, 0, eInfo.length);
        elemInfo[eInfo.length] = oords.length + 1;
        elemInfo[eInfo.length + 1] = 1;
        elemInfo[eInfo.length + 2] = 1;
        for (int i = 0; i < ptdim && oords.length + i != ordinates.length; ++i) {
            ordinates[oords.length + i] = pts[i];
        }
        int outtype = 4 + geom.getDimensions() * 1000;
        return new JGeometry(outtype, geom.getSRID(), elemInfo, ordinates);
    }

    public static JGeometry pointToOrientedPoint(JGeometry geom, double[] orientData) {
        if (geom == null || orientData == null) {
            return null;
        }
        if (geom.getType() != 1 && geom.getType() != 5) {
            return null;
        }
        if (geom.isOrientedPoint() || geom.isOrientedMultiPoint()) {
            return null;
        }
        int geomdim = geom.getDimensions();
        int type = geom.getType();
        if (type == 1) {
            double[] geompts = geom.getPoint();
            if (geompts == null) {
                return null;
            }
            if (orientData.length != geomdim) {
                System.out.println("Orientation vector size [" + orientData.length + "]" + " is not equal to geometry dimension [" + geomdim + "]");
                return null;
            }
            int[] elemInfo = new int[]{1, 1, 1, geomdim + 1, 1, 0};
            double[] ordinates = new double[2 * geomdim];
            for (int i = 0; i < geomdim; ++i) {
                ordinates[i] = geompts[i];
                ordinates[geomdim + i] = orientData[i];
            }
            int outtype = 1 + geom.getDimensions() * 1000;
            return new JGeometry(outtype, geom.getSRID(), elemInfo, ordinates);
        }
        int numPoints = geom.getNumPoints();
        if (orientData.length != geomdim * numPoints) {
            return null;
        }
        int[] eInfo = geom.getElemInfo();
        double[] oords = geom.getOrdinatesArray();
        if (eInfo == null || oords == null) {
            return null;
        }
        int[] elemInfo = new int[6 * numPoints];
        for (int i = 0; i < numPoints; ++i) {
            elemInfo[6 * i] = 2 * geomdim * i + 1;
            elemInfo[6 * i + 1] = 1;
            elemInfo[6 * i + 2] = 1;
            elemInfo[6 * i + 3] = 2 * geomdim * i + 1 + geomdim;
            elemInfo[6 * i + 4] = 1;
            elemInfo[6 * i + 5] = 0;
        }
        double[] ordinates = new double[2 * oords.length];
        for (int i = 0; i < numPoints; ++i) {
            for (int j = 0; j < geomdim; ++j) {
                ordinates[2 * geomdim * i + j] = oords[geomdim * i + j];
                ordinates[2 * geomdim * i + j + geomdim] = orientData[geomdim * i + j];
            }
        }
        int outtype = 5 + geom.getDimensions() * 1000;
        return new JGeometry(outtype, geom.getSRID(), elemInfo, ordinates);
    }

    public static JGeometry changePointOrientation(JGeometry geom, int element, double[] orientData) {
        if (geom == null || orientData == null || element < 0) {
            return null;
        }
        int geomdim = geom.getDimensions();
        int type = geom.getType();
        if (type == 1) {
            double[] geompts = geom.getPoint();
            if (orientData.length != geomdim) {
                System.out.println("Orientation vector size [" + orientData.length + "]" + " is not equal to geometry dimension [" + geomdim + "]");
                return null;
            }
            int[] elemInfo = new int[]{1, 1, 1, geomdim + 1, 1, 0};
            double[] ordinates = new double[2 * geomdim];
            for (int i = 0; i < geomdim; ++i) {
                ordinates[i] = geompts[i];
                ordinates[geomdim + i] = orientData[i];
            }
            int outtype = 1 + geom.getDimensions() * 1000;
            return new JGeometry(outtype, geom.getSRID(), elemInfo, ordinates);
        }
        if (type == 5 && geom.isOrientedMultiPoint()) {
            int[] eInfo = geom.getElemInfo();
            double[] oords = geom.getOrdinatesArray();
            if (eInfo == null || oords == null) {
                return null;
            }
            int numPoints = geom.getNumPoints();
            if (element >= numPoints) {
                System.out.println("Element index [" + element + "]" + " out of geometry elements range.");
                return null;
            }
            if (orientData.length != geomdim) {
                System.out.println("Orientation vector size [" + orientData.length + "]" + " is not equal to geometry dimension [" + geomdim + "]");
                return null;
            }
            int[] elemInfo = new int[eInfo.length];
            double[] ordinates = new double[oords.length];
            System.arraycopy(oords, 0, ordinates, 0, oords.length);
            System.arraycopy(eInfo, 0, elemInfo, 0, eInfo.length);
            for (int j = 0; j < geomdim; ++j) {
                ordinates[2 * geomdim * element + j + geomdim] = orientData[j];
            }
            int outtype = 5 + geom.getDimensions() * 1000;
            return new JGeometry(outtype, geom.getSRID(), elemInfo, ordinates);
        }
        return null;
    }

    public static JGeometry addLine(JGeometry geom, JGeometry line) {
        if (geom == null || line == null) {
            return null;
        }
        if (line.getType() != 2) {
            return null;
        }
        return JGeometryUtil.addLineOrPolygon(geom, line);
    }

    public static JGeometry addPolygon(JGeometry geom, JGeometry polygon) {
        if (geom == null || polygon == null) {
            return null;
        }
        if (polygon.getType() != 3) {
            return null;
        }
        return JGeometryUtil.addLineOrPolygon(geom, polygon);
    }

    private static JGeometry addLineOrPolygon(JGeometry geom, JGeometry input) {
        if (geom == null || input == null) {
            return null;
        }
        if (input.getType() != 2 && input.getType() != 3) {
            return null;
        }
        if (geom.getSRID() != input.getSRID()) {
            return null;
        }
        int[] leinfo = input.getElemInfo();
        double[] loords = input.getOrdinatesArray();
        if (leinfo == null || loords == null) {
            return null;
        }
        int geomdim = geom.getDimensions();
        int inputdim = input.getDimensions();
        int type = geom.getType();
        int outtype = -1;
        if (input.getType() == 2) {
            outtype = 6;
            if (type != 2 && type != 6) {
                outtype = 4;
            }
        } else {
            outtype = 7;
            if (type != 3 && type != 7) {
                outtype = 4;
            }
        }
        outtype += geom.getDimensions() * 1000;
        if (type == 1) {
            int i;
            int[] elemInfo = new int[3 + leinfo.length];
            elemInfo[0] = 1;
            elemInfo[1] = 1;
            elemInfo[2] = 1;
            for (int i2 = 3; i2 < elemInfo.length; i2 += 3) {
                elemInfo[i2] = leinfo[i2 - 3] + geomdim;
                elemInfo[i2 + 1] = leinfo[i2 - 2];
                elemInfo[i2 + 2] = leinfo[i2 - 1];
            }
            int lnumpts = loords.length / inputdim;
            double[] ordinates = new double[geomdim + lnumpts * geomdim];
            double[] geompts = geom.getPoint();
            for (i = 0; i < geomdim; ++i) {
                ordinates[i] = geompts[i];
            }
            for (i = 0; i < lnumpts; ++i) {
                for (int j = 0; j < inputdim && j != geomdim; ++j) {
                    ordinates[geomdim + geomdim * i + j] = loords[inputdim * i + j];
                }
            }
            return new JGeometry(outtype, geom.getSRID(), elemInfo, ordinates);
        }
        int[] eInfo = geom.getElemInfo();
        double[] oords = geom.getOrdinatesArray();
        if (eInfo == null || oords == null) {
            return null;
        }
        int[] elemInfo = new int[eInfo.length + leinfo.length];
        System.arraycopy(eInfo, 0, elemInfo, 0, eInfo.length);
        for (int i = eInfo.length; i < elemInfo.length; i += 3) {
            elemInfo[i] = leinfo[i - eInfo.length] + oords.length;
            elemInfo[i + 1] = leinfo[i - eInfo.length + 1];
            elemInfo[i + 2] = leinfo[i - eInfo.length + 2];
        }
        int lnumpts = loords.length / inputdim;
        double[] ordinates = new double[oords.length + lnumpts * geomdim];
        System.arraycopy(oords, 0, ordinates, 0, oords.length);
        for (int i = 0; i < lnumpts; ++i) {
            for (int j = 0; j < inputdim && j != geomdim; ++j) {
                ordinates[oords.length + geomdim * i + j] = loords[inputdim * i + j];
            }
        }
        return new JGeometry(outtype, geom.getSRID(), elemInfo, ordinates);
    }

    private static JGeometry removeElement(JGeometry geom, int elemIndex, int elemType) {
        int i;
        if (geom == null || elemIndex == -1) {
            return null;
        }
        int gtype = geom.getType();
        if (gtype == 1 || gtype == 2 || gtype == 3) {
            return null;
        }
        int[] eInfo = geom.getElemInfo();
        double[] oords = geom.getOrdinatesArray();
        if (eInfo == null || oords == null) {
            return null;
        }
        JGeometry[] elems = JGeometryUtil.getElements(geom);
        if (elems == null) {
            return null;
        }
        if (elemIndex >= elems.length) {
            return null;
        }
        JGeometry elem = elems[elemIndex];
        if (elem == null || elem.getType() != elemType) {
            return null;
        }
        JGeometryElementInfo[] elemsInfo = JGeometryUtil.getElementsInfo(geom, elemIndex + 1);
        if (elemsInfo == null || elemsInfo.length == 0) {
            return null;
        }
        int eiStart = elemsInfo[0].getElementInfoStart();
        int eiEnd = elemsInfo[0].getElementInfoEnd();
        int oordStart = elemsInfo[0].getElementOordStart();
        int oordEnd = elemsInfo[0].getElementOordEnd();
        int numpts = 0;
        int numlines = 0;
        int numpols = 0;
        int outputType = -1;
        for (int i2 = 0; i2 < elems.length; ++i2) {
            if (i2 == elemIndex) continue;
            if (elems[i2].getType() == 1) {
                ++numpts;
                continue;
            }
            if (elems[i2].getType() == 2) {
                ++numlines;
                continue;
            }
            if (elems[i2].getType() != 3) continue;
            ++numpols;
        }
        if (numpts > 0) {
            outputType = numlines > 0 || numpols > 0 ? 4 : (numpts == 1 ? 1 : 5);
        } else if (numlines > 0) {
            outputType = numpols > 0 ? 4 : (numlines == 1 ? 2 : 6);
        } else if (numpols > 0) {
            outputType = numpols == 1 ? 3 : 7;
        }
        if (outputType == -1) {
            System.out.println("Unable to define output geometry type.");
            return null;
        }
        outputType += geom.getDimensions() * 1000;
        int eiextent = eiEnd - eiStart + 1;
        int ordextent = oordEnd - oordStart + 1;
        int[] elemInfo = null;
        double[] ordinates = null;
        if (elemType == 1 && eInfo[eiStart + 2] > 1) {
            elemInfo = new int[eInfo.length];
            for (i = 0; i < eiStart + 3; ++i) {
                elemInfo[i] = eInfo[i];
            }
            int n = eiStart + 2;
            elemInfo[n] = elemInfo[n] - 1;
            for (i = eiStart + 3; i < elemInfo.length; i += 3) {
                elemInfo[i] = eInfo[i] - ordextent;
                elemInfo[i + 1] = eInfo[i + 1];
                elemInfo[i + 2] = eInfo[i + 2];
            }
        } else {
            elemInfo = new int[eInfo.length - eiextent];
            for (i = 0; i < eiStart; ++i) {
                elemInfo[i] = eInfo[i];
            }
            for (i = eiStart; i < elemInfo.length; i += 3) {
                elemInfo[i] = eInfo[i + eiextent] - ordextent;
                elemInfo[i + 1] = eInfo[i + 1 + eiextent];
                elemInfo[i + 2] = eInfo[i + 2 + eiextent];
            }
        }
        ordinates = new double[oords.length - ordextent];
        for (i = 0; i < oordStart; ++i) {
            ordinates[i] = oords[i];
        }
        for (i = oordStart; i < ordinates.length; ++i) {
            ordinates[i] = oords[i + ordextent];
        }
        return new JGeometry(outputType, geom.getSRID(), elemInfo, ordinates);
    }

    public static JGeometry removeElements(JGeometry geom, int[] elemIndexes) {
        if (geom == null || elemIndexes == null || elemIndexes.length == 0) {
            return null;
        }
        int gtype = geom.getType();
        if (gtype == 1 || gtype == 2 || gtype == 3) {
            return null;
        }
        int[] eInfo = geom.getElemInfo();
        double[] oords = geom.getOrdinatesArray();
        if (eInfo == null || oords == null) {
            return null;
        }
        JGeometry[] elems = JGeometryUtil.getElements(geom);
        if (elems == null) {
            return null;
        }
        JGeometry outGeom = null;
        for (int i = 0; i < elems.length; ++i) {
            boolean toAdd = true;
            for (int j = 0; j < elemIndexes.length; ++j) {
                if (elemIndexes[j] != i) continue;
                toAdd = false;
                break;
            }
            if (!toAdd) continue;
            if (outGeom == null) {
                try {
                    outGeom = (JGeometry)elems[i].clone();
                }
                catch (Exception ex) {}
                continue;
            }
            if (elems[i].getType() == 1) {
                outGeom = JGeometryUtil.addPoint(outGeom, elems[i]);
                continue;
            }
            if (elems[i].getType() == 2) {
                outGeom = JGeometryUtil.addLine(outGeom, elems[i]);
                continue;
            }
            if (elems[i].getType() != 3) continue;
            outGeom = JGeometryUtil.addPolygon(outGeom, elems[i]);
        }
        return outGeom;
    }

    public static JGeometry removePoint(JGeometry geom, int elemIndex) {
        return JGeometryUtil.removeElement(geom, elemIndex, 1);
    }

    public static JGeometry removeLine(JGeometry geom, int elemIndex) {
        return JGeometryUtil.removeElement(geom, elemIndex, 2);
    }

    public static JGeometry removePolygon(JGeometry geom, int elemIndex) {
        return JGeometryUtil.removeElement(geom, elemIndex, 3);
    }

    public static JGeometry addVoidPolygon(JGeometry geom, int elemIndex, JGeometry voidPolygon) {
        int i;
        if (geom == null || elemIndex < 0 || voidPolygon == null) {
            return null;
        }
        if (voidPolygon.getType() != 3) {
            return null;
        }
        if (geom.getDimensions() != voidPolygon.getDimensions()) {
            return null;
        }
        if (geom.getSRID() != voidPolygon.getSRID()) {
            return null;
        }
        int[] eInfo = geom.getElemInfo();
        double[] oords = geom.getOrdinatesArray();
        if (eInfo == null || oords == null) {
            return null;
        }
        int[] voidInfo = voidPolygon.getElemInfo();
        if (voidInfo == null || voidPolygon.getOrdinatesArray() == null || voidInfo.length > 3) {
            return null;
        }
        JGeometry[] elems = JGeometryUtil.getElements(geom);
        if (elems == null) {
            return null;
        }
        if (elemIndex >= elems.length) {
            return null;
        }
        JGeometry elem = elems[elemIndex];
        if (elem == null || elem.getType() != 3) {
            return null;
        }
        JGeometryElementInfo[] elemsInfo = JGeometryUtil.getElementsInfo(geom, elemIndex + 1);
        if (elemsInfo == null || elemsInfo.length == 0) {
            return null;
        }
        int eiEnd = elemsInfo[0].getElementInfoEnd();
        int oordStart = elemsInfo[0].getElementOordStart();
        int oordEnd = elemsInfo[0].getElementOordEnd();
        boolean ccwExtRingOrientation = true;
        double[] extRingOords = new double[oordEnd - oordStart + 1];
        int count = 0;
        for (int k = oordStart; k <= oordEnd; ++k) {
            extRingOords[count++] = oords[k];
        }
        if (GeometryUtil.isClockwise(extRingOords)) {
            ccwExtRingOrientation = false;
        }
        int[] elemInfo = null;
        double[] ordinates = null;
        double[] voidOords = new double[voidPolygon.getOrdinatesArray().length];
        if (!GeometryUtil.isClockwise(voidPolygon.getOrdinatesArray()) && ccwExtRingOrientation || GeometryUtil.isClockwise(voidPolygon.getOrdinatesArray()) && !ccwExtRingOrientation) {
            voidOords = GeometryUtil.reverseCoordinates(voidPolygon.getOrdinatesArray(), voidPolygon.getDimensions());
        } else {
            System.arraycopy(voidPolygon.getOrdinatesArray(), 0, voidOords, 0, voidPolygon.getOrdinatesArray().length);
        }
        elemInfo = new int[eInfo.length + 3];
        ordinates = new double[oords.length + voidOords.length];
        for (i = 0; i <= eiEnd; ++i) {
            elemInfo[i] = eInfo[i];
        }
        elemInfo[eiEnd + 1] = oordEnd + 2;
        elemInfo[eiEnd + 2] = 2003;
        elemInfo[eiEnd + 3] = 1;
        for (i = eiEnd + 4; i < elemInfo.length; i += 3) {
            elemInfo[i] = eInfo[i - 3] + voidOords.length;
            elemInfo[i + 1] = eInfo[i - 2];
            elemInfo[i + 2] = eInfo[i - 1];
        }
        for (i = 0; i <= oordEnd; ++i) {
            ordinates[i] = oords[i];
        }
        for (i = 0; i < voidOords.length; ++i) {
            ordinates[oordEnd + i + 1] = voidOords[i];
        }
        for (i = oordEnd + 1; i < oords.length; ++i) {
            ordinates[i + voidOords.length] = oords[i];
        }
        return new JGeometry(geom.getType() + geom.getDimensions() * 1000, geom.getSRID(), elemInfo, ordinates);
    }

    public static JGeometry removeVoidPolygon(JGeometry geom, int elemIndex, int voidIndex) {
        int i;
        if (geom == null || elemIndex < 0 || voidIndex < 0) {
            return null;
        }
        int[] eInfo = geom.getElemInfo();
        double[] oords = geom.getOrdinatesArray();
        if (eInfo == null || oords == null) {
            return null;
        }
        JGeometry[] elems = JGeometryUtil.getElements(geom);
        if (elems == null) {
            return null;
        }
        if (elemIndex >= elems.length) {
            return null;
        }
        JGeometry elem = elems[elemIndex];
        if (elem == null || elem.getType() != 3) {
            return null;
        }
        JGeometryElementInfo[] elemsInfo = JGeometryUtil.getElementsInfo(geom, elemIndex + 1);
        if (elemsInfo == null || elemsInfo.length == 0) {
            return null;
        }
        int eiStart = elemsInfo[0].getElementInfoStart();
        int eiEnd = elemsInfo[0].getElementInfoEnd();
        if (eiEnd - eiStart + 1 < 4) {
            return null;
        }
        int voidEIstart = -1;
        int voidOOstart = -1;
        int voidOOend = -1;
        boolean voidFound = false;
        int voidIdx = -1;
        for (int i2 = eiStart; i2 < eiEnd; i2 += 3) {
            if (eInfo[i2 + 1] == 2003) {
                ++voidIdx;
            }
            if (voidIdx != voidIndex) continue;
            voidFound = true;
            voidEIstart = i2;
            voidOOstart = eInfo[i2] - 1;
            break;
        }
        if (!voidFound) {
            System.out.println("Void polygon (index=" + voidIndex + " not found");
            return null;
        }
        voidOOend = voidEIstart + 3 < eInfo.length ? eInfo[voidEIstart + 3] - 2 : oords.length - 1;
        int voidOOlength = voidOOend - voidOOstart + 1;
        int[] elemInfo = new int[eInfo.length - 3];
        double[] ordinates = new double[oords.length - voidOOlength];
        for (i = 0; i < voidEIstart; ++i) {
            elemInfo[i] = eInfo[i];
        }
        for (i = voidEIstart; i < elemInfo.length; i += 3) {
            elemInfo[i] = eInfo[i + 3] - voidOOlength;
            elemInfo[i + 1] = eInfo[i + 4];
            elemInfo[i + 2] = eInfo[i + 5];
        }
        for (i = 0; i < voidOOstart; ++i) {
            ordinates[i] = oords[i];
        }
        for (i = voidOOstart; i < ordinates.length; ++i) {
            ordinates[i] = oords[i + voidOOlength];
        }
        return new JGeometry(geom.getType() + geom.getDimensions() * 1000, geom.getSRID(), elemInfo, ordinates);
    }

    public static JGeometry breakLine(JGeometry geom, JGeometrySegmentPoint interPT) {
        if (geom == null || interPT == null) {
            return null;
        }
        int gtype = geom.getType();
        if (gtype == 1 || gtype == 5 || gtype == 3 || gtype == 7 || gtype == 6 || gtype == 4) {
            return null;
        }
        double[] oords = geom.getOrdinatesArray();
        if (oords == null) {
            return null;
        }
        int[] eInfo = geom.getElemInfo();
        if (eInfo == null) {
            return null;
        }
        JGeometrySegment segment = interPT.getSegment();
        Point2D point = interPT.getPoint();
        int ptLoc = interPT.getPointLocation();
        if (segment == null || point == null) {
            return null;
        }
        int elemIndex = segment.getElementIndex();
        int segIndex = segment.getSegmentIndex();
        int dim = geom.getDimensions();
        JGeometry elem = geom.getElementAt(elemIndex + 1);
        if (elem == null || elem.getType() != 2) {
            return null;
        }
        if (elem.getElemInfo() == null) {
            return null;
        }
        boolean compoundLine = false;
        if (elem.getElemInfo()[1] == 4) {
            compoundLine = true;
        } else if (elem.getElemInfo()[2] == 2) {
            System.out.println("Cannot break a line made with circular arcs.");
            return null;
        }
        JGeometryElementInfo[] elemsInfo = JGeometryUtil.getElementsInfo(geom, elemIndex + 1);
        if (elemsInfo == null || elemsInfo.length == 0) {
            return null;
        }
        int eiEnd = elemsInfo[0].getElementInfoEnd();
        int oordStart = elemsInfo[0].getElementOordStart();
        int oordEnd = elemsInfo[0].getElementOordEnd();
        int nvertexes = (oordEnd - oordStart + 1) / dim;
        if (segIndex == 0 && ptLoc == 0 || segIndex == nvertexes - 2 && ptLoc == 1) {
            return null;
        }
        int offset = 0;
        offset = ptLoc == 1 ? segIndex * dim + ptLoc * dim : segIndex * dim;
        int[] elemInfo = null;
        double[] ordinates = null;
        int dimSize = dim;
        if (ptLoc == 2) {
            dimSize = 2 * dim;
        }
        if (!compoundLine) {
            int i;
            elemInfo = new int[eInfo.length + 3];
            ordinates = new double[oords.length + dimSize];
            for (i = 0; i <= eiEnd; ++i) {
                elemInfo[i] = eInfo[i];
            }
            elemInfo[eiEnd + 1] = oordStart + offset + dimSize + 1;
            elemInfo[eiEnd + 2] = 2;
            elemInfo[eiEnd + 3] = 1;
            for (i = eiEnd + 4; i < elemInfo.length; i += 3) {
                elemInfo[i] = eInfo[i - 3] + dimSize;
                elemInfo[i + 1] = eInfo[i - 2];
                elemInfo[i + 2] = eInfo[i - 1];
            }
            for (i = 0; i < oordStart + offset + dim; ++i) {
                ordinates[i] = oords[i];
            }
            for (i = 0; i < dimSize; i += dim) {
                ordinates[oordStart + offset + dim + i] = point.getX();
                ordinates[oordStart + offset + dim + i + 1] = point.getY();
            }
            for (i = oordStart + offset + dim; i < oords.length; ++i) {
                ordinates[i + dimSize] = oords[i];
            }
        } else {
            System.out.println("Break of compound line is not supported yet.");
            return null;
        }
        int outType = geom.getType();
        if (outType == 2) {
            outType = 6;
        }
        return new JGeometry(outType + geom.getDimensions() * 1000, geom.getSRID(), elemInfo, ordinates);
    }

    public static JGeometry splitPolygon(JGeometry geom, JGeometrySegmentPoint[] segPoints, JGeometry[] splitLines) {
        int i;
        int i2;
        int l;
        int spdim;
        double[] spoords;
        int i3;
        if (geom == null || segPoints == null || segPoints.length == 0 || splitLines == null || splitLines.length == 0) {
            return null;
        }
        int gtype = geom.getType();
        if (gtype == 1 || gtype == 5 || gtype == 2 || gtype == 7 || gtype == 6 || gtype == 4) {
            return null;
        }
        int numSegPoints = segPoints.length;
        if (segPoints[0].getSegment().getElementIndex() != segPoints[numSegPoints - 1].getSegment().getElementIndex()) {
            return null;
        }
        if (numSegPoints > 2) {
            for (i3 = 2; i3 < numSegPoints; i3 += 2) {
                if (segPoints[i3].getSegment().getSubElementIndex() == segPoints[i3 + 1].getSegment().getSubElementIndex()) continue;
                return null;
            }
        }
        for (i3 = 0; i3 < splitLines.length; ++i3) {
            int spdim2 = splitLines[0].getDimensions();
            double[] spoords2 = splitLines[i3].getOrdinatesArray();
            if (spoords2 != null && spoords2.length / spdim2 >= 2) continue;
            return null;
        }
        int dim = geom.getDimensions();
        JGeometry elem = geom;
        if (elem == null || elem.getType() != 3) {
            return null;
        }
        double[] oords = elem.getOrdinatesArray();
        int[] einfo = elem.getElemInfo();
        if (einfo == null || oords == null) {
            return null;
        }
        boolean compoundPolygon = false;
        if (elem.getElemInfo()[1] == 1005) {
            compoundPolygon = true;
        }
        if (compoundPolygon) {
            System.out.println("Compound polygon not supported yet in split method.");
            return null;
        }
        int firstloc = segPoints[0].getPointLocation();
        int lastloc = segPoints[numSegPoints - 1].getPointLocation();
        int firstsegIndex = segPoints[0].getSegment().getSegmentIndex();
        int lastsegIndex = segPoints[numSegPoints - 1].getSegment().getSegmentIndex();
        if (numSegPoints == 2 && segPoints[0].getPoint().getX() == segPoints[numSegPoints - 1].getPoint().getX() && segPoints[0].getPoint().getY() == segPoints[numSegPoints - 1].getPoint().getY()) {
            System.out.println("Split at same segment point is not supported.");
            return null;
        }
        int npts = oords.length / dim;
        int nsegs = npts - 1;
        int nelems = einfo.length / 3;
        int lastoordIndex = oords.length - 1;
        if (nelems > 1) {
            lastoordIndex = einfo[3] - 1;
        }
        boolean sameSeg = false;
        double dist1 = Double.NaN;
        double dist2 = Double.NaN;
        if (segPoints.length == 2 && firstsegIndex == lastsegIndex) {
            sameSeg = true;
            Point2D pts1 = segPoints[0].getPoint();
            Point2D pts2 = segPoints[1].getPoint();
            double x = oords[firstsegIndex * dim];
            double y = oords[firstsegIndex * dim + 1];
            double deltax1 = pts1.getX() - x;
            double deltay1 = pts1.getY() - y;
            dist1 = Math.sqrt(deltax1 * deltax1 + deltay1 * deltay1);
            double deltax2 = pts2.getX() - x;
            double deltay2 = pts2.getY() - y;
            dist2 = Math.sqrt(deltax2 * deltax2 + deltay2 * deltay2);
        }
        ArrayList<Double> firstPart = new ArrayList<Double>();
        ArrayList<Double> secondPart = new ArrayList<Double>();
        int start = -1;
        int end = -1;
        if (firstsegIndex < lastsegIndex || sameSeg && dist1 < dist2) {
            if (firstloc == 0) {
                start = firstsegIndex * dim;
            } else if (firstloc == 1) {
                start = (firstsegIndex + 1) * dim;
            } else {
                start = (firstsegIndex + 1) * dim;
                firstPart.add(new Double(segPoints[0].getPoint().getX()));
                firstPart.add(new Double(segPoints[0].getPoint().getY()));
            }
            if (lastloc == 0 || lastloc == 2) {
                end = lastsegIndex * dim + dim;
            } else if (lastloc == 1) {
                end = (lastsegIndex + 1) * dim + dim;
            }
            for (int i4 = start; i4 < end; ++i4) {
                firstPart.add(new Double(oords[i4]));
            }
            if (lastloc == 2) {
                firstPart.add(new Double(segPoints[1].getPoint().getX()));
                firstPart.add(new Double(segPoints[1].getPoint().getY()));
            }
            spoords = splitLines[0].getOrdinatesArray();
            spdim = splitLines[0].getDimensions();
            for (l = spoords.length - dim; l > 0; l -= spdim) {
                firstPart.add(new Double(spoords[l - spdim]));
                firstPart.add(new Double(spoords[l - spdim + 1]));
            }
            if (lastloc == 0) {
                start = lastsegIndex * dim;
            } else if (lastloc == 1) {
                start = (lastsegIndex + 1) * dim;
            } else {
                start = (lastsegIndex + 1) * dim;
                secondPart.add(new Double(segPoints[1].getPoint().getX()));
                secondPart.add(new Double(segPoints[1].getPoint().getY()));
            }
            end = lastoordIndex + 1;
            for (i2 = start; i2 < end; ++i2) {
                secondPart.add(new Double(oords[i2]));
            }
            start = dim;
            if (firstloc == 0 || firstloc == 2) {
                end = firstsegIndex * dim + dim;
            } else if (firstloc == 1) {
                end = (firstsegIndex + 1) * dim + dim;
            }
            for (i2 = start; i2 < end; ++i2) {
                secondPart.add(new Double(oords[i2]));
            }
            if (firstloc == 2) {
                secondPart.add(new Double(segPoints[0].getPoint().getX()));
                secondPart.add(new Double(segPoints[0].getPoint().getY()));
            }
            for (l = dim; l < spoords.length; l += spdim) {
                secondPart.add(new Double(spoords[l]));
                secondPart.add(new Double(spoords[l + 1]));
            }
        } else if (firstsegIndex > lastsegIndex || sameSeg && dist1 > dist2) {
            if (lastloc == 0) {
                start = lastsegIndex * dim;
            } else if (lastloc == 1) {
                start = (lastsegIndex + 1) * dim;
            } else {
                start = (lastsegIndex + 1) * dim;
                firstPart.add(new Double(segPoints[1].getPoint().getX()));
                firstPart.add(new Double(segPoints[1].getPoint().getY()));
            }
            if (firstloc == 0 || firstloc == 2) {
                end = firstsegIndex * dim + dim;
            } else if (firstloc == 1) {
                end = (firstsegIndex + 1) * dim + dim;
            }
            for (int i5 = start; i5 < end; ++i5) {
                firstPart.add(new Double(oords[i5]));
            }
            if (firstloc == 2) {
                firstPart.add(new Double(segPoints[0].getPoint().getX()));
                firstPart.add(new Double(segPoints[0].getPoint().getY()));
            }
            spoords = splitLines[0].getOrdinatesArray();
            spdim = splitLines[0].getDimensions();
            for (l = dim; l < spoords.length; l += spdim) {
                firstPart.add(new Double(spoords[l]));
                firstPart.add(new Double(spoords[l + 1]));
            }
            if (firstloc == 0) {
                start = firstsegIndex * dim;
            } else if (firstloc == 1) {
                start = (firstsegIndex + 1) * dim;
            } else {
                start = (firstsegIndex + 1) * dim;
                secondPart.add(new Double(segPoints[0].getPoint().getX()));
                secondPart.add(new Double(segPoints[0].getPoint().getY()));
            }
            end = lastoordIndex + 1;
            for (i2 = start; i2 < end; ++i2) {
                secondPart.add(new Double(oords[i2]));
            }
            start = dim;
            if (lastloc == 0 || lastloc == 2) {
                end = lastsegIndex * dim + dim;
            } else if (lastloc == 1) {
                end = (lastsegIndex + 1) * dim + dim;
            }
            for (i2 = start; i2 < end; ++i2) {
                secondPart.add(new Double(oords[i2]));
            }
            if (lastloc == 2) {
                secondPart.add(new Double(segPoints[1].getPoint().getX()));
                secondPart.add(new Double(segPoints[1].getPoint().getY()));
            }
            for (l = spoords.length - dim; l > 0; l -= spdim) {
                secondPart.add(new Double(spoords[l - spdim]));
                secondPart.add(new Double(spoords[l - spdim + 1]));
            }
        } else {
            return null;
        }
        int outType = 7;
        int[] elemInfo = new int[]{1, 1003, 1, firstPart.size() + 1, 1003, 1};
        double[] ordinates = new double[firstPart.size() + secondPart.size()];
        for (i = 0; i < firstPart.size(); ++i) {
            ordinates[i] = (Double)firstPart.get(i);
        }
        for (i = 0; i < secondPart.size(); ++i) {
            ordinates[i + firstPart.size()] = (Double)secondPart.get(i);
        }
        return new JGeometry(outType + geom.getDimensions() * 1000, geom.getSRID(), elemInfo, ordinates);
    }

    public static boolean hasPoint(JGeometry geom) {
        if (geom == null) {
            return false;
        }
        int gtype = geom.getType();
        if (gtype == 1 || gtype == 5) {
            return true;
        }
        if (gtype != 4) {
            return false;
        }
        int[] eInfo = geom.getElemInfo();
        if (eInfo == null || eInfo.length < 3) {
            return false;
        }
        for (int i = 0; i < eInfo.length; i += 3) {
            if (eInfo[i + 1] != 1) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLine(JGeometry geom) {
        if (geom == null) {
            return false;
        }
        int gtype = geom.getType();
        if (gtype == 2 || gtype == 6) {
            return true;
        }
        if (gtype != 4) {
            return false;
        }
        int[] eInfo = geom.getElemInfo();
        if (eInfo == null || eInfo.length < 3) {
            return false;
        }
        for (int i = 0; i < eInfo.length; i += 3) {
            if (eInfo[i + 1] != 2 && eInfo[i + 1] != 4) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPolygon(JGeometry geom) {
        if (geom == null) {
            return false;
        }
        int gtype = geom.getType();
        if (gtype == 3 || gtype == 7) {
            return true;
        }
        if (gtype != 4) {
            return false;
        }
        int[] eInfo = geom.getElemInfo();
        if (eInfo == null || eInfo.length < 3) {
            return false;
        }
        for (int i = 0; i < eInfo.length; i += 3) {
            if (eInfo[i + 1] != 1003 && eInfo[i + 1] != 1005) continue;
            return true;
        }
        return false;
    }

    public static boolean hasVoidPolygon(JGeometry geom) {
        if (geom == null) {
            return false;
        }
        int gtype = geom.getType();
        if (gtype != 3 && gtype != 7 && gtype != 4) {
            return false;
        }
        int[] eInfo = geom.getElemInfo();
        if (eInfo == null || eInfo.length < 3) {
            return false;
        }
        for (int i = 0; i < eInfo.length; i += 3) {
            if (eInfo[i + 1] != 2003 && eInfo[i + 1] != 2005) continue;
            return true;
        }
        return false;
    }

    public static int identifyPointElement(JGeometry geom, Point2D point, double tolerance) {
        int elemIndex = -1;
        if (geom == null || point == null) {
            return -1;
        }
        JGeometry[] geoms = JGeometryUtil.getElements(geom);
        if (geoms == null) {
            return -1;
        }
        double minDist = Double.MAX_VALUE;
        for (int k = 0; k < geoms.length; ++k) {
            double dy;
            Point2D pt;
            double dx;
            double distance;
            int gtype = geoms[k].getType();
            if (gtype != 1 || !((distance = Math.sqrt((dx = (pt = geoms[k].getJavaPoint()).getX() - point.getX()) * dx + (dy = pt.getY() - point.getY()) * dy)) <= tolerance) || !(distance < minDist)) continue;
            minDist = distance;
            elemIndex = k;
            break;
        }
        return elemIndex;
    }

    public static int identifyLineElement(JGeometry geom, Point2D point, double tolerance) {
        int elemIndex = -1;
        if (geom == null || point == null) {
            return -1;
        }
        JGeometry[] geoms = JGeometryUtil.getElements(geom);
        if (geoms == null) {
            return -1;
        }
        double minDist = Double.MAX_VALUE;
        for (int k = 0; k < geoms.length; ++k) {
            Point2D[][] boundary;
            int gtype = geoms[k].getType();
            if (gtype != 2 || (boundary = JGeometryUtil.getBoundary(geoms[k])) == null) continue;
            Point2D[] bounds = boundary[0];
            for (int m = 0; m < bounds.length - 1; ++m) {
                Point2D p1 = bounds[m];
                Point2D p2 = bounds[m + 1];
                double[] dist = GeometryUtil.distToLine(point, p1, p2);
                if (!(dist[0] <= tolerance) || !(dist[0] < minDist)) continue;
                minDist = dist[0];
                elemIndex = k;
                break;
            }
            if (elemIndex > -1) break;
        }
        return elemIndex;
    }

    public static int identifyPolygonElement(JGeometry geom, Point2D point) {
        int elemIndex = -1;
        if (geom == null || point == null) {
            return -1;
        }
        JGeometry[] geoms = JGeometryUtil.getElements(geom);
        if (geoms == null) {
            return -1;
        }
        for (int k = 0; k < geoms.length; ++k) {
            Point2D[][] boundary;
            int gtype = geoms[k].getType();
            if (gtype != 3 || (boundary = JGeometryUtil.getBoundary(geoms[k])) == null) continue;
            int extbounds = 0;
            if (geoms[k].getElemInfo()[1] == 2003) {
                extbounds = boundary.length - 1;
            }
            if (!GeometryUtil.pointInPolygon(point, boundary[extbounds])) continue;
            if (boundary.length == 1) {
                elemIndex = k;
                break;
            }
            boolean insideVoid = false;
            int startVoids = 1;
            int endVoids = boundary.length - 1;
            if (geoms[k].getElemInfo()[1] == 2003) {
                startVoids = 0;
                endVoids = boundary.length - 2;
            }
            for (int l = startVoids; l <= endVoids; ++l) {
                if (!GeometryUtil.pointInPolygon(point, boundary[l])) continue;
                insideVoid = true;
                break;
            }
            if (insideVoid) continue;
            elemIndex = k;
            break;
        }
        return elemIndex;
    }

    public static int identifyVoidPolygonIndex(JGeometry geom, int polyElement, Point2D point) {
        int elemIndex = -1;
        if (geom == null || point == null || polyElement < 0) {
            return -1;
        }
        JGeometry[] geoms = JGeometryUtil.getElements(geom);
        if (geoms == null) {
            return -1;
        }
        if (polyElement >= geoms.length) {
            return -1;
        }
        int gtype = geoms[polyElement].getType();
        if (gtype != 3) {
            return -1;
        }
        Point2D[][] boundary = JGeometryUtil.getBoundary(geoms[polyElement]);
        if (boundary == null) {
            return -1;
        }
        if (boundary.length == 1) {
            return -1;
        }
        int extbounds = 0;
        if (geoms[polyElement].getElemInfo()[1] == 2003) {
            extbounds = boundary.length - 1;
        }
        int startVoids = 1;
        int endVoids = boundary.length - 1;
        if (geoms[polyElement].getElemInfo()[1] == 2003) {
            startVoids = 0;
            endVoids = boundary.length - 2;
        }
        int voidindex = 0;
        for (int l = startVoids; l <= endVoids; ++l) {
            if (GeometryUtil.pointInPolygon(point, boundary[l])) {
                elemIndex = voidindex;
                break;
            }
            ++voidindex;
        }
        return elemIndex;
    }

    public static int[] identifyPolygonElementAndVoidIndex(JGeometry geom, Point2D point) {
        if (geom == null || point == null) {
            return null;
        }
        JGeometry[] geoms = JGeometryUtil.getElements(geom);
        if (geoms == null) {
            return null;
        }
        for (int k = 0; k < geoms.length; ++k) {
            Point2D[][] boundary;
            int gtype = geoms[k].getType();
            if (gtype != 3 || (boundary = JGeometryUtil.getBoundary(geoms[k])) == null) continue;
            if (boundary.length == 1) {
                return null;
            }
            int extbounds = 0;
            if (geoms[k].getElemInfo()[1] == 2003) {
                extbounds = boundary.length - 1;
            }
            if (!GeometryUtil.pointInPolygon(point, boundary[extbounds])) continue;
            boolean insideVoid = false;
            int startVoids = 1;
            int endVoids = boundary.length - 1;
            if (geoms[k].getElemInfo()[1] == 2003) {
                startVoids = 0;
                endVoids = boundary.length - 2;
            }
            int voidindex = 0;
            for (int l = startVoids; l <= endVoids; ++l) {
                if (GeometryUtil.pointInPolygon(point, boundary[l])) {
                    int[] res = new int[]{k, voidindex};
                    return res;
                }
                ++voidindex;
            }
        }
        return null;
    }

    private static int getGeometryType(ArrayList<JGeometry> elems) {
        int numpts = 0;
        int numlines = 0;
        int numpols = 0;
        int outputType = -1;
        if (elems == null) {
            return -1;
        }
        for (int i = 0; i < elems.size(); ++i) {
            JGeometry elem = elems.get(i);
            if (elem.getType() == 1) {
                ++numpts;
                continue;
            }
            if (elem.getType() == 2) {
                ++numlines;
                continue;
            }
            if (elem.getType() != 3) continue;
            ++numpols;
        }
        if (numpts > 0) {
            outputType = numlines > 0 || numpols > 0 ? 4 : (numpts == 1 ? 1 : 5);
        } else if (numlines > 0) {
            outputType = numpols > 0 ? 4 : (numlines == 1 ? 2 : 6);
        } else if (numpols > 0) {
            outputType = numpols == 1 ? 3 : 7;
        }
        return outputType;
    }

    public static JGeometry getVoidBoundaryAsGeometry(JGeometry geom, int voidElement) {
        if (geom == null || geom.getType() != 3 || voidElement < 1) {
            return null;
        }
        double[] oords = geom.getOrdinatesArray();
        int[] eInfo = geom.getElemInfo();
        if (oords == null || eInfo == null) {
            return null;
        }
        int nrings = eInfo.length / 3;
        if (voidElement >= nrings) {
            return null;
        }
        int oordStart = eInfo[3 * voidElement];
        int oordEnd = oords.length + 1;
        if (voidElement < nrings - 1) {
            oordEnd = eInfo[3 * (voidElement + 1)];
        }
        double[] voidOords = new double[oordEnd - oordStart];
        int count = 0;
        for (int i = oordStart - 1; i < oordEnd - 1; ++i) {
            voidOords[count++] = oords[i];
        }
        JGeometry voidGeom = new JGeometry(3, geom.getSRID(), new int[]{1, 1003, 1}, GeometryUtil.reverseCoordinates(voidOords, geom.getDimensions()));
        return voidGeom;
    }

    public static int[] getGeometryElementsWithinBox(JGeometry geom, Rectangle2D mbr) {
        if (geom == null || mbr == null) {
            return null;
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        JGeometry[] elems = JGeometryUtil.getElements(geom);
        if (elems == null || elems.length == 0) {
            return null;
        }
        for (int i = 0; i < elems.length; ++i) {
            int dim = elems[i].getDimensions();
            double[] box = elems[i].getMBR();
            if (box == null) continue;
            if (elems[i].getType() == 1) {
                if (!mbr.contains(box[0], box[1])) continue;
                indexes.add(new Integer(i));
                continue;
            }
            Rectangle2D.Double embr = new Rectangle2D.Double(box[0], box[1], box[dim] - box[0], box[dim + 1] - box[1]);
            if (!mbr.contains(embr)) continue;
            indexes.add(new Integer(i));
        }
        if (indexes.size() == 0) {
            return null;
        }
        int[] output = new int[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            output[i] = (Integer)indexes.get(i);
        }
        return output;
    }

    public static JGeometry[] getElements(JGeometry geometry) {
        if (geometry == null) {
            return null;
        }
        JGeometry[] jgeomA = JGeometryUtil.getElements(geometry, -1);
        return jgeomA;
    }

    public static JGeometry[] getElements(JGeometry geometry, int position) {
        if (geometry == null) {
            return null;
        }
        ArrayList<JGeometry> al = new ArrayList<JGeometry>();
        JGeometry geom = null;
        int ecount = 0;
        int gtype = geometry.getType();
        int[] elemInfo = geometry.getElemInfo();
        double[] ordinates = geometry.getOrdinatesArray();
        int dim = geometry.getDimensions();
        int typeOffset = 1000 * dim;
        int srid = geometry.getSRID();
        if (gtype == 1 || gtype == 2 || gtype == 3) {
            al.add(geometry);
            ++ecount;
        } else if (gtype == 6 || gtype == 7 || gtype == 4 || gtype == 5) {
            if (elemInfo == null || ordinates == null) {
                return null;
            }
            int eistart = 0;
            int start = 0;
            int eiend = 0;
            int end = 0;
            for (int i = 0; i < elemInfo.length; i += 3) {
                int egtype;
                int egtype2;
                if (elemInfo[i + 1] == 2) {
                    if (++ecount == position || position == -1) {
                        egtype2 = 2;
                        start = elemInfo[i] - 1;
                        end = i + 3 < elemInfo.length ? elemInfo[i + 3] - 1 : ordinates.length;
                        geom = JGeometryUtil.makeElementGeometry(geometry, egtype2 + typeOffset, i, i + 3, start, end);
                        geom.setLRMDimension(geometry.getLRMDimension());
                        al.add(geom);
                    }
                    if (ecount != position) continue;
                    i = elemInfo.length;
                    continue;
                }
                if (elemInfo[i + 1] == 4) {
                    int subElems = elemInfo[i + 2];
                    if (++ecount == position || position == -1) {
                        egtype = 2;
                        eistart = i;
                        start = elemInfo[i] - 1;
                        if (i + 3 + 3 * subElems < elemInfo.length) {
                            end = elemInfo[i + 3 + 3 * subElems] - 1;
                            eiend = i + 3 + 3 * subElems;
                        } else {
                            end = ordinates.length;
                            eiend = elemInfo.length;
                        }
                        geom = JGeometryUtil.makeElementGeometry(geometry, egtype + typeOffset, eistart, eiend, start, end);
                        geom.setLRMDimension(geometry.getLRMDimension());
                        al.add(geom);
                    }
                    if (ecount == position) {
                        i = elemInfo.length;
                        continue;
                    }
                    i += 3 * subElems;
                    continue;
                }
                if (elemInfo[i + 1] == 1003 || elemInfo[i + 1] == 1005 || elemInfo[i + 1] == 3 || elemInfo[i + 1] == 5) {
                    ++ecount;
                    egtype2 = 3;
                    int top_e = elemInfo[i + 1];
                    eistart = i;
                    start = elemInfo[i] - 1;
                    boolean hasMore = false;
                    if ((top_e == 1003 || top_e == 3) && i + 3 < elemInfo.length) {
                        end = elemInfo[i + 3] - 1;
                        eiend = i + 3;
                        hasMore = true;
                    } else if ((top_e == 1005 || top_e == 5) && i + 3 + 3 * elemInfo[i + 2] < elemInfo.length) {
                        int subElems = elemInfo[i + 2];
                        end = elemInfo[i + 3 + 3 * subElems] - 1;
                        eiend = i + 3 + 3 * subElems;
                        i += 3 * subElems;
                        hasMore = true;
                    } else {
                        end = ordinates.length;
                        eiend = elemInfo.length;
                    }
                    boolean inner = true;
                    while (hasMore && inner) {
                        if (i + 3 + 1 < elemInfo.length) {
                            int nexte = elemInfo[i + 3 + 1];
                            if (nexte == 2003) {
                                if ((i += 3) + 3 < elemInfo.length) {
                                    end = elemInfo[i + 3] - 1;
                                    eiend = i + 3;
                                } else {
                                    end = ordinates.length;
                                    eiend = elemInfo.length;
                                }
                                inner = true;
                                continue;
                            }
                            if (nexte == 2005) {
                                int isubElems;
                                if ((i += 3) + 3 + 3 * (isubElems = elemInfo[i + 2]) < elemInfo.length) {
                                    end = elemInfo[i + 3 + 3 * isubElems] - 1;
                                    eiend = i + 3 + 3 * isubElems;
                                    inner = true;
                                } else {
                                    end = ordinates.length;
                                    eiend = elemInfo.length;
                                    inner = false;
                                }
                                i += 3 * isubElems;
                                continue;
                            }
                            inner = false;
                            continue;
                        }
                        hasMore = false;
                    }
                    if (ecount == position || position == -1) {
                        geom = JGeometryUtil.makeElementGeometry(geometry, egtype2 + typeOffset, eistart, eiend, start, end);
                        al.add(geom);
                    }
                    if (ecount != position) continue;
                    i = elemInfo.length;
                    continue;
                }
                if (elemInfo[i + 1] == 1) {
                    int eitpr = elemInfo[i + 2];
                    egtype = 1;
                    start = elemInfo[i] - 1;
                    boolean isOriPoint = false;
                    if (eitpr >= 1) {
                        if (i + 3 < elemInfo.length) {
                            if (eitpr == 1 && elemInfo[i + 4] == 1 && elemInfo[i + 5] == 0) {
                                isOriPoint = true;
                            }
                            if (isOriPoint && i + 6 < elemInfo.length) {
                                end = elemInfo[i + 6] - 1;
                            } else if (isOriPoint) {
                                end = ordinates.length;
                            }
                        }
                        for (int j = 0; j < eitpr; ++j) {
                            ++ecount;
                            if (dim == 2 && !isOriPoint) {
                                if (ecount == position || position == -1) {
                                    geom = new JGeometry(ordinates[start], ordinates[start + 1], srid);
                                    al.add(geom);
                                }
                                if (ecount == position) {
                                    j = eitpr;
                                    i = elemInfo.length;
                                    continue;
                                }
                                start += 2;
                                continue;
                            }
                            if (dim == 3 && !isOriPoint) {
                                if (ecount == position || position == -1) {
                                    geom = new JGeometry(ordinates[start], ordinates[start + 1], ordinates[start + 2], srid);
                                    al.add(geom);
                                }
                                if (ecount == position) {
                                    j = eitpr;
                                    i = elemInfo.length;
                                    continue;
                                }
                                start += 3;
                                continue;
                            }
                            if (!isOriPoint) {
                                if (ecount == position || position == -1) {
                                    int[] eia = new int[]{1, 1, 1};
                                    double[] eoa = new double[dim];
                                    eoa = JGeometryUtil.getOrdinatesOfElement(geometry, start, start + dim);
                                    geom = new JGeometry(egtype + typeOffset, srid, eia, eoa);
                                    al.add(geom);
                                }
                                if (ecount == position) {
                                    j = eitpr;
                                    i = elemInfo.length;
                                    continue;
                                }
                                start += dim;
                                continue;
                            }
                            if (!isOriPoint) continue;
                            if (ecount == position || position == -1) {
                                geom = JGeometryUtil.makeElementGeometry(geometry, egtype, i, i + 6, start, end);
                                al.add(geom);
                            }
                            if (ecount == position) {
                                j = eitpr;
                                i = elemInfo.length;
                                continue;
                            }
                            i += 3;
                        }
                        continue;
                    }
                    return null;
                }
                i += 3;
            }
        }
        if (position > ecount || ecount == 0) {
            return null;
        }
        JGeometry[] jga = new JGeometry[al.size()];
        return al.toArray(jga);
    }

    private static double[] getOrdinatesOfElement(JGeometry geom, int start, int end) {
        if (geom == null) {
            return null;
        }
        double[] ordinates = geom.getOrdinatesArray();
        if (ordinates == null) {
            return null;
        }
        double[] elemOrdArray = new double[end - start];
        int n = 0;
        for (int i = start; i < end; ++i) {
            elemOrdArray[n] = ordinates[i];
            ++n;
        }
        return elemOrdArray;
    }

    private static int[] getElemInfoOfElement(JGeometry geom, int start, int end) {
        if (geom == null) {
            return null;
        }
        int[] elemInfo = geom.getElemInfo();
        if (elemInfo == null) {
            return null;
        }
        int[] elemInfoArray = new int[end - start];
        int n = 0;
        int offset = elemInfo[start] - 1;
        for (int i = start; i < end; i += 3) {
            elemInfoArray[n] = elemInfo[i] - offset;
            elemInfoArray[n + 1] = elemInfo[i + 1];
            elemInfoArray[n + 2] = elemInfo[i + 2];
            n += 3;
        }
        return elemInfoArray;
    }

    private static JGeometry makeElementGeometry(JGeometry geom, int egtype, int eistart, int eiend, int start, int end) {
        if (geom == null) {
            return null;
        }
        int[] eia = new int[eiend - eistart];
        eia = JGeometryUtil.getElemInfoOfElement(geom, eistart, eiend);
        double[] eoa = new double[end - start];
        eoa = JGeometryUtil.getOrdinatesOfElement(geom, start, end);
        JGeometry geo = new JGeometry(egtype, geom.getSRID(), eia, eoa);
        return geo;
    }
}

