/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.ds;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.mapviewer.share.ArrayParameter;
import oracle.mapviewer.share.MVThemeMetadata;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.UserIdentity;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;
import org.w3c.dom.Node;

public class DSUtil {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static String STRING_TABLE_TYPE = "MV_STRINGLIST";
    public static String NUMBER_TABLE_TYPE = "MV_NUMBERLIST";
    public static String DATE_TABLE_TYPE = "MV_DATELIST";
    static String arrayDDL1 = "CREATE or REPLACE type " + STRING_TABLE_TYPE + " as TABLE of VARCHAR2(1000)";
    static String arrayDDL2 = "CREATE or REPLACE type " + NUMBER_TABLE_TYPE + " as TABLE of NUMBER";
    static String arrayDDL3 = "CREATE or REPLACE type " + DATE_TABLE_TYPE + " as TABLE of DATE";

    public static final Connection getDBConnection(String datasrc, VisContext vc) throws SQLException {
        String key;
        Connection conn = null;
        DBDataSource ds = (DBDataSource)DSManager.get(datasrc);
        if (ds == null) {
            throw new SQLException("data-src object not found.");
        }
        if (vc == null) {
            return ds.getConnection();
        }
        UserIdentity ids = vc.getUserIdentity();
        if (ids == null) {
            return ds.getConnection();
        }
        Hashtable userNames = ids.getUserNames();
        String userId = (String)userNames.get(key = ds.getWebUserType());
        if (userId == null) {
            return ds.getConnection();
        }
        if (ds.useProxySession()) {
            Properties p = new Properties();
            p.put("PROXY_USER_NAME", userId);
            conn = ds.getProxyConnection(ds.getProxyType(), p);
            return conn;
        }
        conn = ds.getConnection();
        String plsqlpkg = ds.getUserInfoPackageName();
        if (plsqlpkg != null && userId != null && ds.isUserIfnoPackageValid()) {
            try {
                String call = "{CALL " + plsqlpkg + ".set_user(?)}";
                CallableStatement cstmt = conn.prepareCall(call);
                cstmt.setString(1, userId);
                cstmt.executeUpdate();
                cstmt.close();
                log.finest("package " + plsqlpkg + ".set_user called for :" + userId + ".");
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error setting web user info in the database.", e);
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void closeDBConnection(Connection conn, String dataSrc) {
        if (conn == null) {
            throw new IllegalArgumentException("Null connection found.");
        }
        if (dataSrc == null) {
            try {
                conn.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new IllegalArgumentException("Null data source found.");
        }
        try {
            OracleConnection oc;
            String plsqlpkg;
            DBDataSource ds = (DBDataSource)DSManager.get(dataSrc);
            if (ds != null && (plsqlpkg = ds.getUserInfoPackageName()) != null && ds.isUserIfnoPackageValid()) {
                try {
                    String call = "{CALL " + plsqlpkg + ".clear_user()}";
                    CallableStatement cstmt = conn.prepareCall(call);
                    cstmt.executeUpdate();
                    cstmt.close();
                    log.finest("package " + plsqlpkg + ".clear_user called.");
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Error clearing web user info in the database.", e);
                }
            }
            if (conn instanceof OracleConnection && (oc = (OracleConnection)conn).isProxySession()) {
                oc.close(1);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
    }

    public static boolean validPLSQLPackage(Connection conn, String pkg) {
        if (conn == null) {
            throw new IllegalArgumentException("invalid/null connection.");
        }
        try {
            String call = "{CALL " + pkg + ".clear_user()}";
            CallableStatement cstmt = conn.prepareCall(call);
            cstmt.executeUpdate();
            cstmt.close();
            log.finest("package " + pkg + ".clear_user called. The package is valid.");
            return true;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error clearing web user info in the database.", e);
            return false;
        }
    }

    public static void createArrayTypes(Connection conn, String dataSrc) {
        ArrayDescriptor ad1 = null;
        ArrayDescriptor ad2 = null;
        ArrayDescriptor ad3 = null;
        ad1 = DSUtil.getArrayDescriptor(conn, "string", true);
        ad2 = DSUtil.getArrayDescriptor(conn, "number", true);
        ad3 = DSUtil.getArrayDescriptor(conn, "date", true);
        if (ad1 != null && ad2 != null && ad3 != null) {
            return;
        }
        Statement st = null;
        try {
            st = conn.createStatement();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Cannot create a statement.", ex);
        }
        try {
            if (ad1 == null) {
                st.executeUpdate(arrayDDL1);
                log.info("SQL array type created by MapViewer: " + STRING_TABLE_TYPE);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Cannot create SQL array type " + STRING_TABLE_TYPE + ".", ex);
            log.log(Level.WARNING, "Make sure you run the following in the schema of " + dataSrc + ":\n " + arrayDDL1);
        }
        try {
            if (ad2 == null) {
                st.executeUpdate(arrayDDL2);
                log.info("SQL array type created by MapViewer: " + NUMBER_TABLE_TYPE);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Cannot create SQL array type " + NUMBER_TABLE_TYPE + ".", ex);
            log.log(Level.WARNING, "Make sure you run the following in the schema of " + dataSrc + ":\n " + arrayDDL2);
        }
        try {
            if (ad3 == null) {
                st.executeUpdate(arrayDDL3);
                log.info("SQL array type created by MapViewer: " + DATE_TABLE_TYPE);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Cannot create SQL array type " + DATE_TABLE_TYPE + ".", ex);
            log.log(Level.WARNING, "Make sure you run the following in the schema of " + dataSrc + ":\n " + arrayDDL3);
        }
        try {
            st.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static ArrayDescriptor getArrayDescriptor(Connection conn, String etype, boolean probingOnly) {
        String typeName = "";
        if ("STRING".equalsIgnoreCase(etype)) {
            typeName = STRING_TABLE_TYPE;
        } else if ("NUMBER".equalsIgnoreCase(etype)) {
            typeName = NUMBER_TABLE_TYPE;
        } else if ("DATE".equalsIgnoreCase(etype)) {
            typeName = DATE_TABLE_TYPE;
        } else {
            log.warning("Invalid array element type: " + etype);
            return null;
        }
        try {
            ArrayDescriptor arrayDescriptor = (ArrayDescriptor)((OracleConnection)conn).getDescriptor(typeName);
            if (arrayDescriptor == null) {
                arrayDescriptor = ArrayDescriptor.createDescriptor((String)typeName, (Connection)conn);
            }
            return arrayDescriptor;
        }
        catch (Exception ex) {
            if (!probingOnly) {
                log.warning("Unable to get or create SQL array type: " + typeName);
                log.warning("Make sure you have created the 3 SQL types in your database:\n" + arrayDDL1 + "\n" + arrayDDL2 + "\n" + arrayDDL3 + "\n");
            }
            return null;
        }
    }

    static String getMetaDataQueryString(int type, boolean singleSelection) {
        switch (type) {
            case 1: {
                return singleSelection ? "select * from user_sdo_styles where name=?" : "select * from user_sdo_styles";
            }
            case 2: {
                return singleSelection ? "select * from user_sdo_themes where name=?" : "select * from user_sdo_themes";
            }
            case 3: {
                return singleSelection ? "select * from user_sdo_maps where name=?" : "select * from user_sdo_maps";
            }
            case 4: {
                return singleSelection ? "select * from user_sdo_cached_maps where name=?" : "select * from user_sdo_cached_maps";
            }
            case 6: {
                return singleSelection ? "select * from user_sdo_edit_sessions where name=?" : "select * from user_sdo_edit_sessions";
            }
            case 5: {
                return singleSelection ? "select * from user_sdo_tile_admin_tasks where id=?" : "select * from user_sdo_tile_admin_tasks";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getMetaDataDefinition(Connection conn, String name, int type) throws SQLException {
        String query = DSUtil.getMetaDataQueryString(type, true);
        if (query == null) {
            return null;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        pstmt = conn.prepareStatement(query);
        pstmt.setString(1, name.toUpperCase());
        rs = pstmt.executeQuery();
        if (!rs.next()) {
            HashMap hashMap = null;
            return hashMap;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ResultSetMetaData meta = rs.getMetaData();
        int cc = meta.getColumnCount();
        for (int colIndex = 1; colIndex < cc + 1; ++colIndex) {
            int sqlType = meta.getColumnType(colIndex);
            String dbTypeName = meta.getColumnTypeName(colIndex).toUpperCase();
            String cname = meta.getColumnName(colIndex);
            Object value = DSUtil.readColumnValue(rs, colIndex, sqlType, dbTypeName);
            map.put(cname, value);
        }
        HashMap<String, Object> hashMap = map;
        return hashMap;
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public static HashMap[] getMetaDataDefinitionSet(Connection conn, int type) throws SQLException {
        return null;
    }

    public static Object readColumnValue(ResultSet rs, int colIndex, int sqlType, String dbTypeName) throws SQLException {
        Object value = null;
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                value = rs.getString(colIndex);
                break;
            }
            case -5: 
            case 4: 
            case 5: {
                value = new Long(rs.getLong(colIndex));
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                value = new Double(rs.getDouble(colIndex));
            }
            case 2005: 
            case 2011: {
                try {
                    value = Util.getClobContents(rs.getClob(colIndex));
                }
                catch (IOException e) {
                    log.warning("Error reading clob contents." + e.getMessage());
                }
                break;
            }
            case 2004: {
                try {
                    value = Util.getBlobContents(rs.getBlob(colIndex));
                }
                catch (IOException e) {
                    log.warning("Error reading blob contents." + e.getMessage());
                }
                break;
            }
            case 2002: {
                if (dbTypeName.indexOf("SDO_GEOMETRY") >= 0) {
                    try {
                        STRUCT st = (STRUCT)rs.getObject(colIndex);
                        value = JGeometry.load((STRUCT)st);
                    }
                    catch (Exception e) {
                        log.warning("Error loading geometry." + e.getMessage());
                    }
                    break;
                }
                if (dbTypeName.indexOf("SDO_NUMBER_ARRAY") >= 0) {
                    Array array = rs.getArray(colIndex);
                    BigDecimal[] bdArray = (BigDecimal[])array.getArray();
                    int[] intArray = null;
                    if (bdArray != null) {
                        intArray = new int[bdArray.length];
                        for (int i = 0; i < bdArray.length; ++i) {
                            intArray[i] = bdArray[i].intValue();
                        }
                    }
                    value = intArray;
                    break;
                }
                log.warning("Unknown column type encountered. " + dbTypeName);
                break;
            }
            default: {
                value = rs.getString(colIndex);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSpatialTablesAndTypes(String dataSource, String[] types, boolean allUsers) {
        if (dataSource == null) {
            return null;
        }
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        boolean processGeometry = false;
        boolean processAnnotation = false;
        boolean processGeoraster = false;
        boolean processTopology = false;
        if (types == null || types.length == 0) {
            processGeometry = true;
            processAnnotation = true;
            processGeoraster = true;
            processTopology = true;
        } else {
            for (int i = 0; i < types.length; ++i) {
                if (types[i].equalsIgnoreCase("ANNOTATIONTEXT")) {
                    processAnnotation = true;
                    continue;
                }
                if (types[i].equalsIgnoreCase("GEOMETRY")) {
                    processGeometry = true;
                    continue;
                }
                if (types[i].equalsIgnoreCase("GEORASTER")) {
                    processGeoraster = true;
                    continue;
                }
                if (!types[i].equalsIgnoreCase("TOPOLOGY")) continue;
                processTopology = true;
            }
        }
        ArrayList<String> registeredTables = new ArrayList<String>();
        String query = null;
        try {
            String owner;
            Object tbName;
            conn = DSUtil.getDBConnection(dataSource, null);
            String user = conn.getMetaData().getUserName();
            boolean isOracleDB = true;
            if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                isOracleDB = false;
            }
            String dbVersion = "";
            boolean is10gOrAfter = true;
            if (processGeometry) {
                if (isOracleDB) {
                    dbVersion = Util.getDBVersion(conn);
                    is10gOrAfter = Util.is10gOrAfter(conn);
                    if (allUsers) {
                        query = is10gOrAfter ? "select distinct table_name, owner from (select table_name, column_name, owner from all_sdo_geom_metadata  minus  select table_name, column_name, table_owner from all_sdo_topo_metadata) order by table_name" : "select distinct table_name, owner from all_sdo_geom_metadata order by table_name";
                        log.finest("Query to load geometry metadata:\n" + query);
                        st = conn.prepareStatement(query);
                        rs = st.executeQuery();
                    } else {
                        if (is10gOrAfter) {
                            query = "select distinct table_name, owner from ((select table_name, column_name, owner from all_sdo_geom_metadata where owner = :1 minus  select table_name, column_name, table_owner from all_sdo_topo_metadata where table_owner = :2) union all (select 'DUMMY.VALUE' table_name, column_name, owner from  (select table_name, column_name, owner from all_sdo_geom_metadata where owner <> :3 minus  select table_name, column_name, table_owner from all_sdo_topo_metadata where table_owner <> :4))) order by table_name";
                            st = conn.prepareStatement(query);
                            st.setString(1, user.toUpperCase());
                            st.setString(2, user.toUpperCase());
                            st.setString(3, user.toUpperCase());
                            st.setString(4, user.toUpperCase());
                        } else {
                            query = "select distinct table_name, owner from all_sdo_geom_metadata  where owner = :1  union all select distinct 'DUMMY.VALUE', owner from all_sdo_geom_metadata  where owner <> :2  order by table_name";
                            st = conn.prepareStatement(query);
                            st.setString(1, user.toUpperCase());
                            st.setString(2, user.toUpperCase());
                        }
                        log.finest("Query to load geometry metadata:\n" + query);
                        rs = st.executeQuery();
                    }
                    while (rs.next()) {
                        tbName = rs.getString(1);
                        if (((String)tbName).endsWith("_LT")) continue;
                        owner = rs.getString(2);
                        registeredTables.add(owner + "." + (String)tbName + ":GEOMETRY");
                    }
                    rs.close();
                    st.close();
                } else {
                    query = "select table_name from user_sdo_geom_metadata order by table_name";
                    log.finest("Query to load geometry metadata:\n" + query);
                    st = conn.prepareStatement(query);
                    rs = st.executeQuery();
                    while (rs.next()) {
                        tbName = rs.getString(1);
                        registeredTables.add(user + "." + (String)tbName + ":GEOMETRY");
                    }
                    rs.close();
                    st.close();
                }
            }
            if (!isOracleDB) {
                if (registeredTables.size() > 0) {
                    Collections.sort(registeredTables);
                }
                tbName = registeredTables;
                return tbName;
            }
            if (is10gOrAfter) {
                if (processGeoraster) {
                    if (allUsers) {
                        query = "select distinct table_name, owner from all_sdo_geor_sysdata order by table_name";
                        st = conn.prepareStatement(query);
                    } else {
                        query = "select distinct table_name, owner from all_sdo_geor_sysdata  where owner = :1  union all select distinct 'DUMMY.VALUE', owner from all_sdo_geor_sysdata  where owner <> :2 order by table_name";
                        st = conn.prepareStatement(query);
                        st.setString(1, user.toUpperCase());
                        st.setString(2, user.toUpperCase());
                    }
                    log.finest("Query to load georaster metadata:\n" + query);
                    rs = st.executeQuery();
                    while (rs.next()) {
                        tbName = rs.getString(1);
                        if (((String)tbName).endsWith("_LT")) continue;
                        owner = rs.getString(2);
                        registeredTables.add(owner + "." + (String)tbName + ":GEORASTER");
                    }
                    rs.close();
                    st.close();
                }
                if (processTopology) {
                    if (allUsers) {
                        query = "select distinct table_name, table_owner from all_sdo_topo_metadata order by table_name";
                        st = conn.prepareStatement(query);
                    } else {
                        query = "select table_name, table_owner from (select distinct table_name, table_owner from all_sdo_topo_metadata  where table_owner = :1  union all select distinct 'DUMMY.VALUE', a.table_owner from all_sdo_topo_metadata a, all_tables b  where a.table_owner <> :2  and a.table_owner = b.owner and a.table_name = b.table_name)  order by table_name";
                        st = conn.prepareStatement(query);
                        st.setString(1, user.toUpperCase());
                        st.setString(2, user.toUpperCase());
                    }
                    log.finest("Query to load topology metadata:\n" + query);
                    rs = st.executeQuery();
                    while (rs.next()) {
                        String topoTable = rs.getString(1);
                        String tb_schema = rs.getString(2);
                        if (topoTable == null) continue;
                        if (topoTable.endsWith("_LT")) {
                            int idx = topoTable.lastIndexOf("_LT");
                            topoTable = topoTable.substring(0, idx);
                        }
                        registeredTables.add(tb_schema + "." + topoTable + ":TOPOLOGY");
                    }
                    rs.close();
                    st.close();
                }
            }
            if (processAnnotation && (Util.is11gOrAfter(conn) || dbVersion.indexOf("10.2.0.3") > 0 || dbVersion.indexOf("10.2.0.4") > 0)) {
                if (allUsers) {
                    query = "select distinct table_name, owner from all_annotation_text_metadata order by table_name";
                    st = conn.prepareStatement(query);
                } else {
                    query = "select distinct table_name, owner from all_annotation_text_metadata  where owner = :1  union all select distinct 'DUMMY.VALUE', owner from all_annotation_text_metadata  where owner <> :2 order by table_name";
                    st = conn.prepareStatement(query);
                    st.setString(1, user.toUpperCase());
                    st.setString(2, user.toUpperCase());
                }
                log.finest("Query to load annotation text metadata:\n" + query);
                rs = st.executeQuery();
                while (rs.next()) {
                    tbName = rs.getString(1);
                    if (((String)tbName).endsWith("_LT")) continue;
                    owner = rs.getString(2);
                    registeredTables.add(owner + "." + (String)tbName + ":ANNOTATIONTEXT");
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    DSUtil.closeDBConnection(conn, dataSource);
                }
                catch (Exception re) {}
            }
        }
        if (registeredTables.size() > 0) {
            Collections.sort(registeredTables);
        }
        return registeredTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSpatialModelsAndTypes(String dataSource, String[] types, boolean allUsers) {
        if (dataSource == null) {
            return null;
        }
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        boolean processNetwork = false;
        boolean processTopology = false;
        if (types == null || types.length == 0) {
            processNetwork = true;
            processTopology = true;
        } else {
            for (int i = 0; i < types.length; ++i) {
                if (types[i].equalsIgnoreCase("NETWORK")) {
                    processNetwork = true;
                    continue;
                }
                if (!types[i].equalsIgnoreCase("TOPOLOGY")) continue;
                processTopology = true;
            }
        }
        boolean hasSelectAnyTable = DSUtil.sessionHasPrivilege(dataSource, "SELECT ANY TABLE");
        ArrayList<String> registeredModels = new ArrayList<String>();
        try {
            conn = DSUtil.getDBConnection(dataSource, null);
            String user = conn.getMetaData().getUserName();
            if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                ArrayList<String> arrayList = registeredModels;
                return arrayList;
            }
            if (Util.is10gOrAfter(conn)) {
                String tb_schema;
                String query = null;
                if (processNetwork) {
                    if (allUsers) {
                        query = "select distinct network, owner from all_sdo_network_metadata order by network";
                        log.finest("Query to network model metadata:\n" + query);
                        st = conn.prepareStatement(query);
                        rs = st.executeQuery();
                    } else {
                        query = hasSelectAnyTable ? "select network, owner from (select distinct network, owner from all_sdo_network_metadata where owner = :1 union all select distinct 'DUMMY.VALUE' network, owner from all_sdo_network_metadata where owner <> :2 )  order by network" : "select network, owner from (select distinct network, owner from all_sdo_network_metadata where owner = :1 union all select /*+ RULE */ distinct 'DUMMY.VALUE' network, a.owner from all_sdo_network_metadata a, user_tab_privs b where a.owner <> :2  and b.privilege = 'SELECT' and a.owner = b.owner and  (a.link_table_name = b.table_name or   a.node_table_name = b.table_name or   a.path_table_name = b.table_name or   a.path_link_table_name = b.table_name))  order by network";
                        log.finest("Query to network model metadata:\n" + query);
                        st = conn.prepareStatement(query);
                        st.setString(1, user.toUpperCase());
                        st.setString(2, user.toUpperCase());
                        rs = st.executeQuery();
                    }
                    while (rs.next()) {
                        String netName = rs.getString(1);
                        tb_schema = rs.getString(2);
                        if (netName == null) continue;
                        registeredModels.add(tb_schema + "." + netName + ":NETWORK");
                    }
                    rs.close();
                    st.close();
                }
                if (processTopology) {
                    if (allUsers) {
                        query = "select distinct topology, owner from all_sdo_topo_metadata order by topology";
                        log.finest("Query to topology model metadata:\n" + query);
                        st = conn.prepareStatement(query);
                        rs = st.executeQuery();
                    } else {
                        query = hasSelectAnyTable ? "select topology, owner from (select distinct topology, owner from all_sdo_topo_metadata where owner = :1 union all select distinct 'DUMMY.VALUE' topology, owner from all_sdo_topo_metadata where owner <> :2 ) order by topology" : "select topology, owner from (select distinct topology, owner from all_sdo_topo_metadata where owner = :1 union all select distinct 'DUMMY.VALUE' topology, a.owner from all_sdo_topo_metadata a, user_tab_privs b where a.owner <> :2  and b.privilege = 'SELECT' and a.owner = b.owner and  (a.topology || '_FACE$' = b.table_name or  a.topology || '_EDGE$' = b.table_name or  a.topology || '_NODE$' = b.table_name or  a.topology || '_RELATION$' = b.table_name))  order by topology";
                        log.finest("Query to topology model metadata:\n" + query);
                        st = conn.prepareStatement(query);
                        st.setString(1, user.toUpperCase());
                        st.setString(2, user.toUpperCase());
                        rs = st.executeQuery();
                    }
                    while (rs.next()) {
                        String topoName = rs.getString(1);
                        tb_schema = rs.getString(2);
                        if (topoName == null) continue;
                        registeredModels.add(tb_schema + "." + topoName + ":TOPOLOGY");
                    }
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    DSUtil.closeDBConnection(conn, dataSource);
                }
                catch (Exception re) {}
            }
        }
        if (registeredModels.size() > 0) {
            Collections.sort(registeredModels);
        }
        return registeredModels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sessionHasPrivilege(String dataSource, String priv) {
        block41: {
            boolean bl;
            if (dataSource == null || priv == null) {
                return false;
            }
            Connection conn = null;
            Statement st = null;
            ResultSet rs = null;
            String querystr = null;
            try {
                conn = DSUtil.getDBConnection(dataSource, null);
                if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                    boolean bl2 = false;
                    return bl2;
                }
                querystr = "select * from session_privs where privilege = :1";
                st = conn.prepareStatement(querystr);
                st.setString(1, priv.toUpperCase());
                rs = st.executeQuery();
                if (!rs.next()) break block41;
                bl = true;
            }
            catch (Exception ex) {
                break block41;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception re) {}
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception re) {}
                }
                if (conn != null) {
                    try {
                        DSUtil.closeDBConnection(conn, dataSource);
                    }
                    catch (Exception re) {}
                }
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAnnotationTextTables(String dataSource, String userName) {
        if (dataSource == null || userName == null) {
            return null;
        }
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        ArrayList<String> tables = new ArrayList<String>();
        try {
            conn = DSUtil.getDBConnection(dataSource, null);
            if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                List list = null;
                return list;
            }
            String dbVersion = Util.getDBVersion(conn);
            boolean is11gOrAfter = Util.is11gOrAfter(conn);
            String query = null;
            if (is11gOrAfter || dbVersion.indexOf("10.2.0.3") > 0 || dbVersion.indexOf("10.2.0.4") > 0) {
                query = "select distinct table_name, owner from all_annotation_text_metadata  where owner = :1  order by table_name";
                log.finest("Query to load annotation text metadata for user [" + userName.toUpperCase() + "]:\n" + query);
                st = conn.prepareStatement(query);
                st.setString(1, userName.toUpperCase());
                rs = st.executeQuery();
                while (rs.next()) {
                    String tb_Name = rs.getString(1);
                    String tb_schema = rs.getString(2);
                    if (tb_Name == null || tb_Name.endsWith("_LT")) continue;
                    tables.add(tb_Name);
                }
            }
        }
        catch (Exception e) {
            List list = null;
            return list;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    DSUtil.closeDBConnection(conn, dataSource);
                }
                catch (Exception re) {}
            }
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getGeometryTables(String dataSource, String userName) {
        if (dataSource == null || userName == null) {
            return null;
        }
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        ArrayList<String> tables = new ArrayList<String>();
        try {
            conn = DSUtil.getDBConnection(dataSource, null);
            if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                List list = null;
                return list;
            }
            String query = null;
            if (Util.is10gOrAfter(conn)) {
                query = "select distinct table_name, owner from (select table_name, column_name, owner from all_sdo_geom_metadata where owner = :1 minus  select table_name, column_name, table_owner from all_sdo_topo_metadata where table_owner = :2) order by table_name";
                log.finest("Query to load geometry metadata for user [" + userName.toUpperCase() + "]:\n" + query);
                st = conn.prepareStatement(query);
                st.setString(1, userName.toUpperCase());
                st.setString(2, userName.toUpperCase());
            } else {
                query = "select distinct table_name, owner from all_sdo_geom_metadata  where owner = :1  order by table_name";
                log.finest("Query to load geometry metadata for user [" + userName.toUpperCase() + "]:\n" + query);
                st = conn.prepareStatement(query);
                st.setString(1, userName.toUpperCase());
            }
            rs = st.executeQuery();
            while (rs.next()) {
                String tb_Name = rs.getString(1);
                String tb_schema = rs.getString(2);
                if (tb_Name == null || tb_Name.endsWith("_LT")) continue;
                tables.add(tb_Name);
            }
        }
        catch (Exception e) {
            List list = null;
            return list;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    DSUtil.closeDBConnection(conn, dataSource);
                }
                catch (Exception re) {}
            }
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getGeoRasterTables(String dataSource, String userName) {
        if (dataSource == null || userName == null) {
            return null;
        }
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        ArrayList<String> tables = new ArrayList<String>();
        try {
            conn = DSUtil.getDBConnection(dataSource, null);
            if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                List list = null;
                return list;
            }
            String user = conn.getMetaData().getUserName();
            String query = null;
            if (Util.is10gOrAfter(conn)) {
                query = "select distinct table_name, owner from all_sdo_geor_sysdata  where owner = :1  order by table_name";
                log.finest("Query to load georaster metadata for user [" + userName.toUpperCase() + "]:\n" + query);
                st = conn.prepareStatement(query);
                st.setString(1, userName.toUpperCase());
                rs = st.executeQuery();
                while (rs.next()) {
                    String tb_Name = rs.getString(1);
                    String tb_schema = rs.getString(2);
                    if (tb_Name == null || tb_Name.endsWith("_LT")) continue;
                    tables.add(tb_Name);
                }
            }
        }
        catch (Exception e) {
            List list = null;
            return list;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    DSUtil.closeDBConnection(conn, dataSource);
                }
                catch (Exception re) {}
            }
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTopologyTables(String dataSource, String userName) {
        if (dataSource == null || userName == null) {
            return null;
        }
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        ArrayList<String> tables = new ArrayList<String>();
        try {
            conn = DSUtil.getDBConnection(dataSource, null);
            if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                List list = null;
                return list;
            }
            String query = null;
            if (Util.is10gOrAfter(conn)) {
                query = "select table_name, table_owner from (select distinct a.table_name, a.table_owner from all_sdo_topo_metadata a, all_tables b where a.table_owner = :1  and a.table_owner = b.owner and a.table_name = b.table_name) order by table_name";
                log.finest("Query to load topology metadata for user [" + userName.toUpperCase() + "]:\n" + query);
                st = conn.prepareStatement(query);
                st.setString(1, userName.toUpperCase());
                rs = st.executeQuery();
                while (rs.next()) {
                    String tb_Name = rs.getString(1);
                    String tb_schema = rs.getString(2);
                    if (tb_Name == null) continue;
                    if (tb_Name.endsWith("_LT")) {
                        int idx = tb_Name.lastIndexOf("_LT");
                        tb_Name = tb_Name.substring(0, idx);
                    }
                    tables.add(tb_Name);
                }
            }
        }
        catch (Exception e) {
            List list = null;
            return list;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    DSUtil.closeDBConnection(conn, dataSource);
                }
                catch (Exception re) {}
            }
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getNetworkModels(String dataSource, String userName) {
        if (dataSource == null || userName == null) {
            return null;
        }
        boolean hasSelectAnyTable = DSUtil.sessionHasPrivilege(dataSource, "SELECT ANY TABLE");
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        ArrayList<String> models = new ArrayList<String>();
        try {
            conn = DSUtil.getDBConnection(dataSource, null);
            if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                List list = null;
                return list;
            }
            String user = conn.getMetaData().getUserName();
            String query = null;
            if (Util.is10gOrAfter(conn)) {
                query = hasSelectAnyTable || user.equalsIgnoreCase(userName) ? "select distinct network, owner from all_sdo_network_metadata where owner = :1 order by network" : "select /*+ RULE */ distinct a.network, a.owner from all_sdo_network_metadata a, user_tab_privs b where a.owner = :1  and b.privilege = 'SELECT' and a.owner = b.owner and  (a.link_table_name = b.table_name or   a.node_table_name = b.table_name or   a.path_table_name = b.table_name or   a.path_link_table_name = b.table_name) order by network";
                log.finest("Query to load network models for user [" + userName.toUpperCase() + "]:\n" + query);
                st = conn.prepareStatement(query);
                st.setString(1, userName.toUpperCase());
                rs = st.executeQuery();
                while (rs.next()) {
                    String netName = rs.getString(1);
                    String tb_schema = rs.getString(2);
                    if (netName == null) continue;
                    models.add(netName);
                }
            }
        }
        catch (Exception e) {
            List list = null;
            return list;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    DSUtil.closeDBConnection(conn, dataSource);
                }
                catch (Exception re) {}
            }
        }
        return models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTopologyModels(String dataSource, String userName) {
        if (dataSource == null || userName == null) {
            return null;
        }
        boolean hasSelectAnyTable = DSUtil.sessionHasPrivilege(dataSource, "SELECT ANY TABLE");
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        ArrayList userModels = new ArrayList();
        ArrayList<String> models = new ArrayList<String>();
        try {
            conn = DSUtil.getDBConnection(dataSource, null);
            if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                List list = null;
                return list;
            }
            String user = conn.getMetaData().getUserName();
            if (Util.is10gOrAfter(conn)) {
                String query = null;
                query = hasSelectAnyTable || user.equalsIgnoreCase(userName) ? "select distinct topology, owner from all_sdo_topo_metadata where owner = :1 order by topology" : "select distinct a.topology, a.owner from all_sdo_topo_metadata a, user_tab_privs b where a.owner = :1  and b.privilege = 'SELECT' and a.owner = b.owner and  (a.topology || '_FACE$' = b.table_name or  a.topology || '_EDGE$' = b.table_name or  a.topology || '_NODE$' = b.table_name or  a.topology || '_RELATION$' = b.table_name) order by topology";
                log.finest("Query to load topology models for user [" + userName.toUpperCase() + "]:\n" + query);
                st = conn.prepareStatement(query);
                st.setString(1, userName.toUpperCase());
                rs = st.executeQuery();
                userModels.clear();
                while (rs.next()) {
                    String topoName = rs.getString(1);
                    String tb_schema = rs.getString(2);
                    if (topoName == null) continue;
                    models.add(topoName);
                }
            }
        }
        catch (Exception e) {
            List list = null;
            return list;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    DSUtil.closeDBConnection(conn, dataSource);
                }
                catch (Exception re) {}
            }
        }
        return models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MVThemeMetadata[] getThemesMetadata(String dataSource, String[] themes) {
        if (dataSource == null || themes == null || themes.length == 0) {
            return null;
        }
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        String query = "SELECT name, description,table_name, column_name, styling_rules, srid FROM USER_SDO_GEOM_METADATA a inner join USER_SDO_THEMES b  on a.TABLE_NAME=b.BASE_TABLE and (a.COLUMN_NAME=b.GEOMETRY_COLUMN  OR a.COLUMN_NAME = (b.GEOMETRY_COLUMN || '.SPATIALEXTENT') OR a.COLUMN_NAME = (b.GEOMETRY_COLUMN || '.PRIVATEENVELOPE'))";
        query = query + " and UPPER(name) in (select column_value from table(:1))";
        log.finest("Query: " + query);
        ArrayList<MVThemeMetadata> themeMeta = new ArrayList<MVThemeMetadata>();
        try {
            conn = DSUtil.getDBConnection(dataSource, null);
            String[] values = themes;
            ArrayParameter arrvalues = new ArrayParameter("MV_STRINGLIST", values);
            stmt = conn.prepareStatement(query);
            stmt.setArray(1, (Array)JDBCUtil.createSQLArray(arrvalues, conn));
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                String description = rs.getString(2);
                String baseTable = rs.getString(3);
                String spatialColumn = rs.getString(4);
                CLOB stylingRulesCLOB = JDBCUtil.safeCastCLOB(rs.getClob(5));
                String styrules = null;
                try {
                    styrules = stylingRulesCLOB.getSubString(1L, (int)stylingRulesCLOB.length());
                }
                catch (SQLException e) {
                    styrules = null;
                }
                int srid = rs.getInt(6);
                MVThemeMetadata meta = new MVThemeMetadata();
                meta.setName(name);
                meta.setDescription(description);
                meta.setBaseTable(baseTable);
                meta.setSpatialColumn(spatialColumn);
                meta.setStylingRules(styrules);
                meta.setSRID(srid);
                String type = null;
                if (styrules != null) {
                    XMLDOMParser parser = new XMLDOMParser();
                    if (!parser.parse(styrules)) {
                        MVThemeMetadata[] mVThemeMetadataArray = null;
                        return mVThemeMetadataArray;
                    }
                    Node root = parser.getElementNode("styling_rules");
                    if (root != null) {
                        type = XMLDOMParser.getAttribute(root, "theme_type");
                    }
                }
                meta.setType(type);
                themeMeta.add(meta);
            }
        }
        catch (Exception ex) {
            log.warning(ex.getMessage());
            MVThemeMetadata[] mVThemeMetadataArray = null;
            return mVThemeMetadataArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    DSUtil.closeDBConnection(conn, dataSource);
                }
                catch (Exception re) {}
            }
        }
        if (themeMeta.size() == 0) {
            return null;
        }
        return themeMeta.toArray(new MVThemeMetadata[themeMeta.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLrsTable(String dataSource, String table, String geomColumn) {
        if (dataSource == null || table == null || geomColumn == null) {
            return false;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        String query = "SELECT " + geomColumn + " FROM " + table + " where " + geomColumn + " is not null and rownum < 2";
        log.finest("Query: " + query);
        boolean isLRS = false;
        try {
            conn = DSUtil.getDBConnection(dataSource, null);
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            if (rs.next()) {
                JSDOGeometry geom = JDBCUtil.loadGeometry(rs, 1, true);
                isLRS = geom.isLRSGeometry();
            }
        }
        catch (Exception ex) {
            log.warning(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    DSUtil.closeDBConnection(conn, dataSource);
                }
                catch (Exception re) {}
            }
        }
        return isLRS;
    }
}

