/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.cache;

import java.util.Map;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.cache.MVLinkedHashMap;

public class CacheGroup
extends MVLinkedHashMap {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String name = null;
    private long memSize = 0L;

    public CacheGroup(String name) {
        this.name = name;
    }

    public CacheGroup(String name, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public long getMemorySize() {
        return this.memSize;
    }

    public boolean isPinned() {
        return false;
    }

    public void put(Object key, Object obj, long size) {
        CacheMgr2.increaseSize(size);
        this.memSize += size;
        int oldSize = this._put(key, obj, (int)size);
        if (oldSize != 0) {
            this.memSize -= (long)oldSize;
            CacheMgr2.decreaseSize(size);
        }
    }

    @Override
    public void clear() {
        super.clear();
        CacheMgr2.decreaseSize(this.memSize);
        this.memSize = 0L;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry eldest) {
        boolean remove;
        boolean bl = remove = !CacheMgr2.hasRoom(0);
        if (remove) {
            MVLinkedHashMap.Entry e = (MVLinkedHashMap.Entry)eldest;
            CacheMgr2.decreaseSize(e.getSize());
            this.memSize -= (long)e.getSize();
        }
        return remove;
    }

    @Override
    public String report(int ntab) {
        String tabs = "";
        for (int i = 0; i < ntab; ++i) {
            tabs = tabs + "\t";
        }
        return tabs + "Cache group " + this.name + " statistics:\n" + super.report(ntab);
    }
}

