/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sdovis.GeoRasterTheme;
import oracle.sdovis.ImageTheme;
import oracle.sdovis.PredefinedGeometryTheme;
import oracle.sdovis.ShadedReliefTheme;
import oracle.sdovis.Theme;
import oracle.sdovis.WMSMapTheme;

public class ThemeList {
    private Vector mThemes;

    public ThemeList() {
    }

    public ThemeList(String baseMap) {
    }

    public int addTheme(Theme t) {
        this.initThemes();
        this.mThemes.add(t);
        return this.mThemes.size() - 1;
    }

    public void addTheme(Theme t, int pos) {
        this.initThemes();
        try {
            this.mThemes.add(pos, t);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public void addPredefinedTheme(String theme, String dataSource) {
    }

    public void addPredefinedTheme(String theme, String dataSource, double minScale, double maxScale, boolean forcedlabeling) {
    }

    public void removeTheme(int pos) {
        if (this.mThemes == null) {
            return;
        }
        try {
            this.mThemes.remove(pos);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void removeTheme(String name) {
        for (int i = 0; i < this.mThemes.size(); ++i) {
            Theme t = (Theme)this.mThemes.elementAt(i);
            if (!t.getName().equalsIgnoreCase(name)) continue;
            this.removeTheme(i);
            return;
        }
    }

    public void setThemeEnabled(String name, boolean v) {
        Theme t = this.getTheme(name);
        if (t == null) {
            return;
        }
        t.getDecorator().setEnabled(v);
    }

    public boolean isThemeEnabled(String name) {
        Theme t = this.getTheme(name);
        return t.getDecorator().isEnabled();
    }

    public void setAllThemesEnabled(boolean v) {
    }

    public void clear() {
        if (this.mThemes == null) {
            return;
        }
        Enumeration enumer = this.mThemes.elements();
        while (enumer.hasMoreElements()) {
            Theme t = (Theme)enumer.nextElement();
            t.destroy();
        }
        this.mThemes.removeAllElements();
    }

    public Theme getTheme(int pos) {
        try {
            return (Theme)this.mThemes.elementAt(pos);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public Theme getTheme(String name) {
        for (int i = 0; i < this.mThemes.size(); ++i) {
            Theme t = (Theme)this.mThemes.get(i);
            if (!t.getName().equalsIgnoreCase(name)) continue;
            return t;
        }
        return null;
    }

    public Theme getLastMatchingTheme(String name) {
        for (int i = this.mThemes.size() - 1; i >= 0; --i) {
            PredefinedGeometryTheme pgt;
            Theme t = (Theme)this.mThemes.get(i);
            if (t.getName().equalsIgnoreCase(name)) {
                return t;
            }
            if (!(t instanceof PredefinedGeometryTheme) || (pgt = (PredefinedGeometryTheme)t).getTemplateTheme() == null || !name.equalsIgnoreCase(pgt.getTemplateTheme())) continue;
            return t;
        }
        return null;
    }

    public Vector getThemes() {
        return this.mThemes;
    }

    public void setThemes(Collection c) {
        this.mThemes = new Vector(c);
    }

    public int size() {
        return this.mThemes != null ? this.mThemes.size() : 0;
    }

    public void moveThemeUp(int pos) {
        if (this.mThemes == null || pos <= 0) {
            return;
        }
        try {
            Object t = this.mThemes.elementAt(pos);
            if (t == null) {
                return;
            }
            this.mThemes.insertElementAt(t, pos - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void moveThemeDown(int pos) {
        if (this.mThemes == null || pos >= this.mThemes.size() - 1) {
            return;
        }
        try {
            Object t = this.mThemes.elementAt(pos);
            this.mThemes.insertElementAt(t, pos + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean hasRasterThemes() {
        if (this.mThemes == null || this.mThemes.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.mThemes.size(); ++i) {
            Theme t = (Theme)this.mThemes.get(i);
            if (!(t instanceof ImageTheme) && !(t instanceof GeoRasterTheme) && !(t instanceof ShadedReliefTheme) && (!(t instanceof WMSMapTheme) || !((WMSMapTheme)t).getIsBackgroundImage())) continue;
            return true;
        }
        return false;
    }

    protected void initThemes() {
        if (this.mThemes == null) {
            this.mThemes = new Vector(32);
        }
    }
}

