/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import oracle.sdovis.CoordArray;
import oracle.sdovis.Proj;

public class ProjAzEd
implements Proj {
    private static final int SOUTH_POLE = 1;
    private static final int NORTH_POLE = 2;
    private double R;
    private double clon;
    private double clat;
    private double dlon;
    private double dlat;
    private double easting;
    private double northing;
    private double _cos_clat;
    private double _sin_clat;
    private double o_clon;
    private double o_clat;
    private int pole_pos = 0;
    private Rectangle2D virtualQW;
    private static double[] bg;

    public ProjAzEd(double cLongitude, double cLatitude) {
        this(6378206.4, cLongitude, cLatitude);
    }

    public ProjAzEd(double R, double cLongitude, double cLatitude) {
        this.R = R;
        if (cLatitude == 90.0) {
            this.pole_pos = 2;
        } else if (cLatitude == -90.0) {
            this.pole_pos = 1;
        }
        this.dlon = Proj.util.Clip(cLongitude, -360.0, 360.0);
        this.dlat = Proj.util.Clip(cLatitude, -90.0, 90.0);
        this.o_clon = this.dlon <= 0.0 ? this.dlon + 180.0 : this.dlon - 180.0;
        this.o_clat = this.dlat == 0.0 ? 0.0 : -this.dlat;
        this.clon = Proj.util.Clip(cLongitude * (Math.PI / 180), Math.PI * -2, Math.PI * 2);
        this.clat = Proj.util.Clip(cLatitude * (Math.PI / 180), -1.5707963267948966, 1.5707963267948966);
        this.init();
    }

    @Override
    public double[] save() {
        return new double[]{this.getProjId(), this.R, this.dlon, this.dlat};
    }

    public static ProjAzEd restore(double[] v) {
        if (v[0] != 1.0) {
            System.err.println("Error: Projection ID does not match!");
        }
        return new ProjAzEd(v[1], v[2], v[3]);
    }

    public double getR() {
        return this.R;
    }

    @Override
    public Proj.P2 getCenter() {
        return new Proj.P2(this.clon * 57.29577951308232, this.clat * 57.29577951308232);
    }

    @Override
    public int getProjId() {
        return 1;
    }

    @Override
    public final boolean forward(double lon, double lat, Proj.P2 result) {
        boolean pole;
        double x = 0.0;
        double y = 0.0;
        boolean bl = pole = lat >= 90.0 || lat <= -90.0;
        lat = lat == 90.0 ? 1.5707963267948966 : (lat == -90.0 ? -1.5707963267948966 : (lat *= Math.PI / 180));
        double delta = Proj.util.adjustLon((lon *= Math.PI / 180) - this.clon);
        double k_ = 0.0;
        double cos_c = this._sin_clat * Math.sin(lat) + this._cos_clat * Math.cos(lat) * Math.cos(delta);
        if (Math.abs(1.0 - cos_c) < 1.0E-15) {
            result.set(0.0 + this.easting, 0.0 + this.northing);
            return true;
        }
        if (Math.abs(-1.0 - cos_c) < 1.0E-10) {
            return false;
        }
        double c = Math.acos(cos_c);
        k_ = c / Math.sin(c);
        x = pole ? 0.0 : this.R * k_ * Math.cos(lat) * Math.sin(delta);
        y = pole ? this.R * k_ * this._cos_clat * Math.sin(lat) : this.R * k_ * (this._cos_clat * Math.sin(lat) - this._sin_clat * Math.cos(lat) * Math.cos(delta));
        result.set(x + this.easting, y + this.northing);
        return true;
    }

    @Override
    public final boolean inverse(double x, double y, Proj.P2 result) {
        double lat = 0.0;
        double lon = 0.0;
        if ((x -= this.easting) == 0.0 && (y -= this.northing) == 0.0) {
            lon = this.clon * 57.29577951308232;
            lat = this.clat * 57.29577951308232;
            result.set(lon, lat);
            return true;
        }
        double rho = Math.sqrt(x * x + y * y);
        double c = rho / this.R;
        lat = Math.asin(Math.cos(c) * this._sin_clat + y * Math.sin(c) * this._cos_clat / rho);
        if (this.pole_pos == 2) {
            lon = this.clon + Math.atan2(x, -y);
        } else if (this.pole_pos == 1) {
            lon = this.clon + Math.atan2(x, y);
        } else {
            double atan2 = Math.atan2(x * Math.sin(c), rho * this._cos_clat * Math.cos(c) - y * this._sin_clat * Math.sin(c));
            lon = this.clon + atan2;
        }
        lat *= 57.29577951308232;
        lon *= 57.29577951308232;
        lat = Proj.util.Clip(lat, -90.0, 90.0);
        if (lon > 180.0) {
            lon -= 360.0;
        } else if (lon < -180.0) {
            lon += 360.0;
        }
        result.set(lon, lat);
        return true;
    }

    @Override
    public void setOffset(double easting, double northing) {
        this.easting = easting;
        this.northing = northing;
    }

    @Override
    public Proj.P2 getOffset() {
        return new Proj.P2(this.easting, this.northing);
    }

    public boolean isOddPoint(double x, double y) {
        return Math.abs(y) > this.northing + Math.PI * this.R || Math.abs(x) > this.easting + Math.PI * this.R;
    }

    @Override
    public Proj.P2 getOpposite() {
        return new Proj.P2(this.o_clon, this.o_clat);
    }

    @Override
    public double[] getBoundingGeom() {
        return bg;
    }

    @Override
    public double[] getParallel(double y, double density) {
        if (y >= 90.0 || y <= -90.0) {
            return null;
        }
        if (Math.abs(y) > 55.0) {
            density *= (double)((int)Math.max(1.0, Math.abs(y) / 20.0));
        }
        CoordArray ca = new CoordArray(720);
        float i = -240.0f;
        while (i <= 240.0f) {
            ca.add(i, y);
            i = (float)((double)i + density);
        }
        return ca.getAll();
    }

    public static Rectangle2D getQueryWindow(double cx, double cy, double size, Rectangle2D deviceWin, Proj[] resProj) {
        size = Math.abs(size);
        Rectangle2D.Double qw = null;
        double ratio = deviceWin.getWidth() / deviceWin.getHeight();
        double h = size;
        double w = size * ratio;
        Rectangle2D.Double vqw = new Rectangle2D.Double(cx - w / 2.0, cy - h / 2.0, w, h);
        if (cy > 90.0) {
            cy = 90.0;
        } else if (cy < -90.0) {
            cy = -90.0;
        } else if (Math.abs(90.0 - cy) < size * 0.05) {
            cy = 90.0;
        } else if (Math.abs(-90.0 - cy) < size * 0.05) {
            cy = -90.0;
        }
        double miny = 0.0;
        double maxy = 0.0;
        if (cy == -90.0) {
            miny = -90.0;
            maxy = Proj.util.Clip(-90.0 + h, -90.0, 90.0);
        } else if (cy == 90.0) {
            miny = Proj.util.Clip(90.0 - h, -90.0, 90.0);
            maxy = 90.0;
        } else {
            double r;
            miny = cy - h / 2.0;
            maxy = cy + h / 2.0;
            if (maxy > 90.0) {
                r = maxy - 90.0;
                miny = Proj.util.Clip(miny - r, -90.0, 90.0);
            }
            if (miny < -90.0) {
                r = Math.abs(miny + 90.0);
                maxy = Proj.util.Clip(maxy + r, -90.0, 90.0);
            }
            miny = Proj.util.Clip(miny, -90.0, 90.0);
            maxy = Proj.util.Clip(maxy, -90.0, 90.0);
        }
        if (cx > 180.0) {
            cx -= 360.0;
        } else if (cx < -180.0) {
            cx += 360.0;
        }
        double minx = 0.0;
        double maxx = 0.0;
        if (w >= 360.0) {
            w = 360.0;
            minx = Proj.util.Clip(cx - w / 2.0, -360.0, 360.0);
            maxx = Proj.util.Clip(cx + w / 2.0, -360.0, 360.0);
        } else {
            w = Math.abs(maxy - miny) * ratio;
            minx = Proj.util.Clip(cx - w / 2.0, -360.0, 360.0);
            maxx = Proj.util.Clip(cx + w / 2.0, -360.0, 360.0);
        }
        qw = new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny);
        ProjAzEd prj = new ProjAzEd(cx, cy);
        prj.virtualQW = vqw;
        resProj[0] = prj;
        return qw;
    }

    @Override
    public Rectangle2D getBoundingBox(Rectangle2D dataView, Rectangle2D deviceView) {
        double vh;
        double pw;
        double ph = pw = this.R * Math.PI;
        double h = dataView.getHeight();
        double w = dataView.getWidth();
        double ratio = w / h;
        if (this.pole_pos == 2 || this.pole_pos == 1) {
            Proj.P2 p2;
            double x = this.dlon;
            double y = this.pole_pos == 2 ? this.dlat - h / 2.0 : this.dlat + h / 2.0;
            if (this.forward(x, y, p2 = new Proj.P2())) {
                double vh2;
                ph = Math.abs(p2.y - this.northing) * 2.0;
                pw = ph * ratio;
                if (this.virtualQW != null && (vh2 = this.virtualQW.getHeight()) >= 180.0) {
                    ph *= vh2 / 180.0;
                    pw *= vh2 / 180.0;
                }
                return new Rectangle2D.Double(-pw / 2.0, -ph / 2.0, pw, ph);
            }
            System.err.println("ProjAzEd: cannot do forward transformation on " + x + "," + y);
        }
        double den = Math.abs(this.dlat) > 40.0 ? 810.0 : (Math.abs(this.dlat) > 20.0 ? 630.0 : 540.0);
        double f1 = w / den;
        pw *= f1;
        ph *= f1;
        if (this.virtualQW != null && (vh = this.virtualQW.getHeight()) > 180.0) {
            pw *= vh / 180.0;
            ph *= vh / 180.0;
        }
        return new Rectangle2D.Double(-pw / 2.0, -ph / 2.0, pw, ph);
    }

    private void init() {
        this._cos_clat = Math.cos(this.clat);
        this._sin_clat = Math.sin(this.clat);
    }

    private static void createBG() {
        double R = 6378206.4;
        CoordArray ca = new CoordArray(750);
        double radius = Math.PI * R;
        for (int i = 0; i <= 360; ++i) {
            double x = radius * Math.cos((double)i * (Math.PI / 180));
            double y = radius * Math.sin((double)i * (Math.PI / 180));
            ca.add(x, y);
        }
        bg = ca.getAll();
    }

    static {
        ProjAzEd.createBG();
    }
}

