/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.theme.ThemeDecorator;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.BaseMap;
import oracle.sdovis.BaseMap2;
import oracle.sdovis.BasemapStore;
import oracle.sdovis.RSBundle;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.util.DBTable;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapTable
extends DBTable
implements BasemapStore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final String DEF_TABLE_NAME = "USER_SDO_MAPS";
    String mName;
    String mDescription;
    StringBuffer mDefinition;

    public MapTable(String dataSrc, String tableName) {
        super(dataSrc, tableName);
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String v) {
        this.mName = v;
    }

    public void setDescription(String v) {
        this.mDescription = v;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getMapDefinition() {
        return this.mDefinition == null ? null : this.mDefinition.toString();
    }

    public void setMapDefinition(String v) {
        this.mDefinition = new StringBuffer(v);
    }

    @Override
    public int update() throws SQLException {
        String name = this.mName;
        StringBuffer def = this.mDefinition;
        this.delete();
        this.mName = name;
        this.mDefinition = def;
        int res = this.insert();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert() throws SQLException {
        int res;
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        boolean autoCommit = this.mConnection.getAutoCommit();
        this.mConnection.setAutoCommit(false);
        this.initInsertStatement();
        this.mInsertStatement.setString(1, this.mName.toUpperCase());
        this.mInsertStatement.setString(2, this.mDescription);
        if (this.mDBtypename == null || this.mDBtypename.equalsIgnoreCase("ORACLE")) {
            res = this.mInsertStatement.executeUpdate();
            this.mConnection.commit();
            Statement stmt = this.mConnection.createStatement();
            this.mResultSet = stmt.executeQuery("SELECT * FROM " + this.mTableName + " WHERE name='" + this.mName.toUpperCase() + "' FOR UPDATE");
            if (!this.mResultSet.next()) {
                log.warning("Unable to select " + this.mName.toUpperCase() + " from table " + this.mTableName + " for update definition.");
            }
            Clob mCLOBDef = this.mResultSet.getClob("DEFINITION");
            try {
                Util.putClobContents(mCLOBDef, this.mDefinition.toString());
                this.mConnection.commit();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {}
                this.close();
            }
        } else {
            String definition = null;
            if (this.mDefinition != null) {
                definition = this.mDefinition.toString();
            }
            if (definition == null) {
                this.mInsertStatement.setClob(3, (Clob)null);
            } else {
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                try {
                    BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)b, "UTF8"));
                    w.write(definition);
                    w.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                byte[] ba = b.toByteArray();
                ByteArrayInputStream barray = new ByteArrayInputStream(ba);
                this.mInsertStatement.setAsciiStream(3, (InputStream)barray, ba.length);
            }
            res = this.mInsertStatement.executeUpdate();
            this.mConnection.commit();
            this.mConnection.setAutoCommit(autoCommit);
            this.close();
        }
        return res;
    }

    @Override
    public int delete() throws SQLException {
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        boolean autoCommit = this.mConnection.getAutoCommit();
        this.mConnection.setAutoCommit(false);
        this.initDeleteStatement();
        this.mDeleteStatement.setString(1, this.mName.toUpperCase());
        int res = this.mDeleteStatement.executeUpdate();
        this.mConnection.commit();
        this.mConnection.setAutoCommit(autoCommit);
        this.close();
        this.mName = null;
        this.mDefinition = null;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseMap loadBasemapDefinition(String mapName) {
        try {
            this.query("select * from " + this.mTableName + " where name='" + mapName.toUpperCase() + "'");
            if (!this.next()) {
                BaseMap baseMap = null;
                return baseMap;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            BaseMap e2 = null;
            return e2;
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (SQLException e2) {}
        }
        BaseMap map = null;
        XMLDOMParser parser = new XMLDOMParser();
        if (!parser.parse(this.mDefinition.toString())) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01013"));
            return null;
        }
        Document doc = parser.getDocument();
        if (doc == null) {
            return null;
        }
        Node root = parser.getElementNode("map_definition");
        if (root == null) {
            return null;
        }
        String type = XMLDOMParser.getAttribute(root, "type");
        if (type != null && "2".equals(type)) {
            map = new BaseMap2();
            MapTable.parseType2(parser, (BaseMap2)map);
        } else {
            map = new BaseMap();
            String order = XMLDOMParser.getAttribute(root, "keepthemesorder");
            if (order != null && order.trim().equalsIgnoreCase("true")) {
                map.setKeepThemesOrder(true);
            }
            NodeList nl = parser.getElementNodes("theme");
            BaseMap.PredefinedThemeDesc[] defs = new BaseMap.PredefinedThemeDesc[nl.getLength()];
            for (int i = 0; i < nl.getLength(); ++i) {
                Node theme = nl.item(i);
                BaseMap.PredefinedThemeDesc td = new BaseMap.PredefinedThemeDesc();
                td.name = XMLDOMParser.getAttribute(theme, "name");
                td.mods = MapTable.extractThemeModifiers(parser, theme);
                defs[i] = td;
            }
            map.setThemes(defs);
        }
        map.setCustomTags(MapTable.parseCustomTags(parser));
        map.setName(this.mName);
        map.setDescription(this.mDescription);
        try {
            map.setInitX(Double.parseDouble(XMLDOMParser.getAttribute(root, "initx")));
        }
        catch (Exception e) {
            map.setInitX(0.0);
        }
        try {
            map.setInitY(Double.parseDouble(XMLDOMParser.getAttribute(root, "inity")));
        }
        catch (Exception e) {
            map.setInitY(0.0);
        }
        parser.close();
        return map;
    }

    public static void parseType2(XMLDOMParser parser, BaseMap2 map) {
        NodeList nl = parser.getElementNodes("zoom_level");
        if (nl == null || nl.getLength() == 0) {
            throw new RuntimeException("invalid type 2 basemap definition.");
        }
        Vector<BaseMap2.ZoomLevel> levels = new Vector<BaseMap2.ZoomLevel>();
        Vector<BaseMap.PredefinedThemeDesc> allThemes = new Vector<BaseMap.PredefinedThemeDesc>();
        Hashtable<String, String> themeNames = new Hashtable<String, String>(57);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node level = nl.item(i);
            BaseMap2.ZoomLevel zLevel = new BaseMap2.ZoomLevel();
            try {
                zLevel.id = Integer.parseInt(XMLDOMParser.getAttribute(level, "id"));
            }
            catch (Exception e) {
                zLevel.id = i;
            }
            try {
                zLevel.srid = Integer.parseInt(XMLDOMParser.getAttribute(level, "srid"));
            }
            catch (Exception e) {
                zLevel.srid = 0;
            }
            try {
                zLevel.scale = Double.parseDouble(XMLDOMParser.getAttribute(level, "scale"));
            }
            catch (Exception e) {
                zLevel.scale = 0.0;
            }
            ArrayList themes = XMLDOMParser.getSubElements(level, "theme");
            BaseMap.PredefinedThemeDesc[] defs = new BaseMap.PredefinedThemeDesc[themes.size()];
            for (int k = 0; k < themes.size(); ++k) {
                Node theme = (Node)themes.get(k);
                BaseMap.PredefinedThemeDesc td = new BaseMap.PredefinedThemeDesc();
                td.name = XMLDOMParser.getAttribute(theme, "name");
                td.mods = MapTable.extractThemeModifiers(parser, theme);
                ThemeDecorator cfr_ignored_0 = td.mods;
                td.mods.minScale = Double.POSITIVE_INFINITY;
                ThemeDecorator cfr_ignored_1 = td.mods;
                td.mods.maxScale = Double.NEGATIVE_INFINITY;
                ThemeDecorator cfr_ignored_2 = td.mods;
                td.mods.minLabelScale = Double.POSITIVE_INFINITY;
                ThemeDecorator cfr_ignored_3 = td.mods;
                td.mods.maxLabelScale = Double.NEGATIVE_INFINITY;
                defs[k] = td;
                String o = themeNames.put(td.name.toUpperCase(), "v");
                if (o != null) continue;
                allThemes.add(td);
            }
            zLevel.themes = defs;
            levels.add(zLevel);
        }
        map.setZoomLevels(levels.toArray(new BaseMap2.ZoomLevel[nl.getLength()]));
        map.setThemes(allThemes.toArray(new BaseMap.PredefinedThemeDesc[allThemes.size()]));
    }

    public static ThemeDecorator extractThemeModifiers(XMLDOMParser parser, Node theme) {
        ArrayList al;
        ThemeDecorator td = new ThemeDecorator();
        String sc = XMLDOMParser.getAttribute(theme, "min_scale");
        if (sc != null && sc.length() > 0) {
            try {
                td.setMinScale(Double.parseDouble(sc));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "max_scale")) != null && sc.length() > 0) {
            try {
                td.setMaxScale(Double.parseDouble(sc));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "label_min_scale")) != null && sc.length() > 0) {
            try {
                td.setLabelMinScale(Double.parseDouble(sc));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "label_max_scale")) != null && sc.length() > 0) {
            try {
                td.setLabelMaxScale(Double.parseDouble(sc));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "scale_mode")) != null && sc.trim().length() > 0 && sc.trim().equalsIgnoreCase("RATIO")) {
            td.setScaleType("RATIO");
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "info_columns")) != null && sc.length() > 0 && (al = Util.splitBy(sc, ",\n")).size() > 0) {
            String[] infoCols = new String[al.size()];
            for (int ki = 0; ki < al.size(); ++ki) {
                infoCols[ki] = ((String)al.get(ki)).trim();
            }
            td.setInfoColumns(infoCols);
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "label_always_on")) != null && sc.equalsIgnoreCase("TRUE")) {
            td.setLabelAlwaysOn(true);
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "fast_unpickle")) != null && sc.equalsIgnoreCase("TRUE")) {
            td.setFastUnpickle(true);
        } else if (sc != null && sc.equalsIgnoreCase("FALSE")) {
            td.setFastUnpickle(false);
        }
        sc = XMLDOMParser.getAttribute(theme, "upside_down_labels");
        if (sc != null && sc.equalsIgnoreCase("TRUE")) {
            td.upsideDownLabels = true;
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "min_dist")) != null) {
            try {
                td.setMinDistBetweenPoints(Double.parseDouble(sc));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "fixed_svglabel")) != null && sc.equalsIgnoreCase("true")) {
            td.setFixedSVGLabel(true);
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "selectable_in_svg")) != null && sc.equalsIgnoreCase("true")) {
            td.setSelectableInSVG(true);
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "onclick")) != null) {
            td.setOnClickInSVG(sc);
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "onmouseover")) != null) {
            td.setOnMouseOverInSVG(sc);
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "onmousemove")) != null) {
            td.setOnMouseMoveInSVG(sc);
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "onmouseout")) != null) {
            td.setOnMouseOutInSVG(sc);
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "workspace_name")) != null && sc.length() > 0) {
            td.setWorkspaceName(sc);
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "workspace_savepoint")) == null || sc.length() == 0) {
            sc = XMLDOMParser.getAttribute(theme, "workspace_savedpoint");
        }
        if (sc != null && sc.length() > 0) {
            td.setWorkspaceSavedPoint(sc);
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "workspace_date")) != null && sc.length() > 0) {
            td.setWorkspaceDate(sc);
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "workspace_date_format")) != null && sc.length() > 0) {
            td.setWorkspaceDateFormat(sc);
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "workspace_date_nlsparam")) != null && sc.length() > 0) {
            td.setWorkspaceDateNlsParam(sc);
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "workspace_date_tswtz")) != null && sc.length() > 0 && sc.equalsIgnoreCase("true")) {
            td.setWorkspaceDateTsWtz(true);
        }
        sc = XMLDOMParser.getAttribute(theme, "minimum_pixels");
        int numPixels = 0;
        if (sc != null && sc.trim().length() > 0) {
            try {
                numPixels = Integer.parseInt(sc);
            }
            catch (Exception e) {
                numPixels = 0;
            }
        }
        td.setMinimumFeatureSizePx(numPixels);
        String transparency = XMLDOMParser.getAttribute(theme, "transparency");
        float alpha = 1.0f;
        if (transparency != null && transparency.trim().length() > 0) {
            try {
                alpha = Float.parseFloat(transparency);
                if (alpha < 0.0f || alpha > 1.0f) {
                    alpha = 1.0f;
                }
            }
            catch (Exception e) {
                alpha = 1.0f;
            }
        }
        td.setOpacity(alpha);
        String sShapes = XMLDOMParser.getAttribute(theme, "simplify_shapes");
        if (sShapes != null && sShapes.trim().length() > 0 && "false".equalsIgnoreCase(sShapes)) {
            td.setSimplifiedShapes(false);
        }
        sc = XMLDOMParser.getAttribute(theme, "fetch_size");
        int ftsize = 100;
        if (sc != null && sc.trim().length() > 0) {
            try {
                ftsize = Integer.parseInt(sc);
            }
            catch (Exception e) {
                ftsize = 100;
            }
        }
        td.setFetchSize(ftsize);
        sc = XMLDOMParser.getAttribute(theme, "timeout");
        long timeout = 0L;
        if (sc != null && sc.trim().length() > 0) {
            try {
                timeout = Long.parseLong(sc);
            }
            catch (Exception e) {
                timeout = 0L;
            }
        }
        td.setRequestTimeout(timeout);
        sc = XMLDOMParser.getAttribute(theme, "no_repetitive_label");
        if (sc != null && sc.trim().length() > 0 && "true".equalsIgnoreCase(sc)) {
            td.noRepetitiveLabel = true;
        }
        if ((sc = XMLDOMParser.getAttribute(theme, "allow_naked_points")) != null && sc.trim().length() > 0 && "false".equalsIgnoreCase(sc)) {
            td.allowNakedPoints = false;
        }
        String snap_to_tile_scale = XMLDOMParser.getAttribute(theme, "snap_to_tile_scale");
        boolean snapToTileScale = false;
        if (snap_to_tile_scale != null && snap_to_tile_scale.trim().length() > 0 && "true".equalsIgnoreCase(snap_to_tile_scale)) {
            snapToTileScale = true;
        }
        td.setSnapToTileScale(snapToTileScale);
        String tile_resizing_option = XMLDOMParser.getAttribute(theme, "tile_resizing_option");
        String tileResizingOption = "unbiased";
        if (tile_resizing_option != null && tile_resizing_option.trim().length() > 0) {
            tileResizingOption = tile_resizing_option;
        }
        td.setTileResizingOption(tileResizingOption);
        String current_threads = XMLDOMParser.getAttribute(theme, "current_threads");
        int currentThreads = 8;
        if (current_threads != null && current_threads.trim().length() > 0) {
            currentThreads = Integer.parseInt(current_threads);
        }
        td.setCurrentThreads(currentThreads);
        return td;
    }

    public static Hashtable parseCustomTags(XMLDOMParser parser) {
        NodeList tagList;
        Hashtable<String, String> htags = new Hashtable<String, String>();
        if (parser == null) {
            return htags;
        }
        Node tags = parser.getElementNode("custom_tags");
        if (tags != null && (tagList = parser.getElementNodes("tag")) != null && tagList.getLength() > 0) {
            for (int i = 0; i < tagList.getLength(); ++i) {
                Node tag = tagList.item(i);
                NodeList tagChildren = tag.getChildNodes();
                if (tagChildren == null) continue;
                String tagName = null;
                String tagValue = null;
                for (int j = 0; j < tagChildren.getLength(); ++j) {
                    Node tgc = tagChildren.item(j);
                    if (tgc != null && tgc.getNodeName().equalsIgnoreCase("name")) {
                        tagName = tgc.getChildNodes().item(0).getNodeValue();
                        if (tagName == null || tagName.trim().length() >= 1) continue;
                        tagName = null;
                        continue;
                    }
                    if (tgc == null || !tgc.getNodeName().equalsIgnoreCase("value") || (tagValue = tgc.getChildNodes().item(0).getNodeValue()) == null || tagValue.trim().length() >= 1) continue;
                    tagValue = null;
                }
                if (tagName == null || tagValue == null) continue;
                htags.put(tagName.trim(), tagValue.trim());
            }
        }
        return htags;
    }

    @Override
    protected void initDeleteStatement() throws SQLException {
        if (this.mDeleteStatement == null) {
            this.mDeleteStatement = this.mConnection.prepareStatement("DELETE FROM " + this.mTableName + " WHERE name = ?");
        }
    }

    @Override
    protected void initInsertStatement() throws SQLException {
        if (this.mInsertStatement == null) {
            this.mInsertStatement = this.mDBtypename == null || this.mDBtypename.equalsIgnoreCase("ORACLE") ? this.mConnection.prepareStatement("INSERT INTO " + this.mTableName + " VALUES(?,  ?, empty_clob())") : this.mConnection.prepareStatement("INSERT INTO " + this.mTableName + " VALUES(?,  ?, ?)");
        }
    }

    @Override
    protected void initUpdateStatement() throws SQLException {
    }

    @Override
    protected void updateLocalData() throws SQLException {
        Object typeName = null;
        this.mName = this.mResultSet.getString("NAME");
        this.mDescription = this.mResultSet.getString("DESCRIPTION");
        Clob mCLOBDef = this.mResultSet.getClob("DEFINITION");
        try {
            this.mDefinition = new StringBuffer(mCLOBDef.getSubString(1L, (int)mCLOBDef.length()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.mDefinition = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getBasemapNames() {
        ArrayList<String> arrayList;
        ArrayList<String> res = null;
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = DSUtil.getDBConnection(this.mDataSource, null);
            if (conn == null) {
                ArrayList<String> arrayList2 = res;
                return arrayList2;
            }
            res = new ArrayList<String>();
            String query = "SELECT name from USER_SDO_MAPS order by name";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                res.add(rs.getString(1));
            }
            arrayList = res;
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            ArrayList<String> arrayList3 = res;
            return arrayList3;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException se) {
                log.severe(se.getMessage());
            }
            try {
                stmt.close();
            }
            catch (SQLException se) {
                log.severe(se.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {}
        }
        return arrayList;
    }
}

