/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.ImageGraphicAttribute;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.BucketSeries;
import oracle.mapviewer.share.stylex.VariableMarkerStyleModel;
import oracle.mapviewer.share.stylex.VariablePieChartStyleModel;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.MarkerStyleModifiers;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.AdvancedStyleModifiers;
import oracle.sdovis.stylex.PieChartStyle;
import oracle.sdovis.stylex.PieChartStyleModifiers;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.sdovis.stylex.VariablePieChartStyle;

public class LegendEntry {
    public static final int ITEM_TYPE_STYLE = 0;
    public static final int ITEM_TYPE_SEPARATOR = 1;
    public static final int ITEM_TYPE_TITLE = 2;
    public static final int[] PROFILE_TEXT_SIZE = new int[]{9, 12, 16};
    public static final int[] PROFILE_IMAGE_WIDTH = new int[]{24, 40, 64};
    public static final int[] PROFILE_IMAGE_HEIGHT = new int[]{14, 23, 38};
    public static final int[] PROFILE_AVSTYLE_WIDTH = new int[]{95, 120, 160};
    public static final int[] PROFILE_AVSTYLE_HEIGHT = new int[]{75, 120, 180};
    int type = 0;
    String styleName = null;
    String text = null;
    int profile = 1;
    int pWidth;
    int pHeight;
    int pTextSize = 0;
    int userWidth = -1;
    int userHeight = -1;
    String fontFamily = null;
    Color background = Color.white;
    Color foreground = Color.black;
    Style style = null;
    AttributedString as = null;
    boolean isAVStyle = false;
    int numSpaces = 0;
    BufferedImage bimage = null;

    public LegendEntry(String styleName, String desc) {
        this.styleName = styleName;
        this.text = desc == null ? "" : desc;
    }

    public LegendEntry() {
        this.type = 1;
    }

    public LegendEntry(Style style, String desc) {
        this.text = desc == null ? "" : desc;
        this.style = style;
        if (style instanceof AdvancedStyle) {
            this.isAVStyle = true;
        }
    }

    public LegendEntry(String title) {
        this.type = 2;
        this.text = title;
    }

    public void setUserSpcifiedDimensioin(int w, int h) {
        this.userWidth = w;
        this.userHeight = h;
    }

    public void setBackground(Color c) {
        this.background = c;
    }

    public void setForeground(Color c) {
        this.foreground = c;
    }

    public void setFontFamily(String font) {
        this.fontFamily = font;
    }

    public Font getFont() {
        if (this.fontFamily != null) {
            return new Font(this.fontFamily, 0, this.getTextSize());
        }
        return null;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void addTab() {
        this.numSpaces += 4;
    }

    public int getNumSpaces() {
        return this.numSpaces;
    }

    public boolean hasAdvancedStyle() {
        return this.isAVStyle;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public boolean materializeStyles(VisContext vc) {
        if (this.styleName == null || this.styleName.length() == 0 || this.style != null) {
            return true;
        }
        if (this.style == null) {
            this.style = vc.resolveStyle(this.styleName);
            if (this.style == null) {
                return false;
            }
            this.style.resolveStyles(DSManager.getStyleCache(vc.getMasterDataSourceName()), vc.getDynamicStyles());
        }
        StyleModifiers stymods = this.style.convertToPixelSize(null);
        if (this.style instanceof AdvancedStyle) {
            this.pHeight = PROFILE_AVSTYLE_HEIGHT[this.profile];
            this.isAVStyle = true;
            if (this.style instanceof VariableMarkerStyle) {
                int sy = 2;
                BucketSeries buckets = ((VariableMarkerStyleModel)((VariableMarkerStyle)this.style).getModel()).getBucketSeries();
                int nBuckets = buckets.size();
                for (int i = 0; i < nBuckets; ++i) {
                    Bucket bucket = buckets.getBucket(i);
                    StyleMarker sty = (StyleMarker)bucket.getRenderStyle();
                    if (sty == null) continue;
                    StyleModifiers smods = null;
                    if (stymods != null && stymods instanceof AdvancedStyleModifiers) {
                        smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers(((VariableMarkerStyle)this.style).getBaseMarkerName().toUpperCase() + "_" + i);
                    }
                    int styleH = sty.getDesiredHeight();
                    if (smods != null && smods instanceof MarkerStyleModifiers) {
                        styleH = ((MarkerStyleModifiers)smods).getHeight();
                    }
                    sy += styleH + 2;
                }
                if (sy > this.pHeight) {
                    this.pHeight = sy;
                }
            } else if (this.style instanceof VariablePieChartStyle) {
                int sy = 2;
                BucketSeries buckets = ((VariablePieChartStyleModel)((VariablePieChartStyle)this.style).getModel()).getBucketSeries();
                int nBuckets = buckets.size();
                for (int i = 0; i < nBuckets; ++i) {
                    Bucket bucket = buckets.getBucket(i);
                    PieChartStyle sty = (PieChartStyle)bucket.getRenderStyle();
                    if (sty == null) continue;
                    StyleModifiers smods = null;
                    if (stymods != null && stymods instanceof AdvancedStyleModifiers) {
                        smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers("PIECHART_" + i);
                    }
                    int styleH = sty.getPieRadius() * 2;
                    if (smods != null && smods instanceof PieChartStyleModifiers) {
                        styleH = ((PieChartStyleModifiers)smods).getPieRadius() * 2;
                    }
                    sy += styleH + 2;
                }
                if (sy > this.pHeight) {
                    this.pHeight = sy;
                }
            }
        } else if (this.style instanceof StyleMarker) {
            StyleMarker sm = (StyleMarker)this.style;
            int w = sm.getDesiredWidth();
            int h = sm.getDesiredHeight();
            if (stymods != null && stymods instanceof MarkerStyleModifiers) {
                w = ((MarkerStyleModifiers)stymods).getWidth();
                h = ((MarkerStyleModifiers)stymods).getHeight();
            }
            if (h > 0 && h > PROFILE_IMAGE_HEIGHT[this.profile]) {
                this.pHeight = h;
            }
        }
        if (this.userHeight > 0) {
            this.pHeight = this.userHeight;
        }
        return true;
    }

    public int getUserWidth() {
        return this.userWidth;
    }

    public int getUseHeight() {
        return this.userHeight;
    }

    public int getPreferredWidth() {
        if (this.userWidth > 0) {
            this.pWidth = this.userWidth;
            return this.pWidth;
        }
        if (this.as != null) {
            AttributedCharacterIterator iter = null;
            iter = this.as.getIterator();
            FontRenderContext frc = new FontRenderContext(null, true, false);
            LineBreakMeasurer measure = new LineBreakMeasurer(iter, frc);
            float wrapWidth = 9999.0f;
            TextLayout layout = measure.nextLayout(wrapWidth);
            this.pWidth = (int)layout.getAdvance();
        } else {
            this.pWidth = this.hasAdvancedStyle() ? PROFILE_AVSTYLE_WIDTH[this.profile] : 0;
        }
        return this.pWidth;
    }

    public int getPreferredHeight() {
        return this.pHeight;
    }

    public void prepare(VisContext vc) {
        this.materializeStyles(vc);
        this.assembleAttrString(true);
    }

    public AttributedString getAttrString() {
        return this.as;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assembleAttrString(boolean aa) {
        double w = PROFILE_TEXT_SIZE[this.profile];
        if (this.pTextSize > 0) {
            w = this.pTextSize;
        }
        int imgw = PROFILE_IMAGE_WIDTH[this.profile];
        if (this.type == 1) {
            this.as = new AttributedString(" ");
            this.as.addAttribute(TextAttribute.SIZE, new Float(w));
            this.as.addAttribute(TextAttribute.FOREGROUND, this.background);
            return true;
        }
        String tab = "";
        if (this.numSpaces > 0) {
            for (int i = 0; i < this.numSpaces; ++i) {
                tab = tab + " ";
            }
        }
        if (this.type == 2) {
            this.as = new AttributedString(tab + this.text);
            if (this.foreground != null) {
                this.as.addAttribute(TextAttribute.FOREGROUND, this.foreground);
            } else {
                this.as.addAttribute(TextAttribute.FOREGROUND, Color.black);
            }
            if (this.fontFamily != null) {
                this.as.addAttribute(TextAttribute.FAMILY, this.fontFamily);
            }
            this.as.addAttribute(TextAttribute.SIZE, new Float(w));
            return true;
        }
        this.as = this.style != null ? new AttributedString(tab + "A " + this.text + " ") : new AttributedString(tab + this.text + " ");
        if (this.foreground != null) {
            this.as.addAttribute(TextAttribute.FOREGROUND, this.foreground);
        } else {
            this.as.addAttribute(TextAttribute.FOREGROUND, Color.black);
        }
        if (this.fontFamily != null) {
            this.as.addAttribute(TextAttribute.FAMILY, this.fontFamily);
        }
        this.as.addAttribute(TextAttribute.SIZE, new Float(w));
        if (this.style != null) {
            int height = this.pHeight;
            int maxWidth = 0;
            int tsize = PROFILE_TEXT_SIZE[this.profile];
            if (this.pTextSize > 0) {
                tsize = this.pTextSize;
            }
            if (this.hasAdvancedStyle() && this.userWidth <= 0) {
                maxWidth = ((AdvancedStyle)this.style).getMaxLegendWidth(null, tsize);
                imgw = Math.max(maxWidth, PROFILE_AVSTYLE_WIDTH[this.profile]);
            } else if (this.userWidth > 0) {
                imgw = this.userWidth;
            }
            this.bimage = new BufferedImage(imgw, height, 2);
            Graphics2D g2 = (Graphics2D)this.bimage.getGraphics();
            if (aa) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (this.background != null) {
                g2.setColor(new Color(0, 0, 0, 0));
                g2.fillRect(0, 0, imgw, height);
            }
            Rectangle2D.Float sr = new Rectangle2D.Float(1.0f, 1.0f, imgw - 2, height - 2);
            try {
                StyleModifiers stymods = this.style.convertToPixelSize(null);
                this.style.apply(null, g2, sr, stymods);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            finally {
                g2.dispose();
            }
            ImageGraphicAttribute imgrep = new ImageGraphicAttribute(this.bimage, 0, 0.0f, height / 2 + 3);
            this.as.addAttribute(TextAttribute.CHAR_REPLACEMENT, imgrep, this.numSpaces, this.numSpaces + 1);
        }
        return true;
    }

    public void destroy() {
        this.as = null;
        if (this.bimage != null) {
            this.bimage.flush();
            this.bimage = null;
        }
    }

    public String toXMLString() {
        switch (this.type) {
            case 1: {
                return "<entry is_separator=\"true\" />";
            }
            case 2: {
                return "<entry is_title=\"true\" text=\"" + this.text + "\"/>";
            }
            case 0: {
                String t = this.text != null ? " text=\"" + this.text + "\" " : "";
                String w = this.userWidth > 0 ? " width=\"" + this.userWidth + "\"" : "";
                String h = this.userHeight > 0 ? " height=\"" + this.userHeight + "\"" : "";
                return "<entry style=\"" + this.styleName + "\"" + t + w + h + (this.numSpaces > 0 ? " tab=\"" + this.numSpaces / 4 + "\" " : "") + "/>";
            }
        }
        return "";
    }

    public int getImageHeight() {
        return PROFILE_IMAGE_HEIGHT[this.profile];
    }

    public int getImageWidth() {
        if (this.hasAdvancedStyle()) {
            return PROFILE_AVSTYLE_WIDTH[this.profile];
        }
        return PROFILE_IMAGE_WIDTH[this.profile];
    }

    public int getType() {
        return this.type;
    }

    public int getTextSize() {
        if (this.pTextSize > 0) {
            return this.pTextSize;
        }
        return PROFILE_TEXT_SIZE[this.profile] + 1;
    }

    public void setTextSize(int tsize) {
        this.pTextSize = tsize;
    }

    public Style getStyle() {
        return this.style;
    }

    public String getText() {
        String tab = "";
        if (this.numSpaces > 0) {
            for (int i = 0; i < this.numSpaces; ++i) {
                tab = tab + " ";
            }
        }
        if (this.type == 2) {
            return tab + this.text;
        }
        if (this.type == 0) {
            return tab + this.text;
        }
        return "";
    }

    public void setProfile(int profile) {
        this.profile = profile;
        this.pHeight = PROFILE_IMAGE_HEIGHT[profile];
        this.pWidth = PROFILE_IMAGE_WIDTH[profile];
    }

    public int getProfile() {
        return this.profile;
    }
}

