/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.instrument.PhaseEvent;
import oracle.lbs.mapcache.cache.MapCache;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.MapBounds;
import oracle.mapviewer.share.OMSException;
import oracle.mapviewer.share.theme.ThemeDecorator;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.sdovis.AnnotationTextTheme;
import oracle.sdovis.BaseMap;
import oracle.sdovis.BasemapCache;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.CustomGeomTheme;
import oracle.sdovis.DataException;
import oracle.sdovis.DynamicGeometryTheme;
import oracle.sdovis.GeoRasterTheme;
import oracle.sdovis.ImageTheme;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LRSTheme;
import oracle.sdovis.LoadThemeData2;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapCacheTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.NetworkTheme;
import oracle.sdovis.NsDpHandler;
import oracle.sdovis.PredefinedGeometryTheme;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.ShadedReliefTheme;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.ThemeCache;
import oracle.sdovis.ThemeList;
import oracle.sdovis.TopologyTheme;
import oracle.sdovis.VisContext;
import oracle.sdovis.WFSTheme;
import oracle.sdovis.WMSMapTheme;
import oracle.sdovis.WMTSTheme;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.AnnotationTextThemeDefinition;
import oracle.sdovis.theme.CustomGeomThemeDefinition;
import oracle.sdovis.theme.DynGeomThemeDefinition;
import oracle.sdovis.theme.GeoRasterThemeDefinition;
import oracle.sdovis.theme.ImageThemeDefinition;
import oracle.sdovis.theme.LRSThemeDefinition;
import oracle.sdovis.theme.MapCacheThemeProducer;
import oracle.sdovis.theme.NetworkThemeDefinition;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.ShadedReliefThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.theme.TopologyThemeDefinition;
import oracle.sdovis.theme.WFSThemeDefinition;
import oracle.sdovis.theme.WMSMapThemeDefinition;
import oracle.sdovis.theme.WMTSThemeDefinition;
import oracle.sdovis.theme.WMTSThemeProducer;
import oracle.sdovis.util.Util;

public class DBMapMaker
extends MapMaker {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static PhaseEvent loadSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.MAPMAKER, "DBMapMaker", "Map Loading", "Time spent on loading");
    private static PhaseEvent renderSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.MAPMAKER, "DBMapMaker", "Map Rendering", "Time spent on rendering");
    String mCacheSubRegion = null;
    Vector mBaseMaps = new Vector();

    public DBMapMaker(String dataSrc) throws SQLException {
        this(dataSrc, "USER_SDO_MAPS", "USER_SDO_THEMES", "ALL_SDO_STYLES");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBMapMaker(String dataSrc, String mapTable, String themeTable, String styleTable) throws SQLException {
        this.vc.setMasterDataSourceName(dataSrc);
        Connection conn = null;
        try {
            CacheMgr2.init();
            DataSourceI dsi = DSManager.get(dataSrc);
            if (dsi instanceof DBDataSource) {
                conn = DSUtil.getDBConnection(dataSrc, this.vc);
                this.mCacheSubRegion = CacheMgr2.createSubRegion(conn);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    log.warning(e.getMessage());
                }
            }
        }
    }

    public String getCacheSubRegionName() {
        return this.mCacheSubRegion;
    }

    @Override
    public void destroy() {
        this.clear();
    }

    public void addPredefinedMap(String mapName) throws SQLException {
        BasemapCache mc = null;
        DataSourceI ads = DSManager.get(this.vc.getMasterDataSourceName());
        mc = ads.getBasemapCache();
        BaseMap map = mc.getOrLoadBasemap(mapName);
        if (map != null) {
            map.addMapToMapMaker(this);
            for (int i = 0; i < this.mBaseMaps.size(); ++i) {
                BaseMap map1 = (BaseMap)this.mBaseMaps.get(i);
                if (!map1.getName().equalsIgnoreCase(map.getName())) continue;
                return;
            }
            this.mBaseMaps.add(map);
        }
    }

    public Theme addPredefinedTheme(String name, int pos, double minScale, double maxScale) throws SQLException {
        return this.addPredefinedTheme(name, this.vc.getMasterDataSourceName(), pos, minScale, maxScale, false, -1.0, false, false, true);
    }

    public Theme addPredefinedTheme(String name, int pos, double minScale, double maxScale, boolean snapToTileScale, String tileResizingOption, int currentThreads) throws SQLException {
        return this.addPredefinedTheme(name, this.vc.getMasterDataSourceName(), pos, minScale, maxScale, false, -1.0, false, false, true, snapToTileScale, tileResizingOption, currentThreads);
    }

    public Theme addPredefinedTheme(String name, int pos, double minScale, double maxScale, boolean forcedLabeling, double minDistBetweenPoints, boolean fixedSVGLabel, boolean fastUnpickle, boolean reorientLines, boolean snapToTileScale, String tileResizingOption, int currentThreads) throws SQLException {
        return this.addPredefinedTheme(name, this.vc.getMasterDataSourceName(), pos, minScale, maxScale, forcedLabeling, minDistBetweenPoints, fixedSVGLabel, fastUnpickle, reorientLines, snapToTileScale, tileResizingOption, currentThreads);
    }

    public Theme addPredefinedTheme(String themeName, String dataSrc, int pos, double minScale, double maxScale, boolean forcedLabeling, double minDistBetweenPoints, boolean fixedSVGLabel, boolean fastUnpickle, boolean reorientLines) throws SQLException {
        return this.addPredefinedTheme(themeName, dataSrc, pos, minScale, maxScale, forcedLabeling, minDistBetweenPoints, fixedSVGLabel, fastUnpickle, reorientLines, null);
    }

    public Theme addPredefinedTheme(String themeName, String dataSrc, int pos, double minScale, double maxScale, boolean forcedLabeling, double minDistBetweenPoints, boolean fixedSVGLabel, boolean fastUnpickle, boolean reorientLines, boolean snapToTileScale, String tileResizingOption, int currentThreads) throws SQLException {
        return this.addPredefinedTheme(themeName, dataSrc, pos, minScale, maxScale, forcedLabeling, minDistBetweenPoints, fixedSVGLabel, fastUnpickle, reorientLines, null, snapToTileScale, tileResizingOption, currentThreads);
    }

    public Theme addPredefinedTheme(String themeName, String dataSrc, int pos, double minScale, double maxScale, boolean forcedLabeling, double minDistBetweenPoints, boolean fixedSVGLabel, boolean fastUnpickle, boolean reorientLines, Object[] bindingParameters) throws SQLException {
        return this.addPredefinedTheme(themeName, dataSrc, pos, minScale, maxScale, forcedLabeling, minDistBetweenPoints, fixedSVGLabel, fastUnpickle, reorientLines, bindingParameters, null);
    }

    public Theme addPredefinedTheme(String themeName, String dataSrc, int pos, double minScale, double maxScale, boolean forcedLabeling, double minDistBetweenPoints, boolean fixedSVGLabel, boolean fastUnpickle, boolean reorientLines, Object[] bindingParameters, boolean snapToTileScale, String tileResizingOption, int currentThreads) throws SQLException {
        return this.addPredefinedTheme(themeName, dataSrc, pos, minScale, maxScale, forcedLabeling, minDistBetweenPoints, fixedSVGLabel, fastUnpickle, reorientLines, bindingParameters, null, snapToTileScale, tileResizingOption, currentThreads);
    }

    public Theme addPredefinedTheme(String themeName, String dataSrc, int pos, double minScale, double maxScale, boolean forcedLabeling, double minDistBetweenPoints, boolean fixedSVGLabel, boolean fastUnpickle, boolean reorientLines, Object[] bindingParameters, String templateTheme) throws SQLException {
        ThemeDecorator mods = new ThemeDecorator();
        mods.setLabelAlwaysOn(forcedLabeling);
        mods.setMinScale(minScale);
        mods.setMaxScale(maxScale);
        mods.setMinDistBetweenPoints(minDistBetweenPoints);
        mods.setFixedSVGLabel(fixedSVGLabel);
        mods.setFastUnpickle(fastUnpickle);
        mods.setReorientLines(reorientLines);
        return this.addPredefinedTheme(themeName, dataSrc, pos, mods, bindingParameters, templateTheme);
    }

    public Theme addPredefinedTheme(String themeName, String dataSrc, int pos, double minScale, double maxScale, boolean forcedLabeling, double minDistBetweenPoints, boolean fixedSVGLabel, boolean fastUnpickle, boolean reorientLines, Object[] bindingParameters, String templateTheme, boolean snapToTileScale, String tileResizingOption, int currentThreads) throws SQLException {
        ThemeDecorator mods = new ThemeDecorator();
        mods.setLabelAlwaysOn(forcedLabeling);
        mods.setMinScale(minScale);
        mods.setMaxScale(maxScale);
        mods.setMinDistBetweenPoints(minDistBetweenPoints);
        mods.setFixedSVGLabel(fixedSVGLabel);
        mods.setFastUnpickle(fastUnpickle);
        mods.setReorientLines(reorientLines);
        mods.setSnapToTileScale(snapToTileScale);
        mods.setTileResizingOption(tileResizingOption);
        mods.setCurrentThreads(currentThreads);
        return this.addPredefinedTheme(themeName, dataSrc, pos, mods, bindingParameters, templateTheme);
    }

    public Theme addPredefinedTheme(String themeName, String dataSrc, int pos, ThemeDecorator mods, Object[] bindingParameters, String templateTheme) throws SQLException {
        themeName = themeName.toUpperCase();
        if (templateTheme != null) {
            log.finest("using template theme [name=" + templateTheme + "]");
        }
        Theme theme = null;
        ThemeDefinition themeDef = null;
        ThemeCache tCache = null;
        DataSourceI ds = DSManager.get(dataSrc);
        tCache = ds.getThemeCache();
        themeDef = templateTheme == null ? tCache.getOrLoadThemeDefinition(themeName) : tCache.getOrLoadThemeDefinition(templateTheme);
        if (themeDef == null) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01002") + " [" + themeName + "]");
            return null;
        }
        String tt = themeDef.getThemeType();
        if ("GEOM_PREDEFINED".equals(tt)) {
            PredGeomThemeDefinition pdef = (PredGeomThemeDefinition)themeDef;
            theme = new PredefinedGeometryTheme(themeName, pdef, bindingParameters);
        } else if ("GEOM_DYNAMIC".equals(tt)) {
            theme = new DynamicGeometryTheme((DynGeomThemeDefinition)themeDef, bindingParameters);
        } else if ("GEORASTER".equals(tt)) {
            theme = new GeoRasterTheme((GeoRasterThemeDefinition)themeDef, bindingParameters);
        } else if ("SHADED_RELIEF".equals(tt)) {
            theme = new ShadedReliefTheme((ShadedReliefThemeDefinition)themeDef, bindingParameters);
        } else if ("IMAGE".equals(tt)) {
            theme = new ImageTheme((ImageThemeDefinition)themeDef);
        } else if ("NETWORK".equals(tt)) {
            theme = new NetworkTheme((NetworkThemeDefinition)themeDef);
        } else if ("SHADED_RELIEF".equals(tt)) {
            theme = new ShadedReliefTheme((ShadedReliefThemeDefinition)themeDef);
        } else if ("TOPOLOGY".equals(tt)) {
            theme = new TopologyTheme((TopologyThemeDefinition)themeDef);
        } else if ("WFS".equals(tt)) {
            theme = new WFSTheme((WFSThemeDefinition)themeDef);
        } else if ("GEOM_CUSTOM".equals(tt)) {
            theme = new CustomGeomTheme((CustomGeomThemeDefinition)themeDef, bindingParameters);
        } else if ("ANNOTATION".equals(tt)) {
            theme = new AnnotationTextTheme((AnnotationTextThemeDefinition)themeDef, bindingParameters);
        } else if ("WMS".equals(tt)) {
            theme = new WMSMapTheme((WMSMapThemeDefinition)themeDef);
        } else if ("WMTS".equals(tt)) {
            theme = new WMTSTheme((WMTSThemeDefinition)themeDef);
        } else if ("LRS".equals(tt)) {
            theme = new LRSTheme((LRSThemeDefinition)themeDef, bindingParameters);
        } else {
            log.severe("Invalid theme definition type returned.");
            return null;
        }
        theme.setDecorator(mods);
        this.vc.getThemeList().addTheme(theme, pos);
        return theme;
    }

    public Theme addPredefinedTheme(String name, int pos) throws SQLException {
        return this.addPredefinedTheme(name, this.vc.getMasterDataSourceName(), pos, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, false, -1.0, false, false, true, false, "unbiased", 8);
    }

    public Theme addPredefinedTheme(String name) throws SQLException {
        return this.addPredefinedTheme(name, this.vc.getMasterDataSourceName(), this.vc.getThemeList().size(), Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, false, -1.0, false, false, true, false, "unbiased", 8);
    }

    public Theme addPredefinedTheme(String name, boolean snapToTileScale) throws SQLException {
        return this.addPredefinedTheme(name, this.vc.getMasterDataSourceName(), this.vc.getThemeList().size(), Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, false, -1.0, false, false, true, snapToTileScale, "unbiased", 8);
    }

    public Theme addPredefinedTheme(String name, boolean snapToTileScale, String tileResizingOption) throws SQLException {
        return this.addPredefinedTheme(name, this.vc.getMasterDataSourceName(), this.vc.getThemeList().size(), Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, false, -1.0, false, false, true, snapToTileScale, tileResizingOption, 8);
    }

    public Theme addPredefinedTheme(String name, boolean snapToTileScale, String tileResizingOption, int currentThreads) throws SQLException {
        return this.addPredefinedTheme(name, this.vc.getMasterDataSourceName(), this.vc.getThemeList().size(), Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, false, -1.0, false, false, true, snapToTileScale, tileResizingOption, currentThreads);
    }

    public Theme addPredefinedTheme(String name, String dataSrc) throws SQLException {
        return this.addPredefinedTheme(name, dataSrc, this.vc.getThemeList().size(), Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, false, -1.0, false, false, true, false, "unbiased", 8);
    }

    public Theme addPredefinedTheme(String name, double minScale, double maxScale) throws SQLException {
        return this.addPredefinedTheme(name, this.vc.getMasterDataSourceName(), this.vc.getThemeList().size(), minScale, maxScale, false, -1.0, false, false, true, false, "unbiased", 8);
    }

    public Theme addPredefinedTheme(String name, double minScale, double maxScale, boolean fastUnpickle, boolean reorientLines) throws SQLException {
        return this.addPredefinedTheme(name, this.vc.getMasterDataSourceName(), this.vc.getThemeList().size(), minScale, maxScale, false, -1.0, false, fastUnpickle, reorientLines, false, "unbiased", 8);
    }

    public Theme addPredefinedTheme(String name, double minScale, double maxScale, boolean forcedLabeling) throws SQLException {
        return this.addPredefinedTheme(name, this.vc.getMasterDataSourceName(), this.vc.getThemeList().size(), minScale, maxScale, forcedLabeling, -1.0, false, false, true, false, "unbiased", 8);
    }

    public Theme addJDBCTheme(String name, String dataSrc, String query, String spatialColumn, String srid, String renderStyle, String labelColumn, String labelStyle, boolean passThrough, int pos, String[] hiddenInfoColumns, String[] hiddenInfoNames, double minDistBetweenPoints, boolean forcedLabeling, boolean fixedSVGLabel) {
        name = name.toUpperCase();
        int srid_ = 0;
        try {
            srid_ = Integer.parseInt(srid);
        }
        catch (Exception e) {
            // empty catch block
        }
        DynGeomThemeDefinition td = new DynGeomThemeDefinition(name, dataSrc, query, spatialColumn, srid_);
        td.setFeatureStyleName(renderStyle);
        td.setLabelColumn(labelColumn);
        td.setLabelStyleName(labelStyle);
        if (hiddenInfoColumns != null && hiddenInfoColumns.length > 0) {
            Field[] attrs = new Field[hiddenInfoColumns.length];
            for (int i = 0; i < attrs.length; ++i) {
                Field attr = new Field("").setName(hiddenInfoColumns[i]);
                attr.setDisplayName(hiddenInfoNames[i]);
                attrs[i] = attr;
            }
            td.setIdentifiableColumns(attrs);
        }
        td.setPassthrough(passThrough);
        DynamicGeometryTheme theme = new DynamicGeometryTheme(td, null);
        theme.getDecorator().setLabelAlwaysOn(forcedLabeling);
        theme.getDecorator().setMinDistBetweenPoints(minDistBetweenPoints);
        theme.getDecorator().setFixedSVGLabel(fixedSVGLabel);
        this.addTheme(theme, pos);
        return theme;
    }

    public Theme addJDBCTheme(String name, String dataSrc, String query, String spatialColumn, String srid, String renderStyle, String labelColumn, String labelStyle, int pos, String[] hiddenInfoColumns, String[] hiddenInfoNames, double minDistBetweenPoints, boolean forcedLabeling) {
        return this.addJDBCTheme(name, dataSrc, query, spatialColumn, srid, renderStyle, labelColumn, labelStyle, false, pos, hiddenInfoColumns, hiddenInfoNames, minDistBetweenPoints, forcedLabeling, false);
    }

    public Theme addJDBCTheme(String name, String dataSrc, String query, String spatialColumn, String srid, String renderStyle, String labelColumn, String labelStyle, int pos) {
        return this.addJDBCTheme(name, dataSrc, query, spatialColumn, srid, renderStyle, labelColumn, labelStyle, pos, null, null, 1.0, false);
    }

    public Theme addJDBCTheme(String name, String dataSrc, String query, String spatialColumn, String srid, String renderStyle, String labelColumn, String labelStyle, boolean passThrough, int pos) {
        return this.addJDBCTheme(name, dataSrc, query, spatialColumn, srid, renderStyle, labelColumn, labelStyle, passThrough, pos, null, null, 1.0, false, false);
    }

    public Theme addJDBCTheme(String name, String dataSrc, String query, String spatialColumn, String srid, String renderStyle, String labelColumn, String labelStyle) {
        return this.addJDBCTheme(name, dataSrc, query, spatialColumn, srid, renderStyle, labelColumn, labelStyle, this.vc.getThemeList().size());
    }

    public Theme addJDBCTheme(String name, String dataSrc, String query, String spatialColumn, String srid, String renderStyle, String labelColumn, String labelStyle, boolean passThrough) {
        return this.addJDBCTheme(name, dataSrc, query, spatialColumn, srid, renderStyle, labelColumn, labelStyle, passThrough, this.vc.getThemeList().size());
    }

    public Theme addJDBCTheme(String name, String dataSrc, String query, String spatialColumn, String srid, String renderStyle, String labelColumn, String labelStyle, String[] hiddenInfoColumns, String[] hiddenInfoNames, double minDistBetweenPoints, boolean forcedLabeling) {
        return this.addJDBCTheme(name, dataSrc, query, spatialColumn, srid, renderStyle, labelColumn, labelStyle, this.vc.getThemeList().size(), hiddenInfoColumns, hiddenInfoNames, minDistBetweenPoints, forcedLabeling);
    }

    public Theme addJDBCTheme(String name, String dataSrc, String query, String spatialColumn, String srid, String renderStyle, String labelColumn, String labelStyle, boolean passThrough, String[] hiddenInfoColumns, String[] hiddenInfoNames, double minDistBetweenPoints) {
        return this.addJDBCTheme(name, dataSrc, query, spatialColumn, srid, renderStyle, labelColumn, labelStyle, passThrough, this.vc.getThemeList().size(), hiddenInfoColumns, hiddenInfoNames, minDistBetweenPoints, false, false);
    }

    public void addJDBCTopologyTheme(String name, String dataSource, String query, String topologyName, String featureTable, String srid, String spatialColumn, String renderStyle, String labelColumn, String labelStyle, boolean passThrough, int pos, String[] hiddenInfoColumns, String[] hiddenInfoNames, double minDistBetweenPoints, boolean forcedLabeling) {
        name = name.toUpperCase();
        TopologyThemeDefinition ttd = null;
        ttd = new TopologyThemeDefinition(name, dataSource, query, srid, topologyName, featureTable, spatialColumn, renderStyle, labelColumn, labelStyle, passThrough);
        ttd.setMinDistBetweenNodes(minDistBetweenPoints);
        ttd.setASIS(passThrough);
        if (hiddenInfoColumns != null && hiddenInfoColumns.length > 0) {
            Field[] attrs = new Field[hiddenInfoColumns.length];
            for (int i = 0; i < attrs.length; ++i) {
                Field attr = new Field("").setName(hiddenInfoColumns[i]);
                attr.setDisplayName(hiddenInfoNames[i]);
                attrs[i] = attr;
            }
            ttd.setIdentifiableColumns(attrs);
        }
        TopologyTheme theme = new TopologyTheme(ttd);
        theme.getDecorator().setLabelAlwaysOn(forcedLabeling);
        theme.getDecorator().setMinDistBetweenPoints(minDistBetweenPoints);
        this.addTheme(theme, pos);
    }

    public void addJDBCTopologyDebugTheme(String name, String dataSource, String topoName, String featureTable, String srid, String edgeStyleName, String edgeMarkerStyleName, int edgeMarkerSize, String edgeLabelStyleName, String nodeStyleName, String nodeLabelStyleName, String faceStyleName, String faceLabelStyleName, boolean passThrough, int pos) {
        name = name.toUpperCase();
        TopologyThemeDefinition ttd = null;
        ttd = new TopologyThemeDefinition(name, dataSource, srid, topoName, featureTable, edgeStyleName, edgeMarkerStyleName, edgeMarkerSize, edgeLabelStyleName, nodeStyleName, nodeLabelStyleName, faceStyleName, faceLabelStyleName, passThrough);
        ttd.setASIS(passThrough);
        TopologyTheme theme = new TopologyTheme(ttd);
        theme.getDecorator().setLabelAlwaysOn(true);
        this.addTheme(theme, pos);
    }

    public void addJDBCAnnotationTheme(String name, String dataSource, String query, String annotationTable, String annotationColumn, int srid, boolean passThrough) {
        this.addJDBCAnnotationTheme(name, dataSource, query, annotationTable, annotationColumn, srid, passThrough, this.vc.getThemeList().size());
    }

    public void addJDBCAnnotationTheme(String name, String dataSource, String query, String annotationTable, String annotationColumn, int srid, boolean passThrough, int pos) {
        name = name.toUpperCase();
        AnnotationTextThemeDefinition atd = new AnnotationTextThemeDefinition(name, dataSource, query, annotationTable, annotationColumn, srid, passThrough);
        AnnotationTextTheme theme = new AnnotationTextTheme(atd);
        this.addTheme(theme, pos);
    }

    public void addJDBCAnnotationTheme(String name, String dataSource, String query, String annotationTable, String annotationColumn, String exprtextColumn, int srid, boolean passThrough) {
        this.addJDBCAnnotationTheme(name, dataSource, query, annotationTable, annotationColumn, exprtextColumn, srid, passThrough, this.vc.getThemeList().size());
    }

    public void addJDBCAnnotationTheme(String name, String dataSource, String query, String annotationTable, String annotationColumn, String exprtextColumn, int srid, boolean passThrough, int pos) {
        name = name.toUpperCase();
        AnnotationTextThemeDefinition atd = new AnnotationTextThemeDefinition(name, dataSource, query, annotationTable, annotationColumn, exprtextColumn, srid, passThrough);
        AnnotationTextTheme theme = new AnnotationTextTheme(atd);
        this.addTheme(theme, pos);
    }

    public Style loadStyleFromDB(String name) {
        return this.loadStyleFromDB(name, this.vc.getMasterDataSourceName());
    }

    public Style loadStyleFromDB(String name, String dataSrc) {
        if (name == null || name.length() == 0) {
            return null;
        }
        try {
            DBDataSource ds = (DBDataSource)DSManager.get(dataSrc);
            StyleCache cache = ds.getStyleCache();
            return cache.get(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void loadStylesFromDB(StylingRule[] srules) {
        if (srules == null) {
            return;
        }
        for (int i = 0; i < srules.length; ++i) {
            StylingRule rule = srules[i];
            String name = rule.getFeatureStyleName();
            this.loadStyleFromDB(name);
            if (!rule.getLabeled()) continue;
            name = rule.getLabelStyleName();
            this.loadStyleFromDB(name);
        }
    }

    public void loadStylesFromDB(Theme t) {
        if (t == null) {
            return;
        }
        for (int i = 0; i < t.size(); ++i) {
            StyledFeatureI sf = t.getStyledFeature(i);
            this.loadStyleFromDB(sf.getFeatureStyleName());
            this.loadStyleFromDB(sf.getLabelStyleName());
        }
    }

    public void renderMap(MapBounds bounds, Graphics2D g2) throws DataException {
        MapBounds b = this.transformBounds(bounds);
        this.vc.setQueryWindowSrid(b.getSrid());
        switch (b.getType()) {
            case 3: {
                this.vc.setBoundingThemes(b.getBoundingThemes(), b.getBoundingThemeBorderMargin(), b.isBoundingThemeKeepAspectRatio());
                this.vc.setBoundingThemesSizeHint(b.getBoundingThemeSizeHint());
                this.renderMap(g2);
                return;
            }
            case 2: {
                double[] cs = b.getCenterSize();
                this.renderMap(cs[0], cs[1], cs[2], g2);
                return;
            }
            case 1: {
                double[] mbr = b.getRect();
                if (b.isKeepBoxAspectRatio()) {
                    Rectangle2D rect = new Rectangle2D.Double(mbr[0], mbr[1], mbr[2] - mbr[0], mbr[3] - mbr[1]);
                    rect = this.getMBRWithAspectRatio(this.vc, rect);
                    mbr[0] = rect.getMinX();
                    mbr[1] = rect.getMinY();
                    mbr[2] = rect.getMaxX();
                    mbr[3] = rect.getMaxY();
                }
                this.renderMap(mbr[0], mbr[1], mbr[2], mbr[3], g2);
                return;
            }
            case 4: {
                double[] csc = b.getCenterSize();
                long scale = b.getScale();
                this.renderMapWithScale(csc[0], csc[1], scale, g2);
                return;
            }
        }
        this.renderMap(g2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareGetFeatureInfo(MapBounds bounds) {
        Theme t;
        this.vc.setQueryWindowSrid(bounds.getSrid());
        double[] mbr = bounds.getRect();
        this.vc.setBBox(true);
        SRS mSRS = this.vc.getSrs();
        if ((mSRS == null || mSRS.getSRID() < 1) && (t = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(t.getSRID());
        }
        mSRS = this.vc.getSrs();
        this.vc.setQueryWindow(mSRS.getOptimalQueryWindow(mbr[0], mbr[1], mbr[2], mbr[3], this.vc.getDeviceWindow(), this.vc));
        long t1 = System.currentTimeMillis();
        try {
            Rectangle2D mQueryWin = this.vc.getQueryWindow();
            Rectangle2D mDeviceWin = this.vc.getDeviceWindow();
            if (mQueryWin.getMinX() == Double.NEGATIVE_INFINITY || mQueryWin.getMinY() == Double.NEGATIVE_INFINITY || mQueryWin.getMaxX() == Double.POSITIVE_INFINITY || mQueryWin.getMaxY() == Double.POSITIVE_INFINITY) {
                this.clearRotation();
            }
            this.vc.setInterrupted(false);
            this.vc.setScale(mQueryWin, mDeviceWin);
            this.beginHandlingNSProviders(this.vc, null);
            try {
                if (!this.vc.getNoQuery()) {
                    this.prepareThemes(this.vc);
                }
            }
            finally {
                this.vc.setNoQuery(false);
            }
        }
        catch (Exception e) {
            log.warning("Error in getting retrieving features.");
        }
        long t2 = System.currentTimeMillis();
        log.info(" **** time spent on loading features: " + (t2 - t1) + "ms.");
    }

    private JSDOGeometry createGeomRect(MapBounds bounds) {
        Theme t;
        double[] mbr = bounds.getRect();
        SRS mSRS = this.vc.getSrs();
        if ((mSRS == null || mSRS.getSRID() < 1) && (t = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(t.getSRID());
        }
        mSRS = this.vc.getSrs();
        int srid = mSRS.getSRID();
        boolean isGeodetic = mSRS.isGeodetic();
        int gtype = 2003;
        int[] elemInfo = new int[]{1, 1003, 3};
        double[] ordinates = new double[]{mbr[0], mbr[1], mbr[2], mbr[3]};
        return new JSDOGeometry(gtype, srid, elemInfo, ordinates);
    }

    public String getFeatureInfo(MapBounds bounds, String infoformat) throws DataException {
        MapBounds b = this.transformBounds(bounds);
        this.prepareGetFeatureInfo(b);
        JSDOGeometry geomRect = this.createGeomRect(bounds);
        String info = null;
        if (infoformat.equalsIgnoreCase("APPLICATION/JSON")) {
            info = Util.getFeatureInfoInJSON(this.vc, geomRect);
        } else if (infoformat.equalsIgnoreCase("TEXT/HTML")) {
            info = Util.getFeatureInfoInHTML(this.vc, geomRect);
        } else if (infoformat.equalsIgnoreCase("TEXT/XML")) {
            info = Util.getFeatureInfoInXML(this.vc, geomRect);
        } else {
            log.warning("WMTS getFeatureInfo format was not recognized;TEXT/XML is assigned.");
            info = Util.getFeatureInfoInXML(this.vc, geomRect);
        }
        return info;
    }

    public Image renderMap(MapBounds bounds) throws DataException {
        Graphics2D g2 = (Graphics2D)this.vc.getMapImage().getGraphics();
        this.renderMap(bounds, g2);
        g2.dispose();
        return this.vc.getMapImage();
    }

    private Rectangle2D getMBRWithAspectRatio(VisContext vc, Rectangle2D mbr) {
        if (mbr == null) {
            return null;
        }
        Rectangle2D.Double newMBR = new Rectangle2D.Double(mbr.getMinX(), mbr.getMinY(), mbr.getWidth(), mbr.getHeight());
        double xl = newMBR.getMinX();
        double yl = newMBR.getMinY();
        double xh = newMBR.getMaxX();
        double yh = newMBR.getMaxY();
        double h = Math.abs(yh - yl);
        double w = Math.abs(xh - xl);
        if (h == 0.0 || w == 0.0) {
            return newMBR;
        }
        double r2 = w / h;
        Rectangle2D deviceWin = vc.getDeviceWindow();
        double r1 = deviceWin.getWidth() / deviceWin.getHeight();
        if (r2 > r1) {
            h = w / r1;
        } else if (r2 < r1) {
            w = h * r1;
        }
        double cx = (xl + xh) / 2.0;
        double cy = (yl + yh) / 2.0;
        xl = cx - w / 2.0;
        yl = cy - h / 2.0;
        xh = cx + w / 2.0;
        yh = cy + h / 2.0;
        newMBR.add(xl, yl);
        newMBR.add(xh, yh);
        return newMBR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MapBounds transformBounds(MapBounds bounds) {
        Theme t;
        int bsrid = bounds.getSrid();
        int msrid = this.vc.getMasterSRID();
        if (msrid == 0 && this.vc.getThemeList() != null && (t = this.vc.getThemeList().getTheme(0)) != null) {
            msrid = t.getSRID();
        }
        if (bsrid == 0 || msrid == 0 || bsrid == msrid || bounds.getType() == 3) {
            return bounds;
        }
        Connection conn = this.getJDBCConnection();
        if (conn == null) {
            log.warning("error getting a database connection.");
            return bounds;
        }
        try {
            switch (bounds.getType()) {
                case 1: {
                    double[] mbr = bounds.getRect();
                    double[] result = Util.transform(conn, mbr[0], mbr[1], mbr[2], mbr[3], bsrid, msrid);
                    if (result != null) {
                        MapBounds mapBounds = new MapBounds(result[0], result[1], result[2], result[3], msrid, bounds.isKeepBoxAspectRatio());
                        return mapBounds;
                    }
                    throw new DataException("cannot transform rectangle.");
                }
                case 2: {
                    double[] cs = bounds.getCenterSize();
                    double[] result = Util.transform(conn, cs[0], cs[1], cs[2], bsrid, msrid);
                    if (result != null) {
                        MapBounds e = new MapBounds(result[0], result[1], result[2], msrid);
                        return e;
                    }
                }
                case 4: {
                    double[] csc = bounds.getCenterSize();
                    double[] result = Util.transform(conn, csc[0], csc[1], bsrid, msrid);
                    if (result != null) {
                        MapBounds mapBounds = new MapBounds(result[0], result[1], bounds.getScale(), msrid);
                        return mapBounds;
                    }
                    throw new DataException("cannot transform center point");
                }
            }
            MapBounds mapBounds = bounds;
            return mapBounds;
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            MapBounds mapBounds = bounds;
            return mapBounds;
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {
                log.severe(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Image renderEm(Graphics2D g2) throws DataException {
        long mLoadTime;
        long t2;
        long t1;
        long tokenL = 0L;
        long tokenR = 0L;
        try {
            tokenL = loadSensor.start();
            t1 = System.currentTimeMillis();
            Rectangle2D mQueryWin = this.vc.getQueryWindow();
            Rectangle2D mDeviceWin = this.vc.getDeviceWindow();
            if (mQueryWin.getMinX() == Double.NEGATIVE_INFINITY || mQueryWin.getMinY() == Double.NEGATIVE_INFINITY || mQueryWin.getMaxX() == Double.POSITIVE_INFINITY || mQueryWin.getMaxY() == Double.POSITIVE_INFINITY) {
                this.clearRotation();
            }
            this.vc.setInterrupted(false);
            this.vc.setScale(mQueryWin, mDeviceWin);
            if (!(this.vc.getBoundingThemes() == null || mQueryWin.getMinX() != Double.NEGATIVE_INFINITY && mQueryWin.getMinY() != Double.NEGATIVE_INFINITY && mQueryWin.getMaxX() != Double.POSITIVE_INFINITY && mQueryWin.getMaxY() != Double.POSITIVE_INFINITY || this.vc.getNoQuery())) {
                if (this.prepareBoundingThemes(this.vc) == null) {
                    log.info(RSBundle.getMsg("MAPVIEWER-01004"));
                    throw new DataException(RSBundle.getMsg("MAPVIEWER-01004"));
                }
                mQueryWin = this.vc.getQueryWindow();
            }
            if (mQueryWin.getMinX() != Double.NEGATIVE_INFINITY && mQueryWin.getMinY() != Double.NEGATIVE_INFINITY && mQueryWin.getMaxX() != Double.POSITIVE_INFINITY && mQueryWin.getMaxY() != Double.POSITIVE_INFINITY && this.vc.shouldUseCachedBaseMap()) {
                this.processCachedBaseMap();
            }
            if (mQueryWin.getMinX() != Double.NEGATIVE_INFINITY && mQueryWin.getMinY() != Double.NEGATIVE_INFINITY && mQueryWin.getMaxX() != Double.POSITIVE_INFINITY && mQueryWin.getMaxY() != Double.POSITIVE_INFINITY && this.vc.getBgImage() == null && this.vc.mapCacheThemeExists()) {
                this.adjustQueryWindowForMapCacheTheme();
            }
            if (mQueryWin.getMinX() != Double.NEGATIVE_INFINITY && mQueryWin.getMinY() != Double.NEGATIVE_INFINITY && mQueryWin.getMaxX() != Double.POSITIVE_INFINITY && mQueryWin.getMaxY() != Double.POSITIVE_INFINITY && this.vc.getBgImage() == null && this.vc.mapWMTSThemeExists()) {
                try {
                    this.adjustQueryWindowForWMTSTheme();
                }
                catch (Exception e) {
                    throw new DataException("Failed in adjust query window for WMTS theme.");
                }
            }
            this.beginHandlingNSProviders(this.vc, null);
            try {
                if (!this.vc.getNoQuery()) {
                    this.prepareThemes(this.vc);
                }
            }
            finally {
                this.vc.setNoQuery(false);
            }
            if (mQueryWin.getMinX() == Double.NEGATIVE_INFINITY || mQueryWin.getMinY() == Double.NEGATIVE_INFINITY || mQueryWin.getMaxX() == Double.POSITIVE_INFINITY || mQueryWin.getMaxY() == Double.POSITIVE_INFINITY) {
                mQueryWin = this.buildDataMBR();
                if (mQueryWin == null) {
                    throw new DataException(RSBundle.getMsg("MAPVIEWER-01005"));
                }
                this.vc.setQueryWindow(mQueryWin);
                this.vc.setScale(mQueryWin, mDeviceWin);
            }
            this.endHandlingNSProviders(this.vc, null);
            t2 = System.currentTimeMillis();
            mLoadTime = t2 - t1;
        }
        finally {
            loadSensor.stop(tokenL);
        }
        log.info(" **** time spent on loading features: " + mLoadTime + "ms.");
        t1 = System.currentTimeMillis();
        try {
            tokenR = renderSensor.start();
            this.mRenderEng.render(g2, this.vc);
        }
        finally {
            renderSensor.stop(tokenR);
        }
        t2 = System.currentTimeMillis();
        long mRenderTime = t2 - t1;
        log.info(" **** time spent on rendering: " + mRenderTime + "ms");
        this.vc.setLastRotation(this.vc.getRotation());
        return this.vc.getMapImage();
    }

    private void adjustQueryWindowForMapCacheTheme() throws DataException {
        ThemeList list = this.vc.getThemeList();
        boolean windowAdjusted = false;
        for (int i = 0; i < list.size(); ++i) {
            Theme theme = list.getTheme(i);
            if (!(theme instanceof MapCacheTheme)) continue;
            MapCacheTheme cacheTheme = (MapCacheTheme)theme;
            Rectangle2D window = null;
            if (cacheTheme.getExternalMapViewerURL() == null) {
                window = cacheTheme.getCacheInstance().getMapBoundingBox(this.vc.getQueryWindow(), (int)this.vc.getDeviceWindow().getWidth(), (int)this.vc.getDeviceWindow().getHeight(), false, ((MapCacheTheme)theme).getTileResizingOption());
            } else {
                MapCacheThemeProducer producer = (MapCacheThemeProducer)theme.getProducer();
                producer.prepareData(this.vc.getQueryWindow(), this.vc);
                window = producer.getMapWindow();
            }
            cacheTheme.setMapWindow(window);
            if (!windowAdjusted && cacheTheme.snapToCachedScale()) {
                this.vc.setQueryWindow(window);
            }
            for (int j = i + 1; j < list.size(); ++j) {
                Theme th = list.getTheme(j);
                if (!(th instanceof MapCacheTheme)) continue;
                ((MapCacheTheme)th).setMapWindow(window);
            }
            return;
        }
    }

    private void processCachedBaseMap() {
        this.vc.setMapCacheInstance(this);
        MapCache cache = this.vc.getMapCache();
        if (cache == null) {
            return;
        }
        Rectangle2D mapWindow = cache.getMapBoundingBox(this.vc.getQueryWindow(), (int)this.vc.getDeviceWindow().getWidth(), (int)this.vc.getDeviceWindow().getHeight(), !this.vc.snapToCachedScale(), "unbiased");
        Image cachedImage = null;
        if (mapWindow != null) {
            try {
                cachedImage = cache.getMap(mapWindow, (int)this.vc.getDeviceWindow().getWidth(), (int)this.vc.getDeviceWindow().getHeight(), "unbiased");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to generated cached base map!", e);
            }
        }
        if (cachedImage != null) {
            this.vc.setQueryWindow(mapWindow);
            this.vc.removeBaseMapThemes();
            this.vc.setBgImage(cachedImage);
        }
    }

    public void beginHandlingNSProviders(VisContext vc, String thisThemeOnly) throws DataException {
        NsDpHandler nsdh;
        int i;
        Vector v = vc.getNsDpHandlers();
        if (v == null || v.size() == 0) {
            return;
        }
        for (i = 0; i < v.size(); ++i) {
            nsdh = (NsDpHandler)v.get(i);
            if (thisThemeOnly != null && !nsdh.getDef().getTheme().equalsIgnoreCase(thisThemeOnly)) continue;
            nsdh.startThread();
        }
        try {
            for (i = 0; i < v.size(); ++i) {
                boolean res;
                nsdh = (NsDpHandler)v.get(i);
                if ((thisThemeOnly == null || nsdh.getDef().getTheme().equalsIgnoreCase(thisThemeOnly)) && (res = nsdh.waitForThread())) continue;
            }
        }
        catch (Exception e) {
            throw new DataException("Error processing NS data provider(s).", e);
        }
    }

    public void endHandlingNSProviders(VisContext vc, String thisThemeOnly) throws DataException {
        Vector v = vc.getNsDpHandlers();
        if (v == null || v.size() == 0) {
            return;
        }
        try {
            for (int i = 0; i < v.size(); ++i) {
                NsDpHandler nsdh = (NsDpHandler)v.get(i);
                if (thisThemeOnly != null && !nsdh.getDef().getTheme().equalsIgnoreCase(thisThemeOnly)) continue;
                nsdh.doDataJoin(vc);
            }
        }
        catch (Exception e) {
            throw new DataException("Error processing NS data provider(s).", e);
        }
    }

    public Connection getJDBCConnection() {
        try {
            return DSUtil.getDBConnection(this.vc.getMasterDataSourceName(), this.vc);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            return null;
        }
    }

    @Override
    public Style getStyleWithName(String name) {
        return DBMapMaker.getStyleWithName(name, this.vc.getMasterDataSourceName(), this.vc);
    }

    public void invalidateThemeDataCache(String themeName) {
        this.invalidateThemeDataCache(themeName, this.vc.getMasterDataSourceName());
    }

    private void invalidateThemeDataCache(ThemeDefinition td, ThemeCache tCache) {
        String cachename;
        Enumeration el;
        Exception e;
        String cacheSubRegion;
        String cacheGroup;
        String themeName = td.getName();
        if (td instanceof PredGeomThemeDefinition) {
            PredGeomThemeDefinition pt = (PredGeomThemeDefinition)td;
            cacheGroup = pt.getCacheGroupName();
            cacheSubRegion = pt.getCacheSubRegionName();
            e = null;
            try {
                CacheMgr2.invalidate(cacheSubRegion, cacheGroup);
                log.info("Invalidated theme " + themeName + "'s cached data: " + cacheGroup);
            }
            catch (Exception ex) {
                e = ex;
            }
            if (pt.getSRidCache().size() > 0) {
                el = pt.getSRidCache().elements();
                while (el.hasMoreElements()) {
                    try {
                        cachename = el.nextElement().toString();
                        CacheMgr2.invalidate(cacheSubRegion, cachename);
                        log.info("Invalidated theme " + themeName + "'s cached data: " + cachename);
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                }
                pt.getSRidCache().clear();
            }
            tCache.remove(themeName);
        }
        if (td instanceof NetworkThemeDefinition) {
            NetworkThemeDefinition nt = (NetworkThemeDefinition)td;
            cacheGroup = nt.getLinkCacheGroup();
            cacheSubRegion = nt.getCacheSubRegion();
            e = null;
            try {
                CacheMgr2.invalidate(cacheSubRegion, cacheGroup);
                log.info("Invalidated theme " + themeName + "'s cached data: " + cacheGroup);
            }
            catch (Exception ex) {
                e = ex;
            }
            if (nt.getLinkSRidCache().size() > 0) {
                el = nt.getLinkSRidCache().elements();
                while (el.hasMoreElements()) {
                    try {
                        cachename = el.nextElement().toString();
                        CacheMgr2.invalidate(cacheSubRegion, cachename);
                        log.info("Invalidated theme " + themeName + "'s cached data: " + cachename);
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                        return;
                    }
                }
                nt.getLinkSRidCache().clear();
            }
            cacheGroup = nt.getNodeCacheGroup();
            try {
                CacheMgr2.invalidate(cacheSubRegion, cacheGroup);
                log.info("Invalidated theme " + themeName + "'s cached data: " + cacheGroup);
            }
            catch (Exception ex) {
                e = ex;
            }
            if (nt.getNodeSRidCache().size() > 0) {
                el = nt.getNodeSRidCache().elements();
                while (el.hasMoreElements()) {
                    try {
                        cachename = el.nextElement().toString();
                        CacheMgr2.invalidate(cacheSubRegion, cachename);
                        log.info("Invalidated theme " + themeName + "'s cached data: " + cachename);
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                        return;
                    }
                }
                nt.getNodeSRidCache().clear();
            }
        }
        if (td instanceof TopologyThemeDefinition) {
            TopologyThemeDefinition tp = (TopologyThemeDefinition)td;
            cacheGroup = tp.getCacheEdgeGroup();
            cacheSubRegion = tp.getCacheSubRegion();
            e = null;
            try {
                CacheMgr2.invalidate(cacheSubRegion, cacheGroup);
                log.info("Invalidated theme " + themeName + "'s cached data: " + cacheGroup);
            }
            catch (Exception ex) {
                e = ex;
            }
            if (tp.getSRidEdgeCache().size() > 0) {
                el = tp.getSRidEdgeCache().elements();
                while (el.hasMoreElements()) {
                    try {
                        cachename = el.nextElement().toString();
                        CacheMgr2.invalidate(cacheSubRegion, cachename);
                        log.info("Invalidated theme " + themeName + "'s cached data: " + cachename);
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                }
                tp.getSRidEdgeCache().clear();
            }
            cacheGroup = tp.getCacheNodeGroup();
            try {
                CacheMgr2.invalidate(cacheSubRegion, cacheGroup);
                log.info("Invalidated theme " + themeName + "'s cached data: " + cacheGroup);
            }
            catch (Exception ex) {
                e = ex;
            }
            if (tp.getSRidNodeCache().size() > 0) {
                el = tp.getSRidNodeCache().elements();
                while (el.hasMoreElements()) {
                    try {
                        cachename = el.nextElement().toString();
                        CacheMgr2.invalidate(cacheSubRegion, cachename);
                        log.info("Invalidated theme " + themeName + "'s cached data: " + cachename);
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                }
                tp.getSRidNodeCache().clear();
            }
            tCache.remove(themeName);
        }
        if (td instanceof WFSThemeDefinition) {
            WFSThemeDefinition wfst = (WFSThemeDefinition)td;
            wfst.clearCapabilitiesFromCache();
        }
    }

    public void invalidateThemeDataCache(String themeName, String dataSrc) {
        ThemeDefinition td = null;
        ThemeCache tCache = null;
        try {
            DataSourceI ads = DSManager.get(dataSrc);
            tCache = ads.getThemeCache();
            td = tCache.getThemeDefinition(themeName);
            if (td == null) {
                return;
            }
        }
        catch (Exception ex) {
            log.warning(ex.getMessage());
            return;
        }
        this.invalidateThemeDataCache(td, tCache);
    }

    public void inavlidateAllThemeDataCaches(String dataSrc) {
        ThemeDefinition td = null;
        ThemeCache tCache = null;
        try {
            DataSourceI ads = DSManager.get(dataSrc);
            tCache = ads.getThemeCache();
            if (tCache == null) {
                return;
            }
            String[] names = tCache.getCachedThemeNames();
            for (int i = 0; i < names.length; ++i) {
                String tname = names[i];
                td = tCache.getThemeDefinition(tname);
                if (td == null) continue;
                this.invalidateThemeDataCache(td, tCache);
            }
        }
        catch (Exception ex) {
            log.warning(ex.getMessage());
            return;
        }
    }

    public void prepareThemes(VisContext vct) throws DataException {
        this.prepareThemes2(vct);
    }

    public void prepareThemes2(VisContext vct) throws DataException {
        vct.setDataException(null);
        for (int i = 0; i < vct.getThemeList().size(); ++i) {
            Theme t = vct.getThemeList().getTheme(i);
            if (t.getDecorator().isPrepared()) continue;
            if (this.isThemeToBePrepared(t, vct)) {
                Rectangle2D box = vct.getQueryWindow();
                LoadThemeData2 td = new LoadThemeData2(t, box, vct);
                td.run();
                if (!vct.shouldReportError()) continue;
                log.log(Level.SEVERE, "Aborting map rendering because of severe error!");
                throw vct.getDataException();
            }
            this.setEmptyFeatures(t);
        }
    }

    private boolean isThemeToBePrepared(Theme t, VisContext vct) {
        if (vct.getMasterSRID() > 0 && t.getDefinition().getSrid() > 0 && t.getDefinition().getSrid() != vct.getMasterSRID()) {
            return true;
        }
        Rectangle2D queryWin = vct.getQueryWindow();
        double xl = queryWin.getMinX();
        double yl = queryWin.getMinY();
        double xh = queryWin.getMaxX();
        double yh = queryWin.getMaxY();
        double masterScale = vct.getCurrentScale();
        if (Util.isFullExtent(xl, yl, xh, yh) || masterScale == Double.POSITIVE_INFINITY || masterScale == Double.NEGATIVE_INFINITY) {
            return true;
        }
        SRSCache sc = DSManager.getSRSCache(t.getDefinition().getDataSourceName());
        if (sc == null) {
            return true;
        }
        SRS srs = sc.get(t.getDefinition().getSrid());
        double factor = 1.0;
        double scale = masterScale * factor;
        if (t.getScaleType() == "RATIO") {
            if (srs == null) {
                log.severe("Theme must have SRS when using ratio scale mode. [" + t.getName() + "]");
                return false;
            }
            double centerx = (xl + xh) / 2.0;
            double centery = (yl + yh) / 2.0;
            if (vct.isTileRequest() && srs.isGeodetic()) {
                centerx = 0.0;
                centery = 0.0;
            }
            scale = Math.round(srs.getRatioScale(masterScale * factor, new Point2D.Double(centerx, centery)));
        }
        if (!t.withinRenderScaleLimits(scale)) {
            if (t.getScaleType() == "RATIO") {
                log.info("Scale range for theme " + t.getName() + " is out of map scale [Ratio scale= 1:" + Math.round(scale) + "].");
            } else {
                log.info("Scale range for theme " + t.getName() + " is out of map scale [Screen inch scale= " + scale + "].");
            }
            return false;
        }
        return true;
    }

    public void setEmptyFeatures(Theme t) {
        if (t == null) {
            return;
        }
        if (t instanceof GeoRasterTheme || t instanceof ImageTheme || t instanceof WMSMapTheme || t instanceof MapCacheTheme) {
            t.getProducer().destroy();
        } else if (!(t instanceof LocalTheme)) {
            t.getProducer().setStyledFeatures(new StyledFeatureI[0]);
        }
    }

    public Rectangle2D prepareBoundingThemes(VisContext vct) throws DataException {
        int i;
        log.finest("Preparing bounding themes...");
        String[] themes = vct.getBoundingThemes();
        for (i = 0; i < themes.length; ++i) {
            Theme t = vct.getThemeList().getLastMatchingTheme(themes[i]);
            if (t == null || t.getDecorator().isPrepared()) continue;
            LoadThemeData2 td = new LoadThemeData2(t, vct.getQueryWindow(), vct);
            td.run();
            if (!vct.shouldReportError()) continue;
            throw vct.getDataException();
        }
        for (i = 0; i < themes.length; ++i) {
            this.beginHandlingNSProviders(this.vc, themes[i]);
        }
        for (i = 0; i < themes.length; ++i) {
            this.endHandlingNSProviders(this.vc, themes[i]);
        }
        Rectangle2D mQueryWin = this.vc.getQueryWindow();
        Rectangle2D mDeviceWin = this.vc.getDeviceWindow();
        mQueryWin = vct.getBoundingThemesSizeHint() <= 0.0 ? this.buildDataMBR(themes, vct.getBorderMarginForBoundingThemes(), vct.boundingThemesRespectAspectRatio(), mDeviceWin) : this.buildDataMBR(themes, vct.getBoundingThemesSizeHint(), vct.getBorderMarginForBoundingThemes(), vct.boundingThemesRespectAspectRatio(), mDeviceWin);
        if (mQueryWin != null) {
            this.vc.setQueryWindow(mQueryWin);
            this.vc.setScale(mQueryWin, mDeviceWin);
        }
        return mQueryWin;
    }

    public void clear() {
        log.info("Clearing in-memory geometry and metadata caches.");
        try {
            CacheMgr2.invalidate(this.mCacheSubRegion);
        }
        catch (Exception ex) {
            log.warning(ex.getMessage());
        }
        ThemeList tl = this.vc.getThemeList();
        if (tl != null) {
            tl.clear();
        }
        ThemeCache tCache = null;
        BasemapCache mCache = null;
        DataSourceI ads = DSManager.get(this.vc.getMasterDataSourceName());
        if (ads != null) {
            tCache = ads.getThemeCache();
            if (tCache != null) {
                tCache.removeAll();
            }
            if ((mCache = ads.getBasemapCache()) != null) {
                mCache.removeAll();
            }
        }
    }

    public void clearOwnerTableSridCache() {
        Hashtable ht;
        log.info("clearing data source owner-table-srid cache");
        DataSourceI ds = DSManager.get(this.vc.getMasterDataSourceName());
        AbstractDBDataSource ads = (AbstractDBDataSource)DSManager.get(this.vc.getMasterDataSourceName());
        if (ads != null && (ht = ads.getOwnerTableSridCache()) != null) {
            ht.clear();
        }
    }

    public Vector getPredefinedMapList() {
        return this.mBaseMaps;
    }

    public void clearPredefinedMapList() {
        this.mBaseMaps.clear();
    }

    public BaseMap getPredefinedBaseMap(String mapname) {
        if (mapname == null) {
            return null;
        }
        for (int i = 0; i < this.mBaseMaps.size(); ++i) {
            BaseMap map = (BaseMap)this.mBaseMaps.get(i);
            if (!map.getName().equalsIgnoreCase(mapname)) continue;
            return map;
        }
        return null;
    }

    private void adjustQueryWindowForWMTSTheme() throws DataException, OMSException {
        ThemeList list = this.vc.getThemeList();
        for (int i = 0; i < list.size(); ++i) {
            Theme theme = list.getTheme(i);
            if (!(theme instanceof WMTSTheme)) continue;
            WMTSTheme wmtsTheme = (WMTSTheme)theme;
            Rectangle2D window = null;
            if (!wmtsTheme.getSnapToTileScale()) continue;
            WMTSThemeProducer producer = (WMTSThemeProducer)theme.getProducer();
            window = producer.calAdjustedQueryWindow(this.vc.getQueryWindow(), this.vc);
            this.vc.setQueryWindow(window);
            wmtsTheme.setTileResizingOption("unbiased");
            for (int j = i + 1; j < list.size(); ++j) {
                Theme th = list.getTheme(j);
                if (!(th instanceof WMTSTheme) || !wmtsTheme.getSnapToTileScale()) continue;
                wmtsTheme.setSnapToTileScale(false);
            }
            return;
        }
    }
}

