/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import oracle.mapviewer.share.util.LogFactory;

class CustomLogo {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private WeakReference logo;
    private String file;
    private String positionHint;
    public static final String NORTH = "NORTH";
    public static final String EAST = "EAST";
    public static final String SOUTH = "SOUTH";
    public static final String WEST = "WEST";
    public static final String NORTH_EAST = "NORTH_EAST";
    public static final String SOUTH_EAST = "SOUTH_EAST";
    public static final String SOUTH_WEST = "SOUTH_WEST";
    public static final String NORTH_WEST = "NORTH_WEST";
    public static final String CENTER = "CENTER";
    static String[] POSITIONS = new String[]{"NORTH", "EAST", "SOUTH", "WEST", "NORTH_EAST", "SOUTH_EAST", "SOUTH_WEST", "NORTH_WEST", "CENTER"};

    public CustomLogo(String file, String position) {
        if (file == null || file.length() == 0) {
            throw new IllegalArgumentException("no such logo image file.");
        }
        URL u = null;
        try {
            if (file.toUpperCase().startsWith("HTTP:")) {
                u = new URL(file);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("malformed logo image url.");
        }
        BufferedImage img = null;
        try {
            img = u != null ? ImageIO.read(u) : ImageIO.read(new File(file));
        }
        catch (IOException ex) {
            log.warning("Exception loading logo image: " + ex.getMessage());
        }
        if (img == null) {
            log.severe("cannot load logo image from " + file);
            throw new IllegalArgumentException("no such logo image file.");
        }
        this.positionHint = position == null || !this.validPosition(position) ? SOUTH_EAST : position;
        this.file = file;
        this.logo = new WeakReference<BufferedImage>(img);
    }

    private boolean validPosition(String pos) {
        for (int i = 0; i < POSITIONS.length; ++i) {
            if (!POSITIONS[i].equals(pos)) continue;
            return true;
        }
        return false;
    }

    public Image getLogo() {
        Image img = (Image)this.logo.get();
        if (img != null) {
            return img;
        }
        URL u = null;
        try {
            if (this.file.toUpperCase().startsWith("HTTP:")) {
                u = new URL(this.file);
            }
        }
        catch (MalformedURLException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        log.finest("reloading logo image...");
        try {
            img = u != null ? ImageIO.read(u) : ImageIO.read(new File(this.file));
        }
        catch (IOException ex) {
            log.warning("Exception loading logo image: " + ex.getMessage());
            img = null;
        }
        if (img != null) {
            this.logo = new WeakReference<Image>(img);
            return img;
        }
        log.severe("cannot load logo image from " + this.file);
        return null;
    }

    public String getPositionHint() {
        return this.positionHint;
    }
}

